<?php
class Modules extends CI_Controller {
	function Modules()
	{
		parent::__construct();
		$this->load->library('form_validation');
		$this->load->library('pagination');
	}
	function index($page=1)
	{
		$config['per_page']		= 5;
		$config['base_url'] 	= site_url('admin/modules/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('modules',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('modules',
		array(),
		$config['per_page'],
		$offset
		);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('templates/header');
		$this->load->view('admin/module/list',$data);
		$this->load->view('templates/footer');
	}
	function create()
	{
		$this->load->view('templates/header');
		$this->load->view('admin/module/create');
		$this->load->view('templates/footer');
	}
	function edit($id)
	{
		$where=array(
				'module_id' => $id
		);
		$records=$this->crud_model->get('modules',$where);
		if($records != false){
			//true section
			$data['module_name']			 = $records[0]['module_name'];
			$data['module_id']			 = $records[0]['module_id'];
			$data['module_uri']			 = $records[0]['module_uri'];
			$this->load->view('templates/header');
			$this->load->view('admin/module/edit',$data);
			$this->load->view('templates/footer');

		}
		else{
			//false section
			$this->session->set_flashdata('response','<div class="alert alert-error">error</div>');
			redirect('admin/modules');
		}

	}
	function do_insert()
	{
		$this->form_validation->set_rules('module_name', 'Module Name', 'required|max_length[50]');
		$this->form_validation->set_rules('module_uri', 'Module URI', 'required|max_length[50]');

		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->load->view('templates/header');
			$this->load->view('admin/module/create');
			$this->load->view('templates/footer');
		}
		else
		{	// true section

			$module_name=$this->input->post('module_name');
			$module_uri=$this->input->post('module_uri');

			$data=array('module_name' => $module_name,
					'module_uri' =>$module_uri


			);

			$rr=$this->crud_model->insert('modules',$data);

			if($rr == false){
				// error

				$this->session->set_flashdata('response','<div class="alert alert-error">Module cannot be inserted</div>',':old:');
				$this->load->view('templates/header');
				$this->load->view('admin/modules');
				$this->load->view('templates/footer');
			}
			else
			{
				// redirect
				$this->session->set_flashdata('response','<div class="alert alert-success">Module are added successfully</div>');
				redirect('admin/modules');

			}
		}

	}

	function do_update()
	{
		$this->form_validation->set_rules('module_name', 'Module Name', 'required|max_length[50]');
		$this->form_validation->set_rules('module_uri', 'Module URI', 'required|max_length[50]');

		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$records=$this->crud_model->get('modules');
			if($records != false){
				//true section
				$data['module_name']			 = $records[0]['module_name'];
				$data['module_id']			 = $records[0]['module_id'];
				$data['module_uri']			 = $records[0]['module_uri'];
				$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
				$this->load->view('templates/header');
				$this->load->view('admin/module/edit',$data);
				$this->load->view('templates/footer');
					
			}
			else{
				//false section
				$this->session->set_flashdata('response','<div class="alert alert-error">error</div>');
				redirect('admin/modules');
			}
		}
		else
		{// true section

			$module_name= $this->input->post('module_name');
			$module_id=  $this->input->post('module_id');
			$module_uri=  $this->input->post('module_uri');

			$where=array(
					'module_id'=> $module_id
			);
			$data=array(
					'module_name' =>$module_name,
					'module_uri'  => $module_uri

			);
			$records=$this->crud_model->update('modules',$data,$where);
			$this->session->set_flashdata('response','<div class="alert alert-success">Module are updated</div>');
			redirect('admin/modules');
		}

	}
	function do_delete($id=0)
	{
		$where=array(
				'module_id'=> $id
		);

		$this->crud_model->delete('modules',$where);

		$this->session->set_flashdata('response','<div class="alert alert-success">Module is deleted</div>');
		redirect('admin/modules');
	}
}
