<?php
 if (!defined('BASEPATH')) exit('No direct script access allowed');
 
class PurchaseOrder extends CI_Controller{
	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true) {
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}	
		$this->load->model('Vehicle');
	}
	function index($client="") {

	}

	public function listPurchaseOrder(){
		if($this->users_model->check_permission("PurchaseOrderInventory","View")==false && $this->users_model->check_permission("PurchaseOrderJob","View")==false && $this->users_model->check_permission("PurchaseOrderOthers","View")==false){ 
			$red=$this->session->userdata("default_controller_name");
			$this->session->set_flashdata('response','You do not have permission to access this page.Please contact administrator.');
            redirect($red);
		}
		$title['headerTitle']="Purchase Order";
  		$page = 0;
		$i=1;
		$list='';
		$headList='';
		foreach ($this->Job_card_model->get_all_purchase_order() as $row) {
			$style='';
			if($row->status=='Cancel'){
				$style= 'style="background: #f5d2d2;color:#6b1110;"';
			} else if($row->status=='Confirmed') {
				$style='style="background:#dff1cc;color:#316100;"';
			} else {
				$style='style="background:#cbe7fb;color:#24587e;"';
			}
		    $list.='<tr '.$style.' >
						<td>'.$i++.'</td>
						<td>'.$row->po_code.'</td>
						<td>'.$row->po_type.'</td>
						<td>'.date("M d, Y", strtotime($row->po_date)).'</td>
						<td>'.$row->supplier_name.'</td>
						<td>'.$row->job_card_number.'</td>
						<td align="right">'.$row->po_net_amt.'</td>
						<td>
							<div class="btn-group">
								<button type="button" class="btn btn-sm btn-primary dropdown-toggle" data-bs-toggle="dropdown">
									Action <span class="caret"></span>
								</button>
								<ul class="dropdown-menu" role="menu">';
									$list.= '<li><a target="_blank"  href="'.base_url().'index.php/furniture/PurchaseOrder/printPurchaseOrder/' . $row->po_id . '"><i class="fa fa-print"></i> Print</a> </li>';
									if(($row->po_type==='Inventory' && $this->users_model->check_permission("PurchaseOrderInventory","Edit")!=false) || ($row->po_type==='Job' && $this->users_model->check_permission("PurchaseOrderJob","Edit")!=false) || ($row->po_type==='Others' && $this->users_model->check_permission("PurchaseOrderOthers","Edit")!=false)) {
										if($row->pi_status!='Draft' && $row->pi_status!='Confirmed'){
											if($row->rfq_number==NULL){
												if($row->status!='Cancel' && $row->status!='Confirmed' && $row->pi_status!='Draft' && $row->pi_status!='Confirmed') {
													if($row->po_create_type == 0){
														$list.= '<li><a class="iframe iframe cboxElement click2" title="View Receipt" href="'.base_url().'index.php/furniture/PurchaseOrder/editPurchaseOrder/' . $row->po_id . '"><i class="fa fa-edit"></i> Edit</a> </li>';
													}
													else{
														$list.= '<li><a class="iframe iframe cboxElement click2" title="View Receipt" href="'.base_url().'index.php/furniture/PurchaseOrder/editPurchaseOrderJob/' . $row->po_id . '"><i class="fa fa-edit"></i> Edit</a> </li>';
													}
												}
											} else {
												if($row->status!='Cancel' && $row->status!='Confirmed' && $row->pi_status!='Draft' && $row->pi_status!='Confirmed') {
													if($row->po_create_type == 0){
														$list.= '<li><a class="iframe iframe cboxElement click2" title="View Receipt" href="'.base_url().'index.php/furniture/PurchaseOrder/edit_po_from_request/' . $row->po_id . '"><i class="fa fa-edit"></i> Edit</a> </li>';
													}
													else{
														$list.= '<li><a class="iframe iframe cboxElement click2" title="View Receipt" href="'.base_url().'index.php/furniture/PurchaseOrder/editPurchaseOrderJob/' . $row->po_id . '"><i class="fa fa-edit"></i> Edit</a> </li>';
													}	
												}
											}
										}
									}
									if(($row->po_type==='Inventory' && $this->users_model->check_permission("PurchaseOrderInventory","Delete")!=false) || ($row->po_type==='Job' && $this->users_model->check_permission("PurchaseOrderJob","Delete")!=false) || ($row->po_type==='Others' && $this->users_model->check_permission("PurchaseOrderOthers","Delete")!=false)) {
										if($row->status!='Cancel' && $row->pi_status!='Draft' &&  $row->pi_status!='Confirmed') {
											$rrr="'".$row->po_id."','".$row->po_code."'";
											$list.= '<li><a ref="" data-bs-toggle="modal" data-bs-target="#cancelPurchaseOrder" class="cancelPO" data-id="'.$row->po_id.'" data-code="'.$row->po_code.'" ><i class="fa fa-close"></i> Cancel</a> </li>';
										} 
									}
								$list.= '</ul>
							</div>
						</td>
				    </tr>';
		}
		$datas   =   array("data" => $list);
  		$this->load->view('templates/header',$title);
		$this->load->view('furniture/quotations/purchaseorder/listPurchaseOrder',$datas);
		$this->load->view('templates/footer');
	}

	public function printPurchaseOrder($purchase_id,$approvestatus=NULL){
		if($this->users_model->check_permission("PurchaseOrderInventory","View")==false && $this->users_model->check_permission("PurchaseOrderJob","View")==false && $this->users_model->check_permission("PurchaseOrderOthers","View")==false){ 
			$red=$this->session->userdata("default_controller_name");
			$this->session->set_flashdata('response','You do not have permission to access this page.Please contact administrator.');
            redirect($red);
		}
		$datas['row']        = $this->Job_card_model->purchaseOrderRow($purchase_id);

		$division_id	=	$datas['row']->division_id;
		$datas['approvestatus'] = $approvestatus;
		$this->db->select('*' );
		$this->db->from('company_division');
		$this->db->where('division_id', $division_id);
		$rs = $this->db->get();
		$datas['logo_filename'] = $rs->row()->logo_filename;

		$datas['details']    = $this->Job_card_model->purchaseOrderDetails($purchase_id);

		$query = $this->db->get('company_details');  
		$datas['company_details'] = $query->row();

		$this->load->view('furniture/quotations/purchaseorder/printPurchaseOrder',$datas);
	}

	public function approvePurchaseOrder($po_id,$po_code){
		$this->session->keep_flashdata('response');
		$where = array('po_id'	=> $po_id);	
		$data_quo['status']= 'Confirmed';
		$data_quo['approved_date']= date('Y-m-d h:m:s');
		$data_quo['approved_user']= $this->session->userdata('user_name');
		
		$this->crud_model->update('po_h',$data_quo,$where);
		
		$log_data=array(
			'trans_no'     =>  $po_code,
			'trans_type'   =>  'Purchase Order',
			'trans_op'     =>  'Confirmed',
			'trans_user_id'=>  $this->session->userdata('user_id')
		);
		$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);
		
		$this->session->set_flashdata('success','Confirmed successfully..');
		redirect('Dashboard/home');
	}

	public function search_items() {
		$item	=	$this->input->post('item');
	 	$today	=	date("Y-m-d");
	 	$html	='';
		$sql="";

	  	$query3 = $this->db->query("SELECT * FROM `items`  WHERE `status`='1' and `is_purchase`='1' and  `item_name` like '%$item%' limit 15");
	 	$itemList_date	=	$query3->result_array();
	 	$itemList='';
	 	foreach($itemList_date as $itemList_datas){
			if($itemList_datas['last_purchase_rate']!=NULL && $itemList_datas['last_purchase_rate']!='' && $itemList_datas['last_purchase_rate']!='0'){
				$cost_price=$itemList_datas['last_purchase_rate'];
			} else if($itemList_datas['cost_price']!=NULL && $itemList_datas['cost_price']!=''){
				$cost_price=$itemList_datas['cost_price'];
			} else {
				$cost_price=0;
			}
			$uom_id = $itemList_datas['uom_id'];
			
			$sub_uom_nme	= $sub_uom_id	=	$conversion = '';
			if(!empty($uom_id)){
				$query4 = $this->db->query("SELECT * FROM `unit_master` WHERE `unit_id` = $uom_id  AND `status` = 1");
				if($query4->num_rows() > 0){
					$sub_uom_nme	=	$query4->row()->unit_name;
					$sub_uom_id		=	$query4->row()->unit_id;
				}
				else{
					$sub_uom_nme	=	'';
					$sub_uom_id		=	'';
				}
			}
			if(!empty($itemList_datas['conversion'])){
				$conversion = $itemList_datas['conversion'];
			}
			else{
				$conversion = '';
			}
			$html.='<li tabindex="-1" class="search_item_list p_description_button"  
										data-margin	="'.$itemList_datas['margin'].'"  
										data-rate	="'.$itemList_datas['selling_price'].'"  
										data-item_code	="'.$itemList_datas['item_code'].'" 
										data-item_UOM_id ="'.$itemList_datas['unit_id'].'" 
										data-uom = "'.$itemList_datas['unit'].'"
										data-sub-uom = "'.$itemList_datas['uom_id'].'"
										data-sub-uom-name = "'.$sub_uom_nme.'"
										data-sub-uom-id = "'.$sub_uom_id.'"
										data-item_name	= "'.$itemList_datas['item_name'].'" 
										data-item_cost	= "'.$cost_price.'" 
										data-uom-conversion	= "'.$conversion.'" 
										data-item_details_id = "'.$itemList_datas['id'].'" 
										data-item_uom_from = "'.$itemList_datas['unit_from'].'" 
										data-item_uom_to = "'.$itemList_datas['unit_to'].'" 
										item_tax_rate="10">'.$itemList_datas['item_name'].'</li>';
	 	}
		if(count($itemList_date)==0){
		 	$html.='<li>No data found</li>';
	 	}
		print $html;
	}

	public function search_ledger() {
		$client	=	$this->input->post('client');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		
		$like=array('ledger_name'=>$client);
		$where=" status=1 and (acoount_group_id!=17 and acoount_group_id!=18 and acoount_group_id!=19 and acoount_group_id!=20) ";
		$client_contact_data=$this->crud_model->get('ledgers',$where,25,0,null,null,$like,null,null);
		//$client_contact_data = $this->db->query("SELECT * FROM `ledgers` where (acoount_group_id!=17 and acoount_group_id!=18 and acoount_group_id!=19 and acoount_group_id!=20 ) and `ledger_name` like '%$client%'   order by ledger_name limit 25 ");
		$n=1;
		if(count($client_contact_data)>0){
			$html ='';
			foreach ($client_contact_data as $client_contact_datas){
				$html.='<li tabindex="-1" value="' .$client_contact_datas['ledger_id'].'" class="client_button" tabindex="'.$n++.'" ><input type="hidden" class="client_name" value="'.$client_contact_datas['ledger_name'].'" /><input type="hidden" class="client_code" value="'.$client_contact_datas['ledger_code'].'" />'.$client_contact_datas['ledger_name'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		
		print $html;
	}

	public function search_items_by_location() {
		$item	=	$this->input->post('item');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		$loc_id	=	$this->input->post('loc_id');

		$query3 = $this->db->query("SELECT * FROM `items`  WHERE `item_name` like '%$item%'");
		$itemList_date	=	$query3->result_array();
		$itemList='';
		
		foreach($itemList_date as $itemList_datas){
			$item_rate=0;
			$id=$itemList_datas['id'];
			$query5 = $this->db->query("SELECT item_rate FROM `item_trans` WHERE `loc_id` = '$loc_id' and `item_id` = '$id' and `trans_type`=1 ORDER BY `item_trans_id` DESC LIMIT 1");
			if($query5->num_rows() > 0){
				$item_rate = $query5->row()->item_rate;
			}
			if($item_rate==0){
				$query6 = $this->db->query("SELECT item_rate FROM `item_trans` WHERE `loc_id` != '$loc_id' and `item_id` = '$id' and `trans_type`=1 ORDER BY `item_trans_id` DESC LIMIT 1");
				if($query6->num_rows() > 0){
					$item_rate = $query6->row()->item_rate;
				}
			}
			if($item_rate==0){
				$item_rate =$itemList_datas['cost_price'];
			}

			$html.='<li tabindex="-1" class="search_item_list p_description_button" data-rate="'.$itemList_datas['selling_price'].'"  data-item_code="'.$itemList_datas['item_code'].'" data-item_UOM_id="'.$itemList_datas['unit_id'].'" data-item_name="'.$itemList_datas['item_name'].'" data-item_cost="'.$item_rate.'" data-item_details_id="'.$itemList_datas['id'].'" item_tax_rate="5">'.$itemList_datas['item_name'].'</li>';
		}
		if(count($itemList_date)==0){
			$html.='<li>No data found</li>';
		}
		print $html;
	}

	public function do_insert() {
		if($this->users_model->check_permission("PurchaseOrderInventory","Add")==false && $this->users_model->check_permission("PurchaseOrderJob","Add")==false && $this->users_model->check_permission("PurchaseOrderOthers","Add")==false){ 
			$red=$this->session->userdata("default_controller_name");
			$this->session->set_flashdata('response','You do not have permission to access this page.Please contact administrator.');
            redirect($red);
		}
    	//$this->form_validation->set_rules('po', 'po number', 'required');
		$this->form_validation->set_rules('po_date', 'Date', 'required');
		//if($this->input->post('togBtn')){
			$this->form_validation->set_rules('p_description[]', 'Product', 'required');
		/* } else {
			$this->form_validation->set_rules('p_description_id[]', 'Product', 'required');
		} */
		$this->form_validation->set_rules('supplier_id', 'Supplier', 'required');
		$this->form_validation->set_rules('po_type', 'Type', 'required');
		$this->form_validation->set_rules('payment_mode', 'Payment Mode', 'required');
		if($this->input->post('payment_mode')==='Cash'){
			$this->form_validation->set_rules('header_ledger_code', 'Ledger', 'required');
		}
		if($this->input->post('po_type')==='Job'){
			$this->form_validation->set_rules('job_id', 'Job No', 'required');
		}
        if ($this->form_validation->run() == FALSE){
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			redirect('furniture/PurchaseOrder/create_purchase_order');
        } else {
	  		$user_id	=	$this->session->userdata('user_id');
			$this->db->trans_begin();
			$po_date			=	date("Y-m-d", strtotime($this->input->post('po_date')));
	 		$purchaseNumber= $this->Job_card_model->purchaseNumber($this->input->post('division'));
			$po_code= $this->Job_card_model->get_purchase_order_no($purchaseNumber,$this->input->post('division'));
			$data = array( 
				'po_number'         => $purchaseNumber,
				'po_code'       	=> $po_code,
				'po_date'           => $po_date,
				'supplier_id'       => $this->input->post('supplier_id'),
				'division_id'       => $this->input->post('division'),
				'supplier_reference'=> $this->input->post('supplier_ref'),
				'job_id'            => $this->input->post('job_id'),
				'loc_id'            => $this->input->post('loc_id'),
				'currency_id'       => $this->input->post('currency'),
				'exchange_rate'     => $this->input->post('exchange_rate'),
				'rfq_number'        => NULL,
				'payment_mode'      => $this->input->post('payment_mode'),
				'delivery_address'  => $this->input->post('supply_address'),
				'delivery_terms'    => $this->input->post('delivery_terms'),
				'po_type'    		=> $this->input->post('po_type'),
				'poh_ledger_code'   => @$this->input->post('header_ledger_code'),
				'user_id'           => $user_id,
				'status'            => 'Draft'
			);	
			$this->db->insert('po_h', $data);
			$insert_id = $this->db->insert_id();
	
			if($insert_id){
				//if($this->input->post('job_id')!='' && $this->input->post('job_id')!='0' ){
				//if($this->input->post('togBtn')){ 
					$loop_count	= count($this->input->post('p_description'));
				//} else {
				//	$loop_count	= count($this->input->post('p_description_id'));
				//}
				$p_description_id	= $this->input->post('p_description_id');
				$p_description	    = $this->input->post('p_description');
				$p_d_description	  =	$this->input->post('p_d_description');
				$description	    = $this->input->post('description');
				$p_nbitem	        = $this->input->post('p_nbitem');
				$p_section	        = $this->input->post('p_section');
				$p_qty	            = $this->input->post('p_qty');
				$uom	            = $this->input->post('uom_name');
				$uom_id	            = $this->input->post('uom');
				$p_rate	            = $this->input->post('p_rate');
				$p_discount	        = $this->input->post('p_discount');
				$p_vat	        	= $this->input->post('p_vat');
				$fx_rate	        = $this->input->post('fx_rate');
				$p_ledger_code	    = $this->input->post('p_ledger_code');
				$fx_disc	        = $this->input->post('fx_disc');
				$b_uom_conv	        = $this->input->post('b_unit_convertion'); 
				$b_uom	            = $this->input->post('uom_base_id'); 
				$po_gross_amt       = 0;
				$po_discount        = 0;
				$po_vat_amt         = 0;
				$po_net_amt         = 0;
				for($i=0; $i<$loop_count; $i++){
					//if($this->input->post('job_id')!='' && $this->input->post('job_id')!='0' ){ 
					//if($this->input->post('togBtn')){
						$chk_loop	    =	$p_description[$i];
					/* } else {
						$chk_loop	  =	$p_description_id[$i];
					} */
					if($chk_loop!==''){
						if($p_discount[$i]==='') {
							$total2	=	$p_qty[$i]*$p_rate[$i];
						} else {
							$total2	=	$p_qty[$i]*$p_rate[$i]-$p_discount[$i];
						}
					
						if(@$p_section[$i] == ''){
							$p_section2 = '';
						} else {
							$p_section2 = $p_section[$i];
						}
						if($this->input->post('currency')!=1){ 
							$vat_amt = 0;
							if($fx_disc[$i]!='') {
								$p_fx_disc = $fx_disc[$i];
								$fx_amount = ($p_qty[$i]*$fx_rate[$i])-$fx_disc[$i];
								$fx_net_amount = ($p_qty[$i]*$fx_rate[$i])-$fx_disc[$i];
							} else {
								$p_fx_disc = 0;
								$fx_amount = ($p_qty[$i]*$fx_rate[$i]);
								$fx_net_amount = $p_qty[$i]*$fx_rate[$i];
							}
							
						} else {
							if($fx_disc[$i]!='') {
								$p_fx_disc = $fx_disc[$i];
								$fx_amount = ($p_qty[$i]*$fx_rate[$i])-$fx_disc[$i];
							} else {
								$p_fx_disc = 0;
								$fx_amount = ($p_qty[$i]*$fx_rate[$i]);
							}
							
							if(@$p_vat[$i] == ''){
								$vat_amt = 0;
							} else {
								$vat_amt = $p_vat[$i]/100;
							}
							$fx_net_amount = ($fx_amount)+(($fx_amount)*$vat_amt);
						}
						//if($this->input->post('job_id')!=''){ 
						if(@$p_description_id[$i]===''){
							$p_description_idnbx= 0;
						} else {
							$p_description_idnbx= $p_description_id[$i];
						}


						if($b_uom[$i] == $uom_id[$i]){
							$b_uom_qty = $p_qty[$i];
						} else {
							$b_uom_qty  = $p_qty[$i] / $b_uom_conv[$i];
						}
						$b_uom_rate = $fx_amount / $b_uom_conv[$i];

						$data_array = array(
							'po_id' 	      => $insert_id,
							'po_ledger_code'  => $p_ledger_code[$i],
							'item_details_id' => $p_description_idnbx,
							'item_name_nbs'   => $p_description[$i],
							'item_name_purchase' => $p_d_description[$i],
							'item_description'=> $description[$i],
							'loc_id'          => $this->input->post('loc_id'),
							'item_qty' 		  => $p_qty[$i],
							'uom' 		      => $uom[$i],
							'uom_id' 		  => $uom_id[$i],
							'b_uom' 		  => $b_uom,
							'b_uom_qty' 	  => $b_uom_conv[$i],
							'b_uom_conv' 	  => $b_uom_qty,
							'b_uom_rate' 	  => $b_uom_rate,
							'item_fx_rate'    => $fx_rate[$i],
							'item_rate' 	  => $p_rate[$i],
							'item_disc' 	  => $p_discount[$i],
							'item_amount' 	  => (($p_qty[$i]*$p_rate[$i])-(float)$p_discount[$i]),
							'item_vat_per' 	  => $vat_amt,
							'item_vat' 		  => ($total2)*$vat_amt,
							'net_amount' 	  => ($total2)+(($total2)*$vat_amt),
							'fx_disc' 	  	  => $fx_disc[$i],
							'fx_amount' 	  => $fx_amount,
							'fx_net_amount'   => $fx_net_amount,
							'status'          => 1
						);
						$this->db->insert('po_b', $data_array);
					}
				}
				$this->furniture_quotation_model->update_purchase_order_total($insert_id);
				$log_data=array(
					'trans_no'     => $po_code,
					'trans_type'   => 'Purchase Order',
					'trans_op'     => 'Create',
					'trans_user_id'=> $this->session->userdata('user_id')	
				);
				$log_for_transactions	=	$this->crud_model->insert('log_for_transactions',$log_data);
			}
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				redirect("furniture/PurchaseOrder/listPurchaseOrder");
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'Purchase Order Created Successfully');
				redirect("furniture/PurchaseOrder/editPurchaseOrder/".$insert_id);
			}
		}
	}

	public function editPurchaseOrder($purchase_id,$po_b_id='') {
		if($this->users_model->check_permission("PurchaseOrderInventory","Edit")==false && $this->users_model->check_permission("PurchaseOrderJob","Edit")==false && $this->users_model->check_permission("PurchaseOrderOthers","Edit")==false){ 
			$red=$this->session->userdata("default_controller_name");
			$this->session->set_flashdata('response','You do not have permission to access this page.Please contact administrator.');
            redirect($red);
		}
		$title['headerTitle']="Purchase Order Edit";
		$this->form_validation->set_rules('supplier_id', 'Supplier', 'required');
		$this->form_validation->set_rules('po_date', 'Date', 'required');
		$this->form_validation->set_rules('p_description[]', 'Product', 'required');
		$this->form_validation->set_rules('payment_mode', 'Payment Mode', 'required');
		$data['select_html'] = '';
		if($this->input->post('payment_mode')==='Cash'){
			$this->form_validation->set_rules('header_ledger_code', 'Ledger', 'required');
		}
		$unitmaster = $this->crud_model->get('unit_master');
		$data['unitmaster']  =  $unitmaster;
		if($po_b_id!=''){
			$data['item']        = $this->Job_card_model->purchaseitemwiseRow($po_b_id);
			$get_item_uom = $this->furniture_quotation_model->getItemRow($data['item']->item_details_id);		
			if(!empty($get_item_uom)){
				$unitMstarray = array_column($unitmaster, 'unit_name','unit_id');
				 
				if(isset($get_item_uom->unit_id) && isset($unitMstarray[$get_item_uom->unit_id])){
					$main_uom  = $unitMstarray[$get_item_uom->unit_id];
 				}
				else{
					$main_uom  =  '';
				}
				if(isset($get_item_uom->uom_id) && isset($unitMstarray[$get_item_uom->uom_id])){
					$sub_uom  = $unitMstarray[$get_item_uom->uom_id];
				}
				else{
					$sub_uom  = '';
				}
				$selectd_unit = ($get_item_uom->unit_id == $data['item']->uom_id ? 'selected="selected"' : '' );
				$selectd_unit2 = ($get_item_uom->uom_id == $data['item']->uom_id ? 'selected="selected"' : '' );
				$data['select_html'] = '<select id="uom" name="uom[]" class="form-control uom" style="height: 38px;">';
						if($get_item_uom->unit_id == $get_item_uom->uom_id){
							$data['select_html'] .= '<option data-uom-category="1" data-uom-sub="Pcs" data-uom-conv="'.$get_item_uom->conversion.'" data-uom-name="Ctn" data-uom-selected="Ctn" value="'.$get_item_uom->unit_id.'"> Ctn</option>';
						}
						else{
							$data['select_html'] .= '<option '.$selectd_unit.'   data-uom-category="1" data-uom-sub="'.$sub_uom.'" data-uom-conv="'.$get_item_uom->conversion.'" data-uom-name="'.$main_uom.'" data-uom-selected="'.$main_uom.'" value="'.$get_item_uom->unit_id.'">'.$main_uom.'</option> 
						                             <option '.$selectd_unit2.' data-uom-sub="'.$sub_uom.'" data-uom-category="2" data-uom-conv="'.$get_item_uom->conversion.'" data-uom-name="'.$main_uom.'" data-uom-selected="'.$sub_uom.'" value="'.$get_item_uom->uom_id.'">'.$sub_uom.'</option>';
						}									    
				$data['select_html'] .='</select>';			
			}
			
		} else {
			$data['item']        =NULL;
		}
		$data['row']        = $this->Job_card_model->purchaseOrderRow($purchase_id);
        if ($this->form_validation->run() == FALSE){
    		$data['details']    = $this->Job_card_model->purchaseOrderDetails($purchase_id);
			$unit_list = $this->crud_model->get('unit_master');
		    $data['unit_master'] = $unit_list;
			$data['currency']=$this->Job_card_model->currency();
			$list = $this->crud_model->get_list('division_id','division_name','company_division',array(''=>' - Select - '));
			$data['division_list'] = $list;
			$list2 = $this->crud_model->get_list('loc_id','loc_name','location_master',array(''=>' - Select - '));
			$data['location_list'] = $list2;
			$division_id	=	$data['row']->division_id;

			if($this->furniture_quotation_model->config($division_id)){
				$config_data=$this->furniture_quotation_model->config($division_id);
				$data['is_quote_from_master'] = $config_data->is_quote_from_master;
				$data['is_estimate'] = $config_data->is_estimate;
				$data['is_approve'] = $config_data->is_approve;
				$data['is_bom'] = $config_data->is_bom;
				$data['is_optional_item_level'] = $config_data->is_optional_item_level;
				$data['is_category'] = $config_data->is_category;
			} else {
				$data['is_quote_from_master'] = 0;
				$data['is_estimate'] = 0;
				$data['is_approve'] = 0;
				$data['is_bom'] = 0;
				$data['is_optional_item_level'] = 0;
				$data['is_category'] = 0;
			}

			$qt_date=date("Y-m-d");
			$data['vat_percentage_array']=$this->furniture_quotation_model->vat_applicable2($qt_date);

			$unit_list = $this->crud_model->get_list('unit_name','unit_name','unit_master',array(''=>' - Select - '));
			$data['unit_list'] = $unit_list;
						
			$header_ledger_list = $this->crud_model->get_list('ledger_code', 'ledger_name', 'ledgers', array('' => ' - Select - '), array('acoount_group_id' => 22));
			$data['header_ledger_list'] = $header_ledger_list;
			$this->load->view('templates/header',$title);
			$this->load->view('furniture/quotations/purchaseorder/editPurchaseOrder',$data);
			$this->load->view('templates/footer');
        } else {
			$po_date			=	date("Y-m-d", strtotime($this->input->post('po_date')));
	  		$user_id	=	$this->session->userdata('user_id');
			$this->db->trans_begin();
			$data = array( 
				'supplier_id'       => $this->input->post('supplier_id'),
				'po_date'      		=> $po_date,
				'division_id'       => $this->input->post('division'),
				'supplier_reference'=> $this->input->post('supplier_ref'),
				'currency_id'       => $this->input->post('currency'),
				'rfq_number'        => NULL,
				'payment_mode'      => $this->input->post('payment_mode'),
				'delivery_address'  => $this->input->post('supply_address'),
				'delivery_terms'    => $this->input->post('delivery_terms'),
				'poh_ledger_code'   => @$this->input->post('header_ledger_code'),
				'user_id'           => $user_id,
				'status'            => 'Draft'
			);
			
			$this->db->where('po_id', $purchase_id);
			$this->db->update('po_h', $data);
	  		
			if($purchase_id){
				$loop_count	      =	count($this->input->post('p_description'));
				$p_description_id =	$this->input->post('p_description_id');
				$p_description	  =	$this->input->post('p_description');
				$p_nbitem	      =	$this->input->post('p_nbitem');
				$description	  = $this->input->post('description');
				$p_d_description  = $this->input->post('p_d_description');
				$p_section	      =	$this->input->post('p_section');
				$p_qty	          =	$this->input->post('p_qty');
				$p_rate	          =	$this->input->post('p_rate');
				$uom	          = $this->input->post('uom_name');
				$uom_id	          = $this->input->post('uom');
				$p_discount	      =	$this->input->post('p_discount');
				$p_vat	          =	$this->input->post('p_vat');
				$fx_rate	      =	$this->input->post('fx_rate');
				$p_ledger_code	    = $this->input->post('p_ledger_code');
				$fx_disc	        = $this->input->post('fx_disc');
			    $b_uom_conv	        = $this->input->post('b_unit_convertion'); 
				$b_uom	            = $this->input->post('uom_base_id'); 
				$po_gross_amt     = 0;
				$po_discount      = 0;
				$po_vat_amt       = 0;
				$po_net_amt       = 0;
				for($i=0; $i<$loop_count; $i++){
					$chk_loop	    =	$p_description[$i];
					
					if($chk_loop!==''){
						if($p_discount[$i]==='') {
							$total2	= round($p_qty[$i]*$p_rate[$i],3);
						} else {
							$total2	= round($p_qty[$i]*$p_rate[$i],3)-(float)$p_discount[$i];
						}
						
						if($this->input->post('currency')!=1){ 
							$vat_amt = 0;
							if($fx_disc[$i]!='') {
								$p_fx_disc = $fx_disc[$i];
								$fx_amount = ($p_qty[$i]*$fx_rate[$i])-$fx_disc[$i];
								$fx_net_amount = ($p_qty[$i]*$fx_rate[$i])-$fx_disc[$i];
							} else {
								$p_fx_disc = 0;
								$fx_amount = ($p_qty[$i]*$fx_rate[$i]);
								$fx_net_amount = $p_qty[$i]*$fx_rate[$i];
							}
							
						} else {
							if($fx_disc[$i]!='') {
								$p_fx_disc = $fx_disc[$i];
								$fx_amount = ($p_qty[$i]*$fx_rate[$i])-$fx_disc[$i];
							} else {
								$p_fx_disc = 0;
								$fx_amount = ($p_qty[$i]*$fx_rate[$i]);
							}
							
							if(@$p_vat[$i] == ''){
								$vat_amt = 0;
							} else {
								$vat_amt = $p_vat[$i]/100;
							}
							$fx_net_amount = ($fx_amount)+(($fx_amount)*$vat_amt);
						}
						//if($this->input->post('job_id')!=''){ 
						if(@$p_description_id[$i]===''){
							$p_description_idnbx= 0;
						} else {
							$p_description_idnbx= $p_description_id[$i];
						}

						if($b_uom == $uom_id[$i]){
							$b_uom_qty = $p_qty[$i];
						} else {
						 
							$b_uom_qty  = $p_qty[$i] / $b_uom_conv[$i];
						}
						$b_uom_rate = $fx_amount / $b_uom_conv[$i];

						$data_array = array(
							'po_id' 	       => $purchase_id,
							'po_ledger_code'   => $p_ledger_code[$i],
							'item_details_id'  => $p_description_idnbx,
							'item_name_nbs'    => $p_description[$i],
							'item_name_purchase'=>$p_d_description[$i],
			  				'item_description' => $description[$i],
							'loc_id'           => $this->input->post('loc_id'),
							'item_qty' 		   => $p_qty[$i],
							'uom' 		       => $uom[$i],
							'uom_id' 		   => $uom_id[$i],
							'b_uom' 		   => $b_uom,
							'b_uom_qty' 	   => $b_uom_conv[$i],
							'b_uom_conv' 	   => $b_uom_qty,
							'b_uom_rate' 	   => $b_uom_rate,
							'item_fx_rate' 	   => $fx_rate[$i],
			  				'item_rate' 	   => $p_rate[$i],
			 				'item_disc' 	   => $p_discount[$i],
							'item_amount' 	   => $total2,
							'item_vat_per' 	   => $vat_amt,
							'item_vat' 		   => ($total2)*$vat_amt,
							'net_amount' 	   => ($total2)+(($total2)*$vat_amt),
							'fx_disc' 	  	  => $fx_disc[$i],
							'fx_amount' 	  => $fx_amount,
							'fx_net_amount'   => $fx_net_amount,
							'status'          => 1
						);
						if($po_b_id!=''){
							$where=array(
								'po_b_id'=> $po_b_id
							);
							$this->db->update('po_b', $data_array,$where);
						} else {
							$this->db->insert('po_b', $data_array);
						}
		  			}
				}
				$this->furniture_quotation_model->update_purchase_order_total($purchase_id);
				/*$log_data=array(
					'trans_no'     =>	$data['row']->po_code,
					'trans_type'   => 'Purchase Order',
					'trans_op'     => 'Edit',
					'trans_user_id'=> $this->session->userdata('user_id')	
				);
				$log_for_transactions	=	$this->crud_model->insert('log_for_transactions',$log_data);*/
	  		}
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				redirect("furniture/PurchaseOrder/listPurchaseOrder");
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', '');
				redirect("furniture/PurchaseOrder/editPurchaseOrder/".$purchase_id);
			}
		}
	}

	public function do_update_discount($po_id) {
		$this->form_validation->set_rules('nb_po_id', 'Purchase Order', 'required');
		if ($this->form_validation->run() == FALSE)	{
			// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			redirect('furniture/PurchaseOrder/editPurchaseOrder/'.$po_id);
		} else {
			$dbdata = $this->Job_card_model->purchaseOrderRow($po_id);

			$data = array(
				'status'     => 'Draft',
				'po_discount'=> (float)$this->input->post('fx_po_discount')*$dbdata->exchange_rate,
				'po_vat_amt' => $this->input->post('total_vat'),
				'sign' 	  	 => $this->input->post('sign'),
				'round_off'  => (float)$this->input->post('round_off')*$dbdata->exchange_rate,
				'po_net_amt' => (float)$this->input->post('fx_po_net_amt')*$dbdata->exchange_rate,
				'fx_po_discount'=> $this->input->post('fx_po_discount'),
				'fx_po_gross_amt'=> $this->input->post('fx_po_gross_amt'),
				'fx_po_net_amt' => $this->input->post('fx_po_net_amt')
			);

			$where=array(
				'po_id'=> $po_id
			);
			$this->crud_model->update(' po_h',$data,$where );


			$data2 = array(
				'job_id' 	 => $this->input->post('mar_job_id'),
			);
			$this->crud_model->update(' po_b',$data2,$where );

			$job_id =  $this->input->post('mar_job_id');
			$check_job_item_qty = $this->furniture_quotation_model->getjobItemtTotalOrderQuantity($job_id);
			$check_po_item_qty = $this->furniture_quotation_model->getpurchaseTotalOrderQuantity($job_id);

			$check_job_stock_qty = $this->furniture_quotation_model->getjobItemtTotalStockQuantity($job_id);
			$check_mstock_item_qty = $this->furniture_quotation_model->getmaterialstockQuantity($job_id);
			$date = date("Y-m-d H:i:s");
			if($check_job_item_qty  == $check_po_item_qty){
				if($check_job_stock_qty != $check_mstock_item_qty ){
					$job_card_data= array(
						'jobcard_stage' =>21,			
					);
					$where_job_card = array(
						'id' => $job_id
					);
					$this->crud_model->update('job_card',$job_card_data,$where_job_card);
					$datajob_stage = array(
						'job_id' => $job_id,
						'user_id' => $this->session->userdata('user_id'),
						'log_date' => $date,
						'log_status' => 21,
					);
					$this->crud_model->insert('jobcard_track_log',$datajob_stage);		
				}
				else{
					$job_card_data= array(
						'jobcard_stage' =>25,			
					);
					$where_job_card = array(
						'id' => $job_id
					);
					$this->crud_model->update('job_card',$job_card_data,$where_job_card);
					$datajob_stage = array(
						'job_id' => $job_id,
						'user_id' => $this->session->userdata('user_id'),
						'log_date' => $date,
						'log_status' => 25,
					);
					$this->crud_model->insert('jobcard_track_log',$datajob_stage);	
				}
			}
			else{
				$job_card_data= array(
					'jobcard_stage' =>20,			
				);
				$where_job_card = array(
					'id' => $job_id
				);
				$this->crud_model->update('job_card',$job_card_data,$where_job_card);
				$datajob_stage = array(
					'job_id' => $job_id,
					'user_id' => $this->session->userdata('user_id'),
					'log_date' => $date,
					'log_status' => 20,
				);
				$this->crud_model->insert('jobcard_track_log',$datajob_stage);	
			}

			$page=1;
			redirect('furniture/PurchaseOrder/listPurchaseOrder');
		}
	}

	public function searchSupplier() {
		$client	=	$this->input->post('client');
		$status	=	$this->input->post('status');
		$condition = "";
		if($status != ''){
			$condition .= "AND `status` = '1' ";
		}
		$client_contact_data = $this->db->query("SELECT * FROM `supplier_master` WHERE `supplier_name` LIKE  '%$client%' $condition LIMIT 5");
		$n=1;
		$html ='';
		if(count($client_contact_data->result_array())>0){
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<li tabindex="-1" value="' .$client_contact_datas['supplier_id'].'" class="client_button" tabindex="'.$n++.'" ><input type="hidden" class="client_name" value="'.$client_contact_datas['supplier_name'].'" /><input type="hidden" class="client_address" value="'.$client_contact_datas['address'].'" />'.$client_contact_datas['supplier_name'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		print $html;
	}

	public function searchJob() {
		$po_number = $this->input->post('po_number');
		$division = $this->input->post('division');
		//print 'aaa';
		$jobData = $this->Job_card_model->getPurchaseOrderData($division,$po_number);
		if($jobData!=false){
		  echo json_encode($jobData);
		}else{
		  echo 0;
		}
	}

	public function getJobDetails() {
		$job_number = $this->input->post('job_number');
		$division = $this->input->post('division');

		$client_contact_data = $this->db->query("SELECT * FROM `job_card` JC JOIN new_client_master NCM ON NCM.client_id=JC.client_id  WHERE  JC.`job_card_number`  LIKE  '%$job_number%' AND JC.`divisionid`='$division' AND (JC.`job_card_status`='Draft') ");
		$n=1;
		$html ='';
		if(count($client_contact_data->result_array())>0){
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<li tabindex="-1" value="' .$client_contact_datas['id'].'" class="job_button" tabindex="-1" ><input type="hidden" class="job_card_number" value="'.$client_contact_datas['job_card_number'].'" /><input type="hidden" class="client_name" value="'.$client_contact_datas['client_name'].'" /><input type="hidden" class="client_telephone1" value="'.$client_contact_datas['client_telephone1'].'" /><input type="hidden" class="project_name" value="'.$client_contact_datas['project_name'].'" />'.$client_contact_datas['job_card_number'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		echo $html;
	}

	public function getPRDetails() {
		$pr_no = $this->input->post('pr_no');
		$division = $this->input->post('division');

		$client_contact_data = $this->db->query("SELECT * FROM `purchase_request` WHERE `pr_code` LIKE '%$pr_no%' AND `division_id`='$division' AND `status`='Confirmed'");
		$n=1;
		$html ='';
		if(count($client_contact_data->result_array())>0){
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<li tabindex="-1" value="' .$client_contact_datas['pr_id'].'" class="purchase_request_button" tabindex="-1" ><input type="hidden" class="pr_code" value="'.$client_contact_datas['pr_code'].'" />'.$client_contact_datas['pr_code'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_purchase_request_button" > No Results Found </li>';
		}
		echo $html;
	}

	public function getDetails() {
		$job_number = $this->input->post('job_number');
		$division = $this->input->post('division');
		$jobData = $this->Job_card_model->getJobData($division,$job_number);		
		if($jobData!=false){
		  echo json_encode($jobData);
		} else {
		  echo 0;
		}
	}

	public function edit_po_from_request($purchase_id) {
		if($this->users_model->check_permission("PurchaseOrderInventory","Edit")==false && $this->users_model->check_permission("PurchaseOrderJob","Edit")==false && $this->users_model->check_permission("PurchaseOrderOthers","Edit")==false){ 
			$red=$this->session->userdata("default_controller_name");
			$this->session->set_flashdata('response','You do not have permission to access this page.Please contact administrator.');
            redirect($red);
		}
		$title['headerTitle']="Purchase Order Edit";
		$this->form_validation->set_rules('row_item_name[]', 'Product', 'required');
		if($this->input->post('payment_mode')==='Cash'){
			$this->form_validation->set_rules('header_ledger_code', 'Ledger', 'required');
		}
		$data['dbdata']        = $this->Job_card_model->purchaseOrderRow($purchase_id);
        if ($this->form_validation->run() == FALSE){
			$data['currency']=$this->Job_card_model->currency();
    		$data['details']    = $this->Job_card_model->purchaseOrderDetails($purchase_id);
			$job_card_id    = $this->input->post('job_card_id');
		
			$client    = $this->input->post('client');
		
			$this->load->model('proforma_model');
			$data['client_det']=$client;
			$data['client_det_id']=$this->input->post('client_id');
			
			$list2 = $this->crud_model->get_list2('department_id','department_name','department_master',array(''=>' - Select - '),array('status'=>1));
			$data['department_list'] = $list2;

			$division_id = $data['dbdata']->division_id;
			$list = $this->crud_model->get_list2('division_id','division_name','company_division',array(),array('division_id'=>$division_id));
			$data['division_list'] = $list;
			
			if($this->furniture_quotation_model->config($division_id)){
				$config_data=$this->furniture_quotation_model->config($division_id);
				$data['is_quote_from_master'] = $config_data->is_quote_from_master;
				$data['is_estimate'] = $config_data->is_estimate;
				$data['is_approve'] = $config_data->is_approve;
				$data['is_bom'] = $config_data->is_bom;
				$data['is_optional_item_level'] = $config_data->is_optional_item_level;
				$data['is_category'] = $config_data->is_category;
			} else {
				$data['is_quote_from_master'] = 0;
				$data['is_estimate'] = 0;
				$data['is_approve'] = 0;
				$data['is_bom'] = 0;
				$data['is_optional_item_level'] = 0;
				$data['is_category'] = 0;
			}

			$qt_date=date("Y-m-d");
			$data['vat_percentage_array']=$this->furniture_quotation_model->vat_applicable2($qt_date);
			$unit_list = $this->crud_model->get_list('unit_name','unit_name','unit_master',array(''=>' - Select - '));
			$data['unit_list'] = $unit_list;
			$header_ledger_list = $this->crud_model->get_list('ledger_code', 'ledger_name', 'ledgers', array('' => ' - Select - '), array('acoount_group_id' => 22));
			$data['header_ledger_list'] = $header_ledger_list;
			$this->load->view('templates/header',$title);
			$this->load->view('furniture/quotations/purchaseorder/edit_po_from_request',$data);
			$this->load->view('templates/footer');
        } else {
			
			$user_id	=	$this->session->userdata('user_id');
			$this->db->trans_begin();
			$data = array( 
				'supplier_id'       => $this->input->post('supplier_id'),
				'supplier_reference'=> $this->input->post('supplier_ref'),
				'delivery_address'  => $this->input->post('supply_address'),
				'delivery_terms'    => $this->input->post('delivery_terms'),
				'poh_ledger_code'   => @$this->input->post('header_ledger_code'),
				'user_id'           => $user_id,
				'status'            => 'Draft'
			);	
			$this->db->where('po_id', $purchase_id);
			$this->db->update('po_h', $data);
	
			if($purchase_id){
				$loop_count			= count($this->input->post('row_item_name'));
				$po_b_id		= $this->input->post('row_po_b_id');
				$pr_d_id			= $this->input->post('row_pr_d_id');
				$p_description_id	= $this->input->post('row_item_id');
				$p_description	    = $this->input->post('row_item_name');
				$description	    = $this->input->post('row_description');
				$p_qty	            = $this->input->post('row_qty');
				$uom	            = $this->input->post('row_uom');
				$p_rate	            = $this->input->post('row_rate');
				$p_discount	        = $this->input->post('row_disc');
				$p_vat	        	= $this->input->post('p_vat');
				$fx_rate	        = $this->input->post('row_fxrate');
				$fx_disc	        = $this->input->post('fx_row_disc');
				$po_gross_amt       = 0;
				$po_discount        = 0;
				$po_vat_amt         = 0;
				$po_net_amt         = 0;
				for($i=0; $i<$loop_count; $i++){
					$chk_loop	    =	$p_description[$i];
					if($chk_loop!==''){
						if($p_discount[$i]==='') {
							$total2	=	$p_qty[$i]*$p_rate[$i];
						} else {
							$total2	=	$p_qty[$i]*$p_rate[$i]-$p_discount[$i];
						}
					
						if($this->input->post('currency')!=1){ 
							$vat_amt = 0;
							if($fx_disc[$i]!='') {
								$p_fx_disc = $fx_disc[$i];
								$fx_amount = ($p_qty[$i]*$fx_rate[$i])-$fx_disc[$i];
								$fx_net_amount = ($p_qty[$i]*$fx_rate[$i])-$fx_disc[$i];
							} else {
								$p_fx_disc = 0;
								$fx_amount = ($p_qty[$i]*$fx_rate[$i]);
								$fx_net_amount = $p_qty[$i]*$fx_rate[$i];
							}
							
						} else {
							if($fx_disc[$i]!='') {
								$p_fx_disc = $fx_disc[$i];
								$fx_amount = ($p_qty[$i]*$fx_rate[$i])-$fx_disc[$i];
							} else {
								$p_fx_disc = 0;
								$fx_amount = ($p_qty[$i]*$fx_rate[$i]);
							}
							
							if(@$p_vat[$i] == ''){
								$vat_amt = 0;
							} else {
								$vat_amt = $p_vat[$i]/100;
							}
							$fx_net_amount = ($fx_amount)+(($fx_amount)*$vat_amt);
						}
						
						$p_description_idnbx= $p_description_id[$i];
						
						$data_array = array(
							'po_id' 	      => $purchase_id,
							'item_details_id' => $p_description_idnbx,
							'item_name_nbs'   => $p_description[$i],
							'item_description'=> $description[$i],
							'loc_id'          => $this->input->post('loc_id'),
							'item_qty' 		  => $p_qty[$i],
							'uom' 		      => $uom[$i],
							'item_fx_rate'    => $fx_rate[$i],
							'item_rate' 	  => $p_rate[$i],
							'item_disc' 	  => $p_discount[$i],
							'item_amount' 	  => (($p_qty[$i]*$p_rate[$i])-(float)$p_discount[$i]),
							'item_vat_per' 	  => $vat_amt,
							'item_vat' 		  => ($total2)*$vat_amt,
							'net_amount' 	  => ($total2)+(($total2)*$vat_amt),
							'pr_d_id' 	      => $pr_d_id[$i],
							'fx_disc' 	  	  => $fx_disc[$i],
							'fx_amount' 	  => $fx_amount,
							'fx_net_amount'   => $fx_net_amount,
							'status'          => 1
						);

						$awhere=array(
							'po_b_id'=> $po_b_id[$i]
						);
						$this->db->update('po_b', $data_array,$awhere);
					}
				}
				$this->furniture_quotation_model->update_purchase_order_total($purchase_id);
				$log_data=array(
					'trans_no'     => $this->input->post('po_code'),
					'trans_type'   => 'Purchase Order',
					'trans_op'     => 'Edit',
					'trans_user_id'=> $this->session->userdata('user_id')	
				);
				$log_for_transactions	=	$this->crud_model->insert('log_for_transactions',$log_data);
			}
	
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				redirect("furniture/PurchaseOrder/listPurchaseOrder");
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'Updated...');
				redirect("furniture/PurchaseOrder/edit_po_from_request/".$purchase_id);
			}
		}
	}


	public function po_from_request($pr_id) {
		if($this->users_model->check_permission("PurchaseOrderInventory","Add")==false && $this->users_model->check_permission("PurchaseOrderJob","Add")==false && $this->users_model->check_permission("PurchaseOrderOthers","Add")==false){ 
			$red=$this->session->userdata("default_controller_name");
			$this->session->set_flashdata('response','You do not have permission to access this page.Please contact administrator.');
            redirect($red);
		}
		$title['headerTitle']="Purchase Order Create";
		$this->form_validation->set_rules('row_item_name[]', 'Product', 'required');
		$this->form_validation->set_rules('dep_id', 'Department', 'required');
		
		$data['dbdata']        = $this->Job_card_model->purchaseRequestRow($pr_id);
        if ($this->form_validation->run() == FALSE){
			$data['currency']=$this->Job_card_model->currency();
    		$data['details']    = $this->Job_card_model->purchaseRequestDetails($pr_id);
			$job_card_id    = $this->input->post('job_card_id');
		
			$client    = $this->input->post('client');
		
			$this->load->model('proforma_model');
			$data['client_det']=$client;
			$data['client_det_id']=$this->input->post('client_id');
			
			$list2 = $this->crud_model->get_list2('department_id','department_name','department_master',array(''=>' - Select - '),array('status'=>1));
			$data['department_list'] = $list2;

			$division_id = $data['dbdata']->division_id;
			$list = $this->crud_model->get_list2('division_id','division_name','company_division',array(),array('division_id'=>$division_id));
			$data['division_list'] = $list;
			$nn=$this->Job_card_model->purchaseNumber($division_id);
			$data['purchaseNumber'] = $this->Job_card_model->get_purchase_order_no($nn,$division_id);

			if($this->furniture_quotation_model->config($division_id)){
				$config_data=$this->furniture_quotation_model->config($division_id);
				$data['is_quote_from_master'] = $config_data->is_quote_from_master;
				$data['is_estimate'] = $config_data->is_estimate;
				$data['is_approve'] = $config_data->is_approve;
				$data['is_bom'] = $config_data->is_bom;
				$data['is_optional_item_level'] = $config_data->is_optional_item_level;
				$data['is_category'] = $config_data->is_category;
			} else {
				$data['is_quote_from_master'] = 0;
				$data['is_estimate'] = 0;
				$data['is_approve'] = 0;
				$data['is_bom'] = 0;
				$data['is_optional_item_level'] = 0;
				$data['is_category'] = 0;
			}

			$qt_date=date("Y-m-d");
			$data['vat_percentage_array']=$this->furniture_quotation_model->vat_applicable2($qt_date);
			$unit_list = $this->crud_model->get_list('unit_name','unit_name','unit_master',array(''=>' - Select - '));
			$data['unit_list'] = $unit_list;
			$header_ledger_list = $this->crud_model->get_list('ledger_code', 'ledger_name', 'ledgers', array('' => ' - Select - '), array('acoount_group_id' => 22));
			$data['header_ledger_list'] = $header_ledger_list;
			$this->load->view('templates/header',$title);
			$this->load->view('furniture/quotations/purchaseorder/po_from_request',$data);
			$this->load->view('templates/footer');
        } else {
			
	
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				redirect("furniture/PurchaseRequest/listPurchaseRequest");
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'Rate Updated');
				redirect("furniture/PurchaseRequest/updateRate/".$pr_id);
			}
		}
	}

	public function do_insert_po_from_request($pr_id) {
		if($this->users_model->check_permission("PurchaseOrderInventory","Add")==false && $this->users_model->check_permission("PurchaseOrderJob","Add")==false && $this->users_model->check_permission("PurchaseOrderOthers","Add")==false){ 
			$red=$this->session->userdata("default_controller_name");
			$this->session->set_flashdata('response','You do not have permission to access this page.Please contact administrator.');
            redirect($red);
		}
    	$this->form_validation->set_rules('supplier_id', 'Supplier', 'required');
		$this->form_validation->set_rules('pr_id', 'PR No', 'required');
		if($this->input->post('po_type')==='Job'){
			$this->form_validation->set_rules('job_id', 'Job No', 'required');
		}
        if ($this->form_validation->run() == FALSE){
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			redirect('furniture/PurchaseOrder/po_from_request/'.$pr_id);
        } else {
	  		$user_id	=	$this->session->userdata('user_id');
			$this->db->trans_begin();
	 		$purchaseNumber= $this->Job_card_model->purchaseNumber($this->input->post('division'));
			$po_code= $this->Job_card_model->get_purchase_order_no($purchaseNumber,$this->input->post('division'));
			$data = array( 
				'po_number'         => $purchaseNumber,
				'po_code'       	=> $po_code,
				'po_date'           => date("Y-m-d"),
				'supplier_id'       => $this->input->post('supplier_id'),
				'pr_id'        		=> $this->input->post('pr_id'),
				'division_id'       => $this->input->post('division'),
				'supplier_reference'=> $this->input->post('supplier_ref'),
				'job_id'            => $this->input->post('job_id'),
				'loc_id'            => $this->input->post('loc_id'),
				'currency_id'       => $this->input->post('currency'),
				'exchange_rate'     => $this->input->post('exchange_rate'),
				'po_type'       	=> $this->input->post('po_type'),
				'rfq_number'        => $this->input->post('purchase_request'),
				'payment_mode'      => 'Cash',
				'delivery_address'  => $this->input->post('supply_address'),
				'delivery_terms'    => $this->input->post('delivery_terms'),
				'user_id'           => $user_id,
				'status'            => 'Draft'
			);	
			$this->db->insert('po_h', $data);
			$insert_id = $this->db->insert_id();
	
			if($insert_id){
				$loop_count			= count($this->input->post('row_item_name'));
				$pr_d_id			= $this->input->post('row_pr_d_id');
				$p_description_id	= $this->input->post('row_item_id');
				$p_description	    = $this->input->post('row_item_name');
				$description	    = $this->input->post('row_description');
				$p_qty	            = $this->input->post('row_qty');
				$uom	            = $this->input->post('row_uom');
				$p_rate	            = $this->input->post('row_rate');
				$p_discount	        = $this->input->post('row_disc');
				$p_vat	        	= $this->input->post('p_vat');
				$fx_rate	        = $this->input->post('row_fxrate');
				$fx_disc	        = $this->input->post('fx_row_disc');
				$po_gross_amt       = 0;
				$po_discount        = 0;
				$po_vat_amt         = 0;
				$po_net_amt         = 0;
				for($i=0; $i<$loop_count; $i++){
					$chk_loop	    =	$p_description[$i];
					if($chk_loop!==''){
						if($p_discount[$i]==='') {
							$total2	=	$p_qty[$i]*$p_rate[$i];
						} else {
							$total2	=	$p_qty[$i]*$p_rate[$i]-$p_discount[$i];
						}
					
						if($this->input->post('currency')!=1){ 
							$vat_amt = 0;
							if($fx_disc[$i]!='') {
								$p_fx_disc = $fx_disc[$i];
								$fx_amount = ($p_qty[$i]*$fx_rate[$i])-$fx_disc[$i];
								$fx_net_amount = ($p_qty[$i]*$fx_rate[$i])-$fx_disc[$i];
							} else {
								$p_fx_disc = 0;
								$fx_amount = ($p_qty[$i]*$fx_rate[$i]);
								$fx_net_amount = $p_qty[$i]*$fx_rate[$i];
							}
							
						} else {
							if($fx_disc[$i]!='') {
								$p_fx_disc = $fx_disc[$i];
								$fx_amount = ($p_qty[$i]*$fx_rate[$i])-$fx_disc[$i];
							} else {
								$p_fx_disc = 0;
								$fx_amount = ($p_qty[$i]*$fx_rate[$i]);
							}
							
							if(@$p_vat[$i] == ''){
								$vat_amt = 0;
							} else {
								$vat_amt = $p_vat[$i]/100;
							}
							$fx_net_amount = ($fx_amount)+(($fx_amount)*$vat_amt);
						}
						if($p_qty[$i]>0){
							$p_description_idnbx= $p_description_id[$i];
							
							$data_array = array(
								'po_id' 	      => $insert_id,
								'item_details_id' => $p_description_idnbx,
								'item_name_nbs'   => $p_description[$i],
								'item_description'=> $description[$i],
								'loc_id'          => $this->input->post('loc_id'),
								'item_qty' 		  => $p_qty[$i],
								'uom' 		      => $uom[$i],
								'item_fx_rate'    => $fx_rate[$i],
								'item_rate' 	  => $p_rate[$i],
								'item_disc' 	  => $p_discount[$i],
								'item_amount' 	  => (($p_qty[$i]*$p_rate[$i])-(float)$p_discount[$i]),
								'item_vat_per' 	  => $vat_amt,
								'item_vat' 		  => ($total2)*$vat_amt,
								'net_amount' 	  => ($total2)+(($total2)*$vat_amt),
								'pr_d_id' 	      => $pr_d_id[$i],
								'fx_disc' 	  	  => $fx_disc[$i],
								'fx_amount' 	  => $fx_amount,
								'fx_net_amount'   => $fx_net_amount,
								'status'          => 1
							);
							$this->db->insert('po_b', $data_array);
						}
					}
				}
				$this->furniture_quotation_model->update_purchase_order_total($insert_id);
				$log_data=array(
					'trans_no'     => $po_code,
					'trans_type'   => 'Purchase Order',
					'trans_op'     => 'Create',
					'trans_user_id'=> $this->session->userdata('user_id')	
				);
				$log_for_transactions	=	$this->crud_model->insert('log_for_transactions',$log_data);
			}
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				redirect("furniture/PurchaseOrder/listPurchaseOrder");
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'Purchase Order Created Successfully');
				redirect("furniture/PurchaseOrder/edit_po_from_request/".$insert_id);
			}
		}
	}


	function create_purchase_order($client="") {
		$this->users_model->permission("PurchaseOrderInventory", "Add");
		$title['headerTitle']="Purchase Order Create";
		$job_card_id    = $this->input->post('job_card_id');
		$client    = $this->input->post('client');
		$this->load->view('templates/header',$title);
		$this->load->model('proforma_model');
		$data['currency']=$this->Job_card_model->currency();
		$data['results'] = $this->proforma_model->selectcount();
		$data['h']=$this->proforma_model->list_details($job_card_id);
		$data['detail']=$this->proforma_model->getonerow($job_card_id);
		$data['sumdetail']=$this->proforma_model->getsumrow($job_card_id,$client);
		$data['client_det']=$client;
		$data['client_det_id']=$this->input->post('client_id');
		$list = $this->crud_model->get_list('division_id','division_name','company_division',array(''=>' - Select - '));
		$data['division_list'] = $list;
		$list2 = $this->crud_model->get_list('loc_id','loc_name','location_master',array(''=>' - Select - '));
		$data['location_list'] = $list2;
		$nn=$this->Job_card_model->purchaseNumber(1);
		$data['purchaseNumber'] = $this->Job_card_model->get_purchase_order_no($nn,1);

		if($this->furniture_quotation_model->config(1)){
			$config_data=$this->furniture_quotation_model->config(1);
			$data['is_quote_from_master'] = $config_data->is_quote_from_master;
			$data['is_estimate'] = $config_data->is_estimate;
			$data['is_approve'] = $config_data->is_approve;
			$data['is_bom'] = $config_data->is_bom;
			$data['is_optional_item_level'] = $config_data->is_optional_item_level;
			$data['is_category'] = $config_data->is_category;
		} else {
			$data['is_quote_from_master'] = 0;
			$data['is_estimate'] = 0;
			$data['is_approve'] = 0;
			$data['is_bom'] = 0;
			$data['is_optional_item_level'] = 0;
			$data['is_category'] = 0;
		}

		$qt_date=date("Y-m-d");
		$data['vat_percentage_array']=$this->furniture_quotation_model->vat_applicable2($qt_date);

		$unit_list = $this->crud_model->get_list('unit_name','unit_name','unit_master',array(''=>' - Select - '));
		$data['unit_list'] = $unit_list;
		$data['p_order_type']="Inventory";

		$header_ledger_list = $this->crud_model->get_list('ledger_code', 'ledger_name', 'ledgers', array('' => ' - Select - '), array('acoount_group_id' => 22));
		$data['header_ledger_list'] = $header_ledger_list;

		$this->load->view('furniture/quotations/purchaseorder/create_purchase_order',$data);
		$this->load->view('templates/footer');
	}

	function create_purchase_order_job($client="") {
		$this->users_model->permission("PurchaseOrderJob", "Add");
		$title['headerTitle']="Purchase Order Create";
		$job_card_id    = $this->input->post('job_card_id');
		$client    = $this->input->post('client');
		$this->load->view('templates/header',$title);
		$this->load->model('proforma_model');
		$data['currency']=$this->Job_card_model->currency();
		$data['results'] = $this->proforma_model->selectcount();
		$data['h']=$this->proforma_model->list_details($job_card_id);
		$data['detail']=$this->proforma_model->getonerow($job_card_id);
		$data['sumdetail']=$this->proforma_model->getsumrow($job_card_id,$client);
		$data['client_det']=$client;
		$data['client_det_id']=$this->input->post('client_id');
		$list = $this->crud_model->get_list('division_id','division_name','company_division',array(''=>' - Select - '));
		$data['division_list'] = $list;
		$list2 = $this->crud_model->get_list('loc_id','loc_name','location_master',array(''=>' - Select - '));
		$data['location_list'] = $list2;
		$nn=$this->Job_card_model->purchaseNumber(1);
		$data['purchaseNumber'] = $this->Job_card_model->get_purchase_order_no($nn,1);

		if($this->furniture_quotation_model->config(1)){
			$config_data=$this->furniture_quotation_model->config(1);
			$data['is_quote_from_master'] = $config_data->is_quote_from_master;
			$data['is_estimate'] = $config_data->is_estimate;
			$data['is_approve'] = $config_data->is_approve;
			$data['is_bom'] = $config_data->is_bom;
			$data['is_optional_item_level'] = $config_data->is_optional_item_level;
			$data['is_category'] = $config_data->is_category;
		} else {
			$data['is_quote_from_master'] = 0;
			$data['is_estimate'] = 0;
			$data['is_approve'] = 0;
			$data['is_bom'] = 0;
			$data['is_optional_item_level'] = 0;
			$data['is_category'] = 0;
		}

		$qt_date=date("Y-m-d");
		$data['vat_percentage_array']=$this->furniture_quotation_model->vat_applicable2($qt_date);

		$unit_list = $this->crud_model->get_list('unit_name','unit_name','unit_master',array(''=>' - Select - '));
		$data['unit_list'] = $unit_list;
		$data['p_order_type']="Job";

		$header_ledger_list = $this->crud_model->get_list('ledger_code', 'ledger_name', 'ledgers', array('' => ' - Select - '), array('acoount_group_id' => 22));
		$data['header_ledger_list'] = $header_ledger_list;

		$this->load->view('furniture/quotations/purchaseorder/create_purchase_order',$data);
		$this->load->view('templates/footer');
	}
	function create_purchase_order_others($client="") {
		$this->users_model->permission("PurchaseOrderOthers", "Add");
		$title['headerTitle']="Purchase Order Create";
		$job_card_id    = $this->input->post('job_card_id');
		$client    = $this->input->post('client');
		$this->load->view('templates/header',$title);
		$this->load->model('proforma_model');
		$data['currency']=$this->Job_card_model->currency();
		$data['results'] = $this->proforma_model->selectcount();
		$data['h']=$this->proforma_model->list_details($job_card_id);
		$data['detail']=$this->proforma_model->getonerow($job_card_id);
		$data['sumdetail']=$this->proforma_model->getsumrow($job_card_id,$client);
		$data['client_det']=$client;
		$data['client_det_id']=$this->input->post('client_id');
		$list = $this->crud_model->get_list('division_id','division_name','company_division',array(''=>' - Select - '));
		$data['division_list'] = $list;
		$list2 = $this->crud_model->get_list('loc_id','loc_name','location_master',array(''=>' - Select - '));
		$data['location_list'] = $list2;
		$nn=$this->Job_card_model->purchaseNumber(1);
		$data['purchaseNumber'] = $this->Job_card_model->get_purchase_order_no($nn,1);

		if($this->furniture_quotation_model->config(1)){
			$config_data=$this->furniture_quotation_model->config(1);
			$data['is_quote_from_master'] = $config_data->is_quote_from_master;
			$data['is_estimate'] = $config_data->is_estimate;
			$data['is_approve'] = $config_data->is_approve;
			$data['is_bom'] = $config_data->is_bom;
			$data['is_optional_item_level'] = $config_data->is_optional_item_level;
			$data['is_category'] = $config_data->is_category;
		} else {
			$data['is_quote_from_master'] = 0;
			$data['is_estimate'] = 0;
			$data['is_approve'] = 0;
			$data['is_bom'] = 0;
			$data['is_optional_item_level'] = 0;
			$data['is_category'] = 0;
		}

		$qt_date=date("Y-m-d");
		$data['vat_percentage_array']=$this->furniture_quotation_model->vat_applicable2($qt_date);

		$unit_list = $this->crud_model->get_list('unit_name','unit_name','unit_master',array(''=>' - Select - '));
		$data['unit_list'] = $unit_list;
		$data['p_order_type']="Others";

		$header_ledger_list = $this->crud_model->get_list('ledger_code', 'ledger_name', 'ledgers', array('' => ' - Select - '), array('acoount_group_id' => 22));
		$data['header_ledger_list'] = $header_ledger_list;

		$this->load->view('furniture/quotations/purchaseorder/create_purchase_order',$data);
		$this->load->view('templates/footer');
	}

	function search_job() {
	
		$search_name = trim($this->input->post('quotation_number_new_one'));
		$search_name1 = trim($this->input->post('textfield2'));
		
		$like=null;
		$array = explode("-",$search_name.'-0');
		//,'division_code'=>$array[0]
		$like=array('job_card_number'=>$array[1]);
		//$or_like=array('quotation_number'=>$search_name);,'is_invoice'=>0
		$where=array('job_card_divisionid'=>$search_name1);
		//$where=array();
		$records['quotation_list']=$this->crud_model->get('view_furniture_job_card',
				$where,
				null,
				null,
				null,
				null,
				$like,
				null,null);
					
		if($records['quotation_list'] == false ){
			echo 0;
		} else {
			$records=html_escape($records);
			$this->load->view('furniture/quotations/proforma_search_result', $records);
			
		}
		
	}

	public function po_delete(){
		if($this->users_model->check_permission("PurchaseOrderInventory","Delete")==false && $this->users_model->check_permission("PurchaseOrderJob","Delete")==false && $this->users_model->check_permission("PurchaseOrderOthers","Delete")==false){ 
			$red=$this->session->userdata("default_controller_name");
			$this->session->set_flashdata('response','You do not have permission to access this page.Please contact administrator.');
            redirect($red);
		}
		$po_id = trim($this->input->post('po_id'));
		$po_code = trim($this->input->post('po_code'));
		$reason_forclose = trim($this->input->post('reason_forclose'));
		if($po_id!=0 && $po_id!='' && $po_code!=''){
			$update_data = array(
				'status'      => 'Cancel',
				'reason_for_close' => $reason_forclose,
				'cancelled_user'   => $this->session->userdata('user_name'),
				'cancelled_date'   => date('Y-m-d h:m:s'),
			);
			$this->db->where('po_id', $po_id);
			$this->db->update('po_h', $update_data);

			$log_data=array(
				'trans_no'  	=>  $po_code,
				'trans_type'	=>  'Purchase Order',
				'trans_op'  	=>  'Delete',
				'trans_user_id' =>  $this->session->userdata('user_id')
			);
			$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);

			$this->session->set_flashdata('response', 'Cancelled...');
			redirect('furniture/PurchaseOrder/listPurchaseOrder');
		} else {
			$this->session->set_flashdata('response', 'Something went wrong...');
			redirect('furniture/PurchaseOrder/listPurchaseOrder');
		}
	}

	public function po_item_delete($po_b_id,$po_id){
		$this->db->where("po_b_id",$po_b_id);
		$this->db->delete('po_b');
		$this->furniture_quotation_model->update_purchase_order_total($po_id);
		$this->session->set_flashdata('response', 'Deleted...');
		redirect('furniture/PurchaseOrder/editPurchaseOrder/'.$po_id);
	}

	public function create_purchase_order_directJobcard($id = '', $rfq_id = '',$suplier_id = '', $divisionid = ''){
		$this->users_model->permission("PurchaseOrderJob", "Add");
		$checkPodata = $this->Vehicle->CheckPORowData($id, $suplier_id);
		//$getPoitmCnt = $this->Vehicle->getPoItemRowcnt($rfq_id, $checkPodata->po_number);
		$getRfqItmCnt = $this->Vehicle->getRfqItemRow($rfq_id);
		//echo $getPoitmCnt->po_qty; echo$getRfqItmCnt->qty; exit();
		//&& $checkPodata == false || $checkPodata == 0 || $checkPodata == NULL
		//if($getPoitmCnt->po_qty <= $getRfqItmCnt->qty ){
			$dataRow  = $this->Vehicle->getRFQDataPO($id ,$suplier_id);
			if(!empty($dataRow) || $dataRow != false){
				$this->db->trans_begin();
				$purchaseNumber= $this->Job_card_model->purchaseNumber($divisionid);
				$po_code = $this->Job_card_model->get_purchase_order_no($purchaseNumber,$divisionid);
				$user_id	=	$this->session->userdata('user_id');
				$data = array( 
					'po_number'         => $purchaseNumber,
					'po_code'       	=> $po_code,
					'po_date'           => date("Y-m-d"),
					'supplier_id'       => $suplier_id,
					'pr_id'        		=> '',
					'division_id'       => $divisionid,
					'job_id'            => $id,
					'loc_id'            => 0,
					'poh_ledger_code'   => 'CA001',
					'currency_id'       => 1,
					'exchange_rate'     => 1,
					'po_type'       	=> 'Job',
					'rfq_number'        => $this->input->post('purchase_request'),
					'payment_mode'      => 'Cash',
					'delivery_address'  => '',
					'delivery_terms'    => '',
					'user_id'           => $user_id,
					'status'            => 'Draft',
					'po_create_type'    =>1
				);	
				$this->db->insert('po_h', $data);
				$insert_id = $this->db->insert_id();
				if($insert_id){
					$po_h_totalamount = $po_h_totalvatamount = $po_h_nettotal = 0;
					foreach($dataRow AS $rec){
							$dataquotRaw  = $this->Vehicle->getRowQuotDataPO($id,$rec['job_detail_id']);
							$getRfqItmCnt = $this->Vehicle->getRfqItemRow($rec['rfq_id']);
							if($dataquotRaw != false){
								if($getRfqItmCnt->po_rfq_qty != NULL || !empty($getRfqItmCnt->po_rfq_qty)){
									$po_rfq_qty = $getRfqItmCnt->po_rfq_qty;
								}
								else{
									$po_rfq_qty = 0;
								}
								if($getRfqItmCnt->qty != $po_rfq_qty){							
									//if($this->input->post('currency')!=1){ 
									// 	$vat_amt = 0;
									// 	if($fx_disc[$i]!='') {
									// 		$p_fx_disc = $fx_disc[$i];
									// 		$fx_amount = ($p_qty[$i]*$fx_rate[$i])-$fx_disc[$i];
									// 		$fx_net_amount = ($p_qty[$i]*$fx_rate[$i])-$fx_disc[$i];
									// 	} else {
									// 		$p_fx_disc = 0;
									// 		$fx_amount = ($p_qty[$i]*$fx_rate[$i]);
									// 		$fx_net_amount = $p_qty[$i]*$fx_rate[$i];
									// 	}
										
									// } else {
									// 	if($fx_disc[$i]!='') {
									// 		$p_fx_disc = $fx_disc[$i];
									// 		$fx_amount = ($p_qty[$i]*$fx_rate[$i])-$fx_disc[$i];
									// 	} else {
									// 		$p_fx_disc = 0;
									// 		$fx_amount = ($p_qty[$i]*$fx_rate[$i]);
									// 	}
										
									// 	if(@$p_vat[$i] == ''){
									// 		$vat_amt = 0;
									// 	} else {
									// 		$vat_amt = $p_vat[$i]/100;
									// 	}
									// 	$fx_net_amount = ($fx_amount)+(($fx_amount)*$vat_amt);
									// }
							
									$item_rate = $dataquotRaw->furniture_amount;
									//$item_discount = $dataquotRaw->item_discount;
									$qty = $getRfqItmCnt->qty - $po_rfq_qty;
									$item_discount = 0;
									$item_amount = ($qty * $item_rate) - $item_discount;
									//$vat_amt = $dataquotRaw->vat_perce/100;
									$vat_amt = 10/100;
									$item_vat = $item_amount * $vat_amt;
									$net_amount = $item_vat + $item_amount;								
									$data_array = array(
										'po_id' 	      => $insert_id,
										'job_id'          => $id,
										'po_ledger_code'  => 'P0001',
										'item_details_id' => 0,
										'item_name_nbs'   => $rec['item_name'],
										'item_name_purchase'=> $rec['item_name'],
										'item_description'=> '',
										'loc_id'          => 0,
										'item_qty' 		  => ($getRfqItmCnt->qty - $po_rfq_qty),
										'uom' 		      => $rec['uom_name'],
										'uom_id' 		  => $rec['uom_id'],
										'b_uom' 		  => $rec['uom_id'],
										'b_uom_qty' 	  => ($getRfqItmCnt->qty - $po_rfq_qty),
										'b_uom_conv' 	  => 1,
										'b_uom_rate' 	  => $item_rate,
										'item_fx_rate'    => $item_rate,
										'item_rate' 	  => $item_rate,
										'item_disc' 	  => $item_discount,
										'item_amount' 	  => $item_amount,
										'item_vat_per' 	  => $vat_amt,
										'item_vat' 		  => $item_vat,
										'net_amount' 	  => $net_amount,
										'pr_d_id' 	      => 0,
										'fx_disc' 	  	  => $item_discount,
										'fx_amount' 	  => $item_amount,
										'fx_net_amount'   => $net_amount,
										'status'          => 1,
										'job_detail_id'   => $rec['job_detail_id'],
										'rfq_id'		  => $rec['rfq_id']
									);
									$this->db->insert('po_b', $data_array);
									$po_h_totalamount += $item_amount;
									$po_h_totalvatamount += $item_vat;
									$po_h_nettotal += $net_amount;
								}
							}
							// $rfq_where = array(
							// 	'job_id'         => $rec['rfq_id'],
							// 	'job_id'         => $id,
							// 	'job_detail_id'  => $rec['job_detail_id'],							
							// );
							// $rfq_data = array(
							// 	'po_number'	     => $insert_id,
							// );
							// $this->crud_model->update('rfq',$rfq_data,$rfq_where); 
					}					
					$po_h_where = array(
						'po_id' => $insert_id
					);
					$po_h_update_data = array(
						'po_gross_amt'  => $po_h_totalamount,
						'po_vat_amt'	=> $po_h_totalvatamount,
						'po_net_amt'	=> $po_h_nettotal,
						'fx_po_gross_amt'  => $po_h_totalamount,
						'fx_po_net_amt'	=> $po_h_nettotal
					);
					$this->crud_model->update('po_h',$po_h_update_data,$po_h_where); 					
				}
				$log_data=array(
					'trans_no'     => $po_code,
					'trans_type'   => 'Purchase Order',
					'trans_op'     => 'Create',
					'trans_user_id'=> $this->session->userdata('user_id')	
				);
				$log_for_transactions	=	$this->crud_model->insert('log_for_transactions',$log_data);
				if ($this->db->trans_status() === FALSE) {
					$this->db->trans_rollback();
					$this->session->set_flashdata('response', 'OOPS!!!...Something WentWrong.Please Try Again.');
					redirect('jobcard/Vehicle_jobcard/editVjobcard/'.$id.'');		
				} else {
					$this->db->trans_commit();
					$this->session->set_flashdata('success', 'Purchase Order Created Successfully');
					redirect("furniture/PurchaseOrder/editPurchaseOrderJob/".$insert_id);
				}
			}
		// }
		// else {
		// 	$this->db->trans_commit();
		// 	redirect("furniture/PurchaseOrder/editPurchaseOrderJob/".$checkPodata->po_id);
		// }		
	}

	public function editPurchaseOrderJob($purchase_id,$po_b_id='') {		
		if($this->users_model->check_permission("PurchaseOrderInventory","Edit")==false && $this->users_model->check_permission("PurchaseOrderJob","Edit")==false && $this->users_model->check_permission("PurchaseOrderOthers","Edit")==false){ 
			$red=$this->session->userdata("default_controller_name");
			$this->session->set_flashdata('response','You do not have permission to access this page.Please contact administrator.');
            redirect($red);
		}
		$title['headerTitle']="Purchase Order Edit";
		$this->form_validation->set_rules('supplier_id', 'Supplier', 'required');
		$this->form_validation->set_rules('po_date', 'Date', 'required');
		//$this->form_validation->set_rules('p_description[]', 'Product', 'required');
		$this->form_validation->set_rules('payment_mode', 'Payment Mode', 'required');
		$data['select_html'] = '';
		if($this->input->post('payment_mode')==='Cash'){
			$this->form_validation->set_rules('header_ledger_code', 'Ledger', 'required');
		}
		$unitmaster = $this->crud_model->get('unit_master');
		$data['unitmaster']  =  $unitmaster;
		$data['row']        = $this->Job_card_model->purchaseOrderRow($purchase_id);
        if ($this->form_validation->run() == FALSE){
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');	
    		$data['details']    = $this->Job_card_model->purchaseOrderDetails($purchase_id);
			$unit_list = $this->crud_model->get('unit_master');
		    $data['unit_master'] = $unit_list;
			$data['currency']=$this->Job_card_model->currency();
			$list = $this->crud_model->get_list('division_id','division_name','company_division',array(''=>' - Select - '));
			$data['division_list'] = $list;
			$list2 = $this->crud_model->get_list('loc_id','loc_name','location_master',array(''=>' - Select - '));
			$data['location_list'] = $list2;
			$division_id	=	$data['row']->division_id;
			if($this->furniture_quotation_model->config($division_id)){
				$config_data=$this->furniture_quotation_model->config($division_id);
				$data['is_quote_from_master'] = $config_data->is_quote_from_master;
				$data['is_estimate'] = $config_data->is_estimate;
				$data['is_approve'] = $config_data->is_approve;
				$data['is_bom'] = $config_data->is_bom;
				$data['is_optional_item_level'] = $config_data->is_optional_item_level;
				$data['is_category'] = $config_data->is_category;
			} else {
				$data['is_quote_from_master'] = 0;
				$data['is_estimate'] = 0;
				$data['is_approve'] = 0;
				$data['is_bom'] = 0;
				$data['is_optional_item_level'] = 0;
				$data['is_category'] = 0;
			}
			if($data['details'] != false){
				$Rfq_data = array('rfq_qty' => '', 'rfq_id' => '', 'po_rfq_qty');
				foreach($data['details'] as $rec){
					$rfq_datarow = $this->Vehicle->getRfqItemRow($rec['rfq_id']);
					if($rfq_datarow  != false){
						$Rfq_data['rfq_qty'] = $rfq_datarow->qty;
						$Rfq_data['rfq_id'] = $rfq_datarow->rfq_id;
						$Rfq_data['po_rfq_qty'] = $rfq_datarow->po_rfq_qty;
					}
					else{
						$Rfq_data['rfq_qty'] = '';
						$Rfq_data['rfq_id'] = '';
						$Rfq_data['po_rfq_qty'] = '';
					}
					$data['refqadata_qty'][] = $Rfq_data;
				}
			}

			$qt_date=date("Y-m-d");
			$data['vat_percentage_array']=$this->furniture_quotation_model->vat_applicable2($qt_date);
			$unit_list = $this->crud_model->get_list('unit_name','unit_name','unit_master',array(''=>' - Select - '));
			$data['unit_list'] = $unit_list;			
			$header_ledger_list = $this->crud_model->get_list('ledger_code', 'ledger_name', 'ledgers', array('' => ' - Select - '), array('acoount_group_id' => 22));
			$data['header_ledger_list'] = $header_ledger_list;
			$this->load->view('templates/header',$title);
			$this->load->view('furniture/quotations/purchaseorder/editPurchaseOrder_directjob',$data);
			$this->load->view('templates/footer');
        } else { 
			$po_date			=	date("Y-m-d", strtotime($this->input->post('po_date')));
	  		$user_id	=	$this->session->userdata('user_id');
			$this->db->trans_begin();
			$data = array( 
				'supplier_id'       => $this->input->post('supplier_id'),
				'po_date'      		=> $po_date,
				'division_id'       => $this->input->post('division'),
				'supplier_reference'=> $this->input->post('supplier_ref'),
				'currency_id'       => $this->input->post('currency'),
				'rfq_number'        => NULL,
				'payment_mode'      => $this->input->post('payment_mode'),
				'delivery_address'  => $this->input->post('supply_address'),
				'delivery_terms'    => $this->input->post('delivery_terms'),
				'poh_ledger_code'   => @$this->input->post('header_ledger_code'),
				'user_id'           => $user_id,
				'status'            => 'Draf'
			);
			
			$this->db->where('po_id', $purchase_id);
			$this->db->update('po_h', $data);
			$po_b_id  = $this->input->post('po_b_id');
			//var_dump($po_b_id);exit();
			if(!empty($po_b_id)){
			//	echo 'ss'; exit();
 				$p_qty	          =	$this->input->post('p_qty');
				$p_rate	          =	$this->input->post('p_rate');
 				$p_discount	      =	$this->input->post('p_discount');
				$p_vat	          =	$this->input->post('p_vat');
				$fx_rate	      =	$this->input->post('fx_rate');
 				$fx_disc	      = $this->input->post('fx_disc');
 				$fx_disc	      = $this->input->post('fx_disc');
 				$po_rfq_qty	      = $this->input->post('po_rfq_qty');
 				$rfq_qty	      = $this->input->post('rfq_qty');
 				$po_gross_amt     = 0;
				$po_discount      = 0;
				$po_vat_amt       = 0;
				$po_net_amt       = 0;
				
				for($i=0; $i<count($po_b_id); $i++){
					$chk_loop	    =	$po_b_id[$i];	
					$balance_qty =  $rfq_qty[$i] - $po_rfq_qty[$i];
								
					if($chk_loop!==''){
						// if($p_qty[$i] > $balance_qty )	{
						// 	$po_qty = $balance_qty;
						// }
						// else{
						// 	$po_qty = $p_qty[$i];
						// }	
						
						$po_qty = $p_qty[$i];
						if($p_discount[$i]==='') {
							$total2	=	round($po_qty*$p_rate[$i],3);
						} else {
							$total2	=	round($po_qty*$p_rate[$i],3)-(float)$p_discount[$i];
						}					
						if($this->input->post('currency')!=1){ 
							$vat_amt = 0;
							if($fx_disc[$i]!='') {
								$p_fx_disc = $fx_disc[$i];
								$fx_amount = ($po_qty*$fx_rate[$i])-$fx_disc[$i];
								$fx_net_amount = ($po_qty*$fx_rate[$i])-$fx_disc[$i];
							} else {
								$p_fx_disc = 0;
								$fx_amount = ($po_qty*$fx_rate[$i]);
								$fx_net_amount = $po_qty*$fx_rate[$i];
							}							
						} else {
							if($fx_disc[$i]!='') {
								$p_fx_disc = $fx_disc[$i];
								$fx_amount = ($po_qty*$fx_rate[$i])-$fx_disc[$i];
							} else {
								$p_fx_disc = 0;
								$fx_amount = ($po_qty*$fx_rate[$i]);
							}
							
							if(@$p_vat[$i] == ''){
								$vat_amt = 0;
							} else {
								$vat_amt = $p_vat[$i]/100;
							}
							$fx_net_amount = ($fx_amount)+(($fx_amount)*$vat_amt);
						}
						$data_array = array(
            				'item_qty' 	       => $po_qty,
            				'b_uom_qty' 	   => $po_qty,
            				'item_fx_rate' 	   => $fx_rate[$i],
			  				'item_rate' 	   => $p_rate[$i],
			 				'item_disc' 	   => $p_discount[$i],
							'item_amount' 	   => $total2,
							'item_vat_per' 	   => $vat_amt,
 							'item_vat' 		   => ($total2)*$vat_amt,
							'net_amount' 	   => ($total2)+(($total2)*$vat_amt),
							'fx_disc' 	  	  => $fx_disc[$i],
							'fx_amount' 	  => $fx_amount,
							'fx_net_amount'   => $fx_net_amount,
  						);
						$where=array(
							'po_b_id'=> $po_b_id[$i]
						);
						$this->db->update('po_b', $data_array,$where);				
		  			}
				}
				$this->furniture_quotation_model->update_purchase_order_total($purchase_id);
				/*$log_data=array(
					'trans_no'     =>	$data['row']->po_code,
					'trans_type'   => 'Purchase Order',
					'trans_op'     => 'Edit',
					'trans_user_id'=> $this->session->userdata('user_id')	
				);
				$log_for_transactions	=	$this->crud_model->insert('log_for_transactions',$log_data);*/
	  		}
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				$this->session->set_flashdata('response', 'OOPS!!!...Something WentWrong.Please Try Again.');
						redirect('jobcard/Vehicle_jobcard/editPurchaseOrderJob/'.$purchase_id.'');	
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', '');
				redirect("furniture/PurchaseOrder/editPurchaseOrderJob/".$purchase_id);
			}
		}
	}

	public function do_update_discount_pojob($po_id) {
		$this->form_validation->set_rules('nb_po_id', 'Purchase Order', 'required');
		if ($this->form_validation->run() == FALSE)	{
			// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			redirect('furniture/PurchaseOrder/editPurchaseOrder/'.$po_id);
		} else {
			$dbdata = $this->Job_card_model->purchaseOrderRow($po_id);

			$data = array(
				'status'     => 'Confirmed',
				'po_discount'=> (float)$this->input->post('fx_po_discount')*$dbdata->exchange_rate,
				'po_vat_amt' => $this->input->post('total_vat'),
				'sign' 	  	 => $this->input->post('sign'),
				'round_off'  => (float)$this->input->post('round_off')*$dbdata->exchange_rate,
				'po_net_amt' => (float)$this->input->post('fx_po_net_amt')*$dbdata->exchange_rate,
				'fx_po_discount'=> $this->input->post('fx_po_discount'),
				'fx_po_gross_amt'=> $this->input->post('fx_po_gross_amt'),
				'fx_po_net_amt' => $this->input->post('fx_po_net_amt')
			);

			$where=array(
				'po_id'=> $po_id
			);
			$this->crud_model->update(' po_h',$data,$where );
			$job_id =  $this->input->post('mar_job_id');
			$check_job_item_qty = $this->furniture_quotation_model->getjobItemtTotalOrderQuantity($job_id);
			$check_po_item_qty = $this->furniture_quotation_model->getpurchaseTotalOrderQuantity($job_id);

			$check_job_stock_qty = $this->furniture_quotation_model->getjobItemtTotalStockQuantity($job_id);
			$check_mstock_item_qty = $this->furniture_quotation_model->getmaterialstockQuantity($job_id);
  

			$date = date("Y-m-d H:i:s");
			if($check_job_item_qty  == $check_po_item_qty){
				

				if($check_job_stock_qty != $check_mstock_item_qty ){
					$job_card_data= array(
						'jobcard_stage' =>21,			
					);
					$where_job_card = array(
						'id' => $job_id
					);
					$this->crud_model->update('job_card',$job_card_data,$where_job_card);
					$datajob_stage = array(
						'job_id' => $job_id,
						'user_id' => $this->session->userdata('user_id'),
						'log_date' => $date,
						'log_status' => 21,
					);
					$this->crud_model->insert('jobcard_track_log',$datajob_stage);		
				}
				else{
					$job_card_data= array(
						'jobcard_stage' =>25,			
					);
					$where_job_card = array(
						'id' => $job_id
					);
					$this->crud_model->update('job_card',$job_card_data,$where_job_card);
					$datajob_stage = array(
						'job_id' => $job_id,
						'user_id' => $this->session->userdata('user_id'),
						'log_date' => $date,
						'log_status' => 25,
					);
					$this->crud_model->insert('jobcard_track_log',$datajob_stage);	
				}
			}
			$data2 = array(
				'job_id' 	 => $this->input->post('mar_job_id'),
			);
			$this->crud_model->update(' po_b',$data2,$where );
			$page=1;
			//redirect('furniture/PurchaseOrder/listPurchaseOrder');
			$this->session->set_flashdata('success', '');
			redirect("furniture/PurchaseOrder/editPurchaseOrderJob/".$po_id);
		}
	}

	public function job_po_item_delete($po_b_id,$po_id){
		$this->db->where("po_b_id",$po_b_id);
		$this->db->delete('po_b');
		$this->furniture_quotation_model->update_purchase_order_total($po_id);
		$this->session->set_flashdata('success', 'Deleted...');
		redirect('furniture/PurchaseOrder/editPurchaseOrderJob/'.$po_id);
	}

	public function getPurchaseOrderJobDesc(){
		$po_b_id = $this->input->post('item_desc_id');
		$dbdata  = $this->Job_card_model->purchaseOrderItemDesc($po_b_id);
		if($dbdata != false ){
			$msg = html_entity_decode($dbdata->item_description);			
		}
		else{
			$msg = "";
		}
		echo $msg;
	}

	public function updatePurchaseOrderJobDesc(){
		$po_b_id = $this->input->post('item_desc_id');
		$pop_description = $this->input->post('pop_description');
		$where=array(
			'po_b_id'=> $po_b_id
		);
		$data2 = array(
			'item_description' 	 => $pop_description,
		);
		$sql = $this->crud_model->update('po_b',$data2,$where );
 		if($sql){
			$msg = "success";			
		}
		else{
			$msg = "";
		}
		echo json_encode($msg);
	}
} 
?>