<?php
 if (!defined('BASEPATH')) exit('No direct script access allowed');
 
class PurchaseRequest extends CI_Controller{
	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true) {
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}	
	}
	function index($client="") {

	}

	public function listPurchaseRequest(){
		if($this->users_model->check_permission("PurchaseRequestInventory","View")==false && $this->users_model->check_permission("PurchaseRequestJob","View")==false && $this->users_model->check_permission("PurchaseRequestOthers","View")==false){ 
			$red=$this->session->userdata("default_controller_name");
			$this->session->set_flashdata('response','You do not have permission to access this page.Please contact administrator.');
            redirect($red);
		}
		$title['headerTitle']="Purchase Request";
  		$page = 0;
		$i=1;
		$list='';
		$headList='';
		$EditPurchaseRequestInventory=$this->users_model->check_permission("PurchaseRequestInventory","Edit");
		$EditPurchaseRequestJob=$this->users_model->check_permission("PurchaseRequestJob","Edit");
		$EditPurchaseRequestOthers=$this->users_model->check_permission("PurchaseRequestOthers","Edit");
		foreach ($this->Job_card_model->get_all_purchase_request() as $row) {
			$style='';
			if($row->status=='Cancel'){
				$style= 'style="background: #f5d2d2;color:#6b1110;"';
			} else if($row->status=='Rate Updated') {
				$style='style="background:#dff1cc;color:#316100;"';
			} else if($row->status=='Confirmed') {
				$style='style="background:#dff1cc;color:#316100;"';
			} else {
				$style='style="background:#cbe7fb;color:#24587e;"';
			}
		    $list.='<tr '.$style.' >
						<td>'.$i++.'</td>
						<td>'.$row->pr_code.'</td>
						<td>'.$row->pr_type.'</td>
						<td>'.date("M d, Y", strtotime($row->pr_date)).'</td>
						<td>'.$row->client_name.'</td>
						<td>'.$row->job_card_number.'</td>
						<td>'.$row->project_name.'</td>
						<td>
							<div class="btn-group">
								<button type="button" class="btn btn-sm btn-primary dropdown-toggle" data-bs-toggle="dropdown">
									Action <span class="caret"></span>
								</button>
								<ul class="dropdown-menu" role="menu">';
							
									$list.= '<li><a target="_blank"  href="'.base_url().'index.php/furniture/PurchaseRequest/printPurchaseRequest/' . $row->pr_id . '"><i class="fa fa-print"></i> Print</a> </li>';
									if(($row->pr_type==='Inventory' && $EditPurchaseRequestInventory!=false) || ($row->pr_type==='Job' && $EditPurchaseRequestJob!=false) || ($row->pr_type==='Others' && $EditPurchaseRequestOthers!=false)) {
										if($row->po_status!='Draft' && $row->po_status!='Confirmed'){
											$list.= '<li><a class="iframe iframe cboxElement click2" title="Edit" href="'.base_url().'index.php/furniture/PurchaseRequest/editPurchaseRequest/' . $row->pr_id . '"><i class="fa fa-edit"></i> Edit</a> </li>';
										}
									}
									if(($row->pr_type==='Inventory' && $this->users_model->check_permission("PurchaseRequestInventory","Delete")!=false) || ($row->pr_type==='Job' && $this->users_model->check_permission("PurchaseRequestJob","Delete")!=false) || ($row->pr_type==='Others' && $this->users_model->check_permission("PurchaseRequestOthers","Delete")!=false)) {
										if($row->status!='Cancel' && $row->po_status!='Draft' && $row->po_status!='Confirmed') {
											$rrr="'".$row->pr_id."','".$row->pr_code."'";
											$list.= '<li><a ref="" data-bs-toggle="modal" data-bs-target="#cancelPurchaseRequest" class="cancelPR" data-id="'.$row->pr_id.'" data-code="'.$row->pr_code.'" ><i class="fa fa-close"></i> Cancel</a> </li>';
										} 
									}
									if(($row->pr_type==='Inventory' && $this->users_model->check_permission("PurchaseOrderInventory","Add")!=false) || ($row->pr_type==='Job' && $this->users_model->check_permission("PurchaseOrderJob","Add")!=false) || ($row->pr_type==='Others' && $this->users_model->check_permission("PurchaseOrderOthers","Add")!=false)) {
										if($row->status==='Confirmed' && ($row->po_status==='' OR $row->po_status===NULL OR $row->po_status==='Cancel')) {
											$list.= '<li><a href="javascript:createPO('.$row->pr_id.')" ><i class="fa fa-plus"></i> Create PO</a> </li>';
										}
									}
									
									/* if($this->session->userdata('user_group_id') == 1 ) {
										if($row->status!='Cancel' && $row->po_status!='Draft' && $row->po_status!='Confirmed') {
											$rrr="'".$row->pr_id."','".$row->pr_code."'";
											$list.= '<li><a ref="" data-bs-toggle="modal" data-bs-target="#cancelPurchaseRequest" class="cancelPR" data-id="'.$row->pr_id.'" data-code="'.$row->pr_code.'" ><i class="fa fa-close"></i> Cancel</a> </li>';
										} 
									} */
						$list.= '</ul>
					</div>
				</td>
			</tr>';
		}
		$datas   =   array("data" => $list);
  		$this->load->view('templates/header',$title);
		$this->load->view('furniture/quotations/purchaserequest/listPurchaseRequest',$datas);
		$this->load->view('templates/footer');
	}

	public function search_items() {
		$item	=	$this->input->post('item');
	 	$today	=	date("Y-m-d");
	 	$html	='';
		$sql="";
		$items = explode(" ", trim($item));
		for($i=0;$i<count($items);$i++) {
			$r	= $items[$i];
			$sql.=" and item_name LIKE '%$r%' ";
		}
		$query3 = $this->db->query("SELECT * FROM `items` where `item_name` like '%$item%' and (is_sales='1' OR `is_purchase`='1') union (SELECT * FROM `items` where (is_sales='1' OR `is_purchase`='1') and `id` not in (SELECT `id` FROM `items` where `item_name` like '%$item%'  and  (is_sales='1' OR `is_purchase`='1') ) ".$sql." order by item_name) limit 50 ");
		
	  	//$query3 = $this->db->query("SELECT * FROM `items`  WHERE `status`='1' and `is_purchase`='1' and  `item_name` like '%$item%' limit 25");
	 	$itemList_date	=	$query3->result_array();
	 	$itemList='';
	 	foreach($itemList_date as $itemList_datas){
			$html.='<li tabindex="-1" class="search_item_list p_description_button" data-rate="'.$itemList_datas['selling_price'].'"  data-item_code="'.$itemList_datas['item_code'].'" data-item_UOM_id="'.$itemList_datas['unit_id'].'" data-item_name="'.$itemList_datas['item_name'].'" data-item_cost="'.$itemList_datas['cost_price'].'" data-item_details_id="'.$itemList_datas['id'].'" data-uom="'.$itemList_datas['unit'].'"  item_tax_rate="10">'.$itemList_datas['item_name'].'</li>';
	 	}
		if(count($itemList_date)==0){
		 	$html.='<li>No data found</li>';
	 	}
		print $html;
	}

	public function search_items_by_location() {
		$item	=	$this->input->post('item');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		$loc_id	=	$this->input->post('loc_id');

		$query3 = $this->db->query("SELECT * FROM `items`  WHERE `item_name` like '%$item%'");
		$itemList_date	=	$query3->result_array();
		$itemList='';
		
		foreach($itemList_date as $itemList_datas){
			$item_rate=0;
			$id=$itemList_datas['id'];
			$query5 = $this->db->query("SELECT item_rate FROM `item_trans` WHERE `loc_id` = '$loc_id' and `item_id` = '$id' and `trans_type`=1 ORDER BY `item_trans_id` DESC LIMIT 1");
			if($query5->num_rows() > 0){
				$item_rate = $query5->row()->item_rate;
			}
			if($item_rate==0){
				$query6 = $this->db->query("SELECT item_rate FROM `item_trans` WHERE `loc_id` != '$loc_id' and `item_id` = '$id' and `trans_type`=1 ORDER BY `item_trans_id` DESC LIMIT 1");
				if($query6->num_rows() > 0){
					$item_rate = $query6->row()->item_rate;
				}
			}
			if($item_rate==0){
				$item_rate =$itemList_datas['cost_price'];
			}

			$html.='<li class="search_item_list p_description_button" data-rate="'.$itemList_datas['selling_price'].'"  data-item_code="'.$itemList_datas['item_code'].'" data-item_UOM_id="'.$itemList_datas['unit_id'].'" data-item_name="'.$itemList_datas['item_name'].'" data-item_cost="'.$item_rate.'" data-item_details_id="'.$itemList_datas['id'].'" item_tax_rate="5">'.$itemList_datas['item_name'].'</li>';
		}
		if(count($itemList_date)==0){
			$html.='<li>No data found</li>';
		}
		print $html;
	}

	function create_pr($client="") {
		if($this->users_model->check_permission("PurchaseRequestInventory","Add")==false && $this->users_model->check_permission("PurchaseRequestJob","Add")==false && $this->users_model->check_permission("PurchaseRequestOthers","Add")==false){ 
			$red=$this->session->userdata("default_controller_name");
			$this->session->set_flashdata('response','You do not have permission to access this page.Please contact administrator.');
            redirect($red);
		}
		$title['headerTitle']="Purchase Request Create";
		$total_count	= $this->input->post('total_count');
		$html='';
		$rowCount=1;
		for($i=1;$i<=$total_count;$i++){
			$item_id		= $this->input->post('item_id'.$i);
			$req_qty		= $this->input->post('req_qty'.$i);
			$closing_stock	= $this->input->post('closing_stock'.$i);
			if($item_id!=''){
				$query = $this->db->query("SELECT * FROM `items`  WHERE `id`='$item_id'");
				if($query->row_array()!=false){
					$rowCountn=$rowCount++;
					//echo $item_id.','.$closing_stock.','.$req_qty.'<br>';
					$html.='<tr class="remove'.$rowCountn.' ">';
					$html.='<td style="text-align: left;"><input type="hidden" name="row_c" class="row_c" value="'.$rowCountn.'" /> '.$rowCountn.'</td>';
					$html.='<td><input type="hidden" name="row_pr_d_id[]" class="row_pr_d_id" value="" /><input type="hidden" name="row_item_name[]" class="row_item_name" value="'.$query->row()->item_name.'" /> <input type="hidden" name="row_item_id[]" class="row_item_id" value="'.$query->row()->id.'" /> <input type="hidden" name="row_description[]" class="row_description" value="NIL" /><input type="hidden" name="row_closing_stock[]" class="row_closing_stock" value="'.$closing_stock.'" /><input type="hidden" name="row_req_qty[]" class="row_req_qty" value="'.$req_qty.'" /><input type="hidden" name="row_material_qty[]" class="row_material_qty" value="'.$req_qty.'" /><input type="hidden" name="row_uom[]" class="row_uom" value="'.$query->row()->unit.'" /><input type="hidden" name="row_p_remarks[]" class="row_p_remarks" value="" /> '.$query->row()->item_name.'</td>';
					$html.='<td style="text-align: left;">'.$closing_stock.'</td>';
					$html.='<td style="text-align: left;">'.$req_qty.'</td>';
					$html.='<td style="text-align: left;">'.$req_qty.'</td>';
					$html.='<td style="text-align: left;">'.$query->row()->unit.'</td>';
					$html.='<td style="text-align: left;"></td>';
					$html.='<td><a class="minus editItemRow" data-bs-target=".bd-example-modal-lg" ><i class="fa fa-edit"></i></a> &nbsp;&nbsp;&nbsp; <a id="add__new__list" class="minus deletMinus" data-bs-target=".bd-example-modal-lg" ><i class="fa fa-trash"></i></a></td>';
					$html.='</tr>';
				}
			}
		}
		//echo $html;
		$job_number    = $this->input->post('job_number');
		$division_id    = $this->input->post('division_id');
		$jobData = $this->Job_card_model->getJobData($division_id,$job_number);
		//print_r($jobData);
		//exit();
		$client    = $this->input->post('client');
		$this->load->view('templates/header',$title);
		$this->load->model('proforma_model');
		$data['client_det']=$client;
		$data['client_det_id']=$this->input->post('client_id');
		$list = $this->crud_model->get_list('division_id','division_name','company_division',array(''=>' - Select - '));
		$data['division_list'] = $list;
		$list2 = $this->crud_model->get_list2('department_id','department_name','department_master',array(''=>' - Select - '),array('status'=>1));
		$data['department_list'] = $list2;
		$nn=$this->Job_card_model->purchaseRequestNumber($division_id);
		$data['purchaseRequestNumber'] = $this->Job_card_model->get_purchase_request_no($nn,$division_id);
		$data['jobData']=$jobData;
		if($this->furniture_quotation_model->config($division_id)){
			$config_data=$this->furniture_quotation_model->config($division_id);
			$data['is_quote_from_master'] = $config_data->is_quote_from_master;
			$data['is_estimate'] = $config_data->is_estimate;
			$data['is_approve'] = $config_data->is_approve;
			$data['is_bom'] = $config_data->is_bom;
			$data['is_optional_item_level'] = $config_data->is_optional_item_level;
			$data['is_category'] = $config_data->is_category;
		} else {
			$data['is_quote_from_master'] = 0;
			$data['is_estimate'] = 0;
			$data['is_approve'] = 0;
			$data['is_bom'] = 0;
			$data['is_optional_item_level'] = 0;
			$data['is_category'] = 0;
		}

		$unit_list = $this->crud_model->get_list('unit_name','unit_name','unit_master',array(''=>' - Select - '));
		$data['unit_list'] = $unit_list;
		$data['addeditems'] = $html;
		
		$this->load->view('furniture/quotations/purchaserequest/create_pr',$data);
		$this->load->view('templates/footer'); 
	}

	function create_purchase_request($client="") {
		$this->users_model->permission("PurchaseRequestInventory", "Add");
		$title['headerTitle']="Purchase Request Create";
		$job_card_id    = $this->input->post('job_card_id');
		$client    = $this->input->post('client');
		$this->load->view('templates/header',$title);
		$this->load->model('proforma_model');
		$data['client_det']=$client;
		$data['client_det_id']=$this->input->post('client_id');
		$list = $this->crud_model->get_list('division_id','division_name','company_division',array(''=>' - Select - '));
		$data['division_list'] = $list;
		$list2 = $this->crud_model->get_list2('department_id','department_name','department_master',array(''=>' - Select - '),array('status'=>1));
		$data['department_list'] = $list2;
		$nn=$this->Job_card_model->purchaseRequestNumber(1);
		$data['purchaseRequestNumber'] = $this->Job_card_model->get_purchase_request_no($nn,1);

		if($this->furniture_quotation_model->config(1)){
			$config_data=$this->furniture_quotation_model->config(1);
			$data['is_quote_from_master'] = $config_data->is_quote_from_master;
			$data['is_estimate'] = $config_data->is_estimate;
			$data['is_approve'] = $config_data->is_approve;
			$data['is_bom'] = $config_data->is_bom;
			$data['is_optional_item_level'] = $config_data->is_optional_item_level;
			$data['is_category'] = $config_data->is_category;
		} else {
			$data['is_quote_from_master'] = 0;
			$data['is_estimate'] = 0;
			$data['is_approve'] = 0;
			$data['is_bom'] = 0;
			$data['is_optional_item_level'] = 0;
			$data['is_category'] = 0;
		}

		$unit_list = $this->crud_model->get_list('unit_name','unit_name','unit_master',array(''=>' - Select - '));
		$data['unit_list'] = $unit_list;
		$data['p_request_type']="Inventory";

		$this->load->view('furniture/quotations/purchaserequest/create_purchase_request',$data);
		$this->load->view('templates/footer');
	}
	function create_purchase_request_job($client="") {
		$this->users_model->permission("PurchaseRequestJob", "Add");
		$title['headerTitle']="Purchase Request Create";
		$job_card_id    = $this->input->post('job_card_id');
		$client    = $this->input->post('client');
		$this->load->view('templates/header',$title);
		$this->load->model('proforma_model');
		$data['client_det']=$client;
		$data['client_det_id']=$this->input->post('client_id');
		$list = $this->crud_model->get_list('division_id','division_name','company_division',array(''=>' - Select - '));
		$data['division_list'] = $list;
		$list2 = $this->crud_model->get_list2('department_id','department_name','department_master',array(''=>' - Select - '),array('status'=>1));
		$data['department_list'] = $list2;
		$nn=$this->Job_card_model->purchaseRequestNumber(1);
		$data['purchaseRequestNumber'] = $this->Job_card_model->get_purchase_request_no($nn,1);

		if($this->furniture_quotation_model->config(1)){
			$config_data=$this->furniture_quotation_model->config(1);
			$data['is_quote_from_master'] = $config_data->is_quote_from_master;
			$data['is_estimate'] = $config_data->is_estimate;
			$data['is_approve'] = $config_data->is_approve;
			$data['is_bom'] = $config_data->is_bom;
			$data['is_optional_item_level'] = $config_data->is_optional_item_level;
			$data['is_category'] = $config_data->is_category;
		} else {
			$data['is_quote_from_master'] = 0;
			$data['is_estimate'] = 0;
			$data['is_approve'] = 0;
			$data['is_bom'] = 0;
			$data['is_optional_item_level'] = 0;
			$data['is_category'] = 0;
		}

		$unit_list = $this->crud_model->get_list('unit_name','unit_name','unit_master',array(''=>' - Select - '));
		$data['unit_list'] = $unit_list;
		$data['p_request_type']="Job";

		$this->load->view('furniture/quotations/purchaserequest/create_purchase_request',$data);
		$this->load->view('templates/footer');
	}
	function create_purchase_request_others($client="") {
		$this->users_model->permission("PurchaseRequestOthers", "Add");
		$title['headerTitle']="Purchase Request Create";
		$job_card_id    = $this->input->post('job_card_id');
		$client    = $this->input->post('client');
		$this->load->view('templates/header',$title);
		$this->load->model('proforma_model');
		$data['client_det']=$client;
		$data['client_det_id']=$this->input->post('client_id');
		$list = $this->crud_model->get_list('division_id','division_name','company_division',array(''=>' - Select - '));
		$data['division_list'] = $list;
		$list2 = $this->crud_model->get_list2('department_id','department_name','department_master',array(''=>' - Select - '),array('status'=>1));
		$data['department_list'] = $list2;
		$nn=$this->Job_card_model->purchaseRequestNumber(1);
		$data['purchaseRequestNumber'] = $this->Job_card_model->get_purchase_request_no($nn,1);

		if($this->furniture_quotation_model->config(1)){
			$config_data=$this->furniture_quotation_model->config(1);
			$data['is_quote_from_master'] = $config_data->is_quote_from_master;
			$data['is_estimate'] = $config_data->is_estimate;
			$data['is_approve'] = $config_data->is_approve;
			$data['is_bom'] = $config_data->is_bom;
			$data['is_optional_item_level'] = $config_data->is_optional_item_level;
			$data['is_category'] = $config_data->is_category;
		} else {
			$data['is_quote_from_master'] = 0;
			$data['is_estimate'] = 0;
			$data['is_approve'] = 0;
			$data['is_bom'] = 0;
			$data['is_optional_item_level'] = 0;
			$data['is_category'] = 0;
		}

		$unit_list = $this->crud_model->get_list('unit_name','unit_name','unit_master',array(''=>' - Select - '));
		$data['unit_list'] = $unit_list;
		$data['p_request_type']="Others";

		$this->load->view('furniture/quotations/purchaserequest/create_purchase_request',$data);
		$this->load->view('templates/footer');
	}

	public function do_insert() {
		if($this->users_model->check_permission("PurchaseRequestInventory","View")==false && $this->users_model->check_permission("PurchaseRequestJob","View")==false && $this->users_model->check_permission("PurchaseRequestOthers","View")==false){ 
			$red=$this->session->userdata("default_controller_name");
			$this->session->set_flashdata('response','You do not have permission to access this page.Please contact administrator.');
            redirect($red);
		}
		$this->form_validation->set_rules('row_item_name[]', 'Product', 'required');
		$this->form_validation->set_rules('dep_id', 'Department', 'required');
		$this->form_validation->set_rules('division_id', 'Division', 'required');
		if($this->input->post('pr_type')==='Job'){
			$this->form_validation->set_rules('job_id', 'Job No', 'required');
		}
        if ($this->form_validation->run() == FALSE){
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			redirect('furniture/PurchaseRequest/create_purchase_request');
        } else {
	  		$user_id	=	$this->session->userdata('user_id');
			$this->db->trans_begin();
	 		$purchaseRequestNumber= $this->Job_card_model->purchaseRequestNumber($this->input->post('division_id'));
			$pr_code= $this->Job_card_model->get_purchase_request_no($purchaseRequestNumber,$this->input->post('division_id'));
			$data = array( 
				'pr_number'   => $purchaseRequestNumber,
				'pr_code'     => $pr_code,
				'pr_date'     => date("Y-m-d"),
				'dep_id'      => $this->input->post('dep_id'),
				'division_id' => $this->input->post('division_id'),
				'job_id'      => $this->input->post('job_id'),
				'pr_type'      => $this->input->post('pr_type'),
				'rfq_number'  => NULL,
				'user_id'     => $user_id,
				'status'      => 'Confirmed',
				'approved_date'=> date('Y-m-d h:m:s'),
				'approved_user'=> $this->session->userdata('user_name')
			);	
			//'status'      => 'Draft'
			$this->db->insert('purchase_request', $data);
			$insert_id = $this->db->insert_id();
	
			if($insert_id){
				$loop_count	= count($this->input->post('row_item_name'));
				
				$row_item_id	  = $this->input->post('row_item_id');
				$row_item_name	  = $this->input->post('row_item_name');
				$row_description  = $this->input->post('row_description');
				$row_material_qty = $this->input->post('row_material_qty');
				$row_uom	      = $this->input->post('row_uom');
				$row_p_remarks	  = $this->input->post('row_p_remarks');
				$po_gross_amt     = 0;
				$po_discount      = 0;
				$po_vat_amt       = 0;
				$po_net_amt       = 0;
				for($i=0; $i<$loop_count; $i++){
					$chk_loop	    =	$row_item_name[$i];
					if($chk_loop!==''){
						if(@$row_item_id[$i]!==''){
							$row_item_idnbx= $row_item_id[$i];
						} else {
							$row_item_idnbx= 0;
						}
						if($row_description[$i]!='NIL'){
							$row_description_nbx=$row_description[$i];
						} else {
							$row_description_nbx=NULL;
						}
						$data_array = array(
							'pr_id' 	      => $insert_id,
							'item_details_id' => $row_item_idnbx,
							'item_name'   	  => $row_item_name[$i],
							'item_description'=> $row_description_nbx,
							'item_qty' 		  => $row_material_qty[$i],
							'uom' 		      => $row_uom[$i],
							'item_remarks'    => $row_p_remarks[$i],
							'status'          => 1
						);
						$this->db->insert('purchase_request_details', $data_array);
					}
				}
				$log_data=array(
					'trans_no'     => $pr_code,
					'trans_type'   => 'Purchase Request',
					'trans_op'     => 'Create',
					'trans_user_id'=> $this->session->userdata('user_id')	
				);
				$log_for_transactions	=	$this->crud_model->insert('log_for_transactions',$log_data);
			}
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				redirect("furniture/PurchaseRequest/listPurchaseRequest");
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'Purchase Request Created...');
				//redirect("furniture/PurchaseRequest/editPurchaseOrder/".$insert_id);
				redirect("furniture/PurchaseRequest/listPurchaseRequest");
			}
		}
	}

	public function printPurchaseRequest($purchase_id,$approvestatus=NULL){
		if($this->users_model->check_permission("PurchaseRequestInventory","View")==false && $this->users_model->check_permission("PurchaseRequestJob","View")==false && $this->users_model->check_permission("PurchaseRequestOthers","View")==false){ 
			$red=$this->session->userdata("default_controller_name");
			$this->session->set_flashdata('response','You do not have permission to access this page.Please contact administrator.');
            redirect($red);
		}
		$datas['row']        = $this->Job_card_model->purchaseRequestRow($purchase_id);

		$division_id	=	$datas['row']->division_id;

		$this->db->select('*' );
		$this->db->from('company_division');
		$this->db->where('division_id', $division_id);
		$rs = $this->db->get();
		$datas['logo_filename'] = $rs->row()->logo_filename;
		$datas['approvestatus'] = $approvestatus;

		$datas['details']    = $this->Job_card_model->purchaseRequestDetails($purchase_id);

		$query = $this->db->get('company_details');  
		$datas['company_details'] = $query->row();

		$this->load->view('furniture/quotations/purchaserequest/printPurchaseRequest',$datas);
	}

	public function approvePurchaseRequest($pr_id,$pr_code){
		$this->session->keep_flashdata('response');
		$where = array('pr_id'	=> $pr_id);	
		$data_quo['status']= 'Confirmed';
		$data_quo['approved_date']= date('Y-m-d h:m:s');
		$data_quo['approved_user']= $this->session->userdata('user_name');

		$this->crud_model->update('purchase_request',$data_quo,$where);
		
		$log_data=array(
			'trans_no'     =>  $pr_code,
			'trans_type'   =>  'Purchase Request',
			'trans_op'     =>  'Confirmed',
			'trans_user_id'=>  $this->session->userdata('user_id')
		);
		$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);
		
		$this->session->set_flashdata('success','Confirmed successfully..');
		redirect('Dashboard/home');
	}

	public function editPurchaseRequest($purchase_id,$po_b_id='') {
		if($this->users_model->check_permission("PurchaseRequestInventory","Edit")==false && $this->users_model->check_permission("PurchaseRequestJob","Edit")==false && $this->users_model->check_permission("PurchaseRequestOthers","Edit")==false){ 
			$red=$this->session->userdata("default_controller_name");
			$this->session->set_flashdata('response','You do not have permission to access this page.Please contact administrator.');
            redirect($red);
		}
		$title['headerTitle']="Purchase Request Edit";
		$this->form_validation->set_rules('row_item_name[]', 'Product', 'required');
		$this->form_validation->set_rules('dep_id', 'Department', 'required');
		
		$data['dbdata']        = $this->Job_card_model->purchaseRequestRow($purchase_id);
        if ($this->form_validation->run() == FALSE){
    		$data['details']    = $this->Job_card_model->purchaseRequestDetails($purchase_id);
			$job_card_id    = $this->input->post('job_card_id');
		
			$client    = $this->input->post('client');
		
			$this->load->model('proforma_model');
			$data['client_det']=$client;
			$data['client_det_id']=$this->input->post('client_id');
			$list = $this->crud_model->get_list('division_id','division_name','company_division',array(''=>' - Select - '));
			$data['division_list'] = $list;
			$list2 = $this->crud_model->get_list2('department_id','department_name','department_master',array(''=>' - Select - '),array('status'=>1));
			$data['department_list'] = $list2;

			$division_id = $data['dbdata']->division_id;

			if($this->furniture_quotation_model->config($division_id)){
				$config_data=$this->furniture_quotation_model->config($division_id);
				$data['is_quote_from_master'] = $config_data->is_quote_from_master;
				$data['is_estimate'] = $config_data->is_estimate;
				$data['is_approve'] = $config_data->is_approve;
				$data['is_bom'] = $config_data->is_bom;
				$data['is_optional_item_level'] = $config_data->is_optional_item_level;
				$data['is_category'] = $config_data->is_category;
			} else {
				$data['is_quote_from_master'] = 0;
				$data['is_estimate'] = 0;
				$data['is_approve'] = 0;
				$data['is_bom'] = 0;
				$data['is_optional_item_level'] = 0;
				$data['is_category'] = 0;
			}

			$unit_list = $this->crud_model->get_list('unit_name','unit_name','unit_master',array(''=>' - Select - '));
			$data['unit_list'] = $unit_list;

			$this->load->view('templates/header',$title);
			$this->load->view('furniture/quotations/purchaserequest/editPurchaseRequest',$data);
			$this->load->view('templates/footer');
        } else {
			
			$user_id	=	$this->session->userdata('user_id');
			$this->db->trans_begin();
			$pr_code= $this->input->post('pr_code');
			$data = array( 
				'dep_id'      => $this->input->post('dep_id'),
				'job_id'      => $this->input->post('job_id'),
				'rfq_number'  => NULL,
				'user_id'     => $user_id,
			);	
			$this->db->where('pr_id', $purchase_id);
			$this->db->update('purchase_request', $data);
	
			if($purchase_id){
				
				$loop_count	= count($this->input->post('row_item_name'));
				
				$pr_d_id 	  	  = $this->input->post('row_pr_d_id');
				$row_item_id	  = $this->input->post('row_item_id');
				$row_item_name	  = $this->input->post('row_item_name');
				$row_description  = $this->input->post('row_description');
				$row_material_qty = $this->input->post('row_material_qty');
				$row_uom	      = $this->input->post('row_uom');
				$row_p_remarks	  = $this->input->post('row_p_remarks');
				$po_gross_amt     = 0;
				$po_discount      = 0;
				$po_vat_amt       = 0;
				$po_net_amt       = 0;
				$this->db->where("pr_id",$purchase_id);
				$this->db->delete('purchase_request_details');
				for($i=0; $i<$loop_count; $i++){
					$chk_loop	    =	$row_item_name[$i];
					if($chk_loop!==''){
						if(@$row_item_id[$i]!==''){
							$row_item_idnbx= $row_item_id[$i];
						} else {
							$row_item_idnbx= 0;
						}
						if($pr_d_id[$i]!='0'){
							$nbx= $pr_d_id[$i];
						} else {
							$nbx= NULL;
						}
						if($row_description[$i]!='NIL'){
							$row_description_nbx=$row_description[$i];
						} else {
							$row_description_nbx=NULL;
						}
						$data_array = array(
							'pr_d_id' 	      => $nbx,
							'pr_id' 	      => $purchase_id,
							'item_details_id' => $row_item_idnbx,
							'item_name'   	  => $row_item_name[$i],
							'item_description'=> $row_description_nbx,
							'item_qty' 		  => $row_material_qty[$i],
							'uom' 		      => $row_uom[$i],
							'rate' 		      => 0,
							'item_remarks'    => $row_p_remarks[$i],
							'status'          => 1
						);
						$this->db->insert('purchase_request_details', $data_array);
					}
				}
				$log_data=array(
					'trans_no'     => $pr_code,
					'trans_type'   => 'Purchase Request',
					'trans_op'     => 'Edit',
					'trans_user_id'=> $this->session->userdata('user_id')	
				);
				$log_for_transactions	=	$this->crud_model->insert('log_for_transactions',$log_data);
			}
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				redirect("furniture/PurchaseRequest/listPurchaseRequest");
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'Updated');
				redirect("furniture/PurchaseRequest/editPurchaseRequest/".$purchase_id);
			}
		}
	}

	public function updateRate($purchase_id,$po_b_id='') {
		$title['headerTitle']="Purchase Request Update Rate";
		$this->form_validation->set_rules('row_item_name[]', 'Product', 'required');
		$this->form_validation->set_rules('dep_id', 'Department', 'required');
		
		$data['dbdata']        = $this->Job_card_model->purchaseRequestRow($purchase_id);
        if ($this->form_validation->run() == FALSE){
    		$data['details']    = $this->Job_card_model->purchaseRequestDetails($purchase_id);
			$job_card_id    = $this->input->post('job_card_id');
		
			$client    = $this->input->post('client');
		
			$this->load->model('proforma_model');
			$data['client_det']=$client;
			$data['client_det_id']=$this->input->post('client_id');
			$list = $this->crud_model->get_list('division_id','division_name','company_division',array(''=>' - Select - '));
			$data['division_list'] = $list;
			$list2 = $this->crud_model->get_list2('department_id','department_name','department_master',array(''=>' - Select - '),array('status'=>1));
			$data['department_list'] = $list2;

			$division_id = $data['dbdata']->division_id;

			if($this->furniture_quotation_model->config($division_id)){
				$config_data=$this->furniture_quotation_model->config($division_id);
				$data['is_quote_from_master'] = $config_data->is_quote_from_master;
				$data['is_estimate'] = $config_data->is_estimate;
				$data['is_approve'] = $config_data->is_approve;
				$data['is_bom'] = $config_data->is_bom;
				$data['is_optional_item_level'] = $config_data->is_optional_item_level;
				$data['is_category'] = $config_data->is_category;
			} else {
				$data['is_quote_from_master'] = 0;
				$data['is_estimate'] = 0;
				$data['is_approve'] = 0;
				$data['is_bom'] = 0;
				$data['is_optional_item_level'] = 0;
				$data['is_category'] = 0;
			}

			$unit_list = $this->crud_model->get_list('unit_name','unit_name','unit_master',array(''=>' - Select - '));
			$data['unit_list'] = $unit_list;

			$this->load->view('templates/header',$title);
			$this->load->view('furniture/quotations/purchaserequest/updateRate',$data);
			$this->load->view('templates/footer');
        } else {
			
			$user_id	=	$this->session->userdata('user_id');
			$this->db->trans_begin();
			$pr_code= $this->input->post('pr_code');
			$data = array( 
				'dep_id'      => $this->input->post('dep_id'),
				'job_id'      => $this->input->post('job_id'),
				'rfq_number'  => NULL,
				'user_id'     => $user_id,
				'status'      => 'Rate Updated'
			);	
			$this->db->where('pr_id', $purchase_id);
			$this->db->update('purchase_request', $data);
	
			if($purchase_id){
				
				$loop_count	= count($this->input->post('row_item_name'));
				
				$pr_d_id 	  	  = $this->input->post('row_pr_d_id');
				$row_item_id	  = $this->input->post('row_item_id');
				$row_item_name	  = $this->input->post('row_item_name');
				$row_description  = $this->input->post('row_description');
				$row_material_qty = $this->input->post('row_material_qty');
				$row_uom	      = $this->input->post('uom');
				$row_rate	      = $this->input->post('row_rate');
				$row_p_remarks	  = $this->input->post('row_p_remarks');
				$po_gross_amt     = 0;
				$po_discount      = 0;
				$po_vat_amt       = 0;
				$po_net_amt       = 0;
				$this->db->where("pr_id",$purchase_id);
				$this->db->delete('purchase_request_details');
				for($i=0; $i<$loop_count; $i++){
					$chk_loop	    =	$row_item_name[$i];
					if($chk_loop!==''){
						if(@$row_item_id[$i]!==''){
							$row_item_idnbx= $row_item_id[$i];
						} else {
							$row_item_idnbx= 0;
						}
						if($pr_d_id[$i]!='0'){
							$nbx= $pr_d_id[$i];
						} else {
							$nbx= NULL;
						}
						if($row_description[$i]!='NIL'){
							$row_description_nbx=$row_description[$i];
						} else {
							$row_description_nbx=NULL;
						}
						$data_array = array(
							'pr_d_id' 	      => $nbx,
							'pr_id' 	      => $purchase_id,
							'item_details_id' => $row_item_idnbx,
							'item_name'   	  => $row_item_name[$i],
							'item_description'=> $row_description_nbx,
							'item_qty' 		  => $row_material_qty[$i],
							'uom' 		      => $row_uom[$i],
							'rate' 		      => $row_rate[$i],
							'item_remarks'    => $row_p_remarks[$i],
							'status'          => 1
						);
						$this->db->insert('purchase_request_details', $data_array);
					}
				}
				$log_data=array(
					'trans_no'     => $pr_code,
					'trans_type'   => 'Purchase Request',
					'trans_op'     => 'Edit',
					'trans_user_id'=> $this->session->userdata('user_id')	
				);
				$log_for_transactions	=	$this->crud_model->insert('log_for_transactions',$log_data);
			}
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				redirect("furniture/PurchaseRequest/listPurchaseRequest");
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'Rate Updated');
				redirect("furniture/PurchaseRequest/updateRate/".$purchase_id);
			}
		}
	}

	public function do_update_discount($po_id) {
		$this->form_validation->set_rules('nb_po_id', 'Purchase Order', 'required');
		if ($this->form_validation->run() == FALSE)	{
			// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			redirect('furniture/PurchaseOrder/editPurchaseOrder/'.$po_id);
		} else {
			$data = array(
				'status'     => 'Confirmed',
				'po_discount'=> $this->input->post('discount_bd'),
				'po_vat_amt' => $this->input->post('total_vat'),
				'sign' 	  	 => $this->input->post('sign'),
				'round_off'  => $this->input->post('round_off'),
				'po_net_amt' => $this->input->post('grand_total'),
			);

			$where=array(
				'po_id'=> $po_id
			);
			$this->crud_model->update(' po_h',$data,$where );


			$data2 = array(
				'job_id' 	 => $this->input->post('mar_job_id'),
			);
			$this->crud_model->update(' po_b',$data2,$where );
			$page=1;
			redirect('furniture/PurchaseOrder/listPurchaseOrder');
		}
	}

	public function searchSupplier() {
		$client	=	$this->input->post('client');
		$client_contact_data = $this->db->query("SELECT * FROM `supplier_master` WHERE `supplier_name` LIKE  '%$client%'");
		$n=1;
		$html ='';
		if(count($client_contact_data->result_array())>0){
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<li value="' .$client_contact_datas['supplier_id'].'" class="client_button" tabindex="'.$n++.'" ><input type="hidden" class="client_name" value="'.$client_contact_datas['supplier_name'].'" /><input type="hidden" class="client_address" value="'.$client_contact_datas['address'].'" />'.$client_contact_datas['supplier_name'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		print $html;
	}

	public function searchJob() {
		$po_number = $this->input->post('po_number');
		$division = $this->input->post('division');
		//print 'aaa';
		$jobData = $this->Job_card_model->getPurchaseOrderData($division,$po_number);
		if($jobData!=false){
		  echo json_encode($jobData);
		}else{
		  echo 0;
		}
	}

	public function getDetails() {
		$job_number = $this->input->post('job_number');
		$division = $this->input->post('division');

		$client_contact_data = $this->db->query("SELECT * FROM `job_card` JC JOIN new_client_master NCM ON NCM.client_id=JC.client_id  WHERE  JC.`job_card_number`  LIKE  '%$job_number%' AND JC.`divisionid`='$division' AND (JC.`job_card_status`='Draft') ");
		$n=1;
		$html ='';
		if(count($client_contact_data->result_array())>0){
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<li value="' .$client_contact_datas['id'].'" class="job_button" tabindex="-1" ><input type="hidden" class="job_card_number" value="'.$client_contact_datas['job_card_number'].'" /><input type="hidden" class="client_name" value="'.$client_contact_datas['client_name'].'" /><input type="hidden" class="project_name" value="'.$client_contact_datas['project_name'].'" />'.$client_contact_datas['job_card_number'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		echo $html;
	}

	public function getPurchaseRequestNo(){  
		$division_id =$this->input->post('division_id');
		$query= $this->db->query("SELECT count(pr_number) as pr_number FROM `purchase_request` WHERE division_id='$division_id' ");
		$no=$query->row()->pr_number+1;
		if($division_id!=0){
			$query2= $this->db->query("SELECT * FROM  `company_division` WHERE division_id='$division_id'");
			$division_code=$query2->row()->division_code;
		} else {
			$division_code='';
		}
		$purchase_request_no='PR-'.sprintf("%'.04d",$no).'-'.$division_code;
		$data   =   json_encode(array('2',$purchase_request_no));
	    echo $data;
		
	}

	

	function search_job() {
	
		$search_name = trim($this->input->post('quotation_number_new_one'));
		$search_name1 = trim($this->input->post('textfield2'));
		
		$like=null;
		$array = explode("-",$search_name.'-0');
		//,'division_code'=>$array[0]
		$like=array('job_card_number'=>$array[1]);
		//$or_like=array('quotation_number'=>$search_name);,'is_invoice'=>0
		$where=array('job_card_divisionid'=>$search_name1);
		//$where=array();
		$records['quotation_list']=$this->crud_model->get('view_furniture_job_card',
				$where,
				null,
				null,
				null,
				null,
				$like,
				null,null);
					
		if($records['quotation_list'] == false ){
			echo 0;
		} else {
			$records=html_escape($records);
			$this->load->view('furniture/quotations/proforma_search_result', $records);
			
		}
		
	}

	public function pr_delete(){
		if($this->users_model->check_permission("PurchaseRequestInventory","Delete")==false && $this->users_model->check_permission("PurchaseRequestJob","Delete")==false && $this->users_model->check_permission("PurchaseRequestOthers","Delete")==false){ 
			$red=$this->session->userdata("default_controller_name");
			$this->session->set_flashdata('response','You do not have permission to access this page.Please contact administrator.');
            redirect($red);
		}
		$pr_id = trim($this->input->post('pr_id'));
		$pr_code = trim($this->input->post('pr_code'));
		$reason_forclose = trim($this->input->post('reason_forclose'));
		if($pr_id!=0 && $pr_id!='' && $pr_code!=''){
			
			$update_data = array(
				'status'      	   => 'Cancel',
				'reason_for_close' => $reason_forclose,
				'cancelled_user'   => $this->session->userdata('user_name'),
				'cancelled_date'   => date('Y-m-d h:m:s'),
			);

			$this->db->where('pr_id', $pr_id);
			$this->db->update('purchase_request', $update_data);

			$log_data=array(
				'trans_no'  	=>  $pr_code,
				'trans_type'	=>  'Purchase Request',
				'trans_op'  	=>  'Delete',
				'trans_user_id' =>  $this->session->userdata('user_id')
			);
			$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);

			$this->session->set_flashdata('response', 'Cancelled...');
			redirect('furniture/PurchaseRequest/listPurchaseRequest');
		} else {
			$this->session->set_flashdata('response', 'Something went wrong...');
			redirect('furniture/PurchaseRequest/listPurchaseRequest');
		}
	}


	public function po_item_delete($po_b_id,$po_id){
		$this->db->where("po_b_id",$po_b_id);
		$this->db->delete('po_b');
		$this->furniture_quotation_model->update_purchase_order_total($po_id);
		$this->session->set_flashdata('response', 'Deleted...');
		redirect('furniture/PurchaseOrder/editPurchaseOrder/'.$po_id);
	}
} 
?>