<?php
class Technician_log_status extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
		$this->load->model('Vehicle');
		$this->load->model('users_model');
		$this->load->model('crud_model');
		$this->load->model('Supervisor_model');
		$this->load->model('Job_card_model');
	}


	public function index(){
	   $title['headerTitle']="Technician Log";
	   $data['make']  = $this->Vehicle->getMake();
	   $data['model']  = $this->Vehicle->getModel();
	   $data['customer']  = $this->Vehicle->getCustomer();
	   //$data['registration']  = $this->Vehicle->getRegistration();
	   $data['technicianVjobcard'] = $this->Vehicle->getTechnicianVjobcard();
	   $data['technicianVjobcarddetial'] = $this->Vehicle->getTechnicianVjobcarddetail();
 	   $data['vjobcardcount'] = $this->Vehicle->getVjobcardcountarea();
	   $data['technician']  = $this->Vehicle->getServiceStaff();		
	   $this->load->view('templates/header',$title);
	   $this->load->view('technician/update_status',$data);
	   $this->load->view('templates/footer');
   	}

   	public function technicianLog($lg_id= "", $jb_id = ""){
		$title['headerTitle']="Technician Log";
		$this->load->view('templates/header',$title);
	   $this->load->view('technician/update_log_status');
	   $this->load->view('templates/footer');
   	}

	   public function JobsPending() {
		$logdata = $this->Vehicle->getTechnicianlogdetail();
		$isBegin = $this->Supervisor_model->CheckopenedJobtechnician(); 
		$job_id = $this->input->post('job_id');
		$check_job_item_qty = $this->Job_card_model->getjobItemtTotalOrderQuantity($job_id);
		$check_po_item_qty  = $this->Job_card_model->getpurchaseTotalOrderQuantity($job_id);
		$check_job_stock_qty   = $this->Job_card_model->getjobItemtTotalStockQuantity($job_id);
		$check_mstock_item_qty = $this->Job_card_model->getmaterialstockQuantity($job_id);

		$list ='<thead class="thead-light">
					<tr>
						<th>Particulars</th>
						<th>AWS</th>
						<th>MIN</th>
						<th>Ageing</th>
						<th>Action</th>
					</tr>
				</thead>';
		if($logdata != FALSE){
			$count=0;
			$i = 1;
			
			foreach($logdata as $records){
				$beginBtnClass = '';
				$beginBtnClass2 = '';
				$completeBtnClass='';
				$showClass='';
				$completedTrClass='';
				$not_begin_job=0;
				//$complete_class = '';
				$job_detail_id = $records['job_detail_id'];
				$query=$this->db->query("SELECT * FROM `technician_wise_log` WHERE `job_detail_id` = $job_detail_id and job_status='begin' order by `log_id` DESC limit 1 ");
				if($query->num_rows()>0){
					$result=$query->row();
					$end_time=$result->end_time;
					$job_flag=$result->job_flag;
					if(!empty($end_time) OR $job_flag==1){
						$not_begin_job=1;
					}
				}
				$dates=$this->db->query("SELECT min(`job_date`) as min,max(`job_date`) as max FROM `technician_wise_log` WHERE `job_detail_id` = $job_detail_id")->result();
				$fromDate=$dates[0]->min;
				$toDate=$dates[0]->max;
				if(!empty($fromDate) && !empty($toDate)){
					$starttimestamp = strtotime($fromDate);
					$endtimestamp   = strtotime($toDate);
					$datediff 		= abs($endtimestamp - $starttimestamp);
					$linewiseaging  = round($datediff / (60 * 60 * 24));
				} else {
					$linewiseaging = 0;
				}
				if($not_begin_job!=1){
					$beginBtnClass    = ($records['progress_status'] == 20 ? 'hide ' : '');	
					$completeBtnClass = ($records['progress_status'] == 20 ? 'show' : '');
					$showClass  	  = ($records['progress_status'] == 20 ? 'alert-warning' : '');
				}

				$beginBtnClass2 = ($records['job_technician_status'] == 3 ? 'hide' : '');
				$completedTrClass  = ($records['job_technician_status'] == 3 ? 'alert-success' : '');
				if(!empty($isBegin) || $isBegin != false ){
					if($isBegin->job_detail_id  == $records['job_detail_id'] ){
						$Signoff = '&nbsp;&nbsp;<a class=" btn-danger btn btn-sm Job-off-supervisor text-white"  role="button" title="Sign-Off" data-job-id="'.$records['job_card_id'].'"  data-technician_id="'.$records['technician_id'].'"><i class="fe fe-eye"></i> </a>';
					}
					else{
						$Signoff = "";
					}
					
				}
				else{
					$Signoff =  '';
				}
				if($records['service_troubleshoot'] != 0 ){
 					if(($check_job_stock_qty != $check_mstock_item_qty) ||  ($check_job_item_qty  != $check_po_item_qty)){
						$complete_class = "incompleted-job";
					}
					else{
						$complete_class = "completed-job";
					}
				}
				else{
					$complete_class = "completed-job";
				}
 				$list.='<tr class="'.$showClass .' '.$completedTrClass.'" id="jobseleted_'.$records['job_detail_id'].'">
 							<td>'.$records['furniture_description'].'</td>						
							<td>'.$records['aws'].'</td>
							<td>'.$records['min'].'</td>
							<td>'.($linewiseaging > 0 ? $linewiseaging : '').'</td>
							<td>
								<a class=" btn-warning btn btn-sm select-job text-white '.$beginBtnClass.' '.$beginBtnClass2.' '.$not_begin_job.'  '.$records['progress_status'].'" role="button" id="select-job_'.$records['job_detail_id'].'" data-job-detail-id="'.$records['job_detail_id'].'" data-job-no="'.$records['job_card_number'].'"   data-job-id="'.$records['job_card_id'].'" data-technician_id="'.$records['technician_id'].'" >Begin</a>
								<a class=" btn-success btn btn-sm '.$complete_class.' text-white '.$completeBtnClass.'"  role="button" id="completed-job_'.$records['job_detail_id'].'" data-job-detail-id="'.$records['job_detail_id'].'" data-job-no="'.$records['job_card_number'].'"   data-job-id="'.$records['job_card_id'].'" data-technician_id="'.$records['technician_id'].'" >Complete</a>
								'.$Signoff.'
							</td>
 						</tr>';
			}
			 
		} else {
			$list.='<tr>
						<td  style="color: red;">No records available</td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
					</tr>';
		}
		echo json_encode($list);
	}

	public function beginJob()
	{
		$job_detail_id = $this->input->post('job_detail_id');
		$job_id = $this->input->post('job_id');
		$job_no = $this->input->post('job_no');
		$status = $this->input->post('status');
		$job_status = $this->input->post('job_status');
		$technician_id = $this->input->post('technician_id');
		//$userid = $this->session->userdata('user_id');
		$qry = $this->Supervisor_model->beginJob($job_detail_id, $job_id, $job_no, $status, $job_status,$technician_id);
		if ($qry === TRUE) {
			echo json_encode('success');

		} else {
			echo json_encode('error');
		}
	}

	public function completeJob(){
		$job_detail_id = $this->input->post('job_detail_id');
		$job_id = $this->input->post('job_id');
		$job_no = $this->input->post('job_no');
		$status = $this->input->post('status');
		$job_status = $this->input->post('job_status');
		$technician_id = $this->input->post('technician_id');
		$qry = $this->Supervisor_model->completeJob($job_detail_id, $job_id, $job_no, $status, $job_status,$technician_id);
		if($qry === TRUE){
			echo json_encode('success');
		}
		else{
			echo json_encode('error');
		}
	}

	public function SignoffJob(){
		$toDay = date("Y-m-d H:i:s");
		$technician_id = $this->input->post('technician_id');
		$updated_by = $this->session->userdata('user_id');
		$selectqry = $this->db->query("SELECT * FROM `technician_wise_log`WHERE end_time IS NULL AND job_status = 'begin' AND `user_id` ='".$technician_id."' and  `job_flag`=0 order by log_id DESC LIMIT 1");
		if ($selectqry->num_rows() > 0) {
			$result = $selectqry->row();
			$starttimestamp = strtotime($result->job_date);
			$endtimestamp = strtotime($toDay);
			$timediff = abs($endtimestamp - $starttimestamp);
			$hours = floor($timediff / 3600);
			$minutes = floor(($timediff % 3600) / 60);
			$seconds = $timediff % 60;
			$duration = sprintf('%02d:%02d:%02d', $hours, $minutes, $seconds);
			$statusUpdate = $this->db->query("UPDATE `technician_wise_log` SET `job_duration`= '".$duration."',`end_time` = '". $toDay."' , `updated_by` = '".$updated_by."' WHERE job_status = 'begin' AND `end_time` IS NULL AND`user_id` ='". $technician_id."' AND job_flag = 0 AND `log_id` = '". $result->log_id."' ");				 
			if($statusUpdate){
				echo json_encode('success');
			}else{
				echo json_encode('warning');
			}
		}
		else{
			echo json_encode('error');
		}
	}
 }