<?php
class Vehicle_jobcard extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
		$this->load->model('Vehicle');
		$this->load->model('users_model');
		$this->load->model('crud_model');
	}
	public function index($status=''){
		$this->users_model->permission("Job_card", "View");
		$title['headerTitle']="Vehicle Job Card";
		$data['make']  = $this->Vehicle->getMake();
		$data['model']  = $this->Vehicle->getModel();
		$data['customer']  = $this->Vehicle->getCustomer();
		$data['registration']  = $this->Vehicle->getRegistration();
		$data['vjobcard'] = $this->Vehicle->getVjobcard($status);
		$data['vjobcardcount'] = $this->Vehicle->getVjobcardcountarea();
		if(!empty($data['vjobcard'])){
			foreach($data['vjobcard'] as $rec){
				$jobstatusCnt = $this->Vehicle->jobcradStatuslist($rec['id']);
				$jobstatuspendgCnt = $this->Vehicle->jobcradStatuspending($rec['id']);
				$jobstatuscmpltCnt = $this->Vehicle->jobcradStatusCompleted($rec['id']);
				$jobcard_status = array('job_status' => '', 'job_id' => '');  
 				if($jobstatusCnt != false ||  $jobstatusCnt > 0){  
					if($jobstatuspendgCnt  >= $jobstatusCnt){					  
					   $jobcard_status['job_status'] = 'inprogress';				
			  		}else if ($jobstatuscmpltCnt  == $jobstatusCnt){
						$jobcard_status['job_status'] = 'completed';
					}					
				} 
				else{
					$jobcard_status['job_status'] = 'Nodata';
				}			 
				$jobcard_status['job_id'] = $rec['id'];
				$data['jobcard_status'][] = $jobcard_status;
			}
		}		
		$this->load->view('templates/header',$title);
		$this->load->view('furniture/quotations/jobcard/vjobcard',$data);
		$this->load->view('templates/footer');
	}
	public function create_jobcard(){
		if(get_cookie('division_val_id')!=false){ 			 
			$data['enq_no']= $this->crud_model->get_job_no(get_cookie('division_val_id')); 
			$title['h_division_id']=get_cookie('division_val_id'); 
			$data['h_division_id']=get_cookie('division_val_id'); 
		} else { 
			$data['enq_no']= NULL; 
			$title['h_division_id']=NULL; 
			$data['h_division_id']=NULL; 
		}
		$division_id = $this->session->userdata('user_division');
		if(!empty($data['h_division_id'])){
			$data['h_division_id'] = $data['h_division_id'];
		}
		else{
			$data['h_division_id'] = $division_id ;
		}		
		$this->users_model->permission("Job_card", "Add");
		$title['headerTitle']="Create Vehicle Job Card";
		$this->load->view('templates/header',$title);
		$data['make']    = $this->Vehicle->getMake();
		$data['staff']   = $this->Vehicle->getServiceStaff();
		$data['advisor'] = $this->Vehicle->getAdvisorStaff();
		$data['jb_num']  =  $this->crud_model->get_job_no($division_id);
		$data['company_config']   = $this->crud_model->get_companyConfig();
		$data['v_type'] = $this->Vehicle->getVehicleType();
 		$this->load->view('furniture/quotations/jobcard/create_jobcard',$data);
		$this->load->view('templates/footer');
	}
	public function create(){
		$this->users_model->permission("Job_card", "Add");
		$division_id = $this->session->userdata('user_division');
		$reg_no_id = $this->input->post('reg_no');
		//echo $reg_no_id; 
		$dataCheckJbcard = $this->Vehicle->CheckJobcardStatus($reg_no_id);
 			$dbdata = $this->Vehicle->dataRow($reg_no_id);
			$data['company_config']   = $this->crud_model->get_companyConfig();
			$is_chassi = $this->crud_model->is_chassi_number();
			$data['jb_num']  =  $this->crud_model->get_job_no($division_id);
			$cookie_division_val = array(
				'name'   => 'division_val_id',
				'value'  => $this->input->post('division_id'),
				'expire' => 60*60*24*60
			);
			$this->input->set_cookie($cookie_division_val);	
			if(get_cookie('division_val_id')!=false){ 
				$data['enq_no']= $this->crud_model->get_job_no(get_cookie('division_val_id')); 
				$title['h_division_id']=get_cookie('division_val_id'); 
				$data['h_division_id']=get_cookie('division_val_id'); 
			} else { 
				$data['enq_no']= NULL; 
				$title['h_division_id']=NULL; 
				$data['h_division_id']=NULL; 
			}
			$config = array(	
				array(
					'field' => 'v_type',
					'label' => 'Vehicle Type',
					'rules' => 'trim|required',
					'errors' => array(
						'required'      => 'Please Select %s.'
					)
				),				
				array(
						'field' => 'make',
						'label' => 'Make',
						'rules' => 'rtrim|required',
						'errors' => array(
							'required'      => 'Please Select %s.'
						)
				),
				array(
						'field' => 'model',
						'label' => 'Model',
						'rules' => 'trim|required',
						'errors' => array(
							'required'      => 'Please Select %s.'
						)
				),
				array(
				'field' => 'client',
				'label' => 'Customer Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
				),array(
				'field' => 'contact_name',
				'label' => 'Contact Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
				),array(
				'field' => 'contact_num',
				'label' => 'Contact Number',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
				),array(
				'field' => 'km_in',
				'label' => 'Kilometer IN',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
				),array(
				'field' => 'job_card_number',
				'label' => 'Job Number',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please select a division to add %s.'
				)
				),array(
				'field' => 'job_date',
				'label' => 'Date',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please select %s.'
				)
				),array(
				'field' => 'fuel_level',
				'label' => 'Fuel Level',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please select %s.'
				)
				), 
			);	
			if($this->input->post('reg_val') == 1 ){
				$config[] = array(
					'field' => 'reg_no',
					'label' => 'Registration Number',
					'rules' => 'trim|required',
					'errors' => array(
						'required'      => 'Please Enter %s.',
					)
				);
				// $config[] = array(
				// 		'field' => 'chassi_number',
				// 		'label' => 'Chassi Number',
				// 		'rules' => 'trim|required',
				// 		'errors' => array(
				// 			'required'      => 'Please Enter %s.',
				// 		)
				// 	);			
			}
			if($this->input->post('reg_val') == 0 || empty($this->input->post('reg_val'))  ){
				if($reg_no_id != '')
				{
					// $config[] = array(
					// 	'field' => 'reg_no',
					// 	'label' => 'Registration Number',
					// 	'rules' => 'trim|is_unique[reg_no_table.reg_no]',
					// 	'errors' => array(
					// 		'is_unique'      => '%s  is Alreadyssss Exists..'
					// 	)
					// );

					$config[] =	array(
						'field' => 'reg_no',
						'label' => 'Registration Number',
						'rules' => 'trim|required|callback_validate_v_type',
						'errors' => array(
							'required'      => 'Please Enterdd %s.',
							'validate_v_type' => '%s is Already Exists with this Vehicle Type.'
						)
					);	
				}
				else{
					$config[] =	array(
						'field' => 'reg_no',
						'label' => 'Registration Number',
						'rules' => 'trim|required',
						'errors' => array(
							'required'      => 'Please Enter %s.',
						)
					);	
				}
			
				if($is_chassi == 0){	
					$config[] = array(
						'field' => 'chassi_number',
						'label' => 'Chassi Number',
						'rules' => 'trim|required|callback_is_unique[reg_no_table.chassi_number]',
						'errors' => array(
							'required'      => 'Please Enter %s.',
							'is_unique'      => '%s  is Already Exists..'
						)	
					); 						
				}else{
					if(!empty($this->input->post('chassi_number'))){
						$config[] = array(
							'field' => 'chassi_number',
							'label' => 'Chassi Number',
							'rules' => 'trim|callback_is_unique[reg_no_table.chassi_number]',	
							'errors' => array(
								'is_unique'      => '%s  is Already Exists..'
							)
						); 
					}
				}	
			}
			if($data['company_config']->is_advisor == 1){
				$config[] = array(
					'field' => 'advisor',
					'label' => 'Advisor',
					'rules' => 'trim|required',
					'errors' => array(
						'required'      => 'Please Add %s.',
					)
				);
			}
			//'rules' => 'trim|is_unique[reg_no_table.chassi_number]',
			$this->form_validation->set_rules($config);
			$model_id = $this->input->post('model');
			$Client_Id = $this->input->post('client_id');
			$contact_name = $this->input->post('contact_name');
			if ($this->form_validation->run() == FALSE ){
				
				if(!empty(get_cookie('division_val_id'))){
					$data['h_division_id'] = get_cookie('division_val_id');
				}
				else{
					$data['h_division_id'] = $division_id ;
				}
				$data['reg_no']   =  set_value('reg_no');
				$data['make']     =  set_value('make');
				$data['fuel_level']     =  set_value('fuel_level');
				$data['model']    =  $this->Vehicle->getJBCModel($model_id);			
				$data['chassi_number']  =  set_value('chassi_number');
				$data['client']   =  set_value('client');
				//$data['h_division_id'] = get_cookie('division_val_id'); 
				//$data['contact_name'] =  set_value('contact_name');
				//$data['contact_num']  =  set_value('contact_num');
				$data['km_in']      =  set_value('km_in');
				$data['next_km']      =  set_value('next_km');
				$data['job_card_number']  =  set_value('job_card_number');
				$data['job_date']   =  set_value('job_date');			
				$data['car_year']   =  set_value('car_year');
				$data['car_color']  =  set_value('car_color');
				$this->session->set_flashdata('response',''.validation_errors().'',':old:');
				$data['reg_val'] 	= $this->input->post('reg_val');
				$title['headerTitle']="Vehicle Job Card";
				$this->load->view('templates/header',$title);
				$data['make']     = $this->Vehicle->getMake();
				$data['staff']    = $this->Vehicle->getServiceStaff();
				$data['advisor']  = $this->Vehicle->getAdvisorStaff();
				$data['vehicle_type'] = $this->Vehicle->getVehicleType();
				$data['selected_contact'] = $this->Vehicle->get_ContactDetails($Client_Id,$contact_name);
				$this->load->view('furniture/quotations/jobcard/create_Vjobcard',$data);
				$this->load->view('templates/footer');
			}
			else{
				//echo $dataCheckJbcard->job_card_status; exit();
			if($dataCheckJbcard == false || $dataCheckJbcard->job_card_status == 'Completed'){
				$division_id = $this->input->post('division_id');
				$job_card_number  = $this->crud_model->get_job_no($division_id);
				$is_insurance = $this->input->post('is_insurance') !='' || $this->input->post('is_insurance') == 1 ? 1 : 0;
				$contact_name = $this->input->post('contact_name');
				$con_num = $this->input->post('contact_num');
				$client_id = $this->input->post('client_id');
				if(!empty($contact_name) && !empty($con_num ) ){
					$cnt_cntact = $this->db->query("SELECT * FROM `client_contact` where `Client_Id`='$client_id' AND Contact_Name LIke '%$contact_name%' AND Contact_Tel = $con_num ");
					if($cnt_cntact->num_rows() > 0){
						$contact_id = $cnt_cntact->row()->Contact_Id;
					}else{
						$contact_id = $this->input->post('contact_id');
					}
				}
				else{
					$contact_id = $this->input->post('contact_id');
				}
				if($this->input->post('reg_val') == 0  || $this->input->post('reg_val') == "" ){
					$data = array(
						'v_type'	 =>	$this->input->post('v_type'),
						'reg_no'	 =>	$this->input->post('reg_no'),
						'make_id'    => $this->input->post('make'),
						'model_id'   => $this->input->post('model'),
						'client_id'  => $this->input->post('client_id'),				 
						'car_year'   => $this->input->post('car_year'),
						'car_color'  => $this->input->post('car_color'),
						'chassi_number' => $this->input->post('chassi_number'),
						'labour_disc'   => $this->input->post('labour_disc'),
						'parts_disc'    => $this->input->post('parts_disc'),
					);
 					$this->Vehicle->insertregistration($data);
				}
 				$data = array(
					'job_card_number' => $job_card_number,
					'job_card_date' => date('y-m-d', strtotime($this->input->post('job_date'))),
					'client_id' => $this->input->post('client_id'),
					'divisionid' => $division_id,
					'created_user_id' => $this->session->userdata('user_id'),
					'reg_no' =>  $this->input->post('reg_no'),
					'make' =>  $this->input->post('make'),
					'model' =>  $this->input->post('model'),
					'chassi_number' =>  $this->input->post('chassi_number'),
					'car_year' =>  $this->input->post('car_year'),
					'car_color' =>  $this->input->post('car_color'),
					'contact_id' => $contact_id,
					'contact_name' => $contact_name,
					'contact_num' =>  $this->input->post('contact_num'),
					'km_in' =>  $this->input->post('km_in'),
					'next_km' =>  $this->input->post('next_km'),
					'fuel_level' =>  $this->input->post('fuel_level'),
					'is_insurance' =>  $is_insurance,
					'salesman_id' =>  $this->input->post('advisor'),
					'job_card_status' =>  'Draft',
					'job_card_total' =>  $this->input->post('job_card_total'),
					'job_card_vat_perc' =>  10,
					'job_card_vat_amount' =>  $this->input->post('jbcdvat_amount'),
					'job_card_amount_with_vat' =>  $this->input->post('job_card_amount_with_vat'),
					'vtype_id' =>  $this->input->post('v_type'),
				);
				$res = $this->crud_model->insert('job_card',$data);
				$insert_id = $this->db->insert_id();
				if($res != ''){
					$item_id = $this->input->post('item_id');
					$furniture_model = $this->input->post('item');
					$furniture_description =$this->input->post('desc');
					$vat_perce =($this->input->post('item_vat') !='' ?  $this->input->post('item_vat') : 10);
					$vat_amount =$this->input->post('item_vat_amount');
					$item_discount =$this->input->post('item_discount');
					$net_amount =$this->input->post('item_net_amount');
					$section_id =$this->input->post('section_id');
					$technician_id =$this->input->post('technician_id');
					$furniture_quantity =$this->input->post('item_qty');
					$furniture_unitprice =$this->input->post('item_rate');
					$furniture_amount =$this->input->post('item_amount');
					$item_uom =$this->input->post('item_uom');
					$item_uom_id =$this->input->post('item_uom_id');
					$sl = 1;
					if(!empty($item_id)){	
						for($i = 0; $i < count($item_id);$i++ ){
							$data  = array(
								'job_card_id' => $insert_id,
								'sl_no' => $sl++,
								'item_id' => $item_id[$i],
								'furniture_model' =>$furniture_model[$i],
								'furniture_description' =>$furniture_description[$i],
								'furniture_unitprice' =>$furniture_unitprice[$i],
								'furniture_quantity' =>$furniture_quantity[$i],
								'furniture_amount' =>$furniture_amount[$i],
								'uom'	    =>$item_uom[$i],
								'uom_id'    =>$item_uom_id[$i],
								'vat_perce' =>$vat_perce[$i],
								'vat_amount' =>$vat_amount[$i],
								'item_discount' =>$item_discount[$i],
								'net_amount' =>$net_amount[$i],
								'jb_type' =>1,
								'section_id' =>$section_id[$i],
								'technician_id' =>$technician_id[$i],
							);
							$this->Vehicle->insertjobcarddetail($data);
						}
					}
					$date = date("Y-m-d H:i:s");
					$userid = $this->session->userdata('user_id');
					$data= array(						
						'masters_type'=>'Vehicle Job Card',	
						'masters_id'=>$insert_id,	
						'date'=>$date,	
						'created_id'=> $userid,	
						'masters_op'=>'create',	
					);
					$this->crud_model->insert('log_for_masters',$data);
					$this->session->set_flashdata('success', 'Job Card Created');		
					redirect('jobcard/Vehicle_jobcard/editVjobcard/'.$insert_id.'');				
				}
				else{
						$this->session->set_flashdata('response', 'Something WentWrong');					 
						redirect('jobcard/Vehicle_jobcard/create');					 
				}
			}
			else{
				$this->session->set_flashdata('responsemsg', 'Already Having An Opened Job Under This Vehicle Registration '.$reg_no_id.'');					 
				redirect('jobcard/Vehicle_jobcard/create');		
			}
		}
	}
	// Callback function for is_unique validation
public function is_unique($str) {
    $this->db->where('chassi_number', $str);
    $query = $this->db->get('reg_no_table');
    if ($query->num_rows() > 0) {
		$row_detail =  $query->row();
        $this->form_validation->set_message('is_unique', '%s already exists for Vehicle Reg : '.$row_detail->reg_no.'.');
        return FALSE;
    } else {
        return TRUE;
    }
}

	public function add_contact( ) {
		//if($Contact_Id!='' && $Client_Id!=''){
			$Client_Id  	   = $this->input->post('client_id');
			$client_Contact_Name  	   = $this->input->post('client_Contact_Name');
			$client_Contact_Tel  	   = $this->input->post('client_Contact_Tel');
			$client_Contact_designation= $this->input->post('client_Contact_designation');
			$client_Contact_Email  	   = $this->input->post('client_Contact_Email');
			$client_Contact_Address    = $this->input->post('client_Contact_Address');
			$msg = array('message' => '', 'html' => '');
			if($client_Contact_Name!==''){
				if($client_Contact_Tel!==''){
					$data=array(
						'Client_Id'   => $Client_Id,
						'Contact_Name'   => $client_Contact_Name,
						'Contact_Tel' 	 =>	$client_Contact_Tel,
						'designation' 	 =>	$client_Contact_designation,
						'Contact_Email'  =>	$client_Contact_Email,
						'Contact_Address'=>	$client_Contact_Address,
						'Creation_date' =>  date("Y-m-d H:i:s"),
					);
					$records=$this->crud_model->insert('client_contact',$data);

					$get_contact = $this->Vehicle->get_ContactDetails_only($Client_Id); 
					$html= '';
					if(!empty($get_contact)){
						$html  = "<option value=''>Select Contact Person</option>";
						foreach($get_contact AS $rec){
							$html .= "<option data-cnt-id='".$rec['Contact_Id']."' value='".$rec['Contact_Name']." - ".$rec['Contact_Id']."'>".$rec['Contact_Name']."</option>";
						}
					}
					else{
						$html .= "<option value=''>No Data Found</option>";
					}
					$msg['html'] = $html;
					$msg['message'] = 'success';					 				
 
				} else {
					$msg['message'] = 'error';					 	
 
				}
			} else {
				$msg['message']  = 'error';
				
			}
			echo json_encode($msg);
		 
	}


	public function editVjobcard($id = ''){
	//	$this->users_model->permission("Job_card", "Edit");
		$title['headerTitle']="Update Vehicle Job Card";
		$this->load->view('templates/header',$title);
		$data['make']  = $this->Vehicle->getMake();	
		$data['customer'] = $this->Vehicle->getCustomer();	
		$data['staff']    = $this->Vehicle->getServiceStaff();
		$data['advisor']  = $this->Vehicle->getAdvisorStaff();
		$data['technician']  = $this->Vehicle->getServiceStaff();
		$data['vjobcard'] = $this->Vehicle->getVjobcard_detail($id);
		$data['model']    = $this->Vehicle->getregisterModel($data['vjobcard']->make);
		$data['vjobcard_detail'] = $this->Vehicle->getVjobcard_desc($id);
		$data['vjobcard_troubleshhot_service'] = $this->Vehicle->getVjobcard_troubleshhot_service($id);
		$vjobcard_line_service = $this->Vehicle->getVjobcard_line_service($id);
		$Client_Id = $data['vjobcard']->client_id;
		$division_id =  $this->Vehicle->getVjobcard_division($id);
		$data['material_details'] = $this->Vehicle->getPurchaseMaterial_job($id,$division_id);
		$data['material_issue']   = $this->Vehicle->getMaterialIssue_job($id,$division_id);
		$data['ContactDetails']   = $this->Vehicle->get_ContactDetails_only($Client_Id);
		$data['jobtype_spare']	  = $this->Vehicle->Chkjobtype_spare($id);
		$data['jobtype_labour']	  = $this->Vehicle->Chkjobtype_labour($id);
		$data['company_config']   = $this->crud_model->get_companyConfig();
		$data['Unitmasterdata']   = $this->Vehicle->getUnitmasterdata();
		$data['vehicle_discount_limit']  = $this->crud_model->getVehicle_section_DiscountLimit($id);
		$data['select_discount_person']  = $this->Vehicle->getLabourDiscountAdvisor($division_id);
		$data['grouplist']  = $this->Vehicle->getServiceLineGroup();
		$data['servicelistmaster']  = $this->Vehicle->getServiceLineMaster();
		$data['jobcard_technician_tbsht'] =  $this->Vehicle->getJobCardtechnician($id);
		$data['jobcard_technician_servline'] =  $this->Vehicle->getJobCardtechnicianSrvline($id);
		$data['jobcard_technician_rowcnt'] =  $this->Vehicle->getJobCardtechnician($id);
		$data['stock'] =  $this->Vehicle->getstock();
		$data['unit_master'] =  $this->Vehicle->Unitmaster();
		$data['checkByOrder'] = $this->Vehicle->checkByOrder($id);
		$data['checkrfq'] = $this->Vehicle->CheckRfq($id);
		$data['supplier'] = $this->Vehicle->getsupplier();
		$data['quotationstatus'] = $this->Vehicle->getquotationstatus($id);
		$data['quotationupdatestatus'] = $this->Vehicle->getquotationupdatestatus($id);
		$data['rfq_data'] = $this->Vehicle->getRFQdataDetails($id);
		$data['vehicle_type'] = $this->Vehicle->getVehicleType();
		$data['category_view'] = $this->Vehicle->getJobcardCategoryView($id);
		$data['check_quotation'] = $this->Vehicle->cehckQuotationRowData($id);
 		if(!empty($data['vjobcard_detail'])){		
			foreach($data['vjobcard_detail']  as $recs){
				if($recs['jb_type'] == 1){
					$jb_id 	    = $recs['job_card_id'];
					$jb_det_id  = $recs['job_card_details_id'];
					$check_technician_add =  $this->Vehicle->getChecktechnicianadd($jb_id,$jb_det_id);
					$jobcrd_btn_status =  $this->Vehicle->getChecktechniciantable($jb_id,$jb_det_id);
					$jobcard_technician_rowcnt =  $this->Vehicle->getJobCardtechnicianrowcnt($jb_id,$jb_det_id);
					$jbcd_tech = array('job_status' => '', 'job_id' => '', 'job_detailed_id' => '','Jbtch_rowcnt', 'jobcrd_btn_status' => '');  
					if($check_technician_add != false){  
						if($check_technician_add->progress_status == 20){
							if($jobcard_technician_rowcnt <= 1){
								if($check_technician_add->job_technician_status == 2){
									$jbcd_tech['job_status'] =  'inprogress';
								}
								else if($check_technician_add->job_technician_status == 3){
									$jbcd_tech['job_status']  = 'completed';
								}
								else{
									$jbcd_tech['job_status'] =  'pending';
								}
							}
							else{
								$jbcd_tech['job_status'] =  'inprogress';
							}						
						}
						else{
							$jbcd_tech['job_status'] =  'pending';
						}
						// $check_technician_add > 0 ? 'pending' : 'completed';
					}
					else{
						$jbcd_tech['job_status']  = 'completed';
					}
					if($jobcard_technician_rowcnt != false){  
						$jbcd_tech['Jbtch_rowcnt'] = $jobcard_technician_rowcnt > 0 ? $jobcard_technician_rowcnt : '0';
					}
					else{
						$jbcd_tech['Jbtch_rowcnt']  = '0';
					}
					if($jobcrd_btn_status != false){  
						$jbcd_tech['jobcrd_btn_status'] = $jobcrd_btn_status > 0 ? 'Not-allowded' : 'allowed';
					}
					else{
						$jbcd_tech['jobcrd_btn_status']  = 'allowed';
					}
					$jbcd_tech['job_id']          = $jb_id ;
					$jbcd_tech['job_detailed_id'] = $jb_det_id ;
					$data['jbcd_tech'][] = $jbcd_tech;
				}
			}
		}
		if(!empty($data['rfq_data'])){
			foreach($data['rfq_data']  as $recs){
				$getRfqItmCnt = $this->Vehicle->getRfqItemRow($recs['rfq_id']);
				$create_po = array('po_status' => '','supplier_id' => '', 'rfq_id' => ''); 
				if($getRfqItmCnt != false){
					if($getRfqItmCnt->qty != $getRfqItmCnt->po_rfq_qty){
						$create_po['supplier_id'] =  $getRfqItmCnt->supplier_id;
						$create_po['rfq_id'] =  $getRfqItmCnt->rfq_id;
					}
					else{
						$create_po['supplier_id'] =  '';
						$create_po['rfq_id'] =  '';
					}
				} 
				$data['create_po'][] = $create_po;
			}
		}
		$data['vjobcard_line_service'] = $vjobcard_line_service;		
		$this->load->view('furniture/quotations/jobcard/edit_Vjobcard',$data);
		$this->load->view('templates/footer');
	}
	public function edit(){		
		 
		$this->users_model->permission("Job_card", "Edit");
		$job_card_id = $this->input->post('job_card_id');
		$reg_no_id   = $this->input->post('reg_no_id');
		$dbdata = $this->Vehicle->dataRow($reg_no_id);
		$data['company_config']   = $this->crud_model->get_companyConfig();
		$config = array(		 
			// array(
            //         'field' => 'make',
            //         'label' => 'Make',
            //         'rules' => 'rtrim|required',
            //         'errors' => array(
            //             'required'      => 'Please Select %s.'
            //         )
            // ),
			// array(
            //         'field' => 'model',
            //         'label' => 'Model',
            //         'rules' => 'trim|required',
            //         'errors' => array(
            //             'required'      => 'Please Select %s.'
            //         )
			// ),
		  array(
			'field' => 'client',
			'label' => 'Customer Name',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please Enter %s.'
			)
	   		),array(
			'field' => 'contact_name',
			'label' => 'Contact Name',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please Enter %s.'
			)
	   		),array(
			'field' => 'contact_num',
			'label' => 'Contact Number',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please Enter %s.'
			)
	   		),array(
			'field' => 'km_in',
			'label' => 'Kilometer IN',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please Enter %s.'
			)
	   		),array(
			'field' => 'job_card_number',
			'label' => 'Job Number',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please select a division to add %s.'
			)
	   		),array(
			'field' => 'job_date',
			'label' => 'Date',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please select %s.'
			)
	   		),//array(
			// 'field' => 'advisor',
			// 'label' => 'Advisor',
			// 'rules' => 'trim|required',
			// 'errors' => array(
			// 	'required'      => 'Please select %s.'
			// )
	   		// ),array(
			// 'field' => 'item[]',
			// 'label' => 'Labour Charges',
			// 'rules' => 'trim|required',
			// 'errors' => array(
			// 	'required'      => 'Please Add %s For Create Job Card.'
			// )
	   		// ),
		);		
		if($this->input->post('reg_val') == 2 || empty($this->input->post('reg_val'))){
			$config[] = array(
				'field' => 'reg_no',
				'label' => 'Registration Number',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.',
				)
			);	
		}
		if($this->input->post('reg_val') == 0  ){
			if($reg_no_id != '')
			{
				$config[] = array(
					'field' => 'reg_no',
					'label' => 'This Registration Number',
					'rules' => 'trim|is_unique[reg_no_table.reg_no]',
					'errors' => array(
						'is_unique'      => '%s  is Already Exists..'
					)
				);
			}
			else{
				$config[] = array(
					'field' => 'reg_no',
					'label' => 'Registration Number',
					'rules' => 'trim|required',
					'errors' => array(
						'required'      => 'Please Enter %s.',
					)
				);
			}
			$config[] = array(
				'field' => 'chassi_number',
				'label' => 'Chassi Number',
				'rules' => 'trim|is_unique[reg_no_table.chassi_number]',
				'errors' => array(
					'is_unique'      => '%s already exists.'
				)
			); 
				
		}
        $this->form_validation->set_rules($config);
		if ($this->form_validation->run() == FALSE){			
			$data['reg_no']   =  set_value('reg_no');
			$data['make']     =  set_value('make');
			$data['fuel_level']   =  set_value('fuel_level');
			$data['model']    =  set_value('model');			
			$data['chassi_number']  =  set_value('chassi_number');
			$data['client']   =  set_value('client');
			$data['contact_name']  =  set_value('contact_name');
			$data['km_in']  =  set_value('km_in');
			$data['job_card_number']  =  set_value('job_card_number');
			$data['job_date']   =  set_value('job_date');
			$data['advisor']    =  set_value('advisor');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');			
			$title['headerTitle']="Update Vehicle Job Card";
			$this->load->view('templates/header',$title);
			$data['make']  = $this->Vehicle->getMake();	
			$data['customer']  = $this->Vehicle->getCustomer();	
			$data['staff']  = $this->Vehicle->getServiceStaff();
			$data['advisor']  = $this->Vehicle->getAdvisorStaff();
			$data['vjobcard'] = $this->Vehicle->getVjobcard_detail($job_card_id);
			$data['model']  = $this->Vehicle->getregisterModel($data['vjobcard']->model);
			$data['vjobcard_detail'] = $this->Vehicle->getVjobcard_desc($job_card_id);
			$Client_Id = $data['vjobcard']->client_id;
			$data['ContactDetails'] = $this->Vehicle->get_ContactDetails_only($Client_Id);
			redirect('jobcard/Vehicle_jobcard/editVjobcard/'.$job_card_id.'');
		}
		else{
			$where2 = array('job_card_id' => $job_card_id,'jb_type' => 1);
			$this->crud_model->delete('job_card_details',$where2);
			$is_insurance = $this->input->post('is_insurance') !='' || $this->input->post('is_insurance') == 1 ? 1 : 0;
			if($this->input->post('reg_val') == 0 ){
				$data = array(
					'reg_no'	 =>	$this->input->post('reg_no'),
					'make_id' => $this->input->post('make'),
					'model_id' => $this->input->post('model'),
					'client_id' => $this->input->post('client_id'),				 
					'car_year' => $this->input->post('car_year'),
					'car_color' => $this->input->post('car_color'),
					'chassi_number' => $this->input->post('chassi_number'),
				);
			 $this->Vehicle->insertregistration($data);
			}
				/****sp amount****/
				$sp_qnty  = $this->input->post('m_item_qty');
				$sp_furniture_quantity  = $this->input->post('m_furniture_quantity');
				$sp_rate  = $this->input->post('m_item_rate');
				$sp_vat   = $this->input->post('m_item_vat') ;
				$sp_disc   = $this->input->post('m_item_disc');
				$cntitem = $this->input->post('jbcard_detail_id_sp');				
				$sp_total_amount = $sp_net_amount = 0;
 				if (!empty($sp_furniture_quantity) || $sp_furniture_quantity != '') {
					for ($sp = 0; $sp < count($sp_furniture_quantity); $sp++) {
						if (!empty($sp_furniture_quantity[$sp])){
							// Use ternary operators to ensure numeric values
						//	$sp_rate = is_numeric($sp_rate[$sp]) ? floatval($sp_rate[$sp]) : 0;
							$new_sp_vat_p = is_numeric($sp_vat[$sp]) ? floatval($sp_vat[$sp]) : 0;
							$new_sp_disc_value = is_numeric($sp_disc[$sp]) ? floatval($sp_disc[$sp]) : 0;
					
							// Calculate the amount
							$sp_amount = (floatval($sp_furniture_quantity[$sp]) * floatval($sp_rate[$sp])) - $new_sp_disc_value;
							$sp_vat_amnt = (floatval($sp_amount) * $new_sp_vat_p) / 100;
							$sp_net_amount += $sp_amount + $sp_vat_amnt;
						}
					}
				}

				// if(!empty($sp_qnty)){
				// 	for($sp = 0 ; $sp < count($sp_qnty); $sp++){
				// 		//$sp_vat_p   = floatval($sp_vat[$sp]) * 100;
				// 		$sp_vat_p   = floatval($sp_vat[$sp]) ;
				// 		$sp_amount   = (floatval($sp_qnty[$sp]) * floatval($sp_rate[$sp])) -  $sp_disc[$sp];
				// 		$sp_vat_amnt = (floatval($sp_amount) * floatval($sp_vat_p)) / 100;
				// 		$sp_net_amount += $sp_amount + $sp_vat_amnt;
				// 	}
				// }
				/****lb amount****/
				$lb_net_amount = 0;
				$lb_vat_perce     = ($this->input->post('item_vat') !='' ?  $this->input->post('item_vat') : 10);
				$lb_item_discount = $this->input->post('item_discount') !=  "" ? $this->input->post('item_discount') : 0;
				$lb_item_qty      = $this->input->post('item_qty')  !=  "" ? $this->input->post('item_qty') : 0;
				$lb_item_rate     = $this->input->post('item_rate')  !=  "" ? $this->input->post('item_rate') : 0;
				$lb_item_amount   = $this->input->post('item_amount')  !=  "" ? $this->input->post('item_amount') : 0;
				$lb_cntitem       = $this->input->post('job_card_details_id_lb') ;
				if (!empty($lb_cntitem) || $lb_cntitem != '') {
					for ($lb = 0; $lb < count($lb_cntitem); $lb++) {
						if (!empty($lb_cntitem[$lb])) {
							//$current_lb_item_rate   = is_numeric($lb_item_rate[$lb]) ? floatval($lb_item_amount[$lb]) : 0;;
							$current_item_amount   = is_numeric($lb_item_amount[$lb]) ? floatval($lb_item_amount[$lb]) : 0;;
							$current_item_discount = is_numeric($lb_item_discount[$lb]) ? floatval($lb_item_discount[$lb]) : 0;							
							// Calculate amounts
							$lb_amount = $current_item_amount - $current_item_discount;
							$lb_vat_amnt = ($lb_amount * (floatval($lb_vat_perce[$lb]) / 100));
							$lb_net_amount += $lb_amount + $lb_vat_amnt;    
						} 
						// echo $current_item_amount; echo '<br>***';
						// echo $current_item_discount; echo '<br> ***';
						// echo $lb_vat_perce[$lb]; echo '<br> ***';
						// echo $lb_amount; echo '<br>***';
						// echo $lb_vat_amnt; echo '<br>***';
						// echo ($lb_amount + $lb_vat_amnt); echo '<br>***';
						// echo $lb_net_amount; echo '<br><br><br>******';
					}
				}
			//	echo '<br>';
				//echo $lb_net_amount; echo '<br>';
				//echo  $sp_net_amount; exit();

 				$job_card_amount_with_vat = $sp_net_amount + $lb_net_amount;				
				$data = array(
					'job_card_date' => date('y-m-d', strtotime($this->input->post('job_date'))),
					//'client_id' => $this->input->post('client_id'),
					'created_user_id' => $this->session->userdata('user_id'),
					//'reg_no' =>  $this->input->post('reg_no'),
					//'make' =>  $this->input->post('make'),
					//'model' =>  $this->input->post('model'),
					//'car_year' =>  $this->input->post('car_year'),
					//'car_color' =>  $this->input->post('car_color'),
					'contact_id' => $this->input->post('contact_id'),
					'contact_name' =>  $this->input->post('contact_name'),
					'contact_num' =>  $this->input->post('contact_num'),
					'km_in' =>  $this->input->post('km_in'),
					'next_km' =>  $this->input->post('next_km'),
					'fuel_level' =>  $this->input->post('fuel_level'),
					'is_insurance' =>  $is_insurance,
					'salesman_id' =>  $this->input->post('advisor'),
					'job_card_status' =>  'Draft',
					'job_card_total' =>  $job_card_amount_with_vat,
					'job_card_vat_perc' =>  10,
					'job_card_vat_amount' =>  $job_card_amount_with_vat,
					'job_card_amount_with_vat' =>  $job_card_amount_with_vat,
				);
			    $where = array('id' => $job_card_id);
			    $this->crud_model->update('job_card',$data,$where);		 				
			if( $this->input->post('jb_type') == 1)
			{			 
				$item_id = $this->input->post('item_id');
				$furniture_model = $this->input->post('item');
				$furniture_description = $this->input->post('desc');
				$vat_perce = ($this->input->post('item_vat') !='' ?  $this->input->post('item_vat') : 10);
				$vat_amount = $this->input->post('item_vat_amount');
				$item_discount = $this->input->post('item_discount');
				$item_disc_perc = $this->input->post('item_discount_prcnt_lb');
				$net_amount = $this->input->post('item_net_amount');
				$section_id = $this->input->post('section_id');
				$technician_id = $this->input->post('technician_id');
				$furniture_quantity = $this->input->post('item_qty');
				$furniture_unitprice = $this->input->post('item_rate');
				$furniture_amount = $this->input->post('item_amount');
				$job_card_details_id = $this->input->post('job_card_details_id');
				$item_uom = $this->input->post('item_uom');
				$item_uom_id = $this->input->post('item_uom_id');
				$service_troubleshoot = $this->input->post('service_troubleshoot');
				$sl = 1;
				if(!empty($item_id)){	
					for($i = 0; $i < count($item_id);$i++ ){				
						$dataValues  = array(
							'job_card_id' => $job_card_id,
							'sl_no' => $sl++,
							'job_card_details_id'=> $job_card_details_id[$i],
							'item_id' => $item_id[$i],
							'furniture_model' => $furniture_model[$i],
							'furniture_description' => $furniture_description[$i],
							'furniture_unitprice' => 0,
							'furniture_quantity' => $furniture_quantity[$i],
							'furniture_amount' => $furniture_amount[$i],
							'uom'	    => NULL,
							'uom_id'    => NULL,
							'vat_perce' => $vat_perce[$i],
							'vat_amount' => $vat_amount[$i],
							'item_disc_perc' => $item_disc_perc[$i],
							'item_discount' => $item_discount[$i],
							'net_amount' => $net_amount[$i],
							'jb_type' => $this->input->post('jb_type'),
							'section_id' => $section_id[$i],
							//'technician_id' => $technician_id[$i],
							'body_id' =>   '',
							'part_type' =>  '',
							'service_troubleshoot' => $service_troubleshoot[$i],
							'service_group_id' =>   $this->input->post('service_group_id')[$i],
							'aws' =>   $this->input->post('item_aws')[$i],
							'min' =>   $this->input->post('item_min')[$i],
							'job_status' =>   $this->input->post('lb_job_status')[$i]
						);
						$this->Vehicle->UpdateJobdetails($dataValues);
					}
				}	
			}
		 
			// if($this->input->post('m_jb_type') == 2){				  
			// 	$item_id = $this->input->post('m_item_id');
			// 	$furniture_model = $this->input->post('m_item');
			// 	$furniture_description =  $this->input->post('furniture_description');
			// 	$vat_perce =($this->input->post('m_item_vat') !='' ?  $this->input->post('m_item_vat') : 10);
			// 	$vat_amount =$this->input->post('m_item_vat_amount');
			// 	$item_discount =$this->input->post('m_item_discount');
			// 	$item_disc_perc =$this->input->post('m_item_discount_perc');
			// 	$net_amount =$this->input->post('m_item_net_amount');
			// 	$furniture_quantity =$this->input->post('m_item_qty');
			// 	$furniture_unitprice =$this->input->post('m_item_rate');
			// 	$furniture_amount =$this->input->post('m_item_amount');
			// 	$job_card_details_id = $this->input->post('m_job_card_details_id');
			// 	$body_id =  $this->input->post('body_id');
			// 	$part_type  =  $this->input->post('part_type');
			// 	$item_uom =$this->input->post('sp_uom');
			// 	$item_uom_id =$this->input->post('sp_uom_id');
				
			// 	$sl = 1;
			// 	if(!empty($furniture_model)){	
			// 		for($i = 0; $i < count($item_id);$i++ ){
			// 			$m_section_id = $this->input->post('m_section_id')[$i];
			// 			//if(!empty($this->input->post('m_section_id')[$i])){
			// 				$section = explode('-', $m_section_id);
			// 				$section_id = $section[1];
			// 				$technician_id = $section[0];
			// 				$dataValues  = array(
			// 					'job_card_id' => $job_card_id,
			// 					'sl_no' => $sl++,
			// 					'job_card_details_id'=>$job_card_details_id[$i],
			// 					'item_id' => $item_id[$i],
			// 					'furniture_model' =>$furniture_model[$i],
			// 					'furniture_description' =>$furniture_description[$i],
			// 					'furniture_unitprice' =>$furniture_unitprice[$i],
			// 					'furniture_quantity' =>$furniture_quantity[$i],
			// 					'furniture_amount' =>$furniture_amount[$i],
			// 					'vat_perce' =>$vat_perce[$i],
			// 					'uom'	    =>$item_uom[$i],
			// 				    'uom_id'    =>$item_uom_id[$i],
			// 					'vat_amount' =>$vat_amount[$i],
			// 					'item_disc_perc' =>$item_disc_perc[$i],
			// 					'item_discount' =>$item_discount[$i],
			// 					'net_amount' => $net_amount[$i],
			// 					'jb_type' => $this->input->post('m_jb_type'),
			// 					'section_id' => $section_id,
			// 					'technician_id' => $technician_id,
			// 					'body_id' =>   $this->input->post('body_id')[$i],
			// 					'part_type' =>   $this->input->post('part_type')[$i],
			// 					'service_troubleshoot' =>  NULL,
			// 					'service_group_id' =>   NULL,
  			// 					'aws' =>   $this->input->post('item_aws')[$i],
 			// 					'min' =>   $this->input->post('item_min')[$i]
			// 				);	
 			// 				$this->Vehicle->UpdateJobdetails($dataValues);
			// 		  //  }
			// 		}
			// 	}
			//}	
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'	=> 'Vehicle Job Card',	
					'masters_id'	=> $job_card_id,	
					'date'			=>	$date,	
					'created_id'	=> $userid,	
					'masters_op'	=> 'update',	
				);
				$this->crud_model->insert('log_for_masters',$data);
				$this->session->set_flashdata('success', 'Job Card Updated');
		    	redirect('jobcard/Vehicle_jobcard/editVjobcard/'.$job_card_id.'');
		}	
	}

	public function validate_v_type($reg_no)
	{
		$v_type = $this->input->post('v_type');
		if (!$this->Vehicle->is_v_type_valid($reg_no, $v_type)) {
			return false;
		}
		return true;
	}

	public function validate_edit_v_type($reg_no)
	{
		$v_type = $this->input->post('v_type');		
		if(!empty($this->input->post('reg_no_id'))){
			$id  = $this->input->post('reg_no_id');
		}
		else{
			$id  = $this->input->post('regnoid');			
		}
		if (!$this->Vehicle->is_edit_v_type_valid($reg_no, $v_type,$id)) {
			return false;
		}
		return true;
	}

	public function validate_chassi_number()
	{
		$v_type = $this->input->post('v_type');
 		if (!$this->Vehicle->is_chassi_number_valid($v_type,)) {
			return false;
		}
		return true;
	}
	public function validate_edit_chassi_number()
	{
		$v_type = $this->input->post('v_type');
		$id  = $this->input->post('reg_no_id');
		if (!$this->Vehicle->is_edit_chassi_number_valid($v_type, $id)) {
			return false;
		}
		return true;
	}

	public function insurance($id = ''){
		$this->users_model->permission("Job_card", "Edit");
		$title['headerTitle']="Update Vehicle Job Card";
		$where=array(
			'id' => $id
		);
		$records=$this->crud_model->get('job_card',$where); 
		if($records != false){
		 
			$config = array(		 
			array(
				'field' => 'client',
				'label' => 'Insurer Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
				),array(
				'field' => 'lpono',
				'label' => 'LPO Number',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
				),array(
				'field' => 'lpo_date',
				'label' => 'LPO Date',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Add %s.'
				)
				),array(
				'field' => 'claim_no',
				'label' => 'Claim Number',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
				),array(
				'field' => 'claim_amount',
				'label' => 'Claim Amount',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
				)
			);	
	
		    $this->form_validation->set_rules($config);
			if ($this->form_validation->run() == FALSE){
				$data['customer']  = $this->Vehicle->getnewCustomer();
				$data['lpono']		 = $records[0]['lpono'];
				$data['insurer_id']		 = $records[0]['insurer_id'];
				$data['lpo_date']		 = $records[0]['lpo_date'];
				$data['claim_no']		 = $records[0]['claim_no'];
				$data['claim_amount']		 = $records[0]['claim_amount']; 
				$data['id'] = $id;
				$this->load->view('templates/header',$title);
				$this->load->view('furniture/quotations/jobcard/is_insurance',$data);
				$this->load->view('templates/footer'); 
			}
			else{

				$data = array(
					
					'lpono' => $this->input->post('lpono'),
					'insurer_id' => $this->input->post('insurer_id'),
					'lpo_date' => date('y-m-d', strtotime($this->input->post('lpo_date'))),
					'created_user_id' => $this->session->userdata('user_id'),
					'claim_no' =>  $this->input->post('claim_no'),
					'claim_amount' =>  $this->input->post('claim_amount'),
				);
				$where = array('id' => $id);
				$this->crud_model->update('job_card',$data,$where);	
				if ($this->db->trans_status() === FALSE) {
					$this->db->trans_rollback();
					redirect("jobcard/Vehicle_jobcard");
				}
				else {
					$this->db->trans_commit();
				    $this->session->set_flashdata('success', 'Insurer Detailes Updated');
			    	redirect('jobcard/Vehicle_jobcard/insurance/'.$id.'');
				}

			}
	    }
	}

	public function customerComplaints($id = '') {
		$this->users_model->permission("Job_card", "Edit");
		$title['headerTitle']="Update Vehicle Job Card";
		$where=array(
			'id' => $id
		);
		$records=$this->crud_model->get('job_card',$where); 

		if($records != false){			 
			$config = array(		 
				array(
						'field' => 'customer_complaints',
						'label' => 'Customer Complaints Detail',
						'rules' => 'rtrim|required',
						'errors' => array(
							'required'      => 'Please Add  %s.'
						)
				),);
				$this->form_validation->set_rules($config);
			
			if ($this->form_validation->run() == FALSE){ 
				$data['customer_complaints']   =  set_value('customer_complaints');
				$this->session->set_flashdata('response',''.validation_errors().'',':old:');
				$data['customer_complaints']		 = $records[0]['customer_complaints'];
				$data['service_advisor_meassages']	 = $records[0]['service_advisor_meassages'];
				$data['id'] = $id;

				$this->load->view('templates/header',$title);
				$this->load->view('furniture/quotations/jobcard/customer_complaints',$data);
				$this->load->view('templates/footer'); 
			} else{
				
					$user_id	=	$this->session->userdata('user_id');
					$data = array(
						'customer_complaints' => htmlentities($this->input->post('customer_complaints')),
						'service_advisor_meassages' =>  htmlentities($this->input->post('service_advisor_meassages'))
					);
					$this->db->trans_begin();
					$where = array('id' => $id);
			     	$this->crud_model->update('job_card',$data,$where);	
										
					if ($this->db->trans_status() === FALSE) {
						$this->db->trans_rollback();
						redirect("jobcard/Vehicle_jobcard");
					} else {
						$this->db->trans_commit();
					$this->session->set_flashdata('success', 'Customer Complaints Added Successfully');
					redirect('jobcard/Vehicle_jobcard/customerComplaints/'.$id.'');
				}
			}
		}
       	
	}
	public function inventoryDetails($id = '') {
		$this->users_model->permission("Job_card", "Edit");
		$title['headerTitle']="Update Vehicle Job Card";
		$where=array(
			'id' => $id
		);
		$records=$this->crud_model->get('job_card',$where); 
		if($records != false){
			$config = array(
				array(
					'field' => 'inventory_detail_img',
					'label' => 'Customer Inventory Detail',
					'rules' => 'callback_validate_inventory_detail_img',
					'errors' => array(
						'validate_inventory_detail_img' => 'Please select at least one inventory detail image.'
					)
				),
			);
				$this->form_validation->set_rules($config);			 
				//$this->form_validation->set_rules('inventory_detail', 'Customer inventory_detail', 'required');		
			if ($this->form_validation->run() == FALSE){ 
				$data['inventory_detail']   =  set_value('inventory_detail');
				$this->session->set_flashdata('response',''.validation_errors().'',':old:');
				$data['inventory_detail']		 = $records[0]['inventory_detail'];
				$data['inventory_detail_master'] = $this->Vehicle->v_InventoryChecklist();
				$data['id'] = $id;
				$this->load->view('templates/header',$title);
				$this->load->view('furniture/quotations/jobcard/v_inventory_detail',$data);
				$this->load->view('templates/footer'); 
			} 
			else{
				
				$user_id	=	$this->session->userdata('user_id');
				if ($this->input->post('inventory_detail_img')) {
					$inventory_details = $this->input->post('inventory_detail_img');
					if (is_array($inventory_details)) {
						$selected_values = implode(',', $inventory_details);
					} else {
						$selected_values = $inventory_details;
					} 
					$selected_values = rtrim($selected_values, ','); 
				}
				$data = array(
					'inventory_detail' => $selected_values,
				);						
				$this->db->trans_begin();
				$where = array('id' => $id);
				$this->crud_model->update('job_card',$data,$where);	
									
				if ($this->db->trans_status() === FALSE) {
					$this->db->trans_rollback();
					$this->session->set_flashdata('response', 'OOPS!!!...Something WentWrong.Please Try Again.');
					redirect('jobcard/Vehicle_jobcard/inventoryDetails/'.$id.'');
				} else {
					$this->db->trans_commit();
					$this->session->set_flashdata('success', 'Inventory Details Added Successfully');
					redirect('jobcard/Vehicle_jobcard/inventoryDetails/'.$id.'');
				}	
			}
		}
       	
	}

	public function validate_inventory_detail_img($str) {
		if (isset($_POST['inventory_detail_img']) && count($_POST['inventory_detail_img']) > 0) {
			foreach ($_POST['inventory_detail_img'] as $value) {
				if ($value != '') {
					return true; 
				}
			}
			return false; 
		} else {
			return false;
		}
	}

	public function do_draft($id = '',$division_id = ''){
	 
		$this->users_model->permission("Quotation", "Add");
		$this->db->trans_begin();
	    //$id  = $this->input->post('id');
		//$division_id = $this->input->post('division');
		$query_data= $this->db->query("SELECT * FROM `furniture_quotation` WHERE `job_card_id`='$id' limit 1");
		if ($query_data->num_rows()==0){
			$user_id	=	$this->session->userdata('user_id');
			$dbdata = $this->Vehicle->jobCardRow($id);
			// $division=$dbdata->division_id;
			$SQL = "SELECT MAX(quotation_number)+1 as `new_quotation_number` FROM furniture_quotation WHERE `quotation_divisionid`='$division_id';";
			$result = $this->db->query($SQL);
			$data = $result->result_array();
			if($data[0]['new_quotation_number'] != NULL and $data[0]['new_quotation_number'] != ""){
				$quotation_number= $data[0]['new_quotation_number'];
			} else{
				$quotation_number = 10001;
			}
			$query= $this->db->query("SELECT * FROM  `company_division` WHERE division_id='$division_id' and status='1'");
			$division_code=$query->row()->division_code;
			//$division_dbdata = $this->EnquiryModel->company_division($division);
			$qtnmr=$division_code.'-'.$quotation_number;

			if($dbdata->tax_perce==0){
				$vat_percentage=0;
			} else {
				$date=date("Y-m-d");
				$query2= $this->db->query("SELECT * FROM `vat_applicable` WHERE `applicable_date` in (SELECT max(applicable_date) FROM `vat_applicable` where `applicable_date`<'$date') order by `vat_percentage` DESC");
				$vat_percentage=$query2->row()->vat_percentage;
			}
			
			$data = array(
				'quotation_number' 			=> $quotation_number,
				'quotation_number_full' 	=> $qtnmr.'-0',
				'quotation_revisionnumber' 	=> 0,
				'quotation_date'   			=> date("Y-m-d"),
				'quotation_divisionid'    	=> $division_id,
				'client_id'    				=> $dbdata->client_id,
				'contact_id'    			=> $dbdata->contact_id,
				'quotation_vat_percentage'  => $vat_percentage,
				'quotation_vat_amount'  	=> 0,
				'quotation_amount_with_vat'  => 0,
				'quotation_status'    		=> 'Draft',
				'job_card_id'    			=> $id,
				'quotation_type'    		=> 3,
				'reg_no'    				=> $dbdata->reg_no,
				'make_id'    				=> $dbdata->make,
				'model_id'    				=> $dbdata->model,
				'contact_person'    		=> $dbdata->contact_name,
				'contact_p_tel'    			=> $dbdata->contact_num,
				'salesman_id'  				=> $dbdata->salesman_id,
				'status'  					=> 3
			);
			 
			$this->crud_model->insert('furniture_quotation', $data);
			$insert_id = $this->db->insert_id();		
			$list='';
			$i=0;

			$job_data = array(
					'quotation_id' => $insert_id ,
					'qtn_no' => $qtnmr
			);
			$where_1 = array('id' => $id);
			$this->crud_model->update('job_card',$job_data,$where_1);

			$log_data=array(
				'trans_no'  =>  $qtnmr.'-0',
				'trans_type'  =>  'Quotation',
				'trans_op'  =>  'Create',
				'trans_user_id'  =>  $this->session->userdata('user_id')
			);
			$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);
			$log_for_quotationg_data=array(
				'trans_id'  	=>  $insert_id,
				'trans_type'  	=>  'Quotation',
				'trans_action'  =>  'Create',
				'flow_id'  		=>  3,
				'group_by'  	=>  1,
				'trans_user_id' =>  $this->session->userdata('user_id')
			);
			$log_for_transactions=$this->crud_model->insert('log_for_quotation',$log_for_quotationg_data);			
			/* $u_data = array(
				'quotation_number' => $qtnmr,
				'status' => 2
			);
			$this->db->where('id', $Enquiry_Id);
			$this->db->update('enquiry', $u_data); */
			
			if ($this->db->trans_status() === FALSE) {
                    $this->db->trans_rollback();
                    redirect("jobcard/Vehicle_jobcard/index");
                } 
				else {
                    $this->db->trans_commit();
                    $this->session->set_flashdata('success', 'Quotation Created Successfully');
                    $path	=	base_url()."index.php/furniture/furniture_quotation_client_project/index/".$insert_id;
					redirect($path);
             }
			
		} else {
			$this->db->trans_rollback();
			 $this->session->set_flashdata('response', 'Quotation Already created!!! <a target="_blank"  href="'.site_url('furniture/furniture_quotation_client_project/index//'.$query_data->row()->id.'').'" class="btn btn-success view_quotation"><span >Qtn# : '.$query_data->row()->quotation_number.' </span></a>');
			// //$path	=	base_url()."index.php/furniture/furniture_quotation_client_project/index/".$query_data->row()->id;
			// $path	=	base_url()."index.php/furniture/Enquiry/listEnquiry";
			// redirect($path);
			redirect('jobcard/Vehicle_jobcard/editVjobcard/'.$id.'');
		}		
	}

	public function document_attachments($job_no,$division_id) {
		$this->users_model->permission("Job_card", "Edit");
		$dbdata = $this->Vehicle->dataRowdocument($job_no,$division_id);		
		//$this->form_validation->set_rules('job_no', 'Job No', 'required');
		$this->form_validation->set_rules('title', 'Title', 'required');
		$title['headerTitle']="Document Attachments";
		$config = array(		 
			array(
                    'field' => 'title',
                    'label' => 'Title',
                    'rules' => 'rtrim|required',
                    'errors' => array(
                        'required'      => 'Please enter document %s.'
                    )
            ),);
			$this->form_validation->set_rules($config);
		if ($this->form_validation->run() == FALSE){ 
			$data['title']   =  set_value('title');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			//$inventory_item=$this->JobCardModel->inventory_item();
			$vir_files =$this->Vehicle->vir_files($job_no,$division_id);
			$datas   =   array("dbdata" => $dbdata,"vir_files"=>$vir_files);
			$datas['job_no'] = $job_no;
			$datas['division_id'] = $division_id;
			$this->load->view('templates/header',$title);
			$this->load->view('furniture/quotations/jobcard/document_attachments',$datas);
			$this->load->view('templates/footer'); 
		} else{
			
			/*$this->db->where('job_no', $job_no);
			$this->db->where('division_id', $division_id);
			$this->db->delete('vir_files');*/					
			$this->load->library('upload');
			$files = $_FILES;
			$file_upload = $this->input->post('image');
			$file_upload2 = $this->input->post('image2');
			$config['upload_path'] = './images/job_documents/';
			$config['file_name'] = date("YmdHis").'-'.rand(100000, 999999);
			$config['allowed_types'] = '*';
			$config['max_size']= '0';
			$config['overwrite'] = TRUE;
			//ini_set("upload_max_filesize",40M);
			$this->load->library('upload', $config);
			$this->upload->initialize($config);
			
			if ($this->upload->do_upload('image')) {
				$ext = end(explode(".", $_FILES["image"]['name']));
				$datanew = array(
					'job_no' 	 => $job_no,
					'division_id'=> $division_id,
					'title'=> $this->input->post('title'),
					'file_name'  => $config['file_name'].'.'.$ext
				);
				$added = $this->db->insert('vir_files',$datanew);
			} else {
				$this->session->set_flashdata('response', $this->upload->display_errors());
				redirect("jobcard/Vehicle_jobcard/document_attachments/".$job_no."/".$division_id);
			}
			
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				redirect("jobcard/Vehicle_jobcard");
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'Attachment Added Successfully');
				redirect("jobcard/Vehicle_jobcard/document_attachments/".$job_no."/".$division_id);
			}
		}		   
	}

	public function delete_documents($job_no,$division_id,$id){
		if($job_no!='' && $division_id!='' && $id!='' ){
			$this->db->where('vir_files_id', $id);
			$this->db->delete('vir_files');
			$this->session->set_flashdata('success', 'File Deleted Successfully');
			redirect("jobcard/Vehicle_jobcard/document_attachments/".$job_no."/".$division_id);
		} else {
			redirect("jobcard/Vehicle_jobcard");
		}
	}

	public function view_files($job_no,$division_id) {
	    	$data['job_images'] =$this->Vehicle->get_job_images($job_no);
			$data['job_no'] = $job_no;
			$data['division_id'] = $division_id;
			$title['headerTitle']="View Images";
			$this->load->view('templates/header',$title);
			$this->load->view('furniture/quotations/jobcard/view_images',$data);
			$this->load->view('templates/footer'); 
	}

	public function check_job_crd_confirmation(){
		$job_id = $this->input->post('jb_id');
		$check_po_exist = $this->Vehicle->checkPOdata($job_id);
		if($check_po_exist !== NULL){
			$msg = $check_po_exist;
		}
		else{
			$msg = "confirm";
		}
		echo json_encode($msg);
	}
	public function checkPurcahseDataPulled(){
		$job_id = $this->input->post('job_id');
		$check_pur_datapulled = $this->Vehicle->get_check_pulled_pur_data($job_id); 
		echo json_encode($check_pur_datapulled );
	}

	public function checkMaterialIssueDataPulled(){
		$job_id = $this->input->post('job_id');
		$check_material_datapulled = $this->Vehicle->get_check_pulled_material_data($job_id);
		echo json_encode($check_material_datapulled);
	}
	public function checkRateDiff(){
		$job_id = $this->input->post('job_id');
		$check_rate_Job = $this->Vehicle->get_check_rate_Job($job_id);
		$check_rate_quo = $this->Vehicle->get_check_rate_quo($job_id);
		$rata_Array =  array('job_rate' =>  $check_rate_Job, 'qout_rate' => $check_rate_quo );
		echo json_encode($rata_Array);	
	}
	public function checkByorderitemscount(){
		$job_id = $this->input->post('job_id');
		$check_job_item_qty = $this->Vehicle->get_check_Order_Quantity($job_id);
		$check_po_item_qty = $this->Vehicle->get_check_purchase_Order_Quantity($job_id);
		$byorder_array = array('job_item_qty' => $check_job_item_qty , 'po_item_qty' =>$check_po_item_qty);
		echo json_encode($byorder_array);	
	}
	public function checkStockitemscount(){
		$job_id = $this->input->post('job_id');
		$check_job_stock_qty = $this->Vehicle->get_ckeck_jobStock_Quantity($job_id);
		$check_mstock_item_qty = $this->Vehicle->get_check_materialStock_Quantity($job_id);
		$stock_array = array('job_stock_qty' => $check_job_stock_qty, 'material_stock_qty' => $check_mstock_item_qty);
		echo json_encode($stock_array);
	}
	public function check_jobcard_confirmstatus(){
		$job_id = $this->input->post('job_id');
		$check_Job_status = $this->Vehicle->jobcard_confirmstatus($job_id);
 		echo json_encode($check_Job_status);
	}

	public function updateJObcardStatus(){
		$job_id = $this->input->post('job_id');
		$date = date("Y-m-d H:i:s");
		$data = array ( 'job_card_status'=> 'Completed',);
		$update_jobcard_staus  = $this->Vehicle->UpdateJObcardStatus($job_id,$data);
		$datajob_stage = array(
			'job_id' => $job_id,
			'user_id' => $this->session->userdata('user_id'),
			'log_date' => $date,
			'log_status' => 36,
		);
		$this->crud_model->insert('jobcard_track_log',$datajob_stage);	
		echo json_encode($update_jobcard_staus);
	}

	public function getTechnician(){
		$tech_id = $this->input->post('tech_id');
		$staff = $this->Vehicle->getServiceStaff();
		$html = '';
		if(!empty($staff))
		foreach ($staff as $res) {
			     
				if( $res['type'] == 2){
					$selected = $tech_id == $res['staff_id'] ? 'selected="selected"' : '' ;
				$html .= '<option  '.$selected.'   value="'.$res['staff_id'].'-'.$res['section_id'].'">' . $res['staff_name'] . '</option>';
			}
	    }
		echo $html;
	}

	public function send_disc_request(){
		$getresponse = $this->Vehicle->sendDicsRequest();
		echo json_encode($getresponse);
	}

	public function job_history($reg_no = ''){
		$title['headerTitle']="Job History";
		$data['records'] = $this->Vehicle->getJobhistory($reg_no);
		$inv_detail = [];
		if(!empty($data['records'])){
			foreach( $data['records'] as $rec){
				 $inv_detail[] = $this->Vehicle->getInvoiceDetails($rec['invoice_id']);
			}
			$data['inv_detail'] = $inv_detail;
		}
		else{
			$data['inv_detail'] = NULL;
		}
		$data['reg_no'] = $reg_no;
		$this->load->view('templates/header',$title);
		$this->load->view('reports/job_history',$data);
		$this->load->view('templates/footer'); 
	}

	public function printJobcard($job_id,$type=''){
		
		//$this->load->helper(array('dompdf', 'file'));
		 // page info here, db calls, etc.     
		 
		$records = $this->Vehicle->get_vehicle_job_details($job_id);
		if($records == false) {
				$this->session->set_flashdata('response','<div class="alert alert-error">Please Complete JobCard..</div>');
				redirect("jobcard/Vehicle_jobcard");
		}	
		$job_card_id = $records->id;
		$division_id = $records->divisionid;
		
  		$datas['logo']  = $this->Vehicle->getcompany_division($division_id);
		$datas['records'] = $records;
		$datas['company_details']  = $this->Vehicle->getcompany_details();
		$datas['customer']  = $this->Vehicle->getCustomer();
		$datas['make']  = $this->Vehicle->getMake();
		$datas['model']  = $this->Vehicle->getModel();
		// if($job_card_id!=0){
		// 	$this->db->select('job_card_number');
		// 	$this->db->from('job_card');
		// 	$this->db->where('id', $job_card_id);
		// 	$this->db->limit(1);
		// 	$query2 = $this->db->get();
		// 	$records['job_card_number'] = $query2->row()->job_card_number;
		// } else {
		// 	$records['job_card_number'] = "";
		// }

		// $records['logos_url'] = array();
		// $logos_id = explode(",",$records['quotation_logos']);
		// foreach($logos_id as $key=>$logo_id) {
		// 	$where = array('logo_id' => $logo_id);
		// 	$logo = $this->crud_model->get('logos',$where);
		// 	if($logo== true){
		// 		array_push($records['logos_url'], "images/logos/".$logo[0]['logo_filename']);
		// 	}else if($records['logo_filename']){
		// 		array_push($records['logos_url'], "images/company_division/".$records['logo_filename']);
		// 	}
		// }
		
		// $query = $this->db->get('company_details');  
		// $records['company_details'] = $query->row();
		// foreach ($query->result() as $row)
		// {
		// 	$company_email_name =  $row->company_name;
		// }
		//var_dump($records);exit;
		//$this->load->view('general/quotations/printview4', $records);
		 
		//if($type=="pdf"){
			$datas['image'] = "without_image";
			$datas['print_type'] = "pdf_print_type";
			$datas['controller'] = $this;

			$mpdf = new \Mpdf\Mpdf([
				'default_font_size' => 10,
			]);
		//	$datas   =   array("records" => $records,'print_type'=>'pdf_print_type');
			$header = $this->load->view('general/jobcard/jobcard_pdf_header', $datas , true);
			$html = $this->load->view('general/jobcard/jobcard_printview', $datas , true);
			$footer = $this->load->view('general/jobcard/jobcard_pdf_footer', $datas , true);
			
			$mpdf->SetHTMLHeader($header);
			$mpdf->AddPage('P','','','','',15,15,88,20,5,3);
			// Write the HTML content
			$mpdf->WriteHTML($html);

			// Get the total number of pages
			$totalPages = $mpdf->page;

			// Set the footer only on the last page
			if ($totalPages > 0) {
				//$mpdf->AddPage('P','','','','',15,15,82,20,10,0); // Add a new page
				$mpdf->SetHTMLFooter($footer);
				$mpdf->WriteHTML(''); // Write an empty HTML to apply the footer
			}
		//	 echo 'JobCard - '.ucfirst(strtolower($client_name)).' - '.$records->job_card_number;
			$download_path='pdfexport/Quotation/';
			$filename= 'JobCard_'.$records->job_card_number;
			$mpdf->Output($filename, 'I');



			/*$mpdf->SetHTMLFooter($footer);
			$base_url=base_url();
			
			// if($records['invoice_status']==='1'){
			// 	$mpdf->SetWatermarkText('Cancelled');
			// 	$mpdf->showWatermarkText = true;
			// }
			
			$mpdf->WriteHTML($html);
			$download_path='pdfexport/Quotation/';
			$filename='22.pdf';
			//$mpdf->Output($download_path.$filename, 'F');
			$mpdf->Output($filename, 'I');*/
		
		//}else if($type=="normal"){
	//	$records['print_type'] = "normal_print_type";
		//$this->load->view('general/quotations/normal_jobcard_print', $records);
	//	}
		/*else if($type=="email"){
		
		$this->db->select('*');
		$this->db->from('emails'); 
		$query_email = $this->db->get();
		$records_email=$query_email->result_array();
		
		$records['print_type'] = "email_print_type";
		$this->load->helper(array('dompdf', 'file'));
		$html = $this->load->view('general/quotations/printview4', $records, true);
		pdf_create($html, 'Invoice_No_'.$invoice_id,$stream=FALSE);
				
				
				
				$from 		= $records['salesman_email_id'];
				$fromname 	= $company_email_name;
				$to 		= $records['client_email'];
				$cc 		= @$records_email[0]['invoice_cc'];
				$subject 	= 'Invoice';
				$message 	= 'Please find attached invoice';
				$this->load->library('invoice_email');
				$send = $this->invoice_email->send($from,$fromname,$to,$subject,$message,$cc,$bcc="",$invoice_id);
				if($send){
					$this->session->set_flashdata('response','<div class="alert alert-success">Email Send Successfully</div>');
				}else{
					$this->session->set_flashdata('response','<div class="alert alert-error">Something Wrong.Try Again</div>');
				}
				redirect('invoices');
		}*/
		 //$html = $this->load->view('general/quotations/printview1', $records, true);
		 //pdf_create($html, 'Quotation_No_'.$quotation_id);		
		 //if you want to write it to disk and/or send it as an attachment  
	}

	public function service_troubleshoot($id = ''){
		$title['headerTitle']="Service Line Troubleshooting";
		$where=array(
			'id' => $id
		);
		$data['grouplist']  = $this->Vehicle->getServiceLineGroup();
		$records=$this->crud_model->get('job_card',$where); 
		
		if($records != false){
			$config = array(
				array(
					'field' => 'service_group_id[]',
					'label' => 'Checking Line',
					'rules' => 'rtrim|required',
					'errors' => array(
						'required' => 'Please Add Any %s.'
					)
				),
				array(
					'field' => 'furniture_description[]',
					'label' => 'Description',
					'rules' => 'rtrim|required',
					'errors' => array(
						'required' => '%s is required.'
					)
				),
			);
				$this->form_validation->set_rules($config);			 
 			if ($this->form_validation->run() == FALSE){ 
				$data['service_group_id']   =  set_value('service_group_id');
				$this->session->set_flashdata('response',''.validation_errors().'',':old:');
				$service_datalist = array( 
										'job_card_details_id' => '', 
										'service_group_id' => '',  
										'jb_type' => '',  
										'service_troubleshoot' => '',  
										'item_id' => '', 
										'furniture_model' => '', 
										'vat_perce' => '',  
										'furniture_description' => '', 
										'technician_id' => '', 
										'aws' => '', 
										'min' => '', 
										'job_card_technician_id' => '', 
										'job_status' => '', 
										'section_id' => '', 
									);
				$job_service_detail= $this->Vehicle->getServiceTroubleShootlist($id);
				if(!empty($job_service_detail)){
					foreach($job_service_detail	 as  $res){
						if($res['jb_type'] == 1 && $res['service_troubleshoot'] == 0 ){
							$jb_detail_id = $res['job_card_details_id'];
							$service_technician_list = $this->Vehicle->getServiceTechnicianlist($id,$jb_detail_id);	
							if (!empty($service_technician_list) && is_object($service_technician_list)) {
								$technician_id  = $service_technician_list->technician_id;
								$job_card_technician_id = $service_technician_list->id;
							}
							else{
								$technician_id  =  NULL;  $job_card_technician_id = NULL;
							}							
							$service_datalist['job_card_details_id']      =  $jb_detail_id;
							$service_datalist['service_group_id']         =  $res['service_group_id'];
							$service_datalist['jb_type']                  =  $res['jb_type'];
							$service_datalist['service_troubleshoot']     =  $res['service_troubleshoot'];
							$service_datalist['item_id']                  =  $res['item_id'];
							$service_datalist['furniture_model']          =  $res['furniture_model'];
							$service_datalist['vat_perce']                =  $res['vat_perce'];
							$service_datalist['furniture_description']    =  $res['furniture_description'];
							$service_datalist['technician_id']            =  $technician_id;
							$service_datalist['aws']           			  =  $res['aws'];
							$service_datalist['min']            		  =  $res['min'];
							$service_datalist['job_card_technician_id']   =  $job_card_technician_id;
							$service_datalist['job_status']   			  =  $res['job_status'];
							$service_datalist['section_id']   			  =  $res['section_id'];
							$data['service_tbsht_list'][] = $service_datalist;
						}
					}
				}
				$data['id'] = $id;
				$data['staff'] = $this->Vehicle->getServiceStaff();
				$this->load->view('templates/header',$title);
				$this->load->view('furniture/quotations/jobcard/service_line_troubleshooting',$data);
				$this->load->view('templates/footer'); 
			} 
			else{
				$this->db->trans_begin();
				$vmodelID = $this->Vehicle->getVModelJobcardRow($id);
				if($vmodelID != false || $vmodelID != Null){
					$vtypecheck = $this->Vehicle->getVModelTypeRow($vmodelID);
					if($vtypecheck != false){
						$vcategoryFactor = $this->Vehicle->getVcategoryFactorRow($vtypecheck);
					}
				}
				$jobcard_details_id  = $this->input->post('job_card_details_id');
				if (is_array($jobcard_details_id) && !empty(array_filter($jobcard_details_id))) {
					$filtered_jobcard_details_id = array_filter($jobcard_details_id);						
					$unique_jb_det_id = array_unique($filtered_jobcard_details_id);
					$jb_det_idtrim = implode(", ", $unique_jb_det_id);					
					if (!empty($jb_det_idtrim)) {
						$sql_del = $this->db->query("DELETE FROM `job_card_technician` WHERE `job_id` = $id AND `job_detail_id` NOT IN ($jb_det_idtrim) AND `progress_status` = 0 AND `job_technician_status` = 1");
						
						if ($sql_del) {
							$this->db->query("DELETE FROM `job_card_details` WHERE `job_card_id` = $id AND `jb_type` = 1 AND `job_card_details_id` NOT IN ($jb_det_idtrim) AND `job_status` = 1");
						}
					}  
				}
				$service_group_id = $this->input->post('service_group_id');
				if(!empty($service_group_id)){
					$sl = 1;
					$furniture_amount = $vat = $vat_amount = $net_amount = 0;
					$dbdata = $this->Vehicle->jobCardRowData($id);
					$discount_percentage = $this->Vehicle->getVehiclediscount($dbdata->reg_no,$dbdata->vtype_id);
					foreach($service_group_id as $i => $s_id ){						
						if(!empty($this->input->post('job_card_details_id'))){
								$job_card_details_id  = $this->input->post('job_card_details_id')[$i];
								$where2 = array('job_card_id'=>$id ,
								'jb_type' => 1,
								'service_group_id' => $service_group_id[$i],
								'service_troubleshoot' => '0',
								'job_card_details_id' => $job_card_details_id 
					    	);
							$del = $this->crud_model->delete('job_card_details',$where2);
							//if($del  === TRUE){ 
								if(!empty($this->input->post('job_card_technician_id'))){
									$job_card_technician_id  = $this->input->post('job_card_technician_id')[$i];
									$wheretec = array(
										'id'              => $job_card_technician_id ,
										'job_id'          => $id ,
										'job_detail_id'   => $job_card_details_id ,
										'service_troubleshoot' => 0,
										//'progress_status' => 0,
									);
									$this->crud_model->delete('job_card_technician',$wheretec);
								}
							//}							
						}
					}
					$unique_service_group_id = array_unique($service_group_id);
					$service_group_idtrim = implode(", ", $unique_service_group_id);
				    $this->db->query("DELETE FROM `job_card_details` WHERE  `job_card_id` = $id AND `jb_type` = 1  AND `service_group_id` NOT IN ($service_group_idtrim) AND `job_status` = 1");
				    $this->db->query("DELETE FROM `job_card_technician` WHERE  `job_id` = $id AND  `service_group_id` NOT IN ($service_group_idtrim) AND `progress_status` = 0 AND `job_technician_status` = 1");
					for($k = 0; $k < count($service_group_id);$k++) {						
						if(!empty($this->input->post('job_card_details_id')) && $this->input->post('job_card_details_id') !=''){
							$job_card_details_id  = $this->input->post('job_card_details_id')[$k];
						}
						else{
							$job_card_details_id  = '';
						} 	
						if($discount_percentage != false){
 							$labour_dis		= $discount_percentage->labour_disc;
						}
						else{
 							$labour_dis		= 0;
						}

						$aws  =  $this->input->post('service_line_aws')[$k];
						$furniture_amount = floatval($vcategoryFactor) * intval($aws); 
 						$discount  = floatval($furniture_amount) * floatval($labour_dis)/100;
						$vat =  $this->input->post('service_line_vat')[$k] ;
						$vat_amount  = (floatval($furniture_amount) - floatval($discount)) * (intval($vat) / 100);
						$net_amount  = floatval($vat_amount) + (floatval($furniture_amount) - floatval($discount));
						$dataValues  = array(
							'job_card_details_id'   => $job_card_details_id,
							'job_card_id'           => $id,
							'sl_no'                 => $sl++,
							'item_id'               => $this->input->post('item_id')[$k],
							'furniture_model'       => $this->input->post('furniture_model')[$k],
							'furniture_description' => $this->input->post('furniture_description')[$k],
							'furniture_quantity'    => 1,
							'furniture_amount'      => $furniture_amount,
							'vat_perce'             => $vat,
							'vat_amount'            => $vat_amount,
							'item_disc_perc'        => $labour_dis,
							'item_discount'         => $discount,
							'net_amount'            => $net_amount,
          					'jb_type'               => 1,
          					'section_id'            => $this->input->post('section_id')[$k],
 							//'technician_id'         => $this->input->post('technician_list')[$k],
							'service_troubleshoot'  => 0,
  						    //'service_group_id'      => $s_id,
  							'service_group_id'      => $service_group_id[$k],
  							'aws' => $aws,
 							'min' => $this->input->post('service_line_min')[$k],
							'job_status' => 2
						);	
						//var_dump($dataValues);exit();
						$this->crud_model->insert('job_card_details',$dataValues);
						$insert_id = $this->db->insert_id();	
						$date = date("Y-m-d H:i:s");
						if($this->db->trans_status() === TRUE) {
							if(!empty($this->input->post('job_card_technician_id')) ){
								$job_card_technician_id  = $this->input->post('job_card_technician_id')[$k];
 							}
							else{
								$job_card_technician_id  = '';
							} 
								$datatecval = array(
									'id' 			       	=> $job_card_technician_id,
									'job_id' 		       	=> $id,
									'job_detail_id'        	=> $insert_id,
									'technician_id'        	=> $this->input->post('technician_list')[$k],
									'service_group_id'     	=> $service_group_id[$k],
									'service_troubleshoot' 	=> 0,
									'aws'				   	=> $aws,
									'min'                  	=> $this->input->post('service_line_min')[$k],
									'job_technician_status' => 2,
									'progress_status'		=> 0,
									'created_by'			=> $this->session->userdata('user_id'),
									'created_date'          => $date
								);
							$this->db->insert('job_card_technician',$datatecval);
						}
					}
				}									
				if ($this->db->trans_status() === FALSE) {
					$this->db->trans_rollback();
					$this->session->set_flashdata('response', 'OOPS!!!...Something WentWrong.Please Try Again.');
					redirect('jobcard/Vehicle_jobcard/service_troubleshoot/'.$id.'');
				} else {
					$this->db->trans_commit();


					$this->session->set_flashdata('success', 'Service Troubleshoot Details Added Successfully');
					redirect('jobcard/Vehicle_jobcard/service_troubleshoot/'.$id.'');
				}	
			}
		}
				
	}

	public function create_service_troubleshoot_linewise(){
		$id = $this->input->post('id');
		$section_master_id = $this->input->post('section_master_id');
		$get_tb_data = $this->Vehicle->getServiceTroubleshootrow($id);
		$staff = $this->Vehicle->getServiceStaff();
		$html = '';		
 		if($get_tb_data != false){
			$s_id  = $get_tb_data->service_group_id;
			//$s_id = $get_tb_data->slm_id;
			$html = '<tr id="troubleshoot_linewise_'.$id.'"    class="troubleshoot_linewise_'.$id.'">
						<td style="padding: 4px 5px 4px 10px;">
							<input type="hidden" name="job_card_details_id[]"  value=""/>
							<input type="hidden" name="job_card_technician_id[]"  value=""/>
							<input type="hidden" class="service_group_id" name="service_group_id[]"  value="'.$get_tb_data->service_group_id.'"/>
							'.$get_tb_data->group_code.' - '.$get_tb_data->group_name.'
						</td>
						<td style="padding: 4px 5px 4px 10px;">
 							<input type="hidden" name="item_id[]"  value="'.$get_tb_data->slm_id.'"/>
                            <input type="hidden" name="furniture_model[]"  value="'.$get_tb_data->service_name.'"/>
							<input type="hidden" name="service_line_vat[]" value="'.$get_tb_data->vat.'" />
							<input type="hidden" name="section_id[]" value="'.$section_master_id.'" />
                            <input type="text"   class="form-control service_line_name" name="furniture_description[]" value="'.$get_tb_data->service_name.'" style="border: none !important;background-color: #f1f1f9;" />
						</td>
						<td style="padding: 4px 2px 4px 2px;">
							<select class="form-control select2 technician_list" data-placeholder="Select Technician" name="technician_list[]" id="technician_list" autocomplete="off">';
							$html .= '<option value="" selected>Select Technician</option>'; 
							if(!empty($staff)){
								$val = '';
								foreach ($staff as $res) {										 								
 										$service_areas = explode(',', $res['is_service_area']);		
										if( $res['type'] == 2 && in_array($get_tb_data->service_group_id, $service_areas) ){		
										$html .= '<option value="'.$res['staff_id'].'">'.$res['staff_name'].'</option>';
									}
								}
							}
							else{
								$html .= '<option value="">Tecnician Not Added</option>';
							}
						$html .='</select>
						</td>
						<td style="padding: 4px 2px 4px 2px;">
							<input type="text" class="form-control service_line_aws" name="service_line_aws[]" value="'.$get_tb_data->aws.'" style="border: none !important;background-color: #f1f1f9;" />
						</td>
						<td style="padding: 4px 2px 4px 2px;">
							<input type="text" class="form-control service_line_min" name="service_line_min[]" value="0" style="border: none !important;background-color: #f1f1f9;"/>
						</td>
						<td style="padding: 4px 2px 4px 2px;">
							<span class="remove_button remove_button_'.$id.'">
								<button type="button" class="btn btn-danger remove_serv_tr" data-remove-id="'.$id.'"><i class="fe fe-x-circle" style="font-size:16px;"></i></button>
							</span>	
							<span class="">
								<button type="button" data-service-line-setion-id="'.$section_master_id.'"  data-service-group-id="'.$id.'" class="btn  btn-success add_service_line add_service_line_'.$id.'" id="add_service_line_'.$id.'"  data-update-id="id"><i class="fe fe-plus-circle" style="font-size:16px;"></i></button>
							</span>	 
						</td>
					</tr>';
		}
		else{
			//$html = 'error';
		}
		echo json_encode($html);
	}

	public function service_line_items($id = ''){
		$title['headerTitle']="Service Line Items";
		$where=array(
			'id' => $id
		);
		$records=$this->crud_model->get('job_card',$where); 
		if($records != false){
			$config = array(
				array(
					'field' => 'service_group_id[]',
					'label' => 'Checking Line',
					'rules' => 'rtrim|required',
					'errors' => array(
						'required' => 'Please Add Any %s.'
					)
				),
				// array(
				// 	'field' => 'furniture_description[]',
				// 	'label' => 'Description',
				// 	'rules' => 'rtrim|required',
				// 	'errors' => array(
				// 		'required' => '%s is required.'
				// 	)
				// ),
			);
				$this->form_validation->set_rules($config);			 
 			if ($this->form_validation->run() == FALSE){ 
				$data['service_group_id']   =  set_value('service_group_id');
				$this->session->set_flashdata('response',''.validation_errors().'',':old:');
				$data['grouplist']  = $this->Vehicle->getServiceLineGroup();
				//$data['service_tbsht_list']	= $this->Vehicle->getServiceTroubleShootlist($id);				
				$data['service_tbsht_list']	= [];
				$data['id'] = $id;
				$data['staff'] = $this->Vehicle->getServiceStaff();
				$this->load->view('templates/header',$title);
				$this->load->view('furniture/quotations/jobcard/service_line_items',$data);
				$this->load->view('templates/footer'); 
			} 
			else{
				$this->db->trans_begin();
				$vmodelID = $this->Vehicle->getVModelJobcardRow($id);
				$dbdata = $this->Vehicle->jobCardRowData($id);
 				$discount_percentage = $this->Vehicle->getVehiclediscount($dbdata->reg_no,$dbdata->vtype_id);
				if($vmodelID != false || $vmodelID != Null){
					$vtypecheck = $this->Vehicle->getVModelTypeRow($vmodelID);
					if($vtypecheck != false){
						$vcategoryFactor = $this->Vehicle->getVcategoryFactorRow($vtypecheck);
					}
				}
				$service_group_id = $this->input->post('service_group_id');
				if(!empty($service_group_id)){
					$sl = 1;
					$furniture_amount = $vat = $vat_amount = $net_amount = 0;
					//for($i = 0; $i < count($service_group_id);$i++) {
					$checkedLineMasterIds = $this->input->post('line_master_id');
					if(!empty($checkedLineMasterIds)){
						foreach ($checkedLineMasterIds as $key => $lineMasterId) {
							//if ($this->input->post('line_master_id')[$i]) {
							//if (isset($_POST['line_master_id'][$key])) {
								if(!empty($this->input->post('job_card_details_id'))){
									$job_card_details_id  = $this->input->post('job_card_details_id')[$lineMasterId];
								}
								else{
									$job_card_details_id  = '';
								}
								if($discount_percentage != false){
									$labour_dis		= $discount_percentage->labour_disc;
							   }
							   else{
									$labour_dis		= 0;
							   }
								$aws  =  $this->input->post('service_line_aws')[$lineMasterId];
								$furniture_amount = floatval($vcategoryFactor) * intval($aws); 
								$discount  = floatval($furniture_amount) * floatval($labour_dis)/100;
								$vat =  $this->input->post('service_line_vat')[$lineMasterId] ;
								$vat_amount  = (floatval($furniture_amount) - floatval($discount) )* (intval($vat) / 100);
								$net_amount  = floatval($vat_amount) + (floatval($furniture_amount) - floatval($discount) );
								//echo 'furniture_amount **** '.$furniture_amount.'<br> discount *** '.$discount.'<br> vat **** '.$vat.'<br> vat_amount *** '.$vat_amount.'<br>net_amount *** '.$net_amount.'<br>';
								$dataValues  = array(
									'job_card_details_id'   => $this->input->post('job_card_details_id')[$lineMasterId],
									'job_card_id'           => $id,
									'sl_no'                 => $sl++,
									'item_id'               => $lineMasterId,
									'furniture_model'       => $this->input->post('furniture_model')[$lineMasterId],
									'furniture_description' => $this->input->post('furniture_model')[$lineMasterId],
									'furniture_quantity'    => 1,
									'furniture_amount'      => $furniture_amount,
									'vat_perce'             => $vat,
									'vat_amount'            => $vat_amount,
									'item_disc_perc'        => $labour_dis,
									'item_discount'         => $discount,
									'net_amount'            => $net_amount,
									'jb_type'               => 1,
									'section_id'            => $this->input->post('section_id')[$lineMasterId],
									//'technician_id'         => $this->input->post('technician_list')[$lineMasterId],
									'service_group_id'      => $this->input->post('service_group_id')[$lineMasterId],
									'aws' => $aws,
									'min' => $this->input->post('service_line_min')[$lineMasterId]
								);	
								//var_dump($dataValues);exit();
 								 //$this->db->insert('job_card_details',$dataValues);	
								 $this->crud_model->insert('job_card_details',$dataValues);
								 $insert_id = $this->db->insert_id();		
								 $date = date("Y-m-d H:i:s");
								if($this->db->trans_status() === TRUE) { 
									$datatecval = array(
										'job_id' 		       	=> $id,
										'job_detail_id'        	=> $insert_id,
										'technician_id'        	=> $this->input->post('technician_list')[$lineMasterId],
										'service_group_id'     	=> $this->input->post('service_group_id')[$lineMasterId],
										'service_troubleshoot' 	=> 1,
										'aws'				   	=> $aws,
										'min'                  	=> $this->input->post('service_line_min')[$lineMasterId],
										'job_technician_status' => 1,
										'progress_status'		=> 0,
										'created_by'			=> $this->session->userdata('user_id'),
										'created_date'          => $date
									);
									$this->db->insert('job_card_technician',$datatecval);
								}				
						//	}
						}
 					}			
				}						
				if ($this->db->trans_status() === FALSE) {
					$this->db->trans_rollback();
					$this->session->set_flashdata('response', 'OOPS!!!...Something WentWrong.Please Try Again.');
					redirect('jobcard/Vehicle_jobcard/service_line_items/'.$id.'');
				} else {
					$this->db->trans_commit();
					$this->session->set_flashdata('success', 'Service Items Details Added Successfully');
					redirect('jobcard/Vehicle_jobcard/editVjobcard/'.$id.'');
				}	
			}
		}
	}

	public function create_service_item_linewise(){
		$id = $this->input->post('id');
		$jb_id = $this->input->post('jb_id');
		$section_master_id = $this->input->post('section_master_id');
		$get_tb_data = $this->Vehicle->getServicegrouprow($id);
	//	$srv_id  = $get_tb_data->id;
		$staff = $this->Vehicle->getServiceStaff();
		$check_jbcard_gp_id =  $this->Vehicle->getCheckjobcardRow();
		$line_items = $this->Vehicle->getServiceLineItemsList($id);
		$check_line_items = $this->Vehicle->getCheckServiceLineItemsList();
		$html = '';	
		$html = array('msg' => '', 'table_cntent' => '' , 'hidden_select' => '');
		// if($check_jbcard_gp_id == false){
		// 	$html['table_cntent'] .= '<tr id="items_linewise_'.$id.'" class="items_linewise_'.$id.'" >
		// 				<td colspan="4" style="padding: 12px;text-align:center;color: #ff0000;font-size: 14px;font-weight: 600;">TroubleShoot Group is Not Found</td>
		// 			</tr>';
		// }
		//else{		 	
 		if($line_items != false){
			if(!empty($check_line_items)){
				$check_line_itemsArray  = array_column($check_line_items ,'item_id','item_id');
			}
			foreach($line_items  AS $lineres){
				if(isset($lineres['slm_id']) && isset($check_line_itemsArray[$lineres['slm_id']])){
					$check_id = $check_line_itemsArray[$lineres['slm_id']];
				}
				else{
					$check_id = '';
				}
				//if($check_id  !=  $lineres['slm_id']){ //checking line for same service line // disabled option on 12/1/2025 after meeting
				$min = ($lineres['aws'] / 12 ) * 60 ;
				$html['table_cntent'] .= '<tr id="items_linewise_'.$id.'" class="items_linewise_'.$id.'" >
							<td style="padding: 4px 5px 4px 10px; display:flex;">									 
									<input type="hidden" name="furniture_model['.$lineres['slm_id'].']"  value="'.$lineres['service_name'].'" autocomplete="off"/>
									<input type="hidden" name="service_line_vat['.$lineres['slm_id'].']" value="'.$lineres['vat'].'" autocomplete="off" />
									<input type="hidden" name="section_id['.$lineres['slm_id'].']" value="'.$section_master_id.'" autocomplete="off"/>
									<input type="hidden" class="service_group_id" name="service_group_id['.$lineres['slm_id'].']"  value="'.$lineres['service_group_id'].'" autocomplete="off"/>
 									<label class="colorinput" style="vertical-align: middle;">
										<input data-grouping-id="'.$lineres['sub_service_line_id'].'"    name="line_master_id[]" type="checkbox" value="'.$lineres['slm_id'].'" class="line_master_id colorinput-input" autocomplete="off" />
									    <span class="colorinput-color bg-azure"></span>
								       <input type="hidden" name="job_card_details_id['.$lineres['slm_id'].']"  value="" autocomplete="off"/>
									</label>
							    	<span style="text-wrap:wrap;line-height: 21px; padding-top: 5px;"><strong>'.$lineres['service_code'].' - '.$lineres['service_name'].'</strong></span>
							</td>						  
							<td style="padding: 4px 2px 4px 2px;">
								<select class="form-control  technician_list"  name="technician_list['.$lineres['slm_id'].']"   autocomplete="off">';
								$html['table_cntent'] .= '<option value="" selected>Select Technician</option>'; 
 								$option = true;
								if(!empty($staff) || $staff != false){
									$val = '';
									foreach ($staff as $res) {										 								
											$service_areas = explode(',', $res['is_service_area']);		
											if( $res['type'] == 2 && in_array($lineres['service_group_id'], $service_areas) ){		
												$html['table_cntent'] .= '<option value="'.$res['staff_id'].'">'.$res['staff_name'].'</option>';
											}
											$option = false;
									}
								}
								else{
									if($option){
										$html['table_cntent'] .= '<option value ="" selected >No technicians available</option>'; 
									}
								}
							$html['table_cntent'] .='</select>
							</td>
							<td style="padding: 4px 2px 4px 2px; text-align:center;">
								<input type="hidden" class="form-control service_line_aws" name="service_line_aws['.$lineres['slm_id'].']" value="'.$lineres['aws'].'" style="border: none !important;background-color: #f1f1f9;" autocomplete="off" readonly />
							  '.$lineres['aws'].'
							</td>
							<td style="padding: 4px 2px 4px 2px; text-align:center;">
								<input type="hidden" class="form-control service_line_min" name="service_line_min['.$lineres['slm_id'].']" value="'.$min.'" style="border: none !important;background-color: #f1f1f9;" autocomplete="off" readonly/>
								'.$min.'
							</td>
						</tr>';
				//	}
			}

			if(!empty($staff) || $staff != false){
				$val = '';
				$html['hidden_select'] .= '<option value="" selected>Select Technician</option>'; 
				$option = true;
				foreach ($staff as $res) {										 								
						$service_areas = explode(',', $res['is_service_area']);		
						if( $res['type'] == 2 && in_array($id, $service_areas) ){		
							$html['hidden_select'] .= '<option  value="'.$res['staff_id'].'">'.$res['staff_name'].'</option>';
						}
						$option = false;
				}
			}
			else{
				if($option){
					$html['hidden_select'] .= '<option value = "" selected>No technicians available</option>'; 
				}
			}
		}
		else{
			$html['msg'] = 'error';
		}
	//}
		echo json_encode($html);
	}

	public function getServiceTechnician(){
		$tech_id = $this->input->post('tech_id');
		$section_master_id = $this->input->post('sect_id');
		$s_id = $this->input->post('s_id');
		$staff = $this->Vehicle->getServiceStaff();
		$html = '';
		$option = true;
		if(!empty($staff))
		{	$html = '<option value="" selected>Select Technician</option>'; 
			foreach ($staff as $res) {					
				$service_areas = explode(',', $res['is_service_area']);		
				if( $res['type'] == 2 && in_array($s_id, $service_areas) ){		
					$selected = $tech_id == $res['staff_id'] ? 'selected="selected"' : '' ;
					$html .= '<option '.$selected.' value="'.$res['staff_id'].'">'.$res['staff_name'].'</option>';
				}
				$option = false;
			}
		}
		else{
			if($option){
				$html .= '<option value =" " selected>No technicians available</option>'; 
			}
		}
		echo $html;
	}
	public function getTechnicianII(){
		$technician = $this->Vehicle->getNewTechnicianII();
		$newtechnicianlist = $this->Vehicle->getNewTechnicianAddedList();
		$staff = $this->Vehicle->getServiceStaff();
		$technicianArray = array_column($staff,'staff_name','staff_id');
		$html = "";
		$html = array('message' => '', 'html' => '', 'table' => '');		
		if(!empty($newtechnicianlist)){			
			$tech_checkArray = array_column($newtechnicianlist ,'technician_id' ,'technician_id' );
			foreach($newtechnicianlist as $newrec){
				if(isset($newrec['technician_id']) && isset($technicianArray[$newrec['technician_id']])){
						$tech_name = $technicianArray[$newrec['technician_id']];
				}
				else{
					$tech_name = "";
				}
				if($newrec['progress_status'] == 20 ){
					if($newrec['job_technician_status'] == 3 ){
						$inprogress_status = 'Completed';
						$disabled = 'disabled';
						$staus_indication = '<span class="progress-status bg-completed"></span>';
					}
					else{
						$inprogress_status = 'Inprogress';
						$disabled = 'disabled';
						$staus_indication = '<span class="progress-status bg-inprogress"></span>';
					}					
				}
				else if($newrec['progress_status'] == 0){
					$inprogress_status = 'Pending';
					$disabled = '';
					$staus_indication = '<span class="progress-status bg-pending"></span>';
				}
				else{
					$inprogress_status = 'Completed';
					$disabled = 'disabled';
					$staus_indication = '<span class="progress-status bg-completed"></span>';
				}

				$html['table'] .= '<tr id="Row_'.$newrec['id'].'">
							<td>'.$tech_name.'</td>
							<td>'.$staus_indication.' '.$inprogress_status.' </td>
							<td><button class="btn btn-danger btn-sm delete_technician" '.$disabled.' data-technician-name="'.$tech_name.'" data-id="'.$newrec['id'].'"><i class="fa fa-close"></i></button></td>
						</tr>';
			}			
			if(!empty($technician)){
				$html['html']=  '<option value=""></option>';
				foreach($technician as $res){
					if(isset($res['staff_id']) && isset($tech_checkArray[$res['staff_id']])){
						$staff_id = $tech_checkArray[$res['staff_id']];
					}
					else{
						$staff_id ='';
					}
					if($staff_id == $res['staff_id']){
						$staff_status = false;
					}
					else{
						$staff_status = true;
					}
					if($staff_status){
						$html['html'] .= '<option value="'.$res['staff_id'].'">'.$res['staff_name'].'</option>';
					}					
				}			
			}
			$html['message'] = 'success';
		}
		else{
			$html['message'] = false;
		}
		echo json_encode($html);
	}
	public function addnewTechnicianII(){		
		$job_id = $this->input->post('job_id');
		$service_group_id = $this->input->post('service_id');
		$job_detail_id = $this->input->post('detail_id');
		$technician_id = $this->input->post('technician_id');
		$job_status = $this->input->post('job_status');
		$date = date("Y-m-d H:i:s");
		$this->db->trans_begin();
		$dataValues  = array(
			'job_id' => $job_id,
			'job_detail_id'  => $job_detail_id,
			'technician_id'  => $technician_id,
			'service_group_id' => $service_group_id,
			'service_troubleshoot' => 1,
			'aws'           => 0,
			'min'			=> 0,
			'job_technician_status' => $job_status,
			'progress_status' => 0,
			'created_by'			=> $this->session->userdata('user_id'),
			'created_date'          => $date
		);
		$ins = $this->db->insert('job_card_technician',$dataValues);
		if ($this->db->trans_status() === FALSE) {
			$msg = 'error';
			$this->db->trans_rollback();			
		} else {
			$this->db->trans_commit();
			$msg = 'success';
		}	
		echo json_encode($msg);
	}

	public function deleteTchnician() {
		$id = $this->input->post('id');
		$this->db->trans_begin();
		//$where = array('id' => $id, 'job_technician_status'  => 1 , 'progress_status' => 0);
		$where = array('id' => $id, 'progress_status' => 0);
		$this->crud_model->delete('job_card_technician',$where);
		if ($this->db->trans_status() === FALSE) {
			$msg = 'error';
			$this->db->trans_rollback();			
		} else {
			$this->db->trans_commit();
			$msg = 'success';
		}	
		echo json_encode($msg);
	}

	public function DeleteJobcardDetails(){
		$jb_line_id = $this->input->post('jb_line_id');
		$this->db->trans_begin();
		$where 		= array('job_card_details_id' => $jb_line_id, 'job_status' => 1);
		$this->crud_model->delete('job_card_details',$where);
		if ($this->db->trans_status() === FALSE) {			
			$msg = 'error';
			$this->db->trans_rollback();			
		} else {
			$where1 = array('job_detail_id' => $jb_line_id, 'job_technician_status' => 1);
			$this->crud_model->delete('job_card_technician',$where1);
			$this->db->trans_commit();
			$msg = 'success';
		}	
		echo json_encode($msg);
	}

	public function jobconsumables(){
		$job_card_id = $this->input->post('job_card_id');
		$issue_type  = $this->input->post('issue_type');
		$servicegroup  = $this->input->post('servicegroup');
		$group_id  	   = $this->input->post('group_id');
		$stock_desc    = $this->input->post('stock_desc');
		$stock_id	   = $this->input->post('stock_id');
		$stock_qty	   = $this->input->post('stock_qty');
		$consu_vat	   = $this->input->post('consu_vat');
		$uom_spare	   = $this->input->post('uom_spare');
		$spare_uom_name	   = $this->input->post('spare_uom_name');
		$amnt	  	   = $this->input->post('amnt');
		$net_amnt	   = $this->input->post('net_amnt');
		if($stock_id != '' || !empty($stock_id)){
			$stock_id  = $stock_id;
		}
		else{
			$stock_id  = 0;
		}

		$vat_amnt = (( floatval($amnt) *  floatval($stock_qty)   ) * floatval($consu_vat)) /100;
		$this->db->trans_begin();
		$message = array('msg' =>'', 'line_id' => '');
		$data_value = array( 
			    'job_card_id'  => $job_card_id ,
				'item_id'              => $stock_id,
				'furniture_model'      => $stock_desc,
				'furniture_description' => $stock_desc,
				'uom' => $spare_uom_name,
				'uom_id' => $uom_spare, 
				'vat_perce'  => $consu_vat,
				'vat_amount'  => $vat_amnt,
				'jb_type'    => 2,
				'issue_type'    => $issue_type,
				'service_troubleshoot'  => 1,
				'service_group_id' => $group_id ,
				'furniture_quantity' => $stock_qty,
				'furniture_unitprice' => $amnt,
				'furniture_amount' => $net_amnt,
				'net_amount' => $net_amnt,
			);
			$this->crud_model->insert('job_card_details',$data_value);
			$insert_id = $this->db->insert_id();	
 			if ($this->db->trans_status() === FALSE) {
				$message['msg'] = 'error';
				$this->db->trans_rollback();			
			} else {
				$this->db->trans_commit();
				$message['msg'] = 'success';
				$message['line_id'] = $insert_id;
			}	
			echo json_encode($message);		
	}

	public function jobconsumables_remove(){
		$jb_dt_id = $this->input->post('jb_dt_id');
		$this->db->trans_begin();
		$where = array('job_card_details_id' => $jb_dt_id);
		$this->crud_model->delete('job_card_details',$where);
		if ($this->db->trans_status() === FALSE) {
			$message = 'error';
			$this->db->trans_rollback();			
		} else {
			$this->db->trans_commit();
			$message = 'success';
		}	
		echo json_encode($message);		
	}

	public function jobQuotation($id = '',$division = ''){
		$this->users_model->permission("Quotation", "Add");
		$this->db->trans_begin();
		$check_quotation = $this->Vehicle->cehckQuotationRowData($id);
		if($check_quotation  ===  FALSE || $check_quotation == 0 ){
			$dbdata = $this->Vehicle->jobCardRowData($id);
			$dbdatadetail    = $this->Vehicle->jobCardRowDataDetail($id);
			$quotationnumber = $this->Vehicle->getQuotationNum($division);
			$discount_percentage = $this->Vehicle->getVehiclediscount($dbdata->reg_no,$dbdata->vtype_id);
			$unit =	$this->Vehicle->getUnitmasterdata();
			$unitArray = array_column($unit, 'unit_name', 'unit_id');
			if($quotationnumber !=  false){
				$quotation_number = $quotationnumber;
			}
			else{
				$quotation_number = 10001;
			}
			$divisioncode = $this->Vehicle->divisionCode($division);
			if($divisioncode != false){
				$division_code = $divisioncode;
			}
			else{
				$divisioncode = NULL;
			}
			
			if($divisioncode  != NULL){
				$qtnmr =  $division_code.'-'.$quotation_number;
			}
			else{
				$qtnmr = NULL;
			}	
			
			
 			$quoation_data  =  array(
				'quotation_number'       => $quotation_number,
				'quotation_number_full'  => $qtnmr.'-0',
				'quotation_revisionnumber'  => 0,
				'quotation_date' 		    => date("Y-m-d"),
				'quotation_divisionid'      => $division,
				'client_id' 		        => $dbdata->client_id,
				'contact_id'                => $dbdata->contact_id,
				'quotation_vat_percentage'  => 0,
				'quotation_vat_amount'  	=> 0,
				'quotation_amount_with_vat' => 0,
				'quotation_status'    		=> 'Unapproved',//Unapproved
				'job_card_id'    			=> $id,
				'quotation_type'    		=> 3,
				'reg_no'    				=> $dbdata->reg_no,
				'make_id'    				=> $dbdata->make,
				'model_id'    				=> $dbdata->model,
				'chassi_number'    			=> $dbdata->chassi_number,
				'car_year'    				=> $dbdata->car_year,
				'car_color'    				=> $dbdata->car_color,
				'contact_person'    		=> $dbdata->contact_name,
				'contact_p_tel'    			=> $dbdata->contact_num,
				'salesman_id'  				=> $dbdata->salesman_id,
				'status'  					=> 3,
			);
  			$this->crud_model->insert('furniture_quotation',$quoation_data);
			$insert_id = $this->db->insert_id();
			if($dbdatadetail != false)
				{
					$unit_name = $unit_id = "";
					$discount  = $amount = $amount_disc = $vat_amount = $net_amnt = 0;		
					//var_dump($dbdatadetail); exit();
					foreach($dbdatadetail as $datarec){		
						$service_master = $this->Vehicle->getServicelineQuot($datarec['service_group_id']);				
						$stock_id   = $datarec['item_id'];	
						$vat_perce  = $datarec['vat_perce'];			
						if($discount_percentage != false){
							$consumable_dis = $discount_percentage->parts_disc;
							$labour_dis		= $discount_percentage->labour_disc;
						}
						else{
							$consumable_dis = 0;
							$labour_dis		= 0;
						}			
						if($datarec['jb_type'] == 1){
							$amount = $datarec['furniture_amount'];
							$dis_limit = $labour_dis;
							$discount  = floatval($amount) * floatval($labour_dis)/100;
							$unit_id   = "";
							$unit_name   = "";
							$amount_disc = $datarec['item_discount'];
							$vat_amount  = $datarec['vat_amount'];
							$net_amnt	 = $datarec['net_amount'];
							$issue_type  = NULL;
						}
						else{
							if( $datarec['issue_type'] == 'stock'){
								$consumable_amount =  $this->Vehicle->getStockrate($stock_id,$division);
								
								if($consumable_amount != false){
									$sel_price = $consumable_amount->sel_price;
									$amount  = floatval($datarec['furniture_quantity'])  *  floatval($sel_price);
									$unit_id = $consumable_amount->uom_id;
								}else{
									$amount  = 0;
									$unit_id = "";
									$sel_price = 0;
								}
								if(isset($datarec['uom_id']) && isset($unitArray[$datarec['uom_id']])){
									$unit_name  = $unitArray[$datarec['uom_id']];
									$unit_id    = $datarec['uom_id'];
								}
								else{
									$unit_name  =  "";
								}
							}else{
								$amount  = 0;
								$unit_id = $datarec['uom_id'];
								$unit_name  =  $datarec['uom'];
								$sel_price = 0;
							}
							$dis_limit   = $consumable_dis;
							$discount    = floatval($amount) * floatval($consumable_dis)/100; 
							$amount_disc = floatval($amount) - floatval($discount);
							$vat_amount  = floatval($amount_disc) * floatval($vat_perce)/100;
							$net_amnt	 = floatval($amount_disc) + floatval($vat_amount);
							$issue_type  = $datarec['issue_type'];
						}
						if( $datarec['issue_type'] == 'order'){		
							$jb_dtl_id = $datarec['job_card_details_id'];
							$rfqdata = $this->Vehicle->getRFQRowData($id,$jb_dtl_id);		
							if($rfqdata != false){
								$rfq_unit_id   = $rfqdata->uom_id;
								$rfq_unit_name = $rfqdata->uom_name;
								$rfq_item_qty  = $rfqdata->qty;
								$rfq_amount    = $rfqdata->selling_price;
								$rfq_discount      = floatval($rfq_amount * $rfq_item_qty) * floatval($consumable_dis)/100; 
								$rfq_amount_disc   = floatval($rfq_amount * $rfq_item_qty) - floatval($rfq_discount);
								$rfq_vat_amount    = floatval($rfq_amount_disc) * floatval($vat_perce)/100;
								$rfq_net_amnt	   = floatval($rfq_amount_disc) + floatval($rfq_vat_amount);
							}else{
								$rfq_unit_id       = $unit_id;
								$rfq_unit_name     = $unit_name;
								$rfq_item_qty      = $datarec['issued_quantity'];
								$rfq_amount 	   = $amount ;
								$rfq_discount      = floatval($amount * $rfq_item_qty) * floatval($consumable_dis)/100; 
								$rfq_amount_disc   = floatval($amount * $rfq_item_qty) - floatval($discount);
								$rfq_vat_amount    = floatval($amount_disc) * floatval($vat_perce)/100;
								$rfq_net_amnt	   = floatval($amount_disc) + floatval($vat_amount);
							}				
							$quotation_detail_data = array(
								'quotation_id'  => $insert_id, 
								'job_id'		=> $id,
								'job_detail_id'	=> $datarec['job_card_details_id'],
								'furniture_area' =>  $service_master,
								'ex_furniture_area' =>  $datarec['service_group_id'],
								'item_id'		=> $datarec['item_id'],
								'furniture_model'		=> $datarec['furniture_model'],
								'furniture_description' => $datarec['furniture_description'],
								'furniture_uom' 		 => $rfq_unit_id,
								'furniture_uom_name' 	=> $rfq_unit_name,
								'furniture_quantity' => $rfq_item_qty,
								'furniture_unitprice' 	 => $rfq_amount,
								'furniture_amount' 	 => $rfq_amount,
								'vat_perce' 	 => $vat_perce,
								'vat_amount' 	 => $rfq_vat_amount,
								'item_disc_perc' => $dis_limit,
								'item_discount'  => $rfq_discount,
								'net_amount' 	 => $rfq_net_amnt,
								'furniture_type' => $datarec['jb_type'],
								'uom'            => $rfq_unit_name,
								'issue_type' 	 => $issue_type,
								'service_group_id' => $datarec['service_group_id'],
								'service_troubleshoot' => $datarec['service_troubleshoot'],
								'quotation_status' =>'Requested',
							);
						}
						else{
							if( $datarec['jb_type'] == '2'){
									//$item_qty = $datarec['issued_quantity'];
									$item_qty = $datarec['furniture_quantity'];
									$furniture_area =  'Spare Parts';
									$furniture_amount = ($amount * $item_qty ) - $discount;
							}
							else{
								$item_qty = $datarec['furniture_quantity'];
								$furniture_area =  'Labour';
								$furniture_amount = $amount;
							}

							if( $datarec['jb_type'] == '2'){
								//$item_qty = $datarec['issued_quantity'];
								$item_qty = $datarec['furniture_quantity'];
								$furniture_area =  'Spare Parts';
								$furniture_amount = ($sel_price * $item_qty ) - $discount;
								$furniture_unitprice = $sel_price ; 
							}
							else{
								$item_qty = $datarec['furniture_quantity'];
								$furniture_area =  'Labour';
								$furniture_amount = $amount;
								$furniture_unitprice = $amount ; 
							}
							$quotation_detail_data = array(
								'quotation_id'  => $insert_id, 
								'job_id'		=> $id,
								'job_detail_id'	=> $datarec['job_card_details_id'],
								'furniture_area' =>  $service_master,
								'ex_furniture_area' => $datarec['service_group_id'],
								'item_id'		=> $datarec['item_id'],
								'furniture_model' => $datarec['furniture_model'],
								'furniture_description' => $datarec['furniture_description'],
								'furniture_uom' 		 => $unit_id,
								'furniture_uom_name' 	 => $unit_name,
								'furniture_quantity' => $item_qty,
								'furniture_unitprice' 	 => $furniture_unitprice,
								'furniture_amount' 	 => $furniture_amount,
								'vat_perce' 	 => $vat_perce,
								'vat_amount' 	 => $vat_amount,
								'item_disc_perc' => $dis_limit,
								'item_discount'  => $discount,
								'net_amount' 	 => $net_amnt,
								'furniture_type' => $datarec['jb_type'],
								'uom'            => $unit_name,
								'issue_type' 	 => $issue_type,
								'service_group_id' => $datarec['service_group_id'],
								'service_troubleshoot' => $datarec['service_troubleshoot'],
								'quotation_status' =>'Requested',
							);
						}	
						$this->crud_model->insert('furniture_items',$quotation_detail_data);
					}						
				}
			$date = date("Y-m-d H:i:s");
			$job_card_data= array(
				'quotation_id' => $insert_id,
				'qtn_no' =>$qtnmr.'-0',
				'jobcard_stage' =>15,			
			);
			$where_job_card = array(
				'id' => $id
			);
			$this->crud_model->update('job_card',$job_card_data,$where_job_card);
			$datajob_stage = array(
				'job_id' => $id,
				'user_id' => $this->session->userdata('user_id'),
				'log_date' => $date,
				'log_status' => 15,
			);
			$this->crud_model->insert('jobcard_track_log',$datajob_stage);					
			if ($this->db->trans_status() === FALSE) {
				$message = 'error';
				$this->db->trans_rollback();
				$this->session->set_flashdata('response', 'OOPS!!!...Something WentWrong.Please Try Again.');
				redirect('jobcard/Vehicle_jobcard/editVjobcard/'.$insert_id.'');			
			} 
			else {	
				$this->db->trans_commit();
			
				$this->session->set_flashdata('success', 'Quotation Created Successfully');
  				redirect('quotations/Quotations/jobcardQuotation/'.$insert_id.'');
 			}			
		}
		else{
			$this->db->trans_rollback();	
			$this->session->set_flashdata('response', 'Quotation Already created!!! <a target="_blank"  href="'.site_url('quotations/Quotations/jobcardQuotation/'.$check_quotation->id.'').'" class="btn btn-success view_quotation"><span >Qtn# : '.$check_quotation->quotation_number.' </span></a>');
			redirect('jobcard/Vehicle_jobcard/editVjobcard/'.$id.'');
		}
	}

	public function updatejobQuotation($id = '',$q_id='',$division = ''){
		$this->users_model->permission("Quotation", "Add");
		$this->db->trans_begin();
		$check_quotation = $this->Vehicle->cehckQuotationRowData($id);
			
			$dbdata = $this->Vehicle->jobCardRowData($id);
			$dbdatadetail    = $this->Vehicle->jobCardRowDataDetail($id);
			$discount_percentage = $this->Vehicle->getVehiclediscount($dbdata->reg_no,$dbdata->vtype_id);
 			$unit =	$this->Vehicle->getUnitmasterdata();
			$unitArray = array_column($unit, 'unit_name', 'unit_id');
			$insert_id = $q_id;
			if($dbdatadetail != false)
				{
					$unit_name = $unit_id = "";
					$discount  = $amount = $amount_disc = $vat_amount = $net_amnt = 0;		
 					foreach($dbdatadetail as $datarec){		
						$qoutrow =  $this->Vehicle->getQuotationRow($insert_id,$datarec['job_card_details_id'],$id);
						if($qoutrow  ===  FALSE){													
							$service_master = $this->Vehicle->getServicelineQuot($datarec['service_group_id']);				
							$stock_id   = $datarec['item_id'];	
							$vat_perce  = $datarec['vat_perce'];			
							if($discount_percentage != false){
								$consumable_dis = $discount_percentage->parts_disc;
								$labour_dis		= $discount_percentage->labour_disc;
							}
							else{
								$consumable_dis = 0;
								$labour_dis		= 0;
							}			
							if($datarec['jb_type'] == 1){
								$amount = $datarec['furniture_amount'];
								$dis_limit = $labour_dis;
								$discount  = floatval($amount) * floatval($labour_dis)/100;
								$unit_id   = "";
								$unit_name   = "";
								$amount_disc = $datarec['item_discount'];
								$vat_amount  = $datarec['vat_amount'];
								$net_amnt	 = $datarec['net_amount'];
								$issue_type  = NULL;
							}
							else{
								if( $datarec['issue_type'] == 'stock'){
									$consumable_amount =  $this->Vehicle->getStockrate($stock_id,$division);
 									if($consumable_amount != false){
										$sel_price = $consumable_amount->sel_price;
										$amount  = floatval($datarec['furniture_quantity'])  *  floatval($sel_price);
										$unit_id = $consumable_amount->uom_id;
									}else{
										$amount  = 0;
										$unit_id = "";
										$sel_price = 0;
									}
									if(isset($datarec['uom_id']) && isset($unitArray[$datarec['uom_id']])){
										$unit_name  = $unitArray[$datarec['uom_id']];
										$unit_id    = $datarec['uom_id'];
									}
									else{
										$unit_name  =  "";
									}
								}else{
									$amount  = 0;
									$unit_id = $datarec['uom_id'];
									$unit_name  = $datarec['uom'];
									$sel_price  = 0;
								}
								$dis_limit   = $consumable_dis;
								$discount    = floatval($amount) * floatval($consumable_dis)/100; 
								$amount_disc = floatval($amount) - floatval($discount);
								$vat_amount  = floatval($amount_disc) * floatval($vat_perce)/100;
								$net_amnt	 = floatval($amount_disc) + floatval($vat_amount);
								$issue_type  = $datarec['issue_type'];
							}
							if( $datarec['issue_type'] == 'order'){		
								$jb_dtl_id = $datarec['job_card_details_id'];
								$rfqdata = $this->Vehicle->getRFQRowData($id,$jb_dtl_id);		
								if($rfqdata != false){
									$rfq_unit_id   = $rfqdata->uom_id;
									$rfq_unit_name = $rfqdata->uom_name;
									$rfq_item_qty  = $rfqdata->qty;
									$rfq_amount    = $rfqdata->selling_price;
									$rfq_discount      = floatval($rfq_amount * $rfq_item_qty) * floatval($consumable_dis)/100; 
									$rfq_amount_disc   = floatval($rfq_amount * $rfq_item_qty) - floatval($rfq_discount);
									$rfq_vat_amount    = floatval($rfq_amount_disc) * floatval($vat_perce)/100;
									$rfq_net_amnt	   = floatval($rfq_amount_disc) + floatval($rfq_vat_amount);
								}else{
									$rfq_unit_id       = $unit_id;
									$rfq_unit_name     = $unit_name;
									$rfq_item_qty      = $datarec['issued_quantity'];
									$rfq_amount 	   = $amount ;
									$rfq_discount      = floatval($amount * $rfq_item_qty) * floatval($consumable_dis)/100; 
									$rfq_amount_disc   = floatval($amount * $rfq_item_qty) - floatval($discount);
									$rfq_vat_amount    = floatval($amount_disc) * floatval($vat_perce)/100;
									$rfq_net_amnt	   = floatval($amount_disc) + floatval($vat_amount);
								}				
								$quotation_detail_data = array(
									'quotation_id'  => $insert_id, 
									'job_id'		=> $id,
									'job_detail_id'	=> $datarec['job_card_details_id'],
									'furniture_area' =>  $service_master,
									'ex_furniture_area' =>  $datarec['service_group_id'],
									'item_id'		=> $datarec['item_id'],
									'furniture_model'		=> $datarec['furniture_model'],
									'furniture_description' => $datarec['furniture_description'],
									'furniture_uom' 		 => $rfq_unit_id,
									'furniture_uom_name' 	=> $rfq_unit_name,
									'furniture_quantity' => $rfq_item_qty,
									'furniture_unitprice' 	 => $rfq_amount,
									'furniture_amount' 	 => $rfq_amount,
									'vat_perce' 	 => $vat_perce,
									'vat_amount' 	 => $rfq_vat_amount,
									'item_disc_perc' => $dis_limit,
									'item_discount'  => $rfq_discount,
									'net_amount' 	 => $rfq_net_amnt,
									'furniture_type' => $datarec['jb_type'],
									'uom'            => $rfq_unit_name,
									'issue_type' 	 => $issue_type,
									'service_group_id' => $datarec['service_group_id'],
									'service_troubleshoot' => $datarec['service_troubleshoot'],
									'quotation_status' =>'Requested',
								);
							}
							else{
								if( $datarec['jb_type'] == '2'){
										//$item_qty = $datarec['issued_quantity'];
										$item_qty = $datarec['furniture_quantity'];
										$furniture_area =  'Spare Parts';
										$furniture_amount = ($sel_price * $item_qty ) - $discount;
										$furniture_unitprice = $sel_price ; 
								}
								else{
									$item_qty = $datarec['furniture_quantity'];
									$furniture_area =  'Labour';
									$furniture_amount = $amount;
									$furniture_unitprice = $amount ; 
								}
								$quotation_detail_data = array(
									'quotation_id'  => $insert_id, 
									'job_id'		=> $id,
									'job_detail_id'	=> $datarec['job_card_details_id'],
									'furniture_area' =>  $service_master,
									'ex_furniture_area' => $datarec['service_group_id'],
									'item_id'		=> $datarec['item_id'],
									'furniture_model' => $datarec['furniture_model'],
									'furniture_description' => $datarec['furniture_description'],
									'furniture_uom' 		 => $unit_id,
									'furniture_uom_name' 	 => $unit_name,
									'furniture_quantity' => $item_qty,
									'furniture_unitprice' 	 => $furniture_unitprice,
									'furniture_amount' 	 => $furniture_amount,
									'vat_perce' 	 => $vat_perce,
									'vat_amount' 	 => $vat_amount,
									'item_disc_perc' => $dis_limit,
									'item_discount'  => $discount,
									'net_amount' 	 => $net_amnt,
									'furniture_type' => $datarec['jb_type'],
									'uom'            => $unit_name,
									'issue_type' 	 => $issue_type,
									'service_group_id' => $datarec['service_group_id'],
									'service_troubleshoot' => $datarec['service_troubleshoot'],
									'quotation_status' =>'Requested',
								);
							}	
							$this->crud_model->insert('furniture_items',$quotation_detail_data);
						}
						 
					}						
				}
			$date = date("Y-m-d H:i:s");

			$job_card_data= array(
				'jobcard_stage' =>15,			
			);
			$where_job_card = array(
				'id' => $id
			);
			$this->crud_model->update('job_card',$job_card_data,$where_job_card);
			$datajob_stage = array(
				'job_id' => $id,
				'user_id' => $this->session->userdata('user_id'),
				'log_date' => $date,
				'log_status' => 15,
			);
			$this->crud_model->insert('jobcard_track_log',$datajob_stage);				
			if ($this->db->trans_status() === FALSE) {
				$message = 'error';
				$this->db->trans_rollback();
				$this->session->set_flashdata('response', 'OOPS!!!...Something WentWrong.Please Try Again.');
				redirect('jobcard/Vehicle_jobcard/editVjobcard/'.$insert_id.'');			
			} 
			else {	
				$this->db->trans_commit();		
				$this->session->set_flashdata('success', 'Quotation Update Successfully');
  				redirect('quotations/Quotations/jobcardQuotation/'.$insert_id.'');
 			}	
	}

	public function RFQ($id = ''){
		$this->users_model->permission("Quotation", "Add");
 		$title['headerTitle']="RFQ";
		$this->load->view('templates/header',$title);
		$data['vjobcard_detailRFQ'] = $this->Vehicle->getRFQData($id);
		$date=date("Y-m-d");
		$data['vat_percentage_array']=$this->furniture_quotation_model->vat_applicable2($date);
		if($data['vjobcard_detailRFQ'] != false){		
			$data['vjobcard'] = $this->Vehicle->getVjobcard_detail($id);		
			$data['make']  = $this->Vehicle->getMake();
			$data['model']  = $this->Vehicle->getModel();
			$data['customer']  = $this->Vehicle->getCustomer();
			$data['supplier']  = $this->Vehicle->getsupplier();
			$quotrowdata = $this->Vehicle->getRFQquotationRowData($id);
			if($quotrowdata !=false){
				$quotdata = $this->Vehicle->getRFQquotationData($id,$quotrowdata->id);
				if($quotdata != false){
					foreach($quotdata as $record){
						$checkArray = array('status' => '', 'job_dtl_id' => '');
						$checkArray['job_dtl_id'] = $record['job_detail_id'];
						$checkArray['status'] = 'Readonly';

						$data['checkReadonly'][] = $checkArray;
					}
				}
			}			
			$this->load->view('quotations/rfq/rfq',$data);
			$this->load->view('templates/footer'); 	
		}
		else{
			$this->db->trans_begin();
			$getdata = $this->Vehicle->getVjobcard_detailRFQ($id);
			if($getdata != false){
				foreach($getdata as $rec){
					$rfqdata  = array(
						'job_id' 	    => $rec['job_card_id'],
						'job_detail_id' => $rec['job_card_details_id'],
						'item_name'     => $rec['furniture_model'],
						'qty'           => $rec['furniture_quantity'],
						'uom_id'        => $rec['uom_id'],
						'uom_name'      => $rec['uom'],
						'rfq_vat_perc'  => 10,
					);
					$this->crud_model->insert('rfq',$rfqdata);
				}
				if ($this->db->trans_status() === FALSE) {
					$message = 'error';
					$this->db->trans_rollback();
					$this->session->set_flashdata('response', 'OOPS!!!...Something WentWrong.Please Try Again.');
					redirect('jobcard/Vehicle_jobcard/editVjobcard/'.$id.'');			
				} 
				else {	
					$this->db->trans_commit();
					$this->session->set_flashdata('success', 'RFQ Created Successfully');
 					redirect('jobcard/Vehicle_jobcard/RFQ/'.$id .'');
 				}					 
			}
		}	
	}

	public function RFQUpdate($id = ''){
		//$this->users_model->permission("Quotation", "Add");
		$this->db->trans_begin();
		$getdata = $this->Vehicle->getVjobcard_detailRFQ($id);
		if($getdata != false){				
			foreach($getdata as $rec){
				$RFQROW = $this->Vehicle->getRFQdataRow($id,$rec['job_card_details_id']);
				if($RFQROW  === FALSE){
					$rfqdata  = array(
						'job_id' 	    => $rec['job_card_id'],
						'job_detail_id' => $rec['job_card_details_id'],
						'item_name'     => $rec['furniture_model'],
						'qty'           => $rec['furniture_quantity'],
						'uom_id'        => $rec['uom_id'],
						'uom_name'      => $rec['uom'],
						'rfq_vat_perc'  => 10,
					);
					$this->crud_model->insert('rfq',$rfqdata);
				}
			}
			if ($this->db->trans_status() === FALSE) {
				$message = 'error';
				$this->db->trans_rollback();
				$this->session->set_flashdata('response', 'OOPS!!!...Something WentWrong.Please Try Again.');
				redirect('jobcard/Vehicle_jobcard/editVjobcard/'.$id.'');			
			} 
			else {	
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'New Item Created Successfully');
				redirect('jobcard/Vehicle_jobcard/RFQ/'.$id .'');
			}					 
		}
	}

	public function update_rfq(){
		
		$this->users_model->permission("Quotation", "Add");		
		$job_id  		= $this->input->post('job_id');
		$rfq_id  		= $this->input->post('rfq_id');
		$job_detail_id  = $this->input->post('job_detail_id');
		$qty             = $this->input->post('qty');
		$rfq_cost  		= $this->input->post('rfq_cost');
		$rfq_cost  		= $this->input->post('rfq_cost');
		$rfq_amount  	= $this->input->post('rfq_amount');
		$supplier_id  	= $this->input->post('supplier_id');
		$margin  		= $this->input->post('margin');
		$selling_price  = $this->input->post('selling_price');
		$rfq_vat_perc  = $this->input->post('rfq_vat_perc');
		$hrfq_vat_perc  = $this->input->post('hidden_rfq_vat_perc');
		if(!empty($rfq_id) || $rfq_id != '' ){
			$config = array(
				array(
					'field' => 'supplier_id[]',
					'label' => 'Supplier ',
					'rules' => 'rtrim|required',
					'errors' => array(
						'required' => '%s Name is not valide .'
					)
				),
			);
			$this->form_validation->set_rules($config);		
			if ($this->form_validation->run() == FALSE){ 
				$data['service_group_id']   =  set_value('service_group_id');
				$this->session->set_flashdata('response',''.validation_errors().'',':old:');
				redirect('jobcard/Vehicle_jobcard/RFQ/'.$job_id .'');	
			}
			else{
				$this->db->trans_begin();
				for($i = 0 ; $i < count($rfq_id); $i++){
					if(!empty($rfq_vat_perc[$i])){
						$rfq_vatperc = $rfq_vat_perc[$i];
					}
					else{
						$rfq_vatperc = $hrfq_vat_perc[$i];
					}
					//$rfq_vat_amount    = floatval($rfq_amount_disc) * floatval($rfq_vatperc)/100;
					$rfqdata  = array(
						'rfq_cost' 	    => $rfq_cost[$i],
						'rfq_amount' 	=> $rfq_amount[$i],
						'rfq_vat_perc' 	=> $rfq_vatperc,
						'supplier_id'	=> $supplier_id[$i],
						'margin'     	=> $margin[$i],
						'selling_price' => $selling_price[$i],
					);
					$where = array(
						'rfq_id'  => $rfq_id[$i],
					);
					$this->crud_model->update('rfq',$rfqdata,$where);
					//$netmnt = $selling_price[$i] * $qty[$i];
					$vat_amount    = floatval($selling_price[$i] * $qty[$i]) * floatval($rfq_vatperc)/100;
					$jobcard_detaildata = array(
						'furniture_unitprice' => $selling_price[$i],
						'issued_quantity'     => $qty[$i],
						'vat_perce'           => $rfq_vatperc,
 						'furniture_amount' 	  => $selling_price[$i],	
						'vat_amount'       	  => $vat_amount,
 						'net_amount' => (($selling_price[$i] * $qty[$i]) + $vat_amount),	
					);
					$where_jb_id = array(
						'job_card_details_id'  => $job_detail_id[$i],
						'job_card_id'		=> $job_id
					);
					$this->crud_model->update('job_card_details',$jobcard_detaildata,$where_jb_id);
				}
 				if ($this->db->trans_status() === FALSE) {
					$message = 'error';
					$this->db->trans_rollback();
					$this->session->set_flashdata('response', 'OOPS!!!...Something WentWrong.Please Try Again.');
					redirect('jobcard/Vehicle_jobcard/RFQ/'.$job_id .'');			
				} 
				else {	
					$this->db->trans_commit();
					$this->session->set_flashdata('success', 'RFQ Updated Successfully');
					redirect('jobcard/Vehicle_jobcard/RFQ/'.$job_id  .'');
				}
			}
		}
	}

	public function search_service_line_master_job() {
		$group_name	=	$this->input->post('group_name');
		$job_id	=	$this->input->post('job_id');
		$today	=	date("Y-m-d");
		$html	='';
		$sql= "";
		if(is_numeric($group_name)){
			$sql =  "SL.`group_code` = $group_name ";
		}
		else{
			$sql =  " SL.`group_name` like '%$group_name%'";
		}
		
		$query = $this->db->query("SELECT SL.* FROM `service_line_group`  AS SL LEFT JOIN job_card_details AS JB ON JB.`service_group_id` = SL.`id` WHERE $sql   AND SL.`status` = 1 AND JB.`job_card_id` = $job_id  GROUP BY JB.`service_group_id` ");
 		$makeList_data	=	$query->result_array();
		$makeList='';
		foreach($makeList_data as $makeList_datas){
			$html.='<li tabindex="-1" class="search_masterlist master_button" data-mastergroup-name="'.$makeList_datas['group_name'].'"  data-mastergroup_id="'.$makeList_datas['id'].'" >'.$makeList_datas['group_name'].'</li>';
		}
		if(count($makeList_data)==0){
			$html.='<li class="no_result_button">No data found</li>';
		}
		print $html;
	}

	public function ForEstimationTrafser($jb_id){
		$this->db->trans_begin();
		$date = date("Y-m-d H:i:s");
		$job_card_data= array(
			'jobcard_stage' =>10,			
		);
		$where_job_card = array(
			'id' => $jb_id
		);
		$this->crud_model->update('job_card',$job_card_data,$where_job_card);
		$datajob_stage = array(
			'job_id' => $jb_id,
			'user_id' => $this->session->userdata('user_id'),
			'log_date' => $date,
			'log_status' => 10,
		);
		$this->crud_model->insert('jobcard_track_log',$datajob_stage);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			$this->session->set_flashdata('response', 'OOPS!!!...Something WentWrong.Please Try Again.');
			redirect('jobcard/Vehicle_jobcard/editVjobcard/'.$jb_id.'');	
		} else {
			$this->db->trans_commit();
			$this->session->set_flashdata('success', 'Successfully Transfered');
			redirect('jobcard/Vehicle_jobcard/editVjobcard/'.$jb_id.'');	
		}
	}
	// public function WaitngforApproval($jb_id){
	// 	$this->db->trans_begin();
	// 	$date = date("Y-m-d H:i:s");
	// 	$job_card_data= array(
	// 		'jobcard_stage' =>10,			
	// 	);
	// 	$where_job_card = array(
	// 		'id' => $jb_id
	// 	);
	// 	$this->crud_model->update('job_card',$job_card_data,$where_job_card);
	// 	$datajob_stage = array(
	// 		'job_id' => $jb_id,
	// 		'user_id' => $this->session->userdata('user_id'),
	// 		'log_date' => $date,
	// 		'log_status' => 10,
	// 	);
	// 	$this->crud_model->insert('jobcard_track_log',$datajob_stage);
	// 	if ($this->db->trans_status() === FALSE) {
	// 		$this->db->trans_rollback();
	// 		$this->session->set_flashdata('response', 'OOPS!!!...Something WentWrong.Please Try Again.');
	// 		redirect('jobcard/Vehicle_jobcard/editVjobcard/'.$jb_id.'');	
	// 	} else {
	// 		$this->db->trans_commit();
	// 		$this->session->set_flashdata('success', 'Successfully Transfered');
	// 		redirect('jobcard/Vehicle_jobcard/editVjobcard/'.$jb_id.'');	
	// 	}
	// }



}