<?php
class M_dashboard extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
		$this->load->model('Vehicle');
		$this->load->model('users_model');
	}
	public function index(){
		 
		$title['headerTitle']="Vehicle Job Card";
		$data['make']  = $this->Vehicle->getMake();
		$data['model']  = $this->Vehicle->getModel();
		$data['customer']  = $this->Vehicle->getCustomer();
		$data['registration']  = $this->Vehicle->getRegistration();
		$data['vjobcard'] = $this->Vehicle->getMVjobcard();
		$data['v_category'] = $this->Vehicle->getv_category();
		$this->load->view('templates/header',$title);
		$this->load->view('mobile_view/dashboard',$data);
		$this->load->view('templates/footer');
	}
	public function newjob(){
		if(get_cookie('division_val_id')!=false){ 			 
			$data['enq_no']= $this->crud_model->get_job_no(get_cookie('division_val_id')); 
			$title['h_division_id']=get_cookie('division_val_id'); 
			$data['h_division_id']=get_cookie('division_val_id'); 
		} else { 
			$data['enq_no']= NULL; 
			$title['h_division_id']=NULL; 
			$data['h_division_id']=NULL; 
		}
		$this->users_model->permission("Job_card", "Add");
		$title['headerTitle']="Create Vehicle Job Card";
		$this->load->view('templates/header',$title);		 
		$data['make']  = $this->Vehicle->getMake();
		$data['staff']  = $this->Vehicle->getServiceStaff();
		$data['advisor']  = $this->Vehicle->getAdvisorStaff();
		$data['v_category'] = $this->Vehicle->getv_category();
		$this->load->view('mobile_view/create_Vjobcard',$data);
		$this->load->view('templates/footer');
	}
	
	

	public function do_insert(){
		$this->users_model->permission("Job_card", "Add");
		$reg_no_id = $this->input->post('p_reg_no');
		$dataCheckJbcard = $this->Vehicle->CheckJobcardStatus($reg_no_id);
  
	 
		//$dbdata = $this->Vehicle->dataRow($reg_no_id);
		// if(get_cookie('division_val_id')!=false){ 
		// 	$data['enq_no']= $this->crud_model->get_job_no(get_cookie('division_val_id')); 
		// 	$title['h_division_id']=get_cookie('division_val_id'); 
		// 	$data['h_division_id']=get_cookie('division_val_id'); 
		// } else { 
		// 	$data['enq_no']= NULL; 
		// 	$title['h_division_id']=NULL; 
		// 	$data['h_division_id']=NULL; 
		// }
		if(empty($this->input->post('division_id')) ){

			 $this->session->set_flashdata('response', 'Something WentWrong');
			// $title['headerTitle']="erorr";
			// $this->load->view('templates/header',$title);
			// $this->load->view('mobile_view/common_error');
			// $this->load->view('templates/footer');
			$e_code = 503;
			redirect('m/m_dashboard/error/'.$e_code.'');
		}
		else{
			if($dataCheckJbcard == false || $dataCheckJbcard->job_card_status == 'Completed'){
				$division_id = $this->input->post('division_id');
				$job_card_number  = $this->crud_model->get_job_no($division_id);
				$date = date("Y-m-d H:i:s");
				$Creation_date = date("Y-m-d");
				if($this->input->post('chkbox_val') == 0){
					$conatct_id = $this->input->post('contact_id');
					$contact_name = $this->input->post('contact_p_name');
					$contact_num = $this->input->post('p_contact_num');
				}
				else{
					$contact_name = $this->input->post('contact_p_name');
					$contact_num = $this->input->post('p_contact_num');
					$contactdata =  array('Contact_Name' => $contact_name,	
											'Client_Id'  => $this->input->post('client_id'),
											'Contact_Tel' => $contact_num ,
											'Creation_date' => $Creation_date,
											'Created_UserId' => $this->session->userdata('user_id'));
 					$this->crud_model->insert('client_contact',$contactdata);
 					$conatct_id = $this->db->insert_id();
				}
				$data = array(
					'job_card_number' => $job_card_number,
					'job_card_date' => 	$date,
					'client_id' => $this->input->post('client_id'),
					'divisionid' => $division_id,
					'created_user_id' => $this->session->userdata('user_id'),
					'reg_no' =>  $this->input->post('p_reg_no'),
					'make' =>  $this->input->post('make'),
					'model' =>  $this->input->post('model'),
					'car_year' =>  $this->input->post('car_year'),
					'car_color' =>  $this->input->post('car_color'),
					'contact_id' =>  $conatct_id,
					'contact_name' =>  $contact_name,
					'contact_num' => $contact_num ,
					'km_in' =>  $this->input->post('p_km_in'),
					'next_km' =>  '',
					'fuel_level' =>  $this->input->post('fuel_level_p'),
					'is_insurance' =>  '',
					'salesman_id' =>  $this->session->userdata('advisor_id'),
					'job_card_status' =>  'Draft',
					'job_card_total' =>  '',
					'job_card_vat_perc' =>  10,
					'job_card_vat_amount' =>  '',
					'job_card_amount_with_vat' =>  '',
					'vtype_id'		=>   $this->input->post('vtype_n_id'),
					'jobcard_stage' => 0
				);
				$res = $this->crud_model->insert('job_card',$data);
				$insert_id = $this->db->insert_id();
				if(!empty($insert_id)){					
					$where_reg = array(
						'v_type'    => $this->input->post('vtype_n_id'),
						'reg_no LIKE'  => '%'.$this->input->post('p_reg_no').'%',
					);
					$data_reg = array(
						'client_mobile_no' =>  $this->input->post('p_contact_num'),				 
					);
					$this->crud_model->update('reg_no_table',$data_reg,$where_reg); 
					$userid = $this->session->userdata('user_id');
					$datalog= array(						
						'masters_type'=>'Vehicle Job Card_Tab',	
						'masters_id'=>$insert_id,	
						'date'=>$date,	
						'created_id'=> $userid,	
						'masters_op'=>'create',	
					);
					$this->crud_model->insert('log_for_masters',$datalog);		 
			
 					$datajob_stage = array(
						'job_id' => $insert_id,
						'user_id' => $this->session->userdata('user_id'),
						'log_date' => $date,
						'log_status' => 0,
					);
					$this->crud_model->insert('jobcard_track_log',$datajob_stage);
					$this->session->set_flashdata('success', 'Successfully Created New JobCard');
					redirect('m/m_dashboard/view_jobacard/'.$insert_id.'');	
				}
				else{
					$this->session->set_flashdata('response', 'Something WentWrong');
					$title['headerTitle']="erorr";
					$this->load->view('templates/header',$title);
					$this->load->view('mobile_view/common_error');
					$this->load->view('templates/footer');
				}
			}
			else{
				$this->session->set_flashdata('response', 'Already Having An Opened Job Under This Vehicle Registration '.$reg_no_id.'');					 
				redirect('m/m_dashboard/newjob');		
			}
			
		}
		
	}

	public function view_jobacard($insert_id = 0){
		
		$where = array(
			'id' => $insert_id
		);
		$records=$this->crud_model->get('job_card',$where);
				if($records != false){
			 $v_category= $this->Vehicle->getv_category();
			$categoryArray = array_column($v_category , 'type', 'id' );
			if(isset( $records[0]['vtype_id']) && isset( $categoryArray[$records[0]['vtype_id']]) ){
				$vtype_name = $categoryArray[$records[0]['vtype_id']];
			}
			else{
				$vtype_name = "";
			}
			$data['v_category']             = $v_category;
			$data['job_id']					= $records[0]['id'];
			$data['job_card_number']		= $records[0]['job_card_number'];
			$data['client_id']				= $records[0]['client_id'];
			$data['divisionid']				= $records[0]['divisionid'];
			$data['reg_no']					= $records[0]['reg_no'];
			$data['make']					= $records[0]['make'];
			$data['model']					= $records[0]['model'];
			$data['car_year']				= $records[0]['car_year'];
			$data['car_color']				= $records[0]['car_color'];
			$data['contact_id']				= $records[0]['contact_id'];
			$data['contact_name']			= $records[0]['contact_name'];
			$data['contact_num']			= $records[0]['contact_num'];
			$data['km_in']					= $records[0]['km_in'];
			$data['customer_signature']		= $records[0]['customer_signature'];
			$data['customer_complaints']	= $records[0]['customer_complaints'];
			$data['vtype_id']         	    = $records[0]['vtype_id'];
			$data['fuel_level']         	= $records[0]['fuel_level'];
			$data['inventory_detail']      	= $records[0]['inventory_detail'];
			$data['vtype_name']         	= $vtype_name;
			$data['makeArrayval']  			= $this->Vehicle->getMake();	
			$data['customer']  				= $this->Vehicle->getCustomer();
			$data['modelArrayval']  		= $this->Vehicle->getModel();				
			$where2=array(
				'job_id' => $insert_id
			);
			$nb=$this->crud_model->get('job_images',$where2);
			$data['images'] = $nb;

			
			$title['headerTitle']="View Jobcard";
			$this->load->view('templates/header',$title);
			$this->load->view('mobile_view/create_view_Vjobcard',$data);
			$this->load->view('templates/footer');
		}
		else{
			$e_code = 501;
			redirect('m/m_dashboard/error/'.$e_code.'');
		}
	}
	public function add_signature(){
 		$job_id = $this->input->post('job_id');
		$msg = '';
		
		$where = array('id' => $this->input->post('job_id'));
		$data = array(
			'customer_signature' => $this->input->post('customer_signature'),
		);
		$rs=$this->crud_model->update('job_card',$data,$where);
		if($rs===false){
				echo 'error';
		} else  {
			echo 'ok';
		}
	}

	public function getJob(){
		if(get_cookie('division_val_id')!=false){ 			 
			$data['enq_no']= $this->crud_model->get_job_no(get_cookie('division_val_id')); 
			$title['h_division_id']=get_cookie('division_val_id'); 
			$data['h_division_id']=get_cookie('division_val_id'); 
		} else { 
			$data['enq_no']= NULL; 
			$title['h_division_id']=NULL; 
			$data['h_division_id']=NULL; 
		}
		$this->users_model->permission("Job_card", "Add");
		$title['headerTitle']="Get Job";
		$this->load->view('templates/header',$title);		 
		$data['make']  = $this->Vehicle->getMake();
		$data['staff']  = $this->Vehicle->getServiceStaff();
		$data['advisor']  = $this->Vehicle->getAdvisorStaff();
		$data['v_category'] = $this->Vehicle->getv_category();
		$this->load->view('mobile_view/get_job',$data);
		$this->load->view('templates/footer');
	}

	public function add_compliants(){
		$job_id = $this->input->post('job_id');
		$customer_complaints = $this->input->post('customer_complaints');
		$customer_complaints = htmlentities($customer_complaints);
		$customer_complaints = htmlspecialchars($customer_complaints, ENT_QUOTES | ENT_SUBSTITUTE);
		$where = array('id' => $this->input->post('job_id'));
		$data = array(
			'customer_complaints' =>$customer_complaints,
		);
		$rs=$this->crud_model->update('job_card',$data,$where);
		if($rs===false){
				echo 'error';
		} else  {
			echo 'ok';
		}
	}


	public function add_image(){
		$job_no = $this->input->post('job_id');
		$division_id  = $this->input->post('division_id');
		$uniqueID = $job_no.'-'.$division_id;
		if(!file_exists("images/temp/".$uniqueID))
				mkdir("images/temp/".$uniqueID);
				$config['upload_path'] = 'images/temp/'.$uniqueID;
				$config['file_name'] = date("Ymd").'-'.rand(100000, 999999).'-'.$job_no;
				$config['allowed_types'] = '*';
				$config['max_size']= '0';
				//ini_set("upload_max_filesize",40M);
				$this->load->library('upload', $config);
				$this->upload->initialize($config);
				$this->upload->set_allowed_types('*');		
				if ($this->upload->do_upload('uploadedfile')) {
	
					$upload_data = $this->upload->data();
					  $file_name = $upload_data['file_name'];
					$path = 'images/temp/'.$uniqueID.'/'.$file_name;
					$this->load->library('image_lib');
					//echo $path;
					if(!file_exists("images/job/".$uniqueID)){
						mkdir("images/job/".$uniqueID);
					}
					$target_path = 'images/job/'.$uniqueID;
					$configi['image_library'] = 'gd2';
					$configi['source_image']   = $path;
					
					$configi['new_image']   = $target_path;
					$configi['maintain_ratio'] = TRUE;
					$configi['width']  = 1000; // new size
					$configi['height'] = 1000;
					$config['rotation_angle'] = '90';
					
					$this->image_lib->initialize($configi);    
					$this->image_lib->resize();
					$this->image_lib->clear();
	
					unlink('images/temp/'.$uniqueID.'/'.$file_name); 
					$newdata = array('job_id'=>$job_no, 'image'=>$file_name);
					$add_file = $this->db->insert('job_images', $newdata); 
	
					if($add_file){
						$this->session->set_flashdata('success','Image Uploaded Successfully...');
						redirect('m/m_dashboard/view_jobacard/'.$job_no.'');
					}else{
						$this->session->set_flashdata('response','Something Wrong.Try Again...');
						redirect('m/m_dashboard/view_jobacard/'.$job_no.'');
					}
								 
				} else
				{
					$this->session->set_flashdata('response',''.$this->upload->display_errors().'');
					redirect('m/m_dashboard/view_jobacard/'.$job_no.'');					 
			   } 
			//}
			// else{
			// 	$this->session->set_flashdata('error','Sorry!! Take a Image Before Adding Image...');
			// 	redirect('m/m_dashboard/view_jobacard/'.$job_no.'');
			// }  
		}

public function add_imagexx(){
	$job_no = $this->input->post('job_id');
	$division_id  = $this->input->post('division_id');
	$uniqueID = $job_no.'-'.$division_id;
	if(!file_exists("images/temp/".$uniqueID))
			mkdir("images/temp/".$uniqueID);
			$config['upload_path'] = 'images/temp/'.$uniqueID;
			$config['file_name'] = date("Ymd").'-'.rand(100000, 999999).'-'.$job_no;
			$config['allowed_types'] = '*';
			$config['max_size']= '0';
			//ini_set("upload_max_filesize",40M);
			$this->load->library('upload', $config);
			$this->upload->initialize($config);
			$this->upload->set_allowed_types('*');		
			if ($this->upload->do_upload('uploadedfile')) {

				$upload_data = $this->upload->data();
  				$file_name = $upload_data['file_name'];
				$path = 'images/temp/'.$uniqueID.'/'.$file_name;
				$this->load->library('image_lib');
				//echo $path;
				if(!file_exists("images/job/".$uniqueID)){
					mkdir("images/job/".$uniqueID);
				}
				$target_path = 'images/job/'.$uniqueID;
				$configi['image_library'] = 'gd2';
				$configi['source_image']   = $path;
				
				$configi['new_image']   = $target_path;
				$configi['maintain_ratio'] = TRUE;
				$configi['width']  = 1000; // new size
				$configi['height'] = 1000;
				$config['rotation_angle'] = '90';
				
				$this->image_lib->initialize($configi);    
				$this->image_lib->resize();
				$this->image_lib->clear();

				unlink('images/temp/'.$uniqueID.'/'.$file_name);
				$newdata = array('job_id'=>$job_no, 'image'=>$file_name);
				$add_file = $this->db->insert('job_images', $newdata); 

				if($add_file){
					$this->session->set_flashdata('success','Image Uploaded Successfully...');
					redirect('m/m_dashboard/view_jobacard/'.$job_no.'');
				}else{
					$this->session->set_flashdata('response','Something Wrong.Try Again...');
					redirect('m/m_dashboard/view_jobacard/'.$job_no.'');
				}
							 
			} else
			{
				$this->session->set_flashdata('response',''.$this->upload->display_errors().'');
				redirect('m/m_dashboard/view_jobacard/'.$job_no.'');
				 
		   } 
		//}
		// else{
		// 	$this->session->set_flashdata('error','Sorry!! Take a Image Before Adding Image...');
		// 	redirect('m/m_dashboard/view_jobacard/'.$job_no.'');
		// }  
    }

	public function add_new_registration(){
		$this->users_model->permission("Job_card", "Add");
		$title['headerTitle']="New Registration";
		$data['v_category'] = $this->Vehicle->getv_category();
		$this->load->view('templates/header',$title);
		$this->load->view('mobile_view/add_vehicle',$data);
		$this->load->view('templates/footer');

	}

	public function add_registration(){
		$is_chassi = $this->crud_model->is_chassi_number();
		$config = array(
			// array(
			// 	'field' => 'reg_no',
			// 	'label' => 'Registration Number',
			// 	'rules' => 'trim|required|is_unique[reg_no_table.reg_no]',
			// 	'errors' => array(
			// 		'is_unique'      => 'This %s is Already Exists..',
			// 		'required'      => 'Please Enter %s.'
			// 	)
			array(
				'field' => 'v_type',
				'label' => 'Vehicle Type',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Select %s.'
				)
		   ),
			array(
				'field' => 'reg_no',
				'label' => 'Registration Number',
				'rules' => 'trim|required|callback_validate_v_type',
				'errors' => array(
					'required'      => 'Please Enter %s.',
					'validate_v_type' => '%s is Already Exists with this Vehicle Type.'
				)
			
				),array(
                    'field' => 'make',
                    'label' => 'Make',
                    'rules' => 'rtrim|required',
                    'errors' => array(
                        'required'      => 'Please Enter Vehicle %s.'
                    )
            ),
			array(
                    'field' => 'model',
                    'label' => 'Model',
                    'rules' => 'trim|required',
                    'errors' => array(
                        'required'      => 'Please Choose Any Vehicle %s.'
                    )
			),
		//   array(
		// 		'field' => 'client',
		// 		'label' => 'Customer Name',
		// 		'rules' => 'trim|required',
		// 		'errors' => array(
		// 		'required'      => 'Please Enter %s.'
		// 		)
		// 		),
		// array(
		// 	'field' => 'client_id',
		// 	'label' => 'Customer Name',
		// 	'rules' => 'trim|required',
		// 	'errors' => array(
		// 	'required'      => '%s Not Found.'
		// 	)
		// ),					
		);	

		if(!empty($this->input->post('client'))){
			$config[] = array(
				'field' => 'client_id',
				'label' => 'Customer Name',
				'rules' => 'trim|required',
				'errors' => array(
				'required'      => '%s Not Found.'
				)	
			);
		}

		if($is_chassi == 0){	
			//if($dbdata->chassi_number != $this->input->post('chassi_number')){
				$config[] = array(
					'field' => 'chassi_number',
					'label' => 'Chassi Number',
					'rules' => 'trim|required|callback_validate_chassi_number',
					'errors' => array(
						'required'      => 'Please Enter %s.',
						'validate_chassi_number' => '%s is Already Existssss .'
					)	
				); 
			//}						
		}else{
			if(!empty($this->input->post('chassi_number')) || $this->input->post('chassi_number') != ''){
 				$config[] = array(
					'field' => 'chassi_number',
					'label' => 'Chassi Number',
					'rules' => 'trim|callback_validate_chassi_number',	
					'errors' => array(
						'validate_chassi_number' => '%s is Already Existsaaa .'
					)
				); 
			}
		}
		$this->form_validation->set_rules($config);
		$make_id = $this->input->post('make_id');
		$where2=array(
			'make_id' => $make_id
		);
		$nb=$this->crud_model->get('model',$where2);
		
		if ($this->form_validation->run() == FALSE){
			$data['reg_no']  	=  set_value('reg_no');
			$data['make']     	=  set_value('make');
			$data['make_id']    =  set_value('make_id');
			//$data['model']    =  $this->Vehicle->getJBCModel($model_id);	
			$data['model'] 		= $nb;		
			$data['chassi_number']  =  set_value('chassi_number');
			$data['client']   	=  set_value('client');
			$data['client_id']  =  set_value('client_id');
			$data['car_year']   =  set_value('car_year');
			$data['car_color']  =  set_value('car_color');
			$data['v_type']     =  set_value('v_type');
			$data['v_category'] = $this->Vehicle->getv_category();
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$title['headerTitle']="New Registration";
			$this->load->view('templates/header',$title);
			$this->load->view('mobile_view/add_vehicle',$data);
			$this->load->view('templates/footer');
		}
		else{
			if(!empty($this->input->post('client_id'))){
				$client_id  = $this->input->post('client_id');
			}else{
				$client_id  = 144;
			}
			$data = array(
				'v_type'	 =>	$this->input->post('v_type'),
				'reg_no'	 =>	$this->input->post('reg_no'),
				'make_id'    => $this->input->post('make_id'),
				'model_id'   => $this->input->post('model'),
				'client_id'  => $client_id,	
 				'car_year'   => $this->input->post('car_year'),
				'car_color'  => $this->input->post('car_color'),
				'chassi_number' => $this->input->post('chassi_number'),
			);
			$res = $this->crud_model->insert('reg_no_table',$data);
			if($res === false){
				$this->session->set_flashdata('response', 'Something WentWrong');
				$e_code = 503;
				redirect('m/m_dashboard/error/'.$e_code.'');
			}
			else{
				$insert_id = $this->db->insert_id();
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$datalog= array(						
					'masters_type'=>'Vehicle Registration_Tab',	
					'masters_id'=>$insert_id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'create new ',	
				);
				$this->crud_model->insert('log_for_masters',$datalog);
				$this->session->set_flashdata('success','New Vehichle Registration Added Successfully ');
				redirect('m/m_dashboard/newjob');
			}

		}
	}

	public function get_job_list(){
		$reg_no  = $this->input->post('reg_no');
		$vtype  = $this->input->post('vtype');
		$html ="";
		$i = 1;
		$j = 1;
		$where2=array(
			'reg_no' =>$reg_no,
			'job_card_status'=>'Draft',
			'vtype_id'=>$vtype 
		);
		$nb=$this->crud_model->get('job_card',$where2,null, null, "id", "DESC", null, null, null, null);
		if(!empty($nb)){
				$html ='
				<table id="jocardDtl">
				  <thead>
					  <tr>
						<th> # </th>						 
						<th> JobCard#</th>
						<th>Date</th>
						<th>Action</th>
					  </tr>
				  </thead>
				  <tbody class="scroll-pane">';
			foreach($nb as $rec){
				$html .= '<tr>
						<td class="lazy-load" >'.$i++.'.  </td>
						<td class="lazy-load" > ' .$rec['job_card_number'].'</td>
						<td class="lazy-load" >'.date('d-M-y' ,strtotime($rec['job_card_date'])).'</td>
						<td class="lazy-load" ><a href="'.site_url(('m/m_dashboard/view_jobacard/'.$rec['id'].'')).'" >Update</a></td>
					  </tr>';
					  $j++;
			}
			$html .='</tbody>
			</table>';			
		}
		else{
			$html ='<span id="no_data">no records found for the register number '.$reg_no.' </span>';
		}
		echo $html;
	}

	public function editRegistration($job_id = ''){
		$this->db->trans_begin();
		$this->users_model->permission("Job_card", "Edit");
		$title['headerTitle']="Update Vehicle Detail";
		$where=array(
			'id' => $job_id
		);
		$records=$this->crud_model->get('job_card',$where); 
		
		if($records != false){
		$data['v_category'] = $this->Vehicle->getv_category();
		$is_chassi = $this->crud_model->is_chassi_number();
		$config = array(
				array(
					'field' => 'v_type',
					'label' => 'Vehicle Type',
					'rules' => 'trim|required',
					'errors' => array(
						'required'      => 'Please Select %s.'
					)
			),
			array(
				'field' => 'reg_no',
				'label' => 'Registration Number',
				'rules' => 'trim|required|callback_validate_edit_v_type',
				'errors' => array(
					'required'      => 'Please Enter %s.',
					'validate_edit_v_type' => '%s is Already Exists with selected Vehicle Type.'
					)
				),
				
			array(
						'field' => 'make',
						'label' => 'Make',
						'rules' => 'rtrim|required',
						'errors' => array(
							'required'      => 'Please Enter Vehicle %s.'
						)
				),
				array(
						'field' => 'model',
						'label' => 'Model',
						'rules' => 'trim|required',
						'errors' => array(
							'required'      => 'Please Choose Any Vehicle %s.'
						)
				),
			// array(
			// 		'field' => 'client',
			// 		'label' => 'Customer Name',
			// 		'rules' => 'trim|required',
			// 		'errors' => array(
			// 		'required'      => 'Please Enter %s.'
			// 		)
			// 		),
			// array(
			// 	'field' => 'client_id',
			// 	'label' => 'Customer Name',
			// 	'rules' => 'trim|required',
			// 	'errors' => array(
			// 	'required'      => '%s Not Found.'
			// 	)
			// ),
		);
		if(!empty($this->input->post('client'))){
			$config[] = array(
				'field' => 'client_id',
				'label' => 'Customer Name',
				'rules' => 'trim|required',
				'errors' => array(
				'required'      => '%s Not Found.'
				)	
			);
		}
		if($is_chassi == 0){	
			//if($dbdata->chassi_number != $this->input->post('chassi_number')){
				if(empty($this->input->post('chassi_number')) ||  $this->input->post('chassi_number') == ''){
					$config[] = array(
						'field' => 'chassi_number',
						'label' => 'Chassi Number',
						'rules' => 'trim|required',
						'errors' => array(
							'required'      => 'Please Enter %s.',
 						)	
					); 
				}
				else{
					$config[] = array(
						'field' => 'chassi_number',
						'label' => 'Chassi Number',
						'rules' => 'trim|required|callback_validate_edit_chassi_number',
						'errors' => array(
							'required'      => 'Please Enter %s.',
							'validate_edit_chassi_number' => '%s is Already Exists.'
						)	
					); 
				}
			//}						
		}else{
			if(!empty($this->input->post('chassi_number')) || $this->input->post('chassi_number') != ''){
 				$config[] = array(
					'field' => 'chassi_number',
					'label' => 'Chassi Number',
					'rules' => 'trim|callback_validate_edit_chassi_number',	
					'errors' => array(
						'validate_edit_chassi_number' => '%s is Already Exists .'
					)
				); 
			}
		}
		$this->form_validation->set_rules($config);	
		//var_dump($records);
		
			if ($this->form_validation->run() == FALSE){ 
				$vtype_id = $records[0]['vtype_id'];
				$reg_no   = $records[0]['reg_no'];
				$make  = $this->Vehicle->getMake();
				$where1=array(		
					'v_type'   => $vtype_id,
					'reg_no Like'   =>'%'.$reg_no.'%',				
				);
				$register_rec=$this->crud_model->get('reg_no_table',$where1); 
 				$make  = $this->Vehicle->getMake();
				$makeArray = array_column($make,'title','id');
				if(isset($register_rec[0]['make_id']) & isset($makeArray[$register_rec[0]['make_id']])){
						$make_name = $makeArray[$register_rec[0]['make_id']];
				}
				else{
					$make_name =  "";
				}
				$customer     = $this->Vehicle->getCustomer();
				$customerArray = array_column($customer,'client_name','client_id');

				if(isset($register_rec[0]['client_id']) & isset($customerArray[$register_rec[0]['client_id']])){
						$client_name = $customerArray[$register_rec[0]['client_id']];
				}
				else{
					$client_name =  "";
				}
				$data['model']  = $this->Vehicle->getModel();
				$data['job_id'] 	 =  $records[0]['id'];
				$data['reg_no_id']  = $register_rec[0]['reg_no_id'];
				$data['v_type'] 	= $register_rec[0]['v_type'];
				$data['reg_no']     = $register_rec[0]['reg_no'];
				$data['make_id']    = $register_rec[0]['make_id'];
				$data['make_name']  = $make_name;
				$data['model_id']   = $register_rec[0]['model_id'];
				$data['client_id']  = $register_rec[0]['client_id'];
				$data['client_name'] = $client_name;
				$data['car_year']   = $register_rec[0]['car_year'];
				$data['car_color']  = $register_rec[0]['car_color'];
				$data['chassi_number']   = $register_rec[0]['chassi_number'];
				$this->session->set_flashdata('response',''.validation_errors().'',':old:');
				$this->load->view('templates/header',$title);
				$this->load->view('mobile_view/edit_vehicle',$data);
				$this->load->view('templates/footer');
		}
		else{
			
			$id = $this->input->post('job_id');
			$data_reg = array(
				'v_type'	 =>	$this->input->post('v_type'),
				'reg_no'	 =>	$this->input->post('reg_no'),
				'make_id'    => $this->input->post('make_id'),
				'model_id'   => $this->input->post('model'),
				'client_id'  => $this->input->post('client_id'),				 
 				'car_year'   => $this->input->post('car_year'),
				'car_color'  => $this->input->post('car_color'),
				'chassi_number' => $this->input->post('chassi_number'),
			);
			$where_update_reg=array(		
				'reg_no_id'   =>  	$this->input->post('reg_no_id'),				
			);

			$this->crud_model->update('reg_no_table',$data_reg,$where_update_reg);
			$data_job = array(
				'client_id'  => $this->input->post('client_id'),	
				'reg_no'	 =>	$this->input->post('reg_no'),
				'make'       => $this->input->post('make_id'),
				'model'      => $this->input->post('model'),
				'chassi_number' => $this->input->post('chassi_number'),		 
				'car_year'  => $this->input->post('car_year'),
				'car_color' => $this->input->post('car_color'),
				'vtype_id'  => $this->input->post('v_type'),
				'contact_name' => $this->input->post('contact_num'),
				
			);
			$where_update_job=array(		
				'id'   =>  $id,				
			);
			$this->crud_model->update('job_card',$data_job,$where_update_job);
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				$this->session->set_flashdata('response', 'OOPS!!!...Something WentWrong.Please Try Again.');
				redirect('m/m_dashboard/editRegistration/'.$id.'');
			} else {
				$this->db->trans_commit();
				$insert_id = $this->input->post('reg_no_id');
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'=>'VehicleRegistration-tab',	
					'masters_id'=>$insert_id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'update',	
				);
				$this->crud_model->insert('log_for_masters',$data);
				$data_j= array(						
					'masters_type'=>'VehicleRegistration-Jobcard-tab',	
					'masters_id'=>$id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'update',	
				);
				$this->crud_model->insert('log_for_masters',$data_j);

				$this->session->set_flashdata('success', 'Vehicle Details Updated Successfully');
				redirect('m/m_dashboard/editRegistration/'.$id.'');
			}
			}
		}
	}

	public function UpdateRegistration($reg =""){
		$this->db->trans_begin();
		$this->users_model->permission("Job_card", "Edit");
		$title['headerTitle']="Update Vehicle Detail";
		$where=array(
			'reg_no_id' => $reg
		);
		$records = $this->crud_model->get('reg_no_table',$where); 
		if($records != false){
			$data['v_category'] = $this->Vehicle->getv_category();
			$is_chassi = $this->crud_model->is_chassi_number();
			$customer  = $this->Vehicle->getCustomer();
			$make  	   = $this->Vehicle->getMake();
			$config = array(
				array(
					'field' => 'v_type',
					'label' => 'Vehicle Type',
					'rules' => 'trim|required',
					'errors' => array(
						'required'      => 'Please Select %s.'
					)
			),
			array(
				'field' => 'reg_no',
				'label' => 'Registration Number',
				'rules' => 'trim|required|callback_validate_edit_v_type',
				'errors' => array(
					'required'      => 'Please Enter %s.',
					'validate_edit_v_type' => '%s is Already Exists with selected Vehicle Type.'
					)
				),
				
			array(
						'field' => 'make',
						'label' => 'Make',
						'rules' => 'rtrim|required',
						'errors' => array(
							'required'      => 'Please Enter Vehicle %s.'
						)
				),
				array(
						'field' => 'model',
						'label' => 'Model',
						'rules' => 'trim|required',
						'errors' => array(
							'required'      => 'Please Choose Any Vehicle %s.'
						)
				),
			array(
					'field' => 'client',
					'label' => 'Customer Name',
					'rules' => 'trim|required',
					'errors' => array(
					'required'      => 'Please Enter %s.'
					)
					),
			array(
				'field' => 'client_id',
				'label' => 'Customer Name',
				'rules' => 'trim|required',
				'errors' => array(
				'required'      => '%s Not Found.'
				)
			),
		);
		if($is_chassi == 0){	
			//if($dbdata->chassi_number != $this->input->post('chassi_number')){
				if(empty($this->input->post('chassi_number')) ||  $this->input->post('chassi_number') == ''){
					$config[] = array(
						'field' => 'chassi_number',
						'label' => 'Chassi Number',
						'rules' => 'trim|required',
						'errors' => array(
							'required'      => 'Please Enter %s.',
 						)	
					); 
				}
				else{
					$config[] = array(
						'field' => 'chassi_number',
						'label' => 'Chassi Number',
						'rules' => 'trim|required|callback_validate_edit_chassi_number',
						'errors' => array(
							'required'      => 'Please Enter %s.',
							'validate_edit_chassi_number' => '%s is Already Exists.'
						)	
					); 
				}
				
			//}						
		}else{
			if(!empty($this->input->post('chassi_number')) || $this->input->post('chassi_number') != ''){
 				$config[] = array(
					'field' => 'chassi_number',
					'label' => 'Chassi Number',
					'rules' => 'trim|callback_validate_edit_chassi_number',	
					'errors' => array(
						'validate_edit_chassi_number' => '%s is Already Exists .'
					)
				); 
			}
		}
		$this->form_validation->set_rules($config);	
			if ($this->form_validation->run() == FALSE){ 
				
				$makeArray = array_column($make,'title','id');
				$customerArray = array_column($customer,'client_name','client_id');

				if(isset($records[0]['make_id']) & isset($makeArray[$records[0]['make_id']])){
						$make_name = $makeArray[$records[0]['make_id']];
				}
				else{
					$make_name =  "";
				}
				if(isset($records[0]['client_id']) & isset($customerArray[$records[0]['client_id']])){
					$client_name = $customerArray[$records[0]['client_id']];
				} else {
					$client_name =  "";
				}				 
				$data['model']  = $this->Vehicle->getModel();
				$data['reg_no_id']  = $records[0]['reg_no_id'];
				$data['v_type'] 	= $records[0]['v_type'];
				$data['reg_no']     = $records[0]['reg_no'];
				$data['make_id']    = $records[0]['make_id'];
				$data['make_name']  = $make_name;
				$data['model_id']   = $records[0]['model_id'];
				$data['client_id']  = $records[0]['client_id'];
				$data['client_name'] = $client_name;
				$data['car_year']    = $records[0]['car_year'];
				$data['car_color']   = $records[0]['car_color'];
				$data['chassi_number']  = $records[0]['chassi_number'];
				$this->session->set_flashdata('response',''.validation_errors().'',':old:');
				$this->load->view('templates/header',$title);
				$this->load->view('mobile_view/update_vehicle_reg',$data);
				$this->load->view('templates/footer');
			}
			else{			
				$id = $this->input->post('job_id');
				$data_reg = array(
					'v_type'	 =>	$this->input->post('v_type'),
					'reg_no'	 =>	$this->input->post('reg_no'),
					'make_id'    => $this->input->post('make_id'),
					'model_id'   => $this->input->post('model'),
					'client_id'  => $this->input->post('client_id'),				 
					'car_year'   => $this->input->post('car_year'),
					'car_color'  => $this->input->post('car_color'),
					'chassi_number' => $this->input->post('chassi_number'),
				);
				$where_update_reg=array(		
					'reg_no_id'   =>  	$this->input->post('reg_no_id'),				
				);	
				$this->crud_model->update('reg_no_table',$data_reg,$where_update_reg);				 
				if ($this->db->trans_status() === FALSE) {
					$this->db->trans_rollback();
					$this->session->set_flashdata('response', 'OOPS!!!...Something WentWrong.Please Try Again.');
					redirect('m/m_dashboard/UpdateRegistration/'.$reg.'');
				} else {
					$this->db->trans_commit();
					$insert_id = $this->input->post('reg_no_id');
					$date = date("Y-m-d H:i:s");
					$userid = $this->session->userdata('user_id');
					$data= array(						
						'masters_type'=>'VehicleRegistration-tab',	
						'masters_id'=>$insert_id,	
						'date'=>$date,	
						'created_id'=> $userid,	
						'masters_op'=>'update',	
					);
					$this->crud_model->insert('log_for_masters',$data);
				 
	
					$this->session->set_flashdata('success', 'Vehicle Details Updated Successfully');
					redirect('m/m_dashboard/UpdateRegistration/'.$reg.'');
				}
			}
		}
	}
	 
	public function inventoryDetails_m($id = '') {
		$id = $this->input->post('job_id');
		$where=array(
			'id' => $id
		);
		$records=$this->crud_model->get('job_card',$where); 
		if($records != false){			 
			$this->form_validation->set_rules('inventory_detail', 'Customer inventory_detail', 'required');			
			if ($this->form_validation->run() == FALSE){ 
				$inventory_detail	 = $records[0]['inventory_detail'];
				$inventory_detail_master = $this->Vehicle->v_InventoryChecklist();
				$data['id'] = $id;
				if(!empty($inventory_detail_master)){
					$intry_list  = '';
					foreach($inventory_detail_master as $rec){
						if($rec['status'] == 0){
							$inventory_detail_array = explode(',', $inventory_detail);
							$checked =  in_array($rec['id'], $inventory_detail_array) ? 'checked' : ''; 
							if($rec['image'] != '' || $rec['image'] != NULL){
								$src_link =  base_url().'images/vehicle_inventory/'.$rec['image'];
							}
							else{
								$src_link =  base_url().'images/default_image.png';
							}
							$intry_list .= '<div class="col-4">
									<div class="selectgroup selectgroup-pills">
										<label class="selectgroup-item">
											<div class=" item-card">
												<input type="checkbox" name="inventory_detail_img[]" value="'.$rec['id'].'" class="selectgroup-input" '.$checked.' >
												<span class="selectgroup-button">
													<div class="product-grid6 ">
														<div class="product-image6">
															<img class="img-responsive" src="'.$src_link.'" style="height:150px;width:150px;" alt="Thumb-1">
														</div>
														<div class="product-content text-center"></div>
													</div>
													<div class="ribbone">
														<div class="ribbon"><span>'.$rec['item_name'].'</span></div>
													</div>
												</span>
											</div> 
										</label>  
									</div>  
								</div>';
						}
					}  
 					
				} 
			} else{
				// 	$user_id	=	$this->session->userdata('user_id');										
				// 	$data = array(
				// 		'inventory_detail' => htmlentities($this->input->post('inventory_detail')),
				// 	);
						 
				// 	$this->db->trans_begin();
				// 	$where = array('id' => $id);
			    //  	$this->crud_model->update('job_card',$data,$where);	
										
				// 	if ($this->db->trans_status() === FALSE) {
				// 		$this->db->trans_rollback();
				// 		redirect("JobCard/listJobCard");
				// 	} else {
				// 		$this->db->trans_commit();
				// 	$this->session->set_flashdata('success', 'Inventory Details Added Successfully');
				// 	redirect('jobcard/Vehicle_jobcard/inventoryDetails/'.$id.'');
				// }
			}
		} 
		echo json_encode($intry_list);     	
	}
	public function update_inventory($id = ''){
 		$config = array(
			array(
				'field' => 'inventory_detail_img',
				'label' => 'Customer Inventory Detail',
				'rules' => 'callback_validate_inventory_detail_img',
				'errors' => array(
					'validate_inventory_detail_img' => 'Please select at least one inventory detail image.'
				)
			),
		);
		$this->form_validation->set_rules($config);	
		if ($this->form_validation->run() == FALSE){ 
			$data['inventory_detail']   =  set_value('inventory_detail');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			redirect('m/m_dashboard/view_jobacard/'.$id.'');
		}
		else{
			if ($this->input->post('inventory_detail_img')) {
				$inventory_details = $this->input->post('inventory_detail_img');

				if (is_array($inventory_details)) {
					$selected_values = implode(',', $inventory_details);
				} else {
					$selected_values = $inventory_details;
				} 
				$selected_values = rtrim($selected_values, ','); 
			}
			$data = array(
				'inventory_detail' => $selected_values,
			);	
			$this->db->trans_begin();
			$where = array('id' => $id);
			$this->crud_model->update('job_card',$data,$where);	
								
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				$this->session->set_flashdata('response','error Occured!!!...');
				redirect('m/m_dashboard/view_jobacard/'.$id.'');
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'Inventory Details Added Successfully');
				redirect('m/m_dashboard/view_jobacard/'.$id.'');
			}
		}
	}
	
	

	public function troubleshoot_line($id = ''){
		//echo 'test'; exit();
		$title['headerTitle']="Service Line Troubleshooting";
		$where=array(
			'id' => $id
		);
		$data['grouplist']  = $this->Vehicle->getServiceLineGroup();
		$records=$this->crud_model->get('job_card',$where); 
		
		if($records != false){
			$config = array(
				array(
					'field' => 'service_group_id[]',
					'label' => 'Checking Line',
					'rules' => 'rtrim|required',
					'errors' => array(
						'required' => 'Please Add Any %s.'
					)
				),
				array(
					'field' => 'furniture_description[]',
					'label' => 'Description',
					'rules' => 'rtrim|required',
					'errors' => array(
						'required' => '%s is required.'
					)
				),
			);
				$this->form_validation->set_rules($config);			 
 			if ($this->form_validation->run() == FALSE){ 
				$data['service_group_id']   =  set_value('service_group_id');
				$this->session->set_flashdata('response',''.validation_errors().'',':old:');
				$service_datalist = array( 
										'job_card_details_id' => '', 
										'service_group_id' => '',  
										'jb_type' => '',  
										'service_troubleshoot' => '',  
										'item_id' => '', 
										'furniture_model' => '', 
										'vat_perce' => '',  
										'furniture_description' => '', 
										'technician_id' => '', 
										'aws' => '', 
										'min' => '', 
										'job_card_technician_id' => '', 
										'job_status' => '', 
										'section_id' => '', 
									);
				$job_service_detail= $this->Vehicle->getServiceTroubleShootlist($id);
				//var_dump($job_service_detail);
				if(!empty($job_service_detail)){
					foreach($job_service_detail	 as  $res){
						if($res['jb_type'] == 1 && $res['service_troubleshoot'] == 0 ){
							$jb_detail_id = $res['job_card_details_id'];
							$service_technician_list = $this->Vehicle->getServiceTechnicianlist($id,$jb_detail_id);	
							if (!empty($service_technician_list) && is_object($service_technician_list)) {
								$technician_id  = $service_technician_list->technician_id;
								$job_card_technician_id = $service_technician_list->id;
							}
							else{
								$technician_id  =  NULL;  $job_card_technician_id = NULL;
							}							
 							$service_datalist['job_card_details_id']      =  $jb_detail_id;
							$service_datalist['service_group_id']         =  $res['service_group_id'];
							$service_datalist['jb_type']                  =  $res['jb_type'];
							$service_datalist['service_troubleshoot']     =  $res['service_troubleshoot'];
							$service_datalist['item_id']                  =  $res['item_id'];
							$service_datalist['furniture_model']          =  $res['furniture_model'];
							$service_datalist['vat_perce']                =  $res['vat_perce'];
							$service_datalist['furniture_description']    =  $res['furniture_description'];
							$service_datalist['technician_id']            =  $technician_id;
							$service_datalist['aws']           			  =  $res['aws'];
							$service_datalist['min']            		  =  $res['min'];
							$service_datalist['job_card_technician_id']   =  $job_card_technician_id;
							$service_datalist['job_status']   			  =  $res['job_status'];
							$service_datalist['section_id']   			  =  $res['section_id'];
							$data['service_tbsht_list'][] = $service_datalist;
						}
					}
					
				}
				$data['id'] = $id;
				$data['staff'] = $this->Vehicle->getServiceStaff();
				$this->load->view('templates/header',$title);
				$this->load->view('mobile_view/service_troubleshoot_line',$data);
				$this->load->view('templates/footer'); 
			} 
			else{
				$this->db->trans_begin();
				$vmodelID = $this->Vehicle->getVModelJobcardRow($id);
				if($vmodelID != false || $vmodelID != Null){
					$vtypecheck = $this->Vehicle->getVModelTypeRow($vmodelID);
					if($vtypecheck != false){
						$vcategoryFactor = $this->Vehicle->getVcategoryFactorRow($vtypecheck);
					}
				}
				$service_group_id = $this->input->post('service_group_id');
				$jobcard_details_id  = $this->input->post('job_card_details_id');
				if (is_array($jobcard_details_id) && !empty(array_filter($jobcard_details_id))) {
					$filtered_jobcard_details_id = array_filter($jobcard_details_id);						
					$unique_jb_det_id = array_unique($filtered_jobcard_details_id);
					$jb_det_idtrim = implode(", ", $unique_jb_det_id);					
					if (!empty($jb_det_idtrim)) {
						$sql_del = $this->db->query("DELETE FROM `job_card_technician` WHERE `job_id` = $id AND `job_detail_id` NOT IN ($jb_det_idtrim) AND `progress_status` = 0 AND `job_technician_status` = 2");
						
						if ($sql_del) {
							$this->db->query("DELETE FROM `job_card_details` WHERE `job_card_id` = $id AND `jb_type` = 1 AND `job_card_details_id` NOT IN ($jb_det_idtrim) AND `job_status` = 2");
						}
					}  
				}
				if(!empty($service_group_id)){
					$sl = 1;
					$furniture_amount = $vat = $vat_amount = $net_amount = 0;
					$dbdata = $this->Vehicle->jobCardRowData($id);
					$discount_percentage  = $this->Vehicle->getVehiclediscount($dbdata->reg_no,$dbdata->vtype_id);
					$job_card_details_id  = $this->input->post('job_card_details_id');
					
					foreach($service_group_id as $i => $s_id ){						
						if(!empty($this->input->post('job_card_details_id'))){
								$job_card_details_id  = $this->input->post('job_card_details_id')[$i];
								$where2 = array('job_card_id'=>$id ,
								'jb_type' => 1,
								'service_group_id' => $service_group_id[$i],
								'service_troubleshoot' => '0',
								'job_card_details_id' => $job_card_details_id 
					    	);
							$del = $this->crud_model->delete('job_card_details',$where2);
								if(!empty($this->input->post('job_card_technician_id'))){
									$job_card_technician_id  = $this->input->post('job_card_technician_id')[$i];
									$wheretec = array(
										'id'              => $job_card_technician_id ,
										'job_id'          => $id ,
										'job_detail_id'   => $job_card_details_id ,
										'service_troubleshoot' => 0,
										//'progress_status' => 0,
									);
									$this->crud_model->delete('job_card_technician',$wheretec);
								}
						}
					}
					$unique_service_group_id = array_unique($service_group_id);
					$service_group_idtrim = implode(", ", $unique_service_group_id);
				    
				    $sql_del =  $this->db->query("DELETE FROM `job_card_technician` WHERE  `job_id` = $id AND  `service_group_id` NOT IN ($service_group_idtrim) AND `progress_status` = 0 AND `job_technician_status` = 2");
					if($sql_del){
						$this->db->query("DELETE FROM `job_card_details` WHERE  `job_card_id` = $id AND `jb_type` = 1  AND `service_group_id` NOT IN ($service_group_idtrim) AND `job_status` = 2");
					}
					for($k = 0; $k < count($service_group_id);$k++) {						
						if(!empty($this->input->post('job_card_details_id')) && $this->input->post('job_card_details_id') !=''){
							$job_card_details_id  = $this->input->post('job_card_details_id')[$k];
						}
						else{
							$job_card_details_id  = '';
						} 	
						if($discount_percentage != false){
 							$labour_dis		= $discount_percentage->labour_disc;
						}
						else{
 							$labour_dis		= 0;
						}

						$aws  =  $this->input->post('service_line_aws')[$k];
						$furniture_amount = floatval($vcategoryFactor) * intval($aws); 
 						$discount  = floatval($furniture_amount) * floatval($labour_dis)/100;
						$vat =  $this->input->post('service_line_vat')[$k] ;
						$vat_amount  = (floatval($furniture_amount) - floatval($discount)) * (intval($vat) / 100);
						$net_amount  = floatval($vat_amount) + (floatval($furniture_amount) - floatval($discount));
						$dataValues  = array(
							'job_card_details_id'   => $job_card_details_id,
							'job_card_id'           => $id,
							'sl_no'                 => $sl++,
							'item_id'               => $this->input->post('item_id')[$k],
							'furniture_model'       => $this->input->post('furniture_model')[$k],
							'furniture_description' => $this->input->post('furniture_description')[$k],
							'furniture_quantity'    => 1,
							'furniture_amount'      => $furniture_amount,
							'vat_perce'             => $vat,
							'vat_amount'            => $vat_amount,
							'item_disc_perc'        => $labour_dis,
							'item_discount'         => $discount,
							'net_amount'            => $net_amount,
          					'jb_type'               => 1,
          					'section_id'            => $this->input->post('section_id')[$k],
 							//'technician_id'         => $this->input->post('technician_list')[$k],
							'service_troubleshoot'  => 0,
  						    //'service_group_id'      => $s_id,
  							'service_group_id'      => $service_group_id[$k],
  							'aws' => $aws,
 							'min' => $this->input->post('service_line_min')[$k],
							'job_status' => 1
						);	
 						$this->crud_model->insert('job_card_details',$dataValues);
						$insert_id = $this->db->insert_id();	
						$date = date("Y-m-d H:i:s");
						if($this->db->trans_status() === TRUE) {
							if(!empty($this->input->post('job_card_technician_id')) ){
								$job_card_technician_id  = $this->input->post('job_card_technician_id')[$k];
 							}
							else{
								$job_card_technician_id  = '';
							} 
								$datatecval = array(
									'id' 			       	=> $job_card_technician_id,
									'job_id' 		       	=> $id,
									'job_detail_id'        	=> $insert_id,
									'technician_id'        	=> $this->input->post('technician_list')[$k],
									'service_group_id'     	=> $service_group_id[$k],
									'service_troubleshoot' 	=> 0,
									'aws'				   	=> $aws,
									'min'                  	=> $this->input->post('service_line_min')[$k],
									'job_technician_status' => 1,
									'progress_status'		=> 0,
									'created_by'			=> $this->session->userdata('user_id'),
									'created_date'          => $date
								);
							$this->db->insert('job_card_technician',$datatecval);
						}
					}
				}									
				if ($this->db->trans_status() === FALSE) {
					$this->db->trans_rollback();
					$this->session->set_flashdata('response', 'OOPS!!!...Something WentWrong.Please Try Again.');
					redirect('m/m_dashboard/view_jobacard/'.$id.'');
				} else {
					$this->db->trans_commit();
					$this->session->set_flashdata('success', 'Service Troubleshoot Details Updated Successfully');
					redirect('m/m_dashboard/troubleshoot_line/'.$id.'');
				}	
			}
		}
	}

	public function create_service_troubleshoot_linewise(){
		$id = $this->input->post('id');
		$section_master_id = $this->input->post('section_master_id');
		$get_tb_data = $this->Vehicle->getServiceTroubleshootrow($id);
		$staff = $this->Vehicle->getServiceStaff();
		$html = '';		
 		if($get_tb_data != false){
			$s_id  = $get_tb_data->service_group_id;
			//$s_id = $get_tb_data->slm_id;
			$html = '<tr id="troubleshoot_linewise_'.$id.'"    class="troubleshoot_linewise_'.$id.'">
						<td style="padding: 4px 5px 4px 10px;text-align:center;">
							<input type="hidden" name="job_card_details_id[]"  value=""/>
							<input type="hidden" name="job_card_technician_id[]"  value=""/>
							<input type="hidden" class="service_group_id" name="service_group_id[]"  value="'.$get_tb_data->service_group_id.'"/>
							'.$get_tb_data->group_code.'  
						</td>
						<td style="padding: 4px 5px 4px 10px;">
 							<input type="hidden" name="item_id[]"  value="'.$get_tb_data->slm_id.'"/>
                            <input type="hidden" name="furniture_model[]"  value="'.$get_tb_data->service_name.'"/>
							<input type="hidden" name="service_line_vat[]" value="'.$get_tb_data->vat.'" />
							<input type="hidden" name="section_id[]" value="'.$section_master_id.'" />
                            <input type="text"   class="form-control service_line_name" name="furniture_description[]" value="'.$get_tb_data->service_name.'" style="border: none !important;background-color: #4c5378;" />
						</td>
						<td style="padding: 4px 2px 4px 2px;">
							<select class="form-control select2 technician_list" data-placeholder="Select Technician" name="technician_list[]" id="technician_list" autocomplete="off">';
							$html .= '<option value="" selected>Select Technician</option>'; 
							if(!empty($staff)){
								$val = '';
								foreach ($staff as $res) {										 								
 										$service_areas = explode(',', $res['is_service_area']);		
										if( $res['type'] == 2 && in_array($get_tb_data->service_group_id, $service_areas) ){		
										$html .= '<option value="'.$res['staff_id'].'">'.$res['staff_name'].'</option>';
									}
								}
							}
							else{
								$html .= '<option value="">Tecnician Not Added</option>';
							}
						$html .='</select>
						</td>
						<td style="padding: 4px 2px 4px 2px;">
							<input type="text" class="form-control service_line_aws" name="service_line_aws[]" value="'.$get_tb_data->aws.'" style="border: none !important;background-color: #4c5378;" />
						</td>
						<td style="padding: 4px 2px 4px 2px;">
							<input type="text" class="form-control service_line_min" name="service_line_min[]" value="0" style="border: none !important;background-color: #4c5378;"/>
						</td>
						<td style="padding: 4px 2px 4px 2px;">
							<span class="remove_button remove_button_'.$id.'">
								<button type="button" class="btn btn-danger remove_serv_tr" data-remove-id="'.$id.'"><i class="fe fe-x-circle" style="font-size:16px;"></i></button>
							</span>	
							<!--<span class="">
								<button type="button" data-service-line-setion-id="'.$section_master_id.'"  data-service-group-id="'.$id.'" class="btn  btn-success add_service_line add_service_line_'.$id.'" id="add_service_line_'.$id.'"  data-update-id="id"><i class="fe fe-plus-circle" style="font-size:16px;"></i></button>
							</span>	--> 
						</td>
					</tr>';
		}
		else{
			//$html = 'error';
		}
		echo json_encode($html);
	}

	public function update_service_tbshoot($id = 0){
		$this->db->trans_begin();
		$job_card_detailsdataValues  = array(
			'job_status' => 2
		);
		$wherejob = array(
			'job_status' => 1,
			'service_troubleshoot' => 0,
			'job_card_id' => $id,
			'jb_type' => 1,
		);

		$this->crud_model->update('job_card_details',$job_card_detailsdataValues,$wherejob);

		$datatecval = array(
			'job_technician_status' => 2,
			
		);
		$wheretec = array(
			'progress_status' => 0,
			'service_troubleshoot' => 0,
			'job_id' => $id
		);
		$this->crud_model->update('job_card_technician',$datatecval,$wheretec);


		$job_card_data= array(
			'jobcard_stage' =>5,			
		);
		$where_job_card = array(
			'id' => $id
		);
		$this->crud_model->update('job_card',$job_card_data,$where_job_card);

		$date = date("Y-m-d H:i:s");
		$datajob_stage = array(
			'job_id' => $id,
			'user_id' => $this->session->userdata('user_id'),
			'log_date' => $date,
			'log_status' => 5,
		);
		$this->crud_model->insert('jobcard_track_log',$datajob_stage);

		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			$this->session->set_flashdata('response', 'OOPS!!!...Something WentWrong.Please Try Again.');
			redirect('m/m_dashboard/view_jobacard/'.$id.'');
		} else {
			$this->db->trans_commit();
			$this->session->set_flashdata('success', 'Service Troubleshoot Completed Successfully');
			redirect('m/m_dashboard/troubleshoot_line/'.$id.'');
		}
	} 



	/***Service Jobs***/

	public function newservicejob(){
		if(get_cookie('division_val_id')!=false){ 			 
			$data['enq_no']= $this->crud_model->get_job_no(get_cookie('division_val_id')); 
			$title['h_division_id']=get_cookie('division_val_id'); 
			$data['h_division_id']=get_cookie('division_val_id'); 
		} else { 
			$data['enq_no']= NULL; 
			$title['h_division_id']=NULL; 
			$data['h_division_id']=NULL; 
		}
		$this->users_model->permission("Job_card", "Add");
		$title['headerTitle']="Create Service JobCard";
		$this->load->view('templates/header',$title);		 
		$data['make']  = $this->Vehicle->getMake();
		$data['staff']  = $this->Vehicle->getServiceStaff();
		$data['advisor']  = $this->Vehicle->getAdvisorStaff();
		$data['v_category'] = $this->Vehicle->getv_category();
		$this->load->view('mobile_view/create_Servicejobcard',$data);
		$this->load->view('templates/footer');
	}

	public function servicejob_do_insert(){
		$this->users_model->permission("Job_card", "Add");
		$reg_no_id = $this->input->post('p_reg_no');
		$dataCheckJbcard = $this->Vehicle->CheckJobcardStatus($reg_no_id);
		if(empty($this->input->post('division_id')) ){
			 $this->session->set_flashdata('response', 'Something WentWrong');
			 $e_code = 503;
			 redirect('m/m_dashboard/error/'.$e_code.'');
		}
		else{
			//if($dataCheckJbcard == false || $dataCheckJbcard->job_card_status == 'Completed'){
				$division_id = $this->input->post('division_id');
				$job_card_number  = $this->crud_model->get_service_job_no($division_id);
				$date = date("Y-m-d H:i:s");
				$Creation_date = date("Y-m-d");
				if($this->input->post('chkbox_val') == 0){
					$conatct_id = $this->input->post('contact_id');
					$contact_name = $this->input->post('contact_p_name');
					$contact_num = $this->input->post('p_contact_num');
				}
				else{
					$contact_name = $this->input->post('contact_p_name');
					$contact_num = $this->input->post('p_contact_num');
					$contactdata =  array('Contact_Name' => $contact_name,	
											'Client_Id'  => $this->input->post('client_id'),
											'Contact_Tel' => $contact_num ,
											'Creation_date' => $Creation_date,
											'Created_UserId' => $this->session->userdata('user_id'));
 					$this->crud_model->insert('client_contact',$contactdata);
 					$conatct_id = $this->db->insert_id();
				} 
				$data = array(
					'job_card_number' => $job_card_number,
					'job_card_date'   => $date,
					'client_id'       => $this->input->post('client_id'),
					'divisionid'      => $division_id,
					'created_user_id' => $this->session->userdata('user_id'),
					'reg_no'       => $this->input->post('p_reg_no'),
					'make'         => $this->input->post('make'),
					'model'        => $this->input->post('model'),
					'car_year'     => $this->input->post('car_year'),
					'car_color'    => $this->input->post('car_color'),
					'contact_id'   => $conatct_id,
					'contact_name' => $contact_name,
					'contact_num'  => $contact_num ,
					'km_in'        => $this->input->post('p_km_in'),
					'next_km'      => '',
				//	'fuel_level'   => $this->input->post('fuel_level_p'),
					'is_insurance' => '',
					'salesman_id'  => $this->session->userdata('advisor_id'),
					'job_card_status'     => 'Draft',
					'job_card_total'      => '',
					'job_card_vat_perc'   => 10,
					'job_card_vat_amount' => '',
					'job_card_amount_with_vat' => '',
					'vtype_id'		 => $this->input->post('vtype_n_id'),
					'v_jobcard_type' => 0,
					'jobcard_stage'  => 0,
					'temp_technician_id' =>  $this->input->post('technician_id')
				);
				$res = $this->crud_model->insert('job_card',$data);
				$insert_id = $this->db->insert_id();
				if(!empty($insert_id)){					
					$where_reg = array(
						'v_type'       => $this->input->post('vtype_n_id'),
						'reg_no LIKE'  => '%'.$this->input->post('p_reg_no').'%',
					);
					$data_reg = array(
						'client_mobile_no' =>  $this->input->post('p_contact_num'),				 
					);
					$this->crud_model->update('reg_no_table',$data_reg,$where_reg); 
					$userid = $this->session->userdata('user_id');
					$datalog= array(						
						'masters_type'=>'Vehicle Job Card_Tab',	
						'masters_id'=>$insert_id,	
						'date'=>$date,	
						'created_id'=> $userid,	
						'masters_op'=>'create',	
					);
					$this->crud_model->insert('log_for_masters',$datalog);		 
			
 					$datajob_stage = array(
						'job_id' => $insert_id,
						'user_id' => $this->session->userdata('user_id'),
						'log_date' => $date,
						'log_status' => 0,
					);
					$this->crud_model->insert('jobcard_track_log',$datajob_stage);
					$this->session->set_flashdata('success', 'Successfully Created New JobCard');
					redirect('m/m_dashboard/view_service_jobacard/'.$insert_id.'');	
				}
				else{
					$this->session->set_flashdata('response', 'Something WentWrong');
					$title['headerTitle']="erorr";
					$this->load->view('templates/header',$title);
					$this->load->view('mobile_view/common_error');
					$this->load->view('templates/footer');
				}
		//	}
			// else{
			// 	$this->session->set_flashdata('response', 'Already Having An Opened Job Under This Vehicle Registration '.$reg_no_id.'');					 
			// 	redirect('m/m_dashboard/newservicejob');		
			// }
			
		}
		
	}

	public function view_service_jobacard($insert_id = 0){
		
		$where = array(
			'id' => $insert_id
		);
		$records=$this->crud_model->get('job_card',$where);
				if($records != false){
			 $v_category= $this->Vehicle->getv_category();
			$categoryArray = array_column($v_category , 'type', 'id' );
			if(isset( $records[0]['vtype_id']) && isset( $categoryArray[$records[0]['vtype_id']]) ){
				$vtype_name = $categoryArray[$records[0]['vtype_id']];
			}
			else{
				$vtype_name = "";
			}
			$data['v_category']             = $v_category;
			$data['job_id']					= $records[0]['id'];
			$data['job_card_number']		= $records[0]['job_card_number'];
			$data['client_id']				= $records[0]['client_id'];
			$data['divisionid']				= $records[0]['divisionid'];
			$data['reg_no']					= $records[0]['reg_no'];
			$data['make']					= $records[0]['make'];
			$data['model']					= $records[0]['model'];
			$data['car_year']				= $records[0]['car_year'];
			$data['car_color']				= $records[0]['car_color'];
			$data['contact_id']				= $records[0]['contact_id'];
			$data['contact_name']			= $records[0]['contact_name'];
			$data['contact_num']			= $records[0]['contact_num'];
			$data['km_in']					= $records[0]['km_in'];
			$data['customer_signature']		= $records[0]['customer_signature'];
			$data['customer_complaints']	= $records[0]['customer_complaints'];
			$data['vtype_id']         	    = $records[0]['vtype_id'];
			$data['fuel_level']         	= $records[0]['fuel_level'];
			$data['inventory_detail']      	= $records[0]['inventory_detail'];
			$data['vtype_name']         	= $vtype_name;
			$data['makeArrayval']  			= $this->Vehicle->getMake();	
			$data['customer']  				= $this->Vehicle->getCustomer();
			$data['modelArrayval']  		= $this->Vehicle->getModel();				
			$where2=array(
				'job_id' => $insert_id
			);
			$nb=$this->crud_model->get('job_images',$where2);
			$data['images'] = $nb;

			$data['staff'] = $this->Vehicle->getServiceStaff();
			
			$title['headerTitle']="View Jobcard";
			$this->load->view('templates/header',$title);
			$this->load->view('mobile_view/create_view_service_Vjobcard',$data);
			$this->load->view('templates/footer');
		}
		else{
			$e_code = 501;
			redirect('m/m_dashboard/error/'.$e_code.'');
		}
	}

	public function add_service_image(){
		$job_no = $this->input->post('job_id');
		$division_id  = $this->input->post('division_id');
		$uniqueID = $job_no.'-'.$division_id;
		if(!file_exists("images/temp/".$uniqueID))
				mkdir("images/temp/".$uniqueID);
				$config['upload_path'] = 'images/temp/'.$uniqueID;
				$config['file_name'] = date("Ymd").'-'.rand(100000, 999999).'-'.$job_no;
				$config['allowed_types'] = '*';
				$config['max_size']= '0';
				//ini_set("upload_max_filesize",40M);
				$this->load->library('upload', $config);
				$this->upload->initialize($config);
				$this->upload->set_allowed_types('*');		
				if ($this->upload->do_upload('uploadedfile')) {
	
					$upload_data = $this->upload->data();
					  $file_name = $upload_data['file_name'];
					$path = 'images/temp/'.$uniqueID.'/'.$file_name;
					$this->load->library('image_lib');
					//echo $path;
					if(!file_exists("images/job/".$uniqueID)){
						mkdir("images/job/".$uniqueID);
					}
					$target_path = 'images/job/'.$uniqueID;
					$configi['image_library'] = 'gd2';
					$configi['source_image']   = $path;
					
					$configi['new_image']   = $target_path;
					$configi['maintain_ratio'] = TRUE;
					$configi['width']  = 1000; // new size
					$configi['height'] = 1000;
					$config['rotation_angle'] = '90';
					
					$this->image_lib->initialize($configi);    
					$this->image_lib->resize();
					$this->image_lib->clear();
	
					unlink('images/temp/'.$uniqueID.'/'.$file_name); 
					$newdata = array('job_id'=>$job_no, 'image'=>$file_name);
					$add_file = $this->db->insert('job_images', $newdata); 
	
					if($add_file){
						$this->session->set_flashdata('success','Image Uploaded Successfully...');
						redirect('m/m_dashboard/view_service_jobacard/'.$job_no.'');
					}else{
						$this->session->set_flashdata('response','Something Wrong.Try Again...');
						redirect('m/m_dashboard/view_service_jobacard/'.$job_no.'');
					}
								 
				} else
				{
					$this->session->set_flashdata('response',''.$this->upload->display_errors().'');
					redirect('m/m_dashboard/view_service_jobacard/'.$job_no.'');					 
			   }  
		}

		public function service_inventoryDetails_m($id = '') {
			$id = $this->input->post('job_id');
			$where=array(
				'id' => $id
			);
			$records=$this->crud_model->get('job_card',$where); 
			if($records != false){			 
				$this->form_validation->set_rules('inventory_detail', 'Customer inventory_detail', 'required');			
				if ($this->form_validation->run() == FALSE){ 
					$inventory_detail	 = $records[0]['inventory_detail'];
					$inventory_detail_master = $this->Vehicle->v_InventoryChecklist();
					$data['id'] = $id;
					if(!empty($inventory_detail_master)){
						$intry_list  = '';
						foreach($inventory_detail_master as $rec){
							if($rec['status'] == 0){
								$inventory_detail_array = explode(',', $inventory_detail);
								$checked =  in_array($rec['id'], $inventory_detail_array) ? 'checked' : ''; 
								if($rec['image'] != '' || $rec['image'] != NULL){
									$src_link =  base_url().'images/vehicle_inventory/'.$rec['image'];
								}
								else{
									$src_link =  base_url().'images/default_image.png';
								}
								$intry_list .= '<div class="col-4">
										<div class="selectgroup selectgroup-pills">
											<label class="selectgroup-item">
												<div class=" item-card">
													<input type="checkbox" name="inventory_detail_img[]" value="'.$rec['id'].'" class="selectgroup-input" '.$checked.' >
													<span class="selectgroup-button">
														<div class="product-grid6 ">
															<div class="product-image6">
																<img class="img-responsive" src="'.$src_link.'" style="height:150px;width:150px;" alt="Thumb-1">
															</div>
															<div class="product-content text-center"></div>
														</div>
														<div class="ribbone">
															<div class="ribbon"><span>'.$rec['item_name'].'</span></div>
														</div>
													</span>
												</div> 
											</label>  
										</div>  
									</div>';
							}
						}  
						 
					} 
				} else{
	
				}
			} 
			echo json_encode($intry_list);     	
		}

		public function update_service_inventory($id = ''){
			 $config = array(
				array(
					'field' => 'inventory_detail_img',
					'label' => 'Customer Inventory Detail',
					'rules' => 'callback_validate_inventory_detail_img',
					'errors' => array(
						'validate_inventory_detail_img' => 'Please select at least one inventory detail image.'
					)
				),
			);
			$this->form_validation->set_rules($config);	
			if ($this->form_validation->run() == FALSE){ 
				$data['inventory_detail']   =  set_value('inventory_detail');
				$this->session->set_flashdata('response',''.validation_errors().'',':old:');
				redirect('m/m_dashboard/view_service_jobacard/'.$id.'');
			}
			else{
				if ($this->input->post('inventory_detail_img')) {
					$inventory_details = $this->input->post('inventory_detail_img');
	
					if (is_array($inventory_details)) {
						$selected_values = implode(',', $inventory_details);
					} else {
						$selected_values = $inventory_details;
					} 
					$selected_values = rtrim($selected_values, ','); 
				}
				$data = array(
					'inventory_detail' => $selected_values,
				);	
				$this->db->trans_begin();
				$where = array('id' => $id);
				$this->crud_model->update('job_card',$data,$where);	
									
				if ($this->db->trans_status() === FALSE) {
					$this->db->trans_rollback();
					$this->session->set_flashdata('response','error Occured!!!...');
					redirect('m/m_dashboard/view_service_jobacard/'.$id.'');
				} else {
					$this->db->trans_commit();
					$this->session->set_flashdata('success', 'Inventory Details Added Successfully');
					redirect('m/m_dashboard/view_service_jobacard/'.$id.'');
				}
			}
		}



		public function service_categories($id = ''){
 			$title['headerTitle']="Service Categories";
			$where=array(
				'id' => $id
			);
			$data['grouplist']  = $this->Vehicle->getServiceLineGroup();
			$data['categorylist']  = $this->Vehicle->getMainCategorylist();
			$records=$this->crud_model->get('job_card',$where); 
			
			if($records != false){
				$config = array(
					array(
						'field' => 'service_group_id[]',
						'label' => 'Checking Line',
						'rules' => 'rtrim|required',
						'errors' => array(
							'required' => 'Please Add Any %s.'
						)
					),
					array(
						'field' => 'item_id[]',
						'label' => 'Description',
						'rules' => 'rtrim|required',
						'errors' => array(
							'required' => '%s is required.'
						)
					),array(
						'field' => 'furniture_description[]',
						'label' => 'Description',
						'rules' => 'rtrim|required',
						'errors' => array(
							'required' => '%s is required.'
						)
					),
					array(
						'field' => 'job_card_details_id[]',
						'label' => 'Job Detail Id',
						'rules' => 'rtrim|required',
						'errors' => array(
							'required' => '%s is required.'
						)
					),
					array(
						'field' => 'service_line_amnt[]',
						'label' => 'Amount',
						'rules' => 'rtrim|required',
						'errors' => array(
							'required' => '%s is required.'
						)
					),
					array(
						'field' => 'job_card_technician_id[]',
						'label' => 'Technician',
						'rules' => 'rtrim|required',
						'errors' => array(
							'required' => '%s is required.'
						)
					),
				);
					$this->form_validation->set_rules($config);			 
				 if ($this->form_validation->run() == FALSE){ 
					 $data['service_group_id']   =  set_value('service_group_id');
					 $this->session->set_flashdata('response',''.validation_errors().'',':old:');
					 
					$service_datalist = array( 
											'job_card_details_id' => '', 
											'service_group_id'    => '',  
											'jb_type' => '',  
											'service_troubleshoot' => '',  
											'item_id' => '', 
											'furniture_model' => '', 
											'vat_perce' => '',  
											'furniture_description' => '', 
											'furniture_amount' => '', 
											'item_discount'    => '', 
											'jb_type' => '', 
											'technician_id' => '', 
											'job_card_technician_id' => '', 
											'job_status' => '', 
											'section_id' => '', 
											'job_card_id' => ''
											);
					$job_service_detail= $this->Vehicle->getServiceTroubleShootlist($id);
 					if(!empty($job_service_detail)){
						foreach($job_service_detail	 as  $res){
							if($res['service_troubleshoot'] == 0 ){
								$jb_detail_id = $res['job_card_details_id'];
								$service_technician_list = $this->Vehicle->getServiceTechnicianlist($id,$jb_detail_id);	
								if (!empty($service_technician_list) && is_object($service_technician_list)) {
									$technician_id  = $service_technician_list->technician_id;
									$job_card_technician_id = $service_technician_list->id;
								}
								else{
									$technician_id  =  NULL;  $job_card_technician_id = NULL;
								}							
								$service_datalist['job_card_details_id']      =  $jb_detail_id;
								$service_datalist['service_group_id']         =  $res['service_group_id'];
								$service_datalist['jb_type']                  =  $res['jb_type'];
								$service_datalist['service_troubleshoot']     =  $res['service_troubleshoot'];
								$service_datalist['item_id']                  =  $res['item_id'];
								$service_datalist['furniture_model']          =  $res['furniture_model'];
								$service_datalist['vat_perce']                =  $res['vat_perce'];
								$service_datalist['furniture_description']    =  $res['furniture_description'];
								$service_datalist['technician_id']            =  $res['technician_id'];
 								$service_datalist['job_card_technician_id']   =  $res['technician_id'];
								$service_datalist['job_status']   			  =  $res['job_status'];
								$service_datalist['section_id']   			  =  $res['section_id'];
								$service_datalist['jb_type']   			      =  $res['jb_type'];
								$service_datalist['item_discount']   		  =  $res['item_discount'];
								$service_datalist['furniture_amount']   	  =  $res['furniture_amount'];
								$service_datalist['job_card_id']   	          =  $res['job_card_id'];
								$data['service_tbsht_list'][] = $service_datalist;
							}
						}
						
					}
					$data['id'] = $id;
					$data['staff'] = $this->Vehicle->getServiceStaff();
					$this->load->view('templates/header',$title);
					$this->load->view('mobile_view/garage_services',$data);
					$this->load->view('templates/footer'); 
				} 
				else{
					$this->db->trans_begin();
  					$job_card_details_id = $this->input->post('job_card_details_id');
 					$job_id = $this->input->post('job_id');
					if(!empty($job_card_details_id)){
						$discount 			   = $this->input->post('service_line_disc');
						$furniture_amount      = $this->input->post('service_line_amnt');
						$vat_perce             = $this->input->post('service_line_vat');
						for($k = 0; $k < count($job_card_details_id);$k++) {
							
							$vat_amount            = (floatval($furniture_amount[$k]) - floatval($discount[$k])) * (intval($vat_perce[$k]) / 100);
							$net_amount            = floatval($vat_amount) + (floatval($furniture_amount[$k]) - floatval($discount[$k]));	
							$where2 = array('job_card_id'=>$job_id,
  								        	'job_card_details_id' => $job_card_details_id[$k] 
										);
							$dataValues  = array(
							   'furniture_amount'      => $furniture_amount[$k],
							   'vat_perce'             => $vat_perce[$k],
							   'vat_amount'            => $vat_amount,
 							   'item_discount'         => $discount[$k],
							   'net_amount'            => $net_amount,
      						   );
							  // var_dump($dataValues);exit();
							$this->crud_model->update('job_card_details', $dataValues , $where2);							
						}
					}
					if ($this->db->trans_status() === FALSE) {
						$this->db->trans_rollback();
						$this->session->set_flashdata('response', 'OOPS!!!...Something WentWrong.Please Try Again.');
						redirect('m/m_dashboard/view_service_jobacard/'.$id.'');
					} else {
						$this->db->trans_commit();
						$this->session->set_flashdata('success', 'Service Category Details Updated Successfully');
						redirect('m/m_dashboard/service_categories/'.$id.'');
					}	
				}
			}
		}
 

		public function garage_services_list($id = 0, $cate_id = 0){			 
			$title['headerTitle']="Service Categories List";
			$where=array(
				'id' => $id
			);
 
			$data['grouplist']  = $this->Vehicle->getServiceLineGrouplis($cate_id);
 			$records=$this->crud_model->get('job_card',$where); 
			if($records != false){
				$config = array(
					array(
						'field' => 'service_group_id[]',
						'label' => 'Checking Line',
						'rules' => 'rtrim|required',
						'errors' => array(
							'required' => 'Please Add Any %s.'
						)
					),
					array(
						'field' => 'furniture_description[]',
						'label' => 'Description',
						'rules' => 'rtrim|required',
						'errors' => array(
							'required' => '%s is required.'
						)
					),
					array(
						'field' => 'service_line_amnt[]',
						'label' => 'Amount',
						'rules' => 'rtrim|required',
						'errors' => array(
							'required' => '%s is required.'
						)
					),
					array(
						'field' => 'job_card_technician_id[]',
						'label' => 'Service Technician',
						'rules' => 'rtrim|required',
						'errors' => array(
							'required' => '%s is required.'
						)
					),
				);
					$this->form_validation->set_rules($config);			 
				 if ($this->form_validation->run() == FALSE){ 
					$data['service_group_id']   =  set_value('service_group_id');
					$this->session->set_flashdata('response',''.validation_errors().'',':old:');
					$service_datalist = array( 
											'job_card_details_id' => '', 
											'service_group_id'    => '',  
											'jb_type' => '',  
											'service_troubleshoot' => '',  
											'item_id' => '', 
											'furniture_model' => '', 
											'vat_perce' => '',  
											'furniture_description' => '', 
											'furniture_amount' => '', 
											'item_discount'    => '', 
											'jb_type' => '', 
											'technician_id' => '', 
 											'job_card_technician_id' => '', 
											'job_status' => '', 
											'section_id' => '', 
											'job_card_id' => ''
										);
					$job_service_detail= $this->Vehicle->getServiceTroubleShootlist($id);
 					if(!empty($job_service_detail)){
						foreach($job_service_detail	 as  $res){
							if(  $res['service_troubleshoot'] == 0 ){
								$jb_detail_id = $res['job_card_details_id'];
								$service_technician_list = $this->Vehicle->getServiceTechnicianlist($id,$jb_detail_id);	
								if (!empty($service_technician_list) && is_object($service_technician_list)) {
									$technician_id  = $service_technician_list->technician_id;
									$job_card_technician_id = $service_technician_list->id;
								}
								else{
									$technician_id  =  NULL;  $job_card_technician_id = NULL;
								}							
								$service_datalist['job_card_details_id']      =  $jb_detail_id;
								$service_datalist['service_group_id']         =  $res['service_group_id'];
								$service_datalist['jb_type']                  =  $res['jb_type'];
								$service_datalist['service_troubleshoot']     =  $res['service_troubleshoot'];
								$service_datalist['item_id']                  =  $res['item_id'];
								$service_datalist['furniture_model']          =  $res['furniture_model'];
								$service_datalist['vat_perce']                =  $res['vat_perce'];
								$service_datalist['furniture_description']    =  $res['furniture_description'];
								$service_datalist['technician_id']            =  $res['technician_id'];
 								$service_datalist['job_card_technician_id']   =  $res['technician_id'];
								$service_datalist['job_status']   			  =  $res['job_status'];
								$service_datalist['section_id']   			  =  $res['section_id'];
								$service_datalist['jb_type']   			      =  $res['jb_type'];
								$service_datalist['item_discount']   		  =  $res['item_discount'];
								$service_datalist['furniture_amount']   	  =  $res['furniture_amount'];
								$service_datalist['job_card_id']   	          =  $res['job_card_id'];
								$data['service_tbsht_list'][] = $service_datalist;
							}
						}
						
					}
					$data['id'] = $id;
					$data['cate_id'] = $cate_id;
					$data['staff'] = $this->Vehicle->getServiceStaff();
					$this->load->view('templates/header',$title);
					$this->load->view('mobile_view/garage_services_list',$data);
					$this->load->view('templates/footer'); 
				} 
				else{
					$this->db->trans_begin();
  					$job_card_details_id = $this->input->post('job_card_details_id');
 					$job_id = $this->input->post('job_id');
					if(!empty($job_card_details_id)){
						$discount 			   = $this->input->post('service_line_disc');
						$furniture_amount      = $this->input->post('service_line_amnt');
						$vat_perce             = $this->input->post('service_line_vat');
						for($k = 0; $k < count($job_card_details_id);$k++) {
							
							$vat_amount            = (floatval($furniture_amount[$k]) - floatval($discount[$k])) * (intval($vat_perce[$k]) / 100);
							$net_amount            = floatval($vat_amount) + (floatval($furniture_amount[$k]) - floatval($discount[$k]));	
							$where2 = array('job_card_id'=>$job_id,
  								        	'job_card_details_id' => $job_card_details_id[$k] 
										);
							$dataValues  = array(
							   'furniture_amount'      => $furniture_amount[$k],
							   'vat_perce'             => $vat_perce[$k],
							   'vat_amount'            => $vat_amount,
 							   'item_discount'         => $discount[$k],
							   'net_amount'            => $net_amount,
      						   );
 							$this->crud_model->update('job_card_details', $dataValues , $where2);							
						}
					}									
					if ($this->db->trans_status() === FALSE) {
						$this->db->trans_rollback();
						$this->session->set_flashdata('response', 'OOPS!!!...Something WentWrong.Please Try Again.');
						redirect('m/m_dashboard/view_service_jobacard/'.$id.'');
					} else {
						$this->db->trans_commit();
						$this->session->set_flashdata('success', 'Service Category Details Updated Successfully');
						redirect('m/m_dashboard/service_categories/'.$id.'');
					}	
				}
			}
		}

		public function create_garage_service_linewise(){
			$job_id = $this->input->post('job_id');
			$id = $this->input->post('s_id');
			$section_master_id = $this->input->post('section_master_id');
			$v_model = $this->Vehicle->getVehicleModel_jodData($job_id);
 			$get_tb_data = $this->Vehicle->getGarageServicedatawithRateRow($id,$section_master_id,$v_model);			
			$staff = $this->Vehicle->getServiceStaff();
			$get_servi_data = $this->Vehicle->getGarageServicedataRow($id,$section_master_id);
			$job_tble         = $this->Vehicle->get_jobcard_div($job_id);


			$html = '';		
			$this->db->trans_begin();
			if($get_tb_data != false){
				$discount = 0 ;
				$item_id  = $get_tb_data->slm_id;
				$furniture_model       = $get_tb_data->service_name;
				$furniture_description = $get_tb_data->service_name;
				$furniture_quantity    = 1;
				$furniture_amount      = $get_tb_data->amount;
				$vat_perce             = $get_tb_data->vat;
 				$vat_amount            = (floatval($furniture_amount) - floatval($discount)) * (intval($vat_perce) / 100);
				$net_amount            = floatval($vat_amount) + (floatval($furniture_amount) - floatval($discount));
			}
			else{
				$discount = 0 ;
				$item_id  = $get_servi_data->slm_id;
				$furniture_model       = $get_servi_data->service_name;
				$furniture_description = $get_servi_data->service_name;
				$furniture_quantity    = 1;
				$furniture_amount      = 0;
				$vat_perce             = $get_servi_data->vat;
 				$vat_amount            = (floatval($furniture_amount) - floatval($discount)) * (intval($vat_perce) / 100);
				$net_amount            = floatval($vat_amount) + (floatval($furniture_amount) - floatval($discount));
			}
			$dataValues  = array(
 				'job_card_id'           => $job_id,
 				'item_id'               => $item_id,
				'furniture_model'       => $furniture_model,
				'furniture_description' => $furniture_description,
				'furniture_quantity'    => 1,
				'furniture_amount'      => $furniture_amount,
				'vat_perce'             => $vat_perce,
				'vat_amount'            => $vat_amount,
				'item_disc_perc'        => 0,
				'item_discount'         => $discount,
				'net_amount'            => $net_amount,
				'jb_type'               => 1,
  				'service_troubleshoot'  => 0,
 				'service_group_id'      => $section_master_id,
				'technician_id'			=> $job_tble->temp_technician_id,
				'job_status' => 2
			);

		    $this->crud_model->insert('job_card_details',$dataValues);
			$insert_id = $this->db->insert_id();
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				$this->session->set_flashdata('response', 'OOPS!!!...Something WentWrong.Please Try Again.');
				redirect('m/m_dashboard/view_service_jobacard/'.$id.'');
			} else {
				$this->db->trans_commit();
				$row_data = $this->Vehicle->getJobcardlast_data($insert_id,$job_id);

				if($row_data != false){			
					if($row_data->furniture_amount > (0.000) ||  $row_data->furniture_amount != 0 ){
						$readonly = 'Readonly = "readonly"';
					}
					else{
						$readonly = '';
					}
					$html = '<tr id="troubleshoot_linewise_'.$row_data->job_card_details_id.'" class="troubleshoot_linewise_'.$row_data->job_card_details_id.'">
								<td style="padding: 4px 5px 4px 10px;text-align:center;">
								    <input type="hidden" name="job_id"  value="'.$row_data->job_card_id.'"/>
									<input type="hidden" name="job_card_details_id[]"  value="'.$row_data->job_card_details_id.'"/>
									<input type="hidden" name="job_card_technician_id[]"  value="'.$row_data->technician_id.'"/>
									<input type="hidden" class="service_group_id" name="service_group_id[]"  value="'.$row_data->service_group_id.'"/>
									'.$row_data->item_id.'  
								</td>
								<td style="padding: 4px 5px 4px 10px;">
									<input type="hidden" name="item_id[]"  value="'.$row_data->item_id.'"/>
									<input type="hidden" name="furniture_model[]"  value="'.$row_data->furniture_model.'"/>
									<input type="hidden" name="service_line_vat[]" value="'.$row_data->vat_perce.'" />
									<input type="hidden" name="section_id[]" value="'.$row_data->section_id.'" />
									<input type="text"   class="form-control service_line_name" name="furniture_description[]" value="'.$row_data->furniture_description.'"  readonly  style="border: none !important;background-color: #4c5378;" />
								</td> 
								<td style="padding: 4px 2px 4px 2px;">
									<input type="number" class="form-control service_line_amnt" name="service_line_amnt[]" value="'.$row_data->furniture_amount.'" style="border: none !important;background-color: #4c5378;"  '.$readonly.' />
									<input type="hidden" class="form-control service_line_disc" name="service_line_disc[]" value="0.000" style="border: none !important;background-color: #4c5378;"/>
								</td>
								<!--<td style="padding: 4px 2px 4px 2px;">
									<input type="number" class="form-control service_line_disc" name="service_line_disc[]" value="0.000" style="border: none !important;background-color: #4c5378;"/>
								</td>-->
								<td style="padding: 4px 2px 4px 2px;">
									<span class="remove_button remove_button_'.$row_data->job_card_details_id.'">
										<button type="button" class="btn btn-danger remove_serv_tr" data-jobcard-id="'.$row_data->job_card_id.'" data-remove-id="'.$row_data->job_card_details_id.'"><i class="fe fe-x-circle" style="font-size:16px;"></i></button>
									</span>	
								</td>
							</tr>';
				}
			}
			echo json_encode($html);
		}

		public function stock_services_brand($job_id = 0 , $cate_id = 0){
			$title['headerTitle']="Stock Brand";
			$data['id'] = $job_id;
			$data['cate_id'] = $cate_id;
 			$data['stock_brand']  = $this->Vehicle->getCategorystockBrand($cate_id);
			$this->load->view('templates/header',$title);
			$this->load->view('mobile_view/stock_services_brand',$data);
			$this->load->view('templates/footer'); 
		}

		public function stock_services_brand_list($id = 0,$cate_id = 0, $brand_id = 0){			 
			$title['headerTitle']="Select Item";
			$where=array(
				'id' => $id
			);
			$data['items']  = $this->Vehicle->getServiceItemlist($brand_id);
 			$records=$this->crud_model->get('job_card',$where); 
			if($records != false){
				$config = array(
					array(
						'field' => 'service_group_id[]',
						'label' => 'Checking Line',
						'rules' => 'rtrim|required',
						'errors' => array(
							'required' => 'Please Add Any %s.'
						)
					),
					array(
						'field' => 'item_id[]',
						'label' => 'Description',
						'rules' => 'rtrim|required',
						'errors' => array(
							'required' => '%s is required.'
						)
					),array(
						'field' => 'furniture_description[]',
						'label' => 'Description',
						'rules' => 'rtrim|required',
						'errors' => array(
							'required' => '%s is required.'
						)
					),
					array(
						'field' => 'job_card_details_id[]',
						'label' => 'Job Detail Id',
						'rules' => 'rtrim|required',
						'errors' => array(
							'required' => '%s is required.'
						)
					),
					array(
						'field' => 'service_line_amnt[]',
						'label' => 'Amount',
						'rules' => 'rtrim|required',
						'errors' => array(
							'required' => '%s is required.'
						)
					),
					array(
						'field' => 'job_card_technician_id[]',
						'label' => 'Technician',
						'rules' => 'rtrim|required',
						'errors' => array(
							'required' => '%s is required.'
						)
					),
				);
					$this->form_validation->set_rules($config);			 
				 if ($this->form_validation->run() == FALSE){ 
					$data['service_group_id']   =  set_value('service_group_id');
					$this->session->set_flashdata('response',''.validation_errors().'',':old:');
					$service_datalist = array( 
											'job_card_details_id' => '', 
											'service_group_id' => '',  
											'jb_type' => '',  
											'service_troubleshoot' => '',  
											'item_id' => '', 
											'furniture_model' => '', 
											'vat_perce' => '',  
											'furniture_description' => '', 
											'technician_id' => '', 
											'aws' => '', 
											'min' => '', 
											'job_card_technician_id' => '', 
											'job_status' => '', 
											'section_id' => '', 
											'job_card_id' => '', 
										);
					$job_service_detail= $this->Vehicle->getServiceTroubleShootlist($id);
 					if(!empty($job_service_detail)){
						foreach($job_service_detail	 as  $res){
							if( $res['service_troubleshoot'] == 0 ){
								$jb_detail_id = $res['job_card_details_id'];
								$service_technician_list = $this->Vehicle->getServiceTechnicianlist($id,$jb_detail_id);	
								if (!empty($service_technician_list) && is_object($service_technician_list)) {
									$technician_id  = $service_technician_list->technician_id;
									$job_card_technician_id = $service_technician_list->id;
								}
								else{
									$technician_id  =  NULL;  $job_card_technician_id = NULL;
								}							
								$service_datalist['job_card_details_id']      =  $jb_detail_id;
								$service_datalist['service_group_id']         =  $res['service_group_id'];
								$service_datalist['jb_type']                  =  $res['jb_type'];
								$service_datalist['service_troubleshoot']     =  $res['service_troubleshoot'];
								$service_datalist['item_id']                  =  $res['item_id'];
								$service_datalist['furniture_model']          =  $res['furniture_model'];
								$service_datalist['vat_perce']                =  $res['vat_perce'];
								$service_datalist['furniture_description']    =  $res['furniture_description'];
								$service_datalist['technician_id']            =  $res['technician_id'];
 								$service_datalist['job_card_technician_id']   =  $res['technician_id'];
								$service_datalist['job_status']   			  =  $res['job_status'];
								$service_datalist['section_id']   			  =  $res['section_id'];
 								$service_datalist['item_discount']   		  =  $res['item_discount'];
								$service_datalist['furniture_amount']   	  =  $res['furniture_amount'];
								$service_datalist['job_card_id']   	          =  $res['job_card_id'];
								$data['service_tbsht_list'][] = $service_datalist;
							}
						}
					}
					$data['id'] = $id;
					$data['cate_id'] = $cate_id;
					$data['brand_id'] = $brand_id;
					$data['staff'] = $this->Vehicle->getServiceStaff();
					$this->load->view('templates/header',$title);
					$this->load->view('mobile_view/stock_services_item_list',$data);
					$this->load->view('templates/footer'); 
				} 
				else{
					$this->db->trans_begin();
 					$job_card_details_id = $this->input->post('job_card_details_id');
 					$job_id = $this->input->post('job_id');
					if(!empty($job_card_details_id)){
						$discount 			   = $this->input->post('service_line_disc');
						$furniture_amount      = $this->input->post('service_line_amnt');
						$vat_perce             = $this->input->post('service_line_vat');
						for($k = 0; $k < count($job_card_details_id);$k++) {
							
							$vat_amount            = (floatval($furniture_amount[$k]) - floatval($discount[$k])) * (intval($vat_perce[$k]) / 100);
							$net_amount            = floatval($vat_amount) + (floatval($furniture_amount[$k]) - floatval($discount[$k]));	
							$where2 = array('job_card_id'=>$job_id,
  								        	'job_card_details_id' => $job_card_details_id[$k] 
										);
							$dataValues  = array(
							   'furniture_amount'      => $furniture_amount[$k],
							   'vat_perce'             => $vat_perce[$k],
							   'vat_amount'            => $vat_amount,
 							   'item_discount'         => $discount[$k],
							   'net_amount'            => $net_amount,
      						   );
							  // var_dump($dataValues);exit();
							$this->crud_model->update('job_card_details', $dataValues , $where2);							
						}
					}					 									
					if ($this->db->trans_status() === FALSE) {
						$this->db->trans_rollback();
						$this->session->set_flashdata('response', 'OOPS!!!...Something WentWrong.Please Try Again.');
						redirect('m/m_dashboard/view_service_jobacard/'.$id.'');
					} else {
						$this->db->trans_commit();
						$this->session->set_flashdata('success', 'Service Category Details Updated Successfully');
						redirect('m/m_dashboard/service_categories/'.$id.'');
					}	
				}
			}
		}

		public function create_garage_service_stock_items(){
			$job_id  = $this->input->post('job_id');
			$item_id = $this->input->post('item_id');
			$service_brand_id = $this->input->post('service_brand_id');
			$item_name        = $this->input->post('item_name');
			$vat              = $this->input->post('vat');
			$cate_id          = $this->input->post('cate_id');
			$job_tble         = $this->Vehicle->get_jobcard_div($job_id);
			$selling_price    = $this->Vehicle->getServiceItemsellingprice($item_id,$job_tble->divisionid); 
			$html = '';		
			$this->db->trans_begin();
			if($selling_price != false){
				$discount              = 0 ;
 				$furniture_amount      = $selling_price;
				$vat_perce             = $vat;
 				$vat_amount            = (floatval($furniture_amount) - floatval($discount)) * (intval($vat_perce) / 100);
				$net_amount            = floatval($vat_amount) + (floatval($furniture_amount) - floatval($discount));
			}
			else{
				$discount 			   = 0 ;
    			$furniture_amount      = 0;
				$vat_perce             = $vat;
 				$vat_amount            = (floatval($furniture_amount) - floatval($discount)) * (intval($vat_perce) / 100);
				$net_amount            = floatval($vat_amount) + (floatval($furniture_amount) - floatval($discount));
			}
			$dataValues  = array(
 				'job_card_id'           => $job_id,
 				'item_id'               => $item_id,
				'furniture_model'       => $item_name,
				'furniture_description' => $item_name,
				'furniture_quantity'    => 1,
				'furniture_amount'      => $furniture_amount,
				'vat_perce'             => $vat_perce,
				'vat_amount'            => $vat_amount,
				'item_disc_perc'        => 0,
				'item_discount'         => $discount,
				'net_amount'            => $net_amount,
				'jb_type'               => 1,
  				'service_troubleshoot'  => 0,
 				'service_group_id'      => $cate_id,
  				'jb_type'               => 2,
				'technician_id'			=> $job_tble->temp_technician_id,
  				'job_status'            => 2
			);

		    $this->crud_model->insert('job_card_details',$dataValues);
			$insert_id = $this->db->insert_id();
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				$this->session->set_flashdata('response', 'OOPS!!!...Something WentWrong.Please Try Again.');
				redirect('m/m_dashboard/view_service_jobacard/'.$id.'');
			} else {
				$this->db->trans_commit();
				$row_data = $this->Vehicle->getJobcardlast_data($insert_id,$job_id);

				if($row_data != false){			
					if($row_data->furniture_amount > (0.000) ||  $row_data->furniture_amount != 0 ){
						$readonly = 'Readonly = "readonly"';
					}
					else{
						$readonly = '';
					}
					$html = '<tr id="troubleshoot_linewise_'.$row_data->job_card_details_id.'" class="troubleshoot_linewise_'.$row_data->job_card_details_id.'">
								<td style="padding: 4px 5px 4px 10px;text-align:center;">
									<input type="hidden" name="job_id"  value="'.$row_data->job_card_id.'"/>
									<input type="hidden" name="job_card_details_id[]"  value="'.$row_data->job_card_details_id.'"/>
									<input type="hidden" name="job_card_technician_id[]"  value="'.$row_data->technician_id.'"/>
									<input type="hidden" class="service_group_id" name="service_group_id[]"  value="'.$row_data->service_group_id.'"/>
 									'.$row_data->item_id.'  
								</td>
								<td style="padding: 4px 5px 4px 10px;">
									<input type="hidden" name="item_id[]"  value="'.$row_data->item_id.'"/>
									<input type="hidden" name="furniture_model[]"  value="'.$row_data->furniture_model.'"/>
									<input type="hidden" name="service_line_vat[]" value="'.$row_data->vat_perce.'" />
									<input type="hidden" name="section_id[]" value="'.$row_data->section_id.'" />
									<input type="text"   class="form-control service_line_name" name="furniture_description[]" value="'.$row_data->furniture_description.'"  readonly  style="border: none !important;background-color: #4c5378;" />
								</td> 
								<td style="padding: 4px 2px 4px 2px;">
									<input type="number" class="form-control service_line_amnt" name="service_line_amnt[]" value="'.$row_data->furniture_amount.'" style="border: none !important;background-color: #4c5378;"  '.$readonly.' />
									<input type="hidden" class="form-control service_line_disc" name="service_line_disc[]" value="0.000" style="border: none !important;background-color: #4c5378;"/>
								</td>
								<!--<td style="padding: 4px 2px 4px 2px;">
									<input type="number" class="form-control service_line_disc" name="service_line_disc[]" value="0.000" style="border: none !important;background-color: #4c5378;"/>
								</td>-->
								<td style="padding: 4px 2px 4px 2px;">
									<span class="remove_button remove_button_'.$row_data->job_card_details_id.'">
										<button type="button" class="btn btn-danger remove_serv_tr"  data-jobcard-id="'.$row_data->job_card_id.'" data-remove-id="'.$row_data->job_card_details_id.'"><i class="fe fe-x-circle" style="font-size:16px;"></i></button>
									</span>	
								</td>
							</tr>';
				}
			}
			echo json_encode($html);
		}


		public function unlink_garageservices(){
			$this->db->trans_begin();
			$job_dtl_id  =  $this->input->post('jb_dtl_id');
			$job_id      =  $this->input->post('job_id');
			$msg = '';
			$where2 = array('job_card_id'=>$job_id ,
  							'job_card_details_id' => $job_dtl_id 
						);
			$this->crud_model->delete('job_card_details',$where2);
		    if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				$msg = 'error';
			} else {
				$this->db->trans_commit();
				$msg = 'success';
			}
			echo json_encode($msg);
		}

		public function update_garage_services($id = 0){
			$this->db->trans_begin();
			$job_card_detailsdataValues  = array(
				'job_status' => 2
			);
			$wherejob = array(
				'job_status' => 1,
				'service_troubleshoot' => 0,
				'job_card_id' => $id,
				'jb_type' => 1,
			);
	
			$this->crud_model->update('job_card_details',$job_card_detailsdataValues,$wherejob);
	
			$datatecval = array(
				'job_technician_status' => 2,
				
			);
			$wheretec = array(
				'progress_status' => 0,
				'service_troubleshoot' => 0,
				'job_id' => $id
			);
			$this->crud_model->update('job_card_technician',$datatecval,$wheretec);
	
	
			$job_card_data= array(
				'jobcard_stage' =>5,			
			);
			$where_job_card = array(
				'id' => $id
			);
			$this->crud_model->update('job_card',$job_card_data,$where_job_card);
	
			$date = date("Y-m-d H:i:s");
			$datajob_stage = array(
				'job_id' => $id,
				'user_id' => $this->session->userdata('user_id'),
				'log_date' => $date,
				'log_status' => 5,
			);
			$this->crud_model->insert('jobcard_track_log',$datajob_stage);
	
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				$this->session->set_flashdata('response', 'OOPS!!!...Something WentWrong.Please Try Again.');
				redirect('m/m_dashboard/view_service_jobacard/'.$id.'');
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'Service Troubleshoot Completed Successfully');
				redirect('m/m_dashboard/service_categories/'.$id.'');
			}
		} 
 
	
	public function error($e_code = ''){
		$this->session->set_flashdata('response', 'Something WentWrong');
		$title['headerTitle']="OOPS!";
		$data['error_code'] = $e_code;
		$this->load->view('templates/header',$title);
		$this->load->view('mobile_view/common_error',$data);
		$this->load->view('templates/footer');
	}
	public function validate_inventory_detail_img($str) {
		if (isset($_POST['inventory_detail_img']) && count($_POST['inventory_detail_img']) > 0) {
			foreach ($_POST['inventory_detail_img'] as $value) {
				if ($value != '') {
					return true; 
				}
			}
			return false; 
		} else {
			return false;
		}
	}
	public function validate_v_type($reg_no)
	{
		$v_type = $this->input->post('v_type');
		if (!$this->Vehicle->is_v_type_valid($reg_no,$v_type)) {
			return false;
		}
		return true;
	}
	public function validate_edit_v_type($reg_no)
	{
		$v_type = $this->input->post('v_type');		
		if(!empty($this->input->post('reg_no_id'))){
			$id  = $this->input->post('reg_no_id');
		}
		else{
			$id  = $this->input->post('regnoid');
			
		}
		if (!$this->Vehicle->is_edit_v_type_valid($reg_no, $v_type,$id)) {
			return false;
		}
		return true;
	}

	public function validate_chassi_number()
	{
		$v_type = $this->input->post('v_type');
 		if (!$this->Vehicle->is_chassi_number_valid($v_type,)) {
			return false;
		}
		return true;
	}
	public function validate_edit_chassi_number()
	{
		$v_type = $this->input->post('v_type');
		$id  = $this->input->post('reg_no_id');
		if (!$this->Vehicle->is_edit_chassi_number_valid($v_type, $id)) {
			return false;
		}
		return true;
	}
	
}