<?php
class M_dashboard extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
		$this->load->model('Vehicle');
		$this->load->model('users_model');
	}
	public function index(){
		 
		$title['headerTitle']="Vehicle Job Card";
		$data['make']  = $this->Vehicle->getMake();
		$data['model']  = $this->Vehicle->getModel();
		$data['customer']  = $this->Vehicle->getCustomer();
		$data['registration']  = $this->Vehicle->getRegistration();
		$data['vjobcard'] = $this->Vehicle->getMVjobcard();
		$this->load->view('templates/header',$title);
		$this->load->view('mobile_view/dashboard',$data);
		$this->load->view('templates/footer');
	}
	public function newjob(){
		if(get_cookie('division_val_id')!=false){ 
			 
			$data['enq_no']= $this->crud_model->get_job_no(get_cookie('division_val_id')); 
			$title['h_division_id']=get_cookie('division_val_id'); 
			$data['h_division_id']=get_cookie('division_val_id'); 
		} else { 
			$data['enq_no']= NULL; 
			$title['h_division_id']=NULL; 
			$data['h_division_id']=NULL; 
		}
		$this->users_model->permission("Job_card", "Add");
		$title['headerTitle']="Create Vehicle Job Card";
		$this->load->view('templates/header',$title);
		 
		$data['make']  = $this->Vehicle->getMake();
		$data['staff']  = $this->Vehicle->getServiceStaff();
		$data['advisor']  = $this->Vehicle->getAdvisorStaff();
		$this->load->view('mobile_view/create_Vjobcard',$data);
		$this->load->view('templates/footer');
	}

	public function do_insert(){
		$this->users_model->permission("Job_card", "Add");
		$reg_no_id = $this->input->post('reg_no');
		//$dbdata = $this->Vehicle->dataRow($reg_no_id);
		// if(get_cookie('division_val_id')!=false){ 
		// 	$data['enq_no']= $this->crud_model->get_job_no(get_cookie('division_val_id')); 
		// 	$title['h_division_id']=get_cookie('division_val_id'); 
		// 	$data['h_division_id']=get_cookie('division_val_id'); 
		// } else { 
		// 	$data['enq_no']= NULL; 
		// 	$title['h_division_id']=NULL; 
		// 	$data['h_division_id']=NULL; 
		// }
		if(empty($this->input->post('division_id')) ){

			 $this->session->set_flashdata('response', 'Something WentWrong');
			// $title['headerTitle']="erorr";
			// $this->load->view('templates/header',$title);
			// $this->load->view('mobile_view/common_error');
			// $this->load->view('templates/footer');
			$e_code = 503;
			redirect('m/m_dashboard/error/'.$e_code.'');
		}
		else{
			$division_id = $this->input->post('division_id');
			$job_card_number  = $this->crud_model->get_job_no($division_id);
			$date = date("Y-m-d H:i:s");
			$data = array(
				'job_card_number' => $job_card_number,
				'job_card_date' => 	$date,
				'client_id' => $this->input->post('client_id'),
				'divisionid' => $division_id,
				'created_user_id' => $this->session->userdata('user_id'),
				'reg_no' =>  $this->input->post('p_reg_no'),
				'make' =>  $this->input->post('make'),
				'model' =>  $this->input->post('model'),
				'car_year' =>  $this->input->post('car_year'),
				'car_color' =>  $this->input->post('car_color'),
				'contact_id' => '',
				'contact_name' => '',
				'contact_num' =>  $this->input->post('p_contact_num'),
				'km_in' =>  $this->input->post('p_km_in'),
				'next_km' =>  '',
				'is_insurance' =>  '',
				'salesman_id' =>  $this->session->userdata('user_id'),
				'job_card_status' =>  'Draft',
				'job_card_total' =>  '',
				'job_card_vat_perc' =>  10,
				'job_card_vat_amount' =>  '',
				'job_card_amount_with_vat' =>  '',
			);
			$res = $this->crud_model->insert('job_card',$data);
			$insert_id = $this->db->insert_id();
			if(!empty($insert_id)){
				
				$userid = $this->session->userdata('user_id');
				$datalog= array(						
					'masters_type'=>'Vehicle Job Card_Tab',	
					'masters_id'=>$insert_id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'create',	
				);
				$this->crud_model->insert('log_for_masters',$datalog);
				$this->session->set_flashdata('success', 'Successfully Created New JobCard');
				redirect('m/m_dashboard/view_jobacard/'.$insert_id.'');
				
				
			}
			else{
				$this->session->set_flashdata('response', 'Something WentWrong');
				$title['headerTitle']="erorr";
				$this->load->view('templates/header',$title);
				$this->load->view('mobile_view/common_error');
				$this->load->view('templates/footer');
			}
		}
		
	}

	public function view_jobacard($insert_id = 0){
		
		$where = array(
			'id' => $insert_id
		);
		$records=$this->crud_model->get('job_card',$where);
		
		
		if($records != false){
			$data['job_id']					= $records[0]['id'];
			$data['job_card_number']		= $records[0]['job_card_number'];
			$data['client_id']				= $records[0]['client_id'];
			$data['divisionid']				= $records[0]['divisionid'];
			$data['reg_no']					= $records[0]['reg_no'];
			$data['make']					= $records[0]['make'];
			$data['model']					= $records[0]['model'];
			$data['car_year']				= $records[0]['car_year'];
			$data['car_color']				= $records[0]['car_color'];
			$data['contact_id']				= $records[0]['contact_id'];
			$data['contact_name']			= $records[0]['contact_name'];
			$data['contact_num']			= $records[0]['contact_num'];
			$data['km_in']					= $records[0]['km_in'];
			$data['customer_signature']		= $records[0]['customer_signature'];
			$data['customer_complaints']	= $records[0]['customer_complaints'];
			$data['makeArrayval']  			= $this->Vehicle->getMake();	
			$data['customer']  				= $this->Vehicle->getCustomer();
			$data['modelArrayval']  		= $this->Vehicle->getModel();	

			$where2=array(
				'job_id' => $insert_id
			);
			$nb=$this->crud_model->get('job_images',$where2);
			$data['images'] = $nb;

			
			$title['headerTitle']="View Jobcard";
			$this->load->view('templates/header',$title);
			$this->load->view('mobile_view/create_view_Vjobcard',$data);
			$this->load->view('templates/footer');
		}
		else{
			$e_code = 501;
			redirect('m/m_dashboard/error/'.$e_code.'');
		}
	}
	public function add_signature(){
		//echo 1; exit();
		$job_id = $this->input->post('job_id');
		$msg = '';
		
		$where = array('id' => $this->input->post('job_id'));
		$data = array(
			'customer_signature' => $this->input->post('customer_signature'),
		);
		$rs=$this->crud_model->update('job_card',$data,$where);
		if($rs===false){
				echo 'error';
		} else  {
			echo 'ok';
		}
	}

	public function getJob(){
		if(get_cookie('division_val_id')!=false){ 			 
			$data['enq_no']= $this->crud_model->get_job_no(get_cookie('division_val_id')); 
			$title['h_division_id']=get_cookie('division_val_id'); 
			$data['h_division_id']=get_cookie('division_val_id'); 
		} else { 
			$data['enq_no']= NULL; 
			$title['h_division_id']=NULL; 
			$data['h_division_id']=NULL; 
		}
		$this->users_model->permission("Job_card", "Add");
		$title['headerTitle']="Get Job";
		$this->load->view('templates/header',$title);
		 
		$data['make']  = $this->Vehicle->getMake();
		$data['staff']  = $this->Vehicle->getServiceStaff();
		$data['advisor']  = $this->Vehicle->getAdvisorStaff();
		$this->load->view('mobile_view/get_job',$data);
		$this->load->view('templates/footer');
	}

	public function add_compliants(){
		$job_id = $this->input->post('job_id');
		$customer_complaints = $this->input->post('customer_complaints');
		$customer_complaints = htmlentities($customer_complaints);
		$customer_complaints = htmlspecialchars($customer_complaints, ENT_QUOTES | ENT_SUBSTITUTE);
		$where = array('id' => $this->input->post('job_id'));
		$data = array(
			'customer_complaints' =>$customer_complaints,
		);
		$rs=$this->crud_model->update('job_card',$data,$where);
		if($rs===false){
				echo 'error';
		} else  {
			echo 'ok';
		}
	}

public function add_image(){
	$job_no = $this->input->post('job_id');
	$division_id  = $this->input->post('division_id');
	$uniqueID = $job_no.'-'.$division_id;
	if(!file_exists("images/temp/".$uniqueID))
			mkdir("images/temp/".$uniqueID);
			$config['upload_path'] = 'images/temp/'.$uniqueID;
			$config['file_name'] = date("Ymd").'-'.rand(100000, 999999).'-'.$job_no;
			$config['allowed_types'] = '*';
			$config['max_size']= '0';
			//ini_set("upload_max_filesize",40M);
			$this->load->library('upload', $config);
			$this->upload->initialize($config);
			$this->upload->set_allowed_types('*');		
			if ($this->upload->do_upload('uploadedfile')) {

				$upload_data = $this->upload->data();
  				$file_name = $upload_data['file_name'];
				$path = 'images/temp/'.$uniqueID.'/'.$file_name;

				//echo $path;
				if(!file_exists("images/job/".$uniqueID))
					mkdir("images/job/".$uniqueID);
					$target_path = 'images/job/'.$uniqueID;
					$configi['image_library'] = 'gd2';
					$configi['source_image']   = $path;
					
					$configi['new_image']   = $target_path;
					$configi['maintain_ratio'] = TRUE;
					$configi['width']  = 1000; // new size
					$configi['height'] = 1000;
					$config['rotation_angle'] = '90';
					$this->load->library('image_lib');
					$this->image_lib->initialize($configi);    
					$this->image_lib->resize();
					$this->image_lib->clear();

				unlink('images/temp/'.$uniqueID.'/'.$file_name);
				$newdata = array('job_id'=>$job_no, 'image'=>$file_name);
				$add_file = $this->db->insert('job_images', $newdata); 

				if($add_file){
					$this->session->set_flashdata('success','Image Uploaded Successfully...');
					redirect('m/m_dashboard/view_jobacard/'.$job_no.'');
				}else{
					$this->session->set_flashdata('response','Something Wrong.Try Again...');
					redirect('m/m_dashboard/view_jobacard/'.$job_no.'');
				}
							 
			} else
			{
				$this->session->set_flashdata('response',''.$this->upload->display_errors().'');
				redirect('m/m_dashboard/view_jobacard/'.$job_no.'');
				 
		   } 
		//}
		// else{
		// 	$this->session->set_flashdata('error','Sorry!! Take a Image Before Adding Image...');
		// 	redirect('m/m_dashboard/view_jobacard/'.$job_no.'');
		// }  
    }

	public function add_new_registration(){
		$this->users_model->permission("Job_card", "Add");
		$title['headerTitle']="New Registration";
		$this->load->view('templates/header',$title);
		$this->load->view('mobile_view/add_vehicle');
		$this->load->view('templates/footer');

	}

	public function add_registration(){
		$config = array(
			array(
				'field' => 'reg_no',
				'label' => 'Registration Number',
				'rules' => 'trim|required|is_unique[reg_no_table.reg_no]',
				'errors' => array(
					'is_unique'      => 'This %s is Already Exists..',
					'required'      => 'Please Enter %s.'
				)
				),array(
                    'field' => 'make',
                    'label' => 'Make',
                    'rules' => 'rtrim|required',
                    'errors' => array(
                        'required'      => 'Please Enter Vehicle %s.'
                    )
            ),
			array(
                    'field' => 'model',
                    'label' => 'Model',
                    'rules' => 'trim|required',
                    'errors' => array(
                        'required'      => 'Please Choose Any Vehicle %s.'
                    )
			),
		  array(
				'field' => 'client',
				'label' => 'Customer Name',
				'rules' => 'trim|required',
				'errors' => array(
				'required'      => 'Please Enter %s.'
				)
				),
				array(
					'field' => 'client_id',
					'label' => 'Customer Name',
					'rules' => 'trim|required',
					'errors' => array(
					'required'      => '%s Not Found.'
					)
					),

		);	
		$this->form_validation->set_rules($config);
		$make_id = $this->input->post('make_id');
		$where2=array(
			'make_id' => $make_id
		);
		$nb=$this->crud_model->get('model',$where2);
		
		if ($this->form_validation->run() == FALSE){
			$data['reg_no']  	=  set_value('reg_no');
			$data['make']     	=  set_value('make');
			$data['make_id']    =  set_value('make_id');
			//$data['model']    =  $this->Vehicle->getJBCModel($model_id);	
			$data['model'] 		= $nb;		
			$data['chassi_number']  =  set_value('chassi_number');
			$data['client']   	=  set_value('client');
			$data['client_id']  =  set_value('client_id');
			$data['car_year']   =  set_value('car_year');
			$data['car_color']  =  set_value('car_color');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');

			$title['headerTitle']="New Registration";
			$this->load->view('templates/header',$title);
			$this->load->view('mobile_view/add_vehicle',$data);
			$this->load->view('templates/footer');
		}
		else{
			$data = array(
				'reg_no'	 =>	$this->input->post('reg_no'),
				'make_id' => $this->input->post('make_id'),
				'model_id' => $this->input->post('model'),
				'client_id' => $this->input->post('client_id'),				 
				'car_year' => $this->input->post('car_year'),
				'car_color' => $this->input->post('car_color'),
				'chassi_number' => $this->input->post('chassi_number'),
			);
			$res = $this->crud_model->insert('reg_no_table',$data);
			if($res === false){
				$this->session->set_flashdata('response', 'Something WentWrong');
				$e_code = 503;
				redirect('m/m_dashboard/error/'.$e_code.'');
			}
			else{
				$insert_id = $this->db->insert_id();
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$datalog= array(						
					'masters_type'=>'Vehicle Registration_Tab',	
					'masters_id'=>$insert_id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'create new ',	
				);
				$this->crud_model->insert('log_for_masters',$datalog);
				$this->session->set_flashdata('success','New Vehichle Registration Added Successfully ');
				redirect('m/m_dashboard/newjob');
			}

		}
	}

	public function get_job_list(){
		$reg_no  = $this->input->post('reg_no');
		$html ="";
		$i = 1;
		$j = 1;
		$where2=array(
			'reg_no' => $reg_no,
			'job_card_status'=>'draft'
		);
		$nb=$this->crud_model->get('job_card',$where2,null, null, "job_card_date", "DESC", null, null, null, "job_card_date");
		if(!empty($nb)){
				//var_dump($nb);
				$html ='
				<table id="jocardDtl">
				  <thead>
					  <tr>
						<th>#</th>
						 
						<th>JobCard#</th>
						<th>Date</th>
						<th>Action</th>
					  </tr>
				  </thead>
				  <tbody class="scroll-pane">';
			foreach($nb as $rec){
				$html .= ' <tr>
						<td class="lazy-load"  >'.$i++.'</td>
						<td  class="lazy-load" >'.$rec['job_card_number'].'</td>
						<td  class="lazy-load" >'.date('d-M-y' ,strtotime($rec['job_card_date'])).'</td>
						<td  class="lazy-load" ><a href="'.site_url(('m/m_dashboard/view_jobacard/'.$rec['id'].'')).'" >Update</a></td>
					  </tr>';
					  $j++;
			}
			$html .='</tbody>
			</table>';
			
				}
		else{
			$html ='<span id="no_data">no records found for the register number '.$reg_no.' </span>';
		}
		echo $html;

	}

	public function error($e_code = ''){
		$this->session->set_flashdata('response', 'Something WentWrong');
		$title['headerTitle']="OOPS!";
		$data['error_code'] = $e_code;
		$this->load->view('templates/header',$title);
		$this->load->view('mobile_view/common_error',$data);
		$this->load->view('templates/footer');
	}

	public function create(){
		$this->users_model->permission("Job_card", "Add");
		$reg_no_id = $this->input->post('reg_no');
		$dbdata = $this->Vehicle->dataRow($reg_no_id);
		if(get_cookie('division_val_id')!=false){ 
			$data['enq_no']= $this->crud_model->get_job_no(get_cookie('division_val_id')); 
			$title['h_division_id']=get_cookie('division_val_id'); 
			$data['h_division_id']=get_cookie('division_val_id'); 
		} else { 
			$data['enq_no']= NULL; 
			$title['h_division_id']=NULL; 
			$data['h_division_id']=NULL; 
		}
		$config = array(		 
			array(
                    'field' => 'make',
                    'label' => 'Make',
                    'rules' => 'rtrim|required',
                    'errors' => array(
                        'required'      => 'Please Select %s.'
                    )
            ),
			array(
                    'field' => 'model',
                    'label' => 'Model',
                    'rules' => 'trim|required',
                    'errors' => array(
                        'required'      => 'Please Select %s.'
                    )
			),
		  array(
			'field' => 'client',
			'label' => 'Customer Name',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please Enter %s.'
			)
	   		),array(
			'field' => 'contact_name',
			'label' => 'Contact Name',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please Enter %s.'
			)
	   		),array(
			'field' => 'contact_num',
			'label' => 'Contact Number',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please Enter %s.'
			)
	   		),array(
			'field' => 'km_in',
			'label' => 'Kilometer IN',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please Enter %s.'
			)
	   		),array(
			'field' => 'job_card_number',
			'label' => 'Job Number',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please select a division to add %s.'
			)
	   		),array(
			'field' => 'job_date',
			'label' => 'Date',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please select %s.'
			)
	   		), 
		);	
		if($this->input->post('reg_val') == 1 || empty($this->input->post('reg_val'))){
			$config[] = array(
				'field' => 'reg_no',
				'label' => 'Registration Number',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.',
				)
			);
			$config[] = array(
					'field' => 'chassi_number',
					'label' => 'Chassi Number',
					'rules' => 'trim|required',
					'errors' => array(
						'required'      => 'Please Enter %s.',
					)
				);
			
		}
		if($this->input->post('reg_val') == 0 || empty($this->input->post('reg_val'))  ){
			if($reg_no_id != '')
			{
				$config[] = array(
					'field' => 'reg_no',
					'label' => 'This Registration Number',
					'rules' => 'trim|is_unique[reg_no_table.reg_no]',
					'errors' => array(
						'is_unique'      => '%s  is Already Exists..'
					)
				);
			}
			else{
				$config[] = array(
					'field' => 'reg_no',
					'label' => 'Registration Number',
					'rules' => 'trim|required',
					'errors' => array(
						'required'      => 'Please Enter %s.',
					)
				);
			}
				$config[] = array(
					'field' => 'chassi_number',
					'label' => 'Chassi Number',
					'rules' => 'trim|is_unique[reg_no_table.chassi_number]',
					'errors' => array(
						'is_unique'      => '%s already exists.'
					)
				); 
		}
        $this->form_validation->set_rules($config);
		$model_id = $this->input->post('model');
		$Client_Id = $this->input->post('client_id');
		$get_cutomer_conatct =$this->Vehicle->get_ContactDetails($Client_Id);


		if ($this->form_validation->run() == FALSE){
			$data['reg_no']   =  set_value('reg_no');
			$data['make']     =  set_value('make');
			$data['model']    =  $this->Vehicle->getJBCModel($model_id);			
			$data['chassi_number']  =  set_value('chassi_number');
			$data['client']   =  set_value('client');
			 
			$data['contact_name'] =  set_value('contact_name');
			$data['contact_num']  =  set_value('contact_num');
			$data['km_in']      =  set_value('km_in');
			$data['job_card_number']  =  set_value('job_card_number');
			$data['job_date']   =  set_value('job_date');
			$data['advisor']    =  set_value('advisor');
			$data['car_year']   =  set_value('car_year');
			$data['car_color']  =  set_value('car_color');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');

			$title['headerTitle']="Vehicle Job Card";
			$this->load->view('templates/header',$title);
			$data['make']     = $this->Vehicle->getMake();
			$data['staff']    = $this->Vehicle->getServiceStaff();
			$data['advisor']  = $this->Vehicle->getAdvisorStaff();
			
			$this->load->view('furniture/quotations/jobcard/create_Vjobcard',$data);
			$this->load->view('templates/footer');
		}
		else{
			$division_id = $this->input->post('division_id');
			$job_card_number  = $this->crud_model->get_job_no($division_id);
			$is_insurance = $this->input->post('is_insurance') !='' || $this->input->post('is_insurance') == 1 ? 1 : 0;
			$contact_name = $this->input->post('contact_name');
				if($this->input->post('reg_val') == 0 ){
					$data = array(
						'reg_no'	 =>	$this->input->post('reg_no'),
						'make_id' => $this->input->post('make'),
						'model_id' => $this->input->post('model'),
						'client_id' => $this->input->post('client_id'),				 
						'car_year' => $this->input->post('car_year'),
						'car_color' => $this->input->post('car_color'),
						'chassi_number' => $this->input->post('chassi_number'),
					);
				$this->Vehicle->insertregistration($data);
				}
			$data = array(
				'job_card_number' => $job_card_number,
				'job_card_date' => date('y-m-d', strtotime($this->input->post('job_date'))),
				'client_id' => $this->input->post('client_id'),
				'divisionid' => $division_id,
				'created_user_id' => $this->session->userdata('user_id'),
				'reg_no' =>  $this->input->post('reg_no'),
				'make' =>  $this->input->post('make'),
				'model' =>  $this->input->post('model'),
				'car_year' =>  $this->input->post('car_year'),
				'car_color' =>  $this->input->post('car_color'),
				'contact_id' => $this->input->post('contact_id'),
				'contact_name' => $contact_name,
				'contact_num' =>  $this->input->post('contact_num'),
				'km_in' =>  $this->input->post('km_in'),
				'next_km' =>  $this->input->post('next_km'),
				'is_insurance' =>  $is_insurance,
				'salesman_id' =>  $this->input->post('advisor'),
				'job_card_status' =>  'Draft',
				'job_card_total' =>  $this->input->post('job_card_total'),
				'job_card_vat_perc' =>  10,
				'job_card_vat_amount' =>  $this->input->post('jbcdvat_amount'),
				'job_card_amount_with_vat' =>  $this->input->post('job_card_amount_with_vat'),
			);
			$res = $this->crud_model->insert('job_card',$data);
			$insert_id = $this->db->insert_id();
			if($res != ''){
				$item_id = $this->input->post('item_id');
				$furniture_model = $this->input->post('item');
				$furniture_description =$this->input->post('desc');
				$vat_perce =($this->input->post('item_vat') !='' ?  $this->input->post('item_vat') : 10);
				$vat_amount =$this->input->post('item_vat_amount');
				$item_discount =$this->input->post('item_discount');
				$net_amount =$this->input->post('item_net_amount');
				$section_id =$this->input->post('section_id');
				$technician_id =$this->input->post('technician_id');
				$furniture_quantity =$this->input->post('item_qty');
				$furniture_unitprice =$this->input->post('item_rate');
				$furniture_amount =$this->input->post('item_amount');
				$sl = 1;
				if(!empty($item_id)){	
					for($i = 0; $i < count($item_id);$i++ ){
						$data  = array(
							'job_card_id' => $insert_id,
							'sl_no' => $sl++,
							'item_id' => $item_id[$i],
							'furniture_model' =>$furniture_model[$i],
							'furniture_description' =>$furniture_description[$i],
							'furniture_unitprice' =>$furniture_unitprice[$i],
							'furniture_quantity' =>$furniture_quantity[$i],
							'furniture_amount' =>$furniture_amount[$i],
							'vat_perce' =>$vat_perce[$i],
							'vat_amount' =>$vat_amount[$i],
							'item_discount' =>$item_discount[$i],
							'net_amount' =>$net_amount[$i],
							'jb_type' =>1,
							'section_id' =>$section_id[$i],
							'technician_id' =>$technician_id[$i],
						);
						$this->Vehicle->insertjobcarddetail($data);
					}
				}

				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'=>'Vehicle Job Card',	
					'masters_id'=>$insert_id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'create',	
				);
				$this->crud_model->insert('log_for_masters',$data);
				$this->session->set_flashdata('success', 'Job Card Created');
				$cookie_division_val = array(
					'name'   => 'division_val_id',
					'value'  => $this->input->post('division_id'),
					'expire' => 60*60*24*60
				);
				$this->input->set_cookie($cookie_division_val);
				
			}
			else{
					$this->session->set_flashdata('response', 'Something WentWrong');
					 
					redirect('jobcard/Vehicle_jobcard/create_jobcard');
					 
				}
			redirect('jobcard/Vehicle_jobcard/editVjobcard/'.$insert_id.'');
		}
	}

	

	public function add_contact( ) {
		//if($Contact_Id!='' && $Client_Id!=''){
			$Client_Id  	   = $this->input->post('client_contact_id');
			$client_Contact_Name  	   = $this->input->post('client_Contact_Name');
			$client_Contact_Tel  	   = $this->input->post('client_Contact_Tel');
			$client_Contact_designation= $this->input->post('client_Contact_designation');
			$client_Contact_Email  	   = $this->input->post('client_Contact_Email');
			$client_Contact_Address    = $this->input->post('client_Contact_Address');
			$msg = array('message' => '', 'html' => '');
			if($client_Contact_Name!==''){
				if($client_Contact_Tel!==''){
					$data=array(
						'Client_Id'   => $Client_Id,
						'Contact_Name'   => $client_Contact_Name,
						'Contact_Tel' 	 =>	$client_Contact_Tel,
						'designation' 	 =>	$client_Contact_designation,
						'Contact_Email'  =>	$client_Contact_Email,
						'Contact_Address'=>	$client_Contact_Address,
						'Creation_date' =>  date("Y-m-d H:i:s"),
					);
					$records=$this->crud_model->insert('client_contact',$data);

					$get_contact = $this->Vehicle->get_ContactDetails($Client_Id); 
					$html= '';
					if(!empty($get_contact)){
						$html  = "<option value=''>Select Contact Person</option>";
						foreach($get_contact AS $rec){
							$html .= "<option data-cnt-id='".$rec['Contact_Id']."' value='".$rec['Contact_Name']." - ".$rec['Contact_Id']."'>".$rec['Contact_Name']."</option>";
						}
					}
					else{
						$html = "<option value=''>No Data Found</option>";
					}
					$msg['html'] = $html;
					$msg['message'] = 'success';					 				
 
				} else {
					$msg['message'] = 'error';					 	
 
				}
			} else {
				$msg['message']  = 'error';
				
			}
			echo json_encode($msg);
		 
	}


	public function editVjobcard($id = ''){
		$this->users_model->permission("Job_card", "Edit");
		$title['headerTitle']="Update Vehicle Job Card";
		$this->load->view('templates/header',$title);
		$data['make']  = $this->Vehicle->getMake();	
		$data['customer'] = $this->Vehicle->getCustomer();	
		$data['staff']    = $this->Vehicle->getServiceStaff();
		$data['advisor']  = $this->Vehicle->getAdvisorStaff();
		$data['vjobcard'] = $this->Vehicle->getVjobcard_detail($id);
		$data['model']    = $this->Vehicle->getregisterModel($data['vjobcard']->model);
		$data['staff']    = $this->Vehicle->getServiceStaff();
		$data['vjobcard_detail'] = $this->Vehicle->getVjobcard_desc($id);
		$Client_Id = $data['vjobcard']->client_id;
		$data['ContactDetails'] = $this->Vehicle->get_ContactDetails($Client_Id);
		$this->load->view('furniture/quotations/jobcard/edit_Vjobcard',$data);
		$this->load->view('templates/footer');
	}
	public function edit(){		
		 
		$this->users_model->permission("Job_card", "Edit");
		$job_card_id = $this->input->post('job_card_id');
		$reg_no_id   = $this->input->post('reg_no_id');
		$dbdata = $this->Vehicle->dataRow($reg_no_id);
		$config = array(		 
			// array(
            //         'field' => 'make',
            //         'label' => 'Make',
            //         'rules' => 'rtrim|required',
            //         'errors' => array(
            //             'required'      => 'Please Select %s.'
            //         )
            // ),
			// array(
            //         'field' => 'model',
            //         'label' => 'Model',
            //         'rules' => 'trim|required',
            //         'errors' => array(
            //             'required'      => 'Please Select %s.'
            //         )
			// ),
		  array(
			'field' => 'client',
			'label' => 'Customer Name',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please Enter %s.'
			)
	   		),array(
			'field' => 'contact_name',
			'label' => 'Contact Name',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please Enter %s.'
			)
	   		),array(
			'field' => 'contact_num',
			'label' => 'Contact Number',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please Enter %s.'
			)
	   		),array(
			'field' => 'km_in',
			'label' => 'Kilometer IN',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please Enter %s.'
			)
	   		),array(
			'field' => 'job_card_number',
			'label' => 'Job Number',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please select a division to add %s.'
			)
	   		),array(
			'field' => 'job_date',
			'label' => 'Date',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => 'Please select %s.'
			)
	   		),//array(
			// 'field' => 'advisor',
			// 'label' => 'Advisor',
			// 'rules' => 'trim|required',
			// 'errors' => array(
			// 	'required'      => 'Please select %s.'
			// )
	   		// ),array(
			// 'field' => 'item[]',
			// 'label' => 'Labour Charges',
			// 'rules' => 'trim|required',
			// 'errors' => array(
			// 	'required'      => 'Please Add %s For Create Job Card.'
			// )
	   		// ),
		);	
	
		if($this->input->post('reg_val') == 2 || empty($this->input->post('reg_val'))){
			$config[] = array(
				'field' => 'reg_no',
				'label' => 'Registration Number',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.',
				)
			);
			 
				
		}
		if($this->input->post('reg_val') == 0  ){
			if($reg_no_id != '')
			{
				$config[] = array(
					'field' => 'reg_no',
					'label' => 'This Registration Number',
					'rules' => 'trim|is_unique[reg_no_table.reg_no]',
					'errors' => array(
						'is_unique'      => '%s  is Already Exists..'
					)
				);
			}
			else{
				$config[] = array(
					'field' => 'reg_no',
					'label' => 'Registration Number',
					'rules' => 'trim|required',
					'errors' => array(
						'required'      => 'Please Enter %s.',
					)
				);
			}
				$config[] = array(
					'field' => 'chassi_number',
					'label' => 'Chassi Number',
					'rules' => 'trim|is_unique[reg_no_table.chassi_number]',
					'errors' => array(
						'is_unique'      => '%s already exists.'
					)
				); 
				
		}
        $this->form_validation->set_rules($config);
		if ($this->form_validation->run() == FALSE){
			
			$data['reg_no']   =  set_value('reg_no');
			$data['make']     =  set_value('make');
			$data['model']    =  set_value('model');			
			$data['chassi_number']  =  set_value('chassi_number');
			$data['client']   =  set_value('client');
			$data['contact_name']  =  set_value('contact_name');
			$data['km_in']  =  set_value('km_in');
			$data['job_card_number']  =  set_value('job_card_number');
			$data['job_date']   =  set_value('job_date');
			$data['advisor']    =  set_value('advisor');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			
			$title['headerTitle']="Update Vehicle Job Card";
			$this->load->view('templates/header',$title);
			$data['make']  = $this->Vehicle->getMake();	
			$data['customer']  = $this->Vehicle->getCustomer();	
			$data['staff']  = $this->Vehicle->getServiceStaff();
			$data['advisor']  = $this->Vehicle->getAdvisorStaff();
			$data['vjobcard'] = $this->Vehicle->getVjobcard_detail($job_card_id);
			$data['model']  = $this->Vehicle->getregisterModel($data['vjobcard']->model);
			$data['staff']    = $this->Vehicle->getServiceStaff();
			$data['vjobcard_detail'] = $this->Vehicle->getVjobcard_desc($job_card_id);
			$Client_Id = $data['vjobcard']->client_id;
			$data['ContactDetails'] = $this->Vehicle->get_ContactDetails($Client_Id );
			redirect('jobcard/Vehicle_jobcard/editVjobcard/'.$job_card_id.'');
		}
		else{

			$is_insurance = $this->input->post('is_insurance') !='' || $this->input->post('is_insurance') == 1 ? 1 : 0;
			if($this->input->post('reg_val') == 0 ){
				$data = array(
					'reg_no'	 =>	$this->input->post('reg_no'),
					'make_id' => $this->input->post('make'),
					'model_id' => $this->input->post('model'),
					'client_id' => $this->input->post('client_id'),				 
					'car_year' => $this->input->post('car_year'),
					'car_color' => $this->input->post('car_color'),
					'chassi_number' => $this->input->post('chassi_number'),
				);
			 $this->Vehicle->insertregistration($data);
			}


				$data = array(
					'job_card_date' => date('y-m-d', strtotime($this->input->post('job_date'))),
					//'client_id' => $this->input->post('client_id'),
					'created_user_id' => $this->session->userdata('user_id'),
					//'reg_no' =>  $this->input->post('reg_no'),
					//'make' =>  $this->input->post('make'),
					//'model' =>  $this->input->post('model'),
					//'car_year' =>  $this->input->post('car_year'),00122569
					//'car_color' =>  $this->input->post('car_color'),1233
					'contact_id' => $this->input->post('contact_id'),
					'contact_name' =>  $this->input->post('contact_name'),
					'contact_num' =>  $this->input->post('contact_num'),
					'km_in' =>  $this->input->post('km_in'),
					'next_km' =>  $this->input->post('next_km'),
					'is_insurance' =>  $is_insurance,
					'salesman_id' =>  $this->input->post('advisor'),
					'job_card_status' =>  'Draft',
					'job_card_total' =>  $this->input->post('job_card_total'),
					'job_card_vat_perc' =>  10,
					'job_card_vat_amount' =>  $this->input->post('jbcdvat_amount'),
					'job_card_amount_with_vat' =>  $this->input->post('job_card_amount_with_vat'),
				);
			     $where = array('id' => $job_card_id);
			    $this->crud_model->update('job_card',$data,$where);		 
				$where2 = array('job_card_id' => $job_card_id);
			    $this->crud_model->delete('job_card_details',$where2);
				$item_id = $this->input->post('item_id');
				$furniture_model = $this->input->post('item');
				$furniture_description =$this->input->post('desc');
				$vat_perce =($this->input->post('item_vat') !='' ?  $this->input->post('item_vat') : 10);
				$vat_amount =$this->input->post('item_vat_amount');
				$item_discount =$this->input->post('item_discount');
				$net_amount =$this->input->post('item_net_amount');
				$section_id =$this->input->post('section_id');
				$technician_id =$this->input->post('technician_id');
				$furniture_quantity =$this->input->post('item_qty');
				$furniture_unitprice =$this->input->post('item_rate');
				$furniture_amount =$this->input->post('item_amount');
				$job_card_details_id = $this->input->post('job_card_details_id');
				$sl = 1;
				if(!empty($item_id)){	
					for($i = 0; $i < count($item_id);$i++ ){
						
						$dataValues  = array(
							'job_card_id' => $job_card_id,
							'sl_no' => $sl++,
							'job_card_details_id'=>$job_card_details_id[$i],
							'item_id' => $item_id[$i],
							'furniture_model' =>$furniture_model[$i],
							'furniture_description' =>$furniture_description[$i],
							'furniture_unitprice' =>$furniture_unitprice[$i],
							'furniture_quantity' =>$furniture_quantity[$i],
							'furniture_amount' =>$furniture_amount[$i],
							'vat_perce' =>$vat_perce[$i],
							'vat_amount' =>$vat_amount[$i],
							'item_discount' =>$item_discount[$i],
							'net_amount' =>$net_amount[$i],
							'jb_type' =>1,
							'section_id' =>$section_id[$i],
							'technician_id' =>$technician_id[$i],
						);
						$this->Vehicle->UpdateJobdetails($dataValues);
					}
				}		
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'=>'Vehicle Job Card',	
					'masters_id'=>$job_card_id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'update',	
				);
				$this->crud_model->insert('log_for_masters',$data);
				$this->session->set_flashdata('success', 'Job Card Updated');
		
			redirect('jobcard/Vehicle_jobcard/editVjobcard/'.$job_card_id.'');
		}	
	}
	public function insurance($id = ''){
		$this->users_model->permission("Job_card", "Edit");
		$title['headerTitle']="Update Vehicle Job Card";
		$where=array(
			'id' => $id
		);
		$records=$this->crud_model->get('job_card',$where); 
		if($records != false){
		 
			$config = array(		 
			array(
				'field' => 'client',
				'label' => 'Insurer Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
				),array(
				'field' => 'lpono',
				'label' => 'LPO Number',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
				),array(
				'field' => 'lpo_date',
				'label' => 'LPO Date',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Add %s.'
				)
				),array(
				'field' => 'claim_no',
				'label' => 'Claim Number',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
				),array(
				'field' => 'claim_amount',
				'label' => 'Claim Amount',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
				)
			);	
	
		    $this->form_validation->set_rules($config);
			if ($this->form_validation->run() == FALSE){
				$data['customer']  = $this->Vehicle->getnewCustomer();
				$data['lpono']		 = $records[0]['lpono'];
				$data['insurer_id']		 = $records[0]['insurer_id'];
				$data['lpo_date']		 = $records[0]['lpo_date'];
				$data['claim_no']		 = $records[0]['claim_no'];
				$data['claim_amount']		 = $records[0]['claim_amount']; 
				$data['id'] = $id;
				$this->load->view('templates/header',$title);
				$this->load->view('furniture/quotations/jobcard/is_insurance',$data);
				$this->load->view('templates/footer'); 
			}
			else{

				$data = array(
					
					'lpono' => $this->input->post('lpono'),
					'insurer_id' => $this->input->post('insurer_id'),
					'lpo_date' => date('y-m-d', strtotime($this->input->post('lpo_date'))),
					'created_user_id' => $this->session->userdata('user_id'),
					'claim_no' =>  $this->input->post('claim_no'),
					'claim_amount' =>  $this->input->post('claim_amount'),
				);
				$where = array('id' => $id);
				$this->crud_model->update('job_card',$data,$where);	
				if ($this->db->trans_status() === FALSE) {
					$this->db->trans_rollback();
					redirect("jobcard/Vehicle_jobcard");
				}
				else {
					$this->db->trans_commit();
				    $this->session->set_flashdata('success', 'Insurer Detailes Updated');
			    	redirect('jobcard/Vehicle_jobcard/insurance/'.$id.'');
				}

			}
	    }
	}

	public function customerComplaints($id = '') {
		$this->users_model->permission("Job_card", "Edit");
		$title['headerTitle']="Update Vehicle Job Card";
		$where=array(
			'id' => $id
		);
		$records=$this->crud_model->get('job_card',$where); 

		if($records != false){
			 
			$this->form_validation->set_rules('customer_complaints', 'Customer Complaints', 'required');
			
			if ($this->form_validation->run() == FALSE){ 
				$data['customer_complaints']		 = $records[0]['customer_complaints'];
				$data['service_advisor_meassages']	 = $records[0]['service_advisor_meassages'];
				$data['id'] = $id;

				$this->load->view('templates/header',$title);
				$this->load->view('furniture/quotations/jobcard/customer_complaints',$data);
				$this->load->view('templates/footer'); 
			} else{
				
					$user_id	=	$this->session->userdata('user_id');
					
					
					$data = array(
						'customer_complaints' => htmlentities($this->input->post('customer_complaints')),
						'service_advisor_meassages' =>  htmlentities($this->input->post('service_advisor_meassages'))
					);
					$this->db->trans_begin();
					$where = array('id' => $id);
			     	$this->crud_model->update('job_card',$data,$where);	
										
					if ($this->db->trans_status() === FALSE) {
						$this->db->trans_rollback();
						redirect("JobCard/listJobCard");
					} else {
						$this->db->trans_commit();
					$this->session->set_flashdata('success', 'Customer Complaints Added Successfully');
					redirect('jobcard/Vehicle_jobcard/customerComplaints/'.$id.'');
				}
			}
		}
       	
	}
	public function inventoryDetails($id = '') {
		$this->users_model->permission("Job_card", "Edit");
		$title['headerTitle']="Update Vehicle Job Card";
		$where=array(
			'id' => $id
		);
		$records=$this->crud_model->get('job_card',$where); 

		if($records != false){
			 
			$this->form_validation->set_rules('inventory_detail', 'Customer inventory_detail', 'required');
			
			if ($this->form_validation->run() == FALSE){ 
				$data['inventory_detail']		 = $records[0]['inventory_detail'];

				$data['id'] = $id;

				$this->load->view('templates/header',$title);
				$this->load->view('furniture/quotations/jobcard/v_inventory_detail',$data);
				$this->load->view('templates/footer'); 
			} else{
				
					$user_id	=	$this->session->userdata('user_id');
					
					
					$data = array(
						'inventory_detail' => htmlentities($this->input->post('inventory_detail')),
					);
						 
					$this->db->trans_begin();
					$where = array('id' => $id);
			     	$this->crud_model->update('job_card',$data,$where);	
										
					if ($this->db->trans_status() === FALSE) {
						$this->db->trans_rollback();
						redirect("JobCard/listJobCard");
					} else {
						$this->db->trans_commit();
					$this->session->set_flashdata('success', 'Inventory Details Added Successfully');
					redirect('jobcard/Vehicle_jobcard/inventoryDetails/'.$id.'');
				}
			}
		}
       	
	}

	public function do_draft($id = '',$division_id = ''){
	 
		$this->users_model->permission("Quotation", "Add");
		$this->db->trans_begin();
	    //$id  = $this->input->post('id');
		//$division_id = $this->input->post('division');
		$query_data= $this->db->query("SELECT * FROM `furniture_quotation` WHERE `job_card_id`='$id' limit 1");
		if ($query_data->num_rows()==0){
			$user_id	=	$this->session->userdata('user_id');
			$dbdata = $this->Vehicle->jobCardRow($id);
			// $division=$dbdata->division_id;
			$SQL = "SELECT MAX(quotation_number)+1 as `new_quotation_number` FROM furniture_quotation WHERE `quotation_divisionid`='$division_id';";
			$result = $this->db->query($SQL);
			$data = $result->result_array();
			if($data[0]['new_quotation_number'] != NULL and $data[0]['new_quotation_number'] != ""){
				$quotation_number= $data[0]['new_quotation_number'];
			} else{
				$quotation_number = 10001;
			}
			$query= $this->db->query("SELECT * FROM  `company_division` WHERE division_id='$division_id' and status='1'");
			$division_code=$query->row()->division_code;
			//$division_dbdata = $this->EnquiryModel->company_division($division);
			$qtnmr=$division_code.'-'.$quotation_number;

			if($dbdata->tax_perce==0){
				$vat_percentage=0;
			} else {
				$date=date("Y-m-d");
				$query2= $this->db->query("SELECT * FROM `vat_applicable` WHERE `applicable_date` in (SELECT max(applicable_date) FROM `vat_applicable` where `applicable_date`<'$date') order by `vat_percentage` DESC");
				$vat_percentage=$query2->row()->vat_percentage;
			}
			
			$data = array(
				'quotation_number' 			=> $quotation_number,
				'quotation_number_full' 	=> $qtnmr.'-0',
				'quotation_revisionnumber' 	=> 0,
				'quotation_date'   			=> date("Y-m-d"),
				'quotation_divisionid'    	=> $division_id,
				'client_id'    				=> $dbdata->client_id,
				'contact_id'    			=> $dbdata->contact_id,
				'quotation_vat_percentage'  => $vat_percentage,
				'quotation_vat_amount'  	=> 0,
				'quotation_amount_with_vat'  => 0,
				'quotation_status'    		=> 'Draft',
				'job_card_id'    			=> $id,
				'quotation_type'    		=> 3,
				'salesman_id'  				=> $dbdata->salesman_id,
				'status'  					=> 3
			);
			 
			$this->crud_model->insert('furniture_quotation', $data);
			$insert_id = $this->db->insert_id();		
			$list='';
			$i=0;

			$job_data = array(
					'quotation_id' => $insert_id ,
					'qtn_no' => $qtnmr
			);
			$where_1 = array('id' => $id);
			$this->crud_model->update('job_card',$job_data,$where_1);

			$log_data=array(
				'trans_no'  =>  $qtnmr.'-0',
				'trans_type'  =>  'Quotation',
				'trans_op'  =>  'Create',
				'trans_user_id'  =>  $this->session->userdata('user_id')
			);
			$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);
			$log_for_quotationg_data=array(
				'trans_id'  	=>  $insert_id,
				'trans_type'  	=>  'Quotation',
				'trans_action'  =>  'Create',
				'flow_id'  		=>  3,
				'group_by'  	=>  1,
				'trans_user_id' =>  $this->session->userdata('user_id')
			);
			$log_for_transactions=$this->crud_model->insert('log_for_quotation',$log_for_quotationg_data);			
			/* $u_data = array(
				'quotation_number' => $qtnmr,
				'status' => 2
			);
			$this->db->where('id', $Enquiry_Id);
			$this->db->update('enquiry', $u_data); */
			
			if ($this->db->trans_status() === FALSE) {
                    $this->db->trans_rollback();
                    redirect("JobCard/listJobCard");
                } else {
                    $this->db->trans_commit();
                    $this->session->set_flashdata('success', 'Quotation Created Successfully');
                    $path	=	base_url()."index.php/furniture/furniture_quotation_client_project/index/".$insert_id;
					redirect($path);
             }
			
		} else {
			$this->db->trans_rollback();
			 $this->session->set_flashdata('response', 'Quotation Already created!!!');
			// //$path	=	base_url()."index.php/furniture/furniture_quotation_client_project/index/".$query_data->row()->id;
			// $path	=	base_url()."index.php/furniture/Enquiry/listEnquiry";
			// redirect($path);
			redirect('jobcard/Vehicle_jobcard/editVjobcard/'.$id.'');
		}		
	}

	public function document_attachments($job_no,$division_id) {
		$this->users_model->permission("Job_card", "Edit");
		$dbdata = $this->JobCardModel->dataRow($job_no,$division_id);		
		$this->form_validation->set_rules('job_no', 'Job No', 'required');
		
		if ($this->form_validation->run() == FALSE){ 
			$inventory_item=$this->JobCardModel->inventory_item();
			$vir_files =$this->JobCardModel->vir_files($job_no,$division_id);
			$datas   =   array("dbdata" => $dbdata,"vir_files"=>$vir_files);
			$this->load->view('header');
			$this->load->view('sidebar');
			$this->load->view('document_attachments',$datas);
			$this->load->view('footer');
		} else{
			
			/*$this->db->where('job_no', $job_no);
			$this->db->where('division_id', $division_id);
			$this->db->delete('vir_files');*/
					
			$this->load->library('upload');
			$files = $_FILES;
			$file_upload = $this->input->post('image');
			$file_upload2 = $this->input->post('image2');
	
			$config['upload_path'] = './images/job_documents/';
			$config['file_name'] = date("YmdHis").'-'.rand(100000, 999999);
			$config['allowed_types'] = '*';
			$config['max_size']= '0';
			$config['overwrite'] = TRUE;
			//ini_set("upload_max_filesize",40M);
			$this->load->library('upload', $config);
			$this->upload->initialize($config);
			
	
			if ($this->upload->do_upload('image')) {
				$ext = end(explode(".", $_FILES["image"]['name']));
				$datanew = array(
					'job_no' 	 => $job_no,
					'division_id'=> $division_id,
					'title'=> $this->input->post('ff_name'),
					'file_name'  => $config['file_name'].'.'.$ext
				);
				$added = $this->db->insert('vir_files',$datanew);
			} else {
				$this->session->set_flashdata('response', $this->upload->display_errors());
				redirect("JobCard/document_attachments/".$job_no."/".$division_id);
			}
			
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				redirect("JobCard/listJobCard");
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'Attachment Added Successfully');
				redirect("JobCard/document_attachments/".$job_no."/".$division_id);
			}
		}		   
	}
	

	
}