<?php
class Category extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
		$this->load->model('Vehicle');
	}
	function index($name='NIL',$page=1)	{
		$this->users_model->permission("Category", "View");
		$title['headerTitle']="Stock Category List";
		$where=array();
		$like=array();
		if (@$this->input->post('name')) {
			$name =   $this->input->post("name");
		} elseif ($name != "NIL") {
			$name	=	$name;
		} else {
			$name	= "NIL";
		}
		if($name != "NIL") {
			$like = array('category_name'=>$name);
		}
		$config['per_page']		= 100;
		$config['base_url'] 	= site_url('masters/Category/index/'.$name.'/');
		$config['total_rows'] 	= $this->crud_model->get_count('main_category',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('main_category',array(),$config['per_page'],$offset,'id','desc',$like);
		
		
		
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('templates/header',$title);
		$this->load->view('masters/category/list',$data);
		$this->load->view('templates/footer');
	}
	function create() {
		$this->users_model->permission("Category", "Add");
		$title['headerTitle']="Stock Category Create";
		$data['section_master']  = $this->Vehicle->getsectionMaster();	
		$this->load->view('templates/header',$title);
		$this->load->view('masters/category/create',$data);
		$this->load->view('templates/footer');
	}
	function edit($id) {
		$this->users_model->permission("Category", "Edit");
		$title['headerTitle']="Stock Category Edit";
		$where=array(
				'id' => $id
		);
		$records=$this->crud_model->get('main_category',$where);
		if($records != false){
			//true section
			$data['category_name']	 = $records[0]['category_name'];
			$data['id']			     = $records[0]['id'];
			$data['status']			 = $records[0]['status'];
			$data['department_id']	 = $records[0]['department_id'];
			$data['section_master']  = $this->Vehicle->getsectionMaster();	
			$data['user_status'] = $this->config->item('user_status_array');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/category/edit',$data);
			$this->load->view('templates/footer');

		} else {
			//false section
			$this->session->set_flashdata('response','error');
			redirect('masters/Unit');
		}
	}
	function do_insert() {
		$this->users_model->permission("Category", "Add");
		$title['headerTitle']="Stock Category Create";
		$this->form_validation->set_rules('name', 'Name', 'required');
		$this->form_validation->set_rules('department_id', 'Department', 'required');
		
		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$data['section_master']  = $this->Vehicle->getsectionMaster();	
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/category/create',$data);
			$this->load->view('templates/footer');
		} else {	// true section

			$name=$this->input->post('name');
			$department_id=$this->input->post('department_id');
			
			$data=array('category_name' => $name,
						'department_id' =>$department_id
						);

			$rr=$this->crud_model->insert('main_category',$data);
			$insert_id = $this->db->insert_id();
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Inventory Category',	
				'masters_id'=>$insert_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'create',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			if($rr == false) {
				// error

				$this->session->set_flashdata('response','Stock Category cannot be inserted',':old:');
				$redirect('masters/Category');
			} else {
				// redirect
				$this->session->set_flashdata('success','Stock Category added successfully');
				redirect('masters/Category');

			}
		}

	}

	function do_update() {
		$this->users_model->permission("Category", "Edit");
		$title['headerTitle']="Stock Category Edit";
		$id = ascii_to_entities($this->input->post('id'));
		$status = ascii_to_entities($this->input->post('status'));
		$department_id = ascii_to_entities($this->input->post('department_id'));
		$file_error = "";
		$filename = "";
		$this->form_validation->set_rules('name', 'Name', 'required');
		$this->form_validation->set_rules('department_id', 'Department', 'required');
		
		

		if ($this->form_validation->run() == FALSE) {
			// false section
			$where=array("id"=>$id);
					
			$records=$this->crud_model->get('main_category', $where);
			if($records != false){
				//true section
				$data['category_name']	= $records[0]['category_name'];
				$data['id']			 	= $records[0]['id'];
				$data['department_id']	= $records[0]['department_id'];
				$data['status']			= $records[0]['status'];
				$data['user_status'] = $this->config->item('user_status_array');
				$data['section_master']  = $this->Vehicle->getsectionMaster();	
				$id = $records[0]['id'];
				$this->session->set_flashdata('response',''.validation_errors().'',':old:');
				// $this->load->view('templates/header',$title);
				// $this->load->view('masters/category/edit',$data);
				// $this->load->view('templates/footer');
				redirect('masters/category/edit/'.$id.'');

			} 
		} else {// true section

			$name=$this->input->post('name');
			//$currency_code =  $currency_code;
			
			

			$where=array(
				'id'  => $id
			);
			$data=array(
				'category_name' => $name,
				'department_id' => $department_id,
				'status' => $status
			);

			$records=$this->crud_model->update('main_category',$data,$where);
			
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Inventory Category',	
				'masters_id'=>$id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			$this->session->set_flashdata('success','Stock Category updated');
			redirect('masters/Category');

		}
	}
	function do_delete($unit_id=0) {
		$this->users_model->permission("Category", "Delete");
		$where=array(
			'unit_id'  => $unit_id
		);
		$data=array('status' => 0);
			
		$records=$this->crud_model->update('unit_master',$data,$where);
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Inventory Category',	
				'masters_id'=>$unit_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'create',	
			);
			$this->crud_model->insert('log_for_masters',$data);

		$this->session->set_flashdata('response','Stock Category deleted');
		redirect('masters/Category');
	}
}