<?php
class company_division extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
	}
	function index($page=1)	{
		$config['per_page']		= 5;
		$config['base_url'] 	= site_url('masters/company_division/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('company_division',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('company_division',array(),$config['per_page'],$offset);
		
		for($i=0; $i<sizeof($data['records']); $i++) {
			$div_code = $data['records'][$i]["division_id"];
			$where=array(
				'quotation_divisionid'=> $div_code
			);
			$search_quotations=$this->crud_model->get_view_furniture_quotations_client_project_users($where);
			if($search_quotations) {
				$data['records'][$i]["hide_flag"] = 1;
			}			
		}
		
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('templates/header');
		$this->load->view('masters/company_division/list',$data);
		$this->load->view('templates/footer');
	}
	function create() {
		$this->load->view('templates/header');
		$this->load->view('masters/company_division/create');
		$this->load->view('templates/footer');
	}
	function edit($id) {
		$where=array(
				'division_id' => $id
		);
		$records=$this->crud_model->get('company_division',$where);
		if($records != false){
			//true section
			$data['division_name']			 = $records[0]['division_name'];
			$data['division_code']			 = $records[0]['division_code'];
			$data['currency_name']			 = $records[0]['currency_name'];
			$data['currency_code']			 = $records[0]['currency_code'];
			$data['division_id']			 = $records[0]['division_id'];
			$data['logo_filename']			 = $records[0]['logo_filename'];
			$this->load->view('templates/header');
			$this->load->view('masters/company_division/edit',$data);
			$this->load->view('templates/footer');

		} else {
			//false section
			$this->session->set_flashdata('response','<div class="alert alert-error">error</div>');
			redirect('masters/company_division');
		}
	}
	function do_insert() {
	
		$currency_code = ascii_to_entities($this->input->post('currency_code'));
		$file_error = "";
		$filename = "";
		$this->form_validation->set_rules('division_name', 'Company Division Name', 'required|max_length[100]');
		$this->form_validation->set_rules('division_code', 'Division Code', 'required|max_length[3]');
		$this->form_validation->set_rules('currency_name', 'Currency Name', 'required|max_length[100]');
		$this->form_validation->set_rules('currency_code', 'Currency Code', 'required|max_length[10]');
		
		if($_FILES["logo_image"]["name"]!=""){
		$allowedExts = array("gif", "jpeg", "jpg", "png");
		$temp = explode(".", $_FILES["logo_image"]["name"]);
		$extension = end($temp);
		if ((($_FILES["logo_image"]["type"] == "image/gif")
		|| ($_FILES["logo_image"]["type"] == "image/jpeg")
		|| ($_FILES["logo_image"]["type"] == "image/jpg")
		|| ($_FILES["logo_image"]["type"] == "image/pjpeg")
		|| ($_FILES["logo_image"]["type"] == "image/x-png")
		|| ($_FILES["logo_image"]["type"] == "image/png"))
		&& ($_FILES["logo_image"]["size"] < 1000000)
		&& in_array($extension, $allowedExts)){
			if ($_FILES["logo_image"]["error"] > 0) {
				$file_error = "Invalid file1";
			}/*
		  else
			{
			echo "Upload: " . $_FILES["logo_image"]["name"] . "<br>";
			echo "Type: " . $_FILES["logo_image"]["type"] . "<br>";
			echo "Size: " . ($_FILES["logo_image"]["size"] / 1024) . " kB<br>";
			echo "Stored in: " . $_FILES["logo_image"]["tmp_name"];
			}*/
		  } else {
		  	$file_error = "Invalid file2";
		  }
		
	
		$path = FCPATH."images/company_division";
		$config['upload_path'] = $path;
		$config['allowed_types'] = 'gif|jpg|png|jpeg';
		//$config['max_size'] = '1000';
        //$config['max_width']  = '500';
        //$config['max_height']  = '500';
		
		
		
		$this->load->library('upload', $config);
		
		

		if ($this->upload->do_upload('logo_image')) {
			$up_data = array('upload_data' => $this->upload->data());
		} else {
			$file_error = "File upload error.3";
		}

		$filename = @$up_data["upload_data"]["file_name"];
		}

		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->load->view('templates/header');
			$this->load->view('masters/company_division/create');
			$this->load->view('templates/footer');
		} else {	// true section

			$division_name=$this->input->post('division_name');
			$division_code=$this->input->post('division_code');
			$currency_name=$this->input->post('currency_name');
			//$currency_code =  $currency_code;
			
			$data=array('division_name' => $division_name,
						'division_code' => $division_code,
						'currency_name' => $currency_name,
						'currency_code' => $currency_code,
						'logo_filename' => $filename

			);

			$rr=$this->crud_model->insert('company_division',$data);

			if($rr == false) {
				// error

				$this->session->set_flashdata('response','<div class="alert alert-error">Division and Currency cannot be inserted</div>',':old:');
				$this->load->view('templates/header');
				$this->load->view('masters/company_division');
				$this->load->view('templates/footer');
			} else {
				// redirect
				$this->session->set_flashdata('response','<div class="alert alert-success">Company Division and Currency added successfully</div>');
				redirect('masters/company_division');

			}
		}

	}

	function do_update() {
		
		$currency_code = ascii_to_entities($this->input->post('currency_code'));
		$file_error = "";
		$filename = "";
		$this->form_validation->set_rules('division_name', 'Division Name', 'required|max_length[100]');
		$this->form_validation->set_rules('division_code', 'Division Code', 'required|max_length[3]');
		$this->form_validation->set_rules('currency_name', 'Currency Name', 'required|max_length[100]');
		$this->form_validation->set_rules('currency_code', 'Currency Code', 'required|max_length[10]');
		
		if($_FILES["logo_image"]["name"]!=""){
		$allowedExts = array("gif", "jpeg", "jpg", "png");
		$temp = explode(".", $_FILES["logo_image"]["name"]);
		$extension = end($temp);
		if ((($_FILES["logo_image"]["type"] == "image/gif")
		|| ($_FILES["logo_image"]["type"] == "image/jpeg")
		|| ($_FILES["logo_image"]["type"] == "image/jpg")
		|| ($_FILES["logo_image"]["type"] == "image/pjpeg")
		|| ($_FILES["logo_image"]["type"] == "image/x-png")
		|| ($_FILES["logo_image"]["type"] == "image/png"))
		&& ($_FILES["logo_image"]["size"] < 1000000)
		&& in_array($extension, $allowedExts)){
			if ($_FILES["logo_image"]["error"] > 0) {
				$file_error = "Invalid file1";
			}/*
		  else
			{
			echo "Upload: " . $_FILES["logo_image"]["name"] . "<br>";
			echo "Type: " . $_FILES["logo_image"]["type"] . "<br>";
			echo "Size: " . ($_FILES["logo_image"]["size"] / 1024) . " kB<br>";
			echo "Stored in: " . $_FILES["logo_image"]["tmp_name"];
			}*/
		  } else {
		  	$file_error = "Invalid file2";
		  }
		
	
		$path = FCPATH."images/company_division";
		$config['upload_path'] = $path;
		$config['allowed_types'] = 'gif|jpg|png|jpeg';
		//$config['max_size'] = '1000';
        //$config['max_width']  = '500';
        //$config['max_height']  = '500';
		
		
		
		$this->load->library('upload', $config);
		
		

		if ($this->upload->do_upload('logo_image')) {
			$up_data = array('upload_data' => $this->upload->data());
		} else {
			$file_error = "File upload error.3";
		}

		$filename = $up_data["upload_data"]["file_name"];
		}else{
			$filename = $this->input->post('image_item');
		}

		if ($this->form_validation->run() == FALSE) {
			// false section
			$division_id = $this->input->post('division_id');
			$where=array("division_id"=>$division_id);
					
			$records=$this->crud_model->get('company_division', $where);
			if($records != false){
				//true section
				$data['division_name'] = $records[0]['division_name'];
				$data['division_code'] = $records[0]['division_code'];
				$data['currency_name'] = $records[0]['currency_name'];
				$data['currency_code'] = $records[0]['currency_code'];
				$data['division_id']   = $records[0]['division_id'];
				$data['logo_filename'] = $records[0]['logo_filename'];
				$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
				$this->load->view('templates/header');
				$this->load->view('masters/company_division/edit',$data);
				$this->load->view('templates/footer');

			} else {
				//false section
				$this->session->set_flashdata('response','<div class="alert alert-error">error</div>');
				redirect('masters/company_division');
			}
		} else {// true section

			$division_name =  $this->input->post('division_name');
			$division_code =  $this->input->post('division_code');
			$currency_name =  $this->input->post('currency_name');
			//$currency_code =  $currency_code;
			$division_id   =  $this->input->post('division_id');

			$where=array(
				'division_id'  => $division_id
			);
			$data=array(
				'division_name' =>$division_name,
				'division_code' =>$division_code,
				'currency_name' =>$currency_name,
				'currency_code' =>$currency_code,
				'logo_filename' => $filename
			);

			$records=$this->crud_model->update('company_division',$data,$where);

			$this->session->set_flashdata('response','<div class="alert alert-success">Company division updated</div>');
			redirect('masters/company_division');

		}
	}
	function do_delete($id=0) {

		$where=array(
			'quotation_divisionid'=> $id
		);
		
		$records=$this->crud_model->get('view_furniture_quotations_client_project_users', $where);
		
		if(!$records) {
			$where=array(
				'division_id'=> $id
			);
			$this->crud_model->delete('company_division',$where);
			$this->session->set_flashdata('response','<div class="alert alert-success">Company division deleted</div>');
			redirect('masters/company_division');
		} else {
			$this->session->set_flashdata('response','<div class="alert alert-error">Sorry. You cannot delete a division that is used in the existing quotations.</div>');
			redirect('masters/company_division');
		}
	}
}