<?php
class item_category extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
	}
	function index($page=1)	{
		$config['per_page']		= 5;
		$config['base_url'] 	= site_url('masters/item_category/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('sub_category',array());

		$offset = ($page-1) * $config['per_page'];

		$this->db->select('*');
		$this->db->from('sub_category');
		$this->db->join('main_category', 'main_category.id = sub_category.main_category','right');
		$query = $this->db->get();
		
		$data['records'] = $query->result_array();
		
		for($i=0; $i<sizeof($data['records']); $i++) {
			$main_category_id = $data['records'][$i]["id"];
			$where=array(
				'main_category'=> $main_category_id
			);
			$search_sub_category=$this->crud_model->get('sub_category',$where);
			if($search_sub_category) {
				$data['records'][$i]["hide_flag"] = 1;
			}			
		}
		
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		
		$this->load->view('templates/header');
		$this->load->view('masters/item_category/list_category',$data);
		$this->load->view('templates/footer');
	}
	function create() {
		$list = $this->crud_model->get_list('id','category_name','main_category',array('select'=>' - Select - '));
		$data['category_list'] = $list;
		
		$this->load->view('templates/header');
		$this->load->view('masters/item_category/create_category',$data);
		$this->load->view('templates/footer');
	}
	function edit($id) {
		$where=array(
				'id' => $id
		);
		
		$this->db->select('*');
		$this->db->from('sub_category');
		$this->db->where('sub_id', $id); 
		$query = $this->db->get();
		
		$records=$query->result_array();
		$list = $this->crud_model->get_list('id','category_name','main_category');
		$data['category_list'] = $list;
		
		if($records != false){
			$data['main_category']			 = $records[0]['main_category'];
			$data['main_category_id']		 = $records[0]['sub_id'];
			$data['sub_category']			 = $records[0]['sub_category_name'];
		
			$this->load->view('templates/header');
			$this->load->view('masters/item_category/edit_category',$data);
			$this->load->view('templates/footer');
		} else {
			//false section
			$this->session->set_flashdata('response','<div class="alert alert-error">Error</div>');
			redirect('masters/item_category');
		}
	}
	function edit_main($id) {
		$where=array(
				'id' => $id
		);
		
		$this->db->select('*');
		$this->db->from('main_category');
		$this->db->where('id', $id); 
		$query = $this->db->get();
		
		$records=$query->result_array();
		
		if($records != false){
			$data['main_category_id']		 = $records[0]['id'];
			$data['sub_category']			 = $records[0]['category_name'];
		
			$this->load->view('templates/header');
			$this->load->view('masters/item_category/edit_main_category',$data);
			$this->load->view('templates/footer');
		} else {
			//false section
			$this->session->set_flashdata('response','<div class="alert alert-error">Error</div>');
			redirect('masters/item_category');
		}
	}
	function do_insert() {
	
		$currency_code = ascii_to_entities($this->input->post('currency_code'));
	
		//$this->form_validation->set_rules('division_name', 'Company Division Name', 'required|max_length[100]');
		//$this->form_validation->set_rules('division_code', 'Division Code', 'required|max_length[3]');
		//$this->form_validation->set_rules('currency_name', 'Currency Name', 'required|max_length[100]');
		//$this->form_validation->set_rules('currency_code', 'Currency Code', 'required|max_length[10]');

		if ($this->input->post('category')=="")
		{
			// false section
			$this->session->set_flashdata('response','<div class="alert alert-error">category is required</div>',':old:');
			$list = $this->crud_model->get_list('id','category_name','main_category',array('select'=>' - Select - '));
			$data['category_list'] = $list;
			$this->load->view('templates/header');
			$this->load->view('masters/item_category/create_category',$data);
			$this->load->view('templates/footer');
		} else {	// true section

			if(($this->input->post('textfield2')=="" || $this->input->post('textfield2')=="select") && $this->input->post('category')!=""){
				$data=array('category_name' => $this->input->post('category')
				);

				$rr=$this->crud_model->insert('main_category',$data);
			}else{
				$data=array('main_category' => $this->input->post('textfield2'),
							'sub_category_name' => $this->input->post('category')
				);

				$rr=$this->crud_model->insert('sub_category',$data);
			}
			
			if($rr == false) {
				// error

				$this->session->set_flashdata('response','<div class="alert alert-error">Category cannot be inserted</div>',':old:');
				$this->load->view('templates/header');
				$this->load->view('masters/item_category');
				$this->load->view('templates/footer');
			} else {
				// redirect
				$this->session->set_flashdata('response','<div class="alert alert-success">Category added successfully</div>');
				redirect('masters/item_category');

			}
		}

	}

	function do_update() {
		
		$this->form_validation->set_rules('division_code', 'Sub Category', 'required');

		if ($this->form_validation->run() == FALSE) {
			// false section
			$item_id = $this->input->post('main_category_id');
			$where=array("sub_id"=>$item_id);
					
			$records=$this->crud_model->get('sub_category', $where);
			if($records != false){
				//true section
				$data['main_category']			 = $records[0]['main_category'];
				$data['main_category_id']		 = $records[0]['sub_id'];
				$data['sub_category']			 = $records[0]['sub_category_name'];
				
				$list = $this->crud_model->get_list('id','category_name','main_category');
				$data['category_list'] = $list;
			
				$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
				$this->load->view('templates/header');
				$this->load->view('masters/item_category/edit_category',$data);
				$this->load->view('templates/footer');

			} else {
				//false section
				$this->session->set_flashdata('response','<div class="alert alert-error">error</div>');
				redirect('masters/item_category');
			}
		} else {// true section

			$where=array(
				'sub_id'  => $this->input->post('main_category_id')
			);
			$data=array('main_category' => $this->input->post('textfield2'),
							'sub_category_name' => $this->input->post('division_code')
				);

			$records=$this->crud_model->update('sub_category',$data,$where);

			$this->session->set_flashdata('response','<div class="alert alert-success">Category updated</div>');
			redirect('masters/item_category');

		}
	}
	function do_main_update() {
		
		$this->form_validation->set_rules('division_code', 'Main Category', 'required');

		if ($this->form_validation->run() == FALSE) {
			// false section
			$item_id = $this->input->post('main_category_id');
			$where=array("id"=>$item_id);
					
			$records=$this->crud_model->get('main_category', $where);
			if($records != false){
				//true section
				$data['main_category_id']		 = $records[0]['id'];
				$data['sub_category']			 = $records[0]['category_name'];
				
				$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
				$this->load->view('templates/header');
				$this->load->view('masters/item_category/edit_main_category',$data);
				$this->load->view('templates/footer');

			} else {
				//false section
				$this->session->set_flashdata('response','<div class="alert alert-error">error</div>');
				redirect('masters/item_category');
			}
		} else {// true section

			$where=array(
				'id'  => $this->input->post('main_category_id')
			);
			$data=array('category_name' => $this->input->post('division_code')
				);

			$records=$this->crud_model->update('main_category',$data,$where);

			$this->session->set_flashdata('response','<div class="alert alert-success">Category updated</div>');
			redirect('masters/item_category');

		}
	}
	function do_delete($id=0) {

		$where=array(
			'main_category'=> $id
		);
		
		$records=$this->crud_model->get('items', $where);
		
		if(!$records) {
			$where=array(
				'id'=> $id
			);
			$this->crud_model->delete('main_category',$where);
			$this->session->set_flashdata('response','<div class="alert alert-success">Category deleted</div>');
			redirect('masters/item_category');
		} else {
			$this->session->set_flashdata('response','<div class="alert alert-error">Sorry. You cannot delete a category that is used in the item creation.</div>');
			redirect('masters/item_category');
		}
	}
}