<?php
class Payhead extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
	}
	function index($page=1)	{
		$this->users_model->permission("PayHead","View");
		$title['headerTitle']="Pay head List";
		$config['per_page']		= 100;
		$config['base_url'] 	= site_url('masters/Payhead/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('pay_head',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('pay_head',array(),$config['per_page'],$offset,'id','DESC');
		
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('templates/header',$title);
		$this->load->view('masters/payhead/list',$data);
		$this->load->view('templates/footer');
	}
	function create() {
		$this->users_model->permission("PayHead","Add");
		$title['headerTitle']="Pay head Create";
		$data['pay_unit_list'] = $this->crud_model->get_list2('id','pay_unit_name','pay_unit',array(''=>'- Select Pay Unit -'),array('status'=>1),'pay_unit_name','asc');
		$data['pay_head_list'] = $this->crud_model->get('pay_head',array('status' => 1));
		$data['pay_unit_records'] = $this->crud_model->get('pay_unit',array('status' => 1));
		$or_where = array('acoount_group_id' => 24);
		$data['payable_ledger_list'] = $this->crud_model->get_list2('ledger_code','ledger_name','ledgers',array(''=>'- Select Ledger -'),array('acoount_group_id'=>4),'ledger_name','asc');
		$data['accounts_ledger_list'] = $this->crud_model->get_list4('ledger_code','ledger_name','ledgers',array(''=>'- Select Ledger -'),array('acoount_group_id'=>24),$or_where,'ledger_name','asc');
		echo $this->db->last_query();
		$this->load->view('templates/header',$title);
		$this->load->view('masters/payhead/create',$data);
		$this->load->view('templates/footer');
	}
	function edit($id) {
		$this->users_model->permission("PayHead","Edit");
		$title['headerTitle']="Pay head Edit";
		$where=array(
			'id' => $id
		);
		$records=$this->crud_model->get('pay_head',$where);
		if($records != false){
			//true section
			$data['id']				= $records[0]['id'];
			$data['pay_head_name']	= $records[0]['pay_head_name'];
			$data['by_attendance']	= $records[0]['by_attendance'];
			$data['is_gosi']		= $records[0]['is_gosi'];
			$data['is_fixed']		= $records[0]['is_fixed'];
			$data['is_fixed_type']	= $records[0]['is_fixed_type'];
			$data['is_indemnity']	= $records[0]['is_indemnity'];
			$data['is_leave_salary']= $records[0]['is_leave_salary'];
			$data['is_loan']		= $records[0]['is_loan'];
			$data['is_ot_normal']	= $records[0]['is_ot_normal'];
			$data['is_ot_special']	= $records[0]['is_ot_special'];
			$data['status']			= $records[0]['status'];
			$data['pay_unit_id']	= $records[0]['pay_unit_id'];
			$data['pay_hash_unit']	= $records[0]['pay_unit'];
			$data['set_formula']	= $records[0]['set_formula'];
			$data['is_formula']		= $records[0]['is_formula'];
			$data['set_variable']		= $records[0]['set_variable'];
			$data['effect_net_salary']= $records[0]['effect_net_salary'];
			$data['is_payable']		= $records[0]['is_payable'];
			$data['payable_ledger'] = $records[0]['payable_ledger'];
			$data['accounts_ledger'] = $records[0]['accounts_ledger'];
			$data['pay_head_display_name']	= $records[0]['pay_head_display_name'];
			$data['user_status'] 	= $this->config->item('user_status_array');

			$data['pay_unit_list'] = $this->crud_model->get_list2('id','pay_unit_name','pay_unit',array(''=>'- Select Pay Unit -'),array('status'=>1),'pay_unit_name','asc');

			$data['pay_head_list'] = $this->crud_model->get('pay_head',array('id!=' => $id,'status' => 1));
			$data['pay_unit_records'] = $this->crud_model->get('pay_unit',array('status' => 1));
			$or_where = array('acoount_group_id' => 24);
			$data['payable_ledger_list'] = $this->crud_model->get_list2('ledger_code','ledger_name','ledgers',array(''=>'- Select Ledger -'),array('acoount_group_id'=>4),'ledger_name','asc');
			$data['accounts_ledger_list'] = $this->crud_model->get_list4('ledger_code','ledger_name','ledgers',array(''=>'- Select Ledger -'),array('acoount_group_id'=>24),$or_where,'ledger_name','asc');
		
			$this->load->view('templates/header',$title);
			$this->load->view('masters/payhead/edit',$data);
			$this->load->view('templates/footer');

		} else {
			//false section
			$this->session->set_flashdata('response','error');
			redirect('masters/Payhead');
		}
	}
	function do_insert() {
		$this->users_model->permission("PayHead","Add");
		$title['headerTitle']="Pay head Create";
		$this->form_validation->set_rules('pay_head_name', 'Name', 'required|is_unique[pay_head.pay_head_name]|trim');
		$this->form_validation->set_rules('pay_head_display_name', 'Name', 'required|trim');
		if($this->input->post('pay_head_type')==='By Attendance') {
			$this->form_validation->set_rules('pay_unit_id', 'Pay Unit', 'required');
			$this->form_validation->set_rules('pay_hash_unit', 'Pay Unit', 'required');
		}
		if($this->input->post('is_payable')!='') {
			$this->form_validation->set_rules('payable_ledger', 'Payable Ledger', 'required');
		} else {
			$this->form_validation->set_rules('accounts_ledger', 'Ledger', 'required');
		}
		if ($this->form_validation->run() == FALSE) {
			// false section
			$data['pay_unit_list'] = $this->crud_model->get_list2('id','pay_unit_name','pay_unit',array(''=>'- Select Pay Unit -'),array('status'=>1),'pay_unit_name','asc');
			$data['pay_head_list'] = $this->crud_model->get('pay_head',array('status' => 1));
			$data['pay_unit_records'] = $this->crud_model->get('pay_unit',array('status' => 1));
			$or_where = array('acoount_group_id' => 24);
			$data['payable_ledger_list'] = $this->crud_model->get_list2('ledger_code','ledger_name','ledgers',array(''=>'- Select Ledger -'),array('acoount_group_id'=>4),'ledger_name','asc');
			$data['accounts_ledger_list'] = $this->crud_model->get_list4('ledger_code','ledger_name','ledgers',array(''=>'- Select Ledger -'),array('acoount_group_id'=>24),$or_where,'ledger_name','asc');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/payhead/create',$data);
			$this->load->view('templates/footer');
		} else {	
			// true section
			$pay_head_name=trim($this->input->post('pay_head_name'));
			$pay_head_display_name=trim($this->input->post('pay_head_display_name'));
			if($this->input->post('by_formula')) {
				$is_formula=1;
				$set_formula=$this->input->post('set_formula');
			} else {
				$is_formula=0;
				$set_formula=NULL;
			}
			$pay_unit_id=0;
			$pay_hash_unit=NULL;
			if($this->input->post('is_gosi')!='') {
				$is_gosi=1;
			} else {
				$is_gosi=0;
			}
			$is_fixed=0;
			$is_indemnity=0;
			$is_leave_salary=0;
			$is_loan=0;
			$is_ot_normal=0;
			$is_ot_special=0;
			$by_attendance=0;
			if($this->input->post('pay_head_type')==='Is Fixed') {
				$is_fixed=1;
			} elseif($this->input->post('pay_head_type')==='Is Indemnity') {
				$is_indemnity=1;
			} elseif($this->input->post('pay_head_type')==='Is Leave Salary') {
				$is_leave_salary=1;
			} elseif($this->input->post('pay_head_type')==='Is Loan') {
				$is_loan=1;
			} elseif($this->input->post('pay_head_type')==='Is OT Normal') {
				$is_ot_normal=1;
			} elseif($this->input->post('pay_head_type')==='Is OT Special') {
				$is_ot_special=1;
			} elseif($this->input->post('pay_head_type')==='By Attendance') {
				$by_attendance=1;
				$pay_unit_id=$this->input->post('pay_unit_id');
				$pay_hash_unit=$this->input->post('pay_hash_unit');
			}
			$is_fixed_type=0;
			if(@$this->input->post('is_fixed_type')!==null) {
				$is_fixed_type=$this->input->post('is_fixed_type');
			}
			$set_variable = '@'.str_replace(' ', '_', $pay_head_name).'@';
			if($this->input->post('effect_net_salary')!='') {
				$effect_net_salary=1;
			} else {
				$effect_net_salary=0;
			}
			$is_payable=0;
			$payable_ledger=NULL;
			if($this->input->post('is_payable')!='') {
				$is_payable=1;
				$accounts_ledger=$payable_ledger=$this->input->post('payable_ledger');
			} else {
				$accounts_ledger=$this->input->post('accounts_ledger');
			}
			$data=array(
				'pay_head_name'  => $pay_head_name,
				'pay_head_display_name' => $pay_head_display_name,
				'by_attendance'  => $by_attendance,
				'is_gosi' 		 => $is_gosi,
				'is_fixed'       => $is_fixed,
				'is_fixed_type'  => $is_fixed_type,
				'is_indemnity' 	 => $is_indemnity,
				'is_leave_salary'=> $is_leave_salary,
				'set_variable'   => $set_variable,
				'is_formula' 	 => $is_formula,
				'pay_unit_id' 	 => $pay_unit_id,
				'pay_unit' 	 	 => $pay_hash_unit,
				'is_loan' 		 => $is_loan,
				'is_ot_normal' 	 => $is_ot_normal,
				'is_ot_special'  => $is_ot_special,
				'set_formula' 	 => $set_formula,
				'effect_net_salary'=> $effect_net_salary,
				'is_payable' 	 => $is_payable,
				'accounts_ledger' => $accounts_ledger,
				'payable_ledger' => $payable_ledger
			);

			$rr=$this->crud_model->insert('pay_head',$data);
			$insert_id	=	$this->db->insert_id();
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Pay Head',	
				'masters_id'=>$insert_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'create',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			if($rr == false) {
				// error
				$this->session->set_flashdata('response','Pay head cannot be inserted',':old:');
				$redirect('masters/Payhead');
			} else {
				// redirect
				$this->session->set_flashdata('success','Pay head added successfully');
				redirect('masters/Payhead');
			}
		}
	}
	public function get_pay_unit_hash() {
		$pay_unit_id = $this->input->post('pay_unit_id');
		$where=array("id"=>$pay_unit_id);
		$records=$this->crud_model->get('pay_unit', $where);
		echo json_encode($records); //$records[0]['pay_hash_unit'];
	}

	function do_update() {
		$this->users_model->permission("PayHead","Edit");
		$title['headerTitle']="Department Edit";
		$pay_head_id = ascii_to_entities($this->input->post('pay_head_id'));
		$this->form_validation->set_rules('pay_head_name', 'Name', 'required');
		$this->form_validation->set_rules('pay_head_display_name', 'Name', 'required');
		$status = ascii_to_entities($this->input->post('status'));
		if($this->input->post('pay_head_type')==='By Attendance') {
			$this->form_validation->set_rules('pay_unit_id', 'Pay Unit', 'required');
			$this->form_validation->set_rules('pay_hash_unit', 'Pay Unit', 'required');
		}
		$file_error = "";
		$filename = "";
		if($this->input->post('is_payable')!='') {
			$this->form_validation->set_rules('payable_ledger', 'Payable Ledger', 'required');
		} else {
			$this->form_validation->set_rules('accounts_ledger', 'Ledger', 'required');
		}
		if ($this->form_validation->run() == FALSE) {
			// false section
			$where=array("id"=>$pay_head_id);
			$records=$this->crud_model->get('pay_head', $where);
			if($records != false){
				//true section
				$data['id']				= $records[0]['id'];
				$data['pay_head_name']	= $records[0]['pay_head_name'];
				$data['by_attendance']	= $records[0]['by_attendance'];
				$data['is_gosi']		= $records[0]['is_gosi'];
				$data['is_fixed']		= $records[0]['is_fixed'];
				$data['is_fixed_type']	= $records[0]['is_fixed_type'];
				$data['is_indemnity']	= $records[0]['is_indemnity'];
				$data['is_leave_salary']= $records[0]['is_leave_salary'];
				$data['is_loan']		= $records[0]['is_loan'];
				$data['is_ot_normal']	= $records[0]['is_ot_normal'];
				$data['is_ot_special']	= $records[0]['is_ot_special'];
				$data['status']			= $records[0]['status'];
				$data['pay_unit_id']	= $records[0]['pay_unit_id'];
				$data['pay_hash_unit']	= $records[0]['pay_unit'];
				$data['set_formula']	= $records[0]['set_formula'];
				$data['is_formula']		= $records[0]['is_formula'];
				$data['set_variable']	= $records[0]['set_variable'];
				$data['effect_net_salary']= $records[0]['effect_net_salary'];
				$data['is_payable']		= $records[0]['is_payable'];
				$data['payable_ledger'] = $records[0]['payable_ledger'];
				$data['accounts_ledger'] = $records[0]['accounts_ledger'];
				$data['pay_head_display_name']	= $records[0]['pay_head_display_name'];
				$data['user_status'] 	= $this->config->item('user_status_array');
	
				$data['pay_unit_list'] = $this->crud_model->get_list2('id','pay_unit_name','pay_unit',array(''=>'- Select Pay Unit -'),array('status'=>1),'pay_unit_name','asc');

				$data['pay_head_list'] = $this->crud_model->get('pay_head',array('id!=' => $records[0]['id'],'status' => 1));
				$data['pay_unit_records'] = $this->crud_model->get('pay_unit',array('status' => 1));
				$or_where = array('acoount_group_id' => 24);
				$data['payable_ledger_list'] = $this->crud_model->get_list2('ledger_code','ledger_name','ledgers',array(''=>'- Select Ledger -'),array('acoount_group_id'=>4),'ledger_name','asc');
				$data['accounts_ledger_list'] = $this->crud_model->get_list4('ledger_code','ledger_name','ledgers',array(''=>'- Select Ledger -'),array('acoount_group_id'=>24),$or_where,'ledger_name','asc');
				$this->session->set_flashdata('response',''.validation_errors().'',':old:');
				$this->load->view('templates/header',$title);
				$this->load->view('masters/payhead/edit',$data);
				$this->load->view('templates/footer');

			} 
		} else {// true section
			
			$pay_head_name=trim($this->input->post('pay_head_name'));
			$pay_head_display_name=trim($this->input->post('pay_head_display_name'));
			if($this->input->post('by_formula')) {
				$is_formula=1;
				$set_formula=$this->input->post('set_formula');
			} else {
				$is_formula=0;
				$set_formula=NULL;
			}
			$pay_unit_id=0;
			$pay_hash_unit=NULL;
			if($this->input->post('is_gosi')!='') {
				$is_gosi=1;
			} else {
				$is_gosi=0;
			}
			$is_fixed=0;
			$is_indemnity=0;
			$is_leave_salary=0;
			$is_loan=0;
			$is_ot_normal=0;
			$is_ot_special=0;
			$by_attendance=0;
			if($this->input->post('pay_head_type')==='Is Fixed') {
				$is_fixed=1;
			} elseif($this->input->post('pay_head_type')==='Is Indemnity') {
				$is_indemnity=1;
			} elseif($this->input->post('pay_head_type')==='Is Leave Salary') {
				$is_leave_salary=1;
			} elseif($this->input->post('pay_head_type')==='Is Loan') {
				$is_loan=1;
			} elseif($this->input->post('pay_head_type')==='Is OT Normal') {
				$is_ot_normal=1;
			} elseif($this->input->post('pay_head_type')==='Is OT Special') {
				$is_ot_special=1;
			} elseif($this->input->post('pay_head_type')==='By Attendance') {
				$by_attendance=1;
				$pay_unit_id=$this->input->post('pay_unit_id');
				$pay_hash_unit=$this->input->post('pay_hash_unit');
			}
			$is_fixed_type=0;
			if(@$this->input->post('is_fixed_type')!==null) {
				$is_fixed_type=$this->input->post('is_fixed_type');
			}
			if($this->input->post('effect_net_salary')!='') {
				$effect_net_salary=1;
			} else {
				$effect_net_salary=0;
			}
			$is_payable=0;
			$payable_ledger=NULL;
			if($this->input->post('is_payable')!='') {
				$is_payable=1;
				$accounts_ledger=$payable_ledger=$this->input->post('payable_ledger');
			} else {
				$accounts_ledger=$this->input->post('accounts_ledger');
			}
			$data=array(
				'pay_head_name'  => $pay_head_name,
				'pay_head_display_name'  => $pay_head_display_name,
				'by_attendance'  => $by_attendance,
				'is_gosi' 		 => $is_gosi,
				'is_fixed' 		 => $is_fixed,
				'is_fixed_type'  => $is_fixed_type,
				'is_indemnity'   => $is_indemnity,
				'is_leave_salary'=> $is_leave_salary,
				'is_loan'        => $is_loan,
				'is_ot_normal'   => $is_ot_normal,
				'is_formula' 	 => $is_formula,
				'pay_unit_id' 	 => $pay_unit_id,
				'pay_unit' 		 => $pay_hash_unit,
				'set_formula' 	 => $set_formula,
				'is_ot_special'  => $is_ot_special,
				'effect_net_salary'=> $effect_net_salary,
				'is_payable' 	 => $is_payable,
				'accounts_ledger' => $accounts_ledger,
				'payable_ledger' => $payable_ledger
			);
			$where=array(
				'id'  => $pay_head_id
			);
		
			$records=$this->crud_model->update('pay_head',$data,$where);
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Payroll Pay Head',	
				'masters_id'=>$pay_head_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);

			$this->session->set_flashdata('success','Pay head updated');
			redirect('masters/Payhead');
		}
	}
	function do_delete($department_id=0) {
		$this->users_model->permission("PayHead","Delete");
		$where=array(
			'department_id'  => $department_id
		);
		$data=array('status' => 0);
			
		$records=$this->crud_model->update('department_master',$data,$where);
		$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Payroll Pay Head',	
				'masters_id'=>$department_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'delete',	
			);
			$this->crud_model->insert('log_for_masters',$data);

		$this->session->set_flashdata('success','Pay head deleted');
		redirect('masters/Department');
	}
}