<?php
class ServiceCategory extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
		$this->load->model('Vehicle');
		$this->load->model('users_model');
	}
	public function index(){
		$title['headerTitle']="Service Category";
		$data['vchtypelist']  = $this->Vehicle->getServiceCategoryMaster();	
		$this->load->view('templates/header',$title);
		$this->load->view('masters/vehicle/service_category',$data);
		$this->load->view('templates/footer');
	}
	public function create(){
 		$config = array(
			array(
				'field' => 'service_category_name',
				'label' => 'Category Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.',
 				)
            ),
 
		);	
		if($this->input->post('service_category_name') != '')
		{
			$config[] = array(
				'field' => 'service_category_name',
				'label' => 'Category Name',
				'rules' => 'trim|is_unique[service_category_master.service_category_name]',
				'errors' => array(
					'is_unique'      => '%s  is Already Exists..'
				)
			);
		}
        $this->form_validation->set_rules($config);
		if ($this->form_validation->run() == FALSE){
			$data['cat_name']     =  set_value('service_category_name');
 			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$title['headerTitle']="Vehicle Category";
			$data['vchtypelist']  = $this->Vehicle->getServiceCategoryMaster();		
			$this->load->view('templates/header',$title);
			$this->load->view('masters/vehicle/service_category',$data);
			$this->load->view('templates/footer');
		}
		else{
			$data = array(
				'service_category_name' =>	$this->input->post('service_category_name'),
 			);
			$res = $this->crud_model->insert('service_category_master',$data);
			if($res){
				$insert_id = $this->db->insert_id();
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'=>'Service Category',	
					'masters_id'=>$insert_id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'create',	
				);
				$this->crud_model->insert('log_for_masters',$data);
			    $this->session->set_flashdata('success', 'Service Category Created Successfully');				 
			}
			else{
				$this->session->set_flashdata('response', 'Something WentWrong');
				 
			}
			redirect('masters/ServiceCategory');
		}
	}
	public function update_vehiclecategory(){		
		//$this->users_model->permission("ServiceLineGroup", "Edit");
		$edit_cat_name = $this->input->post('edit_service_category_name');
		$insert_id = $this->input->post('edit_cat_id');
		$check_unique = $this->Vehicle->checkServiceCategoryName($edit_cat_name);
 

		if($this->input->post('edit_service_category_name') != '' && ($check_unique->service_category_id != $insert_id && $check_unique->service_category_name == $edit_cat_name))
		{
			$config[] = array(
				'field' => 'edit_service_category_name',
				'label' => 'Category Name',
				'rules' => 'trim|is_unique[service_category_master.service_category_name]',
				'errors' => array(
					'is_unique'      => '%s  is Already Exists..'
				)
			);
		}
		else{
			$config = array(
				array(
					'field' => 'edit_service_category_name',
					'label' => 'Category Name',
					'rules' => 'trim|required',
					'errors' => array(
						'required'      => 'Please Enter %s.',
					 )
				),				 
			); 
		}
		$this->form_validation->set_rules($config);
		if ($this->form_validation->run() == FALSE){
			$data['edit_cat_name']     =  set_value('edit_service_category_name');
 			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$title['headerTitle']="Vehicle Category";
			$data['vchtypelist']  = $this->Vehicle->getServiceCategoryMaster();			
			$this->load->view('templates/header',$title);
			$this->load->view('masters/vehicle/service_category',$data);
			$this->load->view('templates/footer');
		}
		else{
			$datas = array(
				'service_category_name'    	=> $this->input->post('edit_service_category_name'),
 				'service_category_status' 	=> $this->input->post('edit_vh_status'),				
			);
			
			$where = array(
				'service_category_id' 	=> $insert_id,
			);
  			$res = $this->crud_model->update('service_category_master',$datas,$where);	
				
 			if($res){			
					
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'=>'Service Category',	
					'masters_id'=>$insert_id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'update',	
				);
				$this->crud_model->insert('log_for_masters',$data);
			    $this->session->set_flashdata('success', 'Service Category Updated Successfully');				 
			}
			else{
				$this->session->set_flashdata('response', 'Something WentWrong');				
			}
			redirect('masters/ServiceCategory');
		}
	}
}