<?php
class ServiceRateMaster extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
		$this->load->model('Vehicle');
		$this->load->model('users_model');
	}
	public function index(){
		//$this->users_model->permission("ServiceLineMaster", "View");
		$title['headerTitle']="Service Rate Master";
		$data['grouplist']  = $this->Vehicle->getServiceRateMaster();	
		$data['VehicleCategory']  = $this->Vehicle->getServiceVehicleCategory();	
		$this->load->view('templates/header',$title);
		$this->load->view('masters/vehicle/service_rate_master',$data);
		$this->load->view('templates/footer');
	}
	public function Update_servicelinegroupstatus(){
 		$this->db->trans_begin();
		$id =  $this->input->post('id');
		$status =  $this->input->post('status');
		$where = array('id' => $id);
		$data = array(
			'status'    => $status
	   );
		$this->crud_model->update('service_rate_master',$data,$where);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			echo 'error';
		} else {
			$this->db->trans_commit();
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Service Rate Master - Status',	
				'masters_id'=>$id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);
			echo 'success';
		}
	}
	public function create(){
  		$config = array(
			array(
				'field' => 'group_name',
				'label' => 'Group Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.',
 				)
            ),
 
		   array(
				'field' => 'sub_service_line_id',
				'label' => 'Service Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Select %s.'
				)
		   ),
		   array(
				'field' => 'service_category_id',
				'label' => 'Service Category',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Select %s.'
				)
		   ),
		   array(
				'field' => 'rate',
				'label' => 'Rate',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
		   ),
		);	
		if(!empty($this->input->post('group_name')) || $this->input->post('group_name') != ''){
			$config[] =array(
				'field' => 'service_group_id',
				'label' => 'Group Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => '  %s Is Not Valid.'
				)
			);
		}
        $this->form_validation->set_rules($config);
		if ($this->form_validation->run() == FALSE){
			$data['sub_service_line_id']     =  set_value('sub_service_line_id');
			$data['group_name']              =  set_value('group_name');
			$data['service_category_id']     =  set_value('service_category_id');
			$data['service_group_id']        =  set_value('service_group_id');
			$data['rate']                    =  set_value('rate');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$title['headerTitle']   ="Service Rate Master";
			$data['grouplist']      = $this->Vehicle->getServiceRateMaster();	
			$data['VehicleCategory']  = $this->Vehicle->getServiceVehicleCategory();	
			$this->load->view('templates/header',$title);
			$this->load->view('masters/vehicle/service_rate_master',$data);
			$this->load->view('templates/footer');
		}
		else{
 
			$service_area  =  $this->input->post('sub_service_line_id');
 
			$data = array(
				'services_group_id' => $this->input->post('service_group_id'),
				'item_id'           => $this->input->post('sub_service_line_id'),
				'vehicle_type_id'   => $this->input->post('service_category_id'),
				'amount'	        => $this->input->post('rate'),
				'date' 			    => date('y-m-d'),
 			);
			$res = $this->crud_model->insert('services_rate_table',$data);
			if($res){
				$insert_id = $this->db->insert_id();
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'=>'Service Rate Master',	
					'masters_id'=>$insert_id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'create',	
				);
				$this->crud_model->insert('log_for_masters',$data);
			    $this->session->set_flashdata('success', 'Service Rate Master Created Successfully');				 
			}
			else{
				$this->session->set_flashdata('response', 'Something WentWrong');
				 
			}
			redirect('masters/ServiceRateMaster');
		}
	}
	public function update_servicerate_master(){		
		//$this->users_model->permission("ServiceLineMaster", "Edit");
		$config = array(
			array(
				'field' => 'edit_group_name',
				'label' => 'Group Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.',
 				)
            ),

		   array(
				'field' => 'edit_sub_service_line_id',
				'label' => 'Service Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => ' %s Is Required.'
				)
		   ), 
		   array(
				'field' => 'edit_service_category_id',
				'label' => 'Service Category',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
		   ),
		   array(
				'field' => 'edit_rate',
				'label' => 'Rate',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
		   ),
		);	
		if(!empty($this->input->post('group_name')) || $this->input->post('group_name') != ''){
			$config[] =array(
				'field' => 'edit_service_group_id',
				'label' => 'Group Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => '  %s Is Not Valid.'
				)
			);
		}
		$this->form_validation->set_rules($config);
		if ($this->form_validation->run() == FALSE){
			$data['edit_group_name']     =  set_value('edit_group_name');
			$data['edit_service_group_id']     =  set_value('edit_service_group_id');
			$data['edit_sub_service_line_id']   =  set_value('edit_sub_service_line_id');
			$data['edit_service_category_id']   =  set_value('edit_service_category_id');
			$data['edit_rate']   		 =  set_value('edit_rate');
			$data['is_troubleshoot']     =  set_value('is_troubleshoot');
			$data['edit_group_name']     =  set_value('edit_group_name');
			$data['m_status']     		 =  set_value('m_status');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
 			$title['headerTitle']   ="Service Rate Master";
			$data['grouplist']      = $this->Vehicle->getServiceRateMaster();	
			$data['VehicleCategory']  = $this->Vehicle->getServiceVehicleCategory();	
			$this->load->view('templates/header',$title);
			$this->load->view('masters/vehicle/service_rate_master',$data);
			$this->load->view('templates/footer');
		}
		else{
			// $service_area_str = '';
			// $service_area  =  $this->input->post('edit_sub_service_line_id');
 			// if(!empty($service_area)){
			// 	for($i=0;$i<count($service_area);$i++){
			// 		$service_area_str.=$service_area[$i].',';
			// 	}
			// 	$service_area_str=rtrim($service_area_str, ',');
			// }

			$datas = array(
				'services_group_id' => $this->input->post('edit_service_group_id'),
				'item_id'           => $this->input->post('edit_sub_service_line_id'),
				'vehicle_type_id'   => $this->input->post('edit_service_category_id'),
				'amount'	        => $this->input->post('edit_rate'),
				'status'		   => $this->input->post('m_status') 	
			);
			$insert_id = $this->input->post('edit_services_rate_id');
			$where = array(
				'services_rate_id' 	=> $insert_id,
			);
  			$res = $this->crud_model->update('services_rate_table',$datas,$where);					
 			if($res){				
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'=>'Service Rate Master',	
					'masters_id'=>$insert_id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'update',	
				);
				$this->crud_model->insert('log_for_masters',$data);
			    $this->session->set_flashdata('success', 'Service Rate Master Updated Successfully');				 
			}
			else{
				$this->session->set_flashdata('response', 'Something WentWrong');				
			}
			redirect('masters/ServiceRateMaster');
		}
	}
}