<?php
class VehicleModel extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
		$this->load->model('Vehicle');
		$this->load->model('users_model');
	}
	public function index(){
		$this->users_model->permission("VehicleModel", "View");
		$title['headerTitle']="Vehicle Model";
		$data['make']  = $this->Vehicle->getMake();
		$data['model']  = $this->Vehicle->getModel();
		$data['vcategory']  = $this->Vehicle->getVehicleCategoryList();
		$this->load->view('templates/header',$title);
		$this->load->view('masters/vehicle/vehicle_model',$data);
		$this->load->view('templates/footer');

	}
	public function create(){
		$this->users_model->permission("VehicleModel", "Add");
		$this->form_validation->set_rules('make', 'Make', 'required');
		$this->form_validation->set_rules('title', 'Title', 'required');
		$this->form_validation->set_rules('vtype', 'Vehicle Category', 'required');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			redirect('masters/VehicleModel');
		}
		else{
			$data = array(
				'make_id' => $this->input->post('make'),
				'code' => $this->input->post('title'),
				'title' => $this->input->post('title'),
				'type' => $this->input->post('vtype')
			);
			$res = $this->Vehicle->saveModel($data);
			if($res){
				$insert_id = $this->db->insert_id();
					$date = date("Y-m-d H:i:s");
					$userid = $this->session->userdata('user_id');
					$data= array(						
						'masters_type'=>'VehicleModel',	
						'masters_id'=>$insert_id,	
						'date'=>$date,	
						'created_id'=> $userid,	
						'masters_op'=>'create',	
					);
					$this->crud_model->insert('log_for_masters',$data);
				$this->session->set_flashdata('success', 'Vehicle Model Added Successfully');
			}
			else{
				$this->session->set_flashdata('response', 'Something WentWrong');
			}
			redirect('masters/VehicleModel');
		}
	}
	public function edit(){		
		$this->users_model->permission("VehicleModel", "Edit");
		$this->form_validation->set_rules('updatetitle', 'Title', 'required');
		$this->form_validation->set_rules('updatevtype', 'Vehicle Category', 'required');
		if ($this->form_validation->run() == FALSE) {
			redirect('masters/VehicleModel');
		}
		else{
			$data = array(
				'make_id'=> $this->input->post('edit_make'),
				'code'   => $this->input->post('updatetitle'),
				'title'  => $this->input->post('updatetitle'),
				'type'   =>	$this->input->post('updatevtype')
			);
			$res = $this->Vehicle->Updatemodel($data);
			if($res){
				    $insert_id = $this->input->post('updatetitle');
					$date = date("Y-m-d H:i:s");
					$userid = $this->session->userdata('user_id');
					$data= array(						
						'masters_type'=>'VehicleModel',	
						'masters_id'=>$insert_id,	
						'date'=>$date,	
						'created_id'=> $userid,	
						'masters_op'=>'update',	
					);
					$this->crud_model->insert('log_for_masters',$data);
				$this->session->set_flashdata('success', 'Model Updated Successfully');				 
			}
			else{
				$this->session->set_flashdata('response', 'Something WentWrong');
				 
			}
			redirect('masters/VehicleModel');
		}
	}
}