<?php
class VehicleType extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
 		$this->load->model('Vehicle');
		$this->load->model('users_model');
		$this->load->model('crud_model');
	}
	public function index(){
		//$this->users_model->permission("VehicleType", "View");
		$title['headerTitle']="Vehicle Types";
		$data['VehicleType']  = $this->Vehicle->getVehicleType();
		$this->load->view('templates/header',$title);
		$this->load->view('masters/vehicle/vehicle_type',$data);
		$this->load->view('templates/footer');

	}
	public function create(){
		//$this->users_model->permission("VehicleType", "Add");
		$this->form_validation->set_rules('title', 'Make', 'required');
 		if ($this->form_validation->run() == FALSE) {
			redirect('masters/VehicleType');
		}
		else{
			$data = array(
				'type' => $this->input->post('title'),
			);
			$res = $this->crud_model->insert('vehicle_type',$data);
			if($res){
				$insert_id = $this->db->insert_id();
					$date = date("Y-m-d H:i:s");
					$userid = $this->session->userdata('user_id');
					$data= array(						
						'masters_type'=>'VehicleType',	
						'masters_id'=>$insert_id,	
						'date'=>$date,	
						'created_id'=> $userid,	
						'masters_op'=>'create',	
					);
					$this->crud_model->insert('log_for_masters',$data);
				$this->session->set_flashdata('success', 'Vehicle Type Added Successfully');
			}
			else{
				$this->session->set_flashdata('response', 'Something WentWrong');
			}
			
			redirect('masters/VehicleType');
		}
	}
	public function edit(){		
		//$this->users_model->permission("VehicleType", "Edit");
		$this->form_validation->set_rules('updatetitle', 'Type Name', 'required');
		if ($this->form_validation->run() == FALSE) {
			redirect('masters/VehicleType');
		}
		else{
			$data = array(
 				'type'  => $this->input->post('updatetitle'),
				'type_status' => $this->input->post('type_status'),
			);
			$id = $this->input->post('make_id');
			$where_1 = array('id' => $id);
			$res =$this->crud_model->update('vehicle_type',$data,$where_1);
			if($res){
				    $insert_id = $id;
					$date = date("Y-m-d H:i:s");
					$userid = $this->session->userdata('user_id');
					$data= array(						
						'masters_type'=>'VehicleType',	
						'masters_id'=>$insert_id,	
						'date'=>$date,	
						'created_id'=> $userid,	
						'masters_op'=>'update',	
					);
					$this->crud_model->insert('log_for_masters',$data);
				$this->session->set_flashdata('success', 'Vehicle Type Updated Successfully');				 
			}
			else{
				$this->session->set_flashdata('response', 'Something WentWrong');
				 
			}
			redirect('masters/VehicleType');
		}
	}
}