<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Technician extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->model('furniture_quotation_model');
		$this->load->model('Technician_model');
		$this->load->model('Job_card_model');
	}	

	public function view_jobs($job_id,$technician_id) {
		$title['headerTitle']="View Jobs";
		$data['dbdata']=$this->crud_model->get('view_furniture_job_card',array('job_card_id'=>$job_id));
		$data['job_list_item_wise']=$this->Technician_model->job_list_item_wise($job_id);
		$data['isBegin'] = $this->Technician_model->CheckopenedJobtechnician($job_id,$technician_id); 
		$data['check_job_item_qty'] = $this->Job_card_model->getjobItemtTotalOrderQuantity($job_id);
		$data['check_po_item_qty']  = $this->Job_card_model->getpurchaseTotalOrderQuantity($job_id);
		$data['check_job_stock_qty']   = $this->Job_card_model->getjobItemtTotalStockQuantity($job_id);
		$data['check_mstock_item_qty'] = $this->Job_card_model->getmaterialstockQuantity($job_id);


		$this->load->view('templates/header',$title);
		$this->load->view('technician/view_jobs',$data);
		$this->load->view('templates/footer');
	}

	public function beginJob()
	{
		$job_detail_id = $this->input->post('job_detail_id');
		$job_id = $this->input->post('job_id');
		$job_no = $this->input->post('job_no');
		$status = $this->input->post('status');
		$job_status = $this->input->post('job_status');
		$technician_id = $this->input->post('technician_id');
		//$userid = $this->session->userdata('user_id');
		$qry = $this->Technician_model->beginJob($job_detail_id, $job_id, $job_no, $status, $job_status,$technician_id);
		if ($qry === TRUE) {
			echo json_encode('success');

		} else {
			echo json_encode('error');
		}
	}
	public function completeJob(){
		$job_detail_id = $this->input->post('job_detail_id');
		$job_id = $this->input->post('job_id');
		$job_no = $this->input->post('job_no');
		$status = $this->input->post('status');
		$job_status = $this->input->post('job_status');
		$technician_id = $this->input->post('technician_id');
		$qry = $this->Technician_model->completeJob($job_detail_id, $job_id, $job_no, $status, $job_status,$technician_id);
		if($qry === TRUE){
			echo json_encode('success');
		}
		else{
			echo json_encode('error');
		}
	}
	public function endJob(){
		$toDay = date("Y-m-d H:i:s");
		$technician_id = $this->session->userdata('technician_id');
		$selectqry = $this->db->query("SELECT * FROM `technician_wise_log`WHERE end_time IS NULL AND job_status = 'begin' AND `user_id` ='".$technician_id."' order by `log_id` DESC limit 1");
		if ($selectqry->num_rows() > 0) {
			$result = $selectqry->row();
			$starttimestamp = strtotime($result->job_date);
			$endtimestamp = strtotime($toDay);
			$timediff = abs($endtimestamp - $starttimestamp);
			$hours = floor($timediff / 3600);
			$minutes = floor(($timediff % 3600) / 60);
			$seconds = $timediff % 60;
			$duration = sprintf('%02d:%02d:%02d', $hours, $minutes, $seconds);
			$statusUpdate = $this->db->query("UPDATE `technician_wise_log` SET `job_duration`= '".$duration."',`end_time` = '".$toDay."' WHERE job_status = 'begin' AND `end_time` IS NULL AND job_flag = 0 AND`user_id` ='". $technician_id."' AND `log_id` = '".$result->log_id."' ");
			//$this->db->query("UPDATE `job_card_technician` SET  `progress_status` = 0 WHERE  `technician_id` ='".$technician_id."' AND `job_detail_id` ='".$result->job_detail_id."'");
			echo json_encode('success');
		} else {
			echo json_encode('error');
		}
	}
	public function SignoffJob(){
		$toDay = date("Y-m-d H:i:s");
		$technician_id = $this->session->userdata('technician_id');
		$selectqry = $this->db->query("SELECT * FROM `technician_wise_log`WHERE end_time IS NULL AND job_status = 'begin' AND `user_id` ='".$technician_id."' and  `job_flag`=0 order by log_id DESC LIMIT 1");
		if ($selectqry->num_rows() > 0) {
			$result = $selectqry->row();
			$starttimestamp = strtotime($result->job_date);
			$endtimestamp = strtotime($toDay);
			$timediff = abs($endtimestamp - $starttimestamp);
			$hours = floor($timediff / 3600);
			$minutes = floor(($timediff % 3600) / 60);
			$seconds = $timediff % 60;
			$duration = sprintf('%02d:%02d:%02d', $hours, $minutes, $seconds);
			$statusUpdate = $this->db->query("UPDATE `technician_wise_log` SET `job_duration`= '".$duration."',`end_time` = '". $toDay."' WHERE job_status = 'begin' AND `end_time` IS NULL AND`user_id` ='". $technician_id."' AND job_flag = 0 AND `log_id` = '". $result->log_id."' ");				 
			if($statusUpdate){
				echo json_encode('success');
			}else{
				echo json_encode('warning');
			}
		}
		else{
			echo json_encode('error');
		}
	}

	public function getConsumableList(){	
		$consdata = $this->Technician_model->getConsumableListdata();
		$html = '';
		$html = array('message' => '', 'table' => '');	
		if($consdata != FALSE){
			foreach($consdata as $rec){
				if( ($rec['furniture_quantity'] - $rec['issued_quantity']) == 0  ){
					$text_sign = '<i class="fe fe-check text-success me-2" ></i>';
				}
				else{
					$text_sign = '<i class="fe fe-x text-danger me-2"></i>';
				}
				$html['table']  .= '<tr>
							<td>'.$rec['furniture_description'].'</td>
							<td>'.$rec['uom'].'</td>
							<td style="text-align:center;">'.$rec['furniture_quantity'].'</td>
							<td style="text-align:center;">'.$rec['issued_quantity'].'</td>
							<td>'.$text_sign.'</td>
						</tr>';
			}
			$html['message'] = 'success';
		}
		else{
			$html['message'] = 'error';
		}

		echo json_encode($html);
	}
}
?>