<?php

class Job_card_model extends CI_Model {

	public function __construct() {
		// Call the Model constructor
		parent::__construct();
	}

	public function deliveryNoteRow($id){
		$query= $this->db->query("SELECT * FROM `delivery_note` WHERE `id`='$id'");
		return $query->row();
	}

	public function purchaseInvoiceRow($id){
		$query= $this->db->query("SELECT PH.`id`,PH.`purchase_no`,PH.`supplier_reference`,PH.`division_id`,PH.`purchase_invoice_code`,PH.`purchase_date`,PH.`supplier_id`,PH.`payment_mode`,PH.`pur_amt`,PH.`pur_discount`,PH.`pur_vat`,PH.`pur_net_amt`,`PH`.`sign`,`PH`.`round_off`,PH.`delivery_address`,PH.`job_id`,PH.`supplier_inv_no`,PH.`supplier_inv_date`,POH.`po_number`,POH.`po_code`,SM.`supplier_name`,SM.`address`,U.`user_name`,JC.`job_card_number`,PH.`status` as `purchase_status` FROM `purchase_h` PH INNER JOIN `supplier_master` SM ON SM.`supplier_id`=PH.`supplier_id` JOIN `users` U ON U.`user_id`=PH.`user_id`  LEFT JOIN `po_h` POH ON POH.`po_id`=PH.`po_h_id` LEFT JOIN `job_card` JC ON JC.`id`=PH.`job_id`  WHERE PH.`id`='$id'");
		return $query->row();
	}

	public function purchaseInvoiceDetailsXX($id){
		$query= $this->db->query("SELECT `purchase_b`.`po_b_id`, `purchase_b`.`item_name_purchase`, `purchase_b`.`uom`, `purchase_b`.`item_description` AS `body_description`,`purchase_b`.`item_h_id`,`purchase_b`.`technician`,`purchase_b`.`item_qty`,`purchase_b`.`item_rate`,`purchase_b`.`item_fx_rate`,`purchase_b`.`item_amt`,`purchase_b`.`item_disc_amt`,`purchase_b`.`item_vat_per`,`purchase_b`.`item_vat_amt`,`purchase_b`.`item_net_amt`,`purchase_b`.`lcost`,`purchase_b`.`tcost` FROM `purchase_b` WHERE `purchase_b`.`pur_h_id`='$id'");
		
		return $query->result_array();
	}

	public function purchaseOrderRow($id){
		$query= $this->db->query("SELECT `po_h`.`po_id`,`po_h`.`po_number`,`po_h`.`division_id`,`po_h`.`currency_id`,`po_h`.`loc_id`,`po_h`.`poh_ledger_code`,`po_h`.`po_code`,`po_h`.`po_date`,`po_h`.`po_type`,`po_h`.`payment_mode`,`po_h`.`supplier_id`,`po_h`.`supplier_reference`,`po_h`.`delivery_address`,`po_h`.`delivery_terms`,`po_h`.`po_gross_amt`,`po_h`.`po_vat_amt`,`po_h`.`po_discount`,`po_h`.`sign`,`po_h`.`round_off`,`po_h`.`po_net_amt`,`po_h`.`fx_po_gross_amt`,`po_h`.`fx_po_discount`,`po_h`.`fx_po_net_amt`,`po_h`.`status`,`supplier_master`.`supplier_name`,`supplier_master`.`address`,`po_h`.`job_id`,`po_h`.`approved_date`,`po_h`.`approved_user`,`job_card`.`job_card_number`,`NCM`.`client_name`,`NCM`.`client_telephone1`,PR.`pr_id`,PR.`pr_code`,`users`.user_name,po_h.exchange_rate,currency.currency_code,currency.currency_name,currency.float_part,currency.decimal_part FROM `po_h` JOIN `users`ON `users`.`user_id`=`po_h`.`user_id`  JOIN `supplier_master` ON `supplier_master`.`supplier_id`=`po_h`.`supplier_id` JOIN `currency` on currency.currency_id=`po_h`.currency_id LEFT JOIN `job_card` ON `job_card`.`id`=`po_h`.`job_id` LEFT JOIN new_client_master NCM ON NCM.client_id=job_card.client_id LEFT JOIN purchase_request PR ON PR.pr_code=`po_h`.rfq_number  WHERE `po_h`.`po_id`='$id'");
		return $query->row();
	}

	public function purchaseitemwiseRow($po_b_id){
		$query= $this->db->query("SELECT * FROM `po_b` WHERE `po_b`.`po_b_id`='$po_b_id'");
 		return $query->row();
	}

	public function purchaseinvoiceitemwiseRow($pur_det_id){
		$query= $this->db->query("SELECT * FROM `purchase_b` WHERE `purchase_b`.`pur_det_id`='$pur_det_id'");
		return $query->row();
	}

	public function materialIssueRow($id){
		$query= $this->db->query("SELECT MIH.`mi_id`,MIH.mi_number,MIH.mi_code,MIH.division_id,MIH.mi_date,MIH.job_id,MIH.loc_id,JC.`job_card_number`,NCM.client_name,NCM.client_id,NCM.client_telephone1,FQ.quotation_number_full as quotation_number FROM `material_issue_h` MIH JOIN `job_card` JC ON JC.`id`=MIH.`job_id` INNER JOIN new_client_master NCM ON NCM.client_id=JC.client_id LEFT JOIN `furniture_quotation` FQ on FQ.id=JC.quotation_id WHERE MIH.mi_number='$id'");
		return $query->row();
	}

	public function materialIssueDetails($id){
		$query= $this->db->query("SELECT MIB.`mi_b_id`,MIB.`mi_id`,I.`item_name`, MIB.`item_details_id`, MIB.`item_description` AS `body_description`,MIB.`technician_id`,MIB.`job_detail_id`, MIB.`item_qty`,MIB.`item_rate`,MIB.`item_disc`,MIB.`item_amount`,MIB.`item_vat_per`,MIB.`item_vat`,MIB.`net_amount`,MIB.`uom`,MIB.`uom_id` FROM `material_issue_b` MIB LEFT JOIN `items` I ON I.`id`=MIB.`item_details_id` WHERE MIB.`mi_id`='$id' AND MIB.`status` = 1 ");
		return $query->result_array();
	}

	public function materialIssueQtyRow($job_detail_id){
		$query= $this->db->query("SELECT SUM(item_qty) as issued_qty FROM `material_issue_b`  WHERE `job_detail_id`='$job_detail_id' AND `status` = 1");
 		return $query->row()->issued_qty;
	}

	public function materialJobcarddetail($id){
		$query= $this->db->query("SELECT furniture_quantity, issued_quantity, job_card_details_id FROM job_card_details WHERE job_card_id='$id'");
		return $query->result_array();
	}

	public function materialReturnRow($id){
		$query= $this->db->query("SELECT MIH.`mr_id`,MIH.mr_number,MIH.mr_code,MIH.division_id,MIH.mr_date,MIH.job_id,MIH.loc_id,JC.`job_card_number`,NCM.client_name,NCM.client_id,NCM.client_telephone1,FQ.quotation_number_full as quotation_number FROM `material_return_h` MIH JOIN `job_card` JC ON JC.`id`=MIH.`job_id` INNER JOIN new_client_master NCM ON NCM.client_id=JC.client_id LEFT JOIN `furniture_quotation` FQ on FQ.id=JC.quotation_id WHERE MIH.mr_number='$id'");
		return $query->row();
	}

	public function materialReturnDetails($id){
		$query= $this->db->query("SELECT MIB.`mi_b_id`,I.`item_name`, MIB.`item_details_id`, MIB.`item_description` AS `body_description`,MIB.`technician_id`, MIB.`item_qty`,MIB.`item_rate`,MIB.`item_disc`,MIB.`item_amount`,MIB.`item_vat_per`,MIB.`item_vat`,MIB.`net_amount` FROM `material_return_b` MIB LEFT JOIN `items` I ON I.`id`=MIB.`item_details_id` WHERE MIB.`mr_id`='$id'");
		return $query->result_array();
	}

	public function purchaseOrderDetails($id){
		$query= $this->db->query("SELECT `po_b`.`po_b_id`,`items`.`item_name`, `po_b`.`po_ledger_code`, `po_b`.`item_details_id`, `po_b`.`item_fx_rate`, `po_b`.`item_name_nbs` AS `item_name_nbs`, `po_b`.`item_name_purchase`,`po_b`.`uom`,`po_b`.`uom_id`,`po_b`.`b_uom`,`po_b`.`b_uom_conv`,`po_b`.`b_uom_qty`,`po_b`.`b_uom_rate`,`po_b`.`item_description` AS `body_description`,`po_b`.`technician_id`, `po_b`.`item_qty`,`po_b`.`item_rate`,`po_b`.`uom`,`po_b`.`item_disc`,`po_b`.`item_amount`,`po_b`.`item_vat_per`,`po_b`.`item_vat`,`po_b`.`net_amount`, `po_b`.`pr_d_id`, `po_b`.`fx_disc`, `po_b`.`fx_amount`, `po_b`.`fx_net_amount`, `po_b`.`rfq_id` FROM `po_b` LEFT JOIN `items` ON `items`.`id`=`po_b`.`item_details_id` WHERE `po_b`.`po_id`='$id'");
		return $query->result_array();
	}

	public function getJobData($division,$job_number){
		$query= $this->db->query("SELECT * FROM `job_card` JC JOIN new_client_master NCM ON NCM.client_id=JC.client_id  WHERE  JC.`job_card_number`='$job_number' AND JC.`divisionid`='$division' AND (JC.`job_card_status`='Draft')");
		return $query->row();
	}
	public function getPurchaseOrderData($division,$job_number){
		$query= $this->db->query("SELECT * FROM `po_h` PO JOIN supplier_master SM ON SM.supplier_id=PO.supplier_id JOIN `currency` C on C.currency_id=PO.currency_id LEFT JOIN `job_card` JC ON JC.id=PO.job_id LEFT JOIN new_client_master NCM ON NCM.client_id=JC.client_id  WHERE  PO.`po_code`='$job_number' AND PO.`division_id`='$division' AND (PO.`status`='Draft')");
		return $query->row();
	}

	public function getAllPurchaseOrder($division,$job_number){
		$query= $this->db->query("SELECT * FROM `po_h` PO JOIN supplier_master SM ON SM.supplier_id=PO.supplier_id JOIN `currency` C on C.currency_id=PO.currency_id LEFT JOIN `job_card` JC ON JC.id=PO.job_id LEFT JOIN new_client_master NCM ON NCM.client_id=JC.client_id  WHERE  PO.`po_code` LIKE '%$job_number%' AND PO.`division_id`='$division' AND (PO.`status`='Confirmed')");
		return $query->result_array();
	}

	public function purchaseInvoiceDetails($po_id){
		$query= $this->db->query("SELECT `po_b`.`po_b_id`,`po_b`.`po_ledger_code`,`items`.`item_name`, `po_b`.`uom`, `po_b`.`item_details_id`, `po_b`.`item_name_nbs` AS `item_name_nbs`, 
										`po_b`.`item_name_purchase` as `item_name_purchase`,  `po_b`.`item_description` AS `body_description`,`po_b`.`technician_id`, 
										`po_b`.`item_qty`,`po_b`.`item_fx_rate`,`po_b`.`item_rate`,`po_b`.`item_disc`,`po_b`.`item_amount`,`po_b`.`item_vat_per`,`po_b`.`item_vat`,
										`po_b`.`net_amount`, `po_b`.`fx_disc`, `po_b`.`fx_amount`, `po_b`.`fx_net_amount`,`po_h`.`currency_id`,`currency`.`currency_name`,
										`po_b`.`uom_id`,`po_b`.`b_uom`,`po_b`.`b_uom_qty`,`po_b`.`b_uom_conv`, 
										`currency`.`currency_code` FROM `po_b`  JOIN `po_h` ON `po_h`.`po_id`=`po_b`.`po_id` INNER JOIN `currency` ON `currency`.`currency_id`=`po_h`.`currency_id` LEFT JOIN `items` ON `items`.`id`=`po_b`.`item_details_id` WHERE `po_b`.`po_id`='$po_id' ");
 		return $query->result_array();
	}
	public function editPurchaseInvoiceDetails($id){
		$query= $this->db->query("SELECT `purchase_b`.`pur_det_id`, `purchase_b`.`pu_ledger_code`,`purchase_b`.`po_b_id`,`purchase_b`.`uom`,`purchase_b`.`b_uom`,`items`.`item_name`,`items`.`unit_id`,`items`.`uom_id` as sp_uom_id, `items`.`unit_to`,`items`.`unit_from`,`items`.`margin`, `purchase_b`.`item_name_purchase` AS `item_name_purchase`, `purchase_b`.`item_description` AS `body_description`,`purchase_b`.`item_h_id`,`purchase_b`.`technician`,`purchase_b`.`lcost`,`purchase_b`.`tcost`,`purchase_b`.`item_qty`,`purchase_b`.`item_fx_rate`,`purchase_b`.`item_rate`,`purchase_b`.`item_amt`,`purchase_b`.`item_disc_amt`,`purchase_b`.`item_vat_per`,`purchase_b`.`item_vat_amt`,`purchase_b`.`item_net_amt`,`purchase_b`.`fx_disc`,`purchase_b`.`fx_amount`,`purchase_b`.`fx_net_amount`,`purchase_b`.`b_uom_rate`,`purchase_b`.`uom_id`,`purchase_b`.`b_uom_conv` FROM `purchase_b` LEFT JOIN `items` ON `items`.`id`=`purchase_b`.`item_h_id` WHERE `purchase_b`.`pur_h_id`='$id'");  	  
		return $query->result_array();
	}
	public function editPurchaseInvoiceRow($id){
		$query= $this->db->query("SELECT `purchase_h`.`po_h_id`, `purchase_h`.`purchase_invoice_code`,`purchase_h`.`currency_id`,`purchase_h`.`loc_id`,`purchase_h`.`pi_type`,`po_h`.`po_number`,`po_h`.`po_code`,`purchase_h`.`purchase_no`,`purchase_h`.`purchase_date`,`purchase_h`.`supplier_inv_no`,`purchase_h`.`supplier_id`,`purchase_h`.`supplier_reference`,`purchase_h`.`delivery_address`,`purchase_h`.`delivery_terms`,`purchase_h`.`supplier_inv_date`,`purchase_h`.`supplier_id`,`purchase_h`.`payment_mode`,`purchase_h`.`pur_amt`,`purchase_h`.`pur_discount`,`purchase_h`.`pur_vat`,`purchase_h`.`pur_net_amt`,`purchase_h`.`sign`,`purchase_h`.`round_off`,`purchase_h`.`division_id`,`purchase_h`.`job_id`,`supplier_master`.`supplier_name`,`supplier_master`.`address`,`supplier_master`.`supplier_code`,`job_card`.`job_card_number`,`job_card`.`job_card_number`,`job_card`.`id`,`NCM`.`client_name`,`NCM`.`client_telephone1`,`purchase_h`.`id` as purchase_h_id,purchase_h.exchange_rate,currency.currency_code,purchase_h.pi_ledger_code FROM `purchase_h` JOIN `supplier_master` ON `supplier_master`.`supplier_id`=`purchase_h`.`supplier_id` JOIN `currency` on currency.currency_id=purchase_h.currency_id LEFT JOIN `po_h` ON `po_h`.`po_id`=`purchase_h`.`po_h_id`  LEFT JOIN `job_card` ON `job_card`.`id`=`purchase_h`.`job_id`LEFT JOIN new_client_master NCM ON NCM.client_id=job_card.client_id WHERE `purchase_h`.`id`='$id'");
		return $query->row();
	}
	public function total_other_expense($id){
		$query= $this->db->query("SELECT sum(`amount`) as total_other_expense FROM `purchase_invoice_other_expense` WHERE `purchase_id` ='$id' ");
		return $query->row()->total_other_expense;
	}
	public function checkQuantity($po_b_id){
		$query= $this->db->query("SELECT SUM(purchase_b.`item_qty`) AS `invoice_qty` FROM `purchase_b` join purchase_h on purchase_h.id=purchase_b.`pur_h_id`  WHERE (purchase_h.status='Draft' OR purchase_h.status='Confirmed') and purchase_b.`po_b_id`='$po_b_id'");
		if($query->result_array()!=false){
		  $invoice_qty = $query->row()->invoice_qty;
		}else{
			$invoice_qty = 0;
		}
		return $invoice_qty;
	}
	function get_view_job_card($where = array(),$limit=null,$offset=null,$order_by_field=null,$order_by_order=null,$like=null, $or_where=null){

		

		if(!is_null($offset) and !is_null($limit)){
			$this->db->limit($limit,$offset);
		}
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}

		if($like !=null && is_array($like)) {
			foreach($like as $key=>$value) {
				$this->db->like($key, $value);
			}
		}

		if($or_where) {
			$this->db->or_where($or_where);
		}

		$this->db->select('job_card.id as job_card_id,job_card.*,new_client_master.*,furniture_quotation.*,users.*,company_division.*');
		$this->db->where($where);
		$this->db->from('job_card');
		$this->db->join('new_client_master','new_client_master.client_id = job_card.client_id','left');
		$this->db->join('furniture_quotation','furniture_quotation.id = job_card.quotation_id','left');
		$this->db->join('users','users.user_id = job_card.salesman_id','left');
		//$this->db->join('furniture_exstock_paymentterm','furniture_exstock_paymentterm.payment_id = job_card.exstock_paymenttermid','left');
		//$this->db->join('furniture_byorder_paymentterm','furniture_byorder_paymentterm.payment_id = job_card.byorder_paymenttermid','left');
		$this->db->join('company_division','company_division.division_id = job_card.divisionid','left');
		$this->db->order_by("job_card.id","desc");

		$rs = $this->db->get();
		//$this->db->last_query();

		if($rs->num_rows() > 0) {
			return $rs->result_array();
		} else {
			return false;
		}	
	}
	
	function get_job_card_data($quotation_id) {
	
		$data['quotation_id']  = $quotation_id;
		
		$where=array('job_card.id' => $quotation_id);
		
		$records=$this->get_view_job_card($where);
		if($records!=false) {
			$data['job_card_number']			=$records[0]['job_card_number'];
			$data['quotation_id']				=$records[0]['quotation_id'];
			$data['job_card_divisionid']		=$records[0]['divisionid'];
			
			$data['quotation_number']			=$records[0]['quotation_number_full'];

			
			$data['job_card_date']				= $records[0]['job_card_date'];
			$data['job_card_confirmationdate']	= $records[0]['job_card_confirmationdate'];
			
			$data['job_card_status']			=$records[0]['job_card_status'];
			$data['reason_forclose']			=$records[0]['reason_forclose'];
			$data['lpono']						=$records[0]['lpono'];
						
			$data['last_modified_by']			= $records[0]['last_modified_by'];
			$data['last_modified_date']			= $records[0]['last_modified_date'];
			
			$data['division_id']				= $records[0]['divisionid'];
			$data['division_code']				= $records[0]['division_code'];
			$data['division_name']				= $records[0]['division_name'];
			
			$data['currency_code']				= $records[0]['currency_code'];
			$data['currency_name']				= $records[0]['currency_name'];
			$data['logo_filename']				= $records[0]['logo_filename'];
			
			$data['salesman_name']				= $records[0]['user_name'];
			$data['salesman_email_id']			= $records[0]['user_email_id'];
			$data['salesman_contact_number']	= $records[0]['user_contact_number'];
			$data['salesman_direct_number']		= $records[0]['user_direct_number'];
			
			$data['client_id']					= $records[0]['client_id'];
			$data['client_name']				= $records[0]['client_name'];
			$data['client_address']				= $records[0]['client_address'];
			$data['client_country']				= $records[0]['client_country'];
			$data['client_telephone1']			= $records[0]['client_telephone1'];
			$data['client_telephone2']			= $records[0]['client_telephone2'];
			$data['client_email']				= $records[0]['client_email'];
			$data['client_fax']				    = $records[0]['client_fax'];
			$data['contact_person']				= $records[0]['contact_person'];
			$data['tax_name']	           		= $records[0]['tax_name'];
			$data['tax_no']	        			= $records[0]['tax_no'];
			
			
			$data['project_name']				= $records[0]['project_name'];
			$data['project_location']			= $records[0]['project_location'];
			$data['project_remarks']			= $records[0]['project_remarks'];
			$data["project_contact_person_email"] = $records[0]["project_contact_person_email"];
			$data["project_contact_person_number"] = $records[0]["project_contact_person_number"];	
			$data["j_po_no"] 					   = $records[0]["j_po_no"];
			
			$data['job_card_total']			= round($records[0]['job_card_total'], 3);
			$data['quotation_discount_amount']      = $records[0]['quotation_discount'];

			if  ($data['quotation_discount_amount']!=0 && $data['job_card_total']!= 0){
				$data['discount_percentage']		= round(($data['quotation_discount_amount'] * 100) / $data['job_card_total'],8);
			} else {
				$data['discount_percentage'] = 0;
			}

			//$data['quotation_discount_amount'] 	= round($data['quotation_total'] * ($data['discount_percentage'] / 100),3);
			$data['job_card_net_total']		= round($data['job_card_total'] - $data['quotation_discount_amount'],3);
			$data['quotation_discount']			= $records[0]['quotation_discount'];
			$data['advance_percentage']			= $records[0]['advance_percentage'];
			$data['advance_amount']				= $records[0]['advance_amount'];
			/*$data['exstock_paymenttermid'] 	= $records[0]['exstock_paymenttermid'];
			$data['byorder_paymenttermid'] 	= $records[0]['byorder_paymenttermid'];
			$data['exstock_payment_label'] 	= $records[0]['payment_label'];
			$data['byorder_payment_label'] 	= $records[0]['payment_label'];
			$data['exstock_payment_text'] 	= $records[0]['payment_text'];
			$data['byorder_payment_text'] 	= $records[0]['payment_text'];*/
			return $data;		
		} else {
			return false;
		}	
	}// End of get_full_quotation_details
	
	public function purchaseNumber($division_id){
		$query= $this->db->query("SELECT max(`po_number`) as `po_number` FROM `po_h` WHERE division_id='$division_id'");
 		return $query->row()->po_number+1;
	}
	public function miNumber($division_id){
		$query= $this->db->query("SELECT max(`mi_number`) as `mi_number` FROM `material_issue_h` WHERE division_id='$division_id'");
		return $query->row()->mi_number+1;
	}
	public function mrNumber($division_id){
		$query= $this->db->query("SELECT max(`mr_number`) as `mi_number` FROM `material_return_h` WHERE division_id='$division_id'");
		return $query->row()->mi_number+1;
	}
	public function purchaseInvoiceNumber($division_id){
		$query= $this->db->query("SELECT max(`purchase_no`) as `purchase_no` FROM `purchase_h` WHERE division_id='$division_id'");
		return $query->row()->purchase_no+1;
	}

	public function saNumber($division_id){
		$query= $this->db->query("SELECT max(`sa_number`) as `sa_number` FROM `stock_adjustment_h` WHERE division_id='$division_id'");
		return $query->row()->sa_number+1;
	}

	public function get_sa_no($no,$division_id=0){
		if($division_id!=0){
			$query= $this->db->query("SELECT * FROM  `company_division` WHERE division_id='$division_id' ");
			$division_code=$query->row()->division_code;
		} else {
			$division_code='';
		}
		$sa_no='SA-'.sprintf("%'.04d",$no).'-'.$division_code;
		return $sa_no;
	}
	
	public function get_purchase_order_no($no,$division_id=0){
		if($division_id!=0){
			$query= $this->db->query("SELECT * FROM  `company_division` WHERE division_id='$division_id' ");
			$division_code=$query->row()->division_code;
		} else {
			$division_code='';
		}
		$purchase_order_no='PO-'.sprintf("%'.04d",$no).'-'.$division_code;
		return $purchase_order_no;
	}
	public function get_mi_no($no,$division_id=0){
		if($division_id!=0){
			$query= $this->db->query("SELECT * FROM  `company_division` WHERE division_id='$division_id' ");
			$division_code=$query->row()->division_code;
		} else {
			$division_code='';
		}
		$purchase_order_no='MI-'.sprintf("%'.04d",$no).'-'.$division_code;
		return $purchase_order_no;
	}
	public function get_mr_no($no,$division_id=0){
		if($division_id!=0){
			$query= $this->db->query("SELECT * FROM  `company_division` WHERE division_id='$division_id' ");
			$division_code=$query->row()->division_code;
		} else {
			$division_code='';
		}
		$purchase_order_no='MR-'.sprintf("%'.04d",$no).'-'.$division_code;
		return $purchase_order_no;
	}
	public function get_purchase_invoice_no($no,$division_id=0){
		if($division_id!=0){
			$query= $this->db->query("SELECT * FROM  `company_division` WHERE division_id='$division_id' ");
			$division_code=$query->row()->division_code;
		} else {
			$division_code='';
		}
		$purchase_order_no='PI-'.sprintf("%'.04d",$no).'-'.$division_code;
		return $purchase_order_no;
	}

	public function listData($limit, $start,$po_number,$po_date,$supplier_name,$job_no,$division_id,$supplier_id){
		if ($division_id != "NIL"){
		  $sql	= " and `po_h`.`division_id` = '$division_id'";
		} else {
			//$sql	=	$this->OppLogin->userList("`po_h`.`division_id`");
			$sql	="";
		}
			if ($po_number != "NIL"){
				$sql	.= " and `po_h`.`po_number` = '$po_number'";
			}
		if ($po_date != "NIL"){
				$sql	.= " and `po_h`.`po_date` = '$po_date'";
			}
		if ($supplier_id != "NIL"){
			$sql	.= " and `po_h`.`supplier_id`='$supplier_id'";
		}
		if ($job_no != "NIL"){
			$sql	.= " and `job_card`.job_no = '$job_no'";
		}
		$query= $this->db->query("SELECT `po_h`.`po_id`,`po_h`.`po_number`,`po_h`.`po_code`,`po_h`.`po_date`,`po_h`.`payment_mode`,`po_h`.`po_net_amt`,`po_h`.`status`,`supplier_master`.`supplier_name`,`job_card`.job_card_number,`purchase_h`.status AS pi_status FROM `po_h` JOIN `supplier_master` ON `supplier_master`.`supplier_id`=`po_h`.`supplier_id` LEFT JOIN `job_card` ON `job_card`.id= `po_h`.job_id LEFT JOIN `purchase_h` ON (`purchase_h`.po_h_id=`po_h`.`po_id` and `purchase_h`.status='1') WHERE (`po_h`.`status`='1' or `po_h`.`status`='0')  ".$sql." order by `po_id` desc limit ".$start.",".$limit);
		return $query->result();
  	}

	public function record_count($fromDate,$toDate,$filter_value,$jobNo,$client_id){
		$sql='';
		if($fromDate!='NIL' and $toDate!='NIL') {
			$sql .="  AND mi.`mi_date` between '$fromDate' and '$toDate'  ";
		} else if($fromDate!='NIL' and $toDate=='NIL'){
			$sql .=" and mi.`mi_date`	>=	'$fromDate' ";
		} else if($fromDate=='NIL' and $toDate!='NIL'){
			$sql .=" and mi.`mi_date`	<=	'$toDate' ";
		}

		if ($filter_value != "NIL"){
			$sql	.= " and mi.`mi_code` like '%$filter_value%'";
		} 
		if ($jobNo != "NIL"){
			$sql	.= " and `job_card`.`job_card_number` = '%$jobNo%'";
		}
		if ($client_id != "NIL"){
			$sql	.= " and `job_card`.client_id = '$client_id'";
		}
		$result =   $this->db->query("SELECT count(mi.`mi_id`) AS `Tcount` FROM `material_issue_h` as mi LEFT JOIN `job_card` ON `job_card`.id= mi.job_id INNER JOIN `new_client_master` ncm on ncm.client_id=`job_card`.client_id WHERE (mi.`status`='1' or mi.`status`='0')  ".$sql);
	 	return ($result->row()->Tcount);
 	}

	 function get_all_purchase_order(){
		if(isset($_REQUEST['ttttt'])){
			if($this->input->post('filter_value')!=""){
				$this->db->like('`po_h`.`po_code`',$this->input->post('filter_value'));
			}
			if($this->input->post('jobNo')!=""){
				$this->db->like('`job_card`.job_card_number',$this->input->post('jobNo'));
			}
			if($this->input->post('type')!="All"){
				$this->db->like('po_type',$this->input->post('type'));
			}
			if($this->input->post('client_id')!=""){
				$this->db->where('supplier_master.supplier_id',$this->input->post('client_id'));
			}
			$fromDate=$this->input->post('fromDate');
			$toDate=$this->input->post('toDate');
			if($fromDate!='' and $toDate!='') {
				$date2 = str_replace('/', '-', $this->input->post("fromDate"));
				$date3 = str_replace('/', '-', $this->input->post("toDate"));
				$fromDate =   date("Y-m-d", strtotime($date2));
				$toDate =   date("Y-m-d", strtotime($date3));
				$this->db->where('`po_h`.`po_date` >=', $fromDate);
				$this->db->where('`po_h`.`po_date` <=', $toDate);
			} else if($fromDate!='' and $toDate==''){
				$date2 = str_replace('/', '-', $this->input->post("fromDate"));
				$fromDate =   date("Y-m-d", strtotime($date2));
				$this->db->where('`po_h`.`po_date` >=', $fromDate);
			} else if($fromDate=='' and $toDate!=''){
				$date3 = str_replace('/', '-', $this->input->post("toDate"));
				$toDate =   date("Y-m-d", strtotime($date3));
				$this->db->where('`po_h`.`po_date` <=', $toDate);
			}
		}
		
		
		$this->db->select('`po_h`.`po_id`,`po_h`.`po_number`,`po_h`.`po_code`,`po_h`.`po_type`,`po_h`.`po_date`,`po_h`.`payment_mode`,`po_h`.`po_net_amt`,`po_h`.`status`,`po_h`.`rfq_number`,`po_h`.`po_create_type`,`supplier_master`.`supplier_name`,`job_card`.job_card_number,`purchase_h`.status AS pi_status');
		$this->db->from('po_h');
		$this->db->join('supplier_master','supplier_master.supplier_id = po_h.supplier_id','left');
		$this->db->join('job_card','job_card.id = po_h.job_id','left');
		$this->db->join('purchase_h','purchase_h.po_h_id = po_h.po_id and (purchase_h.status="Draft" OR purchase_h.status="Confirmed")','left');
		$status = array('Draft','Confirmed','Cancel');
		$this->db->where_in('po_h.`status`', $status);
		$this->db->limit(200);
		$this->db->group_by("po_id");
		$this->db->order_by("po_id","desc");
		
		$rs = $this->db->get();
		//echo $this->db->last_query().'<br>';
		if($rs->num_rows() > 0) {
			return $rs->result();
		} else {
			return array();
		}
	}


	public function mi_record_count($fromDate,$toDate,$filter_value,$jobNo,$client_id){
		$sql='';
		if($fromDate!='NIL' and $toDate!='NIL') {
			$sql .="  AND mi.`mi_date` between '$fromDate' and '$toDate'  ";
		} else if($fromDate!='NIL' and $toDate=='NIL'){
			$sql .=" and mi.`mi_date`	>=	'$fromDate' ";
		} else if($fromDate=='NIL' and $toDate!='NIL'){
			$sql .=" and mi.`mi_date`	<=	'$toDate' ";
		}

		if ($filter_value != "NIL"){
			$sql	.= " and mi.`mi_code` like '%$filter_value%'";
		} 
		if ($jobNo != "NIL"){
			$sql	.= " and `job_card`.`job_card_number` = '%$jobNo%'";
		}
		if ($client_id != "NIL"){
			$sql	.= " and `job_card`.client_id = '$client_id'";
		}
		$result =   $this->db->query("SELECT count(mi.`mi_id`) AS `Tcount` FROM `material_issue_h` as mi LEFT JOIN `job_card` ON `job_card`.id= mi.job_id INNER JOIN `new_client_master` ncm on ncm.client_id=`job_card`.client_id WHERE (mi.`status`='1' or mi.`status`='0')  ".$sql);
	 	return ($result->row()->Tcount);
 	}

  	public function miListData($limit, $start,$fromDate,$toDate,$filter_value,$jobNo,$client_id){
		$sql='';
		if($fromDate!='NIL' and $toDate!='NIL') {
			$sql .="  AND mi.`mi_date` between '$fromDate' and '$toDate'  ";
		} else if($fromDate!='NIL' and $toDate=='NIL'){
			$sql .=" and mi.`mi_date`	>=	'$fromDate' ";
		} else if($fromDate=='NIL' and $toDate!='NIL'){
			$sql .=" and mi.`mi_date`	<=	'$toDate' ";
		}

		if ($filter_value != "NIL"){
			$sql	.= " and mi.`mi_code` like '%$filter_value%'";
		} 
		if ($jobNo != "NIL"){
			$sql	.= " and `job_card`.`job_card_number` like '%$jobNo%'";
		}
		if ($client_id != "NIL"){
			$sql	.= " and `job_card`.client_id = '$client_id'";
		}
		
		$query= $this->db->query("SELECT mi.`mi_id`,mi.`mi_number`,mi.`mi_code`,mi.`mi_date`,mi.`payment_mode`,mi.`mi_net_amt`,mi.`status`,`job_card`.job_card_number,ncm.client_name FROM `material_issue_h` as mi LEFT JOIN `job_card` ON `job_card`.id= mi.job_id INNER JOIN `new_client_master` ncm on ncm.client_id=`job_card`.client_id  WHERE (mi.`status`='1' or mi.`status`='0')  ".$sql." order by `mi_id` desc limit ".$start.",".$limit);
		return $query->result();
	}

	public function mr_record_count($fromDate,$toDate,$filter_value,$jobNo,$client_id){
		$sql='';
		if($fromDate!='NIL' and $toDate!='NIL') {
			$sql .="  AND mi.`mr_date` between '$fromDate' and '$toDate'  ";
		} else if($fromDate!='NIL' and $toDate=='NIL'){
			$sql .=" and mi.`mr_date`	>=	'$fromDate' ";
		} else if($fromDate=='NIL' and $toDate!='NIL'){
			$sql .=" and mi.`mr_date`	<=	'$toDate' ";
		}

		if ($filter_value != "NIL"){
			$sql	.= " and mi.`mr_code` like '%$filter_value%'";
		} 
		if ($jobNo != "NIL"){
			$sql	.= " and `job_card`.`job_card_number` = '%$jobNo%'";
		}
		if ($client_id != "NIL"){
			$sql	.= " and `job_card`.client_id = '$client_id'";
		}
		$result =   $this->db->query("SELECT count(mi.`mi_id`) AS `Tcount` FROM `material_return_h` as mi LEFT JOIN `job_card` ON `job_card`.id= mi.job_id INNER JOIN `new_client_master` ncm on ncm.client_id=`job_card`.client_id WHERE (mi.`status`='1' or mi.`status`='0')  ".$sql);
	 	return ($result->row()->Tcount);
 	}

	public function mrListData($limit, $start,$fromDate,$toDate,$filter_value,$jobNo,$client_id){
		$sql='';
		if($fromDate!='NIL' and $toDate!='NIL') {
			$sql .="  AND mi.`mr_date` between '$fromDate' and '$toDate'  ";
		} else if($fromDate!='NIL' and $toDate=='NIL'){
			$sql .=" and mi.`mr_date`	>=	'$fromDate' ";
		} else if($fromDate=='NIL' and $toDate!='NIL'){
			$sql .=" and mi.`mr_date`	<=	'$toDate' ";
		}

		if ($filter_value != "NIL"){
			$sql	.= " and mi.`mr_code` like '%$filter_value%'";
		} 
		if ($jobNo != "NIL"){
			$sql	.= " and `job_card`.`job_card_number` like '%$jobNo%'";
		}
		if ($client_id != "NIL"){
			$sql	.= " and `job_card`.client_id = '$client_id'";
		}
		$query= $this->db->query("SELECT mi.`mr_id`,mi.`mr_number`,mi.`mr_code`,mi.`mr_date`,mi.`payment_mode`,mi.`mr_net_amt`,mi.`status`,`job_card`.job_card_number,ncm.client_name FROM `material_return_h` as mi LEFT JOIN `job_card` ON `job_card`.id= mi.job_id INNER JOIN `new_client_master` ncm on ncm.client_id=`job_card`.client_id    WHERE (mi.`status`='1' or mi.`status`='0')  ".$sql." order by `mr_id` desc limit ".$start.",".$limit);
		return $query->result();
	}

	public function purchaseInvoicelistData($limit, $start,$po_number,$po_date,$supplier_name,$job_no,$division_id,$supplier_id){
		if ($division_id != "NIL"){
			$sql	= " and `purchase_h`.`division_id` = '$division_id'";
		} else {
			//$sql	=	$this->OppLogin->userList("`po_h`.`division_id`");
			$sql	="";
		}
			if ($po_number != "NIL"){
				$sql	.= " and `purchase_h`.`purchase_invoice_code` = '$po_number'";
			}
		if ($po_date != "NIL"){
				$sql	.= " and `purchase_h`.`purchase_date` = '$po_date'";
			}
		if ($supplier_id != "NIL"){
			$sql	.= " and `purchase_h`.`supplier_id`='$supplier_id'";
		}
		if ($job_no != "NIL"){
			$sql	.= " and `job_card`.job_no = '$job_no'";
		}
		$query= $this->db->query("SELECT `purchase_h`.`id`,`purchase_h`.`purchase_no`,`purchase_h`.`purchase_invoice_code`,`purchase_h`.`purchase_date`,`purchase_h`.`payment_mode`,`purchase_h`.`pur_net_amt`,`purchase_h`.`status`,`supplier_master`.`supplier_name`,`job_card`.job_card_number,`purchase_h`.status AS pi_status FROM `purchase_h` JOIN `supplier_master` ON `supplier_master`.`supplier_id`=`purchase_h`.`supplier_id` LEFT JOIN `job_card` ON `job_card`.id= `purchase_h`.job_id WHERE (`purchase_h`.`status`='1' or `purchase_h`.`status`='0')  ".$sql." order by `id` desc limit ".$start.",".$limit);
		return $query->result();
	}
	public function pi_record_count($po_number,$po_date,$supplier_name,$job_no,$division_id,$supplier_id){
		if ($division_id != "NIL"){
			$sql	= " and `purchase_h`.`division_id` = '$division_id'";
		} else {
			//$sql	=	$this->OppLogin->userList("`po_h`.`division_id`");
			$sql	="";
		}
			if ($po_number != "NIL"){
				$sql	.= " and `purchase_h`.`purchase_invoice_code` = '$po_number'";
			}
		if ($po_date != "NIL"){
				$sql	.= " and `purchase_h`.`purchase_date` = '$po_date'";
			}
		if ($supplier_id != "NIL"){
			$sql	.= " and `purchase_h`.`supplier_id`='$supplier_id'";
		}
		if ($job_no != "NIL"){
			$sql	.= " and `job_card`.job_no = '$job_no'";
		}
		$result= $this->db->query("SELECT  count(`purchase_h`.`id`) AS `Tcount` FROM `purchase_h` JOIN `supplier_master` ON `supplier_master`.`supplier_id`=`purchase_h`.`supplier_id` LEFT JOIN `job_card` ON `job_card`.id= `purchase_h`.job_id WHERE (`purchase_h`.`status`='1' or `purchase_h`.`status`='0')  ".$sql );
		return ($result->row()->Tcount);
	}
	public function currency(){
		$query= $this->db->query("SELECT * FROM `currency` where 1 ");
		return $query->result();
	}
	public function purchase_expense(){
		$query= $this->db->query("SELECT * FROM `ledgers` where `acoount_group_id`='5' ");
		return $query->result();
	}
	public function other_expenseData($id){
		$query= $this->db->query("SELECT * FROM `purchase_invoice_other_expense` where `purchase_id`='$id' ");
		return $query->result();
	}
	public function payabel(){
		// OR `acoount_group_id`='4'
		$query= $this->db->query("SELECT * FROM `ledgers` where (`acoount_group_id`='18') ");
		return $query->result();
	}

	public function qouteitemWiseDatarow($quotation_id){
		$result =   $this->db->query("SELECT FI.furniture_id,FI.ex_furniture_area,FI.sub_group_id,FI.item_order FROM `furniture_items` FI WHERE FI.quotation_id='$quotation_id'");
		return ($result->result_array());
	}

	public function jobitemWiseDatarow($job_card_details_id){
		$result =   $this->db->query("SELECT FI.job_card_details_id,FI.sl_no,JC.id as job_id,JC.job_card_number,FI.furniture_area,FI.ex_furniture_area,FI.sub_group,FI.sub_group_id,FI.item_order,FI.furniture_model,FI.furniture_quantity,FI.uom,FI.furniture_description,FI.furniture_comments,FI.vat_perce,FI.image,FQ.quotation_number,FQ.quotation_divisionid,FQ.client_id,FQ.quotation_date,FQ.project_name,FQ.common_comments,NCM.client_name,E.enquiry_number,E.enquiry_date FROM `job_card_details` FI INNER JOIN `job_card` JC on JC.id=FI.job_card_id INNER JOIN `furniture_quotation` FQ ON FQ.id=JC.quotation_id LEFT JOIN `new_client_master` NCM ON NCM.client_id=FQ.client_id LEFT JOIN `enquiry` E ON E.id=FQ.enquiry_id WHERE FI.job_card_details_id='$job_card_details_id'");
		return ($result->row_array());
	}

	public function jobDetailsRow($job_card_id,$sl_no){
		$result =   $this->db->query("SELECT * FROM `job_card_details` WHERE job_card_id='$job_card_id' AND sl_no='$sl_no'");
		return ($result->row_array());
	}

	public function jobestimation($job_card_details_id){
		$result =   $this->db->query("SELECT * FROM `job_estimation` WHERE job_card_details_id='$job_card_details_id'");
		return ($result->row_array());
	}

	public function jobestimationMaterialsAdded($job_card_details_id){
		$result =   $this->db->query("SELECT * FROM `job_estimation_material` WHERE job_card_details_id='$job_card_details_id'");
		return ($result->result_array());
	}

	public function jobestimationLabourCostAdded($job_card_details_id){
		$result =   $this->db->query("SELECT * FROM `job_estimation_labourcost` WHERE job_card_details_id='$job_card_details_id'");
		return ($result->result_array());
	}
	public function jobestimationSubContractAdded($job_card_details_id){
		$result =   $this->db->query("SELECT * FROM `job_estimation_subcontract` WHERE job_card_details_id='$job_card_details_id'");
		return ($result->result_array());
	}
	public function jobestimationHiringAdded($job_card_details_id){
		$result =   $this->db->query("SELECT * FROM `job_estimation_hiring` WHERE job_card_details_id='$job_card_details_id'");
		return ($result->result_array());
	}
	public function jobestimationOthersAdded($job_card_details_id){
		$result =   $this->db->query("SELECT * FROM `job_estimation_others` WHERE job_card_details_id='$job_card_details_id'");
		return ($result->result_array());
	}
	public function joboverhead(){
		$result =   $this->db->query("SELECT * FROM `overhead_table` WHERE status='1' ");
		return ($result->result_array());
	}
	public function loc_list(){
		$user_id	=	$this->session->userdata('user_id');
		$this->db->select('location_master.loc_id,location_master.loc_name');
		$this->db->where('user_id',$user_id);
		$this->db->from('location_permission');
		$this->db->join('location_master','location_permission.loc_id = location_master.loc_id','left');
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			$location_list = $rs->result_array();
		} else {
			$list2 = $this->crud_model->get('location_master',array());
			$location_list = $list2;
		}
		return $location_list;
	}

	public function insert_item_trans_data($trans_no,$item_id,$trans_date,$trans_type,$item_qty,$loc_id,$item_rate,$item_amount){
		$user_id	=	$this->session->userdata('user_id');
		$item_trans_array = array(
			'trans_no' 	  => $trans_no,
			'item_id'  	  => $item_id,
			'trans_date'  => $trans_date,
			'trans_type'  => 1,
			'item_qty' 	  => $item_qty,
			'loc_id' 	  => $loc_id,
			'item_rate'   => $item_rate,
			'item_amount' => $item_amount,
			'user_id' 	  => $user_id,
			'created_date'=> date("Y-m-d"),
			'status'      => 1
		);
		$this->db->insert('item_trans', $item_trans_array);

		$this->db->select('items.last_purchase_date');
		$this->db->where('id',$item_id);
		$this->db->from('items');
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			$data = $rs->result_array();
			if($data[0]['last_purchase_date']<=$trans_date){
				$update_data = array(
					'last_purchase_rate' => round($item_rate,3),
					'last_purchase_date' => $trans_date,
					'last_purchase_supplier' => $this->input->post('supplier_code'),
				);			
				$where= array('id'=>$item_id);
				$this->crud_model->update('items',$update_data,$where );
			}
		}
	}
	public function update_other_expense($pur_h_id){
		$rs = $this->crud_model->get('purchase_b',array('pur_h_id'=>$pur_h_id));
		$dbdata             = $this->editPurchaseInvoiceRow($pur_h_id);
		if($rs != false){
			$this->db->where("trans_no",$dbdata->purchase_invoice_code);
			$this->db->where("trans_type",'1');
			$this->db->delete('item_trans');

			$this->db->where("vch_no",$dbdata->purchase_invoice_code);
			$this->db->where("vch_type",'PURCHASE');
			$this->db->delete('accounts');

			$po_gross_amt=0;
			$po_vat_amt=0;
			$po_net_amt=0;
			$po_discount=0;
			$pu_amnt	=	$this->input->post('gross_amount')-(int)$this->input->post('discount_bd');
			$total_other_expense = $this->input->post('total_other_expense');
			foreach($rs as $furniture_item ) {
				$pur_det_id	=	$furniture_item['pur_det_id'];
				$lcost=(($furniture_item['item_amt']-$furniture_item['item_disc_amt'])/$pu_amnt)*$total_other_expense;
				$tcost=$lcost+$furniture_item['item_amt'];
				$update_data = array(
					'lcost' 		=> round($lcost,3),
					'tcost' 		=> round($tcost,3)
				);			
				$where= array('pur_det_id'=>$pur_det_id);
				$this->crud_model->update('purchase_b',$update_data,$where );
				//$this->insert_item_trans_data($dbdata->purchase_invoice_code,$furniture_item['item_h_id'],$dbdata->purchase_date,1,$furniture_item['item_qty'],$dbdata->loc_id,$tcost,round($furniture_item['item_qty']*$tcost,3));
			}
		}
	}

	public function update_other_expense_2($pur_h_id,$nbs){
		$rs = $this->crud_model->get('purchase_b',array('pur_h_id'=>$pur_h_id));
		$dbdata             = $this->editPurchaseInvoiceRow($pur_h_id);
		if($rs != false){
			$this->db->where("trans_no",$dbdata->purchase_invoice_code);
			$this->db->where("trans_type",'1');
			$this->db->delete('item_trans');

			$this->db->where("vch_no",$dbdata->purchase_invoice_code);
			$this->db->where("vch_type",'PURCHASE');
			$this->db->delete('accounts');
			$po_gross_amt=0;
			$po_vat_amt=0;
			$po_net_amt=0;
			$po_discount=0;
			$pu_amnt	=	$dbdata->pur_amt;
			$total_other_expense = $this->input->post('total_other_expense');
			$largevalue=0;
			$xxlcost=0;
			$updated_id='';
			$aplcost='';
			foreach($rs as $furniture_item ) {
				if($largevalue<$furniture_item['item_amt']){
					$largevalue=$furniture_item['item_amt'];
					$updated_id	=	$furniture_item['pur_det_id'];
					$aplcost=(($furniture_item['item_amt'])/$pu_amnt)*$total_other_expense;
				}
				$pur_det_id	=	$furniture_item['pur_det_id'];
				$lcost=(($furniture_item['item_amt'])/$pu_amnt)*$total_other_expense;
				$xxlcost=$xxlcost+round($lcost,3);
				//echo $xxlcost.','.$furniture_item['item_amt'].')/'.$pu_amnt.')*'.$total_other_expense.'<br>';
				$tcost=$lcost+$furniture_item['item_amt'];
				$update_data = array(
					'lcost' 		=> round($lcost,3),
					'tcost' 		=> round($tcost,3)
				);			
				$where= array('pur_det_id'=>$pur_det_id);
				$this->crud_model->update('purchase_b',$update_data,$where );
			}
			if($xxlcost!=$total_other_expense){
				$diff=$total_other_expense-$xxlcost;
				$where2= array('pur_det_id'=>$updated_id);
				$update_data2 = array(
					'lcost' 		=> round($aplcost+$diff,3),
					'tcost' 		=> round($aplcost+$largevalue+$diff,3)
				);
				$this->crud_model->update('purchase_b',$update_data2,$where2 );
			}
		}
	}

	public function insert_into_item_trans($pur_h_id){
		$rs = $this->crud_model->get('purchase_b',array('pur_h_id'=>$pur_h_id));
		$dbdata             = $this->editPurchaseInvoiceRow($pur_h_id);
		$user_id	=	$this->session->userdata('user_id');
		if($rs != false){
			$this->db->where("trans_no",$dbdata->purchase_invoice_code);
			$this->db->where("trans_type",'1');
			$this->db->delete('item_trans');

			$this->db->where("vch_no",$dbdata->purchase_invoice_code);
			$this->db->where("vch_type",'PURCHASE');
			$this->db->delete('accounts');
			$pu_amnt	=	$dbdata->pur_amt;

			$sup_rev_ledger_code='';
			$count=0;

			$this->db->where("vch_no",$dbdata->purchase_invoice_code);
			$this->db->where("vch_type",'Purchase Invoice');
			$this->db->delete('job_allocation');
			if($this->input->post('payment_mode')==='Cash'){
				$supplier_code=$this->input->post('header_ledger_code');
			} else {
				$supplier_code=$this->input->post('supplier_code');
			}
			//item trans data start
			foreach($rs as $furniture_item ) {
				if($furniture_item['b_uom']!=$furniture_item['uom_id']){
					$b_uom_conv=$furniture_item['b_uom_conv'];
				} else {
					$b_uom_conv=1;
				}
				/* if($furniture_item['lcost']===NUll OR $furniture_item['lcost']==='0.000'){
					if($furniture_item['total_discount_item_wise']!=NULL){
						$item_rate=(($furniture_item['item_qty']*$furniture_item['item_rate'])-($furniture_item['item_disc_amt']+$furniture_item['total_discount_item_wise']))/$furniture_item['item_qty'];
						$item_amount=$item_rate*$furniture_item['item_qty'];
					} else {
						
						$item_rate=(($furniture_item['item_qty']*$furniture_item['item_rate'])-$furniture_item['item_disc_amt'])/$furniture_item['item_qty'];
						//$item_rate=($furniture_item['item_fx_rate']/$furniture_item['b_uom_qty']);
						$item_amount=$item_rate*$furniture_item['b_uom_qty'];
					}
					
				} else {
					if($furniture_item['total_discount_item_wise']!=NULL){
						$ttt=(($furniture_item['item_qty']*$furniture_item['item_rate'])-($furniture_item['item_disc_amt']+$furniture_item['total_discount_item_wise']))/$furniture_item['item_qty'];
					} else{
						$ttt=(($furniture_item['item_qty']*$furniture_item['item_rate'])-$furniture_item['item_disc_amt'])/$furniture_item['item_qty'];
					}
					$item_rate=$furniture_item['tcost']/$furniture_item['item_qty'];
					$item_amount=$furniture_item['tcost'];
				} */
				if($furniture_item['lcost']===NUll OR $furniture_item['lcost']==='0.000'){
					$b_uom_rate=$furniture_item['b_uom_rate'];
					$item_amount=$furniture_item['b_uom_qty']*$furniture_item['b_uom_rate'];
				} else {
					$tcost=$furniture_item['tcost']/$furniture_item['item_qty'];
					if($furniture_item['b_uom']!=$furniture_item['uom_id']){
						$b_uom_conv=$furniture_item['b_uom_conv'];
					} else {
						$b_uom_conv=1;
					}
					$b_uom_rate=$tcost/(1/$b_uom_conv);
					$item_amount=$furniture_item['b_uom_qty']*$b_uom_rate;
					$update_dataaa = array(
						'b_uom_rate' 		=> round($b_uom_rate,3)
					);			
					$where= array('pur_det_id'=>$furniture_item['pur_det_id']);
					$this->crud_model->update('purchase_b',$update_dataaa,$where );
				}
				//if($dbdata->pi_type==='Inventory'){
					//$this->insert_item_trans_data($dbdata->purchase_invoice_code,$furniture_item['item_h_id'],$dbdata->purchase_date,1,$furniture_item['item_qty'],$dbdata->loc_id,$item_rate,round($item_amount,3));
					$this->insert_item_trans_data($dbdata->purchase_invoice_code,$furniture_item['item_h_id'],$dbdata->purchase_date,1,$furniture_item['b_uom_qty'],$dbdata->loc_id,$b_uom_rate,round($item_amount,3));
				//}
				if($dbdata->job_id!='' && $dbdata->job_id!='0'){
					$job_allocation_data = array(
						'vch_type'    => 'Purchase Invoice',
						'vch_no'      => $dbdata->purchase_invoice_code,
						'vch_date'    => $dbdata->purchase_date,
						'job_id'      => $dbdata->job_id,
						'ledger_code' => $furniture_item['pu_ledger_code'],
						'ledger_amount' => round($item_amount,3),
						'created_date'=> date('Y-m-d'),
						'user_id' 	  => $this->session->userdata("user_id"),
						'status'	  => 1
					);
					$this->db->insert('job_allocation', $job_allocation_data);
				}
			}

			$rs = $this->crud_model->get('purchase_b',array('pur_h_id'=>$pur_h_id));
			$this->db->select('sum(item_qty*item_rate)-sum(item_disc_amt) as pu_amnt,pu_ledger_code');
			$this->db->from('purchase_b');
			$this->db->where('pur_h_id',$pur_h_id);
			$this->db->group_by('pu_ledger_code');
			$aaquery = $this->db->get();
			$aadata = $aaquery->result_array();
			foreach ($aadata as $key => $value) {
				$accounts_data2[] = array(
					'vch_type' 	  => 'PURCHASE',
					'vch_no'  	  => $dbdata->purchase_invoice_code,
					'vch_date'    => $dbdata->purchase_date,
					'vch_ref'     => $dbdata->supplier_reference,
					'ledger_code' => $value['pu_ledger_code'],
					'rev_ledger_code' => $supplier_code,
					'cc_code' 	  => 1,
					'div_code' 	  => 1,
					'ledger_amount'=> $value['pu_amnt'],
					'vch_narration'=> 'Auto entry from Purchase No '.$dbdata->purchase_invoice_code,
					'user_id' 	  => $user_id,
					'status'      => 1
				);
				if($count==0){
					$sup_rev_ledger_code=$furniture_item['pu_ledger_code'];
					$count++;
				}
			}
			//item trans data end
			//accounts data start
			if($supplier_code!=''){
				$this->db->where("vch_no",$dbdata->purchase_invoice_code);
				$this->db->where("vch_type",'PURCHASE');
				$this->db->delete('accounts');
				$accounts_data = array(
					'vch_type' 	  => 'PURCHASE',
					'vch_no'  	  => $dbdata->purchase_invoice_code,
					'vch_date'    => $dbdata->purchase_date,
					'vch_ref'     => $dbdata->supplier_reference,
					'ledger_code' => $supplier_code,
					'rev_ledger_code' => $sup_rev_ledger_code,
					'cc_code' 	  => 1,
					'div_code' 	  => 1,
					'ledger_amount'  => -$dbdata->pur_net_amt,
					'vch_narration'=> 'Auto entry from Purchase No '.$dbdata->purchase_invoice_code,
					'user_id' 	  => $user_id,
					'status'      => 1
				);
				$this->db->insert('accounts', $accounts_data);

				$this->db->where("trn_no",$dbdata->purchase_invoice_code);
				$this->db->where("trn_type",'Purchase Invoice');
				$this->db->delete('supplier_bill_allocations');
				if($this->input->post('payment_mode')!=='Cash'){
					$supplier_bill_allocations_data = array(
						'supplier_code'  => $this->input->post('supplier_code'),
						'bill_id'        => $pur_h_id,
						'trn_no'       	 => $dbdata->purchase_invoice_code,
						'bill_date'      => $dbdata->purchase_date,
						'bill_amt'       => $dbdata->pur_net_amt,
						'bill_os_amount' => $dbdata->pur_net_amt,
						'division_id' 	 => $dbdata->division_id,
						'bill_type'      => 'Purchase Invoice',
						'trn_type'       => 'Purchase Invoice'
					);
					$this->db->insert('supplier_bill_allocations',$supplier_bill_allocations_data);
				}

				$this->db->insert_batch('accounts', $accounts_data2);
				
				if($dbdata->pur_vat>0){
					$accounts_data = array(
						'vch_type' 	  => 'PURCHASE',
						'vch_no'  	  => $dbdata->purchase_invoice_code,
						'vch_date'    => $dbdata->purchase_date,
						'vch_ref'     => $dbdata->supplier_reference,
						'ledger_code' => 'V0002',
						'rev_ledger_code' => $supplier_code,
						'cc_code' 	  => 1,
						'div_code' 	  => 1,
						'ledger_amount'   => $dbdata->pur_vat,
						'vch_narration'=> 'Auto entry from Purchase No '.$dbdata->purchase_invoice_code,
						'user_id' 	  => $user_id,
						'status'      => 1
					);
					$this->db->insert('accounts', $accounts_data);
				}
				
				if($this->input->post('discount_bd')!='' && $this->input->post('discount_bd')!='0'){
					$accounts_data = array(
						'vch_type' 	  => 'PURCHASE',
						'vch_no'  	  => $dbdata->purchase_invoice_code,
						'vch_date'    => $dbdata->purchase_date,
						'vch_ref'     => $dbdata->supplier_reference,
						'ledger_code' => 'D0001',
						'rev_ledger_code' => $supplier_code,
						'cc_code' 	  => 1,
						'div_code' 	  => 1,
						'ledger_amount'   => -$dbdata->pur_discount,
						'vch_narration'=> 'Auto entry from Purchase No '.$dbdata->purchase_invoice_code,
						'user_id' 	  => $user_id,
						'status'      => 1
					);
					$this->db->insert('accounts', $accounts_data);
				}
				if($this->input->post('round_off')!='' && $this->input->post('round_off')!='0.000'){
					$accounts_data = array(
						'vch_type' 	  => 'PURCHASE',
						'vch_no'  	  => $dbdata->purchase_invoice_code,
						'vch_date'    => $dbdata->purchase_date,
						'vch_ref'     => $dbdata->supplier_reference,
						'ledger_code' => 'R0001',
						'rev_ledger_code' => $supplier_code,
						'cc_code' 	  => 1,
						'div_code' 	  => 1,
						'ledger_amount'   => $dbdata->sign.$dbdata->round_off,
						'vch_narration'=> 'Auto entry from Purchase No '.$dbdata->purchase_invoice_code,
						'user_id' 	  => $user_id,
						'status'      => 1
					);
					$this->db->insert('accounts', $accounts_data);
				}
				$pioe = $this->crud_model->get('purchase_invoice_other_expense',array('purchase_id'=>$pur_h_id));
				if($pioe != false){
					foreach($pioe as $row ) {
						$accounts_data = array(
							'vch_type' 	  => 'PURCHASE',
							'vch_no'  	  => $dbdata->purchase_invoice_code,
							'vch_date'    => $dbdata->purchase_date,
							'vch_ref'     => $dbdata->supplier_reference,
							'ledger_code' => $row['purchase_expense_id'],
							'rev_ledger_code' => $supplier_code,
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'   => $row['amount'],
							'vch_narration'=> 'Auto entry from Purchase No '.$dbdata->purchase_invoice_code,
							'user_id' 	  => $user_id,
							'status'      => 1
						);
						$this->db->insert('accounts', $accounts_data);
						$accounts_data = array(
							'vch_type' 	  => 'PURCHASE',
							'vch_no'  	  => $dbdata->purchase_invoice_code,
							'vch_date'    => $dbdata->purchase_date,
							'vch_ref'     => $dbdata->supplier_reference,
							'ledger_code' => $row['payable_id'],
							'rev_ledger_code' => $supplier_code,
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'   => -$row['amount'],
							'vch_narration'=> 'Auto entry from Purchase No '.$dbdata->purchase_invoice_code,
							'user_id' 	  => $user_id,
							'status'      => 1
						);
						$this->db->insert('accounts', $accounts_data);
					}
				}
			}
			//accounts data end
		}
	}

	function get_all_purchase_invoice(){
		if(isset($_REQUEST['ttttt'])){
			if($this->input->post('filter_value')!=""){
				$this->db->like('purchase_invoice_code',$this->input->post('filter_value'));
			}
			if($this->input->post('type')!="All"){
				$this->db->like('pi_type',$this->input->post('type'));
			}
			$fromDate=$this->input->post('fromDate');
			$toDate=$this->input->post('toDate');
			if($fromDate!='' and $toDate!='') {
				$date2 = str_replace('/', '-', $this->input->post("fromDate"));
				$date3 = str_replace('/', '-', $this->input->post("toDate"));
				$fromDate =   date("Y-m-d", strtotime($date2));
				$toDate =   date("Y-m-d", strtotime($date3));
				$this->db->where('purchase_date >=', $fromDate);
				$this->db->where('purchase_date <=', $toDate);
			} else if($fromDate!='' and $toDate==''){
				$date2 = str_replace('/', '-', $this->input->post("fromDate"));
				$fromDate =   date("Y-m-d", strtotime($date2));
				$this->db->where('purchase_date >=', $fromDate);
			} else if($fromDate=='' and $toDate!=''){
				$date3 = str_replace('/', '-', $this->input->post("toDate"));
				$toDate =   date("Y-m-d", strtotime($date3));
				$this->db->where('purchase_date <=', $toDate);
			}
		}

		$this->db->select('`purchase_h`.`id`,`purchase_h`.`purchase_no`,`purchase_h`.`purchase_invoice_code`,`purchase_h`.`pi_type`,`purchase_h`.`purchase_date`,`purchase_h`.`payment_mode`,`purchase_h`.`pur_net_amt`,`purchase_h`.`status`,`supplier_master`.`supplier_name`,`job_card`.job_card_number,`purchase_h`.status AS pi_status' );
		$this->db->from('purchase_h');
		$this->db->join('supplier_master','purchase_h.supplier_id = supplier_master.supplier_id','inner');
		$this->db->join('job_card','purchase_h.job_id = job_card.id','left');
		$this->db->limit(200);
		$this->db->order_by("purchase_h.id","desc");
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}else{
			return false;
		}
	}

	function getItem($client){

		$this->db->query("SET SQL_BIG_SELECTS=1"); 
		$this->db->select('*' );
		$this->db->from('view_get_purchase_cost');
		if($client!=''){
			$this->db->like('view_get_purchase_cost.item_name', $client);
		}
		$this->db->limit(25);
		$this->db->order_by("view_get_purchase_cost.item_name","desc");
		$rs = $this->db->get();
		return $rs->result_array();
	}

	
	public function purchaseRequestNumber($division_id){
		$query= $this->db->query("SELECT max(`pr_number`) as `pr_number` FROM `purchase_request` WHERE division_id='$division_id'");
		return $query->row()->pr_number+1;
	}

	public function get_purchase_request_no($no,$division_id=0){
		if($division_id!=0){
			$query= $this->db->query("SELECT * FROM  `company_division` WHERE division_id='$division_id' ");
			$division_code=$query->row()->division_code;
		} else {
			$division_code='';
		}
		$purchase_request_no='PR-'.sprintf("%'.04d",$no).'-'.$division_code;
		return $purchase_request_no;
	}

	function get_all_purchase_request(){
		if(isset($_REQUEST['ttttt'])){
			if($this->input->post('filter_value')!=""){
				$this->db->like('`purchase_request`.`pr_code`',$this->input->post('filter_value'));
			}
			if($this->input->post('type')!="All"){
				$this->db->like('`purchase_request`.`pr_type`',$this->input->post('type'));
			}
			if($this->input->post('jobNo')!=""){
				$this->db->like('`job_card`.job_card_number',$this->input->post('jobNo'));
			}
			
			$fromDate=$this->input->post('fromDate');
			$toDate=$this->input->post('toDate');
			if($fromDate!='' and $toDate!='') {
				$date2 = str_replace('/', '-', $this->input->post("fromDate"));
				$date3 = str_replace('/', '-', $this->input->post("toDate"));
				$fromDate =   date("Y-m-d", strtotime($date2));
				$toDate =   date("Y-m-d", strtotime($date3));
				$this->db->where('`purchase_request`.`pr_date` >=', $fromDate);
				$this->db->where('`purchase_request`.`pr_date` <=', $toDate);
			} else if($fromDate!='' and $toDate==''){
				$date2 = str_replace('/', '-', $this->input->post("fromDate"));
				$fromDate =   date("Y-m-d", strtotime($date2));
				$this->db->where('`purchase_request`.`pr_date` >=', $fromDate);
			} else if($fromDate=='' and $toDate!=''){
				$date3 = str_replace('/', '-', $this->input->post("toDate"));
				$toDate =   date("Y-m-d", strtotime($date3));
				$this->db->where('`purchase_request`.`pr_date` <=', $toDate);
			}
		}
		
		$this->db->select('purchase_request.*,job_card.job_card_number,po_h.po_number,new_client_master.client_name,job_card.job_card_number,po_h.po_number,job_card.project_name,po_h.status as po_status');
		$this->db->from('purchase_request');
		$this->db->join('job_card','job_card.id = purchase_request.job_id','left');
		$this->db->join('new_client_master','new_client_master.client_id = job_card.client_id','left');
		$this->db->join('po_h','po_h.pr_id = purchase_request.pr_id','left');
		$status = array('Draft','Confirmed','Rate Updated','Cancel');
		$this->db->where_in('purchase_request.`status`', $status);
		$this->db->limit(200);
		$this->db->group_by("pr_id");
		$this->db->order_by("pr_id","desc");
		
		$rs = $this->db->get();
		//echo $this->db->last_query().'<br>';
		if($rs->num_rows() > 0) {
			return $rs->result();
		} else {
			return array();
		}
	}


	public function purchaseRequestRow($id){
		$query= $this->db->query("SELECT `purchase_request`.`pr_id`,`purchase_request`.`pr_type`,`purchase_request`.`pr_number`,`purchase_request`.`pr_code`,`purchase_request`.`division_id`,`purchase_request`.`job_id`,`purchase_request`.`rfq_number`,`purchase_request`.`dep_id`,`purchase_request`.`user_id`,`purchase_request`.`pr_date`,`purchase_request`.`status`,`job_card`.`job_card_number`,`job_card`.`project_name`,`users`.user_name,`NCM`.`client_name`,`NCM`.`client_telephone1`,`department_master`.`department_name` FROM `purchase_request` JOIN `department_master`ON `department_master`.`department_id`=`purchase_request`.`dep_id`  JOIN `users`ON `users`.`user_id`=`purchase_request`.`user_id` LEFT JOIN `job_card` ON `job_card`.`id`=`purchase_request`.`job_id` LEFT JOIN new_client_master NCM ON NCM.client_id=job_card.client_id WHERE `purchase_request`.`pr_id`='$id'");
		return $query->row();
	}

	public function purchaseRequestDetails($id){
		$query= $this->db->query("SELECT * FROM `purchase_request_details` WHERE `purchase_request_details`.`pr_id`='$id'");
		return $query->result_array();
	}

	function saListData(){
		if(isset($_REQUEST['ttttt'])){
			if($this->input->post('filter_value')!=""){
				$this->db->like('`stock_adjustment_h`.`sa_code`',$this->input->post('filter_value'));
			}

			$fromDate=$this->input->post('fromDate');
			$toDate=$this->input->post('toDate');
			if($fromDate!='' and $toDate!='') {
				$date2 = str_replace('/', '-', $this->input->post("fromDate"));
				$date3 = str_replace('/', '-', $this->input->post("toDate"));
				$fromDate =   date("Y-m-d", strtotime($date2));
				$toDate =   date("Y-m-d", strtotime($date3));
				$this->db->where('`stock_adjustment_h`.`sa_date` >=', $fromDate);
				$this->db->where('`stock_adjustment_h`.`sa_date` <=', $toDate);
			} else if($fromDate!='' and $toDate==''){
				$date2 = str_replace('/', '-', $this->input->post("fromDate"));
				$fromDate =   date("Y-m-d", strtotime($date2));
				$this->db->where('`stock_adjustment_h`.`sa_date` >=', $fromDate);
			} else if($fromDate=='' and $toDate!=''){
				$date3 = str_replace('/', '-', $this->input->post("toDate"));
				$toDate =   date("Y-m-d", strtotime($date3));
				$this->db->where('`stock_adjustment_h`.`sa_date` <=', $toDate);
			}
		}
		
		$this->db->select('*');
		$this->db->from('stock_adjustment_h');
		$status = array('1','0');
		$this->db->where_in('stock_adjustment_h.`status`', $status);
		$this->db->limit(200);
		$this->db->order_by("sa_id","desc");
		$rs = $this->db->get();
		if($rs->num_rows() > 0) {
			return $rs->result();
		} else {
			return array();
		}
	}

	public function getUombaseDivisionwiseItemprice($item_id,$div_id,$uom_id){
		$query	= $this->db->query("SELECT * FROM `item_price` WHERE `division_id` = '$div_id' AND `item_id` = '$item_id' AND `item_price_status` = 1 ");
		 
		if($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return false;
		}
	}

	public function getmaxQuanity($job_id, $jb_dtl_id){
		$this->db->select('item_qty');
		$this->db->from('quotation_items');
		$this->db->where('job_id',$job_id);
		$this->db->where('job_detail_id',$jb_dtl_id);
		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function getMaterialissueRow($id){
		$this->db->select('*');
		$this->db->from('material_issue_h');
		$this->db->where('mi_number',$id);
		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}
	public function getMaterialissuebdata($mi_id){
		$this->db->select('*');
		$this->db->from('material_issue_b');
		$this->db->where('mi_id',$mi_id);
		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	public function getMaterialissueJobdata($jb_id){
		$this->db->select('*');
		$this->db->from('job_card_details');
		$this->db->where('job_card_details_id',$jb_id);
		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function getMaterialissuebRowdata($mi_id,$mi_b_id,$job_detail_id){
		$this->db->select('*');
		$this->db->from('material_issue_b');
		$this->db->where('mi_b_id',$mi_b_id);
		$this->db->where('mi_id',$mi_id);
		$this->db->where('job_detail_id',$job_detail_id);
		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function purchaseOrderItemDesc($po_b_id){
		$this->db->select('item_description');
		$this->db->from('po_b');
		$this->db->where('po_b_id',$po_b_id);
		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function getjobItemtTotalOrderQuantity($job_id){
		$this->db->select_sum('furniture_quantity');
		$this->db->from('furniture_items');
 		$this->db->where('job_id', $job_id);
 		$this->db->where('issue_type', 'order');
		$this->db->where('quotation_status', 'Approved');
		$this->db->group_by('job_id');
		$rs = $this->db->get();
		if ($rs->num_rows() > 0) {
			return $rs->row()->furniture_quantity;
	    } else {
		   return false;
	    }
 	}

	public function getpurchaseTotalOrderQuantity($job_id){
		$this->db->select_sum('item_qty');
		$this->db->from('po_b');
		$this->db->where('job_id',$job_id);
		$rs = $this->db->get();
		if ($rs->num_rows() > 0) {
			return $rs->row()->item_qty;
	    } else {
		   return false;
	    }
	}

	public function getjobItemtTotalStockQuantity($job_id){
		$this->db->select_sum('furniture_quantity');
		$this->db->from('furniture_items');
 		$this->db->where('job_id', $job_id);
 		$this->db->where('issue_type', 'stock');
		$this->db->where('quotation_status', 'Approved');
		$this->db->group_by('job_id');
		$rs = $this->db->get();
		if ($rs->num_rows() > 0) {
			return $rs->row()->furniture_quantity;
	    } else {
		   return false;
	    }
 	}

	public function getmaterialstockQuantity($job_id){
		$this->db->select_sum('item_qty','stock_total');
		$this->db->from('material_issue_b as MB');
		$this->db->join('material_issue_h as MH', 'MH.mi_id  = MB.mi_id', 'LEFT');
		$this->db->where('MH.job_id',$job_id );
		$this->db->where('MH.status', 1);
		$rs = $this->db->get();
 		if ($rs->num_rows() > 0) {
			return $rs->row()->stock_total;
	    } else {
		   return false;
	    }
	}
}
?>