<?php
class Vehicle extends CI_Model {

	function __construct()
	{
		// Call the Model constructor
		parent::__construct();
	}

	public function save($data){
		$this->db->trans_begin();
        $this->db->insert('make', $data);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return false;
		} else {
			$this->db->trans_commit();
			return true;
			//return $this->db->insert_id();
	   }
	}

	public function getMake(){
		
		$this->db->select('*');
		$this->db->from('make');
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function Updatemake($data){
		$id  = $this->input->post('make_id');
		$this->db->trans_begin();
		$this->db->where('id', $id);
		$this->db->update('make', $data);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return false;
		}
		else{
			$this->db->trans_commit();
			return true;
		}
	}
	
	public function getModel(){
		$this->db->select('*');
		$this->db->from('model');
		$this->db->order_by('make_id' ,'ASC');
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	public function saveModel($data){
		$this->db->trans_begin();
        $this->db->insert('model', $data);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return false;
		} else {
			$this->db->trans_commit();
			return true;
	   }
	}
	public function Updatemodel($data){
		$id  = $this->input->post('make_id');
		$this->db->trans_begin();
		$this->db->where('id', $id);
		$this->db->update('model', $data);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return false;
		}
		else{
			$this->db->trans_commit();
			return true;
		}
	}
	public function insertregistration($data){
		$this->db->trans_begin();
        $this->db->insert('reg_no_table', $data);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return false;
		} else {
			$this->db->trans_commit();
			return true;
			//return $this->db->insert_id();
	   }
	}
		
	public function  getRegistration(){
		$client_id       = $this->input->post('search_client_id');
		$search_reg_no   = $this->input->post('search_reg_no');
		$make_search_id  = $this->input->post('make_search_id');
		$model_search    = $this->input->post('model_search');
		$sql = "" ;
		if($client_id != ''){
			//$where = "client_id = $client_id";
			$sql =	$this->db->where('client_id',$client_id);
		}
		if($search_reg_no != ''){
			$sql =	$this->db->where('reg_no',$search_reg_no);
		}
		if($make_search_id != ''){
			$sql =	$this->db->where('make_id',$make_search_id);
		}
		if($model_search != ''){
			$sql =	$this->db->where('model_id',$model_search);
		}
		$this->db->select('*');
		$this->db->from('reg_no_table');
		$sql;
		$this->db->order_by('reg_no_id' ,'DESC');
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	public function getUpdateRegi($reg_no_id){
		$this->db->select('*');
		$this->db->from('reg_no_table');
		$this->db->where('reg_no_id', $reg_no_id);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}			
	}
	public function  getCustomer(){
		$this->db->select('*');
		$this->db->from('new_client_master');
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	public function  getnewCustomer(){
		$this->db->select('*');
		$this->db->from('new_client_master');
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getregisterModel($make_id){
		$this->db->select('*');
		$this->db->from('model');
		$this->db->where('make_id', $make_id);
		$rs = $this->db->get();
	 
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	public function Updateregistration($data){
		$id  = $this->input->post('reg_no_id');
		$this->db->trans_begin();
		$this->db->where('reg_no_id', $id);
		$this->db->update('reg_no_table', $data);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return false;
		}
		else{
			$this->db->trans_commit();
			return true;
		}
	}
	public function Updatenameregistration($data){
		$id  = $this->input->post('reg_no');
		$this->db->trans_begin();
		$this->db->where('reg_no', $id);
		$this->db->update('reg_no_table', $data);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return false;
		}
		else{
			$this->db->trans_commit();
			return true;
		}
	}

	/*public function UpdateVRegistrationInJobcard($jobcarddata){
		$client  = $this->input->post('client_id');
		$reg_no  = $this->input->post('reg_no');
		$this->db->select('*');
		$this->db->where('client_id',$client);
		$this->db->where('reg_no',$reg_no);
		$this->db->from('job_card');
		$rs = $this->db->get();
 		//exit();
		if($rs->num_rows() > 0){

			$this->db->trans_begin();
			$this->db->where('client_id', $client);
			$this->db->where('reg_no', $reg_no);
			$this->db->update('job_card', $jobcarddata);
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
			}
			else{
				$this->db->trans_commit();
			}
		}
	}*/

	public function make(){
        $query= $this->db->query("SELECT * FROM `make` WHERE status='1' ");
		return $query->result();
    }
	public function model($make_id){
        $query= $this->db->query("SELECT * FROM `model` where `make_id`='$make_id' ");
	return $query->result();
    }
	public function dataRow($id){
        $query= $this->db->query("SELECT 
									RNT.`reg_no_id`,
									RNT.`reg_no`,
									RNT.`make_id`,
									RNT.`model_id`,
									RNT.`client_id`,
									RNT.`car_year`,
									RNT.`car_color`,
									RNT.`chassi_number`,
									RNT.`radio_code`,
									RNT.`key_number`,
									MK.`title` AS v_make,
									MD.`title` AS v_model,
									CM.`client_name`,
									CM.`client_telephone1`,
									CM.`client_address` FROM `reg_no_table` RNT 
									INNER JOIN `make` MK ON MK.id=RNT.`make_id` 
									INNER JOIN `model` MD ON MD.id=RNT.`model_id` 
									LEFT JOIN `new_client_master` CM ON CM.`client_id`= RNT.`client_id` WHERE RNT.`reg_no_id`='$id'");
									 
	return $query->row();
    }
	public function getdivision(){	
		$this->db->select('*');
		$this->db->from('company_division');
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	public function getsection(){	
		$this->db->select('*');
		$this->db->from('section_master');
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	public function getstaffdetail(){
		$this->db->select('*');
		$this->db->from('staff_master');
		$this->db->where('status', 1);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function insertStaff($data){
		$this->db->trans_begin();
        $this->db->insert('staff_master', $data);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return false;
		} else {
			$this->db->trans_commit();
			return true;
			  $this->db->insert_id();
	   }
	}

	public function getstaffdata($id){
		$this->db->select('*');
		$this->db->from('staff_master');
		$this->db->where('status', 1);
		$this->db->where('staff_id', $id);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function updatetStaff($data){
		$id  = $this->input->post('staff_id');
		$this->db->trans_begin();
		$this->db->where('staff_id', $id);
		$this->db->update('staff_master', $data);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return false;
		}
		else{
			$this->db->trans_commit();
			return true;
		}
	}

	public function getServiceStaff(){
		$this->db->select('*');
		$this->db->from('staff_master');
		$this->db->where('type', 2);
		$this->db->where('status', 1);
		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	public function getAdvisorStaff(){
		$this->db->select('*');
		$this->db->from('staff_master');
		$this->db->where('type', 1);
		$this->db->where('status', 1);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}



	public function insertjobcard($data){
		$this->db->trans_begin();
		$this->db->insert('job_card', $data);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return false;
		} else {
			$this->db->trans_commit();
			return $this->db->insert_id();
		}
	}


	public function insertjobcarddetail($data){
		$this->db->trans_begin();
        $this->db->insert('job_card_details', $data);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return false;
		} else {
			$this->db->trans_commit();
			 return true;
	   }
	}

	public function insertfurnitureItem($data){
		$this->db->trans_begin();
        $this->db->insert('furniture_items', $data);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return false;
		} else {
			$this->db->trans_commit();
			 return true;
	   }
	}
    
	public function getMVjobcard(){
		$this->db->select('*');
		$this->db->from('job_card');
		$this->db->order_by('job_card_number','DESC');
		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	// public function getVjobcard($status){
	// 	$jbno = $this->input->post('jbno');
	// 	$reg_number = $this->input->post('reg_number');
	// 	$client_id = $this->input->post('client_id');
	// 	$user_id = $this->session->userdata('user_id');
	// 	$sql = "" ;
	// 	if(!empty($jbno)){
	// 		$sql = $this->db->like('job_card_number', $jbno, 'before');
	// 	}		
	// 	if(!empty($reg_number)){
	// 		$sql = $this->db->where('reg_no', $reg_number);
	// 	}
	// 	if(!empty($client_id)){
	// 		$sql = $this->db->where('client_id', $client_id);
	// 	}
	// 	if(!empty($status)){
	// 		if($status == 'Draft'){
	// 			$sql = $this->db->where('job_card_status', 'Draft');
	// 		}
	// 		else if($status == 'Cancelled'){
	// 			$sql = $this->db->where('job_card_status', 'Cancelled');
	// 		}
	// 		else if($status == 'Completed'){
	// 			$sql = $this->db->where('job_card_status', 'Completed');
	// 		}
	// 		else if($status == 'Requested'){
	// 			$sql = $this->db->where('disc_req_to', $user_id);				 
	// 		}			
	// 	}
	// 	$this->db->select('*');
	// 	$this->db->from('job_card');
	// 	$this->db->order_by('job_card_number','DESC');
	// 	$sql;
	// 	$rs = $this->db->get();
 	// 	if($rs->num_rows() > 0){
	// 		return $rs->result_array();
	// 	}
	// 	else{
	// 		return false;
	// 	}
	// }
	public function getVjobcard($status){
		$jbno = $this->input->post('jbno');
		$reg_number = $this->input->post('reg_number');
		$client_id = $this->input->post('client_id');
		$user_id = $this->session->userdata('user_id');
		$job_card_status = $this->input->post('job_card_status');
		$date_fmt= date('Y-m-d',strtotime($this->input->post('report_date_from')));
		$date_to= date('Y-m-d',strtotime($this->input->post('report_date_to')));
		$sql = "" ;
		if(!empty($jbno)){
			$sql = $this->db->like('job_card_number', $jbno, 'before');
		}		
		if(!empty($reg_number)){
			$sql = $this->db->where('reg_no', $reg_number);
		}
		if(!empty($client_id)){
			$sql = $this->db->where('client_id', $client_id);
		}

		if ($this->input->post('report_date_from')!='' and $this->input->post('report_date_to')!='') {
			$sql = $this->db->where('job_card_date >=', $date_fmt);
			$sql = $this->db->where('job_card_date <=', $date_to);
 		} else if ($this->input->post('report_date_from') != '') {
			$sql = $this->db->where('job_card_date >=', $date_fmt);
		} else if ($this->input->post('report_date_to')!=''){
			$sql = $this->db->where('job_card_date <=', $date_to);
		}

		if(!empty($job_card_status) ){
			if($job_card_status == 'Draft'){
				$sql = $this->db->where('job_card_status', 'Draft');
			}
			else if($job_card_status == 'Cancelled'){
				$sql = $this->db->where('job_card_status', 'Cancelled');
			}
			else if($job_card_status == 'Completed'){
				$sql = $this->db->where('job_card_status', 'Completed');
			}
			else if($status == 'Requested'){
				$sql = $this->db->where('disc_req_to', $user_id);				 
			}			 			
		}
		if(!empty($status) ){
			if($status == 'Draft'){
				$sql = $this->db->where('job_card_status', 'Draft');
			}
			else if($status == 'Cancelled'){
				$sql = $this->db->where('job_card_status', 'Cancelled');
			}
			else if($status == 'Completed'){
				$sql = $this->db->where('job_card_status', 'Completed');
			}
			else if($status == 'Requested'){
				$sql = $this->db->where('disc_req_to', $user_id);				 
			}			
		}
		if($this->session->userdata('user_group_id') == 17){
			$sql = $this->db->where_in('jobcard_stage',[5,7,10,15,20,21,25,35]);
		}
		if($this->session->userdata('user_group_id') == 18){
			$sql = $this->db->where_in('jobcard_stage',[10,15,20,21,25,35,40]);
		}
		$this->db->select('*');
		$this->db->from('job_card');
		$this->db->order_by('job_card_number','DESC');
		$sql;
		$rs = $this->db->get();
    		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getVjobcardcountarea(){
		$this->db->select('*');
		$this->db->from('job_card');
		$this->db->order_by('job_card_number','DESC');
 		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getVjobcard_detail($id){
		$this->db->select('*');
		$this->db->from('job_card');
		$this->db->where('id', $id);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}	
	
	public function getVjobcard_desc($id){
		$this->db->select('*');
		$this->db->from('job_card_details');
		$this->db->where('job_card_id',$id);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getVjobcard_troubleshhot_service($id){
		$this->db->select('*');
		$this->db->from('job_card_details');
		$this->db->where('job_card_id',$id);
		$this->db->where('service_troubleshoot',0);
		$this->db->where('jb_type',1);
		$this->db->order_by('service_group_id','ASC');
		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getVjobcard_line_service($id){
		$this->db->select('*');
		$this->db->from('job_card_details');
		$this->db->where('job_card_id',$id);
		$this->db->where('service_troubleshoot',1);
		$this->db->where('jb_type',1);
		$this->db->order_by('item_id','ASC'); 
		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}


	public function Chkjobtype_spare($id){
		$this->db->select('*');
		$this->db->from('job_card_details');
		$this->db->where('jb_type',2);
		$this->db->where('job_card_id',$id);
		$this->db->group_by('jb_type'); 
	 
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function Chkjobtype_labour($id){
		$this->db->select('*');
		$this->db->from('job_card_details');
		$this->db->where('jb_type',1);
		$this->db->where('job_card_id',$id);
		$this->db->group_by('jb_type'); 
		
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}



	/*INSERT INTO `job_card_details`(
		`job_card_details_id`,
		`job_card_id`,
		`sl_no`,
		`item_id`,
		`furniture_model`,
		`furniture_description`,
		`furniture_unitprice`,
		`furniture_quantity`,
		`furniture_amount`,
		`vat_perce`,
		`vat_amount`,
		`item_discount`,
		`net_amount`,
		`jb_type`,
		`section_id`,
		`technician_id`,
		`body_id`,
		`part_type`
	)
	VALUES(
		'571',
		'52',
		'1',
		'8029',
		'Test Stock',
		'',
		'2.590',
		'2.000 ',
		'5.180 ',
		'0.000',
		'4.000',
		'',
		'5.180',
		'2',
		'1',
		'12' '273',
		'Purchase Invoice'
	)*/

	public function UpdateJobdetails($dataValues){
		$job_card_id 		 = $dataValues['job_card_id'];
		$sl_no 				 = $dataValues['sl_no'];
		$job_card_details_id = $dataValues['job_card_details_id'];
		$item_id		     = $dataValues['item_id'];
		$furniture_model     = $dataValues['furniture_model'];
		$furniture_description  = $dataValues['furniture_description'];
		$furniture_unitprice    = $dataValues['furniture_unitprice'];
		$furniture_quantity     = $dataValues['furniture_quantity'];
		$furniture_amount       = $dataValues['furniture_amount'];
		$vat_perce      = $dataValues['vat_perce'];
		$vat_amount     = $dataValues['vat_amount'];
		$item_discount  = $dataValues['item_discount'];
		$net_amount     = $dataValues['net_amount'];
		$jb_type        = $dataValues['jb_type'];
		$section_id     = $dataValues['section_id'];
	//	$technician_id  = $dataValues['technician_id'];
		$body_id        = $dataValues['body_id'];
		$part_type      = $dataValues['part_type'];
		$service_troubleshoot   =  $dataValues['service_troubleshoot'];
		$uom            = $dataValues['uom'];
		$uom_id         = $dataValues['uom_id'];
		$item_disc_perc =  $dataValues['item_disc_perc'];
		$service_group_id  =  $dataValues['service_group_id'];
		$aws             =  $dataValues['aws'];
		$min  			 =  $dataValues['min'];
		$job_status  			 =  $dataValues['job_status'];
		$is_request_id   = $this->input->post('is_request_id');
		if(!empty($is_request_id) && ($is_request_id == $this->session->userdata('user_id')) ){
			$data = array(
				'dis_req_status' => 1,
			);
			$this->db->where('id', $job_card_id);
			$this->db->update('job_card', $data);
		}
		
		if(!empty($job_card_details_id)){
	 				$this->db->query("INSERT INTO `job_card_details`( 
					`job_card_details_id`,
					`job_card_id`,
					`sl_no`,
					`item_id`,
					`furniture_model`,
					`furniture_description`,
					`furniture_unitprice`,
					`furniture_quantity`,
					`furniture_amount`,
					`uom`,
					`uom_id`,
					`vat_perce`,
					`vat_amount`,
					`item_disc_perc`,
					`item_discount`,
					`net_amount`,
					`jb_type`,
					`section_id`,
 					`body_id`,
					`part_type`,
					`service_troubleshoot`,
					`service_group_id`,
					`aws`,
					`min`,
					`job_status`
					) values(
						'$job_card_details_id',
						'$job_card_id',
						'$sl_no',
						'$item_id',
						'$furniture_model',
						'$furniture_description',
						'$furniture_unitprice',
						'$furniture_quantity ',
						'$furniture_amount ',
						'$uom',
						'$uom_id',
						'$vat_perce',
						'$vat_amount',
						'$item_disc_perc',
						'$item_discount',
						'$net_amount',
						'$jb_type',
						'$section_id',
 						'$body_id',
						'$part_type',
						'$service_troubleshoot',
						'$service_group_id',
						'$aws',
						'$min',
						'$job_status'
					)");
		}
		else{			
			$this->db->query("INSERT INTO `job_card_details`( 
											`job_card_id`,
											`sl_no`,
											`item_id`,
											`furniture_model`,
											`furniture_description`,
											`furniture_unitprice`,
											`furniture_quantity`,
											`furniture_amount`,
											`uom`,
											`uom_id`,
											`vat_perce`,
											`vat_amount`,
											`item_disc_perc`,
											`item_discount`,
											`net_amount`,
											`jb_type`,
											`section_id`,
 											`body_id`,
											`part_type`,
											`service_troubleshoot`,
											`service_group_id`,
											`aws`,
											`min`,
											`job_status`
											) values(
												'$job_card_id',
												'$sl_no',
												'$item_id',
												'$furniture_model',
												'$furniture_description',
												'$furniture_unitprice',
												'$furniture_quantity ',
												'$furniture_amount ',
												'$uom',
												'$uom_id',
												'$vat_perce',
												'$vat_amount',
												'$item_disc_perc',
												'$item_discount',
												'$net_amount',
												'$jb_type',
												'$section_id',
 												'$body_id',
												'$part_type',
												'$service_troubleshoot',
												'$service_group_id',
												'$aws',
												'$min',
												'$job_status'
											) ");
		}
		return true;
	}

	public function getInsurer($insurer_id){
		$this->db->select('*');
		$this->db->from('insurer_master');
		$this->db->where('insurer_id', $insurer_id);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function jobCardRow($id){
        $query= $this->db->query("SELECT J.id,
										 J.job_card_number,
										 J.job_card_date,
										 J.divisionid,
										 J.client_id,
										 J.salesman_id,
										 J.project_name,
										 J.contact_id,
										 J.contact_name,
										 J.contact_num,
										 J.status,
										 J.reg_no,
										 J.make,
										 J.model,
										 J.chassi_number,
										 J.contact_name,
										 J.contact_num,
										 NCM.tax_perce FROM `job_card` J 
										 INNER JOIN `new_client_master` NCM ON NCM.client_id=J.client_id  
										 WHERE J.`id` ='$id'");
									return $query->row();
    }
	public function getVjobcard_division($id){
		
		$query= $this->db->query("SELECT divisionid FROM `job_card` WHERE `id` ='$id'" );
		return $query->row()->divisionid;
	}


	public function getPurchaseMaterial_job($id,$division_id){
		$query= $this->db->query("SELECT PH.*,
										 PB.item_h_id,
										 PB.item_name_purchase,
										 PB.item_qty,
										 PB.uom,
										 PB.b_uom,
										 PB.item_rate,
										 PB.item_amt,
										 PB.tcost,
										 PB.fx_amount,
										 PB.item_vat_per,
										 PB.item_vat_amt,
										 PB.item_net_amt,
										 PB.pur_det_id,
										 IP.cost,
										 IP.sel_price,
										 IP.uom_id AS ip_uom
										 FROM `purchase_h` PH 
										 LEFT JOIN `purchase_b` PB ON PB.pur_h_id = PH.id  
										 LEFT JOIN `item_price` IP ON (IP.item_id = PB.item_h_id) AND (IP.division_id = PH.division_id) AND (IP.uom_id = PB.b_uom)
										 WHERE PH.`job_id` ='$id'");	
										 				
									return $query->result_array();
	}

	public function getMaterialIssue_job($id,$division_id){
		$query= $this->db->query("SELECT MH.*,
										 MB.item_details_id,
										 MB.item_description,
										 MB.item_qty,
										 MB.item_rate,
										 MB.item_fx_rate,
										 MB.item_disc,
										 MB.item_amount,
										 MB.item_vat_per,
										 MB.item_vat,
										 MB.net_amount,
										 MB.mi_b_id,
										 MB.uom,
										 MB.uom_id,
										 IP.cost,
										 IP.sel_price
										 FROM `material_issue_h` MH 
										 LEFT JOIN `material_issue_b` MB ON MB.mi_id=MH.mi_id  
										 LEFT JOIN `item_price` IP ON (IP.item_id =  MB.item_details_id) AND (IP.division_id = MH.division_id) AND (IP.uom_id = MB.uom_id)
										 WHERE MH.`job_id` ='$id'");
									return $query->result_array();
	}

	public function get_ContactDetails($Client_Id,$contact_name){
		$html ='';
		$this->db->select('*');
		$this->db->from('client_contact');
		$this->db->where('Client_Id',$Client_Id);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			if(count($rs->result_array())>0){
				$html ='<option value="" > - Select Contact Person- </option>';
				foreach ($rs->result_array() as $client_contact_datas){
					$selected =  $contact_name == $client_contact_datas['Contact_Name'] ? 'selected ="selected"' : '';
					$html.='<option  '.$selected.'  data-cnt-id="'.$client_contact_datas['Contact_Id'].'"  value="'.$client_contact_datas['Contact_Name'].'">'.$client_contact_datas['Contact_Name'].'</option>';			
				}
			} else {
				$html.='<option value="" > - Select Contact Persons- </option>';
			}

			return $html;
		}
		else{
			return false;
		}
	}

	public function get_ContactDetails_only($Client_Id){
		$this->db->select('*');
		$this->db->from('client_contact');
		$this->db->where('Client_Id',$Client_Id);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getJBCModel($model_id){
		$this->db->select('*');
		$this->db->from('model');
		$this->db->where('id', $model_id);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function dataRowdocument($job_no,$division_id){
        $query= $this->db->query("SELECT * FROM `job_card` WHERE  id='$job_no' AND divisionid='$division_id' ");
		return $query->row();
    }

	public function jobDataRow($id,$division_id){
        $query= $this->db->query("SELECT JC.*,
		MK.`title` AS v_make,
		MD.`title` AS v_model,
		CM.`client_code`,
		CM.`client_name`,
		CM.`client_telephone1`,
		CM.`tax_name`,
		RNT.`reg_no_id`,
		RNT.`car_year`,
		RNT.`car_color`,
		RNT.`chassi_number`,
		RNT.`client_mobile_no` FROM `job_card` JC 
		INNER JOIN `make` MK ON MK.id=JC.`make` 
		INNER JOIN `model` MD ON MD.id=JC.`model` 
		LEFT JOIN `new_client_master` CM ON JC.`customer_id`=CM.`client_id` 
		Left join `reg_no_table` RNT ON JC.`reg_no`=RNT.`reg_no` 
		WHERE JC.`id`='$id' AND JC.`divisionid`='$division_id' ");
		return $query->row();
    }

	public function vir_files($job_no,$division_id){
        $query= $this->db->query("SELECT * FROM `vir_files` where `job_no`='$job_no' and `division_id`='$division_id'");
	return $query->result();
    }

	public function get_job_images($job_no){
		$this->db->select('*');
		$this->db->from('job_images');
		$this->db->where('job_id',$job_no);
		
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getvehicledetails($chassi_number){
		$this->db->select('*');
		$this->db->from('reg_no_table');
		$this->db->where('chassi_number',$chassi_number);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function checkPOdata($job_id){
		// $this->db->select('*');
		// $this->db->from('po_h');
		// $this->db->where('job_id',$job_id);
		// $this->db->where('status != ','Cancel');
		// $rs = $this->db->get();		 		 
		// if($rs->num_rows() > 0){
		// 	$this->db->select('*');
		// 	$this->db->from('purchase_h');
		// 	$this->db->where('po_h_id',$rs->row()->po_id);
		// 	$this->db->where('status != ','Cancel');
		// 	$rs1 = $this->db->get();			 			 
		// 	if($rs1->num_rows() > 0){
		// 		return false;
		// 	}
		// 	else{
		// 		return $rs->row()->po_code;
		// 	}				  
		// }
		// else{
		// 	return false;			
		// }

		// $this->db->query("CALL checkPOdata(?, @po_code)", array($job_id));
		// $po_code = $this->db->query("SELECT @po_code AS po_code")->row()->po_code;
		// return $po_code;

		$this->db->query("CALL checkPOdata($job_id, @po_code)");
		$po_code = $this->db->query("SELECT @po_code AS po_code")->row()->po_code;
 		return $po_code;
	}

	public function get_check_pulled_pur_data($job_id){
		// $query = $this->db->query("CALL get_check_pulled_pur_data($job_id)");
		// $result = $query->result_array();
		// return $result;

		$this->db->query("CALL get_check_pulled_pur_data($job_id, @pu_data, @status)");
		$query = $this->db->query("SELECT @pu_data AS pu_data , @status AS status_out");
		$result = $query->result_array();
 		return $result;

		// $returnArray = array('pu_data' => '', 'status' => '');
		// $this->db->select('*');
		// $this->db->from('purchase_h');
		// $this->db->where('status != ','Cancel');
		// $this->db->where('job_id= ',$job_id);
		// $rs = $this->db->get();		
 		// if($rs->num_rows() > 0){
		// 	foreach($rs->result_array() as $records){
		// 		$this->db->select('*');
		// 		$this->db->from('purchase_b');
		// 		$this->db->where('pur_h_id',$records['id']);
		// 		$this->db->where('status ',1);
		// 		$rs1 = $this->db->get();
 		// 		if($rs1->num_rows() > 0){
		// 			$this->db->select('*');
		// 			$this->db->from('job_card_details');
		// 			$this->db->where('body_id',$rs1->row()->pur_det_id);
		// 			$this->db->where('job_card_id',$job_id);
		// 			$this->db->where('part_type','Purchase Invoice');
 		// 			$rs2 = $this->db->get();	
 		// 			if($rs2->num_rows() > 0){
		// 				$returnArray['status'] =  false;						
		// 			}
		// 			else{
		// 				$returnArray['status'] =  TRUE;	
		// 				$returnArray['pu_data'] =  $records['purchase_invoice_code'];	
		// 			}
		// 		}
		// 		else{
		// 			$returnArray['status'] =  false;
		// 		}	
		// 	}
		// }
		// else{
		// 	$returnArray['status'] =  false;	
		// }
		// return $returnArray;
	}

	public function get_check_pulled_material_data($job_id){
		$this->db->query("CALL get_check_pulled_material_data($job_id, @mi_data, @status)");
		$query = $this->db->query("SELECT @mi_data AS mi_data, @status AS status_out");
		$result = $query->result_array();
 		return $result;
		// $returnMTArray = array('mi_data' => '', 'status' => '');
		// $this->db->select('*');
		// $this->db->from('material_issue_h');
		// $this->db->where('status != ','Cancel');
		// $this->db->where('job_id= ',$job_id);
		// $rs = $this->db->get();	
		// if($rs->num_rows() > 0){
		// 	foreach($rs->result_array() as $records){
		// 		$this->db->select('*');
		// 		$this->db->from('material_issue_b');
		// 		$this->db->where('mi_id',$records['mi_id']);
		// 		$this->db->where('status ',1);
		// 		$rs1 = $this->db->get();
		// 		if($rs1->num_rows() > 0){
		// 			$this->db->select('*');
		// 			$this->db->from('job_card_details');
		// 			$this->db->where('body_id',$rs1->row()->mi_b_id);
		// 			$this->db->where('job_card_id',$job_id);
		// 			$this->db->where('part_type','Material Issue');
 		// 			$rs2 = $this->db->get();					
		// 			if($rs2->num_rows() > 0){
		// 				$returnMTArray['status'] =  false;						
		// 			}
		// 			else{
		// 				$returnMTArray['status'] =  TRUE;	
		// 				$returnMTArray['mi_data'] =  $records['mi_code'];	
		// 			}
		// 		}
		// 		else{
		// 			$returnMTArray['status'] =  false;
		// 		}
		// 	}
		// }
		// else{
		// 	$returnMTArray['status'] =  false;	
		// }
		// return $returnMTArray;
	}

	public function get_check_rate_Job($job_id){
		$this->db->select_sum('net_amount');
		$this->db->from('job_card_details');
		$this->db->where('job_card_id ',$job_id);
		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->row()->net_amount;
		}
		else{
			return false;
		}
	}
	public function get_check_rate_quo($job_id){
		$this->db->select_sum('net_amount');
		$this->db->from('furniture_quotation AS FQ');
		$this->db->join('furniture_items AS FI','FI.quotation_id = FQ.id','left');
		$this->db->where('job_card_id ',$job_id);
		$this->db->where('FQ.quotation_status !=','Closed');
		$rs = $this->db->get();
  		if($rs->num_rows() > 0){
			return $rs->row()->net_amount;
		}
		else{
			return false;
		}
	}

	public function get_check_Order_Quantity($job_id){
		$this->db->select_sum('furniture_quantity');
		$this->db->from('furniture_items');
 		$this->db->where('job_id', $job_id);
 		$this->db->where('issue_type', 'order');
		$this->db->where('quotation_status', 'Approved');
		$this->db->group_by('job_id');
		$rs = $this->db->get();
		if ($rs->num_rows() > 0) {
			return $rs->row()->furniture_quantity;
	    } else {
		   return false;
	    }
 	}

	public function get_check_purchase_Order_Quantity($job_id){
		$this->db->select_sum('item_qty');
		$this->db->from('po_b');
		$this->db->where('job_id',$job_id);
		$rs = $this->db->get();
		if ($rs->num_rows() > 0) {
			return $rs->row()->item_qty;
	    } else {
		   return false;
	    }
	}

	public function get_ckeck_jobStock_Quantity($job_id){
		$this->db->select_sum('furniture_quantity');
		$this->db->from('furniture_items');
 		$this->db->where('job_id', $job_id);
 		$this->db->where('issue_type', 'stock');
		$this->db->where('quotation_status', 'Approved');
		$this->db->group_by('job_id');
		$rs = $this->db->get();
		if ($rs->num_rows() > 0) {
			return $rs->row()->furniture_quantity;
	    } else {
		   return false;
	    }
 	}

	 public function get_check_materialStock_Quantity($job_id){
		$this->db->select_sum('item_qty','stock_total');
		$this->db->from('material_issue_b as MB');
		$this->db->join('material_issue_h as MH', 'MH.mi_id  = MB.mi_id', 'LEFT');
		$this->db->where('MH.job_id',$job_id );
		$this->db->where('MH.status', 1);
		$rs = $this->db->get();
 		if ($rs->num_rows() > 0) {
			return $rs->row()->stock_total;
	    } else {
		   return false;
	    }
	}

	public function jobcard_confirmstatus($job_id){
		$this->db->select('jobcard_stage');
		$this->db->from('job_card');
 		$this->db->where('id ',$job_id);
 		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->row()->jobcard_stage;
		}
		else{
			return false;
		}
	}
 



	public function UpdateJObcardStatus($job_id,$data){
		$this->db->trans_begin();
		$this->db->where('id', $job_id);
		$this->db->update('job_card', $data);
		
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return false;
		}
		else{
			$this->db->trans_commit();
			return true;
		}
	}

	public function getInvoiceTempNum($divisionid){
		$this->db->select_max('invoice_number') ;
		$this->db->from('furniture_invoice');
		$this->db->where('quotation_divisionid',$divisionid);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			$inv  = $rs->row()->invoice_number ;
			return $inv;
		}
		else{
			return false;
		}
	}

	public function getUnitmasterdata(){
		$this->db->select('*');
		$this->db->from('unit_master');
		$this->db->where('status', 1);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	// public function getLabourDiscountAdvisor(){
	// 	$user_id   = $this->session->userdata('user_id');
	// 	$disc_limt = $this->crud_model->user_wise_section_discount_limit()->is_labour_disc;
	// 	$this->db->select('SM.staff_id,SM.staff_name,U.is_labour_disc');
	// 	$this->db->from('staff_master AS SM');
	// 	$this->db->join('users as U','U.advisor_id = SM.staff_id','left');
	// 	$this->db->where('SM.staff_id !=',$user_id);
	// 	$this->db->where('U.is_labour_disc > ',$disc_limt);
	// 	$rs = $this->db->get();
	// 	if($rs->num_rows()>0){
	// 		return $rs->result_array();
	// 	}
	// 	else{
	// 		return false;
	// 	}
	// }

	public function getLabourDiscountAdvisor($div_id){
		$user_id   = $this->session->userdata('user_id');
		$disc_limt = $this->crud_model->user_wise_section_discount_limit()->is_labour_disc;
		$this->db->select('user_id,user_name,is_labour_disc');
		$this->db->from('users');		 
		$this->db->where('user_id !=',$user_id);
		$this->db->where('is_labour_disc > ',$disc_limt);
		$this->db->where('user_division',$div_id);
		$this->db->order_by('is_labour_disc','DESC');
		$rs = $this->db->get();
 		if($rs->num_rows()>0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function sendDicsRequest(){		
		$job_id 	 = $this->input->post('job_card_id_req');  
		$data = array(
			'disc_req_to'  => $this->input->post('request_to_adv'),
			'disc_req_from' => $this->session->userdata('user_id'),
			'dis_req_narration'  => $this->input->post('narration'),
			'dis_req_status' => 0
		);
		$this->db->trans_begin();
		$this->db->where('id', $job_id);
		$this->db->update('job_card', $data);		
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			return false;
		}
		else{
			$this->db->trans_commit();
			return true;
		}
	}

	public function getJobhistory($reg_no){

		    $where  = $limit ='' ;
	    	$reg_post = $this->input->post('reg_no');
	    	$from_date = $this->input->post('report_date_from');
	    	$to_date = $this->input->post('report_date_to');
			if(!empty($reg_post)){
				$where = $this->db->where( 'JC.reg_no',$reg_post);
			}
			else{
				if(!empty($reg_no)){
					$where = $this->db->where( 'JC.reg_no',$reg_no);
					$limit = $this->db->limit('5');
				} 
			}
			if(!empty($from_date)){
				$where = $this->db->where( 'FINV.invoice_date >=',date('Y-m-d',strtotime($from_date)));
			}
			if(!empty($to_date)){
				$where = $this->db->where( 'FINV.invoice_date <=',date('Y-m-d',strtotime($to_date)));
			}
		
		$this->db->select('FINV.*,JC.id,JC.job_card_number,JC.km_in,JC.next_km');
		$this->db->from('furniture_invoice AS FINV');
 		$this->db->join('job_card AS JC','JC.id = FINV.job_card_id','left');
		$where;
		$this->db->order_by('invoice_date','DESC');
		$limit;
		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getInvoiceDetails($invoice_id){
		$this->db->select('*');
		$this->db->from('furniture_invoice_details');
		$this->db->where( 'invoice_id',$invoice_id);
		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function get_vehicle_job_details($job_id){
		$this->db->Select('*');
		$this->db->From('job_card');
		$this->db->Where('id',$job_id);
 		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}
	public function getcompany_details(){
		$this->db->select('*');
		$this->db->from('company_details');
 		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}
	public function getcompany_division($division_id){
 		$this->db->select('*');
		$this->db->from('company_division');
		$this->db->where('division_id',$division_id);
 		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function checkInvoice($jb_id){
		$this->db->select('job_card_id');
		$this->db->from('furniture_invoice');
		$this->db->where('job_card_id',$jb_id);
 		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}
	public function datainventorychkRowdocument($id){
		$this->db->select('*');
		$this->db->from('vehicle_inventory_checklist');
		$this->db->where('id',$id);
  		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}
	public function v_InventoryChecklist(){
		$this->db->select('*');
		$this->db->from('vehicle_inventory_checklist');
 		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getServiceLineGroup(){
		$g_code = $this->input->post('g_code');
		$g_name = $this->input->post('g_name');
		$where  = $like = '';
		if($g_code != ''){
			$where  = $this->db->like('group_code',$g_code);
		}
		if($g_name != ''){
			$where  = $this->db->like('group_name ',$g_name);
		}
		$this->db->select('*');
		$this->db->from('service_line_group');
		$where;
		$like;
  		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	public function getServiceLineMaster(){
		$g_code = $this->input->post('g_code');
		$g_name = $this->input->post('g_name');
		$serv_name = $this->input->post('serv_name');
		$where  = $like = '';
		if($g_code != ''){
			$like  = $this->db->like('service_code',$g_code);
		}
		if($g_name != ''){
			$like  = $this->db->like('group_name',$g_name);
		}if($serv_name != ''){
			$like  = $this->db->like('service_name',$serv_name);
		}
		$this->db->select('SLM.*,SLG.*');
		$this->db->from('service_line_master AS SLM');
		$where;
		$like;
		$this->db->join('service_line_group AS SLG','SLG.id = SLM.service_group_id' ,'Left');
		$this->db->order_by('service_code','ASC');
		
  		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	public function getServiceRateMaster(){
		$g_code = $this->input->post('g_code');
		$g_name = $this->input->post('g_name');
		$serv_name = $this->input->post('serv_name');
		$where  = $like = '';
		if($g_code != ''){
			$like  = $this->db->like('service_code',$g_code);
		}
		if($g_name != ''){
			$like  = $this->db->like('group_name',$g_name);
		}if($serv_name != ''){
			$like  = $this->db->like('service_name',$serv_name);
		}

		$this->db->select('SLM.service_code,SLM.service_name,SLM.service_group_id,SLM.slm_id ,SLG.id,SLG.group_name,SLG.group_code,SRM.*');
 		$this->db->from('services_rate_table AS SRM');
		$this->db->join('service_line_master AS SLM','SLM.slm_id = SRM.item_id' ,'Left');
		$this->db->join('service_line_group AS SLG','SLG.id = SRM.services_group_id' ,'Left');
		$this->db->where('SRM.status',1);
		$where;
		$like;
		$this->db->order_by('SRM.services_rate_id','ASC');
  		$rs = $this->db->get();
  		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function checkgroupCode($group_code){
		$this->db->select('*');
		$this->db->from('service_line_group');
		$this->db->where('group_code',$group_code);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function getServiceTroubleshootrow($id){
		$this->db->select('SLM.*,SLG.group_name,SLG.group_code,SLG.id');
		$this->db->from('service_line_master AS SLM');
		$this->db->join('service_line_group AS SLG','SLG.id = SLM.service_group_id' ,'Left');
		$this->db->where('service_group_id',$id);
		$this->db->where('is_troubleshoot',0);
		//$this->db->where('is_troubleshoot',0);
		$this->db->where('m_status',1);
		$this->db->order_by('service_group_id','ASC');
		$rs = $this->db->get();
  		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}

	}
	
	public function getGarageServicedatawithRateRow($id,$sm_id,$vmodel){
		$this->db->select('`SLM`.*, `SR`.`amount`, `SR`.`services_rate_id`');
		$this->db->from('service_line_master AS SLM');
		$this->db->join('services_rate_table AS SR','SR.item_id = SLM.slm_id' ,'Left');
 		$this->db->where('SLM.slm_id',$id);
		$this->db->where('SLM.service_group_id',$sm_id);
		$this->db->where('SR.vehicle_type_id',$vmodel);
 		$rs = $this->db->get();
  		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function getGarageServicedataRow($id,$section_master_id){
		$this->db->select('*');
		$this->db->from('service_line_master');
		$this->db->where('slm_id',$id);
		$this->db->where('service_group_id',$section_master_id);
		$rs = $this->db->get();
  		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function getServiceTroubleShootlist($id){
		$this->db->select('*');
		$this->db->from('job_card_details');
		$this->db->where('job_card_id',$id);
		$this->db->order_by('service_group_id','DESC');
		$this->db->order_by('job_card_details_id','DESC');
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getJobcardlast_data($id,$job_id){
		$this->db->select('*');
		$this->db->from('job_card_details');
		$this->db->where('job_card_id',$job_id);
		$this->db->where('job_card_details_id',$id);
 		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function getVehicleCategoryList(){
		// $g_code = $this->input->post('g_code');
		// $g_name = $this->input->post('g_name');
		// $where  = $like = '';
		// if($g_code != ''){
		// 	$where  = $this->db->where('group_code',$g_code);
		// }
		// if($g_name != ''){
		// 	$where  = $this->db->like('group_name ',$g_name);
		// }
		$this->db->select('*');
		$this->db->from('vehicle_category');
  		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getServiceCategoryMaster(){
		$this->db->select('*');
		$this->db->from('service_category_master');
   		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	public function checkServiceCategoryName($edit_cat_name){
		$this->db->select('*');
		$this->db->from('service_category_master');
		$this->db->Like('service_category_name ',$edit_cat_name);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}
	public function getServiceVehicleCategory(){
		$this->db->select('*');
		$this->db->from('vehicle_category');
		$this->db->where('vh_status',1);
  		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	public function checkVehicleCategoryName($edit_cat_name){
		$this->db->select('*');
		$this->db->from('vehicle_category');
		$this->db->Like('vh_type ',$edit_cat_name);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}
	public function getVModelJobcardRow($id){
		$this->db->select('model');
		$this->db->from('job_card');
		$this->db->Like('id',$id);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row()->model;
		}
		else{
			return false;
		}
	}
	public function getVModelTypeRow($vmodelID){
		$this->db->select('type');
		$this->db->from('model');
		$this->db->Like('id',$vmodelID);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row()->type;
		}
		else{
			return false;
		}
	}
	public function getVcategoryFactorRow($vtypecheck){
		$this->db->select('vh_factor');
		$this->db->from('vehicle_category');
		$this->db->Like('vh_type_id',$vtypecheck);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row()->vh_factor;
		}
		else{
			return false;
		}
	}

	public function getServicegrouprow($id){
		$this->db->select('*');
		$this->db->from('service_line_group');
		$this->db->where('id',$id);
		$this->db->where('status',1);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}
	public function getServicelineQuot($id){
		$this->db->select('group_name');
		$this->db->from('service_line_group');
		$this->db->where('id',$id);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row()->group_name;
		}
		else{
			return false;
		}
	}

	public function getServiceLineItemsList($id){
		$this->db->select('*');
		$this->db->from('service_line_master');
		$this->db->where('service_group_id',$id);
		$this->db->where('is_troubleshoot',1);
		$this->db->where('m_status',1);
		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getCheckServiceLineItemsList(){
		$id = $this->input->post('id');
		$jb_id = $this->input->post('jb_id');
		$this->db->select('item_id');
		$this->db->from('job_card_details');
		$this->db->where('service_group_id',$id);
		$this->db->where('service_troubleshoot',1);
		$this->db->where('job_card_id',$jb_id);	
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getsectionMaster(){
		$this->db->select('*');
		$this->db->from('section_master');
		$this->db->where('status',1);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getCheckjobcardRow(){
		$id = $this->input->post('id');
		$jb_id = $this->input->post('jb_id');
		$this->db->select('0');
		$this->db->from('job_card_details');
		$this->db->where('service_group_id',$id);
		$this->db->where('service_troubleshoot',0);
		$this->db->where('job_card_id',$jb_id);	
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function getServiceTechnicianlist($id,$jb_detail_id){
		$this->db->select('*');
		$this->db->from('job_card_technician');
  		$this->db->where('job_id',$id);	
  		$this->db->where('job_detail_id',$jb_detail_id);	
  		$this->db->where('service_troubleshoot',0);	
		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function getJobCardtechnician($id){
		$this->db->select('technician_id,job_id,job_detail_id');
		$this->db->from('job_card_technician');
  		$this->db->where('job_id',$id);	
		$this->db->where('service_troubleshoot',0);	
		$rs = $this->db->get();
  		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getJobCardtechnicianSrvline($id){
		$this->db->select('technician_id,job_id,job_detail_id');
		$this->db->from('job_card_technician');
  		$this->db->where('job_id',$id);	
		$this->db->where('service_troubleshoot',1);	
		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getNewTechnicianII(){
		$service_id  = $this->input->post('service_id');
		$division_id = $this->input->post('division_id');
		$tech_id = $this->input->post('tech_id');
		$this->db->select('*');
		$this->db->from('staff_master');
  		$this->db->like('is_service_area', $service_id);	
  		$this->db->where('division_id',$division_id);	
  		$this->db->where('staff_id !=',$tech_id);	
  		$this->db->where('type',2);	
  		$this->db->where('status',1);	
 		$rs = $this->db->get();
   		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getNewTechnicianAddedList(){
		$service_id  = $this->input->post('service_id');
		$job_id		 = $this->input->post('job_id');
		$detail_id  = $this->input->post('detail_id');
		$this->db->select('*');
		$this->db->from('job_card_technician');
  		$this->db->where('job_id',$job_id);	
  		$this->db->where('job_detail_id',$detail_id);	
  		$this->db->where('service_group_id',$service_id);	
 		$rs = $this->db->get();
		 if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getChecktechnicianadd($jb_id,$jb_det_id){
		$this->db->select('*');
		$this->db->from('job_card_technician');
  		$this->db->where('job_id',$jb_id);	
  		$this->db->where('job_detail_id',$jb_det_id);	
  		$this->db->where('(progress_status = "20" OR progress_status = "0")');
		  $rs = $this->db->get();
		 if($rs->num_rows() > 0 ){
			 return $rs->row();
		 }
		 else{
			 return false;
		 }
	}
	public function getJobCardtechnicianrowcnt($jb_id,$jb_det_id){
		$this->db->select('*');
		$this->db->from('job_card_technician');
  		$this->db->where('job_id',$jb_id);	
  		$this->db->where('job_detail_id',$jb_det_id);
		$rs = $this->db->get();	
		if($rs->num_rows() > 0 ){
			return $rs->num_rows();
		}
		else{
			return false;
		}
	}
	public function getChecktechniciantable($jb_id,$jb_det_id){
		$this->db->select('*');
		$this->db->from('job_card_technician');
  		$this->db->where('job_id',$jb_id);	
  		$this->db->where('job_detail_id',$jb_det_id);	
  		$this->db->where('(progress_status = "20" OR progress_status = "30")');
 		  $rs = $this->db->get();		
		  if($rs->num_rows() > 0 ){
			 return $rs->num_rows();
		 }
		 else{
			 return false;
		}
	}

	public function getstock(){		
		$this->db->select('item_code,id');
		$this->db->from('items');
  		$this->db->where('status',1);	
		  $rs = $this->db->get();		  
		  if($rs->num_rows() > 0 ){
			 return $rs->result_array();
		 }
		 else{
			 return false;
		 }
	}

	public function getQuotationNum($divisionid){
		$this->db->select_max('quotation_number')  ;
		$this->db->from('furniture_quotation');
		$this->db->where('quotation_divisionid',$divisionid);
		$rs = $this->db->get();
		if($rs->num_rows() > 0 &&  $rs->row()->quotation_number != NULL ){
			$inv  = $rs->row()->quotation_number + 1 ;
			return $inv;
		}
		else{
			return false;
		}
	}
	public function divisionCode($divisionid){
		$this->db->select('division_code');
		$this->db->from('company_division');
		$this->db->where('division_id',$divisionid);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row()->division_code;
		}
		else{
			return false;
		}
	}
	public function jobCardRowData($id){
		$this->db->select('*');
		$this->db->from('job_card');
		$this->db->where('id',$id);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}
	public function jobCardRowDataDetail($id){
		$this->db->select('*');
		$this->db->from('job_card_details');
		$this->db->where('job_card_id',$id);
		$this->db->order_by('job_card_details_id','ASC');

		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	public function getVehiclediscount($reg_no,$vtype_id){
		$this->db->select('*');
		$this->db->from('reg_no_table');
		$this->db->where('reg_no',$reg_no);
		$this->db->where('v_type',$vtype_id);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}
	public function getStockrate($stock_id,$division){
		$this->db->select('*');
		$this->db->from('item_price');
		$this->db->where('item_id',$stock_id);
		$this->db->where('division_id',$division);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}	
	}
	public function cehckQuotationRowData($id){
		$this->db->select('*');
		$this->db->from('furniture_quotation');
		$this->db->where('job_card_id',$id);
		$this->db->where('quotation_status !=','Closed');
 		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}	
	}

	public function getQuotationData($id){
		$this->db->select('*');
		$this->db->from('furniture_quotation');
		$this->db->where('id',$id);
 		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function getQuotationitemdetail($id){
		$this->db->select('*');
		$this->db->from('furniture_items');
		$this->db->where('quotation_id',$id);
 		$this->db->order_by('service_group_id', 'ASC');
 		$this->db->order_by('service_troubleshoot', 'ASC');
 		$this->db->order_by('furniture_type', 'ASC');
 		$rs = $this->db->get(); 
 		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getQuotationitemdetailGroup($id){
		$this->db->select('*');
		$this->db->from('furniture_items');
		$this->db->where('quotation_id',$id);
		$this->db->where('service_troubleshoot', 0);
		$this->db->order_by('service_group_id', 'ASC');
 		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getStockData($item_id){
		$this->db->select('*');
		$this->db->from('items');
		$this->db->where('id',$item_id);
  		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}	
	}
	public function Unitmaster(){
		$this->db->select('*');
		$this->db->from('unit_master');
		$this->db->where('status',1);
  		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getVjobcard_detailRFQ($id){
		$this->db->select('*');
		$this->db->from('job_card_details');
		$this->db->where('job_card_id',$id);
		$this->db->where('issue_type','order');
  		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	public function getRFQData($id){
		$this->db->select('*');
		$this->db->from('rfq');
		$this->db->where('job_id',$id);
  		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	public function getsupplier(){
		$this->db->select('*');
		$this->db->from('supplier_master');
   		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function checkByOrder($id){
		$this->db->select('*');
		$this->db->from('job_card_details');
		$this->db->where('job_card_id',$id);
		$this->db->where('issue_type','order');
  		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->num_rows();
		}
		else{
			return false;
		}
	}
	public function CheckRfq($id){
		$this->db->select('*');
		$this->db->from('rfq');
		$this->db->where('job_id',$id);
  		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->num_rows();
		}
		else{
			return false;
		}
	}
	public function getRFQRowData($id,$jb_dtl_id){
		$this->db->select('*');
		$this->db->from('rfq');
		$this->db->where('job_id',$id);
		$this->db->where('job_detail_id',$jb_dtl_id);
  		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}
	public function getquotationstatus($id){
		$this->db->select('*');
		$this->db->from('furniture_quotation');
		$this->db->where('job_card_id',$id);
		$this->db->where('quotation_status','Confirmed');
  		$rs = $this->db->get();

		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}
	public function getquotationupdatestatus($id){
		$this->db->select('quotation_status,id');
		$this->db->from('furniture_quotation');
		$this->db->where('job_card_id',$id);
  		$rs = $this->db->get();
		
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function getRFQdataDetails($id){
		$this->db->select('*');
		$this->db->from('rfq');
		$this->db->where('job_id',$id);
   		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}
	public function getRFQDataPO($id ,$suplier_id){
		$this->db->select('*');
		$this->db->from('rfq');
		$this->db->where('job_id',$id);
		$this->db->where('supplier_id',$suplier_id);
   		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getRowQuotDataPO($id,$job_detail_id){
		$this->db->select('*');
		$this->db->from('furniture_items');
		$this->db->where('job_id',$id);
		$this->db->where('job_detail_id',$job_detail_id);
		$this->db->where('quotation_status','Approved');
  		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function CheckPORowData($id ,$suplier_id){
		$this->db->select();
		$this->db->from('po_h');
		$this->db->where('job_id',$id);
		$this->db->where('supplier_id',$suplier_id);
 		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}	
	}

	public function getPoItemRowcnt($rfq_id, $po_id){
		$this->db->select('sum(item_qty) as po_qty');
		$this->db->from(' po_b');
		$this->db->where('rfq_id',$rfq_id);
	//	$this->db->where('po_id',$po_id);
 		$rs = $this->db->get();
		
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function getRfqItemRow($rfq_id){
		$this->db->select('RF.*,sum(PO.item_qty) as po_rfq_qty');
		$this->db->from('rfq AS RF');
		$this->db->join('po_b AS PO','PO.rfq_id  = RF.rfq_id ' ,'Left');
		$this->db->where('RF.rfq_id',$rfq_id);
 		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;
		}
	}

	public function is_v_type_valid($reg_no)
	{
		$v_type = $this->input->post('v_type');  
		$this->db->select('reg_no');
		$this->db->from('reg_no_table');
		$this->db->where('reg_no', $reg_no);
 		$this->db->where('v_type', $v_type);
		$rs = $this->db->get();
		if ($rs->num_rows() > 0) {
			$this->form_validation->set_message('validate_v_type', '%s is Already Exists with this Vehicle Type '.$v_type.'.');
			return false;  
		} else {
			return true;  
		}
	}
	public function is_edit_v_type_valid($reg_no)
	{
		$v_type = $this->input->post('v_type');  
		//$id  = $this->input->post('reg_no_id');
		if(!empty($this->input->post('reg_no_id'))){
			$id  = $this->input->post('reg_no_id');
		}
		else{
			$id  = $this->input->post('regnoid');			
		}
		$this->db->select('reg_no');
		$this->db->from('reg_no_table');
		$this->db->where('reg_no', $reg_no);
		//$this->db->where("reg_no LIKE '%$reg_no'");
		$this->db->where('v_type', $v_type);
		$this->db->where('reg_no_id  !=', $id);
		$rs = $this->db->get();
 		if ($rs->num_rows() > 0) {
			$this->form_validation->set_message('validate_edit_v_type', '%s is Already Exists with selected Vehicle Type.');
			return false;  
		} else {
			return true;  
		}
	}


	public function is_chassi_number_valid($v_type)
	{
  		$chassi_number  = $this->input->post('chassi_number');
		$this->db->select('chassi_number');
		$this->db->from('reg_no_table');
 		$this->db->where('v_type', $v_type);
		$this->db->where('chassi_number', $chassi_number);
 		$rs = $this->db->get();
 		if ($rs->num_rows() > 0) {
			$this->form_validation->set_message('validate_chassi_number', '%s is Already Exists.');
			return false;  
		} else {
			return true;  
		}
	}

	public function is_edit_chassi_number_valid($v_type, $id)
	{
  		$chassi_number  = $this->input->post('chassi_number');
		$this->db->select('chassi_number');
		$this->db->from('reg_no_table');
 		$this->db->where('v_type', $v_type);
		$this->db->where('chassi_number', $chassi_number);
		$this->db->where('reg_no_id  !=', $id);
		$rs = $this->db->get();
 		if ($rs->num_rows() > 0) {
			$this->form_validation->set_message('validate_edit_chassi_number', '%s is Already Exists.');
			return false;  
		} else {
			return true;  
		}
	}

	public function getVehicleType(){
		$this->db->select('*');
		$this->db->from('vehicle_type');
 		$this->db->order_by('id','ASC');
		$rs = $this->db->get();
 		if ($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;  
		}
	}

	public function getJobcardCategoryView($id){
		$this->db->select('*');
		$this->db->from('job_card_details');
		$this->db->where('job_card_id ', $id);
 		$this->db->order_by('service_group_id', 'ASC');
 		$this->db->order_by('service_troubleshoot', 'ASC');
 		$this->db->order_by('jb_type', 'ASC');
		$rs = $this->db->get();
 		if ($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;  
		}
	}
	public function CheckJobcardStatus($reg_no_id){
		$this->db->select('*');
		$this->db->from('job_card');
		$this->db->where('reg_no',$reg_no_id);
		$this->db->where('v_jobcard_type',10);
		$this->db->order_by('id', 'DESC');
		$this->db->limit(1);
 		$rs = $this->db->get();  
  		if ($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;  
		}
	}
	public function jobcradStatuslist($job_id){
		$this->db->select('*');
		$this->db->from('job_card_details');
		$this->db->where('job_card_id',$job_id);
		$this->db->where('job_status !=',0);
 		$rs = $this->db->get();  
 		if ($rs->num_rows() > 0){
			return $rs->num_rows();
		}
		else{
			return false;  
		}
	}
	public function jobcradStatuspending($job_id){
		$this->db->select('*');
		$this->db->from('job_card_details');
		$this->db->where('job_card_id',$job_id);
		$this->db->where('(job_status = "2" OR job_status = "1")');
		$this->db->where('job_status !=',0);
 		$rs = $this->db->get();  
 		if ($rs->num_rows() > 0){
			return $rs->num_rows();
		}
		else{
			return false;  
		}
	}
	public function jobcradStatusCompleted($job_id){
		$this->db->select('*');
		$this->db->from('job_card_details');
		$this->db->where('job_card_id',$job_id);
		$this->db->where('job_status',3);
		$this->db->where('job_status !=',0);
 		$rs = $this->db->get();  
 		if ($rs->num_rows() > 0){
			return $rs->num_rows();
		}
		else{
			return false;  
		}
	}

	/******Mobile View******/
	public function getVehicleCategory(){
		$this->db->select('*');
		$this->db->from('vehicle_type');
		//$this->db->where('type_status', 0);
		$this->db->order_by('id','ASC');
		$rs = $this->db->get();
		if ($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;  
		}
	}

	public function getv_category(){
		$this->db->select('*');
		$this->db->from('vehicle_type');
		$this->db->order_by('id','ASC');
		$rs = $this->db->get();
 		if ($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;  
		}
	}

	public function getUpdateRegistration($reg){
		$this->db->select('*');
		$this->db->from('reg_no_table');
		$this->db->where('reg_no_id', $reg);
 		$rs = $this->db->get();
 		if ($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;  
		}
	} 
	public function getQuotationRow($q_id,$jb_dtl_id,$jb_id){
		$this->db->select('*');
		$this->db->from('furniture_items');
		$this->db->where('quotation_id', $q_id);
		$this->db->where('job_detail_id', $jb_dtl_id);
		$this->db->where('job_id', $jb_id);
		$this->db->order_by('job_detail_id','ASC');
 		$rs = $this->db->get();
  		if ($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;  
		}
	}
	 public function getRFQdataRow($id,$jb_dtl_id){
		$this->db->select('*');
		$this->db->from('rfq');
		$this->db->where('job_detail_id', $jb_dtl_id);
		$this->db->where('job_id', $id);
		$this->db->order_by('job_detail_id','ASC');
 		$rs = $this->db->get();
  		if ($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;  
		}
	} 

	public function getRFQquotationRowData($id){
		$this->db->select('*');
		$this->db->from('furniture_quotation');
		$this->db->where('job_card_id',$id);
		$this->db->where('quotation_status !=','Cancelled');
		$rs = $this->db->get();
  		if ($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;  
		}
	}

	public function getRFQquotationData($id,$quotid){
		$this->db->select('*');
		$this->db->from('furniture_items');
		$this->db->where('quotation_id', $quotid);
		$this->db->where('job_id', $id);
		$this->db->where('issue_type','order');
		$this->db->order_by('job_detail_id','ASC');
 		$rs = $this->db->get();
  		if ($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;  
		}
	}

	public function getTechnicianVjobcard(){
		$submit = $this->input->post('ttttt');
		$jbno = $this->input->post('jbno');
		$job_id = $this->input->post('job_id');
		$reg_number = $this->input->post('reg_number');
		$date_to= date('Y-m-d',strtotime($this->input->post('report_date_to')));
		$sql = "" ;
		if(isset($submit) && !empty($job_id)){
			if(!empty($job_id)){
				$sql = $this->db->where('id', $job_id);
			}		
			if(!empty($reg_number)){
				$sql = $this->db->where('reg_no', $reg_number);
			}
			if ($this->input->post('report_date_to')!=''){
				$sql = $this->db->where('job_card_date ', $date_to);
			}
			$this->db->select('*');
			$this->db->from('job_card');	
			$this->db->where('job_card_status', 'Draft');			
			$this->db->where_in('jobcard_stage', [5, 10, 15,20,21,25]); 
			$sql;
			$this->db->order_by('id','ASC');
			$this->db->order_by('job_card_date','ASC');
			$rs = $this->db->get();
			if($rs->num_rows() > 0){
				return $rs->row();
			}
			else{
				return false;
			}
		}
	}

	public function getTechnicianVjobcarddetail(){
		$submit = $this->input->post('ttttt');
		$jbno = $this->input->post('jbno');
		$job_id = $this->input->post('job_id');
		$reg_number = $this->input->post('reg_number');
  		$date_to= date('Y-m-d',strtotime($this->input->post('report_date_to')));
		$sql = "" ;
		if(isset($submit) && !empty($job_id)){

			if(!empty($job_id)){
 				$sql = $this->db->where('JC.id', $job_id);
			}		
			if(!empty($reg_number)){
				$sql = $this->db->where('JC.reg_no', $reg_number);
			}
			if ($this->input->post('report_date_to')!=''){
				$sql = $this->db->where('JC.job_card_date ', $date_to);
			}
			$this->db->select('JC.id, JC.jobcard_stage,JT.job_id,JT.technician_id,JT.job_technician_status,JT.progress_status');
			$this->db->from('job_card_technician AS JT' );	 			
			$this->db->join('job_card AS JC','JC.id = JT.job_id' ,'Left');	
 			$this->db->where('JC.job_card_status', 'Draft');			
			$this->db->where_in('JC.jobcard_stage', [5, 10, 15,20,21,25]); 
			$this->db->where('JT.job_technician_status', 2);
			$this->db->where_in('JT.progress_status', [0,20]); 
			$sql;
			$this->db->group_by('JT.technician_id');
			$this->db->order_by('JC.id','ASC');
 			$this->db->order_by('JC.job_card_date','ASC');
			$rs = $this->db->get();
 			if($rs->num_rows() > 0){
				return $rs->result_array();
			}
			else{
				return false;
			}
		}
	}

	public function getTechnicianlogdetail(){
 		$job_id = $this->input->post('job_id');
		$technician = $this->input->post('technician');
		$sql = "" ;
		if(!empty($job_id)){
			$sql = $this->db->where('JC.id', $job_id);
		}		
		if(!empty($technician) ){
			$sql = $this->db->where('JT.technician_id', $technician);
		}

		$this->db->select('JC.id,JC.job_card_number,JC.job_card_date,JC.divisionid,JC.reg_no,JC.make,JC.model,JC.vtype_id,JC.jobcard_stage,
						JD.job_card_id,JD.job_card_details_id,JD.furniture_description,JD.jb_type,JD.service_troubleshoot,JD.service_group_id,
						JT.job_id,JT.technician_id,JT.job_technician_status,JT.progress_status,JT.job_detail_id,JT.aws,JT.min,');
		$this->db->from('job_card_technician AS JT','JT.job_id  = JC.id' ,'Left');	 			
		$this->db->join('job_card AS JC','JC.id = JT.job_id' ,'Left');	
		$this->db->join('job_card_details AS JD','JD.job_card_details_id  = JT.job_detail_id ' ,'Left');
		$this->db->where('JD.jb_type', 1);
		$this->db->where('JC.job_card_status', 'Draft');			
		$this->db->where_in('JC.jobcard_stage', [5, 10,15,20,21,25]); 
		$this->db->where('JT.job_technician_status', 2);
		$this->db->where_in('JT.progress_status', [0,20]); 
		$sql;
	//	$this->db->group_by('JT.technician_id');
		$this->db->order_by('JC.id','ASC');
		$this->db->order_by('JD.service_group_id','ASC');
		$this->db->order_by('JC.job_card_date','ASC');
		$rs = $this->db->get();
 		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}
	}

	public function getMainCategorylist(){
		$this->db->select('*');
		$this->db->from('main_category');
		$this->db->where('status', 1);
		$this->db->order_by('id','ASC');
 		$rs = $this->db->get();
  		if ($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;  
		}
	}
	public function getServiceLineGrouplis($cate_id){
		$this->db->select('*');
		$this->db->from('service_line_master');
		$this->db->where('service_group_id', $cate_id);
		$this->db->where('m_status', 1);
		$this->db->order_by('slm_id','ASC');
 		$rs = $this->db->get();
   		if ($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;  
		}
	}
	public function getCategorystockBrand($cate_id){
		$this->db->select('IT.main_category,IT.brand_id,FB.brand_id, FB.brand_name,FB.status');
		$this->db->from('items as IT');
		$this->db->join('furniture_brands as FB','FB.brand_id = IT.brand_id');
 		$this->db->where('IT.main_category', $cate_id);
		$this->db->where('FB.status', 1);
		$this->db->group_by('IT.brand_id','ASC');
  		$rs = $this->db->get();
  		if ($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;  
		}
	}

	public function getServiceItemlist($brand_id){
		$this->db->select('IT.id,IT.main_category,IT.brand_id,IT.item_name,IT.vat_percentage,FB.brand_id, FB.brand_name,FB.status');
		$this->db->from('items as IT');
		$this->db->join('furniture_brands as FB','FB.brand_id = IT.brand_id');
 		$this->db->where('IT.brand_id', $brand_id);
		$this->db->where('FB.status', 1);
  		$rs = $this->db->get();
  		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;  
		}
	}

	public function getServiceItemsellingprice($item_id,$div_id){
		$this->db->select('sel_price');
		$this->db->from('item_price');
		$this->db->where('item_id',$item_id);
		$this->db->where('division_id', $div_id);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->row()->sel_price;
		}
		else{
			return false; 
		}
	}

	public function get_jobcard_div($job_id){
		$this->db->select('divisionid,temp_technician_id');
		$this->db->from('job_card');
 		$this->db->where('id', $job_id); 
 		$rs = $this->db->get();
  		if ($rs->num_rows() > 0){
			return $rs->row();
		}
		else{
			return false;  
		}
	}

	public function getVehicleModel_jodData($job_id){
		$this->db->select('type');
		$this->db->from('job_card AS JB');
		$this->db->join('model as M','M.id = JB.model');
		$this->db->where('JB.id', $job_id); 
 		$rs = $this->db->get();
  		if ($rs->num_rows() > 0){
			return $rs->row()->type;
		}
		else{
			return false;  
		}
	}
 

	public function checkTechnicianprogress($jb_id,$jb_detail_id){

	}
}
