<?php 
	$this->load->helper('num_words');
?>

<html>
<head>
  <meta content="text/html; charset=UTF-8" http-equiv="content-type">
  <link href='http://fonts.googleapis.com/css?family=Open+Sans' rel='stylesheet' type='text/css'>
  <title><?php echo $quotation_number_full;?></title>
  <style type="text/css">
  	.outer_wrapper{
		width:700px;
		margin:0 auto;
		min-height:600px;
		/*border:solid 1px blue;*/
	}
	
	.mainTable{
		width:100%;	
	}
	
  	.quotationTitle{
		/*height:150px;*/
		width:100%;
		background-color:#7f7f7f;
		float:left;
	}	
	.quotationTitle h2{
		/*background-color:#7f7f7f;*/
    	margin: 0;
    	text-align: center;	
		font-family: 'Open Sans', sans-serif;
		color:#fff;
		line-height:42px;
		/*text-transform:uppercase;*/
		float:left;
		width:100%;
	}
	
	.leftSpan{
		width:60%;
		vertical-align: top;
	}
	
	.rightSpan{
		width:40%;
		vertical-align: top;
	}
	
	.halfSpan > span {
		float: left;
		width: 100%;
	}
	
	.halfSpan > span label{
		width:50%;
		color:#7f7f7f;
		font-family: 'Open Sans', sans-serif;
		font-weight:bold;
		float:left;
	}
	
	.halfSpan h3{
		color: #000000;
    	font-family: 'Open Sans', sans-serif;
    	font-weight: bold;
    	margin: 0;
		padding:0px;
	}
	
	.halfSpan h4{
		color: #000000;
    	font-family: 'Open Sans', sans-serif;
    	font-weight: normal;
   		margin-bottom: 0;
    	margin-top: 3px;
		padding:0px;
	}
	
	.halfspan p{
		color: #000000;
    	font-family: 'Open Sans', sans-serif;
    	font-weight: normal;
   		margin-bottom: 0;
    	margin-top: 3px;
		padding:0px;	
	}
	
	.halfspan p.boldText{
		font-weight:bold;
		font-size:11px;	
	}
	.details{
		font-size:11px;	
		font-family: 'Open Sans', sans-serif;
	}
	
	.quotationIntro{
		margin-top:10px;
		float:left;
		width:100%;
		font-family: 'Open Sans', sans-serif;
		color:#000000;
		font-size:11px;
		
	}
	
	.quotationIntro h3{
		text-transform:uppercase;	
	}
	
	.quotationIntro b{
		font-weight:bold;	
	}
	
	.FeesTitle h3{
		font-family: 'Open Sans', sans-serif;
		font-weight:bold;
		color:#000;
		margin:5px;
	}
	
	.quotationTables{
		margin-top:10px;
		float:left;
		width:100%;
	}
	
	.quotationTables b{
		font-weight:bold;	
	}
	
	.quotationTables table{
		width:100%;	
		border:solid 1px #d4d4d4;
		/*background-color:#f4f4f4;*/
		border-spacing:0px;
	}
	
	.quotationTables table thead th{
		background-color:#7a7a7a;
		color:#fff;
		font-family: 'Open Sans', sans-serif;
		font-weight:bold;
		text-align:left;	
		padding:5px;
	}
	
	.quotationTables table tbody th{
		font-family: 'Open Sans', sans-serif;
		font-weight:bold;
		text-align:left;	
		padding:5px;
		color:#000;
		font-size:14px;
	}
	
	.quotationTables table th, .quotationTables table td{
		border-bottom: 1px solid #aaaaaa !important;
    	border-right: 1px solid #aaaaaa !important;
		padding:4px;
	}
	
	.quotationTables table td .swDesc{
		opacity: 0.35;
	}
	.quotationTables table td .swDesc1{
	font-size:11px;
	font-family: 'Open Sans', sans-serif;
	}
	

	.footer_content p{
		margin:5px 0px;	
	}
	
	.footer_content h3{
		text-transform:none;
		font-weight:bold;
	}
	
	.quotationTables td:last-child {
		border-right: medium none !important;
	}
	
	.quotationTables td.swdescription:last-child {
		border-right: 1px solid #aaaaaa !important;
		font-size:10px;
	}
	
	.quotationTables tr:last-child td {
		border-bottom: medium none !important;
	}
	a.no_print1 {
	 
	color: #0088cc;
    text-decoration: none;
    font-size: 14px;
    margin-left: 14px;
    padding: 11px;
    background: #dcdcdc;
    margin-top: 13px;
    position: fixed;
    border-radius: 4px;
}
a.no_print1:hover {
	text-decoration: none;
}
	
.quotationTables th:last-child {
	border-right: medium none !important;
}

.quotationTables .swGroup{
	background-color: #A4A4A4;
	color: #fff;
	font-family: 'Open Sans', sans-serif;
	font-weight: bold;
	padding: 5px;
	text-align: center;
	font-size:10px;
	color:#000000;
}

.log_left {
	float: right;
}
	
@media print {
	.rightSpan h3{
		margin:0px;
	}
	
	.rightSpan h4{
		margin:0px;
	}
	.no_print {
		display:none;
}
.no_print1 {
		display:none;
}
	
}
.jb_detail{
	/*table-layout: fixed;*/
	width: 100%;
	border-collapse: collapse;
	font-family: 'Open Sans', sans-serif;
}

.jb_detail td{
	height: 18px;
		font-family: 'Open Sans', sans-serif;
}

.jb_detail  tr {   
	white-space: nowrap;
	line-height: 16px;
	font-family: 'Open Sans', sans-serif;
}
.vat-top-right{
	text-align: right;
	font-size: 12px;
	font-weight: 600;
	margin-bottom: 0;
	font-family: 'Open Sans', sans-serif;

}
.print-body-area{
	height: 670px;
	max-height: 670px;
	font-family: 'Open Sans', sans-serif;
}
.system-info-gen{
	display: block;
	margin: auto;
	float: left;
	font-size: 10px;
	color: #dd2c2c;
	text-align: center;
	width: 100%;
	margin-bottom: 2px;
	font-weight: 600;
	font-family: 'Open Sans', sans-serif;
}
.subject-class {
	font-size: 14px;
	padding: 4px 0 2px 0px;
	margin-bottom: 0;
	font-weight: 600;
	text-align: left;
	font-family: 'Open Sans', sans-serif;
}
.print-footer-area{
	position: relative;
}
.header-title{
	text-align: center;
	font-size: 21px;
	font-weight: bolder;
	margin-bottom: 0px;
	margin-top: 0px;
	font-family: 'Open Sans', sans-serif;
}
  </style>
</head>
<body>
<span class='icon-print no_print'></span><a class='no_print1' href='javascript:window.print();'>Print Quotation</a><br/>
	<div align="center" class="outer_wrapper">
		<div class="header-logo" style="display:block;margin:auto; width:700px; padding-bottom:0px;">
			<img src="<?=base_url()."images/hawar_header.png"?>" alt="" style="height:110px;width:700px; padding:0px;"/>
			<!-- <img src="<?php echo base_url()."images/company_division/".$logo_filename; ?>" alt=""  style="height:120px;width:600px; padding:0px;"  class="logo"/> -->
		</div>
 			<div class="header-title">
				<?php 
					if($print_status == "delivery"){
								echo "Delivery Note";
					} else {
								echo "QUOTATION";
					} 
				?>
			</div>
 		<div class="vat-top-right">VAT No.:	<?php if(isset($company_details->tax_no)){ if($company_details->tax_no!=""){  echo $company_details->tax_no; } }  ?></div>
		<table class="mainTable " style="border: 1px  inset #666;border-collapse: collapse; ">
				<tbody>
					<tr>
						<td colspan="7"  valign="top" style="  border-right: 1px  solid #666;">
							<table border="0px" class="jb_detail" >
								<tr>
									<td valign="middle" colspan="4" style="border-collapse: collapse; font-size:12px; font-weight: 500;white-space: nowrap;">Customer : </td>
								</tr>
								<tr>
									<td colspan="7" valign="middle" style="padding-left: 10px;white-space: normal; ">
										<span class="details" style="font-weight: bold; "><?php echo $client_name;?></span>
									</td>
								</tr>
								<tr>
									<td  colspan="7" valign="middle" style="padding-left: 10px;white-space: normal; ">
										<span class="details"><?php echo $client_address;?></span>
									</td>
								</tr>
								
								<?php /* if($tax_name){*/?>
								<!-- <tr> 
									<td valign="middle" width="15%"  style="border-collapse: collapse; font-weight: 600; padding-left: 10px;"> <span class="details">Vat Name</span></td>
									<td valign="middle" width="5%"   style="border-collapse: collapse; font-weight: 500;"> : </td>
									<td valign="middle"  style="border-collapse: collapse; font-weight: 500;"><span class="details"> <?php echo $tax_name;?></span></td>
								</tr> -->
								<?php /* }*/ ?>
								<?php /*if($tax_no){*/?>
								<tr>                      	 
									
									<td valign="middle" width="35%"   style=" font-size:11px; border-collapse: collapse; font-weight: 600; padding-left: 10px;">Vat No.&nbsp;&nbsp;&nbsp;:&nbsp;&nbsp;&nbsp;</span> <?php echo $tax_no;?></td>
								</tr>
								<?php /* } */?>
							</table>
						</td>
						<td valign="top" style="width: 40%;">
							<table border="0px" class="jb_detail" >
							<?php if($quotation_number!="") { ?>
								<tr>
									<td valign="middle" width="35%" style="border-collapse: collapse; font-weight: 500;"> <span class="details">
									<?php if ($print_status == "delivery"){
												echo "Delivery Note No";
											}else{
												echo "Quotation No";
											} 
									    ?>
									</span></td>
									<td valign="middle" width="5%"   style="border-collapse: collapse; font-weight: 500;"> : </td>
									<td valign="middle"  style="border-collapse: collapse; font-weight: 600;"><span class="details"><?php echo $quotation_number_full;?></span></td>
								</tr>
								<?php } ?>
								<tr>
									<td valign="middle" width="35%" style="border-collapse: collapse; font-weight: 500;"> <span class="details">Date</span></td>
									<td valign="middle" width="5%"   style="border-collapse: collapse; font-weight: 500;"> : </td>
									<td valign="middle"  style="border-collapse: collapse; font-weight: 600;"><span class="details"><?php echo date('M d, Y',strtotime($quotation_date));?></span></td>
								</tr>
								<tr>
									<td valign="top" width="20%"  style="border-collapse: collapse; font-weight: 500;"> <span class="details">Job No.</span></td>
									<td valign="top" width="2%"   style="border-collapse: collapse; font-weight: 500;"> : </td>
									<td colspan="3" valign="middle"  style="border-collapse: collapse; font-weight: 600;"><span class="details"><?php  echo  $job_card_number;?></span></td>
								</tr>
								
							</table>	
						</td>
					</tr>
				</tbody>	
			</table>
			<table class="mainTable " style="border: 1px  inset #666; margin-top:10px ;border-collapse: collapse;">
				<tbody>
					<tr>					
						<td valign="top" style="width: 33%; border-right: 1px  solid #666; border-collapse: collapse; padding:0px;">
							<table  class="jb_detail" >
								<tr style="border-bottom: 1px  inset #666;">
									<td valign="middle" width="15%" style="border-collapse: collapse; font-weight: 500; border-bottom: 1px  inset #666;padding:2px;"> <span class="details">Reg No</span></td>
									<td valign="middle" width="5%"  style="border-collapse: collapse; font-weight: 500; border-bottom: 1px  inset #666;padding:2px;"> : </td>
									<td valign="middle"     style="border-collapse: collapse; font-weight: 600; border-bottom: 1px  inset #666;padding:2px;"><span class="details"> <?php echo $reg_no;?> ( <?=$vtype_name;?> )</span></td>
								</tr>
								<tr>
									<td valign="middle" width="15%" style="border-collapse: collapse; font-weight: 500;padding:2px;"> <span class="details">Year</span></td>
									<td valign="middle" width="5%"   style="border-collapse: collapse; font-weight: 500;padding:2px;"> : </td>
									<td valign="middle"  style="border-collapse: collapse; font-weight: 600;padding:2px;"><span class="details"><?php echo $car_year;?></span></td>
								</tr>
							</table>	
						</td>
						<td valign="top" style="width: 33%; border-right: 1px  solid #666;border-collapse: collapse; padding:0px;">
							<table  class="jb_detail" >
								<tr>
									<td valign="middle" width="22%" style="border-collapse: collapse; font-weight: 500; border-bottom: 1px  inset #666;padding:2px;"> <span class="details">KM.IN</span></td>
									<td valign="middle" width="5%"  style="border-collapse: collapse; font-weight: 500; border-bottom: 1px  inset #666;padding:2px;"> : </td>
									<td valign="middle"     style="border-collapse: collapse; font-weight: 600; border-bottom: 1px  inset #666;padding:2px;"><span class="details"> <?php echo $Km_in;?></span></td>
								</tr>
								<tr>
									<td valign="middle" width="22%" style="border-collapse: collapse; font-weight: 500;padding:2px;"> <span class="details">Chaiss No</span></td>
									<td valign="middle" width="5%"   style="border-collapse: collapse; font-weight: 500;padding:2px;"> : </td>
									<td valign="middle"  style="border-collapse: collapse; font-weight: 600;padding:2px;"><span class="details"><?php echo $chassi_number;?></span></td>
								</tr>
							</table>	
						</td>
						<td valign="top" style="width: 33%;padding:0px;">
							<table  class="jb_detail" style="padding:5px;">
								<tr>
									<td valign="middle" width="18%" style="border-collapse: collapse; font-weight: 500; border-bottom: 1px  inset #666;padding:2px;"> <span class="details">Make</span></td>
									<td valign="middle" width="8%"  style="border-collapse: collapse; font-weight: 500; border-bottom: 1px  inset #666;padding:2px;"> : </td>
									<td valign="middle"     style="border-collapse: collapse; font-weight: 600; border-bottom: 1px  inset #666;padding:2px;"><span class="details"> <?php echo $vname;?></span></td>
								</tr>
								<tr>
									<td valign="middle" width="18%" style="border-collapse: collapse; font-weight: 500;padding:2px;"> <span class="details">Color</span></td>
									<td valign="middle" width="8%"   style="border-collapse: collapse; font-weight: 500;padding:2px;"> : </td>
									<td valign="middle"  style="border-collapse: collapse; font-weight: 600;padding:2px;"><span class="details"><?php echo $car_color;?></span></td>
								</tr>
							</table>	
						</td>
					</tr>
				</tbody>	
			</table>								
			<div class="subject-class">Subject &nbsp;&nbsp;&nbsp;:&nbsp;&nbsp;&nbsp;
				<?php
				    $searchString = "LABOUR CHARGE";
					$vdesc = str_replace($searchString, '', $subject);
					echo $vdesc;
				?>			
			</div>								
			<table style="border-top:none; border: 1px inset #666; width: 100%; border-collapse: collapse;margin-top:1px;line-height:21px;width:100%">
				<thead>
					<tr>
						<th style="font-family: 'Open Sans', sans-serif;border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: nowrap;" width="3%">Sl.No</th>
						<th style="font-family: 'Open Sans', sans-serif;border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: nowrap;" width="2%">#</th>
						<th style="font-family: 'Open Sans', sans-serif;border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: nowrap;" width="45%">ITEM</th>
						<th style="font-family: 'Open Sans', sans-serif;border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: nowrap;" width="3%">QTY</th>
						<th style="font-family: 'Open Sans', sans-serif;border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: nowrap;" width="5%">Unit</th>
						<th style="font-family: 'Open Sans', sans-serif;border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: normal; text-align:center;line-height:10px;" width="6%">Rate<?php echo ' ('.$currency_code.')' ?>&nbsp;&nbsp;</th>
						<th style="font-family: 'Open Sans', sans-serif;border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: normal; text-align:center;line-height:10px;" width="7%">Amnt<?php echo ' ('.$currency_code.')' ?>&nbsp;&nbsp;</th>
						<th style="font-family: 'Open Sans', sans-serif;border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: nowrap; text-align:right;" width="3%">Dis%</th>
						<th style="font-family: 'Open Sans', sans-serif;border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: nowrap; text-align:right;" width="5%">Dis.Amt</th>
						<th style="font-family: 'Open Sans', sans-serif;border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: nowrap; text-align:right;" width="3%">Vat%</th>
						<th style="font-family: 'Open Sans', sans-serif;border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: nowrap; text-align:right;" width="5%">Vat.Amt</th>
						<th style="font-family: 'Open Sans', sans-serif;border:1px inset #666;border-collapse: collapse;background:#ffffff; font-size:10px;white-space: nowrap; text-align:right;" width="10%">Net.Amt</th>
					</tr>
				</thead>					
				<tbody style="border-top:1px inset #666;border-collapse: collapse;">
					<?php 
						$grandTotal = $subnetTotal  = 0;		
						if($furniture_items != false)
						{
							$i=0;
							$grandTotal=0;
							$discnt_prcnt   = 0;
							$total_discount = 0;
							$total_amount   = 0;
							$total_vat_amt  = 0;
							$total_net_amnt = 0;
							$total_labour   = $total_labour_vat  = 0;
							$total_parts    = $total_parts_vat  = 0;
							$furniture_area = "";
							$i = 0;
							$j =1;
							$subGroupTotal = 0;
							foreach($furniture_itemlist as $products){ 
								$ex_furniture_area = $products["ex_furniture_area"];
								$furniture_area    = $products["furniture_area"];
								$quotation_id      = $products["quotation_id"];
								$furniture_id      = $products["furniture_id"];
								$i++;
								$this->db->select('*');
								$this->db->where(array('quotation_id' => $quotation_id, 'ex_furniture_area' => $ex_furniture_area));
								$this->db->from('furniture_items');
								//$this->db->join('items','items.id = furniture_items.item_id','left');
								//$this->db->join('item_specifications','item_specifications.item_id = items.id','left');
								$this->db->order_by("sub_group_id", "ASC");
								$this->db->group_by("sub_group_id");
								$rs = $this->db->get();
								$holi_per_mnth   = $rs->result_array();

								echo '<tr>
											<td colspan="12" class="details" style="border-top:1px inset #666;font-weight:600;border-bottom:1px inset #666;border-collapse: collapse;padding:1.8px;text-align:left;">';
												if($furniture_area !=""){
													echo $furniture_area;
												}
											echo'</td>		
									 </tr>';
							    $sub_group_net_total = 0;
								
								foreach ($holi_per_mnth as $holi_per_mnth){									 
									$this->db->select('*');
									$this->db->where(array('quotation_id' => $quotation_id, 'ex_furniture_area' => $ex_furniture_area, 'sub_group_id' => $holi_per_mnth['sub_group_id']));
									//$this->db->where(array('quotation_id'=>$quotation_id, 'sub_group_id'=>$holi_per_mnth['sub_group_id']));
									$this->db->from('furniture_items');
									$this->db->join('items', 'items.id = furniture_items.item_id', 'left');
									$this->db->join('item_specifications', 'item_specifications.item_id = items.id', 'left');
									$this->db->order_by("service_troubleshoot", "ASC");
									$this->db->order_by("furniture_type", "ASC");
									$this->db->order_by("furniture_id", "ASC");
									$sub_val 	   = $this->db->get();
									$sub_records   = $sub_val->result_array();
									$discnt_prcnt   = 0;
									$sub_total_discount = 0;
									$sub_total_amount   = 0;
									$sub_total_vat_amt  = 0;
									$sub_total_net_amnt = 0;
									$displayedtype= array(); 
									$j = 1;
									$secCalArray  = [];
									foreach($sub_records as $sub_records){
										$vatspareArray  = array('vat' => '',  'spareamt' => '' , 'sparevat' => '' );
										$vatlabArray    = array('vat' => '', 'labouramt' => '', 'labourvat' => '' );	
										$rate =  $sub_records['furniture_unitprice'] * $sub_records['furniture_quantity'];
										if($rate == 0 || $rate == ''){
											$discnt_prcnt = 0;	
										}else{
											$discnt_prcnt = ($sub_records['item_discount'] / ($rate ) * 100);
										}	
										$subamount = ($sub_records['furniture_quantity'] * $sub_records['furniture_unitprice']);					
										$subTotal  = ($sub_records['furniture_quantity'] * $sub_records['furniture_unitprice']) - $sub_records['item_discount'];
										$subnetTotal  = $subTotal + $sub_records['vat_amount'];
										$sub_total_discount = $sub_records['item_discount'];
										$sub_total_amount   = $subTotal ;
										$sub_total_vat_amt  = $sub_records['vat_amount'];
										$sub_total_net_amnt = $subnetTotal;
										$vat_perce = number_format($sub_records['vat_perce'],0);
										if($sub_records['furniture_type'] == 1)
										{
											$total_labour   = $total_labour + $subTotal;
											$total_labour_vat = $total_labour_vat + $sub_total_vat_amt;
											$parts = '';
											$qty = '';
											$uom = '';
											$unit_rate  = '';																								
											$vatlabArray['vat']  = $vat_perce;
											$vatlabArray['labouramt']  = $subTotal;
											$vatlabArray['labourvat']  = $sub_total_vat_amt;
											$vatsection[] = $vatlabArray;		
										} 	
										else{											
											$total_parts   = $total_parts + $subTotal;
											$total_parts_vat = $total_parts_vat + $sub_total_vat_amt;
											$parts = '[P]';
											$qty = number_format($sub_records['furniture_quantity'] , 0);
											$uom = empty($sub_records['uom'])? $sub_records['furniture_uom_name'] :  $sub_records['uom'];
											$unit_rate  = number_format((float)$sub_records['furniture_unitprice'], 3, '.', '');																								 											
											$vatspareArray['vat']  = $vat_perce;
											$vatspareArray['spareamt']   = $subTotal;
											$vatspareArray['sparevat']   = $sub_total_vat_amt;
											$vatsapresection[] = $vatspareArray;	
										}		
  										$total_discount = $total_discount + $sub_total_discount;
										$total_amount   = $total_amount + $sub_total_amount + $sub_total_discount;
										$total_vat_amt  = $total_vat_amt + $sub_total_vat_amt;
										$total_net_amnt = $total_net_amnt + $sub_total_net_amnt;
										$sub_group_net_total = $sub_group_net_total + $sub_total_net_amnt;
										//if(!in_array($sub_records['furniture_type'], $displayedtype) && $sub_records['furniture_type'] !="" ){
										// echo '<tr>
										// 	<td colspan="10" class="details" style="border-top:1px inset #666;font-weight:500;border-bottom:1px inset #666;border-collapse: collapse;padding:1.8px;text-align:left;font=size:10px">';
										
  										// 				if($sub_records['furniture_type'] == 1){
										// 					echo 'Labour Charges';
										// 			   }
										// 			   else{
   
										// 				   echo  'Spare Parts / Consumables';
										// 			   }

										// 	echo'</td>
													
								 		// </tr>';
										// $displayedtype[] =  $sub_records['furniture_type'];
										//}
										if(!empty($sub_records['furniture_description'])){
											$desc = $sub_records['furniture_description'];
										}
										else{
											$desc = $sub_records['furniture_model'];
										}
										echo '<tr style="line-height:18px;">
											<td class="details" style="border-top: none;border-right:1px inset #666;border-collapse: collapse;padding:0.8px 3px 0 3px; white-space: nowrap;text-align:center;">'.$j++.'</td>
											<td class="details" style="border-top: none;border-right:1px inset #666;border-collapse: collapse;padding:0.8px 3px 0 3px; white-space: nowrap;text-align:center;">'.$parts.'</td>
											<td class="details" style="font-size:10px;text-transform:capitalize;border-top: none;border-right:1px inset #666;border-collapse: collapse;padding:0.8px 3px 0 3px; white-space: pre-wrap;">'.$desc.' </td>
											<td class="details" style="border-top: none;border-right:1px inset #666;border-collapse: collapse;padding:0.8px 3px 0 3px; white-space: nowrap;text-align:center;">'.$qty.'</td>
											<td class="details" style="border-top: none;border-right:1px inset #666;border-collapse: collapse;padding:0.8px 3px 0 3px; white-space: nowrap;text-align:center;">'.$uom.'</td>
											<td class="details" style="border-top: none;border-right:1px inset #666;border-collapse: collapse;padding:0.8px 3px 0 3px; white-space: nowrap;text-align:right;">'.$unit_rate.'</td>
											<td class="details" style="border-top: none;border-right:1px inset #666;border-collapse: collapse;padding:0.8px 3px 0 3px; white-space: nowrap;text-align:right;">'.number_format($subamount,3).'</td>
											<td class="details" style="border-top: none;border-right:1px inset #666;border-collapse: collapse;padding:0.8px 3px 0 3px; white-space: nowrap;text-align:right;">'.number_format($discnt_prcnt,1).'%</td>
											<td class="details" style="border-top: none;border-right:1px inset #666;border-collapse: collapse;padding:0.8px 3px 0 3px; white-space: nowrap;text-align:right;">'.number_format($sub_records['item_discount'], 3).'</td>											
											<td class="details" style="border-top: none;border-right:1px inset #666;border-collapse: collapse;padding:0.8px 3px 0 3px; white-space: nowrap;text-align:right;">'.number_format($sub_records['vat_perce'],0).'%</td>
											<td class="details" style="border-top: none;border-right:1px inset #666;border-collapse: collapse;padding:0.8px 3px 0 3px; white-space: nowrap;text-align:right;">'.number_format($sub_records['vat_amount'],3).'</td>
											<td class="details" style="border-top: none;border-right:1px inset #666;border-collapse: collapse;padding:0.8px 3px 0 3px; white-space: nowrap;text-align:right;">'.number_format($subnetTotal,3).'</td>
										</tr>
										';
									}
								}
								echo '<tr>
									<td colspan="10"  style="text-align: right;border-top: 1px inset #666;border-right:1px inset #666;border-collapse: collapse;padding:0.8px 3px 0 3px; " class="details"><b>'.$furniture_area.' total</b></td>
									<td class="details" style="background:#A4A4A4;text-align: right;border-top: 1px inset #666;border-right:0px;border-collapse: collapse;padding:0.8px 3px 0 3px; ">'.$currency_code.'</td>
									<td class="details" style="background:#A4A4A4;text-align: right;border-top: 1px inset #666;border-right:1px inset #666;border-collapse: collapse;padding:0.8px 3px 0 3px; ">'.number_format((float)$sub_group_net_total , 3, '.', '').'</td>
								</tr>';
							}
						}
					?>
				</tbody>
				<tfoot>
						<tr>
							<td class="details" colspan="6" style="border:1px inset #666;border-collapse: collapse;padding:0.8px; white-space: nowrap; text-align:right;font-weight:600;"></td>
							<!-- <td class="details" style="border:1px inset #666;border-collapse: collapse;padding:0.8px; white-space: nowrap;"></td>
							<td class="details" style="border:1px inset #666;border-collapse: collapse;padding:0.8px; white-space: nowrap;"></td>
							<td class="details" style="border:1px inset #666;border-collapse: collapse;padding:0.8px; white-space: nowrap;"></td>
							<td class="details" style="border:1px inset #666;border-collapse: collapse;padding:0.8px; white-space: nowrap;"></td> -->
							<td class="details" style="border:1px inset #666;border-collapse: collapse;padding:0.8px; white-space: nowrap;text-align:right;font-weight:600;"><?= number_format($total_amount,3);?></td>
							<td class="details" style="border:1px inset #666;border-collapse: collapse;padding:0.8px; white-space: nowrap;"></td>
							<td class="details" style="border:1px inset #666;border-collapse: collapse;padding:0.8px; white-space: nowrap;text-align:right;font-weight:600;"><?= number_format($total_discount,3);?></td>
							
							<td class="details" style="border:1px inset #666;border-collapse: collapse;padding:0.8px; white-space: nowrap;"></td>
							<td class="details" style="border:1px inset #666;border-collapse: collapse;padding:0.8px; white-space: nowrap;text-align:right;font-weight:600;"><?= number_format($total_vat_amt,3);?></td>
							<td class="details" style="border:1px inset #666;border-collapse: collapse;padding:0.8px; white-space: nowrap;text-align:right;font-weight:600;"><?= number_format($total_net_amnt,3);?></td>
						</tr>
						<tr>
							<td valign="top" colspan="5"  style="width: 100%; border-right: 1px  solid #666;text-align:left;">
								<table border="0px" class="jb_detail"   style="width: 100%; text-align:left;" >
								    <tr>									   
										<td valign="middle" width="10%" style="border-collapse: collapse; font-weight: 500;padding:2px;"> <span class="details">Labour </span></td>
										<td valign="middle" width="3%"  style="border-collapse: collapse; font-weight: 500;padding:2px;"> : </td>
										<td valign="middle" width="3%"  style="border-collapse: collapse; font-weight: 500;padding:2px;"  class="details"> <?= $currency_code ;?> </td>
										<td valign="middle" width="15%" style="text-align:right; border-collapse: collapse; font-weight: 600;padding:2px;"><span class="details" style="font-size: 12px;"><?= number_format($total_labour ,3);?></span></td>	
										<td width="3%"></td>
										<td valign="middle" width="13%" style="border-collapse: collapse; font-weight: 500;padding:2px;"> <span class="details">V.A.T</span></td>
										<td valign="middle" width="5%"  style="border-collapse: collapse; font-weight: 500;padding:2px;"> : </td>
										<td valign="middle" width="5%"  style="border-collapse: collapse; font-weight: 500;padding:2px;"  class="details"> <?= $currency_code ;?> </td>
										<td  valign="middle" width="15%" style="text-align:right; border-collapse: collapse; font-weight: 600;padding:2px;"><span class="details" style="font-size: 12px;"><?= number_format($total_labour_vat ,3);?></span></td>
    								</tr> 
									<tr>									   
										<td valign="middle" width="10%" style="border-collapse: collapse; font-weight: 500;padding:2px;"> <span class="details">Parts </span></td>
										<td valign="middle" width="3%"  style="border-collapse: collapse; font-weight: 500;padding:2px;"> : </td>
										<td valign="middle" width="3%"  style="border-collapse: collapse; font-weight: 500;padding:2px;"  class="details"> <?= $currency_code ;?> </td>
										<td valign="middle" width="15%" style="text-align:right; border-collapse: collapse; font-weight: 600;padding:2px;"><span class="details" style="font-size: 12px;"><?= number_format($total_parts ,3);?></span></td>
										<td width="3%"></td>
										<td valign="middle" width="10%" style="border-collapse: collapse; font-weight: 500;padding:2px;"> <span class="details">V.A.T </span></td>
										<td valign="middle" width="3%"  style="border-collapse: collapse; font-weight: 500;padding:2px;"> : </td>
										<td valign="middle" width="3%"  style="border-collapse: collapse; font-weight: 500;padding:2px;"  class="details"> <?= $currency_code ;?> </td>
										<td valign="middle" width="15%" style="text-align:right; border-collapse: collapse; font-weight: 600;padding:2px;"><span class="details" style="font-size: 12px;"><?= number_format($total_parts_vat ,3);?></span></td>
  									</tr>
									<tr>	
										<td valign="top" colspan="7" style="width: 100%;text-align:left;padding: 0;">
											<table>
												<thead>
													<th class="details" style="text-align:left;">V</th>
													<th class="details" style="text-align:left;">Rate</th>
													<th class="details" style="text-align:center;">Service / Goods </th>
													<th class="details" style="text-align:center;">V.A.T</th>
												</thead>
												<?php						 
														if(!empty($vat_percentage)){
															$sublbvat = $subspvat = 0;
 															foreach($vat_percentage as $vatrec) {
																$sublabouramt = $sublabourvat =  $subspareamt = $subsparevat = 0 ;																																 																
																foreach($vatsection  as $subvatgp){																			
																	if($subvatgp['vat'] == $vatrec['vat_percentage']){
																		$sublbvat	   = $subvatgp['vat'];
																		$sublabouramt  =  $sublabouramt + $subvatgp['labouramt'];
																		$sublabourvat  =  $sublabourvat + $subvatgp['labourvat'];	
																	}									 																										 															 
																}
																foreach($vatsapresection as $subvatgp){																
																	if($subvatgp['vat'] == $vatrec['vat_percentage']){
																		$subspvat	   = $subvatgp['vat'];
 																		$subspareamt   =  $subspareamt + $subvatgp['spareamt'];
																		$subsparevat   =  $subsparevat + $subvatgp['sparevat'];
																	}
 																}
																if(  $subspvat == $vatrec['vat_percentage']){
																	echo '<tr>
																			<td valign="middle" width="5%" style="line-height:16px; text-align:left; border-collapse: collapse;padding:0px;"><span class="details" style="font-size: 12px;">'.$vatrec['vat_percentage'].'</span></td>
																			<td valign="middle" width="5%" style="line-height:16px;   border-collapse: collapse;padding:0px;text-align:right;"><span class="details" style="font-size: 12px;">'.$vatrec['vat_percentage'].' %</span></td>
																			<td valign="middle" width="15%" style="line-height:16px;  border-collapse: collapse;padding:0px;text-align:right;"><span class="details" style="font-size: 12px;text-align:right;">'.number_format(($sublabouramt + $subspareamt )  ,3).'</span></td>							 												
																			<td valign="middle"  width="10%" style="line-height:16px;   border-collapse: collapse;padding:0px;text-align:right;"><span class="details" style="font-size: 12px;text-align:right;">'.number_format(($sublabourvat  + $subsparevat)  ,3).'</span></td>																			
																		</tr>';
																}
															}
														}														
													?>
												<!-- <tr>													
													<td valign="middle" width="11%" style="text-align:left; border-collapse: collapse;padding:0px;"><span class="details" style="font-size: 12px;"><?= 10;?></span></td>
													<td valign="middle" width="11%" style="text-align:left; border-collapse: collapse;padding:0px;"><span class="details" style="font-size: 12px;"><?= 10;?></span></td>													
													<td valign="middle" width="15%" style="text-align:center; border-collapse: collapse;padding:0px;"><span class="details" style="font-size: 12px;"><?= number_format(($total_parts + $total_labour )  ,3);?></span></td>							 												
													<td valign="middle" width="10%" style="text-align:left; border-collapse: collapse;padding:0px;"><span class="details" style="font-size: 12px;"><?= number_format(($total_labour_vat +  $total_parts_vat) ,3);?></span></td>
												</tr> -->
											</table>								   
										</td>
  									</tr>															
								</table>
							</td>
							<td colspan="7"  valign="top" style=" text-align:right;">
								<table border="0px" class="jb_detail"  style="width: 100%; text-align:right;" >
									<tr>									   
										<td valign="middle" width="30%" style="text-align:left; border-collapse: collapse; font-weight: 500;padding:2px;"> <span class="details">Goods Total</span></td>
										<td valign="middle" width="10%"  style="border-collapse: collapse; font-weight: 500;padding:2px;"> : </td>
										<td valign="middle" width="5%"  style="border-collapse: collapse; font-weight: 500;padding:2px;"  class="details"> <?= $currency_code ;?> </td>
										<td colspan="4" valign="middle" width="30%" style="text-align:right; border-collapse: collapse; font-weight: 600;padding:2px;"><span class="details" style="font-size: 12px;"><?= number_format($total_amount,3);?></span></td>
  									</tr>
									<tr>
 										<td valign="middle" width="30%" style="text-align:left; border-collapse: collapse; font-weight: 500;padding:2px;"> <span class="details">Discounts</span></td>
										<td valign="middle" width="10%"  style="border-collapse: collapse; font-weight: 500;padding:2px;"> : </td>
										<td valign="middle" width="5%"  style="border-collapse: collapse; font-weight: 500;padding:2px;"  class="details"> <?= $currency_code ;?> </td>
										<td  colspan="4" valign="middle" width="30%" style="text-align:right; border-collapse: collapse; font-weight: 600;padding:2px;"><span class="details"><?= number_format($quotation_discount_amount,3);?></span></td>
  									</tr>
									<tr>
 										<td valign="middle" width="30%" style="text-align:left; border-collapse: collapse; font-weight: 500;padding:2px;"> <span class="details">V.A.T</span></td>
										<td valign="middle" width="10%"  style="border-collapse: collapse; font-weight: 500;padding:2px;"> : </td>
										<td valign="middle" width="5%"  style="border-collapse: collapse; font-weight: 500;padding:2px;"  class="details"> <?= $currency_code ;?> </td>
										<td colspan="4" valign="middle" width="30%" style="text-align:right; border-collapse: collapse; font-weight: 600;padding:2px;"><span class="details" style="font-size: 12px;"><?= number_format($total_vat_amt,3);?></span></td>
  									</tr>						
									<tr>
 										<td valign="middle" width="30%" style="text-align:left; border-collapse: collapse; font-weight: 500;padding:2px;"> <span class="details">Net.Amount</span></td>
										<td valign="middle" width="10%"  style="border-collapse: collapse; font-weight: 500;padding:2px;"> : </td>
										<td valign="middle" width="5%"  style="border-collapse: collapse; font-weight: 500;padding:2px;"  class="details"> <?= $currency_code ;?> </td>
										<td colspan="4" valign="middle" width="30%" style="text-align:right; border-collapse: collapse; font-weight: 600;padding:2px;"><span class="details" style="font-size: 12px;"><?= number_format($total_net_amnt,3);?></span></td>
  									</tr>
								</table>	
							</td>
						</tr>
						<tr>
							<td valign="middle" colspan="12"  style="padding-left: 5px; border-top: 1px  solid #666;text-align:center; border-bottom:0;">
							<span class="details" style="padding-top: 5px;border-collapse: collapse; font-size:11px; font-weight: 600;white-space: normal;padding-bottom:5px; ">
								<?php
									//$inv_amnt = round($invoice_percentage_amount-$invoice_discount,3);
									$inv_amnt =  round($total_net_amnt,3);;
									$intpart=(int) $inv_amnt;
									$floatpart=(round($inv_amnt,3)*pow(10,3)-($intpart*pow(10,3)));
									if($floatpart !=0) { 
										echo ucwords($currency_name).'&nbsp'.num_words($intpart) . '&nbsp;&amp;&nbsp;Fils &nbsp;' .number_format($floatpart). " / 1000  Only";
									} else {
										echo ucwords($currency_name).'&nbsp'.num_words($intpart)." Only";
									}
								?></span>
							</td>
						</tr>
					</tfoot>
			</table>								

    	 
 
 		<div class="print-footer-area" style="width:100%;text-align: left;font-size:16px;">
			<span class="quotationIntro footer_content" style="margin-top: 5px;">
				<table width="100%">
						
						<!-- <tr>
							<td valign="middle"  style="padding-left: 5px;"><span class="details" style="font-size:11px; font-weight: 600;white-space: normal;">VAT Amount &nbsp;&nbsp;:&nbsp;&nbsp; 
								<?php
									$vat_amt_wrd = round($total_vat_amt,3);
									$intpart=(int) $vat_amt_wrd;
									$floatpart=(round($vat_amt_wrd,3)*pow(10,3)-($intpart*pow(10,3)));
									//$floatpart= $vat_amt_wrd - floor($vat_amt_wrd);
									if($floatpart !=0) { 
										echo ucwords($currency_name).'&nbsp'.num_words($intpart) . '&nbsp;&amp;&nbsp;Fils &nbsp;' .($floatpart). " / 1000  Only";
									} else {
										echo ucwords($currency_name).'&nbsp'.num_words($intpart)." Only";
									}
								?></span>
							</td>
						</tr> -->
					<tr>
						<td class="details">
							<p></p>
							<br/>
							<p><b>Customer / Representative's Signature</b></p>
						</td>
						<td align="right" class="details">
							<p></p>
							<br/><br/>
							<p><b>For <?php if(isset($company_details->company_name)){ echo $company_details->company_name;} ?></b></p>
						</td>
					</tr>
				</table>
 			</span>													
			<div class="system-info-gen">This is a computer generated document.</div>

		</div>
    </div>
	
	
</body>
</html>