<style>
	.legend-white {
		font-size: 10px;
	}
	.alert-info {
    	color: #24587e;
	}
	.alert-warning {
    	color: #7d6608;
	}
	.alert-success {
    	color: #316100;
	}
	.alert-danger {
    	color: #6b1110;
	}
	.showPrint{
		display:none;
	}
	@media print {
		.hidePrint{
			display:none;
		}
		.showPrint{
			display:block;
		}
		div.dt-buttons {
			display:none;
		}
		.dataTables_filter label{
			display:none;
		}
		table.dataTable>thead .sorting::before,
		table.dataTable>thead .sorting_asc::before,
		table.dataTable>thead .sorting_desc::before,
		table.dataTable>thead .sorting_asc_disabled::before,
		table.dataTable>thead .sorting_desc_disabled::before {
			right: 0;
			content: "";
		}
 
		table.dataTable>thead .sorting::after,
		table.dataTable>thead .sorting_asc::after,
		table.dataTable>thead .sorting_desc::after,
		table.dataTable>thead .sorting_asc_disabled::after,
		table.dataTable>thead .sorting_desc_disabled::after {
			right: 0;
			content: "";
		}
		th {
			font-weight: bold !important;
		}
		tr {
			color:#000 !important;
		}
		.card-category {
			padding: 15px;
		}
	}
	div.dt-buttons {
		float: right;
		padding-left: 15px;
		padding-right: 100px;
	}
	.dataTables_length {
		position: absolute;
	}
	[role="menu"] {
	clear:both;
	position:absolute;
	z-index: 1;
	}
	.buttons-columnVisibility{
		background-color: #bbbdc0;
		background: linear-gradient(to bottom, #f0f0f0 0%, #dadada 100%);
		box-shadow: inset 1px 1px 3px #666;
		width:200px;
		text-align:left;
		padding:5px;
	}
	.dt-down-arrow{
		display: none;
	}
	.selected {
		background-color: #bbbdc0;
	}
	
	</style>
<!--app-content open-->
<div class="app-content main-content">
	<div class="side-app">
		<div class="main-container">
			<!-- PAGE-HEADER -->
			<div class="page-header hidePrint">
				<div>
					<h1 class="page-title">Quotation Register</h1>
					<ol class="breadcrumb">
						<li class="breadcrumb-item"><a href="<?php echo site_url('Dashboard/home');?>">Home</a></li>
						<li class="breadcrumb-item active" aria-current="page">Quotation Register</li>
					</ol>
				</div>
			</div>
			<!-- PAGE-HEADER END -->
			
			<!-- ROW-1 OPEN -->
			<div class="row">
				<div class="col-md-12 col-lg-12">
					<div class="card">
						<?php
							if($this->session->flashdata("response")!='') {
								echo '<div class="alert alert-danger">' . $this->session->flashdata("response") . '</div>';
								$this->session->unset_userdata('response');
							}
						?>
						<?php
							if($this->session->flashdata("success")!='') {
								echo '<div class="alert alert-success">' . $this->session->flashdata("success") . '</div>';
								$this->session->unset_userdata('success');
							}
						?>
						<form id="quotation_report" name="quotation_report" class="form-horizontal" method="post" action="<?php echo site_url('Quotation_register/index/result');?>">
							<div class="card-body hidePrint">
								<div class="form-row">
									<div class="form-group col-md-2 mb-0">
										<div class="form-group">
											<?php if(!isset($submitted_division_id)) $submitted_division_id = "select"; ?>
											<?php echo form_dropdown('division', $division_list, $submitted_division_id, 'id="division" class="form-control form-select select2"') ?>
										</div>
									</div>
									<div class="form-group col-md-2 mb-0">
										<div class="form-group">
											<input type="text" class="form-control  fromDate" id="report_date_from" name="report_date_from" placeholder="From Date" value="<?php echo $this->input->post('report_date_from') ;?>"  autocomplete="off" >
										</div>
									</div>
									<div class="form-group col-md-2 mb-0">
										<div class="form-group">
											<input type="text" class="form-control  toDate" id="report_date_to" name="report_date_to" placeholder="To Date" value="<?php if ($this->input->post('report_date_to')){  echo $this->input->post('report_date_to'); } //elseif($toDate!=='NIL'){ echo $toDate; } ?>"  autocomplete="off" >
										</div>
									</div>
									
									<div class="form-group col-md-2 mb-0">
										<div class="form-group">
											<?php echo form_dropdown('user_id', $users, $this->input->post('user_id'),'class="form-control form-select select2"'); ?>
										</div>
									</div>
									<div class="form-group col-md-2 mb-0">
										<div class="form-group">
											<?php 
												$quotation_statuses = array(
													'0' => 'All',
													'Draft'=>'Draft',
													'Open'=>'Open',
													'Closed'=>'Closed',
													'Confirmed'=>'Confirmed'
												);
												echo form_dropdown('quotation_status', $quotation_statuses, $this->input->post('quotation_status'),'class="form-control form-select select2"'); 
											?>
										</div>
									</div>
									<div class="col-md-2 mb-0">
										<div class="form-group">
											<button class="btn btn-primary " type="submit" name="results" id="results"  ><i class="fe fe-search"></i></button>
											<button class="btn btn-success " type="button" name="results" id="results" onclick="javascript:window.print();" ><i class="fe fe-printer"></i></button>
										</div>
									</div>
								</div>
							</div>
						</form>
						
						<div class="card col-md-6  col-lg-6 hidePrint " style="float: right;box-shadow: none;border: none;margin-left: auto; margin-right: 0px;">
							<div class="progress grouped h-3 " style="height: 40px !important;">
								<div class="progress-bar w-25 legend-white" role="progressbar">Legend : </div>
								<div class="progress-bar w-25 alert-info" role="progressbar">Draft</div>
								<div class="progress-bar w-25 alert-warning " role="progressbar">Open</div>
								<div class="progress-bar w-25 alert-success" role="progressbar">Confirmed</div>
								<div class="progress-bar w-25 alert-danger" role="progressbar">Closed</div>
							</div>
						</div>
						<div class="row showPrint">
							<div class="clearfix">
								<div class="float-start">
									<?php if(isset($logo_filename)){ ?>
										<img src="<?php echo base_url()."images/company_division/".$logo_filename; ?>" alt="" height="70px;" width="260px;"  class="logo"/>
									<?php } else { 
										if(isset($company_details['company_logo'])){ ?>
										<img src="<?php echo base_url()."images/company_logo/".$company_details['company_logo']; ?>" alt="" height="70px;" width="260px;"  class="logo"/>
									<?php } } ?>
								</div>
								<div class="float-end">
									<address  style=" text-align: right;" >
										<?php if(isset($company_details['company_name'])){ echo $company_details['company_name'];} ?>  <?php if(isset($company_details['cr_number'])){ if($company_details['cr_number']!=""){ echo ' | '.$company_details['cr_number'];}} ?>
										<?php if(isset($company_details['company_address'])){ $company_details['company_address']; } ?>  <br>
										<?php if(isset($company_details['email_id'])){ if($company_details['email_id']!=""){ echo ' | '.$company_details['email_id'].'<br>';}} ?>
										<?php if(isset($company_details['telephone_no'])){ echo $company_details['telephone_no'];} ?>  <?php if(isset($company_details['fax_no'])){ if($company_details['fax_no']!=""){ echo ' | '.$company_details['fax_no'];} } ?>
										<?php if(isset($company_details['tax_no'])){ if($company_details['tax_no']!=""){  echo ' <br> TRN # '.$company_details['tax_no'];  } } ?>
									</address>
								</div>
							</div>
							<div class="card-body text-center ">
								<div class="card-category">Quotation Register</div>
							</div>
							<div class="text-center ">
								<div>&nbsp;</div>
								<div>From : <?php if ($this->input->post('report_date_from')){  echo $this->input->post('report_date_from'); } ?><?php if ($this->input->post('report_date_to')){  echo 'To '.$this->input->post('report_date_to'); } ?> </div>
								<div><?php if(isset($sales_man)){ echo 'Sales Man : '.$sales_man; } ?></div>
								<div><?php if ($this->input->post('quotation_status')){  echo 'Status : '.$this->input->post('quotation_status'); } ?></div>
								<div>&nbsp;</div>
							</div>
						</div>
						<div class="table-responsive" style="min-height: 250px;">
							<button class="btn-danger hidePrint" type="button" name="delete_row" id="delete_row" title="Delete Selected row " style="position: relative; top: 0px;float: right;right: 96px; <?php if($records == false) { echo 'display:none;'; } ?> " ><i class="fa fa-trash-o"></i></button>
							<table id="quotation_register_data" class="table card-table">
								<thead class="thead-light" >
									<tr>
										<th>#</th>
										<th>QTN No</th>
										<th>Date</th>
										<th>Confirmed Date</th>
										<th>Client</th>
										<th>Project</th>
										<th>Salesman</th>
										<th style="text-align:right;" >Amount</th>
										<th>Status</th>
									</tr>
								</thead>
								<tbody>
									<?php
										$totalAmt = 0;
										$tr_count = 1;
										if($records != false) {
											foreach($records as $record){
												$status_colors = array(
													'Draft' => 'alert-info',
													'Open' => 'alert-warning',
													'Closed' => 'alert-danger',
													'Confirmed' => 'alert-success'
												);
									?>
									<tr <?php echo 'class="'.$status_colors[$record['quotation_status']].'"'; ?> >
										<td><?php echo $tr_count++; ?></td>
										<td title="<?php echo '#'.$record['quotation_id']; ?>" >
											<?php echo $record['quotation_number_full']; ?>
										</td>
										<td><?php echo date('M d, Y',strtotime($record['quotation_date'])); ?></td>
										<td><?php if($record['quotation_confirmationdate']!=''){ echo date('M d, Y',strtotime($record['quotation_confirmationdate'])); } ?></td>
										<td><?php echo $record['client_name']; ?></td>
										<td><?php echo $record['project_name']; ?></td>
										<td><?php echo $record['user_name']; ?></td>
										<td class="qtn_amount" data-qtn_amount="<?php echo $record['quotation_amount_with_vat']; ?>" style="text-align:right;" ><?php echo number_format($record['quotation_amount_with_vat'],3); ?></td>
										<td><?php echo $record['quotation_status']; ?></td>
									</tr>
									<?php } ?>			
								</tbody>
          			  			<?php if(isset($furniture_division_total)) { ?>
									<table class="table table-bordered table_new" style="float: right; width: 440px;">
										<tr>
											<td style="background-color: #cacaca;" width="118">Total :</td>
											<td style="text-align:right;" class="grand_total" ><b><?php echo $records[0]['currency_code'].". ".number_format($furniture_division_total,3); ?></b></td>
											<td style="width: 100px;" ></td>
										</tr>
									</table>
								<?php }  } else { ?>
								<tr>
									<td colspan="8">No records available</td>
								</tr><?php } ?>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- CONTAINER CLOSED -->
	</div>
</div>
<script src="<?php echo base_url(); ?>/admincss/plugins/date-picker/jquery-ui.js"></script>
<script type="text/javascript">
$(function(e) {
	var table =  $('#quotation_register_data').DataTable({
		"paging": false,
		"processing": true,
		"scrollCollapse": true,
		"ordering": true,
		"iDisplayLength": 5000000,
		"lengthMenu": false,
        "info": true,
		dom: 'lBfrtip',
        buttons: [
            { extend: 'copyHtml5',title: '',text: 'Copy',header: false, text:'<i class="fa fa-copy"></i>',titleAttr: 'Copy', className: 'btn-primary', exportOptions: {columns: ':visible' } },
			{ extend: 'excelHtml5',title: 'Quotation Register Data',filename: function(){ var today = new Date();var n = today.getTime();return 'QuotationRegisterExcelExport' + today.getDate().toString()+(today.getMonth()+1)+today.getFullYear(); },text: 'Excel', text:'<i class="fa fa-file-excel-o"></i>',titleAttr: 'Excel', className: 'btn-success', exportOptions: {columns: ':visible' } },
			/* { extend: 'print',title: 'Purchase Order Data',filename: function(){ var today = new Date();var n = today.getTime();return 'PurchaseOrderPrintExport' + today.getDate().toString()+(today.getMonth()+1)+today.getFullYear(); },text: 'Print', text:'<i class="fa fa-print"></i>',titleAttr: 'Print', className: 'btn-warning', exportOptions: {columns: ':visible' } },	 */	
			{ extend:'colvis', text:'<i class="fa fa-angle-double-down"></i>',titleAttr: 'Column visibility', className: 'btn-gray'},
		]
	});
	//
	$('#quotation_register_data tbody').on('click', 'tr', function () {
        if ($(this).hasClass('selected')) {
            $(this).removeClass('selected');
        } else {
            table.$('tr.selected').removeClass('selected');
            $(this).addClass('selected');
        }
    });
	
	$('#delete_row').click(function () {
        table.row('.selected').remove().draw(false);
		var grand_total=0;
		$('.qtn_amount').each(function() {
			grand_total+= Number($(this).attr("data-qtn_amount"));
		});
		$('.grand_total').html('BD '+Number.parseFloat(grand_total).toFixed(3));
    });
	// Select2 { extend: 'csvHtml5',text: 'CSV',header: false, text:'<i class="fa fa-file-pdf-o"></i>',titleAttr: 'CSV', className: 'btn-warning' },
	//{ extend: 'colvis',title: '',filename: 'fileName',text: 'Pdf', text:'<i class="fa fa-file-pdf-o"></i>',titleAttr: 'Pdf', className: 'btn-warning' },
});

</script>