<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Journal extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->model('furniture_quotation_model');
		$this->load->helper('num_words');
	}


	public function list_journal($division_id="NIL",$filter_by="NIL",$filter_value="NIL") {
		$this->users_model->permission("Journal", "View");
		$title['headerTitle']="Journal List";
		$this->load->library('pagination');
		if (@$this->input->post('division_id')) {
			$division_id =   $this->input->post("division_id");
		} else if ($division_id != "NIL") {
			$division_id	=	$division_id;
		} else {
			$division_id	= "NIL";
		}
		
		if (@$this->input->post('filter_by')) {
			$filter_by =   $this->input->post("filter_by");
		} else if ($filter_by != "NIL") {
			$filter_by	=	$filter_by;
		} else {
			$filter_by	= "NIL";
		}
		
		
		if (@$this->input->post('filter_value')) {
			$filter_value =   $this->input->post("filter_value");
		} else if ($filter_value != "NIL") {
			$filter_value	=	$filter_value;
		} else {
			$filter_value	= "NIL";
		}
		$config["base_url"] = base_url() . "index.php/General_receipt/list_general_receipt/".$division_id."/".$filter_by."/".$filter_value;
        $config["total_rows"] = $this->furniture_quotation_model->journal_record_count($division_id,$filter_by,$filter_value);
        $config['num_links'] = 10;
        $config["per_page"] = 100;
		$config['uri_segment'] =6;
        $this->pagination->initialize($config);
        if ($this->uri->segment(6)) {
            $page = $this->uri->segment(6)*100-100;
            $i=$page+1;
        } else {
            $page = 0;
            $i=1;
        }
		$data['receipts'] = $this->furniture_quotation_model->get_all_journals($config["per_page"], $page,$division_id,$filter_by,$filter_value);
		$data['pagination'] = $this->pagination->create_links();
		//print_r($this->data['receipts']);exit;
		$this->load->view('templates/header',$title);
		$this->load->view('manage/list_journal',$data);
		$this->load->view('templates/footer');
	}

	public function search_ledgerss() {
		$client	=	$this->input->post('client');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		$clients = explode(" ", trim($client));
		for($i=0;$i<count($clients);$i++) {
			$r	= $clients[$i];
			$sql.=" and ledger_name LIKE '%$r%' ";
		}
		$client_contact_data = $this->db->query("SELECT * FROM `ledgers` where status=1 and (acoount_group_id!=17 and acoount_group_id!=18 and acoount_group_id!=22 and acoount_group_id!=23) and `ledger_name` like '$client%'   union (SELECT * FROM `ledgers` where status=1 and (acoount_group_id!=17 and acoount_group_id!=18 and acoount_group_id!=22 and acoount_group_id!=23) and  `ledger_id` not in (SELECT `ledger_id` FROM `ledgers` where status=1 and (acoount_group_id!=17 and acoount_group_id!=18 and acoount_group_id!=22 and acoount_group_id!=23) and `ledger_name` like '$client%' ) ".$sql." order by ledger_name) limit 25 ");
		$n=1;
		if(count($client_contact_data->result_array())>0){
			$html ='';
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<li value="' .$client_contact_datas['ledger_id'].'" class="client_button" tabindex="'.$n++.'" ><input type="hidden" class="client_name" value="'.$client_contact_datas['ledger_name'].'" /><input type="hidden" class="client_code" value="'.$client_contact_datas['ledger_code'].'" />'.$client_contact_datas['ledger_name'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		
		print $html;
	}
	
	public function create_journal(){
		$this->users_model->permission("Journal", "Add");
		$title['headerTitle']="New Journal";
		$data['books_beginning_date']=$this->furniture_quotation_model->books_beginning_date_config();
		$result = $this->db->query("SELECT MAX(journal_no)+1 as `journal_no` FROM journal where 1 ;");
		$getData = $result->result_array();
			
		if($getData[0]['journal_no'] != NULL and $getData[0]['journal_no'] != ""){
			$journal_no = $getData[0]['journal_no'];
		} else{
			$journal_no = 1;
		}
		$ref_div_id	=	1;
		$data['journal_code']	=	$this->furniture_quotation_model->get_journal_code($ref_div_id,$journal_no);

		$this->load->view('templates/header',$title);
		$this->load->view('manage/create_journal',$data);
		$this->load->view('templates/footer');
	}

	public function search_ledger() {
		$client	=	$this->input->post('client');
		$type	=	$this->input->post('type');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		$clients = explode(" ", trim($client));
		for($i=0;$i<count($clients);$i++) {
			$r	= $clients[$i];
			$sql.=" and ledger_name LIKE '%$r%' ";
		}
		if($type==='dr'){
			$sql2=" and acoount_group_id!=17 ";
		} else {
			$sql2=" and acoount_group_id!=18 ";
		}
		$client_contact_data = $this->db->query("SELECT * FROM `ledgers` where status=1 and `ledger_name` like '$client%' ".$sql2."  union (SELECT * FROM `ledgers` where status=1 and  `ledger_id` not in (SELECT `ledger_id` FROM `ledgers` where status=1 and `ledger_name` like '$client%' ".$sql2." ) ".$sql." ".$sql2." order by ledger_name) limit 25 ");
		$n=1;
		//(acoount_group_id!=17 and acoount_group_id!=18 ) and
		if(count($client_contact_data->result_array())>0){
			$html ='';
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<li value="' .$client_contact_datas['ledger_id'].'" class="client_button" tabindex="'.$n++.'" ><input type="hidden" class="client_name" value="'.$client_contact_datas['ledger_name'].'" /><input type="hidden" class="acoount_group_id" value="'.$client_contact_datas['acoount_group_id'].'" /><input type="hidden" class="client_code" value="'.$client_contact_datas['ledger_code'].'" />'.$client_contact_datas['ledger_name'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		
		print $html;
	}

	function get_outstanding_payments(){
		$client_id = $this->input->post('client');
		$ref_division = $this->input->post('ref_division');
		$journal_code = $this->input->post('journal_code');
		$invoices=$this->furniture_quotation_model->get_outstanding_payment($client_id,$ref_division,$journal_code);

        if ($invoices != false){
			foreach($invoices as $index =>$invoice){
				$amount_paid = $invoice['paid_amount'];
				$invoices[$index]['amount_paid'] =$amount_paid;
			}
        }
		$records['invoices'] = $invoices;
		$records=html_escape($records);
		$this->load->view('manage/search_result_payment2', $records);
	}

	function get_outstanding_invoices(){
		$client_id = $this->input->post('client');
		$ref_division = $this->input->post('ref_division');
		$journal_code = $this->input->post('journal_code');
		$invoices=$this->furniture_quotation_model->get_outstanding_invoices_new2($client_id,$ref_division,$journal_code);
		if ($invoices != false){
				foreach($invoices as $index =>$invoice){
				//$quotation_id = $invoice['quotation_id'];
				//$amount_paid = $this->furniture_quotation_model->get_paid_receipts_total($quotation_id);
				$amount_paid = $invoice['paid_amount'];
				$invoices[$index]['amount_paid'] =$amount_paid;
				$invoices[$index]['balance_amount'] =$invoice['invoice_amount']- $amount_paid;
			}
        }
		
		$records['invoices'] = $invoices;
		//$records['Confirmed_quotations'] = $this->crud_model->get_list4('quotation_number_full','quotation_number_full','view_furniture_quotations_client_project_users',array(''=>' - Select Quotation - '),array('client_code'=>$client_id,'quotation_status'=>"Confirmed"));

		//if($records['invoices'] == false ){
		//	echo '<label style="color:red; font-size:14.5px;">No Invoice List Available..!</label>';
		//} else {
			$records=html_escape($records);
			$this->load->view('manage/search_result_receipt2', $records);
		//}
	}

	public function edit_journal($journal_id){
		$this->users_model->permission("Journal", "Edit");
		$title['headerTitle']="Edit Journal";
		$where=array(
			'journal_id' => $journal_id
		);
		$data['dbdata']=$this->crud_model->get('journal',$where);
		$data['books_beginning_date']=$this->furniture_quotation_model->books_beginning_date_config();
		
		$this->db->select("*");
		$this->db->from('accounts');
		$this->db->join('ledgers','ledgers.ledger_code = accounts.ledger_code','left');
		$this->db->where('accounts.`vch_type`', 'JOURNAL');
		$this->db->where('accounts.`vch_no`', $data['dbdata'][0]['journal_code']);
		$this->db->order_by('accounts.id', 'asc');
		$rs = $this->db->get();
		$data['details']    = $rs->result_array();
		
		$this->load->view('templates/header',$title);
		$this->load->view('manage/edit_journal',$data);
		$this->load->view('templates/footer');
	}

	public function save_journal(){
		$this->users_model->permission("Journal", "Add");
		$this->form_validation->set_rules('journal_date','Date', 'required');

		if ($this->form_validation->run() == FALSE) {
			$title['headerTitle']="New Journal";
			$data['books_beginning_date']=$this->furniture_quotation_model->books_beginning_date_config();
			$result = $this->db->query("SELECT MAX(journal_no)+1 as `journal_no` FROM journal where 1 ;");
			$getData = $result->result_array();
			if($getData[0]['journal_no'] != NULL and $getData[0]['journal_no'] != ""){
				$journal_no = $getData[0]['journal_no'];
			} else{
				$journal_no = 1;
			}
			$ref_div_id	=	1;
			$data['journal_code']	=	$this->furniture_quotation_model->get_journal_code($ref_div_id,$journal_no);

			$this->load->view('templates/header',$title);
			$this->load->view('manage/create_journal',$data);
			$this->load->view('templates/footer');
		} else {
			
			$this->db->trans_begin();
			$division_id = $this->input->post('division_id');
			$result = $this->db->query("SELECT MAX(journal_no)+1 as `journal_no` FROM journal where 1 ;");
			$getData = $result->result_array();
			if($getData[0]['journal_no'] != NULL and $getData[0]['journal_no'] != ""){
				$journal_no = $getData[0]['journal_no'];
			} else{
				$journal_no = 1;
			}
			$ref_div_id	=	$division_id;
			$journal_date			=	date("Y-m-d h:m:s", strtotime($this->input->post('journal_date')));
			$journal_code 			= $this->furniture_quotation_model->get_journal_code($ref_div_id,$journal_no);
			$journal['journal_no'] 	= $journal_no;
			$journal['journal_code']= $journal_code;
			$journal['division_id'] = $division_id;
			$journal['journal_date']= $journal_date;
			/* $journal['dr_amount']= ((float)$this->input->post('i_total'));
			$journal['cr_amount'] 	= ((float)$this->input->post('cash')); */
			
			$journal['journal_status'] 	= 1;
			$journal['journal_remarks'] = $this->input->post("remarks");
			$journal['journal_generatedby'] = $this->session->userdata("user_id");
			$rcpt = $this->crud_model->insert('journal',$journal);
			$journal_id = $this->db->insert_id();
			
			if($journal_id){
				
			
				$this->db->where("vch_no",$journal_code);
				$this->db->where("vch_type",'JOURNAL');
				$this->db->delete('accounts');
				$ledger_code = $this->input->post('ledger_code');
				
				$type 		 = $this->input->post('type');
				$dr_amount   = $this->input->post('dr_amount');
				$cr_amount   = $this->input->post('cr_amount');
				$rev_ledger_code  = $this->input->post('rev_ledger_code');
				$narrations  = $this->input->post('narrations');
				$job_id = $this->input->post('job_id');
				$total_dr_amount=0;
				$total_cr_amount=0;
				for($i=0; $i<count($ledger_code); $i++){	
					if($ledger_code[$i]!==""){
						if($type[$i]==='dr'){
							$led_amount=(float)$dr_amount[$i];
							$total_dr_amount=$total_dr_amount+(float)$dr_amount[$i];
						} else {
							$led_amount=-1*(float)$cr_amount[$i];
							$total_cr_amount=$total_cr_amount+(float)$cr_amount[$i];
						}
						
						$accounts_data = array(
							'vch_type' 	  => 'JOURNAL',
							'vch_no'  	  => $journal_code,
							'vch_date'    => $journal_date,
							'vch_ref'     => '',
							'ledger_code' => $ledger_code[$i],
							'rev_ledger_code' => $rev_ledger_code[$i],
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'=> (float)$led_amount,
							'ledger_narration'=> $narrations[$i],
							'vch_narration'=> $this->input->post("remarks"),
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
						$this->db->insert('accounts', $accounts_data);

						if($job_id[$i]!='' && $job_id[$i]!=='0'){
							$job_allocation_data = array(
								'vch_type'    => 'Journal',
								'vch_no'      => $journal_code,
								'vch_date'    => $journal_date,
								'job_id'      => $job_id[$i],
								'ledger_code' => $ledger_code[$i],
								'ledger_amount' => round($led_amount,3),
								'created_date'=> date('Y-m-d'),
								'user_id' 	  => $this->session->userdata("user_id"),
								'status'	  => 1
							);
							$this->db->insert('job_allocation', $job_allocation_data);
						}

					}
					
					$paying_amnt =$this->input->post('current_amount_invoice_'.$ledger_code[$i]);
					$invoice_id =$this->input->post('invoice_id_'.$ledger_code[$i]);
					if (is_countable($invoice_id)) {
						//print_r($invoice_id);
						for($m=0;$m<count($invoice_id);$m++) {
							if($invoice_id[$m]!="" && $paying_amnt[$m]!="" && $paying_amnt[$m]!="0"){
								if($type[$i]==='dr'){
									$supppp=((float)$paying_amnt[$m]*-1);
								} else {
									$supppp=((float)$paying_amnt[$m]);
								}
								$cust_bill_allocations_data = array(
									'supplier_code' => $ledger_code[$i],
									'bill_id'       => $invoice_id[$m],
									'trn_no'        => $journal_code,
									'bill_date'     => $journal_date,
									'bill_amt'      => $supppp,
									'bill_os_amount'=> $supppp,
									'bill_type'     => 'Payment',
									'division_id'   => $division_id,
									'trn_type'      => 'JOURNAL'
								);
								$this->db->insert('supplier_bill_allocations',$cust_bill_allocations_data);
							}
						}
					}
						
					$cust_paying_amnt =$this->input->post('cust_amount_invoice_'.$ledger_code[$i]);
					$cust_invoice_id =$this->input->post('cust_invoice_id_'.$ledger_code[$i]);
					$cust_sm_id =$this->input->post('cust_sm_id_'.$ledger_code[$i]);
					if (is_countable($cust_invoice_id)) {
						//print_r($invoice_id);
						for($m=0;$m<count($cust_invoice_id);$m++) {
							if($cust_invoice_id[$m]!="" && $cust_paying_amnt[$m]!="" && $cust_paying_amnt[$m]!="0"){
								if($type[$i]==='dr'){
									$ddd=((float)$cust_paying_amnt[$m]);
								} else {
									$ddd=((float)$cust_paying_amnt[$m]*-1);
								}
								$cust_bill_allocations_data = array(
									'customer_code' => $ledger_code[$i],
									'bill_id'       => $cust_invoice_id[$m],
									'trn_no'        => $journal_code,
									'bill_date'     => $journal_date,
									'bill_amt'      => $ddd,
									'bill_os_amount'=> $ddd,
									'bill_type'     => 'Receipt',
									'division_id'   => $division_id,
									'sm_id'   		=> $cust_sm_id[$m],
									'trn_type'      => 'JOURNAL'
								);
								$this->db->insert('cust_bill_allocations',$cust_bill_allocations_data);
							}
						}
					}
				}

				if(round($total_dr_amount,3)!=round($total_cr_amount,3)){
					$this->db->where("vch_no",$journal_code);
					$this->db->where("vch_type",'JOURNAL');
				    $this->db->delete('accounts');

					$this->db->where("trn_no",$journal_code);
					$this->db->where("trn_type",'JOURNAL');
				    $this->db->delete('cust_bill_allocations');

					$this->db->where("trn_no",$journal_code);
					$this->db->where("trn_type",'JOURNAL');
				    $this->db->delete('supplier_bill_allocations');

					$this->db->where("journal_id",$journal_id);
					$this->db->delete('journal');

					$this->session->set_flashdata('response', 'Debit and Credit are not equal, Please Try Again...');	
					redirect('Journal/list_journal');
				}

				$up_accnt_data = array(
					'dr_amount' => $total_dr_amount,
					'cr_amount' => $total_cr_amount,
				);
				$this->db->where('journal_id', $journal_id);
				$this->db->update('journal', $up_accnt_data);

				
				$log_data=array(
					'trans_no'  	=>  $journal_code,
					'trans_type'  	=>  'JOURNAL',
					'trans_op'  	=>  'Create',
					'trans_user_id' =>  $this->session->userdata('user_id')

				);
				$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);
			
				if ($this->db->trans_status() === FALSE) {
					$this->db->trans_rollback();
					$this->session->set_flashdata('response', 'Something Wrong, Please Try Again...');	
					redirect('Journal/list_journal');
				} else {
					$this->db->trans_commit();
					$this->session->set_flashdata('success', 'New Journal Created...');	
					redirect('Journal/list_journal');
				}
			}
		}
	}

	public function do_update_journal($journal_id){
		$this->users_model->permission("Journal", "Edit");
		$this->form_validation->set_rules('journal_date','Date', 'required');
		$this->form_validation->set_rules('journal_code','Code', 'required');

		if ($this->form_validation->run() == FALSE) {
			$title['headerTitle']="Edit Journal";
			$where=array(
				'journal_id' => $journal_id
			);
			$data['dbdata']=$this->crud_model->get('journal',$where);
			$data['books_beginning_date']=$this->furniture_quotation_model->books_beginning_date_config();
			
			$this->db->select("*");
			$this->db->from('accounts');
			$this->db->join('ledgers','ledgers.ledger_code = accounts.ledger_code','left');
			$this->db->where('accounts.`vch_type`', 'JOURNAL');
			$this->db->where('accounts.`vch_no`', $data['dbdata'][0]['journal_code']);
			$rs = $this->db->get();
			$data['details']    = $rs->result_array();
			
			$this->load->view('templates/header',$title);
			$this->load->view('manage/edit_journal',$data);
			$this->load->view('templates/footer');
		} else {
			
			$this->db->trans_begin();
			$division_id = $this->input->post('division_id');
			$ref_div_id	=	$division_id;
			$journal_date			=	date("Y-m-d h:m:s", strtotime($this->input->post('journal_date')));
			$journal['journal_date']= $journal_date;
			$journal_code	=	$this->input->post("journal_code");
			/* $journal['dr_amount']= ((float)$this->input->post('i_total'));
			$journal['cr_amount'] 	= ((float)$this->input->post('cash')); */
			
			$journal['journal_status'] 	= 1;
			$journal['journal_remarks'] = $this->input->post("remarks");
			$journal['journal_generatedby'] = $this->session->userdata("user_id");
			$rcpt = $this->crud_model->update('journal',$journal,array("journal_id"=>$journal_id));
			
			if($journal_id){
				$this->db->where("vch_no",$journal_code);
				$this->db->where("vch_type",'JOURNAL');
				$this->db->delete('accounts');

				$this->db->where("trn_no",$journal_code);
				$this->db->where("trn_type",'JOURNAL');
				$this->db->delete('supplier_bill_allocations');

				$this->db->where("trn_no",$journal_code);
				$this->db->where("trn_type",'JOURNAL');
				$this->db->delete('cust_bill_allocations');

				$this->db->where("vch_no",$journal_code);
				$this->db->where("vch_type",'Journal');
				$this->db->delete('job_allocation');

				$ledger_code = $this->input->post('ledger_code');
				$type 		 = $this->input->post('type');
				$dr_amount   = $this->input->post('dr_amount');
				$cr_amount   = $this->input->post('cr_amount');
				$rev_ledger_code  = $this->input->post('rev_ledger_code');
				$narrations  = $this->input->post('narrations');
				$job_id = $this->input->post('job_id');
				$total_dr_amount=0;
				$total_cr_amount=0;
				$acc_id = $this->input->post('acc_id');
				$a=0;
				$nb_rev_ledger_code	='';
				$total_le_amount=0;
				for($i=0; $i<count($ledger_code); $i++){	
					if($ledger_code[$i]!==""){
						if(@$acc_id[$i]!=''){
							$id=$acc_id[$i];
						} else {
							$id=NULL;
						}
						if($type[$i]==='dr'){
							$led_amount=(float)$dr_amount[$i];
							$total_dr_amount=$total_dr_amount+(float)$dr_amount[$i];
						} else {
							$led_amount=-1*(float)$cr_amount[$i];
							$total_cr_amount=$total_cr_amount+(float)$cr_amount[$i];
						}
						$accounts_data = array(
							'id'		  => $id,
							'vch_type' 	  => 'JOURNAL',
							'vch_no'  	  => $journal_code,
							'vch_date'    => $journal_date,
							'vch_ref'     => '',
							'ledger_code' => $ledger_code[$i],
							'rev_ledger_code' => $rev_ledger_code[$i],
							'cc_code' 	  => 1,
							'div_code' 	  => 1,
							'ledger_amount'=> (float)$led_amount,
							'ledger_narration'=> $narrations[$i],
							'vch_narration'=> $this->input->post("remarks"),
							'user_id' 	  => $this->session->userdata("user_id"),
							'status'      => 1
						);
						$this->db->insert('accounts', $accounts_data);

						if($job_id[$i]!='' && $job_id[$i]!=='0'){
							$job_allocation_data = array(
								'vch_type'    => 'Journal',
								'vch_no'      => $journal_code,
								'vch_date'    => $journal_date,
								'job_id'      => $job_id[$i],
								'ledger_code' => $ledger_code[$i],
								'ledger_amount' => round($led_amount,3),
								'created_date'=> date('Y-m-d'),
								'user_id' 	  => $this->session->userdata("user_id"),
								'status'	  => 1
							);
							$this->db->insert('job_allocation', $job_allocation_data);
						}

						$paying_amnt=$this->input->post('current_amount_invoice_'.$ledger_code[$i]);
						$invoice_id =$this->input->post('invoice_id_'.$ledger_code[$i]);
						if (is_countable($invoice_id)) {
							//print_r($invoice_id);
							for($m=0;$m<count($invoice_id);$m++) {
								if($invoice_id[$m]!="" && $paying_amnt[$m]!="" && $paying_amnt[$m]!="0"){
									if($type[$i]==='dr'){
										$supppp=((float)$paying_amnt[$m]*-1);
									} else {
										$supppp=((float)$paying_amnt[$m]);
									}
									$cust_bill_allocations_data = array(
										'supplier_code' => $ledger_code[$i],
										'bill_id'       => $invoice_id[$m],
										'trn_no'        => $journal_code,
										'bill_date'     => $journal_date,
										'bill_amt'      => $supppp,
										'bill_os_amount'=> $supppp,
										'bill_type'     => 'Payment',
										'division_id'   => $division_id,
										'trn_type'      => 'JOURNAL'
									);
									$this->db->insert('supplier_bill_allocations',$cust_bill_allocations_data);
								}
							}
						}
						$cust_paying_amnt =$this->input->post('cust_amount_invoice_'.$ledger_code[$i]);
						$cust_invoice_id =$this->input->post('cust_invoice_id_'.$ledger_code[$i]);
						$cust_sm_id =$this->input->post('cust_sm_id_'.$ledger_code[$i]);
						if (is_countable($cust_invoice_id)) {
							//print_r($invoice_id);
							for($m=0;$m<count($cust_invoice_id);$m++) {
								if($cust_invoice_id[$m]!="" && $cust_paying_amnt[$m]!="" && $cust_paying_amnt[$m]!="0"){
									if($type[$i]==='dr'){
										$ddd=((float)$cust_paying_amnt[$m]);
									} else {
										$ddd=((float)$cust_paying_amnt[$m]*-1);
									}
									$cust_bill_allocations_data = array(
										'customer_code' => $ledger_code[$i],
										'bill_id'       => $cust_invoice_id[$m],
										'trn_no'        => $journal_code,
										'bill_date'     => $journal_date,
										'bill_amt'      => $ddd,
										'bill_os_amount'=> $ddd,
										'bill_type'     => 'Receipt',
										'division_id'   => $division_id,
										'sm_id'   		=> $cust_sm_id[$m],
										'trn_type'      => 'JOURNAL'
									);
									$this->db->insert('cust_bill_allocations',$cust_bill_allocations_data);
								}
							}
						}

					}		
				}

				$log_data=array(
					'trans_no'  	=>  $journal_code,
					'trans_type'  	=>  'JOURNAL',
					'trans_op'  	=>  'Edit',
					'trans_user_id' =>  $this->session->userdata('user_id')

				);
				$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);

				if(round($total_dr_amount,3)!=round($total_cr_amount,3)){
					
					$this->db->where("vch_no",$journal_code);
					$this->db->where("vch_type",'JOURNAL');
				    $this->db->delete('accounts');

					$this->db->where("trn_no",$journal_code);
					$this->db->where("trn_type",'JOURNAL');
					$this->db->delete('supplier_bill_allocations');

					$this->db->where("trn_no",$journal_code);
					$this->db->where("trn_type",'JOURNAL');
					$this->db->delete('cust_bill_allocations');

					$this->db->where("vch_no",$journal_code);
					$this->db->where("vch_type",'Journal');
					$this->db->delete('job_allocation');


					/* $this->db->where("journal_id",$journal_id);
					$this->db->delete('journal'); */
					$total_dr_amount=0;
					$total_cr_amount=0;

					$up_accnt_data = array(
						'dr_amount' => $total_dr_amount,
						'cr_amount' => $total_cr_amount,
					);
					$this->db->where('journal_id', $journal_id);
					$this->db->update('journal', $up_accnt_data);

					$this->db->trans_commit();
					$this->session->set_flashdata('response', 'Debit and Credit are not equal, Please Try Again...');	
					redirect('Journal/list_journal');
				}

				$up_accnt_data = array(
					'dr_amount' => $total_dr_amount,
					'cr_amount' => $total_cr_amount,
				);
				$this->db->where('journal_id', $journal_id);
				$this->db->update('journal', $up_accnt_data);
			
				if ($this->db->trans_status() === FALSE) {
					$this->db->trans_rollback();
					$this->session->set_flashdata('response', 'Something Wrong, Please Try Again...');	
					redirect('Journal/list_journal');
				} else {
					$this->db->trans_commit();
					$this->session->set_flashdata('success', 'Journal Updated...');	
					redirect('Journal/list_journal');
				}
			}
		}
	}

	function view1($journal_id,$type){
		$where=array(
			'journal_id' => $journal_id
		);
		$data['records']=$this->crud_model->get('journal',$where);

		
		/* $where= array('receipt_number'=>$receipt_no);
		$data['records'] = $this->furniture_quotation_model->get_receipt_details($receipt_no,$journal_id,$quotation_divisionid); */
		$data['base_url'] = base_url();

		$data['logos_url'] = array();

		$data['journal_code'] = $data['records'][0]['journal_code'];
		$data['receipt_number'] = $data['records'][0]['journal_no'];
		$data['journal_date'] = $data['records'][0]['journal_date'];
		$data['journal_remarks'] = $data['records'][0]['journal_remarks'];
		$data['journal_status'] = $data['records'][0]['journal_status'];
		$data['division_id'] = $data['records'][0]['division_id'];
		$data['dr_amount'] = $data['records'][0]['dr_amount'];
		$data['cr_amount'] = $data['records'][0]['cr_amount'];

		$temp = $data['records'][0]['journal_generatedby'];

		$this->db->select("*");
		$this->db->from('accounts');
		$this->db->join('ledgers','ledgers.ledger_code = accounts.ledger_code','left');
		$this->db->where('accounts.`vch_type`', 'JOURNAL');
		$this->db->where('accounts.`status`', 1);
		$this->db->where('accounts.`vch_no`', $data['records'][0]['journal_code']);
		$this->db->order_by('accounts.id', 'asc');
		$rs = $this->db->get();
		
		$data['details']    = $rs->result_array();
		
		$query = $this->db->get('company_details');  
		$data['company_details'] = $query->row();
		foreach ($query->result() as $row){
			$company_email_name =  $row->company_name;
		}

		$where=array(
			'division_id' => $data['records'][0]['division_id']
		);
		$logodata=$this->crud_model->get('company_division',$where);
		if($logodata!=false){
			$data['logo_filename'] = $logodata[0]['logo_filename'];
		} else {
			$data['logo_filename'] = NULL;
		}
		if($type=="pdf"){
			$records['print_type'] = "pdf_print_type";
			//$this->load->helper(array('dompdf', 'file'));
			$mpdf = new \Mpdf\Mpdf();
			$html = $this->load->view('manage/print_journal', $data, true);
			//echo $html;
			$footer_html='<footer>
			<table width="100%"  >
				<tr>
					<td >
						<p></p>
						<br/>
						<p></p>
					</td>
					<td align="right"  style="padding-right: 25px;" >
						<p></p>
						<br/><br/>
						<p>Authorised signatory</p>
					</td>
				</tr>
			</table>
		</footer>';
			$mpdf->WriteHTML($html);
			$file_name	=	'Journal Voucher - '.$data['records'][0]['journal_code'];
			$mpdf->SetHTMLFooter($footer_html);
			$mpdf->Output($file_name, 'I');
		}
	} // End of receipt view1

	
	public function cancel_journal($journal_code,$journal_id){
		$this->users_model->permission("Journal", "Delete");
		$this->db->where('journal_id',$journal_id);
		$data = array(
			'journal_status' => 0,
			'journal_cancelledby' => $this->session->userdata('user_name'),
			'journal_cancelled_date' => date('Y-m-d h:m:s')
		);
		$receipt_cancel	= $this->db->update('journal', $data);
		
		$this->db->where('vch_no',$journal_code);
		$data1 = array(
			'status' => 0
		);
		$this->db->update('accounts', $data1);

		$this->db->where('trn_no',$journal_code);
		$data1 = array(
			'status' => 0
		);
		$this->db->update('cust_bill_allocations', $data1);

		$this->db->where('trn_no',$journal_code);
		$data1 = array(
			'status' => 0
		);
		$this->db->update('supplier_bill_allocations', $data1);

		$this->db->where('vch_no',$journal_code);
		$this->db->where('vch_type','Journal');
		$data1 = array(
			'status' => 0
		);
		$this->db->update('job_allocation', $data1);
		
		$log_data=array(
			'trans_no'  	=>  $journal_code,
			'trans_type'  	=>  'JOURNAL',
			'trans_op'  	=>  'Cancel',
			'trans_user_id' =>  $this->session->userdata('user_id')

		);
		$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);
		
		if($receipt_cancel){
			$this->session->set_flashdata('response', 'Journal Cancelled...');
		}else{
			$this->session->set_flashdata('response', 'Something Wrong.Try Again...');
		}
		redirect('Journal/list_journal');
	}

	public function search_job_no() {
		$client	=	$this->input->post('client');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		
		$client_contact_data = $this->db->query("SELECT * FROM `view_furniture_job_card` where `job_card_status`='Draft' AND ( `job_card_number` like '%$client%' OR `client_name` like '%$client%' OR `project_name` like '%$client%'  )   ".$sql." order by client_name limit 25 ");
		$n=1;
		if(count($client_contact_data->result_array())>0){
			$html='<tr class="no_result_button" tabindex="-1"><th><b>Name</b></th><th><b>Project</b></th><th><b>Job No</b></th></tr>';
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<tr tabindex="-1" class="client_button" ><td><input type="hidden" class="nbcli_id" value="' .$client_contact_datas['client_id'].'" /><input type="hidden" class="client_name" value="'.$client_contact_datas['client_name'].'" /><input type="hidden" class="project_name" value="'.$client_contact_datas['project_name'].'" /><input type="hidden" class="job_card_number" value="'.$client_contact_datas['job_card_number'].'" /><input type="hidden" class="job_card_id" value="'.$client_contact_datas['job_card_id'].'" /> '.$client_contact_datas['client_name'].'</td><td>'.$client_contact_datas['project_name'].'</td><td>'.$client_contact_datas['job_card_number'].'</td></tr>';
			}
		} else {
			$html.='<tr class="no_result_button" tabindex="-1"><td style="color:red;" colspan="3" > No Results Found </td></tr>';
		}
		print $html;
	}

}

?>