<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Search extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->model('furniture_quotation_model');
		$this->load->model('Vehicle');
	}		
	public function updateItem(){
		$this->db->select('*');
		$this->db->from('items_temp');
		$query = $this->db->get();
		if($query->num_rows() > 0){
		 	foreach($query->result_array() as $row){
				echo $row['id'].",".$row['cost_price'].",".$row['selling_price'].",".$row['vat_percentage'].",".$row['unit_id'].",".$row['unit'].",".$row['item_type'].",".$row['is_sales'].",".$row['is_purchase'].",".$row['item_file_name'].",".$row['item_packing'].",".$row['reorder_level'].",".$row['status'].",".$row['balance_qty']."<br/>";
				$update_data = array(
					'last_purchase_supplier'  	  => NULL,
					'cost_price'     => $row['cost_price'],
					'selling_price'	 => $row['selling_price'],
					'vat_percentage' => $row['vat_percentage'],
					'unit_id'   	 => $row['unit_id'],
					'unit'      	 => $row['unit'],
					'item_type' 	 => $row['item_type'],
					'is_sales' 		 => $row['is_sales'],
					'is_purchase' 	 => $row['is_purchase'],
					'item_file_name' => $row['item_file_name'],
					'item_packing' 	 => $row['item_packing'],
					'reorder_level' 	 => $row['reorder_level'],
					'status' 	 => $row['status'],
					'balance_qty' 	 => $row['balance_qty'],
				);			
				$where= array('id'=>$row['id']);
				$this->crud_model->update('items',$update_data,$where );	
				/* 'pur_vat'     => 0,
					'pur_discount'=> 0,
					'sign' 	  	  => '-',
					'round_off'   => 0,
					'status'      => 'Draft',
					'pur_net_amt' => 0,
					'fx_pi_gross_amt' => 0,
					'fx_pi_discount' => 0,
					'fx_pi_net_amt' => 0 */
			}
		}
	}

	public function JobsPending() {
		$search_item = $this->input->post('search_item');
		//$test=$this->furniture_quotation_model->myEnquiries(10,0,$search_item);
		$user_id 	 = $this->session->userdata('user_id');
		$sql= " E.status='1' AND (E.`salesman_id` = '$user_id' OR E.`salesman_id`='0')";

		$sql = "";

		$this->db->select('*');
		$this->db->from('job_card');
		$this->db->where('job_card_status !=', 'Completed');
		$this->db->where('job_card_status !=', 'Cancelled');
		$this->db->where('job_card_status =', 'Draft');
		$this->db->order_by('job_card_number ','DESC');
		$rs = $this->db->get();

		$make  = $this->Vehicle->getMake();
		$model  = $this->Vehicle->getModel();
		$customer  = $this->Vehicle->getCustomer();
		$customerArray = array_column($customer ,'client_name','client_id');
		$modelArray = array_column($model ,'title','id');
		$makeArray = array_column($make ,'title','id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>#.</th>
						<th>Job No</th>
						<th>Job Date</th>
						<th>Customer Name</th>
						<th>Vehicle</th>
						<th>Reg.No</th>
					</tr>
				</thead>';
		if($rs->num_rows() > 0){
			$count=0;
			$i = 1;
			foreach($rs->result_array() as $jbrec){ 
				if(isset($jbrec['client_id']) && isset($customerArray[$jbrec['client_id']])){
					$client_name  = $customerArray[$jbrec['client_id']];
				}
				else{
					$client_name  = '';
				}
				if(isset($jbrec['model']) && isset($modelArray[$jbrec['model']])){
					$model_name  = $modelArray[$jbrec['model']];
				}
				else{
					$model_name  = '';
				}

				if(isset($jbrec['make']) && isset($makeArray[$jbrec['make']])){
					$make_name  = $makeArray[$jbrec['make']];
				}
				else{
					$make_name  = '';
				}

				
				$count++;
				$now = time(); // or your date as well
				$your_date = strtotime($jbrec['job_card_date']);
				$datediff = $now - $your_date;
				$days=round($datediff / (60 * 60 * 24));
				$list.='<tr>
						<td>'.$i++.'</td>
						<td><a href="'.site_url('jobcard/Vehicle_jobcard/editVjobcard/').$jbrec['id'].'" >'.$jbrec['job_card_number'].'</a></td>						
						<td>'.date("M d, Y", strtotime($jbrec['job_card_date'])).'</td>
						<td>'.$client_name.'</td>
						<td>'.$make_name.' - '.str_replace('-','',$model_name).'</td>
						<td>'.$jbrec['reg_no'].'</td>
					</tr>';
				 
			}
		} else {
			$list.='<tr>
						<td  style="color: red;">No records available</td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
					</tr>';
		}
		echo json_encode($list);
	}
	
	public function JobsCompleted(){
		$search_item = $this->input->post('search_item');
		//$test=$this->furniture_quotation_model->myEnquiries(10,0,$search_item);
		$user_id 	 = $this->session->userdata('user_id');
		$sql= " E.status='1' AND (E.`salesman_id` = '$user_id' OR E.`salesman_id`='0')";

		$sql = "";

		$this->db->select('*');
		$this->db->from('job_card');
		$this->db->where('job_card_status =', 'Completed');
		$this->db->where('job_card_status !=', 'Cancelled');
		$this->db->where('job_card_status !=', 'Draft');
		$this->db->order_by('job_card_number ','DESC');
		$rs = $this->db->get();
		$make  = $this->Vehicle->getMake();
		$model  = $this->Vehicle->getModel();
		$customer  = $this->Vehicle->getCustomer();
		$customerArray = array_column($customer ,'client_name','client_id');
		$modelArray = array_column($model ,'title','id');
		$makeArray = array_column($make ,'title','id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>#.</th>
						<th>Job No</th>
						<th>Job Date</th>
						<th>Customer Name</th>
						<th>Vehicle</th>
						<th>Reg.No</th>
					</tr>
				</thead>';
		if($rs->num_rows() > 0){
			$count=0;
			$i = 1;
			foreach($rs->result_array() as $jbrec){ 
				if(isset($jbrec['client_id']) && isset($customerArray[$jbrec['client_id']])){
					$client_name  = $customerArray[$jbrec['client_id']];
				}
				else{
					$client_name  = '';
				}
				if(isset($jbrec['model']) && isset($modelArray[$jbrec['model']])){
					$model_name  = $modelArray[$jbrec['model']];
				}
				else{
					$model_name  = '';
				}

				if(isset($jbrec['make']) && isset($makeArray[$jbrec['make']])){
					$make_name  = $makeArray[$jbrec['make']];
				}
				else{
					$make_name  = '';
				}				
				$count++;
				$now = time(); // or your date as well
				$your_date = strtotime($jbrec['job_card_date']);
				$datediff = $now - $your_date;
				$days=round($datediff / (60 * 60 * 24));
				$list.='<tr>
						<td>'.$i++.'</td>
						<td><a href="'.site_url('Invoices/invoice_from/').$jbrec['id'].'" >'.$jbrec['job_card_number'].'</a></td>						
						<td>'.date("M d, Y", strtotime($jbrec['job_card_date'])).'</td>
						<td>'.$client_name.'</td>
						<td>'.$make_name.' - '.str_replace('-','',$model_name).'</td>
						<td>'.$jbrec['reg_no'].'</td>
					</tr>';
				 
			}
		} else {
			$list.='<tr>
						<td  style="color: red;">No records available</td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
					</tr>';
		}
		echo json_encode($list);
	}
	public function jobCancelled(){
		$search_item = $this->input->post('search_item');
		//$test=$this->furniture_quotation_model->myEnquiries(10,0,$search_item);
		$user_id 	 = $this->session->userdata('user_id');
		$sql= " E.status='1' AND (E.`salesman_id` = '$user_id' OR E.`salesman_id`='0')";

		$sql = "";

		$this->db->select('*');
		$this->db->from('job_card');
		$this->db->where('job_card_status !=', 'Completed');
		$this->db->where('job_card_status =', 'Cancelled');
		$this->db->where('job_card_status !=', 'Draft');
		$rs = $this->db->get();

		$make  = $this->Vehicle->getMake();
		$model  = $this->Vehicle->getModel();
		$customer  = $this->Vehicle->getCustomer();
		$customerArray = array_column($customer ,'client_name','client_id');
		$modelArray = array_column($model ,'title','id');
		$makeArray = array_column($make ,'title','id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>#.</th>
						<th>Job No</th>
						<th>Job Date</th>
						<th>Client Name</th>
						<th>Vehicle</th>
						<th>Reg.No</th>
					</tr>
				</thead>';
		if($rs->num_rows() > 0){
			$count=0;
			$i = 1;
			foreach($rs->result_array() as $jbrec){ 
				if(isset($jbrec['client_id']) && isset($customerArray[$jbrec['client_id']])){
					$client_name  = $customerArray[$jbrec['client_id']];
				}
				else{
					$client_name  = '';
				}
				if(isset($jbrec['model']) && isset($modelArray[$jbrec['model']])){
					$model_name  = $modelArray[$jbrec['model']];
				}
				else{
					$model_name  = '';
				}

				if(isset($jbrec['make']) && isset($makeArray[$jbrec['make']])){
					$make_name  = $makeArray[$jbrec['make']];
				}
				else{
					$make_name  = '';
				}

				
				$count++;
				$now = time(); // or your date as well
				$your_date = strtotime($jbrec['job_card_date']);
				$datediff = $now - $your_date;
				$days=round($datediff / (60 * 60 * 24));
				$list.='<tr>
						<td>'.$i++.'</td>
						<td>'.$jbrec['job_card_number'].'</td>						
						<td>'.date("M d, Y", strtotime($jbrec['job_card_date'])).'</td>
						<td>'.$client_name.'</td>
						<td>'.$make_name.' - '.str_replace('-','',$model_name).'</td>
						<td>'.$jbrec['reg_no'].'</td>
					</tr>';
				 
			}
		} else {
			$list.='<tr>
						<td  style="color: red;">No records available</td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
					</tr>';
		}
		echo json_encode($list);
	}

	public function myEnquiries() {
		$search_item = $this->input->post('search_item');
		//$test=$this->furniture_quotation_model->myEnquiries(10,0,$search_item);
		$user_id 	 = $this->session->userdata('user_id');
		$sql= " E.status='1' AND (E.`salesman_id` = '$user_id' OR E.`salesman_id`='0')";
		$query= $this->db->query("SELECT E.`id`,E.enquiry_number,E.salesman_id,E.prospect_name,E.enquiry_date,U.user_name as salesman_name,UC.user_name as created_user FROM `enquiry` E Left JOIN `users` UC ON UC.user_id=E.Created_User_id Left JOIN `users` U ON U.user_id=E.salesman_id  WHERE ".$sql." order by E.salesman_id,E.enquiry_date asc  Limit 500");
		$test= $query->result();
		$list=	'<thead class="thead-light">
					<tr>
						<th>Enq No.</th>
						<th>Client</th>
						<th>Enq Date</th>
						<th>Salesman</th>
						<th>Created By</th>
						<th>Days</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myEnquiry){ 
				$count++;
				if($myEnquiry->salesman_id==='' || $myEnquiry->salesman_id==='0' ){ $salesman_name='Un Assigned'; } else { $salesman_name=$myEnquiry->salesman_name; }
				$now = time(); // or your date as well
				$your_date = strtotime($myEnquiry->enquiry_date);
				$datediff = $now - $your_date;
				$days=round($datediff / (60 * 60 * 24));
				$list.='<tr>
						<td><a href="'.base_url().'index.php/furniture/Enquiry/editenquiry/'.$myEnquiry->id.'" >'.$myEnquiry->enquiry_number.'</a></td>
						<td>'.$myEnquiry->prospect_name.'</td>
						<td>'.date("M d, Y", strtotime($myEnquiry->enquiry_date)).'</td>
						<td>'.$salesman_name.'</td>
						<td>'.$myEnquiry->created_user.'</td>
						<td>'.$days.'</td>
					</tr>';
			}
		} else {
			$list.='<tr>
						<td  style="color: red;">No records available</td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
					</tr>';
		}
		echo json_encode($list);
	}

	public function myQuotations() {
		$search_item = '';
		$test=$this->furniture_quotation_model->myActions(500,0,$search_item);
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Qtn No.</th>
						<th>Client</th>
						<th>Qtn Date</th>
						<th>Project</th>
						<th>Salesman</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				$list.='<tr>
					<td><a href="'.site_url('manage_quotation/quotation/'.$myAction->trans_id.'/'.$myAction->quotation_divisionid.'/'.$myAction->quotation_number).'">'.$myAction->quotation_number_full.'</a></td>
					<td>'.$myAction->client_name.'</td>
					<td>'.date("M d, Y", strtotime($myAction->quotation_date)).'</td>
					<td>'.$myAction->project_name.'</td>
					<td>'.$myAction->salesman_name.'</td>
				</tr>';
			}
		} else {
			$list.='<tr>
				<td  style="color: red;">No records available</td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
			</tr>';
		}
		echo json_encode($list);
	}

	public function withEstimatorQuotations() {
		$search_item = '';
		$test=$this->furniture_quotation_model->myQuoteswithEstimators2(500,0,$search_item);
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Qtn No.</th>
						<th>Client</th>
						<th>Qtn Date</th>
						<th>Project</th>
						<th>Estimator</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				//<a href="'.site_url('manage_quotation/quotation/'.$myAction->trans_id.'/'.$myAction->quotation_divisionid.'/'.$myAction->quotation_number).'">
				$count++;
				$list.='<tr>
				<td>'.$myAction->quotation_number_full.'</td>
				<td>'.$myAction->client_name.'</td>
				<td>'.date("M d, Y", strtotime($myAction->quotation_date)).'</td>
				<td>'.$myAction->project_name.'</td>
				<td>'.$myAction->salesman_name.'</td>
				</tr>';
			}
		} else {
			$list.='<tr>
						<td  style="color: red;">No records available</td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
					</tr>';
		}
		echo json_encode($list);
	}

	public function withApproverQuotations() {
		$search_item = '';
		$test=$this->furniture_quotation_model->myQuotesApprover(500,0,$search_item);
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Qtn No.</th>
						<th>Client</th>
						<th>Qtn Date</th>
						<th>Project</th>
						<th>Approver</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				$list.='<tr>
				<td><a href="'.site_url('manage_quotation/quotation/'.$myAction->trans_id.'/'.$myAction->quotation_divisionid.'/'.$myAction->quotation_number).'">'.$myAction->quotation_number_full.'</a></td>
				<td>'.$myAction->client_name.'</td>
				<td>'.date("M d, Y", strtotime($myAction->quotation_date)).'</td>
				<td>'.$myAction->project_name.'</td>
				<td>'.$myAction->salesman_name.'</td>
				</tr>';
			}
		} else {
			$list.='<tr>
						<td  style="color: red;">No records available</td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
					</tr>';
		}
		echo json_encode($list);
	}

	public function withOktoConfirmQuotations() {
		$search_item = '';
		$test=$this->furniture_quotation_model->myOktoConfirmQuotations(500,0,$search_item);
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Qtn No.</th>
						<th>Client</th>
						<th>Qtn Date</th>
						<th>Project</th>
						<th>Approver</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				$list.='<tr>
				<td><a href="'.site_url('manage_quotation/quotation/'.$myAction->trans_id.'/'.$myAction->quotation_divisionid.'/'.$myAction->quotation_number).'">'.$myAction->quotation_number_full.'</a></td>
				<td>'.$myAction->client_name.'</td>
				<td>'.date("M d, Y", strtotime($myAction->quotation_date)).'</td>
				<td>'.$myAction->project_name.'</td>
				<td>'.$myAction->salesman_name.'</td>
				</tr>';
			}
		} else {
			$list.='<tr>
						<td  style="color: red;">No records available</td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
					</tr>';
		}
		echo json_encode($list);
	}

	public function myJobs() {
		$search_item = '';
		$test=$this->furniture_quotation_model->myJobs(500,0,$search_item);
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Job No.</th>
						<th>Client</th>
						<th>Job Date</th>
						<th>Project</th>
						<th>Salesman</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				$list.='<tr>
				<td><a href="'.site_url('jobcard/Job_card/managejobcard/'.$myAction->job_card_id.'/'.$myAction->divisionid.'/'.$myAction->job_card_number).'">'.$myAction->job_card_number.'</a></td>
				<td>'.$myAction->client_name.'</td>
				<td>'.date("M d, Y", strtotime($myAction->job_card_date)).'</td>
				<td>'.$myAction->project_name.'</td>
				<td>'.$myAction->user_name.'</td>
				</tr>';
			}
		} else {
			$list.='<tr>
						<td  style="color: red;">No records available</td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
					</tr>';
		}
		echo json_encode($list);
	}

	public function myQuoteNotCreatedJobs() {
		$search_item = '';
		$test=$this->furniture_quotation_model->myQuoteNotCreatedJobs(500,0,$search_item);
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Qtn No.</th>
						<th>Client</th>
						<th>Qtn Date</th>
						<th>Project</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				$list.='<tr>
				<td><a href="'.site_url('manage_quotation/quotation/'.$myAction->quotation_id.'/'.$myAction->quotation_divisionid.'/'.$myAction->quotation_number).'">'.$myAction->quotation_number_full.'</a></td>
				<td>'.$myAction->client_name.'</td>
				<td>'.date("M d, Y", strtotime($myAction->quotation_date)).'</td>
				<td>'.$myAction->project_name.'</td>
				</tr>';
			}
		} else {
			$list.='<tr>
						<td  style="color: red;">No records available</td>
						<td></td>
						<td></td>
						<td></td>
					</tr>';
		}
		echo json_encode($list);
	}
	
	public function jobcardDiscountlist() {
		$search_item = '';
		$test=$this->furniture_quotation_model->jobcardDiscountlist(500,0,$search_item);
		$make  = $this->Vehicle->getMake();
		$model = $this->Vehicle->getModel();

		$makeArray = array_column($make,'title','id');
		$modelArray = array_column($model,'title','id');
		
 		$list=	'<thead class="thead-light">
					<tr>
						<th>Job No</th>
						<th>Job Date</th>
						<th>Customer Name</th>
						<th>Reg.No</th>
						<th>Make & Model</th>
						<th>Total Amount</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				if(isset($myAction->make) && isset($makeArray[$myAction->make])){
					$make_name = $makeArray[$myAction->make];
				}
				else{
					$make_name = '';
				}
				if(isset($myAction->model) && isset($modelArray[$myAction->model])){
					$model_name = $modelArray[$myAction->model];
					$model_name = str_replace('-','',$model_name);
				}
				else{
					$model_name = '';
				}
				$count++;
				$list.='<tr>
				<td><a href="'.site_url('jobcard/Vehicle_jobcard/editVjobcard').'/'.$myAction->id.'">'.$myAction->job_card_number.'</a></td>
				<td>'.date("M d, Y", strtotime($myAction->job_card_date)).'</td>
				<td>'.$myAction->client_name.'</td>				
				<td>'.$myAction->reg_no.'</td>
				<td>'.$make_name.' - '.$model_name.'</td>
				<td>'.$myAction->job_card_amount_with_vat.'</td>
				</tr>';
			}
		} else {
			$list.='<tr>
						<td  ></td>
						<td></td>
						<td></td>				
						<td style="color: red;">No records available</td>
						<td></td>
						<td></td>
					</tr>';
		}
		echo json_encode($list);
	}

	public function jobcardDiscountcompletedlist() {
		$search_item = '';
		$test=$this->furniture_quotation_model->jobcardDiscountcompletedlist(500,0,$search_item);
		$make  = $this->Vehicle->getMake();
		$model = $this->Vehicle->getModel();
		$makeArray = array_column($make,'title','id');
		$modelArray = array_column($model,'title','id');
		//var_dump($test);
 		$list=	'<thead class="thead-light">
					<tr>
						<th>Job No</th>
						<th>Job Date</th>
						<th>Customer Name</th>
						<th>Reg.No</th>
						<th>Make & Model</th>
						<th>Total Amount</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			
			foreach($test as $myAction){ 
				if(isset($myAction->make) && isset($makeArray[$myAction->make])){
					$make_name = $makeArray[$myAction->make];
				}
				else{
					$make_name = '';
				}
				if(isset($myAction->model) && isset($modelArray[$myAction->model])){
					$model_name = $modelArray[$myAction->model];
					$model_name = str_replace('-','',$model_name);
				}
				else{
					$model_name = '';
				}
				$count++;
				$list.='<tr>
				<td><a href="'.site_url('jobcard/Vehicle_jobcard/editVjobcard').'/'.$myAction->id.'">'.$myAction->job_card_number.'</a></td>
				<td>'.date("M d, Y", strtotime($myAction->job_card_date)).'</td>
				<td>'.$myAction->client_name.'</td>				
				<td>'.$myAction->reg_no.'</td>
				<td>'.$make_name.' - '.$model_name.'</td>
				<td>'.$myAction->job_card_amount_with_vat.'</td>
				</tr>';
			}
		} else {
			$list.='<tr>
						<td style="color: red;">No records available</td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
					</tr>';
		}
		echo json_encode($list);
	}

	public function myInvoices() {
		$search_item = '';
		$test=$this->furniture_quotation_model->myInvoices();
		$user_id 	 = $this->session->userdata('user_id');
		$make  = $this->Vehicle->getMake();
		$model = $this->Vehicle->getModel();
		$customer  = $this->Vehicle->getCustomer();
		$makeArray = array_column($make,'title','id');
		$modelArray = array_column($model,'title','id');
 		$customerArray = array_column($customer ,'client_name','client_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Inv No.</th>
						<th>Inv Date</th>
						<th>Reg.No</th>
						<th>Vehicle</th>
						<th>Customer Name</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				if(isset($myAction->client_id) && isset($customerArray[$myAction->client_id])){
					$client_name  = $customerArray[$myAction->client_id];
				}
				else{
					$client_name  = '';
				}
				if(isset($myAction->make) && isset($makeArray[$myAction->make])){
					$make_name = $makeArray[$myAction->make];
				}
				else{
					$make_name = '';
				}
				if(isset($myAction->model) && isset($modelArray[$myAction->model])){
					$model_name = $modelArray[$myAction->model];
					$model_name = str_replace('-','',$model_name);
				}
				else{
					$model_name = '';
				}
				$count++;
				$list.='<tr>
				<td><a target="-blank" href="'.site_url('Manage_quotation/printInvoiceDetails/'.$myAction->invoice_id.'/normal').'">'.$myAction->invoice_number.'</a></td>
				<td>'.date("M d, Y", strtotime($myAction->invoice_date)).'</td>
				<td>'.$myAction->reg_no.'</td>
				<td>'.$make_name.'-'.$model_name.'</td>
				<td>'.$client_name.'</td>
				</tr>';
			}
		} else {
			$list.='<tr>
						<td  style="color: red;">No records available</td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
					</tr>';
		}
		echo json_encode($list);
	}

	public function cancelledInvoices() {
		$search_item = '';
		$test=$this->furniture_quotation_model->cancelledInvoices();
		$user_id 	 = $this->session->userdata('user_id');
		$make  = $this->Vehicle->getMake();
		$model = $this->Vehicle->getModel();
		$customer  = $this->Vehicle->getCustomer();
		$makeArray = array_column($make,'title','id');
		$modelArray = array_column($model,'title','id');
 		$customerArray = array_column($customer ,'client_name','client_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Inv No.</th>
						<th>Inv Date</th>
						<th>Reg.No</th>
						<th>Vehicle</th>
						<th>Customer Name</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				if(isset($myAction->client_id) && isset($customerArray[$myAction->client_id])){
					$client_name  = $customerArray[$myAction->client_id];
				}
				else{
					$client_name  = '';
				}
				if(isset($myAction->make) && isset($makeArray[$myAction->make])){
					$make_name = $makeArray[$myAction->make];
				}
				else{
					$make_name = '';
				}
				if(isset($myAction->model) && isset($modelArray[$myAction->model])){
					$model_name = $modelArray[$myAction->model];
					$model_name = str_replace('-','',$model_name);
				}
				else{
					$model_name = '';
				}
				$count++;
				$list.='<tr>
				<td><a target="-blank" href="'.site_url('Manage_quotation/printInvoiceDetails/'.$myAction->invoice_id.'/normal').'">'.$myAction->invoice_number.'</a></td>
				<td>'.date("M d, Y", strtotime($myAction->invoice_date)).'</td>
				<td>'.$myAction->reg_no.'</td>
				<td>'.$make_name.'-'.$model_name.'</td>
				<td>'.$client_name.'</td>
				</tr>';
			}
		} else {
			$list.='<tr>
						<td  style="color: red;">No records available</td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
					</tr>';
		}
		echo json_encode($list);
	}


	public function pendingtoPickEstimator() {
		$search_item = '';
		$test=$this->furniture_quotation_model->pendingtoPickEstimators2(500,0,$search_item);
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Qtn No.</th>
						<th>Client</th>
						<th>Qtn Date</th>
						<th>Project</th>
						<th>Salesman</th>
						<th>Action</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				$list.='<tr>
				<td>'.$myAction->quotation_number_full.'</td>
				<td>'.$myAction->client_name.'</td>
				<td>'.date("M d, Y", strtotime($myAction->quotation_date)).'</td>
				<td>'.$myAction->project_name.'</td>
				<td>'.$myAction->salesman_name.'</td>
				<td>';
				if($myAction->trans_action==='Pick'){ 
					$list.='<a class="btn btn-sm btn-primary" href="javascript:pickEstimator('.$myAction->trans_id.')"">Pick</a>';
				} 
				$list.='</td></tr>';
			}
		} else {
			$list.='<tr>
						<td  style="color: red;">No records available</td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
					</tr>';
		}
		echo json_encode($list);
	}

	public function myEstimationQuotations() {
		$search_item = '';
		$test=$this->furniture_quotation_model->myActionsEstimators(500,0,$search_item);
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Qtn No.</th>
						<th>Client</th>
						<th>Qtn Date</th>
						<th>Project</th>
						<th>Salesman</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				$list.='<tr>
				<td><a href="'.site_url('manage_quotation/quotation/'.$myAction->trans_id.'/'.$myAction->quotation_divisionid.'/'.$myAction->quotation_number).'">'.$myAction->quotation_number_full.'</a></td>
				<td>'.$myAction->client_name.'</td>
				<td>'.date("M d, Y", strtotime($myAction->quotation_date)).'</td>
				<td>'.$myAction->project_name.'</td>
				<td>'.$myAction->salesman_name.'</td>
				</tr>';
			}
		} else {
			$list.='<tr>
						<td  style="color: red;">No records available</td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
					</tr>';
		}
		echo json_encode($list);
	}

	public function myEstimationConfirmed() {
		$search_item = '';
		$test=$this->furniture_quotation_model->myEstimationConfirmed(500,0,$search_item);
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Qtn No.</th>
						<th>Client</th>
						<th>Qtn Date</th>
						<th>Project</th>
						<th>Salesman</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				$list.='<tr>
				<td><a href="'.site_url('manage_quotation/printQuotation/'.$myAction->trans_id.'/normal/without_image/0/0/0/0').'" target="_blank" >'.$myAction->quotation_number_full.'</a></td>
				<td>'.$myAction->client_name.'</td>
				<td>'.date("M d, Y", strtotime($myAction->quotation_date)).'</td>
				<td>'.$myAction->project_name.'</td>
				<td>'.$myAction->salesman_name.'</td>
				</tr>';
			}
		} else {
			$list.='<tr>
						<td  style="color: red;">No records available</td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
					</tr>';
		}
		echo json_encode($list);
	}

	public function confirmedQuote() {
		$search_item = '';
		$test=$this->furniture_quotation_model->confirmedQuote(500,0,$search_item);
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Qtn No.</th>
						<th>Client</th>
						<th>Qtn Date</th>
						<th>Project</th>
						<th>Salesman</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				$list.='<tr>
				<td><a href="'.site_url('manage_quotation/printQuotation/'.$myAction->quotation_id.'/normal/without_image/0/0/0/0').'" target="_blank" >'.$myAction->quotation_number_full.'</a></td>
				<td>'.$myAction->client_name.'</td>
				<td>'.date("M d, Y", strtotime($myAction->quotation_date)).'</td>
				<td>'.$myAction->project_name.'</td>
				<td>'.$myAction->salesman_name.'</td>
				</tr>';
			}
		} else {
			$list.='<tr>
						<td  style="color: red;">No records available</td>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
					</tr>';
		}
		echo json_encode($list);
	}

	public function myEstimationQoutewithApprover() {
		$search_item = '';
		$test=$this->furniture_quotation_model->myEstimationQoutewithApprover(500,0,$search_item);
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Qtn No.</th>
						<th>Client</th>
						<th>Qtn Date</th>
						<th>Project</th>
						<th>Approver</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$trans_id=	$myAction->trans_id;
				$result =   $this->db->query("SELECT users.user_name as approver FROM `log_for_quotation` left join users on log_for_quotation.trans_user_id=users.user_id WHERE ( flow_id='5' OR flow_id='7' ) AND trans_id='$trans_id' group by trans_id ");
				$approver='';
				$data=$result->row_array();
				if($data!=false) {
					$approver=$data['approver'];
				}
				$count++;
				$list.='<tr>
				<td>'.$myAction->quotation_number_full.'</td>
				<td>'.$myAction->client_name.'</td>
				<td>'.date("M d, Y", strtotime($myAction->quotation_date)).'</td>
				<td>'.$myAction->project_name.'</td>
				<td>'.$approver.'</td>
				</tr>';
			}
		} else {
				$list.='<tr>
					<td  style="color: red;">No records available</td>
					<td></td>
					<td></td>
					<td></td>
					<td></td>
				</tr>';
		}
		echo json_encode($list);
	}
	public function pendingtoPickApprover() {
		$search_item = '';
		$test=$this->furniture_quotation_model->pendingtoPickApprovers2(500,0,$search_item);
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Qtn No.</th>
						<th>Client</th>
						<th>Qtn Date</th>
						<th>Project</th>
						<th>Salesman</th>
						<th>Action</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				$list.='<tr>
				<td>'.$myAction->quotation_number_full.'</td>
				<td>'.$myAction->client_name.'</td>
				<td>'.date("M d, Y", strtotime($myAction->quotation_date)).'</td>
				<td>'.$myAction->project_name.'</td>
				<td>'.$myAction->salesman_name.'</td>
				<td>';
				if($myAction->trans_action==='Pick'){ 
					$list.='<a class="btn btn-sm btn-primary" href="javascript:pickApprover('.$myAction->trans_id.')"">Pick</a>';
				} 
				$list.='</td></tr>';
			}
		} else {
			$list.='<tr>
				<td  style="color: red;">No records available</td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
			</tr>';
		}
		echo json_encode($list);
	}

	public function forApproval() {
		$search_item = '';
		$test=$this->furniture_quotation_model->forApproval(500,0,$search_item);
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Qtn No.</th>
						<th>Client</th>
						<th>Qtn Date</th>
						<th>Project</th>
						<th>Salesman</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				$list.='<tr>
					<td><a href="'.site_url('manage_quotation/printQuotation/'.$myAction->trans_id.'/forapprover/without_image/0/0/0/0').'" >'.$myAction->quotation_number_full.'</a></td>
					<td>'.$myAction->client_name.'</td>
					<td>'.date("M d, Y", strtotime($myAction->quotation_date)).'</td>
					<td>'.$myAction->project_name.'</td>
					<td>'.$myAction->salesman_name.'</td>
				</tr>';
			}
		} else {
			$list.='<tr>
				<td style="color: red;" >No records available</td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
			</tr>';
		}
		echo json_encode($list);
	}

	public function forConfirm() {
		$search_item = '';
		$test=$this->furniture_quotation_model->forConfirm(500,0,$search_item);
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Qtn No.</th>
						<th>Client</th>
						<th>Qtn Date</th>
						<th>Project</th>
						<th>Salesman</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				$list.='<tr>
					<td><a href="'.site_url('manage_quotation/printQuotation/'.$myAction->trans_id.'/forapprover/without_image/0/0/0/0').'" >'.$myAction->quotation_number_full.'</a></td>
					<td>'.$myAction->client_name.'</td>
					<td>'.date("M d, Y", strtotime($myAction->quotation_date)).'</td>
					<td>'.$myAction->project_name.'</td>
					<td>'.$myAction->salesman_name.'</td>
				</tr>';
			}
		} else {
			$list.='<tr>
				<td style="color: red;" >No records available</td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
			</tr>';
		}
		echo json_encode($list);
	}

	public function pendingtoApproverPr() {
		$search_item = '';
		$test=$this->furniture_quotation_model->pendingtoApproverPr(500,0,$search_item);
		$user_id 	 = $this->session->userdata('user_id');
		$list='<thead class="thead-light">
					<tr>
						<th>Qtn No.</th>
						<th>Qtn Date</th>
						<th>Salesman</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				$list.='<tr>
					<td><a href="'.base_url().'index.php/furniture/PurchaseRequest/printPurchaseRequest/' . $myAction->pr_id . '/forapprove">'.$myAction->pr_code.'</a></td>
					<td>'.date("M d, Y", strtotime($myAction->pr_date)).'</td>
					<td>'.$myAction->user_name.'</td>
				</tr>';
			}
		} else {
			$list.='<tr>
				<td style="color: red;" >No records available</td>
				<td></td>
				<td></td>
			</tr>';
		}
		echo json_encode($list);
	}

	public function pendingtoApproverPo() {
		$search_item = '';
		$test=$this->furniture_quotation_model->pendingtoApproverPo(500,0,$search_item);
		$user_id 	 = $this->session->userdata('user_id');
		$list='<thead class="thead-light">
					<tr>
						<th>PO No.</th>
						<th>PO Date</th>
						<th>Supplier</th>
						<th style="text-align: right;">Amount</th>
						<th>Customer</th>
						<th>Job no</th>
						<th>User</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				if($myAction->job_id!=0 && $myAction->job_id!==''){
					$job_id = $myAction->job_id;
					$this->db->select('job_card.job_card_number,client_name');
					$this->db->where('id', $job_id);
					$this->db->from('job_card');
					$this->db->join('new_client_master','new_client_master.client_id = job_card.client_id','left');
					$this->db->limit(1);
					$query = $this->db->get();
					$job_card = $query->row();
					if($job_card!=false){
						$client_name = $job_card->client_name;
						$job_card_number = $job_card->job_card_number;
					}
				} else {
					$client_name = '';
					$job_card_number = '';
				}
				$list.='<tr>
					<td><a href="'.base_url().'index.php/furniture/PurchaseOrder/printPurchaseOrder/' . $myAction->po_id . '/forapprove">'.$myAction->po_code.'</a></td>
					<td>'.date("M d, Y", strtotime($myAction->po_date)).'</td>
					<td>'.$myAction->supplier_name.'</td>
					<td style="text-align: right;">'.$myAction->po_net_amt.'</td>
					<td>'.$client_name.'</td>
					<td>'.$job_card_number.'</td>
					<td>'.$myAction->user_name.'</td>
				</tr>';
			}
		} else {
			$list.='<tr>
				<td style="color: red;" >No records available</td>
				<td></td>
				<td></td>
			</tr>';
		}
		echo json_encode($list);
	}


	public function pendingtoApproveCustomer() {
		$search_item = '';
		$test=$this->furniture_quotation_model->pendingtoApproveCustomer(500,0,$search_item);
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Client</th>
						<th>Phone</th>
						<th>Action</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				$list.='<tr>
				<td>'.$myAction->client_name.'</td>
				<td>'.$myAction->client_telephone1ephone1.'</td>
				<td>
				<a href="'.base_url().'index.php/client_reports/edit/' . $myAction->client_id . '">Approve</a>';
				$list.='</td></tr>';
			}
		} else {
			$list.='<tr>
				<td  style="color: red;">No records available</td>
				<td></td>
				<td></td>
			</tr>';
		}
		echo json_encode($list);
	}

	public function pendingPR() {
		$search_item = '';
		$test=$this->furniture_quotation_model->pendingPR(500,0,$search_item);
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>PR No.</th>
						<th>Date</th>
						<th>Department</th>
						<th>PR Type</th>
						<th>User</th>
						<th>Client</th>
						<th>Action</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				if($myAction->job_id!=0 && $myAction->job_id!==''){
					$job_id = $myAction->job_id;
					$this->db->select('*');
					$this->db->where('id', $job_id);
					$this->db->from('job_card');
					$this->db->join('new_client_master','new_client_master.client_id = job_card.client_id','left');
					$this->db->limit(1);
					$query = $this->db->get();
					$job_card = $query->row();
					if($job_card!=false){
						$client_name = $job_card->client_name;
					}
				} else {
					$client_name = '';
				}


				$list.='<tr>
					<td><a href="'.base_url().'index.php/furniture/PurchaseRequest/printPurchaseRequest/' . $myAction->pr_id . '" target="_blank" >'.$myAction->pr_code.'</a></td>
					<td>'.date("M d, Y", strtotime($myAction->pr_date)).'</td>
					<td>'.$myAction->department_name.'</td>
					<td>'.$myAction->pr_type.'</td>
					<td>'.$myAction->user_name.'</td>
					<td>'.$client_name.'</td>
					<td><a class="btn btn-sm btn-primary" href="javascript:createPO('.$myAction->pr_id.')"">Create PO</a></td>';
				$list.='</tr>';
			}
		} else {
			$list.='<tr>
				<td  style="color: red;">No records available</td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
			</tr>';
		}
		echo json_encode($list);
	}

	public function userWisePRpending() {
		$search_item = '';
		if ($this->session->userdata('user_group_id')==1) {
			$user_id = '';
		} else {
			$user_id = $this->session->userdata('user_id');
		}
		$test=$this->furniture_quotation_model->userWisePRpending($user_id);
		$list=	'<thead class="thead-light">
					<tr>
						<th>PR No.</th>
						<th>Date</th>
						<th>Department</th>
						<th>PR Type</th>
						<th>Action</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				$client_name = '';
				$list.='<tr>
					<td><a href="'.base_url().'index.php/furniture/PurchaseRequest/printPurchaseRequest/' . $myAction->pr_id . '" target="_blank" >'.$myAction->pr_code.'</a></td>
					<td>'.date("M d, Y", strtotime($myAction->pr_date)).'</td>
					<td>'.$myAction->department_name.'</td>
					<td>'.$myAction->pr_type.'</td>
					<td><a class="btn btn-sm btn-primary" href="javascript:createPO('.$myAction->pr_id.')"">Create PO</a></td>';
				$list.='</tr>';
			}
		} else {
			$list.='<tr>
				<td  style="color: red;">No records available</td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
			</tr>';
		}
		echo json_encode($list);
	}
	public function userWisePRnotReceived() {
		$search_item = '';
		if ($this->session->userdata('user_group_id')==1) {
			$user_id = '';
		} else {
			$user_id = $this->session->userdata('user_id');
		}
	
		$test=$this->furniture_quotation_model->userWisePRnotReceived($user_id);
		$list=	'<thead class="thead-light">
					<tr>
						<th>PR No.</th>
						<th>Date</th>
						<th>Department</th>
						<th>PR Type</th>
						<th>PO</th>
						<th>Supplier</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				$client_name = '';
				$list.='<tr>
					<td><a href="'.base_url().'index.php/furniture/PurchaseRequest/printPurchaseRequest/' . $myAction->pr_id . '" target="_blank" >'.$myAction->pr_code.'</a></td>
					<td>'.date("M d, Y", strtotime($myAction->pr_date)).'</td>
					<td>'.$myAction->department_name.'</td>
					<td>'.$myAction->pr_type.'</td>
					<td>'.$myAction->po_code.'</td>
					<td>'.$myAction->supplier_name.'</td>';
				$list.='</tr>';
			}
		} else {
			$list.='<tr>
				<td  style="color: red;">No records available</td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
			</tr>';
		}
		echo json_encode($list);
	}

	public function pendingPO() {
		$search_item = '';
		$type = $this->input->post('type');
		$test=$this->furniture_quotation_model->pendingPO(20,0,$type,$search_item);
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>PO No.</th>
						<th>Date</th>
						<th>Supplier</th>
						<th>PR Type</th>
						<th>User</th>
						<th>Client</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				if($myAction->job_id!=0 && $myAction->job_id!==''){
					$job_id = $myAction->job_id;
					$this->db->select('*');
					$this->db->where('id', $job_id);
					$this->db->from('job_card');
					$this->db->join('new_client_master','new_client_master.client_id = job_card.client_id','left');
					$this->db->limit(1);
					$query = $this->db->get();
					$job_card = $query->row();
					if($job_card!=false){
						$client_name = $job_card->client_name;
					}
				} else {
					$client_name = '';
				}
				$list.='<tr>
					<td><a href="'.base_url().'index.php/furniture/PurchaseOrder/printPurchaseOrder/' . $myAction->po_id . '" target="_blank" >'.$myAction->po_code.'</a></td>
					<td>'.date("M d, Y", strtotime($myAction->po_date)).'</td>
					<td>'.$myAction->supplier_name.'</td>
					<td>'.$myAction->po_type.'</td>
					<td>'.$myAction->user_name.'</td>
					<td>'.$client_name.'</td>';
				$list.='</tr>';
			}
		} else {
			$list.='<tr>
				<td  style="color: red;">No records available</td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
			</tr>';
		}
		echo json_encode($list);
	}

	public function jobNotDelivered() {
		
		$dn_row=$this->db->query("SELECT dnd.`job_card_details_id`,sum(dnd.`delivery_quantity`) as qty,dn.job_card_id,dn.delivery_note_number FROM `delivery_note_details` dnd inner join delivery_note dn on dn.id=dnd.delvery_note_id WHERE dn.delivery_note_status = '1' group by dnd.job_card_details_id");
		$dn_datas = $dn_row->result_array();

		$sss = array();
		foreach($dn_datas as $dn_data){
			$sss[$dn_data['job_card_details_id']] = array(
				'delivery_note_number' => $dn_data['delivery_note_number'],
				'job_card_details_id' => $dn_data['job_card_details_id'],
				'qty' => $dn_data['qty'],
			);
		}

		$list='<thead class="thead-light">
					<tr>
						<th>Job No.</th>
						<th>Date</th>
						<th>Client</th>
						<th>Project Name</th>
						<th>Salesman</th>
						<th>Action</th>
					</tr>
				</thead>';

		$this->db->select('jcd.job_card_details_id,jcd.item_id,jcd.furniture_quantity,jc.id,jc.job_card_number,jc.job_card_date,jc.project_name,ncm.client_name,u.user_name');
		$this->db->from('job_card_details jcd');
		$this->db->join('job_card jc','jc.id = jcd.job_card_id','inner');
		$this->db->join('new_client_master ncm','ncm.client_id = jc.client_id','left');
		$this->db->join('users u','u.user_id = jc.salesman_id','left');
		$this->db->where('jc.job_card_status','Completed');
		$this->db->order_by('jcd.job_card_id','ASC');
		$this->db->order_by('jcd.job_card_details_id','ASC');
		$jc_row = $this->db->get();
		$jc_datas = $jc_row->result_array();
		
		$not_delivered_count=0;
		$previous_job_card_id = 0;
		if($jc_datas!=false){	
			foreach($jc_datas as $jc_data){
				if(@$sss[$jc_data['job_card_details_id']]['qty']!=$jc_data['furniture_quantity']){
					if($previous_job_card_id!=$jc_data['id']){
						$not_delivered_count++;
						$previous_job_card_id = $jc_data['id'];
						$list.='<tr>
							<td>'.$jc_data['job_card_number'].'</td>
							<td>'. date('M d,Y',strtotime ($jc_data['job_card_date'])).'</td>
							<td>'.$jc_data['client_name'].'</td>
							<td>'.$jc_data['project_name'].'</td>
							<td>'.$jc_data['user_name'].'</td>
							<td><a href="'.base_url().'index.php/jobcard/Delivery_note/create_delivery_note/' . $jc_data['id'] . '" >Create Delivery Note</a></td>
						</tr>';
					}
				} 
			}
		} else {
			$list.='<tr>
				<td  style="color: red;">No records available</td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
			</tr>';
		}
		echo json_encode($list);
	}

	public function search_main_category() {
		$main_category	=	$this->input->post('main_category');
		$today	=	date("Y-m-d");
		$html	='';
		$main_category_data = $this->db->query("SELECT * FROM `main_category` where status='1' and  `category_name` like '%$main_category%' order by category_name");
		$n = 1;

		if (count($main_category_data->result_array()) > 0) {
			foreach ($main_category_data->result_array() as $main_category_datas) {
				$html .= '<li value="' . $main_category_datas['id'] . '" class="main_category_button" tabindex="' . $n++ . '" ><input type="hidden" class="category_name" value="' . $main_category_datas['category_name'] . '" />' . $main_category_datas['category_name'] . '</li>';
			}
		} else {
			$html .= '<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		print $html;
	}

	public function search_stock_group()
	{
		$stock_group_name = $this->input->post('stock_group_name');
		$today = date("Y-m-d");
		$html = '';
		$stock_group_data = $this->db->query("SELECT * FROM `stock_group` where status='1' and  `stock_group_name` like '%$stock_group_name%' order by stock_group_name");
		$n = 1;
		if (count($stock_group_data->result_array()) > 0) {
			foreach ($stock_group_data->result_array() as $stock_group_datas) {
				$html .= '<li value="' . $stock_group_datas['id'] . '" class="stock_group_name_button" tabindex="' . $n++ . '" ><input type="hidden" class="stock_group_name" value="' . $stock_group_datas['stock_group_name'] . '" />' . $stock_group_datas['stock_group_name'] . '</li>';
			}
		} else {
			$html .= '<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		print $html;
	}
	public function search_brand()
	{
		$brand_name = $this->input->post('brand_name');
		$today = date("Y-m-d");
		$html = '';
		$brand_data = $this->db->query("SELECT * FROM `furniture_brands` where status='1' and `brand_name` like '%$brand_name%' order by brand_name");
		$n = 1;
		if (count($brand_data->result_array()) > 0) {
			foreach ($brand_data->result_array() as $brand_datas) {
				$html .= '<li value="' . $brand_datas['brand_id'] . '" class="brand_button" tabindex="' . $n++ . '" ><input type="hidden" class="brand_name" value="' . $brand_datas['brand_name'] . '" />' . $brand_datas['brand_name'] . '</li>';
			}
		} else {
			$html .= '<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		print $html;
	}

	public function modelsearch(){
		$make_id =$this->input->post('make_id');
		if($make_id!=='') {
		   $make_list='<option value="">--Select Model--</option>';
		   $make_data = $this->db->query("SELECT * FROM `model` where `make_id`='$make_id'  ");
		   foreach($make_data->result() as $row2){
		     //	$selected = set_select('model', $row2['id'], FALSE);
				$make_list.='<option   value="'.$row2->id.'">'.$row2->title.'</option>';
			}
			print $make_list;
		} else {
			echo '0';
		}
	}
	public function search_reg_no(){
		$reg_no =$this->input->post('reg_no');
		if($reg_no!=='') {
			$v_id = $this->input->post('vtype');
			if(($v_id !="" || $v_id !=" ") && $reg_no!='' ){
				$make_data = $this->db->query("SELECT R.`reg_no_id`,R.`v_type`,R.`client_mobile_no`,R.`reg_no`,R.`make_id`,R.`model_id`,R.`client_id`,R.`status`,R.`car_year`,R.`car_color`,R.`chassi_number`,R.labour_disc,R.parts_disc,CM.`client_name`,CM.`client_code`,CM.`client_telephone1`,CM.`tax_no`,CM.client_email,CM.client_address,CM.client_telephone1,CM.client_telephone2,CM.tax_name,CM.tax_no,CM.remarks,CM.acc_group_id FROM `reg_no_table` R INNER JOIN `new_client_master` CM ON CM.`client_id`=R.`client_id` where R.`reg_no` = '$reg_no' AND R.`v_type`='$v_id' ");
				
			}
			else{
				$make_data = $this->db->query("SELECT R.`reg_no_id`,R.`v_type`,R.`client_mobile_no`,R.`reg_no`,R.`make_id`,R.`model_id`,R.`client_id`,R.`status`,R.`car_year`,R.`car_color`,R.`chassi_number`,R.labour_disc,R.parts_disc,CM.`client_name`,CM.`client_code`,CM.`client_telephone1`,CM.`tax_no`,CM.client_email,CM.client_address,CM.client_telephone1,CM.client_telephone2,CM.tax_name,CM.tax_no,CM.remarks,CM.acc_group_id FROM `reg_no_table` R INNER JOIN `new_client_master` CM ON CM.`client_id`=R.`client_id` where R.`reg_no`='$reg_no'  ");
			}
		  	//$make_data = $this->db->query("SELECT R.`reg_no_id`,R.`v_type`,R.`client_mobile_no`,R.`reg_no`,R.`make_id`,R.`model_id`,R.`client_id`,R.`status`,R.`car_year`,R.`car_color`,R.`chassi_number`,R.labour_disc,R.parts_disc,CM.`client_name`,CM.`client_code`,CM.`client_telephone1`,CM.`tax_no`,CM.client_email,CM.client_address,CM.client_telephone1,CM.client_telephone2,CM.tax_name,CM.tax_no,CM.remarks,CM.acc_group_id FROM `reg_no_table` R INNER JOIN `new_client_master` CM ON CM.`client_id`=R.`client_id` where R.`reg_no`='$reg_no'  ");
		   //echo "SELECT R.`reg_no_id`,R.`client_mobile_no`,R.`reg_no`,R.`make_id`,R.`model_id`,R.`client_id`,R.`status`,R.`car_year`,R.`car_color`,R.`chassi_number`,CM.`client_name`,CM.`client_code`,CM.`client_telephone1`,CM.`tax_no`,CM.client_email,CM.client_address,CM.client_telephone1,CM.client_telephone2,CM.tax_name,CM.tax_no,CM.remarks,CM.acc_group_id FROM `reg_no_table` R INNER JOIN `new_client_master` CM ON CM.`client_id`=R.`client_id` where R.`reg_no`='$reg_no' ";
			if($make_data->row_array()!=false){
				$make_id	=	$make_data->row()->make_id;
				$model_id	=	$make_data->row()->model_id;
				$client_name	=	$make_data->row()->client_name;
				$client_telephone1	=	$make_data->row()->client_mobile_no;
				$client_id	=	$make_data->row()->client_id;
				$reg_no_id	=	$make_data->row()->reg_no_id;
				$reg_no	=	$make_data->row()->reg_no;
				$tax_no	=	$make_data->row()->tax_no;
				$car_year	=	$make_data->row()->car_year;
				$car_color	=	$make_data->row()->car_color;
				$chassi_number	=	$make_data->row()->chassi_number;
				$client_code	=	$make_data->row()->client_code;
				$client_email	=	$make_data->row()->client_email;
				$client_address	=	$make_data->row()->client_address;
				$client_telephone1	=	$make_data->row()->client_telephone1;
				$client_telephone2	=	$make_data->row()->client_telephone2;
				$tax_name	=	$make_data->row()->tax_name;
				$tax_no	    =	$make_data->row()->tax_no;
				$remarks	=	$make_data->row()->remarks;
				$acc_gb_id  =   $make_data->row()->acc_group_id;
				$labour_disc  =  $make_data->row()->labour_disc;
				$parts_disc   =  $make_data->row()->parts_disc;
				$vtype_id     =  $make_data->row()->v_type;
				$client_mobile_no     =  $make_data->row()->client_mobile_no;
				$comments  = NULL;
				$client_contact_data = $this->db->query("SELECT * FROM `client_contact` where `Client_Id`='$client_id' and `Status` = 1 order by `Contact_Id` DESC LIMIT 1");
				if($client_contact_data->num_rows() > 0){
					$contact_id  = $client_contact_data->row()->Contact_Id;
					$contact_name  = $client_contact_data->row()->Contact_Name;
					$Contact_num  = $client_contact_data->row()->Contact_Tel;
				}
				else{
					$contact_id    ='';
					$contact_name  = '';
					$Contact_num   = '';
				}

				$make_list = '<option value="">--Select Model--</option>';
		   		$make_data = $this->db->query("SELECT * FROM `model` where `make_id`='$make_id'  ");				
				
				if($acc_gb_id  != 0) {
					$acc_gp_sql = $this->db->query("SELECT * FROM `account_group` WHERE acc_group_id = '$acc_gb_id'");
					if($acc_gp_sql->num_rows()> 0 ){

						$comments = $acc_gp_sql->row()->comments;
					}
				}
		   		foreach($make_data->result() as $row2){
					if($model_id==$row2->id){
						$selected='selected="selected"';
					} else {
						$selected='';
					}
					$make_list.='<option value="'.$row2->id.'" '.$selected.' >'.$row2->title.'</option>';
				}
				$cnt_cntact_list='<option value="">--Select Contact--</option>';
				$cnt_cntact = $this->db->query("SELECT * FROM `client_contact` where `Client_Id`='$client_id'");
				foreach($cnt_cntact->result() as $result ){
					 
					$cnt_cntact_list.='<option data-cnt-id="'.$result->Contact_Id.'" value="'.$result->Contact_Name.'">'.$result->Contact_Name.'</option>';
				}
				$model_data = $this->db->query("SELECT * FROM `model` where `id`='$model_id'");
				$md_id = $model_data->row()->id;
				$md_name = $model_data->row()->title;
				$mak_data = $this->db->query("SELECT * FROM `make` where `id`='$make_id'");
				$mk_name = $mak_data->row()->title;
				if($mk_name == null){
					$mk_name = '';
				}
				else{
					$mk_name = $mk_name;
				}

				$vtype = $this->db->query("SELECT * FROM `vehicle_type` where `id`='$vtype_id'");
				if($vtype->num_rows() > 0 ){
					$vtype_n_id = $vtype->row()->id;
					$vtype_name = $vtype->row()->type;

				}
				else{
					$vtype_n_id = "";
					$vtype_name = "";
				}

				$data   =   json_encode(array('1',$make_id,$model_id,$make_list,$client_name,$client_telephone1,$client_id,$reg_no_id,
												$tax_no,$chassi_number,$car_color,$car_year,$client_code,$cnt_cntact_list,$client_email,
												$client_address,$client_telephone2,$client_telephone1,$tax_name,$tax_no,$remarks,$comments,
												$md_id,$md_name,$mk_name,$labour_disc,$parts_disc,$vtype_n_id,$reg_no,$vtype_name,$contact_id,$contact_name,$Contact_num,$client_mobile_no ));
				echo $data;
			} else {
				$data   =   json_encode(array('2',''));
				echo $data;
			}
		} else {
			$data   =   json_encode(array('0',''));
			echo $data;
		}
	}
	public function search_reg_no_job(){
		$reg_no =$this->input->post('reg_no');
		$html_table = '';
		if($reg_no!=='') {
			$v_id = $this->input->post('vtype');
			if($v_id !=="" && $reg_no!=='' ){
				$make_data = $this->db->query("SELECT R.`reg_no_id`,R.`v_type`,R.`client_mobile_no`,R.`reg_no`,R.`make_id`,R.`model_id`,R.`client_id`,R.`status`,R.`car_year`,R.`car_color`,R.`chassi_number`,R.labour_disc,R.parts_disc,CM.`client_name`,CM.`client_code`,CM.`client_telephone1`,CM.`tax_no`,CM.client_email,CM.client_address,CM.client_telephone1,CM.client_telephone2,CM.tax_name,CM.tax_no,CM.remarks,CM.acc_group_id FROM `reg_no_table` R INNER JOIN `new_client_master` CM ON CM.`client_id`=R.`client_id` where R.`reg_no`= '$reg_no' AND R.`v_type`='$v_id' ");
  					$other_make_data = $this->db->query("SELECT R.`reg_no_id`,R.`v_type`,R.`client_mobile_no`,R.`reg_no`,R.`make_id`,R.`model_id`,R.`client_id`,R.`status`,R.`car_year`,R.`car_color`,R.`chassi_number`,R.labour_disc,R.parts_disc,CM.`client_name`,CM.`client_code`,CM.`client_telephone1`,CM.`tax_no`,CM.client_email,CM.client_address,CM.client_telephone1,CM.client_telephone2,CM.tax_name,CM.tax_no,CM.remarks,CM.acc_group_id FROM `reg_no_table` R INNER JOIN `new_client_master` CM ON CM.`client_id`=R.`client_id` where R.`reg_no` = '$reg_no'  ");
 			}
			else{
				$make_data = $this->db->query("SELECT R.`reg_no_id`,R.`v_type`,R.`client_mobile_no`,R.`reg_no`,R.`make_id`,R.`model_id`,R.`client_id`,R.`status`,R.`car_year`,R.`car_color`,R.`chassi_number`,R.labour_disc,R.parts_disc,CM.`client_name`,CM.`client_code`,CM.`client_telephone1`,CM.`tax_no`,CM.client_email,CM.client_address,CM.client_telephone1,CM.client_telephone2,CM.tax_name,CM.tax_no,CM.remarks,CM.acc_group_id FROM `reg_no_table` R INNER JOIN `new_client_master` CM ON CM.`client_id`=R.`client_id` where R.`reg_no`='$reg_no'  ");
			}
		  	//$make_data = $this->db->query("SELECT R.`reg_no_id`,R.`v_type`,R.`client_mobile_no`,R.`reg_no`,R.`make_id`,R.`model_id`,R.`client_id`,R.`status`,R.`car_year`,R.`car_color`,R.`chassi_number`,R.labour_disc,R.parts_disc,CM.`client_name`,CM.`client_code`,CM.`client_telephone1`,CM.`tax_no`,CM.client_email,CM.client_address,CM.client_telephone1,CM.client_telephone2,CM.tax_name,CM.tax_no,CM.remarks,CM.acc_group_id FROM `reg_no_table` R INNER JOIN `new_client_master` CM ON CM.`client_id`=R.`client_id` where R.`reg_no`='$reg_no'  ");
		   //echo "SELECT R.`reg_no_id`,R.`client_mobile_no`,R.`reg_no`,R.`make_id`,R.`model_id`,R.`client_id`,R.`status`,R.`car_year`,R.`car_color`,R.`chassi_number`,CM.`client_name`,CM.`client_code`,CM.`client_telephone1`,CM.`tax_no`,CM.client_email,CM.client_address,CM.client_telephone1,CM.client_telephone2,CM.tax_name,CM.tax_no,CM.remarks,CM.acc_group_id FROM `reg_no_table` R INNER JOIN `new_client_master` CM ON CM.`client_id`=R.`client_id` where R.`reg_no`='$reg_no' ";

		   if($make_data->row_array()!=false){
				$make_id	=	$make_data->row()->make_id;
				$model_id	=	$make_data->row()->model_id;
				$client_name	=	$make_data->row()->client_name;
				$client_telephone1	=	$make_data->row()->client_mobile_no;
				$client_id	=	$make_data->row()->client_id;
				$reg_no_id	=	$make_data->row()->reg_no_id;
				$reg_no	=	$make_data->row()->reg_no;
				$tax_no	=	$make_data->row()->tax_no;
				$car_year	=	$make_data->row()->car_year;
				$car_color	=	$make_data->row()->car_color;
				$chassi_number	=	$make_data->row()->chassi_number;
				$client_code	=	$make_data->row()->client_code;
				$client_email	=	$make_data->row()->client_email;
				$client_address	=	$make_data->row()->client_address;
				$client_telephone1	=	$make_data->row()->client_telephone1;
				$client_telephone2	=	$make_data->row()->client_telephone2;
				$tax_name	=	$make_data->row()->tax_name;
				$tax_no	    =	$make_data->row()->tax_no;
				$remarks	=	$make_data->row()->remarks;
				$acc_gb_id  =   $make_data->row()->acc_group_id;
				$labour_disc  =  $make_data->row()->labour_disc;
				$parts_disc   =  $make_data->row()->parts_disc;
				$vtype_id     =  $make_data->row()->v_type;
				$client_mobile_no     =  $make_data->row()->client_mobile_no;
				$comments  = NULL;
				$make_list = '<option value="">--Select Model--</option>';
		   		$make_data = $this->db->query("SELECT * FROM `model` where `make_id`='$make_id'  ");				
				
				if($acc_gb_id  != 0) {
					$acc_gp_sql = $this->db->query("SELECT * FROM `account_group` WHERE acc_group_id = '$acc_gb_id'");
					if($acc_gp_sql->num_rows()> 0 ){

						$comments = $acc_gp_sql->row()->comments;
					}
				}
		   		foreach($make_data->result() as $row2){
					if($model_id==$row2->id){
						$selected='selected="selected"';
					} else {
						$selected='';
					}
					$make_list.='<option value="'.$row2->id.'" '.$selected.' >'.$row2->title.'</option>';
				}
				$cnt_cntact_list='<option value="">--Select Contact--</option>';
				$cnt_cntact = $this->db->query("SELECT * FROM `client_contact` where `Client_Id`='$client_id'");
				foreach($cnt_cntact->result() as $result ){
					 
					$cnt_cntact_list.='<option data-cnt-id="'.$result->Contact_Id.'" value="'.$result->Contact_Name.'">'.$result->Contact_Name.'</option>';
				}
				$model_data = $this->db->query("SELECT * FROM `model` where `id`='$model_id'");
				$md_id = $model_data->row()->id;
				$md_name = $model_data->row()->title;
				$mak_data = $this->db->query("SELECT * FROM `make` where `id`='$make_id'");
				$mk_name = $mak_data->row()->title;
				if($mk_name == null){
					$mk_name = '';
				}
				else{
					$mk_name = $mk_name;
				}

				$vtype = $this->db->query("SELECT * FROM `vehicle_type` where `id`='$vtype_id'");
				if($vtype->num_rows() > 0 ){
					$vtype_n_id = $vtype->row()->id;
					$vtype_name = $vtype->row()->type;

				}
				else{
					$vtype_n_id = "";
					$vtype_name = "";
				}

				$data   =   json_encode(array('1',$make_id,$model_id,$make_list,$client_name,$client_telephone1,$client_id,$reg_no_id,$tax_no,$chassi_number,$car_color,$car_year,$client_code,$cnt_cntact_list,$client_email,$client_address,$client_telephone2,$client_telephone1,$tax_name,$tax_no,$remarks,$comments,$md_id,$md_name,$mk_name,$labour_disc,$parts_disc,$vtype_n_id,$reg_no,$vtype_name,$client_mobile_no));
				echo $data;
			} 			
			else if($other_make_data->result_array() !=false)  {
 				$srch_result = $other_make_data->result_array();
				$i = 1;
				//var_dump($srch_result);
				foreach($srch_result as $result_array){
					$vtype_id = $result_array['v_type'];
					$vtype = $this->db->query("SELECT * FROM `vehicle_type` where `id`='$vtype_id'");
					if($vtype->num_rows() > 0 ){
						$vtype_n_id = $vtype->row()->id;
						$vtype_name = $vtype->row()->type;
					}
					else{
						$vtype_n_id = "";
						$vtype_name = "";
					}
					$html_table .= '<tr style="height: 0px;">
										<td colspan="4">
										<table style="width:100%;">
											<tr style="height: 0px;">
											  <td colspan="4">'.$result_array['client_name'].'</td>
											</tr>
											<tr style="height: 0px;border-bottom: 1px solid #cccccc85;">
												<td></td>
												<td><a href="'.site_url('m/m_dashboard/UpdateRegistration/'.$result_array['reg_no_id'].'').'">'.$result_array['reg_no'].'</a></td>
												<td>'.$vtype_name.'</td>
												<td></td>
											</tr>
										</table>
										</td>
									</tr>';
				}
				$data   =   json_encode(array('2',	$html_table));			
				echo $data;
			}
			else{
				$data   =   json_encode(array('3',''));
				echo $data;
			}
			 
		} else {
			$data   =   json_encode(array('0',''));
			echo $data;
		}
	}
	public function client_contact(){

		$client_id  = $this->input->post('Contact_Id');
		$cnt_cntact = $this->db->query("SELECT Contact_Tel FROM `client_contact` where `Contact_Id`='$client_id'");
		 
 		if( $cnt_cntact->num_rows() > 0){
			 
			echo    $cnt_cntact->row()->Contact_Tel;
		}
		else{
		 
			echo '';
		}
		

	}

	public function search_client() {
		$client	=	$this->input->post('client');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		$clients = explode(" ", trim($client));
		for($i=0;$i<count($clients);$i++) {
			$r	= $clients[$i];
			$sql.=" and client_name LIKE '%$r%' ";
		}
		$client_contact_data = $this->db->query("SELECT * FROM `new_client_master` where `client_name` like '$client%'  union (SELECT * FROM `new_client_master` where `client_id` not in (SELECT `client_id` FROM `new_client_master` where `client_name` like '$client%' ) ".$sql." order by client_name) ");
		$n=1;
		if(count($client_contact_data->result_array())>0){
			$html ='';
			$html .='<p calss="new_user" style="padding: 10px;border-bottom: 1px inset;background: #f1f1f9;font-weight: 600;" ><a href="'.site_url('Client_reports/create').'" target="_blank">Create New Customer</a></p>';
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<li value="' .$client_contact_datas['client_id'].'" class="client_button" tabindex="'.$n++.'" >
					<input type="hidden" class="client_name" value="'.$client_contact_datas['client_name'].'" />
					<input type="hidden" class="client_code" value="'.$client_contact_datas['client_code'].'" />
					<input type="hidden" class="client_address" value="'.$client_contact_datas['client_address'].'" />
					<input type="hidden" class="tax_no" value="'.$client_contact_datas['tax_no'].'" />'.$client_contact_datas['client_name'].'
					<input type="hidden" class="is_spare_disc" value="'.$client_contact_datas['is_spare_disc'].'" />
					<input type="hidden" class="is_labour_disc" value="'.$client_contact_datas['is_labour_disc'].'" />
				</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		print $html;
 	}
	 public function search_client_with_disc() {
		$client	=	$this->input->post('client');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		$clients = explode(" ", trim($client));
		for($i=0;$i<count($clients);$i++) {
			$r	= $clients[$i];
			$sql.=" and client_name LIKE '%$r%' ";
		}
		$client_contact_data = $this->db->query("SELECT * FROM `new_client_master` where `client_name` like '$client%'  union (SELECT * FROM `new_client_master` where `client_id` not in (SELECT `client_id` FROM `new_client_master` where `client_name` like '$client%' ) ".$sql." order by client_name) ");
		$n=1;
		if(count($client_contact_data->result_array())>0){
			$html ='';
			$html .='<p calss="new_user" style="padding: 10px;border-bottom: 1px inset;background: #f1f1f9;font-weight: 600;" ><a href="'.site_url('Client_reports/create').'" target="_blank">Create New Customer</a></p>';
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<li value="' .$client_contact_datas['client_id'].'" class="client_button" tabindex="'.$n++.'" >
							<input type="hidden" class="client_spare_disc" value="'.$client_contact_datas['is_spare_disc'].'"/>
							<input type="hidden" class="client_lab_disc" value="'.$client_contact_datas['is_labour_disc'].'"/>
							<input type="hidden" class="client_name" value="'.$client_contact_datas['client_name'].'" />
							<input type="hidden" class="client_code" value="'.$client_contact_datas['client_code'].'" />
							<input type="hidden" class="client_address" value="'.$client_contact_datas['client_address'].'"/>
							<input type="hidden" class="tax_no" value="'.$client_contact_datas['tax_no'].'" />'.$client_contact_datas['client_name'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		print $html;
 	}
	 public function search_client_withoutAdd() {
		$client	=	$this->input->post('client');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		$clients = explode(" ", trim($client));
		for($i=0;$i<count($clients);$i++) {
			$r	= $clients[$i];
			$sql.=" and client_name LIKE '%$r%' ";
		}
		$client_contact_data = $this->db->query("SELECT * FROM `new_client_master` where `client_name` like '$client%'  union (SELECT * FROM `new_client_master` where `client_id` not in (SELECT `client_id` FROM `new_client_master` where `client_name` like '$client%' ) ".$sql." order by client_name) ");
		$n=1;
		if(count($client_contact_data->result_array())>0){
			$html ='';
 			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<li value="'.$client_contact_datas['client_id'].'" class="client_button" tabindex="'.$n++.'" ><input type="hidden" class="client_name" value="'.$client_contact_datas['client_name'].'" /><input type="hidden" class="client_code" value="'.$client_contact_datas['client_code'].'" /><input type="hidden" class="client_address" value="'.$client_contact_datas['client_address'].'" /><input type="hidden" class="tax_no" value="'.$client_contact_datas['tax_no'].'" />'.$client_contact_datas['client_name'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		print $html;
 	}

	
	public function search_client_new() {
		$client	=	$this->input->post('client');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		$clients = explode(" ", trim($client));
		for($i=0;$i<count($clients);$i++) {
			$r	= $clients[$i];
			$sql.=" and client_name LIKE '%$r%' ";
		}
		$client_contact_data = $this->db->query("SELECT * FROM `new_client_master` WHERE `acc_group_id` = 25 AND (`client_name` LIKE '$client%' OR `client_id` NOT IN (SELECT `client_id` FROM `new_client_master` WHERE `client_name` LIKE '$client%' AND `acc_group_id` = 25))ORDER BY `client_name` ");
		//echo "";
		$n=1;
		if(count($client_contact_data->result_array())>0){
			$html ='';
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<li value="' .$client_contact_datas['client_id'].'" class="client_button" tabindex="'.$n++.'" ><input type="hidden" class="client_name" value="'.$client_contact_datas['client_name'].'" /><input type="hidden" class="client_code" value="'.$client_contact_datas['client_code'].'" /><input type="hidden" class="client_address" value="'.$client_contact_datas['client_address'].'" /><input type="hidden" class="tax_no" value="'.$client_contact_datas['tax_no'].'" />'.$client_contact_datas['client_name'].'</li>';
			}
		} else {
			$html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
		}
		print $html;
	}

	public function search_contact_person() {
		$client_id	=	$this->input->post('client_id');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		$client_contact_data = $this->db->query("SELECT * FROM `client_contact` where `Client_Id`='$client_id'");
		$n=1;
		if(count($client_contact_data->result_array())>0){
			$html ='<option value="" > - Select Contact Person- </option>';
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$html.='<option   data-cnt-id="'.$client_contact_datas['Contact_Id'].'"  value="'.$client_contact_datas['Contact_Name'].'">'.$client_contact_datas['Contact_Name'].'</option>';			
			}
		} else {
			$html.='<option value="" > - Select Contact Persons- </option>';
		}		
		print $html;
	}

	public function search_labour_charges() {
		$item	=	$this->input->post('item');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		
		$query = $this->db->query("SELECT * FROM `items` WHERE `item_name` like '%$item%' AND `is_labour` = 1 ");
		$itemList_date	=	$query->result_array();
		$itemList='';
		
		// foreach($itemList_date as $itemList_datas){
		// 	$html.='<li tabindex="-1" class="search_item_list l_item_button" data-rate="'.$itemList_datas['selling_price'].'" data-uom-id="'.$itemList_datas['unit_id'].'" data-uom="'.$itemList_datas['unit'].'" data-item_id="'.$itemList_datas['id'].'" data-item_code="'.$itemList_datas['item_code'].'" data-item_UOM_id="'.$itemList_datas['unit_id'].'" data-item_name="'.$itemList_datas['item_name'].'" item_tax_rate="'.$itemList_datas['vat_percentage'].'"  >'.$itemList_datas['item_name'].'</li>';
		// }
		foreach($itemList_date as $itemList_datas){
			if(!empty($itemList_datas['uom_id']) || $itemList_datas['uom_id'] != NULL){
				$uom_id = $itemList_datas['uom_id'];
			}
			else{
				$uom_id = $itemList_datas['unit_id'];
			}
			if(!empty($user_divsion)){
				$item_id  =$itemList_datas['id']  ;
				$tempriceqry = $this->db->query("SELECT * FROM `item_price` WHERE `division_id` =$user_divsion AND `uom_id` = $uom_id  AND `item_id` = $item_id");
				if($tempriceqry->num_rows() > 0){
					$item_price  = $tempriceqry->row()->sel_price;
				}
				else{
					$item_price  = $itemList_datas['selling_price'];
				}
				
			}
			else{
				$item_price  = $itemList_datas['selling_price'];
			}	
			$html.='<li tabindex="-1" class="search_item_list l_item_button" data-rate="'.$item_price.'" data-uom-id="'.$itemList_datas['unit_id'].'" data-uom="'.$itemList_datas['unit'].'" data-item_id="'.$itemList_datas['id'].'" data-item_code="'.$itemList_datas['item_code'].'" data-item_UOM_id="'.$itemList_datas['unit_id'].'" data-item_name="'.$itemList_datas['item_name'].'" item_tax_rate="'.$itemList_datas['vat_percentage'].'"  >'.$itemList_datas['item_name'].'</li>';
		
			//$html.='<li tabindex="-1" class="search_item_list item_button" data-rate="'.$item_price.'" data-uom-id="'.$itemList_datas['unit_id'].'"   data-item_code="'.$itemList_datas['item_code'].'"  data-item_id="'.$itemList_datas['id'].'"  data-item_UOM_id="'.$itemList_datas['unit_id'].'" data-item_name="'.$itemList_datas['item_name'].'" item_tax_rate="'.$itemList_datas['vat_percentage'].'"  >'.$itemList_datas['item_name'].'</li>';
		}
		if(count($itemList_date)==0){
			$html.='<li class="l_no_result_button">No data found</li>';
		}
		print $html;
	}

	public function search_spare_parts() {
		$item	=	$this->input->post('item');
		$user_divsion  = $this->input->post('user_divsion');
		
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		$query = $this->db->query("SELECT * FROM `items` WHERE `item_name` like '%$item%' LIMIT 10");

		$itemList_date	=	$query->result_array();
		$itemList='';
		foreach($itemList_date as $itemList_datas){
			if(!empty($itemList_datas['uom_id']) || $itemList_datas['uom_id'] != NULL){
				$uom_id = $itemList_datas['uom_id'];
			}
			else{
				$uom_id = $itemList_datas['unit_id'];
			}
			if(!empty($user_divsion)){
				$item_id  =$itemList_datas['id']  ;
				$tempriceqry = $this->db->query("SELECT * FROM `item_price` WHERE `division_id` =$user_divsion AND `uom_id` = $uom_id   AND `item_id` = $item_id");
				if($tempriceqry->num_rows() > 0){
					$item_price  = $tempriceqry->row()->sel_price;
				}
				else{
					$item_price  = $itemList_datas['selling_price'];
				}
				
			}
			else{
				$item_price  = $itemList_datas['selling_price'];
			}			
			$html.='<li tabindex="-1" class="search_item_list item_button" data-rate="'.$item_price.'"  data-item_code="'.$itemList_datas['item_code'].'"  data-item_id="'.$itemList_datas['id'].'"  data-item_UOM_id="'.$itemList_datas['unit_id'].'" data-item_name="'.$itemList_datas['item_name'].'" item_tax_rate="'.$itemList_datas['vat_percentage'].'"  >'.$itemList_datas['item_name'].'</li>';
		}
		if(count($itemList_date)==0){
			$html.='<li class="no_result_button">No data found</li>';
		}
		print $html;
	}
	public function get_job_no(){
		$division_id = $this->input->post('division_id');
		 echo	$this->crud_model->get_job_no($division_id);
	}

	public function search_client_in_enquiry() {
		$client	=	$this->input->post('client');
		$today	=	date("Y-m-d");
		$html	='';
		$sql="";
		/* $clients = explode(" ", trim($client));
		for($i=0;$i<count($clients);$i++) {
			$r	= $clients[$i];
			$sql.=" and client_name LIKE '%$r%' ";
		} */
		/* if($this->session->userdata('user_group_id') == 2 ) {
			$user_id	=	$this->session->userdata('user_id');
			$sql.="  and sales_man='$user_id'";
		}  */
		//$client_contact_data = $this->db->query("SELECT * FROM `new_client_master` where cstatus!=0 AND  ( `client_name` like '$client%' OR `client_telephone1` like '$client%' OR `client_telephone2` like '$client%'  )  union (SELECT * FROM `new_client_master` where cstatus!=0 AND `client_id` not in (SELECT `client_id` FROM `new_client_master` where cstatus!=0 AND ( `client_name` like '$client%' OR `client_telephone1` like '$client%' OR `client_telephone2` like '$client%' ) ) ".$sql." order by client_name) limit 25 ");
		$client_contact_data = $this->db->query("SELECT * FROM `new_client_master` where cstatus!=0 AND  ( `client_name` like '%$client%' OR `client_telephone1` like '%$client%' OR `client_telephone2` like '%$client%'  ) ".$sql." order by client_name limit 25 ");
		
		$n=1;
		
		if(count($client_contact_data->result_array())>0){
			$html='<tr class="no_result_button" tabindex="-1"><th><b>Name</b></th><th><b>Tel 1</b></th><th><b>Tel 2</b></th></tr>';
			foreach ($client_contact_data->result_array() as $client_contact_datas){
				$acc_group_id  = $client_contact_datas['acc_group_id'];
				$gcomments = '';
				$qry  =  $this->db->query("SELECT `comments` FROM `account_group` WHERE `acc_group_id` = '$acc_group_id'");
					if ($qry->num_rows()>0){
						$gcomments = $qry->row()->comments;
					}
					else{
						$gcomments = '';
					}
				 
				$html.='<tr tabindex="-1" >
						    <td class="client_button" >
								<input type="hidden" class="nbcli_id" value="' .$client_contact_datas['client_id'].'" />
								<input type="hidden" class="client_name" value="'.$client_contact_datas['client_name'].'" />
								<input type="hidden" class="client_code" value="'.$client_contact_datas['client_code'].'" />
								<input type="hidden" class="client_address" value="'.$client_contact_datas['client_address'].'" />
								<input type="hidden" class="client_telephone1" value="'.$client_contact_datas['client_telephone1'].'" />
								<input type="hidden" class="client_email" value="'.$client_contact_datas['client_email'].'" />
								<input type="hidden" class="is_credit" value="'.$client_contact_datas['is_credit'].'" />
								<input type="hidden" class="credit_days" value="'.$client_contact_datas['credit_days'].'" />
								<input type="hidden" class="credit_limit" value="'.$client_contact_datas['credit_limit'].'" />
								<input type="hidden" class="cperson" value="'.$client_contact_datas['contact_person'].'" />
								<input type="hidden" class="tax_name" value="'.$client_contact_datas['tax_name'].'" />
								<input type="hidden" class="tax_no" value="'.$client_contact_datas['tax_no'].'" />
								<input type="hidden" class="tax_perce" value="'.$client_contact_datas['tax_perce'].'" /> 
								<input type="hidden" class="gcomments" value="'.$gcomments.'" /> 
								<input type="hidden" class="cremarks" value="'.$client_contact_datas['remarks'].'" /> 
							'.$client_contact_datas['client_name'].'</td>
							<td>'.$client_contact_datas['client_telephone1'].'</td>
							<td>'.$client_contact_datas['client_telephone2'].'</td>
						</tr>';
			}
		} else {
			$html.='<tr class="no_result_button" tabindex="-1"><td style="color:red;" colspan="3" > No Results Found </td></tr>';
		}
		print $html;
	}

	public function search_vehicle_make() { //mobile
		$make	=	$this->input->post('make');
		$today	=	date("Y-m-d");
		$html	='';
		
		$query = $this->db->query("SELECT * FROM `make` WHERE `title` like '%$make%' AND `status` = 1 ");
		$makeList_data	=	$query->result_array();
		$makeList='';
		foreach($makeList_data as $makeList_datas){
			$html.='<li tabindex="-1" class="search_makelist make_button" data-make-name="'.$makeList_datas['title'].'"  data-make_id="'.$makeList_datas['id'].'" >'.$makeList_datas['title'].'</li>';
		}
		if(count($makeList_data)==0){
			$html.='<li class="no_result_button">No data found</li>';
		}
		print $html;
	}
	public function search_vehiclemake() {
		$make	=	$this->input->post('make');
		$today	=	date("Y-m-d");
		$html	='';
		
		$query = $this->db->query("SELECT * FROM `make` WHERE `title` like '%$make%' AND `status` = 1 ");
		$makeList_data	=	$query->result_array();
		$makeList='';
		foreach($makeList_data as $makeList_datas){
			$html.='<li tabindex="-1" class="search_makelist make_button" data-make-name="'.$makeList_datas['title'].'"  data-make_id="'.$makeList_datas['id'].'" >'.$makeList_datas['title'].'</li>';
		}
		if(count($makeList_data)==0){
			$html.='<li class="no_result_button">No data found</li>';
		}
		print $html;
	}

	public function get_vehicle_model(){
		$make_id	= $this->input->post('make_id');
		$html 		= "";
		$query		= $this->db->query("SELECT * FROM `model` WHERE `make_id` = $make_id  ");
		if(count($query->result_array())>0){
			$html ='<option value="" > - Choose Vehicle Model- </option>';
			foreach ($query->result_array() as $model_datas){
				$html.='<option data-model-name="'.$model_datas['title'].'"   value="'.$model_datas['id'].'">'.$model_datas['title'].'</option>';			
			}
		} else {
			$html.='<option value="" > - Choose Vehicle Model - </option>';
		}
		
		print $html;
	}	
		
	public function search_service_line_master() {
		$group_name	=	$this->input->post('group_name');
		$today	=	date("Y-m-d");
		$html	='';
		
		$query = $this->db->query("SELECT * FROM `service_line_group` WHERE `group_name` like '%$group_name%' AND `status` = 1 ");
		$makeList_data	=	$query->result_array();
		$makeList='';
		foreach($makeList_data as $makeList_datas){
			$html.='<li tabindex="-1" class="search_masterlist master_button" data-mastergroup-name="'.$makeList_datas['group_name'].'"  data-mastergroup_id="'.$makeList_datas['id'].'" >'.$makeList_datas['group_name'].'</li>';
		}
		if(count($makeList_data)==0){
			$html.='<li class="no_result_button">No data found</li>';
		}
		print $html;
	}

	public function get_service_line_last_code(){
		$service_group_id  =  $this->input->post('service_group_id');
		$query = $this->db->query("SELECT MAX(service_code) as new_service_code  FROM `service_line_master` WHERE service_group_id = $service_group_id LIMIT 1");
		$service_code  = $query->row()->new_service_code + 1;
		echo json_encode($service_code);
	}
	public function get_sub_service_line(){
		$service_group_id  =  $this->input->post('service_group_id');	
		$html  = $where = '';
		if(!empty($this->input->post('slm_id'))){
			$slm_id  = $this->input->post('slm_id');
			$where = "AND slm_id != '$slm_id'";
		}
		$query = $this->db->query("SELECT *  FROM `service_line_master` WHERE service_group_id = $service_group_id  AND is_troubleshoot != 0 $where");
		if($query->num_rows() > 0)
		{
			$html = '<option label="Select Sub Group" disabled>Select Sub Group</option>';
			foreach($query->result_array() as $subres){
				if(!empty($this->input->post('edt'))){
					$gp_id = $this->input->post('edt');
					$service_area = explode(',',$gp_id);
					$selected = in_array($subres['slm_id'],  $service_area) ? 'selected="selected"' : '';
					$html .='<option '.	$selected .' value="'.$subres['slm_id'].'">'.$subres['service_name'].'</option>';
				}
				else{
					$html .='<option  value="'.$subres['slm_id'].'">'.$subres['service_name'].'</option>';
				}				
			}			
		}
		else{
			$html ='<option value="" disabled>No data</option>';
		}
		echo json_encode($html);
	}
	public function search_Part_Description() {
		$stock_desc	= $this->input->post('stock_desc');
  		$html	='';		
		//$query = $this->db->query("SELECT I.*, IP.sel_price as Cost,IP.uom_id as ip_uom FROM `items` AS I Inner JOIN `item_price` AS IP ON IP.item_id = I.id WHERE I.item_name like '%$stock_desc%' AND `status` = 1 ");
		$query = $this->db->query("SELECT * FROM `items`  WHERE  item_name like '%$stock_desc%' AND `status` = 1 LIMIT 15");
		
		$makeList_data	=	$query->result_array();
		$makeList='';
 		foreach($makeList_data as $makeList_datas){
			$item_id = $makeList_datas['id']; 
			$QRY = $this->db->query("SELECT * FROM item_price WHERE `item_id` = $item_id AND `item_price_status` = 1 LIMIT 15");
 			if($QRY->num_rows() > 0){
				//$cost    = $QRY->row()->sel_price;
				//$uom_id  = $QRY->row()->uom_id;
				if($QRY->row()->sel_price == '' || empty($QRY->row()->sel_price)){
					$cost = $makeList_datas['cost_price'];
				}else{
					$cost =$QRY->row()->sel_price;
				}
				if($QRY->row()->uom_id== '' || empty($QRY->row()->uom_id)){
					$uom_id  = $makeList_datas['unit_id'];
				}else{
					$uom_id  = $QRY->row()->uom_id;
				}
			}
			else{
				$cost = $makeList_datas['cost_price'];
				$uom_id  = $makeList_datas['unit_id'];
			}

			$sql = $this->db->query("SELECT * FROM unit_master WHERE `unit_id` = $uom_id AND  `status` = 1 ");
			$unit_id = $sql->row()->unit_id;
			$unit_name = $sql->row()->unit_name;

			$html.='<li tabindex="-1" class="search_itemlist master_item_button" data-item-uom="'.$unit_id.'"  data-item-uom-name="'.$unit_name.'" data-item-cost="'.$cost.'"  data-item-name="'.$makeList_datas['item_name'].'"  data-item-code="'.$makeList_datas['item_code'].'"  data-item-id="'.$makeList_datas['id'].'" data-item-consu_vat="'.$makeList_datas['vat_percentage'].'" >'.$makeList_datas['item_name'].'</li>';
		}
		if(count($makeList_data)==0){
			$html.='<li class="no_result_button">No data found</li>';
		}
		print $html;
	}
}
?>