<?php
class Configuration extends CI_Controller {
	function Configuration ()
	{
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
	}
	function index($page=1)
	{
		$config['per_page']		= 5;
		$config['base_url'] 	= site_url('admin/configuration/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('configuration',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('configuration',
		array(),
		$config['per_page'],
		$offset
		);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('templates/header');
		$this->load->view('admin/configuration/list',$data);
		$this->load->view('templates/footer');
	}
	function create()
	{
		$this->load->view('templates/header');
		$this->load->view('admin/configuration/create');
		$this->load->view('templates/footer');
	}
	function edit($id)
	{
		$where=array(
				'config_id' => $id
		);
		$records=$this->crud_model->get('configuration',$where);
		if($records != false){
			//true section
			$data['config_name']			     = $records[0]['config_name'];
			$data['config_id']			         = $records[0]['config_id'];
			$data['config_value']			     = $records[0]['config_value'];
			$data['config_flag']			     = $records[0]['config_flag'];
			$this->load->view('templates/header');
			$this->load->view('admin/configuration/edit',$data);
			$this->load->view('templates/footer');

		}
		else{
			//false section
			$this->session->set_flashdata('response','<div class="alert alert-error">error</div>');
			redirect('admin/configuration');
		}

	}
	function do_insert()
	{
		$this->form_validation->set_rules('config_name', 'Configuration Name', 'required|max_length[30]|alpha_dash');
		$this->form_validation->set_rules('config_value', 'Configuration Value', 'required');
		$this->form_validation->set_rules('config_flag', 'Configuration Flag', 'required');

		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->load->view('templates/header');
			$this->load->view('admin/configuration/create');
			$this->load->view('templates/footer');
		}
		else
		{	// true section

			$data=array(
			         'config_name'               => strtoupper($this->input->post('config_name')),
					 'config_value'              => $this->input->post('config_value'),
					 'config_flag'               => $this->input->post('config_flag')

			);

			$rr=$this->crud_model->insert('configuration',$data);

			if($rr == false){
				// error

				$this->session->set_flashdata('response','<div class="alert alert-error">Configuration cannot be inserted</div>',':old:');
				$this->load->view('templates/header');
				$this->load->view('admin/configuration/create');
				$this->load->view('templates/footer');
			}
			else
			{
				// redirect
				$this->session->set_flashdata('response','<div class="alert alert-success">Configuration added successfully</div>');
				redirect('admin/configuration');

			}
		}

	}

	function do_update()
	{
		$this->form_validation->set_rules('config_name', 'Configuration Name', 'required|max_length[30]|alpha_dash');
		$this->form_validation->set_rules('config_value', 'Configuration Value', 'required');
		$this->form_validation->set_rules('config_flag', 'Configuration Flag', 'required');

		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->edit($this->input->post('config_id'));
		}
		else
		{// true section

			
			$where=array(
					'config_id'=> $this->input->post('config_id')
			);
			$data=array(
			         'config_name'               => strtoupper($this->input->post('config_name')),
					 'config_value'              => $this->input->post('config_value'),
					 'config_flag'               => $this->input->post('config_flag')

			);

			$records=$this->crud_model->update('configuration',$data,$where);

			$this->session->set_flashdata('response','<div class="alert alert-success">Configuration updated</div>');
			redirect('admin/configuration');

		}

	}
	function do_delete($id=0)
	{

		$where=array(
				'config_id'=> $id
		);

		$this->crud_model->delete('configuration',$where);

		$this->session->set_flashdata('response','<div class="alert alert-success">Configuration deleted</div>');
		redirect('admin/configuration');
	}
}
