<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class General_quotations extends CI_Controller {

	function General_quotations() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->model('furniture_quotation_model');
		$this->load->helper('num_words');
	}
	
	public function index($page=1, $print_view=0, $print_quotation_id=0) {
	
		$where = array();
		if($this->session->userdata('user_group_id') != 1){
			$where = array('salesman_id' => $this->session->userdata('user_id'));
		}		
		$where ['quotation_divisionid'] = QMS_GENERAL_QTN_DIV_ID;
				
		$config['per_page']		= 50;
		$config['base_url'] 	= site_url('general/general_quotations/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('view_furniture_quotations_client_project_users',$where);
		$offset = ($page-1) * $config['per_page'];
		$data['records'] = $this->crud_model->get('view_furniture_quotations_client_project_users',
			$where,
			$config['per_page'],
			$offset,
			'quotation_id',
			'desc'
		);
		
		/*To handle previous versions code start*/
		$data['old_quotations']=array();
		if($data['records'] != false) {
			foreach($data['records'] as $record){
			
				$data['old_quotations'][$record['quotation_number']]=array();
				
				if($record['quotation_revisionnumber'] == 0) {
					continue;
				}
				
				$where=array('quotation_number'=>$record['quotation_number']);
				$quotation_data=$this->crud_model->get('view_furniture_quotations_client_project_users_all',
					$where, null,null, 'quotation_revisionnumber', 'asc');
					
				foreach($quotation_data as $single_quotation) {
				
					$data['old_quotations'][$record['quotation_number']][$single_quotation['quotation_revisionnumber']]=$single_quotation['quotation_id'];	
				}	
				unset($data['old_quotations'][$record['quotation_number']][$record['quotation_revisionnumber']]);
						
			}// End of foreach($data['records'] as $record)
			/*To handle previous versions code end*/
		}
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		
		
		$data['print_view']=$print_view;
		$data['print_quotation_id']=$print_quotation_id;	
		$data = html_escape($data);
		
		$data["general_quotation"] = 1;
		
		$list = $this->crud_model->get_list('division_id','division_name','company_division',array('all'=>' - All Divisions - '));
		$data['division_list'] = $list;
		
		//$this->load->view('templates/header');
		$this->load->view('templates/header1');
		$this->load->view('general/quotations/quotation',$data);
		//$this->load->view('templates/footer');
		$this->load->view('templates/footer1');
	}
	public function filter_quotation() {
		
		//$this->form_validation->set_rules('filter_division', 'Company Divisions', 'required'); // For set_value()
		$this->form_validation->set_rules('filter_by', 'Filter Category', 'required'); // For set_value()		
		if ($this->form_validation->run() == FALSE) {
			// false section
			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->index();
			return;
		}
		
		$like=null;
		$or_where=null;
		$where=array();
		
		if($this->input->post('filter_by') == 1) {
			$where=array('quotation_number'=>$this->input->post('filter_value'));
		} elseif($this->input->post('filter_by') == 2) {
			$like=array('client_name'=> $this->input->post('filter_value'));
		} else {
			$or_where = array('client_telephone1'=>$this->input->post('filter_value'),
							  'client_telephone2'=>$this->input->post('filter_value'));			
		}
		// Handling Empty Text Field. 
		if($this->input->post('filter_value') == "") {
			$where=array();
			$or_where=array();
		}
		
		$where ['quotation_divisionid'] = QMS_GENERAL_QTN_DIV_ID;
			
		$data['records'] = $this->crud_model->get('view_furniture_quotations_client_project_users', $where, null, null,'quotation_id', 'desc', $like, $or_where);
		
		
		if($data['records'] == false) {
			$this->session->set_flashdata('response','<div class="alert alert-error">No matching quotation found</div>',':old:');
			$this->index();
			return;		
		}
		
		if($this->session->userdata('user_group_id') != 1){
			foreach($data['records'] as $index=>$furniture_item) {
				if($furniture_item['quotation_status'] == 'Confirmed') {
					continue;
				} else if ($furniture_item['salesman_id']!= $this->session->userdata('user_id') ){
				
					unset($data['records'][$index]);
				}
			}
				
		}	
		
		/*To handle previous versions code start*/
		$data['old_quotations']=array();
		
		foreach($data['records'] as $record){
		
			$data['old_quotations'][$record['quotation_number']]=array();
			
			if($record['quotation_revisionnumber'] == 0) {
				continue;
			}
			
			$where=array('quotation_number'=>$record['quotation_number']);
			$quotation_data=$this->crud_model->get('view_furniture_quotations_client_project_users',
				$where, null,null, 'quotation_revisionnumber', 'asc');
				
			foreach($quotation_data as $single_quotation) {
			
				$data['old_quotations'][$record['quotation_number']][$single_quotation['quotation_revisionnumber']]=$single_quotation['quotation_id'];	
			}	
			unset($data['old_quotations'][$record['quotation_number']][$record['quotation_revisionnumber']]);
					
		}// End of foreach($data['records'] as $record)
		/*To handle previous versions code end*/		
				
		$data['pagination'] = '';
				
		$data['print_view']=0;
		$data['print_quotation_id']=0;
		//$list = $this->crud_model->get_list('division_id','division_name','company_division',array('all'=>' - All Divisions - '));
		//$data['division_list'] = $list;
		
		$data['general_qtn_search'] = 1;
		
		
		$data=html_escape($data);
				
		$this->load->view('templates/header');
		$this->load->view('general/quotations/quotation',$data);
		$this->load->view('templates/footer');
		
			
	}	
	
	public function view($quotation_id) {

		$records = $this->furniture_quotation_model->get_full_quotation_details($quotation_id);
		
		if($records == false) {
				$this->session->set_flashdata('response','<div class="alert alert-error">Please Select a Quotation First..</div>');
				redirect('furniture/furniture_quotations');
		}
		
		if($records['quotation_status'] == "Draft") {
			$this->session->set_flashdata('response','<div class="alert alert-error">Sorry! Access denied.</div>');
			redirect('furniture/furniture_quotations');
		}		
		
		$data['quotation_number'] = $records['quotation_number'];
		$data['quotation_revision_number'] = $records['quotation_revisionnumber'];
		$data['quotation_date'] = $records['quotation_date'];
		
		$data['salesman_name'] = $records['salesman_name'];
		$data['salesman_direct_number'] = $records['salesman_direct_number'];
		$data['salesman_contact_number'] = $records['salesman_contact_number'];
		$data['salesman_email_id'] = $records['salesman_email_id'];
		
		$data['client_name'] = $records['client_name'];
		$data['client_address'] = $records['client_address'];
		$data['client_phone_number1'] = $records['client_telephone1'];
		$data['client_phone_number2'] = $records['client_telephone2'];
		$data['client_fax_number'] = $records['client_fax'];
		$data['client_email_id'] = $records['client_email'];
		
		$data['covering_letter'] = $records['covering_letter'];
		$data['furniture_items'] = $records['furniture_items'];
		
		$data['exstock_payment_text'] = $records['exstock_payment_text'];
		$data['exstock_payment_label'] = $records['exstock_payment_label'];
		$data['byorder_payment_label'] = $records['byorder_payment_label'];
		$data['byorder_payment_text'] = $records['byorder_payment_text'];
		
		$data['currency_code'] = $records['currency_code'];
		$data['currency_name'] = $records['currency_name'];
		
		$data['advance'] = $this->furniture_quotation_model->get_quotation_advance($quotation_id);
		
		$data['division_code'] = $records['division_code'];

		$data['logos_url'] = array();
		$logos_id = explode(",",$records['quotation_logos']);
		foreach($logos_id as $key=>$logo_id) {
			$where = array('logo_id' => $logo_id);
			$logo = $this->crud_model->get('logos',$where); 
			if($logo[0]['logo_filename']){
				array_push($data['logos_url'], $logo[0]['logo_filename']);
			}
		}
		
		$data['quotation_discount_amount'] = $records['quotation_discount_amount'];
		$data['discount_percentage'] = $records['discount_percentage'];
		$data['quotation_net_total'] = $records['quotation_net_total'];
		$data['quotation_total'] = $records['quotation_total'];
		
		$data['logos'] = $records['quotation_logos'];
		
		$this->load->view('general/quotations/view',$data);
		
	}
	
	function printview($quotation_id){
		
		
		$records = $this->furniture_quotation_model->get_full_quotation_details($quotation_id);
		//var_dump($records);
		
		if($records == false) {
				$this->session->set_flashdata('response','<div class="alert alert-error">Please Select a Quotation First..</div>');
				redirect('furniture/furniture_quotations');
		}
		
		
		$records['logos_url'] = array();
		$logos_id = explode(",",$records['quotation_logos']);
		foreach($logos_id as $key=>$logo_id) {
			$where = array('logo_id' => $logo_id);
			$logo = $this->crud_model->get('logos',$where); 
			if($logo[0]['logo_filename']){
				array_push($records['logos_url'], $logo[0]['logo_filename']);
			}
		}
		
		/*if($records['quotation_status'] == "Draft") {
			$this->session->set_flashdata('response','<div class="alert alert-error">Sorry! Access denied.</div>');
			redirect('furniture/furniture_quotations');
		}	*/
		
		$this->load->view('general/quotations/printview1',$records);
		
		
	}
	
	function quotationpdf($quotation_id)
	{
		 $this->load->helper(array('dompdf', 'file'));
		 // page info here, db calls, etc.     
		 
		 $records = $this->furniture_quotation_model->get_full_quotation_details($quotation_id);
		//var_dump($records);
		
		if($records == false) {
				$this->session->set_flashdata('response','<div class="alert alert-error">Please Select a Quotation First..</div>');
				redirect('furniture/furniture_quotations');
		}
		
		$records['logos_url'] = array();
		$logos_id = explode(",",$records['quotation_logos']);
		foreach($logos_id as $key=>$logo_id) {
			$where = array('logo_id' => $logo_id);
			$logo = $this->crud_model->get('logos',$where); 
			if($logo[0]['logo_filename']){
				array_push($records['logos_url'], $logo[0]['logo_filename']);
			}
		}
		 
		 $html = $this->load->view('general/quotations/printview1', $records, true);
		 pdf_create($html, 'Quotation_No_'.$quotation_id);
		
		 //if you want to write it to disk and/or send it as an attachment    
	}
	
	
		
}

?>