<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Delivery_note extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('Login');
		}
	}

	public function index() {
		
		
	}

	public function printDn($quotation_id,$type,$print_status=''){
		$this->users_model->permission("Delivery_note", "View");
		$rs = $this->db->query("SELECT DN.*,NCM.*,JC.job_card_number,JC.j_po_no,FQ.quotation_number_full FROM `delivery_note` DN LEFT JOIN `new_client_master` NCM ON NCM.`client_id`=DN.`client_id` LEFT join job_card JC on JC.id=DN.job_card_id LEFT JOIN furniture_quotation FQ on FQ.id=JC.quotation_id WHERE DN.`id`='$quotation_id';");
		$records['nbrcdrs'] =$rs->result_array();	
		$where=array('delivery_note_details.delvery_note_id' => $quotation_id);
		
		$records['furniture_itemlist'] = $this->crud_model->get('delivery_note_details', array('delivery_note_details.delvery_note_id'=>$quotation_id), null, null, "ex_furniture_area", "ASC", null, null, null, "furniture_area");
		if($records == false) {
			$this->session->set_flashdata('response','error');
			redirect('jobcard/Delivery_note/delivery_note_list');
		}
		
		$query = $this->db->get('company_details');
		$records['company_details'] = $query->row();
		foreach ($query->result() as $row){
			$company_email_name =  $row->company_name;
		}
		
		$records['print_status'] = $print_status;
		if($type=="pdf"){
			$records['print_type'] = "pdf_print_type";
			$mpdf = new \Mpdf\Mpdf();
			$datas   =   array("records" => $records,"nbrcdrs" => $rs->result_array(),"furniture_items" => $rs2->result_array(),'print_type'=>'pdf_print_type');
			$html = $this->load->view('general/quotations/printpdfdeliverynote', $datas , true);
			$mpdf->WriteHTML($html);
			$mpdf->Output();
		} else if($type=="normal"){
			$records['print_type'] = "normal_print_type";
			$this->load->view('general/quotations/printdeliverynote', $records);
		}
	}	

	function do_insert_delivery_note(){
		$this->users_model->permission("Delivery_note", "Add");
		$job_card_id=$this->input->post('nbxjob_card_id');
		$divisionid=$this->input->post('nbxjob_card_divisionid');
		$division_code=$this->input->post('nbxdivision_code');
		
		$where=array(
			'id'=> $job_card_id
		);
		$records=$this->crud_model->get('job_card',$where);
		if($records == false) {	
		} else {
			$this->db->trans_begin();
			$query2= $this->db->query("SELECT count(`delivery_note_number`) as `MaxID` FROM `delivery_note` WHERE `divisionid`='$divisionid' ");
			$maxId      = $query2->row();
			if ($maxId->MaxID==NULL){
				$mid	=0;
			} else {
				$mid=$maxId->MaxID+1;
			}
			$dlnt_no = 'DN'.date("y").$division_code.sprintf("%'.05d", ($mid));
			$data=array(
				'delivery_note_number'=> $dlnt_no,
				'delivery_noted_date' => date('Y-m-d h:m:s'),
				'divisionid'	      => $records[0]['divisionid'],
				'salesman_id'		  => $this->session->userdata('user_id'),
				'client_id'	    	  => $records[0]['client_id'],
				'project_name'	      => $records[0]['project_name'],
				'project_location'	  => $records[0]['project_location'],
				'project_remarks'	  => $records[0]['project_remarks'],
				'job_card_id'	      => $job_card_id,
			);
			$this->crud_model->insert('delivery_note',$data);
			$delvery_note_id	=	$this->db->insert_id();
			$nbxfurniture_item_id=$this->input->post('nbxfurniture_item_id');
			$rqqnty=$this->input->post('rqqnty');
			for($i=0;$i<count($this->input->post('nbxfurniture_item_id'));$i++){
				if($nbxfurniture_item_id[$i]!=='' && $rqqnty[$i]!==''){
					$where2=array(
						'job_card_details_id' => $nbxfurniture_item_id[$i]
					);
					$rs = $this->crud_model->get('job_card_details',$where2, null, null, null, null);
					foreach($rs as $furniture_item ) {
						
						$data3 = array(
							'delvery_note_id'		=> $delvery_note_id,
							'furniture_reference'	=> $furniture_item['furniture_reference'],
							'furniture_brand'		=> $furniture_item['furniture_brand'],
							'furniture_brand_other'	=> $furniture_item['furniture_brand_other'],
							'furniture_area'		=> $furniture_item['furniture_area'],
                            'ex_furniture_area'		=> $furniture_item['ex_furniture_area'],
							'sub_group'				=> $furniture_item['sub_group'],
                            'sub_group_id'			=> $furniture_item['sub_group'],
							'item_id'				=> $furniture_item['sub_group_id'],
							'furniture_model'		=> $furniture_item['furniture_model'],
							'furniture_description'	=> $furniture_item['furniture_description'],
							'uom'					=> $furniture_item['uom'],
							'delivery_quantity'		=> $rqqnty[$i],
							'job_card_details_id'	=> $nbxfurniture_item_id[$i],
						);
						
						$this->crud_model->insert('delivery_note_details',$data3);
					}
				}
			}

			$log_data=array(
				'trans_no'  	=>  $dlnt_no,
				'trans_type'	=>  'Delivery Note',
				'trans_op'  	=>  'Create',
				'trans_user_id' =>  $this->session->userdata('user_id')
			);
			$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);

			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				$this->session->set_flashdata('response', 'Something Wrong.Try Again...');
				redirect('jobcard/Delivery_note/delivery_note_list');
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'Delivery Note created Successfully');
				redirect('jobcard/Delivery_note/delivery_note_list');
			}	
		}
	}

	function do_update_delivery_note($job_card_id,$dn_id){
		$this->users_model->permission("Delivery_note", "Edit");
		$where=array(
			'id'=> $job_card_id
		);
		$records=$this->crud_model->get('job_card',$where);
		if($records == false) {	
		} else {
			$dnrecords=$this->Job_card_model->deliveryNoteRow($dn_id);

			$data=array(
				'delivery_noted_date'=> date('Y-m-d h:m:s'),
				'divisionid'	     => $records[0]['divisionid'],
				'salesman_id'		 => $this->session->userdata('user_id'),
				'client_id'	    	 => $records[0]['client_id'],
				'project_name'	     => $records[0]['project_name'],
				'project_location'	 => $records[0]['project_location'],
				'project_remarks'	 => $records[0]['project_remarks'],
				'job_card_id'	     => $job_card_id,
			);
			$delvery_note_id	=	$dn_id;
			$nbxfurniture_item_id=$this->input->post('nbxfurniture_item_id');
			$rqqnty=$this->input->post('rqqnty');
			$this->db->where('delvery_note_id',$dn_id);
			$this->db->delete('delivery_note_details');
			for($i=0;$i<count($this->input->post('nbxfurniture_item_id'));$i++){
				if($nbxfurniture_item_id[$i]!=='' && $rqqnty[$i]!=='' && $rqqnty[$i]!=='0' && $rqqnty[$i]!=='0.000'){
					$where2=array(
						'job_card_details_id' => $nbxfurniture_item_id[$i]
					);
					$rs = $this->crud_model->get('job_card_details',$where2, null, null, null, null);
					foreach($rs as $furniture_item ) {
						$data3 = array(
							'delvery_note_id'		=> $delvery_note_id,
							'furniture_reference'	=> $furniture_item['furniture_reference'],
							'furniture_brand'		=> $furniture_item['furniture_brand'],
							'furniture_brand_other'	=> $furniture_item['furniture_brand_other'],
							'furniture_area'		=> $furniture_item['furniture_area'],
                            'ex_furniture_area'		=> $furniture_item['ex_furniture_area'],
							'sub_group'				=> $furniture_item['sub_group'],
                            'sub_group_id'			=> $furniture_item['sub_group'],
							'item_id'				=> $furniture_item['sub_group_id'],
							'furniture_model'		=> $furniture_item['furniture_model'],
							'furniture_description'	=> $furniture_item['furniture_description'],
							'uom'					=> $furniture_item['uom'],
							'delivery_quantity'		=> $rqqnty[$i],
							'job_card_details_id'	=> $nbxfurniture_item_id[$i],
						);
						$this->crud_model->insert('delivery_note_details',$data3);
					}
				}
			}

			$log_data=array(
				'trans_no'  	=>  $dnrecords->delivery_note_number,
				'trans_type'	=>  'Delivery Note',
				'trans_op'  	=>  'Edit',
				'trans_user_id' =>  $this->session->userdata('user_id')
			);
			$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);

			$this->session->set_flashdata('success', 'Delivery Note Updated...');
			redirect('jobcard/Delivery_note/delivery_note_list');
		}
	}

	public function cancel_dn($id,$delivery_note_number){
		$this->users_model->permission("Delivery_note", "Delete");
		$this->db->where('id',$id);
		$data = array(
			'delivery_note_status' => 0
		);
		$receipt_cancel	= $this->db->update('delivery_note', $data);

		$log_data=array(
			'trans_no'  	=>  $delivery_note_number,
			'trans_type'	=>  'Delivery Note',
			'trans_op'  	=>  'Delete',
			'trans_user_id' =>  $this->session->userdata('user_id')
		);
		$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);

		if($receipt_cancel){
			$this->session->set_flashdata('success', 'Delivery Note Cancelled...');
		} else {
			$this->session->set_flashdata('response', 'Something Wrong.Try Again...');
		}
		redirect('jobcard/Delivery_note/delivery_note_list');
	}


	public function all_list($search_job_card_id) {
		$this->users_model->permission("Delivery_note", "View");
		$title['headerTitle']="Delivery Note";
		$this->data['receipts'] = $this->furniture_quotation_model->get_all_delivery_notes_by_job($search_job_card_id);
		$this->load->view('templates/header',$title);
		$this->load->view('furniture/quotations/jobcard/delivery_note_list',$this->data);
		$this->load->view('templates/footer');
	}

	public function delivery_note_list() {
		$this->users_model->permission("Delivery_note", "View");
		$title['headerTitle']="Delivery Note";
		$this->data['receipts'] = $this->furniture_quotation_model->get_all_delivery_notes();
		$this->load->view('templates/header',$title);
		$this->load->view('furniture/quotations/jobcard/delivery_note_list',$this->data);
		$this->load->view('templates/footer');
	}

	function create_delivery_note($job_card_id)	{
		$this->users_model->permission("Delivery_note", "Add");
		$page=1;
		$title['headerTitle']="Delivery Note Create";
		$jobcardrecords=$this->Job_card_model->get_job_card_data($job_card_id);
		
		$data['general_quotation'] 	  = 0;
		$data['currency_code'] 		  = $jobcardrecords['currency_code'];
		$data['job_card_divisionid']  = $jobcardrecords['job_card_divisionid'];
		$data['job_card_number']  	  = $jobcardrecords['job_card_number'];
		$data['quotation_number']  	  = $jobcardrecords['quotation_number'];
		$data['client_name']  		  = $jobcardrecords['client_name'];
		$data['client_id']  		  = $jobcardrecords['client_id'];
		$data['client_telephone1']    = $jobcardrecords['client_telephone1'];
		$data['division_code'] 		  = $jobcardrecords['division_code'];
		$data['dn_id']				  = NULL;
		
		$data['records'] 		= $this->crud_model->get('job_card_details', array('job_card_details.job_card_id'=>$job_card_id), null, null, "ex_furniture_area", "ASC", null, null, null, "ex_furniture_area");
		$data['mode']			= 'new';
		$data = html_escape($data);
	
		$this->load->view('templates/header',$title);
		$this->load->view('furniture/quotations/jobcard/delivery_note_view',$data);
		$this->load->view('templates/footer');
	}

	function delivery_note_edit($job_card_id,$dn_id)	{
		$this->users_model->permission("Delivery_note", "Edit");
		$page=1;
		$title['headerTitle']="Delivery Note Edit";
		$jobcardrecords=$this->Job_card_model->get_job_card_data($job_card_id);
		
		$data['general_quotation'] = 0;
		$data['currency_code'] 		  = $jobcardrecords['currency_code'];
		$data['job_card_divisionid']  = $jobcardrecords['job_card_divisionid'];
		$data['job_card_number']  	  = $jobcardrecords['job_card_number'];
		$data['quotation_number']  	  = $jobcardrecords['quotation_number'];
		$data['client_name']  		  = $jobcardrecords['client_name'];
		$data['client_id']  		  = $jobcardrecords['client_id'];
		$data['client_telephone1']    = $jobcardrecords['client_telephone1'];
		$data['division_code'] = $jobcardrecords['division_code'];
		
		$data['records'] 		= $this->crud_model->get('job_card_details', array('job_card_details.job_card_id'=>$job_card_id), null, null, "ex_furniture_area", "ASC", null, null, null, "ex_furniture_area");
		$data['job_card_id']	= $job_card_id;
		$data['dn_id']	= $dn_id;
		
		$data['mode']			= 'edit';
		$mode			= 'edit';
		$this->load->view('templates/header',$title);
		$this->load->view('furniture/quotations/jobcard/delivery_note_view',$data);
		$this->load->view('templates/footer');
	}
}
?>