<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Stock_adjustment extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('Login');
		}
	}

	public function index() {
		
		
	}

	public function stock_adjustment_list($fromDate	= "NIL",$toDate	= "NIL",$filter_value	= "NIL"){
		$this->users_model->permission("Stock_adjustment", "View");
		$title['headerTitle']="Stock Adjustment";
		if (@$this->input->post('fromDate')) {
			$date2 = str_replace('/', '-', $this->input->post("fromDate"));
			$fromDate =   date("Y-m-d", strtotime($this->input->post("fromDate")));
		}elseif ($fromDate != "NIL") {
			$fromDate	=	$fromDate;
		} else {
			$fromDate	= 'NIL';
		}
		
		if (@$this->input->post('toDate')) {
			$date3 = str_replace('/', '-', $this->input->post("toDate"));
			$toDate =   date( "Y-m-d", strtotime($this->input->post("toDate")));
		}elseif ($toDate != "NIL") {
			$toDate	=	$toDate;
		} else {
			$toDate	= 'NIL';
		}
		
		
		if (@$this->input->post('filter_value')) {
			$filter_value =   $this->input->post("filter_value");
		}elseif ($filter_value != "NIL") {
			$filter_value	=	$filter_value;
		} else {
			$filter_value	= "NIL";
		}
		
		$DeletePermission=$this->users_model->check_permission("Stock_adjustment","Delete");
		$EditPermission=$this->users_model->check_permission("Stock_adjustment","Edit");
		$i=1;
		$list='';
		$headList='';
		$cus=$this->input->post("supplier_name");
		$h=$this->Job_card_model->saListData();
		foreach ($this->Job_card_model->saListData() as $row) {
			$style='';
			if($row->status=='0'){
				$style='class="nb-td-cancel"';
			} else if($row->status=='1') {
				$style='class="nb-td-confirm"';
			} else {
				$style='class="nb-td-draft"';
			}
		    $list.='<tr '.$style.' >
						<td>'.$i++.'</td>
						<td>'.$row->sa_code.'</td>
						<td>'.date("M d, Y", strtotime($row->sa_date)).'</td>
						<td>'.$row->sa_type.'</td>
						<td>
							<div class="btn-group">
								<button type="button" class="btn btn-sm btn-primary dropdown-toggle" data-bs-toggle="dropdown">
									Action <span class="caret"></span>
								</button>
								<ul class="dropdown-menu" role="menu">';
									if($EditPermission) {
										$list.= '<li><a class="iframe iframe cboxElement click2" title="Edit" href="'.base_url().'index.php/jobcard/Stock_adjustment/edit_stock_adjustment/' . $row->sa_id . '"><i class="fa fa-edit"></i> Edit</a> </li>';
									}
									if($DeletePermission) {
										if($row->status!='0') {
											$rrr="'".$row->sa_id."','".$row->sa_code."'";
											$list.= '<li><a href="javascript:ConfirmDelete('.$rrr.')" ><i class="fa fa-close"></i> Cancel</a> </li>';
										} 
									}
									
								$list.= '</ul>
							</div>
						</td>
				    </tr>';
		}
		
		$datas   =   array("data" => $list,"fromDate" => $fromDate,"toDate" => $toDate,"filter_value" => $filter_value);	
		$this->load->view('templates/header',$title);
		$this->load->view('furniture/quotations/jobcard/stock_adjustment_list',$datas);
		$this->load->view('templates/footer');
	}



	function create_stock_adjustment()	{
		$this->users_model->permission("Stock_adjustment", "View");
		$division_id=1;
		$this->form_validation->set_rules('type', 'Type', 'required');
		$this->form_validation->set_rules('sa_date', 'SA Date', 'required');
		if ($this->form_validation->run() == FALSE){
			$nn=$this->Job_card_model->saNumber($division_id);
			$data['saNumber'] = $this->Job_card_model->get_sa_no($nn,$division_id);
			$data['mode']				= 'new';
			$data['location_list'] = $this->Job_card_model->loc_list();
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header');
			$this->load->view('furniture/quotations/jobcard/create_stock_adjustment',$data);
			$this->load->view('templates/footer');
		} else {
			$user_id	=	$this->session->userdata('user_id');
			$this->db->trans_begin();
			$sa_number=$this->Job_card_model->saNumber($division_id);
			$sa_code=$this->Job_card_model->get_sa_no($sa_number,$division_id);
			$sa_date = date('Y-m-d h:m:s',strtotime( $this->input->post('sa_date')));
			$data = array( 
				'sa_number'   => $sa_number,
				'sa_code'     => $sa_code,
				'sa_date'     => $sa_date,
				'division_id' => $division_id,
				'sa_type'      => $this->input->post('type'),
				'loc_id'      => $this->input->post('loc_id'),
				'user_id'     => $user_id,
				'status'      => 1
			);
			
			$this->db->insert('stock_adjustment_h', $data);
			$insert_id = $this->db->insert_id();
			 if($insert_id){
				$p_description_id	= $this->input->post('p_description_id');
				$p_description	    = $this->input->post('p_description');
				$p_nbitem	        = $this->input->post('p_nbitem');
				$p_section	        = $this->input->post('p_section');
				$p_qty	            = $this->input->post('p_qty');
				$p_rate	            = $this->input->post('p_rate');
				$p_discount	        = $this->input->post('p_discount');
				$p_vat	        	= $this->input->post('p_vat');
				$type_nb	        	= $this->input->post('type_nb');
				$po_gross_amt       = 0;
				$po_discount        = 0;
				$po_vat_amt         = 0;
				$po_net_amt         = 0;
				for($i=0; $i<count($p_description_id); $i++){
					if($p_description_id[$i]!==''){
						if($type_nb==='2'){
							$nb_qty=-1*$p_qty[$i];
						} else {
							$nb_qty=$p_qty[$i];
						}
						$data_array = array(
							'sa_id' 	      => $insert_id,
							'item_details_id' => $p_description_id[$i],
							'item_description'=> $p_description[$i],
							'item_qty' 		  => $nb_qty,
							'loc_id' 		  => $this->input->post('loc_id'),
							'item_rate' 	  => $p_rate[$i],
							'status'          => 1
						);
						$this->db->insert('stock_adjustment_b', $data_array);

						if($nb_qty>0){
							$item_amount	=	$nb_qty*$p_rate[$i];
						} else {
							$item_amount	=	$nb_qty*$p_rate[$i]*-1;
						}
						$item_trans_array = array(
							'trans_no' 	  => $sa_code,
							'item_id'  	  => $p_description_id[$i],
							'trans_date'  => $sa_date,
							'trans_type'  => 4,
							'item_qty' 	  => $nb_qty,
							'loc_id' 	  => $this->input->post('loc_id'),
							'item_rate'   => $p_rate[$i],
							'item_amount' => $item_amount,
							'user_id' 	  => $user_id,
							'created_date'  => date("Y-m-d"),
							'status'      => 1
						);
						$this->db->insert('item_trans', $item_trans_array);
	 		 		}
				}				
			} 
			$log_data=array(
				'trans_no'  	=> $sa_code,
				'trans_type'	=> 'Stock Adjustment',
				'trans_op'  	=> 'Create',
				'trans_user_id' => $this->session->userdata('user_id')
			);
			$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				redirect("jobcard/Stock_adjustment/stock_adjustment_list");
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'Added Successfully');
				redirect("jobcard/Stock_adjustment/stock_adjustment_list");
			}
		}
	}

	function edit_stock_adjustment($sa_id)	{
		$this->users_model->permission("Stock_adjustment", "Edit");
		$where=array(
			'sa_id'=> $sa_id
		);

		$this->form_validation->set_rules('type', 'Type', 'required');
		$this->form_validation->set_rules('sa_code', 'SA Number', 'required');
		$this->form_validation->set_rules('sa_date', 'SA Date', 'required');
		$this->db->select('*');
		$this->db->where($where);
		$this->db->from('stock_adjustment_h');
		$rs = $this->db->get();
		$data['dbdata']= $rs->row();


		$this->db->select('*');
		$this->db->where($where);
		$this->db->from('stock_adjustment_b');
		$rs = $this->db->get();
		$data['records']= $rs->result_array();


		if ($this->form_validation->run() == FALSE){
			$data['mode']				= 'new';
			$data['location_list'] = $this->Job_card_model->loc_list();
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header');
			$this->load->view('furniture/quotations/jobcard/edit_stock_adjustment',$data);
			$this->load->view('templates/footer');
		} else {
			$sa_code	= $this->input->post('sa_code');
			$sa_date 	= date('Y-m-d h:m:s',strtotime( $this->input->post('sa_date')));
			$user_id	= $this->session->userdata('user_id');
			$this->db->trans_begin();
			$data = array( 
				'sa_type'      => $this->input->post('type'),
				'loc_id'      => $this->input->post('loc_id'),
				'user_id'     => $user_id,
				'sa_date' => $sa_date,
				'status'      => 1
			);
			$this->db->where('sa_id', $sa_id);
			$this->db->update('stock_adjustment_h', $data);

			 if($sa_id){
				$p_description_id	= $this->input->post('p_description_id');
				$sa_b_id			= $this->input->post('sa_b_id');
				$p_description	    = $this->input->post('p_description');
				$p_nbitem	        = $this->input->post('p_nbitem');
				$p_section	        = $this->input->post('p_section');
				$p_qty	            = $this->input->post('p_qty');
				$p_rate	            = $this->input->post('p_rate');
				$p_discount	        = $this->input->post('p_discount');
				$p_vat	        	= $this->input->post('p_vat');
				$po_gross_amt       = 0;
				$po_discount        = 0;
				$po_vat_amt         = 0;
				$po_net_amt         = 0;

				$this->db->where("trans_no",$sa_code);
				$this->db->where("trans_type",'4');
				$this->db->delete('item_trans');

				for($i=0; $i<count($p_description_id); $i++){
					if($p_description_id[$i]!==''){
						$data_array = array(
							'sa_id' 	      => $sa_id,
							'item_details_id' => $p_description_id[$i],
							'item_description'=> $p_description[$i],
							'item_qty' 		  => $p_qty[$i],
							'loc_id' 		  => $this->input->post('loc_id'),
							'item_rate' 	  => $p_rate[$i],
							'status'          => 1
						);
						if($sa_b_id[$i]!==''){
							$where2=array(
								'sa_b_id'=> $sa_b_id[$i]
							);
							$this->db->update('stock_adjustment_b', $data_array,$where2);
						} else {
							$this->db->insert('stock_adjustment_b', $data_array);
						}
						

						if($p_qty[$i]>0){
							$item_amount	=	$p_qty[$i]*$p_rate[$i];
						} else {
							$item_amount	=	$p_qty[$i]*$p_rate[$i]*-1;
						}
						$item_trans_array = array(
							'trans_no' 	  => $sa_code,
							'item_id'  	  => $p_description_id[$i],
							'trans_date'  => $sa_date,
							'trans_type'  => 4,
							'item_qty' 	  => $p_qty[$i],
							'loc_id' 	  => $this->input->post('loc_id'),
							'item_rate'   => $p_rate[$i],
							'item_amount' => $item_amount,
							'user_id' 	  => $user_id,
							'created_date'  => date("Y-m-d"),
							'status'      => 1
						);
						$this->db->insert('item_trans', $item_trans_array);
	 		 		}
				}				
			} 
			$log_data=array(
				'trans_no'  	=> $sa_code,
				'trans_type'	=> 'Stock Adjustment',
				'trans_op'  	=> 'Edit',
				'trans_user_id' => $this->session->userdata('user_id')
			);
			$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				redirect("jobcard/Stock_adjustment/stock_adjustment_list");
			} else {
				$this->db->trans_commit();
				$this->session->set_flashdata('success', 'Stock Adjusted Successfully');
				redirect("jobcard/Stock_adjustment/stock_adjustment_list");
			}
		}
	}

	public function search_item() {
		$client	=	$this->input->post('item');
		$today	=	date("Y-m-d");
		$html	='';
		$sql=" and item_name LIKE '%$client%' ";
		$client_contact_data = $this->db->query("SELECT * FROM `items` where item_type='1' ".$sql." order by item_name limit 25 ");
		$n=1;
		if(count($client_contact_data->result_array())>0){
			
			$html='<tr  class="no_result_button" tabindex="-1" ><th><b>Item Name</b></th><th><b>Stock</b></th></tr>';
			foreach ($client_contact_data->result_array() as $client_contact_datas){ 
				$item_id=$client_contact_datas['id'];
				$contact_data = $this->db->query("Select s.`item_trans_id`,s.`trans_no`,s.`item_id`,s.`item_rate`,t.balance_qty,s.`user_id`,s.created_date,s.status from `item_trans` s inner join (SELECT max(`item_trans_id`) as tid,sum(`item_qty`) as balance_qty FROM `item_trans` WHERE status='1' and item_id='$item_id' ) as t on t.tid=s.item_trans_id ORDER BY `item_trans_id` desc  limit 1 ");
				
				if($contact_data->row()!=false){
					$cost_price	=	$contact_data->row()->item_rate;
					$balance_qty	=	$contact_data->row()->balance_qty;
				} else {
					$cost_price	=	$client_contact_datas['cost_price'];
					$balance_qty=0;
				}
				$html.='<tr tabindex="-1" ><td value="' .$client_contact_datas['id'].'" class="p_description_button" style="width:500px;" ><input type="hidden" class="nb_id" value="'.$client_contact_datas['id'].'" /><input type="hidden" class="item_name" value="'.$client_contact_datas['item_name'].'" /><input type="hidden" class="item_description" value="'.htmlspecialchars($client_contact_datas['description']).'" /><input type="hidden" class="item_unit" value="'.$client_contact_datas['unit'].'" /><input type="hidden" class="cost_price" value="'.$cost_price.'" />'.$client_contact_datas['item_name'].'</td><td style="width:50px;text-align:right;">'.$balance_qty.'</td></tr>';
			}
		} else {
			$html.='<td style="color:red;" class="no_result_button" colspan="3" tabindex="-1" > No Results Found </td>';
		}
		
		print $html;
	}
	

	public function stock_adjustment_delete($sa_id,$sa_code){
		$this->users_model->permission("Stock_adjustment", "Delete");
		$update_data = array(
			'status'      => 0,
		);
		$this->db->where('sa_id', $sa_id);
		$this->db->update('stock_adjustment_h', $update_data);

		$this->db->where('trans_no', $sa_code);
		$this->db->where('trans_type', 4);
		$this->db->update('item_trans', $update_data);

		$log_data=array(
			'trans_no'  	=>  $sa_code,
			'trans_type'	=>  'Stock Adjustment',
			'trans_op'  	=>  'Delete',
			'trans_user_id' =>  $this->session->userdata('user_id')

		);
		$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);

		$this->session->set_flashdata('response', 'Cancelled...');
		redirect('jobcard/Stock_adjustment/stock_adjustment_list');
	}
}
?>