<?php
class Brand extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
	}
	function index($stock_group_id='NIL',$name='NIL',$page=1)	{
		$this->users_model->permission("Brand", "View");
		$title['headerTitle']="Brand List";

		$where=array();
		$like=array();
		/* if (@$this->input->post('stock_group_id')) {
			$stock_group_id =   $this->input->post("stock_group_id");
		}elseif ($stock_group_id != "NIL") {
			$stock_group_id	=	$stock_group_id;
		} else {
			$stock_group_id	= "NIL";
		} */
		$stock_group_id	= "NIL";
		if (@$this->input->post('name')) {
			$name =   $this->input->post("name");
		} elseif ($name != "NIL") {
			$name	=	$name;
		} else {
			$name	= "NIL";
		}
		$this->db->select('furniture_brands.brand_id' );
		$this->db->from('furniture_brands');

		if($stock_group_id != "NIL") {
			$this->db->where('stock_group_id', $stock_group_id);
		}
		if($name != "NIL") {
			$this->db->like('brand_name',$name);
		}
		$rs = $this->db->get();

		$config['per_page']		= 100;
		$config['base_url'] 	= site_url('masters/Brand/index/'.$stock_group_id.'/'.$name.'/');
		$config['total_rows'] 	= $rs->num_rows();

		if ($this->uri->segment(6)) {
			$offset = $this->uri->segment(6)*100-100;
			$i=$page+1;
		} else {
			$offset = 0;
			$i=1;
		}

		$this->db->select('furniture_brands.brand_id,furniture_brands.stock_group_id,furniture_brands.brand_name,furniture_brands.status,stock_group.stock_group_name' );
		$this->db->from('furniture_brands');
		$this->db->join('stock_group','furniture_brands.stock_group_id = stock_group.id','left');
		if($stock_group_id != "NIL") {
			$this->db->where('stock_group_id', $stock_group_id);
		}
		if($name != "NIL") {
			$this->db->like('brand_name',$name);
		}
		$this->db->limit($config['per_page'], $offset);
		$rs = $this->db->get();
		$data['records'] =	$rs->result_array();
		
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		$data['name']		= $name;
		$data['stock_group_id']		= $stock_group_id;
		$this->load->view('templates/header',$title);
		$this->load->view('masters/brand/list',$data);
		$this->load->view('templates/footer');
	}
	function create() {
		$this->users_model->permission("Brand", "Add");
		$title['headerTitle']="Brand Create";
		$this->load->view('templates/header',$title);
		$this->load->view('masters/brand/create');
		$this->load->view('templates/footer');
	}
	function edit($id) {
		$this->users_model->permission("Brand", "Edit");
		$title['headerTitle']="Brand Edit";

		$this->db->select('furniture_brands.brand_id,furniture_brands.stock_group_id,furniture_brands.brand_name,furniture_brands.status,stock_group.stock_group_name' );
		$this->db->from('furniture_brands');
		$this->db->join('stock_group','furniture_brands.stock_group_id = stock_group.id','left');
		$this->db->where('brand_id', $id);
		$rs = $this->db->get();
		
		$records=$rs->result_array();
		if($records != false){
			//true section
			$data['brand_name']	= $records[0]['brand_name'];
			$data['brand_id']	= $records[0]['brand_id'];
			$data['status']	    = $records[0]['status'];
			$data['stock_group_name']	= $records[0]['stock_group_name'];
			$data['stock_group_id']	    = $records[0]['stock_group_id'];

			$data['user_status'] = $this->config->item('user_status_array');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/brand/edit',$data);
			$this->load->view('templates/footer');

		} else {
			//false section
			$this->session->set_flashdata('response','error');
			redirect('masters/Unit');
		}
	}
	function do_insert() {
		$this->users_model->permission("Brand", "Add");
		$title['headerTitle']="Brand Create";
		//$this->form_validation->set_rules('stock_group_id', 'Stock Group', 'required');
		$this->form_validation->set_rules('name', 'Name', 'required');
		
		if ($this->form_validation->run() == FALSE) {
			// false section
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$this->load->view('templates/header',$title);
			$this->load->view('masters/brand/create');
			$this->load->view('templates/footer');
		} else {	// true section

			$name=$this->input->post('name');
			//$stock_group_id=$this->input->post('stock_group_id');
			$stock_group_id=0;
			
			$data=array(
				'brand_name' 	=> $name,
				'stock_group_id'=> $stock_group_id
			);

			$rr=$this->crud_model->insert('furniture_brands',$data);
			$insert_id = $this->db->insert_id();
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=> 'Inventory Brand',	
				'masters_id'  => $insert_id,	
				'date'		  => $date,	
				'created_id'  => $userid,	
				'masters_op'  => 'create',	
			);
			$this->crud_model->insert('log_for_masters',$data);
			if($rr == false) {
				// error
				$this->session->set_flashdata('response','Brand cannot be inserted',':old:');
				redirect('masters/Brand');
			} else {
				// redirect
				$this->session->set_flashdata('success','Brand added successfully');
				redirect('masters/Brand');
			}
		}
	}
	function do_update() {
		$this->users_model->permission("Brand", "Edit");
		$title['headerTitle']="Brand Edit";
		//$this->form_validation->set_rules('stock_group_id', 'Stock Group', 'required');
		$brand_id = ascii_to_entities($this->input->post('brand_id'));
		
		$status = ascii_to_entities($this->input->post('status'));
		$file_error = "";
		$filename = "";
		$this->form_validation->set_rules('name', 'Name', 'required');
		
		

		if ($this->form_validation->run() == FALSE) {
			// false section
			$this->db->select('furniture_brands.brand_id,furniture_brands.stock_group_id,furniture_brands.brand_name,furniture_brands.status,stock_group.stock_group_name' );
			$this->db->from('furniture_brands');
			$this->db->join('stock_group','furniture_brands.stock_group_id = stock_group.id','left');
			$this->db->where('brand_id', $brand_id);
			$rs = $this->db->get();
			$records=$rs->result_array();

			if($records != false){
				//true section
				$data['brand_name']			= $records[0]['brand_name'];
				$data['brand_id']			= $records[0]['brand_id'];
				$data['status']				= $records[0]['status'];
				$data['stock_group_name']	= $records[0]['stock_group_name'];
				$data['stock_group_id']	    = $records[0]['stock_group_id'];

				$data['user_status'] = $this->config->item('user_status_array');

				$this->session->set_flashdata('response',''.validation_errors().'',':old:');
				$this->load->view('templates/header',$title);
				$this->load->view('masters/brand/edit',$data);
				$this->load->view('templates/footer');

			} 
		} else {// true section

			$name=$this->input->post('name');
			//$currency_code =  $currency_code;
			
			//$stock_group_id = ascii_to_entities($this->input->post('stock_group_id'));
			$stock_group_id = 0;
			$where=array(
				'brand_id'  => $brand_id
			);
			$data=array(
				'brand_name' => $name,
				'stock_group_id' => $stock_group_id,
				'status' => $status
			);

			$records=$this->crud_model->update('furniture_brands',$data,$where);


			/* $item_data=array(
				'stock_group_id' => $stock_group_id
			);

			$records=$this->crud_model->update('items',$item_data,$where); */

		
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=> 'Inventory Brand',	
				'masters_id'  => $brand_id,	
				'date'		  => $date,	
				'created_id'  => $userid,	
				'masters_op'  => 'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);
			$this->session->set_flashdata('success','Brand updated');
			redirect('masters/Brand');
		}
	}
	function do_delete($unit_id=0) {
		$this->users_model->permission("Brand", "Delete");
		$where=array(
			'unit_id'  => $unit_id
		);
		$data=array('status' => 0);
			
		$records=$this->crud_model->update('unit_master',$data,$where);
		 
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Inventory Brand',	
				'masters_id'=>$unit_id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'delete',	
			);
			$this->crud_model->insert('log_for_masters',$data);

		$this->session->set_flashdata('response','Brand deleted');
		redirect('masters/Brand');
	}
}