<?php
class ServiceLineGroup extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
		$this->load->model('Vehicle');
		$this->load->model('users_model');
	}
	public function index(){
		$this->users_model->permission("ServiceLineGroup", "View");
		$title['headerTitle']="Service Line Group";
		$data['grouplist']  = $this->Vehicle->getServiceLineGroup();	
		$data['section_master']  = $this->Vehicle->getsectionMaster();	
		$this->load->view('templates/header',$title);
		$this->load->view('masters/vehicle/service_line_group',$data);
		$this->load->view('templates/footer');
	}
	public function Update_servicelinegroupstatus(){
		$this->users_model->permission("ServiceLineGroup", "Edit");
		$this->db->trans_begin();
		$id =  $this->input->post('id');
		$status =  $this->input->post('status');
		$where = array('id' => $id);
		$data = array(
			'status'    => $status
	   );
		$this->crud_model->update('service_line_group',$data,$where);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			echo 'error';
		} else {
			$this->db->trans_commit();
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Service Line Group - Status',	
				'masters_id'=>$id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);
			echo 'success';
		}
	}
	public function create(){
		$this->users_model->permission("ServiceLineGroup", "Add");		
 		$config = array(
			array(
				'field' => 'group_name',
				'label' => 'Group Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.',
 				)
            ),
			array(
				'field' => 'group_code',
				'label' => 'Group Code',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
		   ),
		   array(
				'field' => 'section_master',
				'label' => 'Section',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Select %s.'
				)
		   ),
		);	
		if($this->input->post('group_code') != '')
		{
			$config[] = array(
				'field' => 'group_code',
				'label' => 'Group Code',
				'rules' => 'trim|is_unique[service_line_group.group_code]',
				'errors' => array(
					'is_unique'      => '%s  is Already Exists..'
				)
			);
		}
        $this->form_validation->set_rules($config);
		if ($this->form_validation->run() == FALSE){
			$data['group_code']     =  set_value('group_code');
			$data['group_name']     =  set_value('group_name');
			$data['section_master'] =  set_value('section_master');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$title['headerTitle']="Service Line Group";
			$data['grouplist']  = $this->Vehicle->getServiceLineGroup();		
			$data['section_master']  = $this->Vehicle->getsectionMaster();		
			$this->load->view('templates/header',$title);
			$this->load->view('masters/vehicle/service_line_group',$data);
			$this->load->view('templates/footer');
		}
		else{
			$data = array(
				'group_name' =>	$this->input->post('group_name'),
				'group_code' => $this->input->post('group_code'),
				'section_master_id' => $this->input->post('section_master')
			);
			$res = $this->crud_model->insert('service_line_group',$data);
			if($res){
				$service_code =  $this->input->post('group_code').'001';
				$service_name =  $this->input->post('group_name').' troubleshooting';
				$insert_id = $this->db->insert_id();
				$data = array(
					'service_group_id' => $insert_id,
					'service_code'     => $service_code,
					'service_name'	   => $service_name,
					'aws' 			   => 0,
					'is_troubleshoot'  => 0
				);
				$this->crud_model->insert('service_line_master',$data);


				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'=>'Service Line Group',	
					'masters_id'=>$insert_id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'create',	
				);
				$this->crud_model->insert('log_for_masters',$data);
			    $this->session->set_flashdata('success', 'Service Line Group Created Successfully');				 
			}
			else{
				$this->session->set_flashdata('response', 'Something WentWrong');
				 
			}
			redirect('masters/ServiceLineGroup');
		}
	}
	public function update_serviceline(){		
		$this->users_model->permission("ServiceLineGroup", "Edit");
		$group_code = $this->input->post('edit_group_code');
		$insert_id = $this->input->post('edit_group_id');
		$check_unique = $this->Vehicle->checkgroupCode($group_code);
		$config = array(
			array(
				'field' => 'edit_group_name',
				'label' => 'Group Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.',
 				)
            ),
			array(
				'field' => 'edit_group_code',
				'label' => 'Group Code',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
		   ),
		   array(
				'field' => 'edit_section_master',
				'label' => 'Section',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Select %s.'
				)
		   ),
		); 

		if($this->input->post('edit_group_code') != '' && ($check_unique->id != $insert_id && $check_unique->group_code == $group_code))
		{
			$config[] = array(
				'field' => 'edit_group_code',
				'label' => 'Group Code',
				'rules' => 'trim|is_unique[service_line_group.group_code]',
				'errors' => array(
					'is_unique'      => '%s  is Already Exists..'
				)
			);
		}
		$this->form_validation->set_rules($config);
		if ($this->form_validation->run() == FALSE){
			$data['edit_group_code']     =  set_value('edit_group_code');
			$data['edit_group_name']     =  set_value('edit_group_name');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$title['headerTitle']="Service Line Group";
			$data['grouplist']  = $this->Vehicle->getServiceLineGroup();	
			$data['section_master']  = $this->Vehicle->getsectionMaster();	
			$this->load->view('templates/header',$title);
			$this->load->view('masters/vehicle/service_line_group',$data);
			$this->load->view('templates/footer');
		}
		else{
			$datas = array(
				'group_name'    	=> $this->input->post('edit_group_name'),
				'group_code' 		=> $this->input->post('edit_group_code'),				
				'section_master_id' => $this->input->post('edit_section_master'),				
			);
			
			$where = array(
				'id' 	=> $insert_id,
			);
  			$res = $this->crud_model->update('service_line_group',$datas,$where);	
				
 			if($res){			
					
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'=>'Service Line Group',	
					'masters_id'=>$insert_id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'update',	
				);
				$this->crud_model->insert('log_for_masters',$data);
			    $this->session->set_flashdata('success', 'Service Line Group Updated Successfully');				 
			}
			else{
				$this->session->set_flashdata('response', 'Something WentWrong');				
			}
			redirect('masters/ServiceLineGroup');
		}
	}
}