<?php
class ServiceLineMaster extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
		$this->load->model('Vehicle');
		$this->load->model('users_model');
	}
	public function index(){
		$this->users_model->permission("ServiceLineMaster", "View");
		$title['headerTitle']="Service Line Group";
		$data['grouplist']  = $this->Vehicle->getServiceLineMaster();	
		$this->load->view('templates/header',$title);
		$this->load->view('masters/vehicle/service_line_master',$data);
		$this->load->view('templates/footer');
	}
	public function Update_servicelinegroupstatus(){
		$this->users_model->permission("ServiceLineMaster", "Edit");
		$this->db->trans_begin();
		$id =  $this->input->post('id');
		$status =  $this->input->post('status');
		$where = array('id' => $id);
		$data = array(
			'status'    => $status
	   );
		$this->crud_model->update('service_line_master',$data,$where);
		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			echo 'error';
		} else {
			$this->db->trans_commit();
			$date = date("Y-m-d H:i:s");
			$userid = $this->session->userdata('user_id');
			$data= array(						
				'masters_type'=>'Service Line Group - Status',	
				'masters_id'=>$id,	
				'date'=>$date,	
				'created_id'=> $userid,	
				'masters_op'=>'update',	
			);
			$this->crud_model->insert('log_for_masters',$data);
			echo 'success';
		}
	}
	public function create(){
		$this->users_model->permission("ServiceLineMaster", "Add");		
 		$config = array(
			array(
				'field' => 'group_name',
				'label' => 'Group Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.',
 				)
            ),

		   array(
				'field' => 'service_code',
				'label' => 'Service Code',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => ' %s Is Required.'
				)
		   ), 
		   array(
				'field' => 'service_name',
				'label' => 'Service Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
		   ),
		   array(
				'field' => 'aws',
				'label' => 'AWS',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
		   ),
		);	
		if(!empty($this->input->post('group_name')) || $this->input->post('group_name') != ''){
			$config[] =array(
				'field' => 'service_group_id',
				'label' => 'Group Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => '  %s Is Not Valid.'
				)
			);
		}
        $this->form_validation->set_rules($config);
		if ($this->form_validation->run() == FALSE){
			$data['group_code']     =  set_value('group_code');
			$data['group_name']     =  set_value('group_name');
			$data['group_name']     =  set_value('group_name');
			$data['aws']     =  set_value('aws');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$title['headerTitle']="Service Line Group";
			$data['grouplist']  = $this->Vehicle->getServiceLineMaster();		
			$this->load->view('templates/header',$title);
			$this->load->view('masters/vehicle/service_line_master',$data);
			$this->load->view('templates/footer');
		}
		else{
			$service_area_str = '';
			$service_area  =  $this->input->post('sub_service_line_id');
 			if(!empty($service_area)){
				for($i=0;$i<count($service_area);$i++){
					$service_area_str.=$service_area[$i].',';
				}
				$service_area_str=rtrim($service_area_str, ',');
			}
			$data = array(
				'service_group_id' => $this->input->post('service_group_id'),
				'service_code'     => $this->input->post('service_code'),
				'service_name'	   => $this->input->post('service_name'),
				'sub_service_line_id' => $service_area_str,
				'aws' 			   => $this->input->post('aws'),
				'is_troubleshoot'  => 1
			);
			$res = $this->crud_model->insert('service_line_master',$data);
			if($res){
				$insert_id = $this->db->insert_id();
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'=>'Service Line Master',	
					'masters_id'=>$insert_id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'create',	
				);
				$this->crud_model->insert('log_for_masters',$data);
			    $this->session->set_flashdata('success', 'Service Line Master Created Successfully');				 
			}
			else{
				$this->session->set_flashdata('response', 'Something WentWrong');
				 
			}
			redirect('masters/ServiceLineMaster');
		}
	}
	public function update_serviceline_master(){		
		$this->users_model->permission("ServiceLineMaster", "Edit");
		$config = array(
			array(
				'field' => 'edit_group_name',
				'label' => 'Group Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.',
 				)
            ),

		   array(
				'field' => 'edit_service_code',
				'label' => 'Service Code',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => ' %s Is Required.'
				)
		   ), 
		   array(
				'field' => 'edit_service_name',
				'label' => 'Service Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
		   ),
		   array(
				'field' => 'edit_aws',
				'label' => 'AWS',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
		   ),
		);	
		if(!empty($this->input->post('group_name')) || $this->input->post('group_name') != ''){
			$config[] =array(
				'field' => 'edit_service_group_id',
				'label' => 'Group Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => '  %s Is Not Valid.'
				)
			);
		}
		$this->form_validation->set_rules($config);
		if ($this->form_validation->run() == FALSE){
			$data['edit_group_name']     =  set_value('edit_group_name');
			$data['edit_service_code']   =  set_value('edit_service_code');
			$data['edit_service_name']   =  set_value('edit_service_name');
			$data['edit_aws']   		 =  set_value('edit_aws');
			$data['is_troubleshoot']     =  set_value('is_troubleshoot');
			$data['edit_group_name']     =  set_value('edit_group_name');
			$data['m_status']     		 =  set_value('m_status');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$title['headerTitle']="Service Line Group";
			$data['grouplist']  = $this->Vehicle->getServiceLineMaster();		
			$this->load->view('templates/header',$title);
			$this->load->view('masters/vehicle/service_line_master',$data);
			$this->load->view('templates/footer');
		}
		else{
			$service_area_str = '';
			$service_area  =  $this->input->post('edit_sub_service_line_id');
 			if(!empty($service_area)){
				for($i=0;$i<count($service_area);$i++){
					$service_area_str.=$service_area[$i].',';
				}
				$service_area_str=rtrim($service_area_str, ',');
			}

			$datas = array(
				'service_group_id' => $this->input->post('edit_service_group_id'),
				'service_code'     => $this->input->post('edit_service_code'),
				'service_name'	   => $this->input->post('edit_service_name'),
				'sub_service_line_id' => $service_area_str,
				'aws' 			   => $this->input->post('edit_aws'),
				'is_troubleshoot'  => $this->input->post('is_troubleshoot'),
				'm_status'		   => $this->input->post('m_status') 	
			);
			$insert_id = $this->input->post('edit_slm_id');
			$where = array(
				'slm_id' 	=> $insert_id,
			);
  			$res = $this->crud_model->update('service_line_master',$datas,$where);					
 			if($res){				
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'=>'Service Line Master',	
					'masters_id'=>$insert_id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'update',	
				);
				$this->crud_model->insert('log_for_masters',$data);
			    $this->session->set_flashdata('success', 'Service Line Master Updated Successfully');				 
			}
			else{
				$this->session->set_flashdata('response', 'Something WentWrong');				
			}
			redirect('masters/ServiceLineMaster');
		}
	}
}