<?php
class VehicleCategory extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
		$this->load->model('Vehicle');
		$this->load->model('users_model');
	}
	public function index(){
		$this->users_model->permission("VehicleCategory", "View");
		$title['headerTitle']="Vehicle Category";
		$data['vchtypelist']  = $this->Vehicle->getVehicleCategoryList();	
		$this->load->view('templates/header',$title);
		$this->load->view('masters/vehicle/vehicle_category',$data);
		$this->load->view('templates/footer');
	}
	public function create(){
		$this->users_model->permission("VehicleCategory", "Add");		
 		$config = array(
			array(
				'field' => 'cat_name',
				'label' => 'Category Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.',
 				)
            ),
			array(
				'field' => 'factor',
				'label' => 'Factor',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
		   ),
		);	
		if($this->input->post('cat_name') != '')
		{
			$config[] = array(
				'field' => 'cat_name',
				'label' => 'Category Name',
				'rules' => 'trim|is_unique[vehicle_category.vh_type]',
				'errors' => array(
					'is_unique'      => '%s  is Already Exists..'
				)
			);
		}
        $this->form_validation->set_rules($config);
		if ($this->form_validation->run() == FALSE){
			$data['cat_name']     =  set_value('cat_name');
			$data['factor']     =  set_value('factor');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$title['headerTitle']="Vehicle Category";
			$data['vchtypelist']  = $this->Vehicle->getVehicleCategoryList();		
			$this->load->view('templates/header',$title);
			$this->load->view('masters/vehicle/vehicle_category',$data);
			$this->load->view('templates/footer');
		}
		else{
			$data = array(
				'vh_type' =>	$this->input->post('cat_name'),
				'vh_factor' => $this->input->post('factor')
			);
			$res = $this->crud_model->insert('vehicle_category',$data);
			if($res){
				$insert_id = $this->db->insert_id();
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'=>'Vehicle Category',	
					'masters_id'=>$insert_id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'create',	
				);
				$this->crud_model->insert('log_for_masters',$data);
			    $this->session->set_flashdata('success', 'Vehicle Category Created Successfully');				 
			}
			else{
				$this->session->set_flashdata('response', 'Something WentWrong');
				 
			}
			redirect('masters/VehicleCategory');
		}
	}
	public function update_vehiclecategory(){		
		$this->users_model->permission("ServiceLineGroup", "Edit");
		$edit_cat_name = $this->input->post('edit_cat_name');
		$insert_id = $this->input->post('edit_cat_id');
		$check_unique = $this->Vehicle->checkVehicleCategoryName($edit_cat_name);
		$config = array(
			array(
				'field' => 'edit_cat_name',
				'label' => 'Category Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.',
 				)
            ),
			array(
				'field' => 'edit_factor',
				'label' => 'Factor',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
		   ),
		); 

		if($this->input->post('edit_cat_name') != '' && ($check_unique->vh_type_id != $insert_id && $check_unique->vh_type == $edit_cat_name))
		{
			$config[] = array(
				'field' => 'edit_cat_name',
				'label' => 'Category Name',
				'rules' => 'trim|is_unique[vehicle_category.vh_type]',
				'errors' => array(
					'is_unique'      => '%s  is Already Exists..'
				)
			);
		}
		$this->form_validation->set_rules($config);
		if ($this->form_validation->run() == FALSE){
			$data['edit_cat_name']     =  set_value('edit_cat_name');
			$data['edit_factor']     =  set_value('edit_factor');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$title['headerTitle']="Vehicle Category";
			$data['vchtypelist']  = $this->Vehicle->getVehicleCategoryList();			
			$this->load->view('templates/header',$title);
			$this->load->view('masters/vehicle/vehicle_category',$data);
			$this->load->view('templates/footer');
		}
		else{
			$datas = array(
				'vh_type'    	=> $this->input->post('edit_cat_name'),
				'vh_factor' 	=> $this->input->post('edit_factor'),				
				'vh_status' 	=> $this->input->post('edit_vh_status'),				
			);
			
			$where = array(
				'vh_type_id' 	=> $insert_id,
			);
  			$res = $this->crud_model->update('vehicle_category',$datas,$where);	
				
 			if($res){			
					
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'=>'Vehicle Category',	
					'masters_id'=>$insert_id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'update',	
				);
				$this->crud_model->insert('log_for_masters',$data);
			    $this->session->set_flashdata('success', 'Vehicle Category Updated Successfully');				 
			}
			else{
				$this->session->set_flashdata('response', 'Something WentWrong');				
			}
			redirect('masters/VehicleCategory');
		}
	}
}