<?php
class VehicleRegistration extends CI_Controller {
	public function __construct(){
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->helper('text');
		$this->config->load('arrays');
		$this->load->model('Vehicle');
		$this->load->model('users_model');
	}
	public function index(){
		$this->users_model->permission("VehicleRegistration", "View");
		$title['headerTitle']="Vehicle Registration";
		$data['make']  = $this->Vehicle->getMake();
		$data['model']  = $this->Vehicle->getModel();
		$data['customer']  = $this->Vehicle->getCustomer();
		$data['registration']  = $this->Vehicle->getRegistration();		
		$this->load->view('templates/header',$title);
		$this->load->view('masters/vehicle/vehicle_registration',$data);
		$this->load->view('templates/footer');
	}
	public function create_registration(){
		$this->users_model->permission("VehicleRegistration", "Add");
		$title['headerTitle']="Vehicle Registration";
		$this->load->view('templates/header',$title);
		$data['make']  = $this->Vehicle->getMake();
		$this->load->view('masters/vehicle/create_registration',$data);
		$this->load->view('templates/footer');
	}
	public function create(){
		$this->users_model->permission("VehicleRegistration", "Add");
		
		$reg_no_id = $this->input->post('reg_no');
		$dbdata = $this->Vehicle->dataRow($reg_no_id);	
		$is_chassi = $this->crud_model->is_chassi_number();
			// if($reg_no_id && $dbdata->reg_no != $reg_no_id){
			// 	$config = array(
			// 		array(
			// 				'field' => 'reg_no',
			// 				'label' => 'This Registration Number',
			// 				'rules' => 'trim|is_unique[reg_no_table.reg_no]',
			// 				'errors' => array(
			// 					'is_unique'      => '%s  is Already Exists..'
			// 				)
			// 		)
			// 	);
			// }	
			// if($this->input->post('chassi_number') != '' && $dbdata->chassi_number != $this->input->post('chassi_number')){
			// 	$config = array(
			// 		array(
			// 				'field' => 'chassi_number',
			// 				'label' => 'Chassi Number',
			// 				'rules' => 'trim|is_unique[reg_no_table.chassi_number]',
			// 				'errors' => array(
			// 					'is_unique'      => '%s already exists.'
			// 				)
			// 		)
			// 	);
			// }
		 
		$config = array(
			array(
                    'field' => 'reg_no',
                    'label' => 'Registration Number',
                    'rules' => 'trim|required|is_unique[reg_no_table.reg_no]',
                    'errors' => array(
                        'required'      => 'Please Enter %s.',
						'is_unique'      => '%s  is Already Exists..'
                    )
            ),
			array(
				'field' => 'client',
				'label' => 'Customer Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
		   ),
		   array(
			'field' => 'client_id',
			'label' => 'Client Name ',
			'rules' => 'trim|required',
			'errors' => array(
				'required'      => ' %s Is not valid.'
			)
			),
			array(
                    'field' => 'make',
                    'label' => 'Make',
                    'rules' => 'required',
                    'errors' => array(
                        'required'      => 'Please Select %s.'
                    )
            ),
			array(
                    'field' => 'model',
                    'label' => 'Model',
                    'rules' => 'required',
                    'errors' => array(
                        'required'      => 'Please Select %s.'
                    )
			),
		// 	array(
		// 		'field' => 'chassi_number',
		// 		'label' => 'Chassi Number',
		// 		'rules' => 'required|trim|is_unique[reg_no_table.chassi_number]',
		// 		'errors' => array(
		// 			'is_unique'      => '%s already exists.'
		// 		)
		//    )
		);	
		
		if(isset($is_chassi) && $is_chassi == 0){
			//if($this->input->post('chassi_number') != ''){
				$config[] = array(
					'field' => 'chassi_number',
					'label' => 'Chassi Number',
					'rules' => 'trim|required|is_unique[reg_no_table.chassi_number]',
					'errors' => array(
						'is_unique'      => '%s already exists.'
					)
				);
			//}
		}
		else{
			if($this->input->post('chassi_number') != '' || !empty($this->input->post('chassi_number'))){
			 
				$config[] = array(
					'field' => 'chassi_number',
					'label' => 'Chassi Number',
					'rules' => 'trim|is_unique[reg_no_table.chassi_number]',
					'errors' => array(
						'is_unique'      => '%s already exists.'
					)
				);
			}
		}	 

		//echo $is_chassi;exit();
        $this->form_validation->set_rules($config);
		if ($this->form_validation->run() == FALSE){
			$data['reg_no']   =  set_value('reg_no');
			$data['make']     =  set_value('make');
			$data['model']    =  set_value('model');
			$data['client']   =  set_value('client');
			$data['client_id']   =  set_value('client_id');
			$data['chassi_number']  =  set_value('chassi_number');
			$data['labour_disc']    =  set_value('labour_disc');
			$data['parts_disc']     =  set_value('parts_disc');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			$title['headerTitle']   ="Vehicle Registration";
			$this->load->view('templates/header',$title);
			$data['make']  = $this->Vehicle->getMake();
			$this->load->view('masters/vehicle/create_registration',$data);
			$this->load->view('templates/footer');
		}
		else{
			$data = array(
				'reg_no'	 =>	$this->input->post('reg_no'),
				'make_id'    => $this->input->post('make'),
				'model_id'   => $this->input->post('model'),
				'client_id'  => $this->input->post('client_id'),				 
				'car_year'   => $this->input->post('car_year'),
				'car_color'  => $this->input->post('car_color'),
				'chassi_number' => $this->input->post('chassi_number'),
				'radio_code'  => $this->input->post('radio_code'),
				'key_number'  => $this->input->post('key_number'),
				'labour_disc' => $this->input->post('labour_disc'),
				'parts_disc'  => $this->input->post('parts_disc'),
			);
			$res = $this->Vehicle->insertregistration($data);
			if($res){
				$insert_id = $this->db->insert_id();
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'=>'Vehicle Registration',	
					'masters_id'=>$insert_id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'create',	
				);
				$this->crud_model->insert('log_for_masters',$data);
			    $this->session->set_flashdata('success', 'Registration  Successfully');				 
			}
			else{
				$this->session->set_flashdata('response', 'Something WentWrong');
				 
			}
			redirect('masters/VehicleRegistration');
		}
	}
	public function editRegistration($reg_no_id = ''){
		$this->users_model->permission("VehicleRegistration", "Edit");
		$title['headerTitle']="Update Vehicle Registration";
		$this->load->view('templates/header',$title);
		$data['make']  = $this->Vehicle->getMake();	
		$data['customer']  = $this->Vehicle->getCustomer();
		$data['edit_reg'] = $this->Vehicle->getUpdateRegi($reg_no_id);
		$data['model']  = $this->Vehicle->getregisterModel($data['edit_reg']->make_id);
		$this->load->view('masters/vehicle/edit_registration',$data);
		$this->load->view('templates/footer');
	}
	public function edit(){		
		$this->users_model->permission("VehicleRegistration", "Edit");
		
		$reg_no_id = $this->input->post('reg_no_id');
		$dbdata = $this->Vehicle->dataRow($reg_no_id);
		$is_chassi = $this->crud_model->is_chassi_number();
	
		$config = array(
			array(
				'field' => 'reg_no',
				'label' => 'This Registration Number',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.',
				)
			),
			array(
				'field' => 'client_id',
				'label' => 'Client Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => '%s Is not valid.'
				)
				),
			array(
				'field' => 'client',
				'label' => 'Customer Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
			),
			array(
				'field' => 'make',
				'label' => 'Make',
				'rules' => 'required',
				'errors' => array(
					'required'      => 'Please Select %s.'
				)
			),
			array(
				'field' => 'model',
				'label' => 'Model',
				'rules' => 'required',
				'errors' => array(
					'required'      => 'Please Select %s.'
				)
				),
			array(
				'field' => 'chassi_number',
				'label' => 'Chassi Number',
				'rules' => 'required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
				),
			
			);
	
		if($this->input->post('reg_no')!='' && $dbdata->reg_no!=$this->input->post('reg_no')){
			$config[] = array(
				'field' => 'reg_no',
				'label' => 'This Registration Number',
				'rules' => 'trim|is_unique[reg_no_table.reg_no]',
				'errors' => array(
					'is_unique'      => '%s  is Already Exists..'
				)
			);
		}
		if(isset($is_chassi) && $is_chassi == 0){
			if($this->input->post('chassi_number') != '' && $dbdata->chassi_number!= $this->input->post('chassi_number')){
				$config[] = array(
					'field' => 'chassi_number',
					'label' => 'Chassi Number',
					'rules' => 'trim|required|is_unique[reg_no_table.chassi_number]',
					'errors' => array(
						'is_unique'      => '%s already exists.'
					)
				);
			}
		}
		else{
			if($this->input->post('chassi_number') != '' && $dbdata->chassi_number!= $this->input->post('chassi_number')){
				$config[] = array(
					'field' => 'chassi_number',
					'label' => 'Chassi Number',
					'rules' => 'trim|is_unique[reg_no_table.chassi_number]',
					'errors' => array(
						'is_unique'      => '%s already exists.'
					)
				);
			}
		}
		$this->form_validation->set_rules($config);
		if ($this->form_validation->run() == FALSE){
			$data['reg_no']   =  set_value('reg_no');
			$data['make']     =  set_value('make');
			$data['model']    =  set_value('model');
			$data['client']   =  set_value('client');
			$data['client_id']   =  set_value('client_id');
			$data['chassi_number']  =  set_value('chassi_number');
			$data['car_year']       =  set_value('car_year');
			$data['car_color']      =  set_value('car_color');
			$data['labour_disc']    =  set_value('labour_disc');
			$data['parts_disc']     =  set_value('parts_disc');
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			//$title['headerTitle']="Update Vehicle Registration";
		   // $this->load->view('templates/header',$title);
			$data['make']  = $this->Vehicle->getMake();	
			$data['customer']  = $this->Vehicle->getCustomer();
			$data['edit_reg'] = $this->Vehicle->getUpdateRegi($reg_no_id);
			$data['model']  = $this->Vehicle->getregisterModel($data['edit_reg']->make_id);

			//$this->load->view('masters/vehicle/edit_registration', array_merge($data, array('reg_no_id' => $reg_no_id)));

			//$this->load->view('masters/vehicle/edit_registration/'.$reg_no_id,$data);
			redirect('masters/VehicleRegistration/editRegistration/'.$reg_no_id.'');
			//$this->load->view('templates/footer');
			//redirect('masters/VehicleRegistration/editRegistration/'.$this->input->post('reg_no_id').'');
		}
		else {
			$data = array(
				'make_id' 		=> $this->input->post('make'),
				'model_id'    	=> $this->input->post('model'),
				'client_id'    	=> $this->input->post('client_id'),
				'car_year' 		=> $this->input->post('car_year'),
				'car_color' 	=> $this->input->post('car_color'),
				'chassi_number' => $this->input->post('chassi_number'),
				'radio_code' 	=> $this->input->post('radio_code'),
				'key_number' 	=> $this->input->post('key_number'),
				'labour_disc'   => $this->input->post('labour_disc'),
				'parts_disc'    => $this->input->post('parts_disc'),
			);
			$res = $this->Vehicle->Updateregistration($data);
			if($res){
				/*$jobcarddata = array(
					'make' 		=> $this->input->post('make'),
					'model'    	=> $this->input->post('model'),
					'car_year' 		=> $this->input->post('car_year'),
					'car_color' 	=> $this->input->post('car_color'),
					'chassi_number' => $this->input->post('chassi_number'),
				);
				$this->Vehicle->UpdateVRegistrationInJobcard($jobcarddata);*/

				$insert_id = $this->input->post('reg_no');
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'=>'VehicleRegistration',	
					'masters_id'=>$insert_id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'update',	
				);
				$this->crud_model->insert('log_for_masters',$data);
			    $this->session->set_flashdata('success', 'Vehicle Registration Updated Successfully');				 
			}
			else{
				$this->session->set_flashdata('response', 'Something WentWrong');
				
			}
			redirect('masters/VehicleRegistration');
		}
	}
	public function updateNewRegistration(){
		$this->users_model->permission("VehicleRegistration", "Edit");
		$this->users_model->permission("VehicleRegistration", "Edit");
		$config = array(
			array(
                    'field' => 'reg_no',
                    'label' => 'Registration Number',
                    'rules' => 'trim|required',
                    'errors' => array(
                        'required'      => 'Please Enter %s.'
                    )
            ),
			array(
				'field' => 'client',
				'label' => 'Customer Name',
				'rules' => 'trim|required',
				'errors' => array(
					'required'      => 'Please Enter %s.'
				)
		   ),
			array(
                    'field' => 'make',
                    'label' => 'Make',
                    'rules' => 'required',
                    'errors' => array(
                        'required'      => 'Please Select %s.'
                    )
            ),
			array(
                    'field' => 'model',
                    'label' => 'Model',
                    'rules' => 'required',
                    'errors' => array(
                        'required'      => 'Please Select %s.'
                    )
            )
		);
		$reg_no_id = $this->input->post('reg_no_id');	
		$this->form_validation->set_rules($config);
		if ($this->form_validation->run() == FALSE){
			$this->session->set_flashdata('response',''.validation_errors().'',':old:');
			redirect('masters/VehicleRegistration');
		}
		else{
				$data = array(
				'make_id'   => $this->input->post('make'),
				'model_id'  => $this->input->post('model'),
				'client_id' => $this->input->post('client_id'),				 
			);
			$res = $this->Vehicle->Updatenameregistration($data);
			if($res){
				$insert_id = $this->input->post('reg_no');
				$date = date("Y-m-d H:i:s");
				$userid = $this->session->userdata('user_id');
				$data= array(						
					'masters_type'=>'VRegister Change Name',	
					'masters_id'=>$insert_id,	
					'date'=>$date,	
					'created_id'=> $userid,	
					'masters_op'=>'update',	
				);
				$this->crud_model->insert('log_for_masters',$data);
			    $this->session->set_flashdata('success', 'Name Changed Successfully');				 
			}
			else{
				$this->session->set_flashdata('response', 'Something WentWrong');
				
			}
			redirect('masters/VehicleRegistration');

		}	
	}
}