<?php
class kitchen_brands extends CI_Controller {
	function Kitchen_brands()
	{
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
	}
	function index($page=1)
	{
		$config['per_page']		= 5;
		$config['base_url'] 	= site_url('masters/kitchen_brands/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('kitchen_brands',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('kitchen_brands',
		array(),
		$config['per_page'],
		$offset
		);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('templates/header');
		$this->load->view('masters/kitchen_brands/list',$data);
		$this->load->view('templates/footer');
	}
	function create()
	{
		$this->load->view('templates/header');
		$this->load->view('masters/kitchen_brands/create');
		$this->load->view('templates/footer');
	}
	function edit($id)
	{
		$where=array(
				'kitchen_brand_id' => $id
		);
		$records=$this->crud_model->get('kitchen_brands',$where);
		if($records != false){
			//true section
			$data['kitchen_brand_name']			 = $records[0]['kitchen_brand_name'];
			$data['kitchen_brand_id']			 = $records[0]['kitchen_brand_id'];
			$this->load->view('templates/header');
			$this->load->view('masters/kitchen_brands/edit',$data);
			$this->load->view('templates/footer');

		}
		else{
			//false section
			$this->session->set_flashdata('response','<div class="alert alert-error">error</div>');
			redirect('masters/kitchen_brands');
		}

	}
	function do_insert()
	{
		$this->form_validation->set_rules('kitchen_brand_name', 'Kitchen Brand Name', 'required|max_length[50]');

		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->load->view('templates/header');
			$this->load->view('masters/kitchen_brands/create');
			$this->load->view('templates/footer');
		}
		else
		{	// true section

			$kitchen_brand_name=$this->input->post('kitchen_brand_name');

			$data=array('kitchen_brand_name' => $kitchen_brand_name

			);

			$rr=$this->crud_model->insert('kitchen_brands',$data);

			if($rr == false){
				// error

				$this->session->set_flashdata('response','<div class="alert alert-error">Brand cannot be inserted</div>',':old:');
				$this->load->view('templates/header');
				$this->load->view('masters/kitchen_brands');
				$this->load->view('templates/footer');
			}
			else
			{
				// redirect
				$this->session->set_flashdata('response','<div class="alert alert-success">Kitchen Brand added successfully</div>');
				redirect('masters/kitchen_brands');

			}
		}

	}

	function do_update()
	{
		$this->form_validation->set_rules('kitchen_brand_name', 'Kitchen Brand Name', 'required|max_length[50]');

		if ($this->form_validation->run() == FALSE)
		{
			// false section
				
			$records=$this->crud_model->get('kitchen_brands');
			if($records != false){
				//true section
				$data['kitchen_brand_name']			 = $records[0]['kitchen_brand_name'];
				$data['kitchen_brand_id']			 = $records[0]['kitchen_brand_id'];
				$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
				$this->load->view('templates/header');
				$this->load->view('masters/kitchen_brands/edit',$data);
				$this->load->view('templates/footer');

			}
			else{
				//false section
				$this->session->set_flashdata('response','<div class="alert alert-error">error</div>');
				redirect('masters/kitchen_brands');
			}
		}
		else
		{// true section

			$kitchen_brand_name =  $this->input->post('kitchen_brand_name');
			$kitchen_brand_id   =  $this->input->post('kitchen_brand_id');

			$where=array(
					      'kitchen_brand_id'  => $kitchen_brand_id
			);
			$data=array(
					      'kitchen_brand_name' =>$kitchen_brand_name

			);

			$records=$this->crud_model->update('kitchen_brands',$data,$where);

			$this->session->set_flashdata('response','<div class="alert alert-success">Kitchen Brand updated</div>');
			redirect('masters/kitchen_brands');

		}

	}
	function do_delete($id=0)
	{

		$where=array(
				'kitchen_brand_id'=> $id
		);

		$this->crud_model->delete('kitchen_brands',$where);

		$this->session->set_flashdata('response','<div class="alert alert-success">Kitchen Brand deleted</div>');
		redirect('masters/kitchen_brands');
	}
}