<?php
class Worktop_Price_Groups extends CI_Controller {
	function Worktop_Price_Groups()
	{
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
	}
	function index($page=1)
	{
		$config['per_page']		= 5;
		$config['base_url'] 	= site_url('masters/worktop_price_groups/index/');
		$config['total_rows'] 	= $this->crud_model->get_count('view_worktop_price_groups_with_finish',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('view_worktop_price_groups_with_finish',
		array(),
		$config['per_page'],
		$offset
		);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();

		$this->load->view('templates/header');
		$this->load->view('masters/worktop_price_groups/list',$data);
		$this->load->view('templates/footer');
	}
	function create()
	{
		$list = $this->crud_model->get_list('worktop_finish_id','worktop_finish_name','worktop_finish',array(0=>' - Select - '));
		$data['worktop_finish'] = $list;

		$this->load->view('templates/header');
		$this->load->view('masters/worktop_price_groups/create',$data);
		$this->load->view('templates/footer');
	}
	function edit($id)
	{
		$where=array(
				       'price_group_id' => $id
		);
		$records=$this->crud_model->get('worktop_price_groups',$where);
		if($records != false){
			//true section
			$data['price_group_name']		 = $records[0]['price_group_name'];
			$data['price_group_id']			 = $records[0]['price_group_id'];
			$data['worktop_finish_id']		 = $records[0]['worktop_finish_id'];

			$list = $this->crud_model->get_list('worktop_finish_id','worktop_finish_name','worktop_finish',array(0=>' - Select - '));
			$data['worktop_finish'] = $list;

			$this->load->view('templates/header');
			$this->load->view('masters/worktop_price_groups/edit',$data);
			$this->load->view('templates/footer');

		}
			
		else{
			//false section
			$this->session->set_flashdata('response','<div class="alert alert-error">error</div>');
			redirect('masters/worktop_price_groups');
		}

	}
	function do_insert()
	{
		$this->form_validation->set_rules('price_group_name', 'Price Group', 'required|max_length[50]');
		$this->form_validation->set_rules('worktop_finish_id', 'Worktop Finish', 'required|is_natural_no_zero');

		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->create();
		}
		else
		{	// true section

			$price_group_name   = $this->input->post('price_group_name');
			$worktop_finish_id  = $this->input->post('worktop_finish_id');
			$data=array(
					           'price_group_name'   => $price_group_name,
					           'worktop_finish_id'  => $worktop_finish_id
			);

			$this->crud_model->insert('worktop_price_groups',$data);

			// redirect
			$this->session->set_flashdata('response','<div class="alert alert-success">Price Group added successfully</div>');
			redirect('masters/worktop_price_groups');
		}

	}

	function do_update()
	{
		$this->form_validation->set_rules('price_group_name', 'Price Group', 'required|max_length[50]');
		$this->form_validation->set_rules('worktop_finish_id', 'Worktop Finish', 'required|is_natural_no_zero');

		if ($this->form_validation->run() == FALSE)
		{
			// false section

			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->edit($this->input->post('price_group_id'));

		}
		else
		{// true section

			$price_group_name  = $this->input->post('price_group_name');
			$price_group_id    = $this->input->post('price_group_id');
			$worktop_finish_id = $this->input->post('worktop_finish_id');

			$where=array(
					      'price_group_id'=> $price_group_id
			);
			$data=array(
					       'price_group_name'   => $price_group_name,
					       'worktop_finish_id'  => $worktop_finish_id
			);

			$records=$this->crud_model->update('worktop_price_groups',$data,$where);

			$this->session->set_flashdata('response','<div class="alert alert-success">Price Group updated</div>');
			redirect('masters/worktop_price_groups');

		}

	}
	function do_delete($id=0)
	{

		$where=array(
				'price_group_id'=> $id
		);

		$this->crud_model->delete('worktop_price_groups',$where);

		$this->session->set_flashdata('response','<div class="alert alert-success">Price Group deleted</div>');
		redirect('masters/worktop_price_groups');
	}
}

