<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Quotations extends CI_Controller {

	public function __construct()
	{
		parent::__construct();// you have missed this line.\
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('Login');
		}
		$this->load->model('Vehicle');
		$this->load->model('users_model');
		$this->load->model('crud_model');
	}
	public function jobcardQuotation($id = ""){
		$this->users_model->permission("Quotation", "View");
		$title['headerTitle'] = "Quotation";
		$quotation         = $this->Vehicle->getQuotationData($id);
		$data['customer']  = $this->Vehicle->getCustomer();
		$data['job_data']  = $this->Vehicle->getVjobcard_detail($quotation->job_card_id);
		$data['quotation'] = $quotation;
		$data['make']      = $this->Vehicle->getMake();	
		$data['model']     = $this->Vehicle->getregisterModel($data['job_data']->make);
		$data['ContactDetails']   = $this->Vehicle->get_ContactDetails_only($data['job_data']->client_id);
		$data['qt_item_dtl']      = $this->Vehicle->getQuotationitemdetail($id);
		$data['qt_data_gp_list']  = $this->Vehicle->getQuotationitemdetailGroup($id);
		$data['grouplist']  = $this->Vehicle->getServiceLineGroup();
		$data['vehicle_discount_limit']  = $this->crud_model->getVehicle_section_DiscountLimit($quotation->job_card_id);
		$date=date("Y-m-d");
		$data['vat_percentage_array']=$this->furniture_quotation_model->vat_applicable2($date);
		$stockArray  = array('itemCode' => '', 'itemID' => '');
		if(!empty($data['qt_item_dtl'])){
			foreach($data['qt_item_dtl'] as $rec){
				if($rec['issue_type'] == 'stock' ){
					$stoack_data = $this->Vehicle->getStockData($rec['item_id']);
					if($stoack_data != false){
						$stockArray['itemCode'] = $stoack_data->item_code;
						$stockArray['itemID']   = $stoack_data->id;
					}
					else{
						$stockArray['itemCode'] = '';
						$stockArray['itemID']   = '';
					}
	
					$data['stockArray'][] = $stockArray;
				}	
				if($rec['furniture_type'] == '1' ){
					$progressStatus = array('progress' => '' , 'job_card_detail' => '');
					$jb_id  = $rec['job_id'];
					$jb_detail_id = $rec['job_detail_id'];
					$checkTechnicianprogress  =  $this->Vehicle->getChecktechniciantable($jb_id,$jb_detail_id);
					if($checkTechnicianprogress != false){  
						$progressStatus['progress'] = $checkTechnicianprogress > 0 ? 'Not-allowded' : 'allowed';
					}
					else{
						$progressStatus['progress']  = 'allowed';
					}
					$progressStatus['job_card_detail'] = $jb_detail_id ;
					//echo $checkTechnicianprogress;
					//echo '<br>';
					$data['progressStatus'][] = $progressStatus;
				}
			}
		}		
		$this->load->view('templates/header',$title);
		$this->load->view('quotations/jobcardQuotation',$data);
		$this->load->view('templates/footer');
	}

	public function Quotation_approve(){		
		$this->users_model->permission("Quotation", "Add");
		$quotation_id = $this->input->post('quotation_id');
		$job_card_id = $this->input->post('job_card_id');
		$this->db->trans_begin();


		if(!empty( $this->input->post('is_approve_service_line')) || !empty( $this->input->post('is_approve_consumabels'))){	
			$where_quotation1 = array(
						'id' => $quotation_id,
						'job_card_id'	 => $job_card_id,
			);
			$quotation_status = array(
				'quotation_status' => 'Confirmed'
			);
			$this->crud_model->update('furniture_quotation',$quotation_status,$where_quotation1);
			$where_jobcard1 = array(
				'job_card_id'	 => $job_card_id,
			);
			$job_status = array(
				'job_status' => '1'
			);
			$this->crud_model->update('job_card_details',$job_status,$where_jobcard1);	
		}
		 



		$where_quotation_items = array(
			'quotation_id' => $quotation_id,
			'job_id'	 => $job_card_id,
			'quotation_status' => 'Approved'
		);
		$fitems_status= array(
			'quotation_status' => 'Quoted'
		);
		$this->crud_model->update('furniture_items',$fitems_status,$where_quotation_items);

		$quotation_total = $quotation_vat_percentage =  $quotation_vat_amount = $quotation_amount_with_vat = $item_discount_total  = 0 ;					
		$cn_quotation_total = $cn_quotation_vat_percentage = $cn_item_discount_total =  $cn_quotation_discount =  $cn_quotation_vat_amount = $cn_quotation_amount_with_vat = 0 ;
		$lb_quotation_total = $lb_item_discount_total = $lb_quotation_vat_percentage =  $lb_quotation_vat_amount = $lb_quotation_amount_with_vat = 0 ;
 		if(!empty( $this->input->post('is_approve_service_line')) ){		    	
		    $checked_serviceitems = array_values($this->input->post('is_approve_service_line'));
 			foreach($checked_serviceitems AS $key => $item){
				$job_detail_id = $item;
				$qt_item_id    = $this->input->post('qt_item_id_'.$item);
				$job_id        = $this->input->post('job_id_'.$item);
				$lb_amount         = $this->input->post('item_amount_'.$item);
				$lb_item_qty         = $this->input->post('item_qty_'.$item);
				$lb_item_disc_perc = $this->input->post('item_disc_perc_'.$item);
				$lb_item_discount  = $this->input->post('item_discount_'.$item);
				$lb_vat_perce      = $this->input->post('vat_perce_'.$item);
				$lb_vat_amount     = $this->input->post('vat_amount_'.$item);	
				$lb_net_amount     = $this->input->post('net_amount_'.$item);	
				$data_value_quotation = array(
					'furniture_unitprice'	 => $lb_amount,
					'furniture_amount'	 => $lb_amount,
					'vat_perce'		 => $lb_vat_perce,
					'vat_amount'     => $lb_vat_amount,
					'item_disc_perc' => $lb_item_disc_perc,
					'item_discount'  => $lb_item_discount,
					'net_amount'     => $lb_net_amount,
					'quotation_status' => 'Approved'
				);
				$data_value_jobcard = array(
					'furniture_amount' => $lb_amount,
					'vat_perce'		 => $lb_vat_perce,
					'vat_amount'     => $lb_vat_amount,
					'item_disc_perc' => $lb_item_disc_perc,
					'item_discount'  => $lb_item_discount,
					'net_amount'     => $lb_net_amount,
					'job_status' => '2'
				);
				$data_technician_status = array(
					'job_technician_status' => '2'
				);
				$where_quotation = array(
					'furniture_id ' => $qt_item_id,
					'job_id'	 => $job_id,
					'job_detail_id' => $job_detail_id
				);
				$this->crud_model->update('furniture_items',$data_value_quotation,$where_quotation);						
				$where_jobcard = array(
									'job_card_details_id' => $job_detail_id,	
									'job_card_id'	 =>	$job_id
								);
				$this->crud_model->update('job_card_details',$data_value_jobcard,$where_jobcard);	
				$where_technician = array(
									'job_detail_id' => $job_detail_id,	
									'job_id'	 =>	$job_id,
									'service_troubleshoot' =>1
 								);
				$this->crud_model->update('job_card_technician',$data_technician_status,$where_technician);
  			}
		}
 		if(!empty($this->input->post('is_approve_consumabels'))){
			$consumabels_items   = array_values($this->input->post('is_approve_consumabels'));	
 			foreach($consumabels_items AS $k => $consumabels){
				$cn_job_detail_id  = $consumabels;
				$cn_qt_item_id     = $this->input->post('cn_qt_item_id_'.$consumabels);
				$cn_job_id         = $this->input->post('cn_job_id_'.$consumabels);
				$cn_amount         = $this->input->post('cn_item_amount_'.$consumabels);
				$cn_item_qty         = $this->input->post('cn_item_qty_'.$consumabels);
				$cn_item_disc_perc = $this->input->post('cn_item_disc_perc_'.$consumabels);
				$cn_item_discount  = $this->input->post('cn_item_discount_'.$consumabels);
				$cn_vat_perce      = $this->input->post('cn_vat_perce_'.$consumabels);
				$cn_vat_amount     = $this->input->post('cn_vat_amount_'.$consumabels);
				$cn_net_amount     = $this->input->post('cn_net_amount_'.$consumabels);			 
				$data_value_quotation = array(
					'furniture_unitprice'	=> $cn_amount,
					'furniture_amount'	 => $cn_amount,
					'vat_perce'		 => $cn_vat_perce,
					'vat_amount'     => $cn_vat_amount,
					'item_disc_perc' => $cn_item_disc_perc,
					'item_discount'  => $cn_item_discount,
					'net_amount'     => $cn_net_amount,
					'quotation_status' => 'Approved'
				);
				$data_value_jobcard = array(
					'furniture_unitprice'	=> $cn_amount,
					'furniture_amount' => $cn_amount,
					'vat_perce'      => $cn_vat_perce,
 					'vat_amount'     => $cn_vat_amount,
					'item_disc_perc' => $cn_item_disc_perc,
					'item_discount'  => $cn_item_discount,
					'net_amount'     => $cn_net_amount,
					'job_status' 	 => '2'
				);	
				$where_quotation = array(
									'furniture_id ' => $cn_qt_item_id,
									'job_id'	 => $cn_job_id,
									'job_detail_id' => $cn_job_detail_id
								);
			    $this->crud_model->update('furniture_items',$data_value_quotation,$where_quotation);						
				$where_jobcard = array(
									'job_card_details_id' => $cn_job_detail_id,	
									'job_card_id'	 =>	$cn_job_id
								);
			    $this->crud_model->update('job_card_details',$data_value_jobcard,$where_jobcard);	
 			}
		}
		if(!empty( $this->input->post('cn_job_detail_id'))){	
			$cn_quotation_total = $cn_quotation_vat_percentage = $cn_item_discount_total =  $cn_quotation_discount =  $cn_quotation_vat_amount = $cn_quotation_amount_with_vat = 0 ;
			$cn_items   = array_values($this->input->post('cn_job_detail_id'));	
 			foreach($cn_items AS $k => $consumabels){
				$cn_job_detail_id  = $consumabels;
 				$cn_qt_item_id     = $this->input->post('cn_qt_item_id_'.$consumabels);
				$cn_job_id         = $this->input->post('cn_job_id_'.$consumabels);
				$cn_amount         = $this->input->post('cn_item_amount_'.$consumabels);
				$cn_item_qty         = $this->input->post('cn_item_qty_'.$consumabels);
				$cn_item_disc_perc = $this->input->post('cn_item_disc_perc_'.$consumabels);
				$cn_item_discount  = $this->input->post('cn_item_discount_'.$consumabels);
				$cn_vat_perce      = $this->input->post('cn_vat_perce_'.$consumabels);
				$cn_vat_amount     = $this->input->post('cn_vat_amount_'.$consumabels);
				$cn_net_amount     = $this->input->post('cn_net_amount_'.$consumabels);	
				$cn_quotation_total = floatval($cn_quotation_total + ($cn_amount * $cn_item_qty));
				$cn_quotation_vat_amount =  $cn_quotation_vat_amount + $cn_vat_amount;
				$cn_quotation_discount   =  $cn_quotation_discount + $cn_item_discount;
				$cn_quotation_amount_with_vat =  $cn_quotation_amount_with_vat + $cn_net_amount;
				$cn_item_discount_total = $cn_item_discount_total + $cn_item_discount;
				if(empty($this->input->post('is_approve_consumabels'))){
					$data_value_quotation = array(
						'furniture_unitprice'=> $cn_amount,
						'furniture_amount'	 => $cn_amount,
						'vat_perce'		 => $cn_vat_perce,
						'vat_amount'     => $cn_vat_amount,
						'item_disc_perc' => $cn_item_disc_perc,
						'item_discount'  => $cn_item_discount,
						'net_amount'     => $cn_net_amount,
 					);
					$where_quotation = array(
										'furniture_id ' => $cn_qt_item_id,
										'job_id'	 => $cn_job_id,
										'job_detail_id' => $cn_job_detail_id
									);
					$this->crud_model->update('furniture_items',$data_value_quotation,$where_quotation);											 	
				}
			}
		}
		if(!empty( $this->input->post('job_detail_id'))){
			$lbitems = array_values($this->input->post('job_detail_id'));
			$lb_quotation_total = $lb_item_discount_total = $lb_quotation_vat_percentage =  $lb_quotation_vat_amount = $lb_quotation_amount_with_vat = 0 ;
 			foreach($lbitems AS $key => $item){
				$job_detail_id = $item;
 				$qt_item_id    = $this->input->post('qt_item_id_'.$item);
				$job_id        = $this->input->post('job_id_'.$item);
				$lb_amount         = $this->input->post('item_amount_'.$item);
				$lb_item_qty         = $this->input->post('item_qty_'.$item);
				$lb_item_disc_perc = $this->input->post('item_disc_perc_'.$item);
				$lb_item_discount  = $this->input->post('item_discount_'.$item);
				$lb_vat_perce      = $this->input->post('vat_perce_'.$item);
				$lb_vat_amount     = $this->input->post('vat_amount_'.$item);	
				$lb_net_amount     = $this->input->post('net_amount_'.$item);	
				$lb_quotation_total = floatval($lb_quotation_total + ($lb_amount * $lb_item_qty));
				$lb_quotation_vat_amount      = $lb_quotation_vat_amount + $lb_vat_amount;
				$lb_quotation_amount_with_vat = $lb_quotation_amount_with_vat + $lb_net_amount;
				$lb_item_discount_total =  $lb_item_discount_total + $lb_item_discount;
				if(empty( $this->input->post('is_approve_service_line'))){	
					$data_value_quotation = array(
						'furniture_unitprice'=> $lb_amount,
						'furniture_amount'	 => $lb_amount,
						'vat_perce'		 => $lb_vat_perce,
						'vat_amount'     => $lb_vat_amount,
						'item_disc_perc' => $lb_item_disc_perc,
						'item_discount'  => $lb_item_discount,
						'net_amount'     => $lb_net_amount,
 					);
					 $where_quotation = array(
						'furniture_id ' => $qt_item_id,
						'job_id'	 => $job_id,
						'job_detail_id' => $job_detail_id
					);
					$this->crud_model->update('furniture_items',$data_value_quotation,$where_quotation);
				}
			}
		}
		$quotation_total      = floatval($cn_quotation_total  + $lb_quotation_total);
		$quotation_vat_amount = floatval($cn_quotation_vat_amount + $lb_quotation_vat_amount);
		$quotation_amount_with_vat = floatval($cn_quotation_amount_with_vat + $lb_quotation_amount_with_vat);
		$item_discount_total       = floatval($cn_item_discount_total + $lb_item_discount_total);
		$where_quotationupdt= array(
			'id' => $quotation_id,
			'job_card_id'	 => $job_card_id,
		);
		$quotation_updt = array(
			'quotation_total' => $quotation_total,
			'quotation_vat_amount' => $quotation_vat_amount,
			'quotation_amount_with_vat' => $quotation_amount_with_vat,
			'quotation_discount' => $item_discount_total
		);
		$this->crud_model->update('furniture_quotation',$quotation_updt,$where_quotationupdt);		 
		if($this->db->trans_status() === FALSE) {
			$message = 'error';
			$this->db->trans_rollback();
			$this->session->set_flashdata('response', 'OOPS!!!...Something WentWrong.Please Try Again.');
			redirect('jobcard/Vehicle_jobcard/editVjobcard/'.$quotation_id.'');			
		} 
		else {	
			$this->db->trans_commit();
			$this->session->set_flashdata('success', 'Quotation Updated And Approved Successfully');
			redirect('quotations/Quotations/jobcardQuotation/'.$quotation_id.'');
 		}
	}

	public function quotationList($type='NIL',$client_id='NIL',$telephone='NIL',$quotation_number='NIL',$project='NIL',$user_id='NIL'){
			$this->users_model->permission("Quotation", "View");
			$title['headerTitle']="Quotation List";
			
			if (@$this->input->post('quotation_number')) {
				$quotation_number =   $this->input->post("quotation_number");
			}elseif ($quotation_number != "NIL") {
				$quotation_number	=	$quotation_number;
			} else {
				$quotation_number	= "NIL";
			}
			if (@$this->input->post('client_id')) {
				$client_id =   $this->input->post("client_id");
			}elseif ($client_id != "NIL") {
				$client_id	=	$client_id;
			} else {
				$client_id	= "NIL";
			}
			if (@$this->input->post('telephone')) {
				$telephone =   $this->input->post("telephone");
			}elseif ($telephone != "NIL") {
				$telephone	=	$telephone;
			} else {
				$telephone	= "NIL";
			}
			if (@$this->input->post('project')) {
				$project =   $this->input->post("project");
			}elseif ($project != "NIL") {
				$project	=	$project;
			} else {
				$project	= "NIL";
			}
			if (@$this->input->post('user_id')) {
				$user_id =   $this->input->post("user_id");
			}elseif ($user_id != "NIL") {
				$user_id	=	$user_id;
			} else {
				$user_id	= "NIL";
			}
	
	
			if (@$this->input->post('type')) {
				$type =   $this->input->post("type");
			}elseif ($type != "NIL") {
				$type	=	$type;
			} else {
				if (@$this->input->post('nbx')) {
					$type	= "NIL";
				} else {
					$type	= "Draft";
				}
			}
	
			$customer_name='NIL';
			
			$config["base_url"] = base_url() . "index.php/furniture/furniture_quotations/quotationList/".$type."/".$client_id."/".$telephone."/".$quotation_number."/".$project."/".$user_id;
			$config['num_links'] = 15;
			if(isset($_POST["ttttt"])) {
				$config["total_rows"] = 10000000;
				$config["per_page"] = 10000000000000;
				$this->pagination->initialize($config);
				$page = 0;
				$i=1;
			} else {
				$config["total_rows"] = 250;
				$config["per_page"] = 250;
				$this->pagination->initialize($config);
				$config['uri_segment'] = 11;
				if ($this->uri->segment(11)) {
					$page = $this->uri->segment(11)*250-250;
					$i=$page+1;
				} else {
					$page = 0;
					$i=1;
				}
			}
			//pagging end
			$list='';
			$headList='';
			$net_amount=0;
			foreach ($this->furniture_quotation_model->qlistData($config["per_page"], $page,$type,$client_id,$telephone,$quotation_number,$project,$user_id) as $row) {
				$qtnmbr=$row->quotation_number_full;
				if($row->quotation_status==='Closed'){ 
					$style='class="alert-danger"';
				} else if($row->quotation_status==='Open'){ 
					$style='class="alert-info"';
					$qtnmbr='<a id="print" class="print" data-bs-toggle="modal" data-bs-target="#qoutePrint" data-quotation_id="'.$row->quotation_id.'">'.$row->quotation_number_full.'</a>';
				} elseif($row->quotation_status==='Draft'){
					$style='class=""';
				}  else if($row->quotation_status==='Confirmed'){ 
					$style='class="alert-success"';
					$qtnmbr='<a id="print" class="print" data-bs-toggle="modal" data-bs-target="#qoutePrint" data-quotation_id="'.$row->quotation_id.'" >'.$row->quotation_number_full.'</a>';
				} else {
					$style='';
				}
				$list.='<tr '.$style.' >
					<td>'.$i++.'</td>
					<td scope="row">'.$qtnmbr.'</td>
					<td>'.date("M d, Y", strtotime($row->quotation_date)).'</td>
					<td>'.$row->client_name.'</td>
					<td>'.$row->project_name.'</td>
					<td>'.$row->user_name.'</td>
					<td>'.number_format($row->quotation_amount_with_vat,3).'</td>
					<td>'.$row->user_type.'</td>
					<td style="width:100px;"><div class="btn-group">
						<button type="button" class="btn btn-primary dropdown-toggle" data-bs-toggle="dropdown">
						Action <span class="caret"></span>
						</button>
						<ul class="dropdown-menu" role="menu">
						<li><a style="color: black;" href="'.site_url('manage_quotation/quotation/'.$row->quotation_id.'/'.$row->quotation_divisionid.'/'.$row->quotation_number).'"><i class="fa fa-gg"></i> Manage Quote</a></li>
						</ul>
					</div></td>
				</tr>';
				//
				if($client_id!="NIL"){
					$customer_name=$row->client_name;
				}									
			}
			$userList=$this->furniture_quotation_model->userList();
			$datas   =   array("data" => $list, "links" => $this->pagination->create_links(),"userList" => $userList,"client_id" => $client_id,"customer_name" => $customer_name,"telephone" => $telephone,"quotation_number" => $quotation_number,"project" => $project,"type" => $type);
		
		$this->load->view('templates/header',$title);
		$this->load->view('furniture/quotations/quotationList',$datas);
		$this->load->view('templates/footer');
	}
	
	public function index($page=1, $print_view=0, $print_quotation_id=0) {
		$this->session->keep_flashdata('success');
		$this->session->keep_flashdata('response');
		redirect('furniture/furniture_quotations/quotationList');
	}

	public function indexxxxdx($page=1, $print_view=0, $print_quotation_id=0) {

		$where = array();
		$where1 = array('view_furniture_quotations_client_project_users.project_status !=' => '1');
		$delivery_where = array('view_furniture_quotations_client_project_users.delivery_date !=' => '0000-00-00','view_furniture_quotations_client_project_users.project_status !=' => '1');
		//$where = array('furniture_quotation.quotation_divisionid' => 11);
		if($this->session->userdata('user_group_id') != 1){
			$where = array('view_furniture_quotations_client_project_users.salesman_id' => $this->session->userdata('user_id'));
		}

		$data12 =$this->crud_model->get_count('view_furniture_quotations_client_project_users',$where,10000000000000000000000000000000000,0,'quotation_id','desc');
		$config['per_page']		= 50;
		$config['base_url'] 	= site_url('furniture/furniture_quotations/index/');
		$config['total_rows'] 	= $data12;
		//$offset = ($page-1) * $config['per_page'];
		if ($this->uri->segment(4)) {
				$page = $this->uri->segment(4)*50-50;
				$offset=$page+1;
			} else {
				$page = 0;
				$offset=1;
			}
		/*$data['records'] = $this->crud_model->get_view_furniture_quotations_client_project_users
                                                                       ($where,$config['per_page'],$offset,'furniture_quotation.last_modified_date','desc');
                */
				$sql=" 1 ";
        if($this->session->userdata('user_group_id') != 1){
			$where = array('view_furniture_quotations_client_project_users.salesman_id' => $this->session->userdata('user_id'));
			$where1 = array('view_furniture_quotations_client_project_users.salesman_id' => $this->session->userdata('user_id'),'view_furniture_quotations_client_project_users.project_status !=' => '1');
			//$delivery_where = array('view_furniture_quotations_client_project_users.salesman_id' => $this->session->userdata('user_id'),'view_furniture_quotations_client_project_users.delivery_date !=' => '0000-00-00','view_furniture_quotations_client_project_users.project_status !=' => '1');
			$user_id=$this->session->userdata('user_id');
			$sql.="AND view_furniture_quotations_client_project_users.salesman_id=$user_id";
		}
		$or_where = array();
		$like = array();
		if($this->session->userdata('is_estimator') == 1){
			$user_id=$this->session->userdata('user_id');
			$sql.=" AND (view_furniture_quotations_client_project_users.estimator_id IS NULL OR view_furniture_quotations_client_project_users.estimator_id=$user_id )";
		}
		if($this->session->userdata('is_approver') == 1){
			$user_id=$this->session->userdata('user_id');
			$sql.=" AND view_furniture_quotations_client_project_users.status='Approver' AND (view_furniture_quotations_client_project_users.approver_id IS NULL OR view_furniture_quotations_client_project_users.approver_id=$user_id )";
		}
		
		$up_data = $this->db->query("SELECT * FROM `view_furniture_quotations_client_project_users` WHERE ".$sql." order by `quotation_id` desc LIMIT ".$page.",".$config['per_page']);
		
		$data['records'] = $up_data->result_array();
               /* $data['records'] = $this->crud_model->get('view_furniture_quotations_client_project_users',
				$where,
				$config['per_page'],
				$page,
				'quotation_id',
				'desc', $like, $or_where);*/
				$data['delivery_records'] = $this->crud_model->get('view_furniture_quotations_client_project_users',
				$delivery_where,
				5,
				0,
				'delivery_date',
				'asc');

		/*To handle previous versions code start*/
		$data['old_quotations']=array();
		if($data['records'] != false) {
			foreach($data['records'] as $record) {
				//var_dump($record);echo "<br/><br/>";
				//$data['old_quotations'][$record['quotation_number']]=array();
				if($record['quotation_revisionnumber'] == 0) {
					continue;
				}
				$where=array('quotation_number'=>$record['quotation_number'],'quotation_divisionid'=>$record['quotation_divisionid']);
				$quotation_data=$this->crud_model->get_view_furniture_quotations_client_project_users($where, null,null, 'furniture_quotation.quotation_revisionnumber', 'asc');
				foreach($quotation_data as $single_quotation) {
					$data['old_quotations'][$record['quotation_number']][$record['quotation_divisionid']][$single_quotation['quotation_revisionnumber']]=$single_quotation['id'];
				}
				//var_dump($data['old_quotations']); echo "<br/><br/>";
				unset($data['old_quotations'][$record['quotation_number']][$record['quotation_divisionid']][$record['quotation_revisionnumber']]);

			}// End of foreach($data['records'] as $record)
			/*To handle previous versions code end*/

		}
		//exit;

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		$data['print_view']=$print_view;
		$data['print_quotation_id']=$print_quotation_id;
		$data=html_escape($data);
		//$list = $this->crud_model->get_list('division_id','division_name','company_division',array('all'=>' - All Divisions - '));
		$list = $this->crud_model->get_list('division_id','division_name','company_division',array());

		//unset($list[QMS_GENERAL_QTN_DIV_ID]);
		//unset($list[QMS_WORKSHOP_QTN_DIV_ID]);

		$data['division_list'] = $list;
		
		$this->load->view('templates/header');
		$this->load->view('furniture/quotations/quotation',$data);
		$this->load->view('templates/footer');
	}

	public function view($quotation_id) {

		$records = $this->furniture_quotation_model->get_full_quotation_details($quotation_id);

		if($records == false) {
				$this->session->set_flashdata('response','<div class="alert alert-error">Please Select a Quotation First..</div>');
				redirect('furniture/furniture_quotations');
		}

		if($records['quotation_status'] == "Draft") {
			$this->session->set_flashdata('response','<div class="alert alert-error">Sorry! Access denied.</div>');
			redirect('furniture/furniture_quotations');
		}

		$data['quotation_number'] = $records['quotation_number'];
		$data['quotation_revision_number'] = $records['quotation_revisionnumber'];
		$data['quotation_date'] = $records['quotation_date'];

		$data['salesman_name'] = $records['salesman_name'];
		$data['salesman_direct_number'] = $records['salesman_direct_number'];
		$data['salesman_contact_number'] = $records['salesman_contact_number'];
		$data['salesman_email_id'] = $records['salesman_email_id'];

		$data['client_name'] = $records['client_name'];
		$data['client_address'] = $records['client_address'];
		$data['client_phone_number1'] = $records['client_telephone1'];
		$data['client_phone_number2'] = $records['client_telephone2'];
		$data['client_fax_number'] = $records['client_fax'];
		$data['client_email_id'] = $records['client_email'];

		$data['covering_letter'] = $records['covering_letter'];
		$data['furniture_items'] = $records['furniture_items'];

		$data['exstock_payment_text'] = $records['exstock_payment_text'];
		$data['exstock_payment_label'] = $records['exstock_payment_label'];
		$data['byorder_payment_label'] = $records['byorder_payment_label'];
		$data['byorder_payment_text'] = $records['byorder_payment_text'];

		$data['currency_code'] = $records['currency_code'];
		$data['currency_name'] = $records['currency_name'];

		$data['advance'] = $this->furniture_quotation_model->get_quotation_advance($quotation_id);

		$data['division_code'] = $records['division_code'];

		$data['logos_url'] = array();
		$logos_id = explode(",",$records['quotation_logos']);
		foreach($logos_id as $key=>$logo_id) {
			$where = array('logo_id' => $logo_id);
			$logo = $this->crud_model->get('logos',$where);
			if($logo[0]['logo_filename']){
				array_push($data['logos_url'], $logo[0]['logo_filename']);
			}
		}

		$data['quotation_discount_amount'] = $records['quotation_discount_amount'];
		$data['advance_amount'] = $records['advance_amount'];
		$data['discount_percentage'] = $records['discount_percentage'];
		$data['quotation_net_total'] = $records['quotation_net_total'];
		$data['quotation_total'] = $records['quotation_total'];

		$data['logos'] = $records['quotation_logos'];

		$this->load->view('furniture/quotations/view',$data);

	}

	public function view_intl($quotation_id) {

		$records = $this->furniture_quotation_model->get_full_quotation_details($quotation_id);

		if($records == false) {
				$this->session->set_flashdata('response','<div class="alert alert-error">Please Select a Quotation First..</div>');
				redirect('furniture/furniture_quotations');
		}

		if($records['quotation_status'] == "Draft") {
			$this->session->set_flashdata('response','<div class="alert alert-error">Sorry! Access denied.</div>');
			redirect('furniture/furniture_quotations');
		}

		$data['quotation_number'] = $records['quotation_number'];
		$data['quotation_revision_number'] = $records['quotation_revisionnumber'];
		$data['quotation_date'] = $records['quotation_date'];

		$data['salesman_name'] = $records['salesman_name'];
		$data['salesman_direct_number'] = $records['salesman_direct_number'];
		$data['salesman_contact_number'] = $records['salesman_contact_number'];
		$data['salesman_email_id'] = $records['salesman_email_id'];

		$data['client_name'] = $records['client_name'];
		$data['client_address'] = $records['client_address'];
		$data['client_phone_number1'] = $records['client_telephone1'];
		$data['client_phone_number2'] = $records['client_telephone2'];
		$data['client_fax_number'] = $records['client_fax'];
		$data['client_email_id'] = $records['client_email'];

		$data['covering_letter'] = $records['covering_letter'];
		$data['furniture_items'] = $records['furniture_items'];

		$data['exstock_payment_text'] = $records['exstock_payment_text'];
		$data['exstock_payment_label'] = $records['exstock_payment_label'];
		$data['byorder_payment_label'] = $records['byorder_payment_label'];
		$data['byorder_payment_text'] = $records['byorder_payment_text'];

		$data['currency_code'] = $records['currency_code'];
		$data['currency_name'] = $records['currency_name'];

		$data['advance'] = $this->furniture_quotation_model->get_quotation_advance($quotation_id);

		$data['division_code'] = $records['division_code'];

		$data['logos_url'] = array();
		$logos_id = explode(",",$records['quotation_logos']);
		foreach($logos_id as $key=>$logo_id) {
			$where = array('logo_id' => $logo_id);
			$logo = $this->crud_model->get('logos',$where);
			if($logo[0]['logo_filename']){
				array_push($data['logos_url'], $logo[0]['logo_filename']);
			}
		}

		$data['quotation_discount_amount'] = $records['quotation_discount_amount'];
		$data['discount_percentage'] = $records['discount_percentage'];
		$data['quotation_net_total'] = $records['quotation_net_total'];
		$data['quotation_total'] = $records['quotation_total'];

		$data['logos'] = $records['quotation_logos'];

		$this->load->view('furniture/quotations/view_intl',$data);

	}


        public function view_ver2($quotation_id) {

		$records = $this->furniture_quotation_model->get_full_quotation_details($quotation_id);

		if($records == false) {
				$this->session->set_flashdata('response','<div class="alert alert-error">Please Select a Quotation First..</div>');
				redirect('furniture/furniture_quotations');
		}

		if($records['quotation_status'] == "Draft") {
			$this->session->set_flashdata('response','<div class="alert alert-error">Sorry! Access denied.</div>');
			redirect('furniture/furniture_quotations');
		}

		$data['quotation_number'] = $records['quotation_number'];
		$data['quotation_revision_number'] = $records['quotation_revisionnumber'];
		$data['quotation_date'] = $records['quotation_date'];

		$data['salesman_name'] = $records['salesman_name'];
		$data['salesman_direct_number'] = $records['salesman_direct_number'];
		$data['salesman_contact_number'] = $records['salesman_contact_number'];
		$data['salesman_email_id'] = $records['salesman_email_id'];

		$data['client_name'] = $records['client_name'];
		$data['client_address'] = $records['client_address'];
		$data['client_phone_number1'] = $records['client_telephone1'];
		$data['client_phone_number2'] = $records['client_telephone2'];
		$data['client_fax_number'] = $records['client_fax'];
		$data['client_email_id'] = $records['client_email'];

		$data['covering_letter'] = $records['covering_letter'];
		$data['furniture_items'] = $records['furniture_items'];

		$data['exstock_payment_text'] = $records['exstock_payment_text'];
		$data['exstock_payment_label'] = $records['exstock_payment_label'];
		$data['byorder_payment_label'] = $records['byorder_payment_label'];
		$data['byorder_payment_text'] = $records['byorder_payment_text'];

		$data['currency_code'] = $records['currency_code'];
		$data['currency_name'] = $records['currency_name'];

		$data['advance'] = $this->furniture_quotation_model->get_quotation_advance($quotation_id);

		$data['division_code'] = $records['division_code'];

		$data['logos_url'] = array();
		$logos_id = explode(",",$records['quotation_logos']);
		foreach($logos_id as $key=>$logo_id) {
			$where = array('logo_id' => $logo_id);
			$logo = $this->crud_model->get('logos',$where);
			if($logo[0]['logo_filename']){
				array_push($data['logos_url'], $logo[0]['logo_filename']);
			}
		}

		$data['quotation_discount_amount'] = $records['quotation_discount_amount'];
		$data['discount_percentage'] = $records['discount_percentage'];
		$data['quotation_net_total'] = $records['quotation_net_total'];
		$data['quotation_total'] = $records['quotation_total'];

		$data['logos'] = $records['quotation_logos'];

		$this->load->view('furniture/quotations/view_ver2',$data);

	}

        public function view_dn($quotation_id) {

		$records = $this->furniture_quotation_model->get_full_quotation_details($quotation_id);

		if($records == false) {
				$this->session->set_flashdata('response','<div class="alert alert-error">Please Select a Quotation First..</div>');
				redirect('furniture/furniture_quotations');
		}

		if($records['quotation_status'] == "Draft") {
			$this->session->set_flashdata('response','<div class="alert alert-error">Sorry! Access denied.</div>');
			redirect('furniture/furniture_quotations');
		}

		$data['quotation_number'] = $records['quotation_number'];
		$data['quotation_revision_number'] = $records['quotation_revisionnumber'];
		$data['quotation_date'] = $records['quotation_date'];

		$data['salesman_name'] = $records['salesman_name'];
		$data['salesman_direct_number'] = $records['salesman_direct_number'];
		$data['salesman_contact_number'] = $records['salesman_contact_number'];
		$data['salesman_email_id'] = $records['salesman_email_id'];

		$data['client_name'] = $records['client_name'];
		$data['client_address'] = $records['client_address'];
		$data['client_phone_number1'] = $records['client_telephone1'];
		$data['client_phone_number2'] = $records['client_telephone2'];
		$data['client_fax_number'] = $records['client_fax'];
		$data['client_email_id'] = $records['client_email'];

		$data['covering_letter'] = $records['covering_letter'];
		$data['furniture_items'] = $records['furniture_items'];

		$data['exstock_payment_text'] = $records['exstock_payment_text'];
		$data['exstock_payment_label'] = $records['exstock_payment_label'];
		$data['byorder_payment_label'] = $records['byorder_payment_label'];
		$data['byorder_payment_text'] = $records['byorder_payment_text'];

		$data['currency_code'] = $records['currency_code'];
		$data['currency_name'] = $records['currency_name'];

		$data['advance'] = $this->furniture_quotation_model->get_quotation_advance($quotation_id);

		$data['division_code'] = $records['division_code'];

		$data['logos_url'] = array();
		$logos_id = explode(",",$records['quotation_logos']);
		foreach($logos_id as $key=>$logo_id) {
			$where = array('logo_id' => $logo_id);
			$logo = $this->crud_model->get('logos',$where);
			if($logo[0]['logo_filename']){
				array_push($data['logos_url'], $logo[0]['logo_filename']);
			}
		}

		$data['quotation_discount_amount'] = $records['quotation_discount_amount'];
		$data['discount_percentage'] = $records['discount_percentage'];
		$data['quotation_net_total'] = $records['quotation_net_total'];
		$data['quotation_total'] = $records['quotation_total'];

		$data['logos'] = $records['quotation_logos'];

		$this->load->view('furniture/quotations/view_dn',$data);

	}


	public function filter_quotation() {

		$this->form_validation->set_rules('filter_division', 'Company Divisions', 'required'); // For set_value()
		$this->form_validation->set_rules('filter_by', 'Filter Category', 'required'); // For set_value()

                if($this->input->post('filter_division') == "all" || $this->session->userdata('user_group_id') != 1) {
			$this->form_validation->set_rules('filter_value', 'Quotation Number/Client Name', 'required');
		}
		if ($this->form_validation->run() == FALSE) {
			// false section
			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			$this->index();
			return;
		}

		$like=null;
		$or_where=null;
		$where=array();
		$delivery_where = array('view_furniture_quotations_client_project_users.delivery_date !=' => '0000-00-00');
if(($this->input->post('filter_division') != 'all') && $this->session->userdata('user_group_id') != 1) {
	//$where ['quotation_divisionid'] = $this->input->post('filter_division');

	$where = array('view_furniture_quotations_client_project_users.salesman_id' => $this->session->userdata('user_id'),'quotation_divisionid'=>$this->input->post('filter_division'));
	$delivery_where = array('view_furniture_quotations_client_project_users.delivery_date !=' => '0000-00-00','quotation_divisionid'=>$this->input->post('filter_division'));

} else {
				$where ['quotation_divisionid'] = $this->input->post('filter_division');
				$delivery_where = array('view_furniture_quotations_client_project_users.delivery_date !=' => '0000-00-00','quotation_divisionid'=>$this->input->post('filter_division'));
	}


		if($this->input->post('filter_by') == 1) {
			$where=array('view_furniture_quotations_client_project_users.quotation_number'=>$this->input->post('filter_value'),'view_furniture_quotations_client_project_users.salesman_id' => $this->session->userdata('user_id'),'quotation_divisionid'=>$this->input->post('filter_division'));
			$delivery_where = array('view_furniture_quotations_client_project_users.delivery_date !=' => '0000-00-00','view_furniture_quotations_client_project_users.quotation_number'=>$this->input->post('filter_value'));
		} elseif($this->input->post('filter_by') == 2) {
			$like=array('view_furniture_quotations_client_project_users.client_name'=> $this->input->post('filter_value'),'view_furniture_quotations_client_project_users.salesman_id' => $this->session->userdata('user_id'),'quotation_divisionid'=>$this->input->post('filter_division'));
		} else {
			$or_where = array('view_furniture_quotations_client_project_users.client_telephone1'=>$this->input->post('filter_value'),
							'view_furniture_quotations_client_project_users.client_telephone2'=>$this->input->post('filter_value'));
		}
		// Handling Empty Text Field.
		if($this->input->post('filter_value') == "") {
			$where=array();
			$or_where=array();
		}

       

		$data['records'] = $this->crud_model->get('view_furniture_quotations_client_project_users',
				$where,
				null,
				null,
				'quotation_id',
				'desc', $like, $or_where);

				
		$data['delivery_records'] = $this->crud_model->get('view_furniture_quotations_client_project_users',
				$delivery_where,
				5,
				0,
				'delivery_date',
				'asc', $like, $or_where);
 

		if($data['records'] == false && $data['delivery_records'] == false) {
			$this->session->set_flashdata('response','<div class="alert alert-error">No matching quotation found</div>',':old:');
			$this->index();
			return;
		}

		if($this->session->userdata('user_group_id') != 1){
			foreach($data['records'] as $index=>$furniture_item) {
				if($furniture_item['quotation_status'] == 'Confirmed') {
					continue;
				} else if ($furniture_item['salesman_id']!= $this->session->userdata('user_id') ){

					unset($data['records'][$index]);
				}
			}

		}

		/*To handle previous versions code start*/
		$data['old_quotations']=array();

		foreach($data['records'] as $record){

			$data['old_quotations'][$record['quotation_number']]=array();

			if($record['quotation_revisionnumber'] == 0) {
				continue;
			}

			$where=array('furniture_quotation.quotation_number'=>$record['quotation_number'],'quotation_divisionid'=>$record['quotation_divisionid']);
			$quotation_data=$this->crud_model->get_view_furniture_quotations_client_project_users($where, null,null, 'furniture_quotation.quotation_revisionnumber', 'asc');

			foreach($quotation_data as $single_quotation) {

				$data['old_quotations'][$record['quotation_number']][$record['quotation_divisionid']][$single_quotation['quotation_revisionnumber']]=$single_quotation['id'];
			}
			unset($data['old_quotations'][$record['quotation_number']][$record['quotation_divisionid']][$record['quotation_revisionnumber']]);

		}// End of foreach($data['records'] as $record)
		/*To handle previous versions code end*/


		$data['pagination'] = '';

		$data['print_view']=0;
		$data['print_quotation_id']=0;
		//$list = $this->crud_model->get_list('division_id','division_name','company_division',array('all'=>' - All Divisions - '));
		$list = $this->crud_model->get_list('division_id','division_name','company_division',array());
		//unset($list[QMS_GENERAL_QTN_DIV_ID]);
		unset($list[QMS_WORKSHOP_QTN_DIV_ID]);
		$data['division_list'] = $list;




		$data=html_escape($data);
		$this->load->view('templates/header');
		$this->load->view('furniture/quotations/quotation',$data);
		$this->load->view('templates/footer');


	}

	public function view_old_version($quotation_id){
		$records = $this->furniture_quotation_model->get_full_quotation_details($quotation_id, 'multiple');
		$data['furniture_itemlist'] = $this->crud_model->get('furniture_items', array('furniture_items.quotation_id'=>$quotation_id), null, null, "ex_furniture_area", "ASC", null, null, null, "furniture_area");
		if($records == false) {
				$this->session->set_flashdata('response','<div class="alert alert-error">Please Select a Quotation First..</div>');
				redirect('furniture/furniture_quotations');
		}

		if($records['quotation_status'] == "Draft") {
			$this->session->set_flashdata('response','<div class="alert alert-error">Sorry! Access denied.</div>');
			redirect('furniture/furniture_quotations');
		}		
		
		$data['quotation_number'] = $records['quotation_number'];
		$data['quotation_revision_number'] = $records['quotation_revisionnumber'];
		$data['quotation_date'] = $records['quotation_date'];
		$data['quotation_number_full']		= $records['division_code']."-".$records['quotation_number'] . "-". $records['quotation_revisionnumber'];
		$data['salesman_name'] = $records['salesman_name'];
		
		$data['client_name'] = $records['client_name'];
		$data['client_address'] = $records['client_address'];
		$data['client_telephone1'] = $records['client_telephone1'];
		$data['client_telephone2'] = $records['client_telephone2'];
		$data['client_fax'] = $records['client_fax'];
		$data['client_email'] = $records['client_email'];
		
		$data['covering_letter'] = $records['covering_letter'];
		$data['furniture_items'] = $records['furniture_items'];
		
		$data['exstock_payment_text'] = $records['exstock_payment_text'];
		$data['exstock_payment_label'] = $records['exstock_payment_label'];
		$data['byorder_payment_label'] = $records['byorder_payment_label'];
		$data['byorder_payment_text'] = $records['byorder_payment_text'];
		$data['terms_and_conditions'] = $records['terms_and_conditions'];
		$data['project_remarks'] = $records['project_remarks'];
		
		$data['currency_code'] = $records['currency_code'];
		$data['currency_name'] = $records['currency_name'];
		$data['contact_person'] = $records['contact_person'];
		$data['division_id'] = $records['division_id'];
                $data['quotation_logos'] = $records['quotation_logos'];
		
		$data['advance'] = $this->furniture_quotation_model->get_quotation_advance($quotation_id);
		
		$data['division_code'] = $records['division_code'];

		$data['logos_url'] = array();
		$logos_id = explode(",",$records['quotation_logos']);
		foreach($logos_id as $key=>$logo_id) {
			$where = array('logo_id' => $logo_id);
			$logo = $this->crud_model->get('logos',$where); 
			if($logo[0]['logo_filename']){
				array_push($data['logos_url'], "images/logos/".$logo[0]['logo_filename']);
			}
		}
		
		$data['quotation_discount_amount'] = $records['quotation_discount_amount'];
		$data['discount_percentage'] = $records['discount_percentage'];
		$data['quotation_net_total'] = $records['quotation_net_total'];
		$data['quotation_total'] = $records['quotation_total'];
		$data['advance_amount'] = $records['advance_amount'];
		$data['logos'] = $records['quotation_logos'];
		
		//$this->load->view('furniture/quotations/view',$data);
		$data['image']	=	"without_image";
		$data['print_type'] = "normal_print_type";
		$data['chekval'] = 0;
		$data['without_sub'] = 0;
		$data['without_group'] = 0;
		
		$query = $this->db->get('company_details');  
		$data['company_details'] = $query->row();
		
		$this->load->view('general/quotations/printnormal',$data);
	}
	public function upcoming_deliveries($type="", $page=1, $print_view=0, $print_quotation_id=0) {
	
		$five_date = date('Y-m-d', strtotime("+4 days"));

		$where = array();
		if($type==1){
		    $delivery_where = array('view_furniture_quotations_client_project_users.delivery_date <=' => $five_date,'view_furniture_quotations_client_project_users.delivery_date >=' => date('Y-m-d'),'view_furniture_quotations_client_project_users.delivery_date !=' => '0000-00-00','view_furniture_quotations_client_project_users.project_status !=' => '1');
		}else if($type==2){
			$delivery_where = array('view_furniture_quotations_client_project_users.delivery_date >' => $five_date,'view_furniture_quotations_client_project_users.delivery_date >=' => date('Y-m-d'),'view_furniture_quotations_client_project_users.delivery_date !=' => '0000-00-00','view_furniture_quotations_client_project_users.project_status !=' => '1');
		}else if($type==3){
			$delivery_where = array('view_furniture_quotations_client_project_users.delivery_date <' => date('Y-m-d'),'view_furniture_quotations_client_project_users.delivery_date !=' => '0000-00-00','view_furniture_quotations_client_project_users.project_status !=' => '1');
		}else{
			$delivery_where = array('view_furniture_quotations_client_project_users.delivery_date !=' => '0000-00-00','view_furniture_quotations_client_project_users.project_status !=' => '1');
		}
		//$where = array('furniture_quotation.quotation_divisionid' => 11);
		if($this->session->userdata('user_group_id') != 1){
			$where = array('furniture_quotation.salesman_id' => $this->session->userdata('user_id'));
		}

		$config['per_page']		= 50;
		$config['base_url'] 	= site_url('furniture/furniture_quotations/index/');
		$config['total_rows'] 	= $this->crud_model->get_view_furniture_quotations_client_project_users_count($where);
		$offset = ($page-1) * $config['per_page'];

		/*$data['records'] = $this->crud_model->get_view_furniture_quotations_client_project_users
                                                                       ($where,$config['per_page'],$offset,'furniture_quotation.last_modified_date','desc');
                */
                if($this->session->userdata('user_group_id') != 1){
			$where = array('view_furniture_quotations_client_project_users.salesman_id' => $this->session->userdata('user_id'));
			/*if($type==1){
		    $delivery_where = array('view_furniture_quotations_client_project_users.salesman_id' => $this->session->userdata('user_id'),'view_furniture_quotations_client_project_users.delivery_date <=' => $five_date,'view_furniture_quotations_client_project_users.delivery_date >=' => date('Y-m-d'),'view_furniture_quotations_client_project_users.delivery_date !=' => '0000-00-00','view_furniture_quotations_client_project_users.project_status !=' => '1');
		}else if($type==2){
			$delivery_where = array('view_furniture_quotations_client_project_users.salesman_id' => $this->session->userdata('user_id'),'view_furniture_quotations_client_project_users.delivery_date >' => $five_date,'view_furniture_quotations_client_project_users.delivery_date >=' => date('Y-m-d'),'view_furniture_quotations_client_project_users.delivery_date !=' => '0000-00-00','view_furniture_quotations_client_project_users.project_status !=' => '1');
		}else if($type==3){
			$delivery_where = array('view_furniture_quotations_client_project_users.salesman_id' => $this->session->userdata('user_id'),'view_furniture_quotations_client_project_users.delivery_date <' => date('Y-m-d'),'view_furniture_quotations_client_project_users.delivery_date !=' => '0000-00-00','view_furniture_quotations_client_project_users.project_status !=' => '1');
		}else{
			$delivery_where = array('view_furniture_quotations_client_project_users.salesman_id' => $this->session->userdata('user_id'),'view_furniture_quotations_client_project_users.delivery_date !=' => '0000-00-00','view_furniture_quotations_client_project_users.project_status !=' => '1');
		}*/
		}
			
				$data['delivery_records'] = $this->crud_model->get('view_furniture_quotations_client_project_users',
				$delivery_where,
				null,
				null,
				'delivery_date',
				'asc');

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		$data['print_view']=$print_view;
		$data['print_quotation_id']=$print_quotation_id;
		$data=html_escape($data);
		//$list = $this->crud_model->get_list('division_id','division_name','company_division',array('all'=>' - All Divisions - '));
		$list = $this->crud_model->get_list('division_id','division_name','company_division',array());

		//unset($list[QMS_GENERAL_QTN_DIV_ID]);
		//unset($list[QMS_WORKSHOP_QTN_DIV_ID]);

		$data['division_list'] = $list;
		
		$this->load->view('templates/header');
		$this->load->view('furniture/quotations/upcoming_deliveries',$data);
		$this->load->view('templates/footer');
	}
	public function search_upcoming_deliveries($page=1, $print_view=0, $print_quotation_id=0) {
	
		$five_date = date('Y-m-d', strtotime("+4 days"));

		$where = array();
		$like = array();
		if($this->input->post('filter_division') != 'all'){
		$delivery_where = array('view_furniture_quotations_client_project_users.delivery_date !=' => '0000-00-00','view_furniture_quotations_client_project_users.project_status !=' => '1','view_furniture_quotations_client_project_users.quotation_divisionid' => $this->input->post('filter_division'));
		}
		if($this->input->post('filter_by') == 1 && $this->input->post('filter_value')!="") {
		$delivery_where = array('view_furniture_quotations_client_project_users.delivery_date !=' => '0000-00-00','view_furniture_quotations_client_project_users.project_status !=' => '1','view_furniture_quotations_client_project_users.quotation_number' => $this->input->post('filter_value'),'view_furniture_quotations_client_project_users.quotation_divisionid' => $this->input->post('filter_division'));
		}
		if($this->input->post('filter_by') == 2 && $this->input->post('filter_value')!="") {
		$delivery_where = array('view_furniture_quotations_client_project_users.delivery_date !=' => '0000-00-00','view_furniture_quotations_client_project_users.project_status !=' => '1','view_furniture_quotations_client_project_users.quotation_divisionid' => $this->input->post('filter_division'));
		$like=array('view_furniture_quotations_client_project_users.client_name'=> $this->input->post('filter_value'));
		}
		//$where = array('furniture_quotation.quotation_divisionid' => 11);
		if($this->session->userdata('user_group_id') != 1){
			$where = array('furniture_quotation.salesman_id' => $this->session->userdata('user_id'));
		}

		$config['per_page']		= 50;
		$config['base_url'] 	= site_url('furniture/furniture_quotations/index/');
		$config['total_rows'] 	= $this->crud_model->get_view_furniture_quotations_client_project_users_count($where);
		$offset = ($page-1) * $config['per_page'];

		/*$data['records'] = $this->crud_model->get_view_furniture_quotations_client_project_users
                                                                       ($where,$config['per_page'],$offset,'furniture_quotation.last_modified_date','desc');
                */
                if($this->session->userdata('user_group_id') != 1){
			$where = array('view_furniture_quotations_client_project_users.salesman_id' => $this->session->userdata('user_id'));
			/*if($this->input->post('filter_division') != 'all'){
			$delivery_where = array('view_furniture_quotations_client_project_users.salesman_id' => $this->session->userdata('user_id'),'view_furniture_quotations_client_project_users.delivery_date !=' => '0000-00-00','view_furniture_quotations_client_project_users.project_status !=' => '1','view_furniture_quotations_client_project_users.quotation_divisionid' => $this->input->post('filter_division'));
			}
			if($this->input->post('filter_by') == 1 && $this->input->post('filter_value')!="") {
		$delivery_where = array('view_furniture_quotations_client_project_users.salesman_id' => $this->session->userdata('user_id'),'view_furniture_quotations_client_project_users.delivery_date !=' => '0000-00-00','view_furniture_quotations_client_project_users.project_status !=' => '1','view_furniture_quotations_client_project_users.quotation_number' => $this->input->post('filter_value'),'view_furniture_quotations_client_project_users.quotation_divisionid' => $this->input->post('filter_division'));
		}
		if($this->input->post('filter_by') == 2 && $this->input->post('filter_value')!="") {
		$delivery_where = array('view_furniture_quotations_client_project_users.salesman_id' => $this->session->userdata('user_id'),'view_furniture_quotations_client_project_users.delivery_date !=' => '0000-00-00','view_furniture_quotations_client_project_users.project_status !=' => '1','view_furniture_quotations_client_project_users.quotation_divisionid' => $this->input->post('filter_division'));
		$like=array('view_furniture_quotations_client_project_users.client_name'=> $this->input->post('filter_value'));
		}*/
		}
			
				$data['delivery_records'] = $this->crud_model->get('view_furniture_quotations_client_project_users',
				$delivery_where,
				null,
				null,
				'delivery_date',
				'asc',$like);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		$data['print_view']=$print_view;
		$data['print_quotation_id']=$print_quotation_id;
		$data=html_escape($data);
		//$list = $this->crud_model->get_list('division_id','division_name','company_division',array('all'=>' - All Divisions - '));
		$list = $this->crud_model->get_list('division_id','division_name','company_division',array());

		//unset($list[QMS_GENERAL_QTN_DIV_ID]);
		//unset($list[QMS_WORKSHOP_QTN_DIV_ID]);

		$data['division_list'] = $list;
		
		$this->load->view('templates/header');
		$this->load->view('furniture/quotations/upcoming_deliveries',$data);
		$this->load->view('templates/footer');
	}
	public function latest_quotations($type="", $page=1, $print_view=0, $print_quotation_id=0) {
		
		$where = array();
		
		if($type==1){
		    $where1 = array('view_furniture_quotations_client_project_users.project_status !=' => '1','view_furniture_quotations_client_project_users.quotation_status' => 'Confirmed');
		}else if($type==2){
			$where1 = array('view_furniture_quotations_client_project_users.project_status !=' => '1','view_furniture_quotations_client_project_users.quotation_status' => 'Closed');
		}else if($type==3){
			$where1 = array('view_furniture_quotations_client_project_users.project_status !=' => '1','view_furniture_quotations_client_project_users.quotation_status' => 'Open');
		}else{
			$where1 = array('view_furniture_quotations_client_project_users.project_status !=' => '1','view_furniture_quotations_client_project_users.quotation_status' => 'Draft');
		}
		//$where = array('furniture_quotation.quotation_divisionid' => 11);
		if($this->session->userdata('user_group_id') != 1){
			$where = array('furniture_quotation.salesman_id' => $this->session->userdata('user_id'));
		}

		$config['per_page']		= 2000;
		$config['base_url'] 	= site_url('furniture/furniture_quotations/index/');
		$config['total_rows'] 	= $this->crud_model->get_view_furniture_quotations_client_project_users_count($where);
		$offset = ($page-1) * $config['per_page'];

		/*$data['records'] = $this->crud_model->get_view_furniture_quotations_client_project_users
                                                                       ($where,$config['per_page'],$offset,'furniture_quotation.last_modified_date','desc');
                */
                if($this->session->userdata('user_group_id') != 1){
			if($type==1){
		    $where1 = array('view_furniture_quotations_client_project_users.salesman_id' => $this->session->userdata('user_id'),'view_furniture_quotations_client_project_users.project_status !=' => '1','view_furniture_quotations_client_project_users.quotation_status' => 'Confirmed');
		}else if($type==2){
			$where1 = array('view_furniture_quotations_client_project_users.salesman_id' => $this->session->userdata('user_id'),'view_furniture_quotations_client_project_users.project_status !=' => '1','view_furniture_quotations_client_project_users.quotation_status' => 'Closed');
		}else if($type==3){
			$where1 = array('view_furniture_quotations_client_project_users.salesman_id' => $this->session->userdata('user_id'),'view_furniture_quotations_client_project_users.project_status !=' => '1','view_furniture_quotations_client_project_users.quotation_status' => 'Open');
		}else{
			$where1 = array('view_furniture_quotations_client_project_users.salesman_id' => $this->session->userdata('user_id'),'view_furniture_quotations_client_project_users.project_status !=' => '1','view_furniture_quotations_client_project_users.quotation_status' => 'Draft');
		}
		}
			
				$data['records'] = $this->crud_model->get('view_furniture_quotations_client_project_users',
				$where1,
				$config['per_page'],
				$offset,
				'quotation_id',
				'desc');
				
				/*To handle previous versions code start*/
		$data['old_quotations']=array();
		if($data['records'] != false) {
			foreach($data['records'] as $record) {
				//var_dump($record);echo "<br/><br/>";
				//$data['old_quotations'][$record['quotation_number']]=array();
				if($record['quotation_revisionnumber'] == 0) {
					continue;
				}
				$where=array('quotation_number'=>$record['quotation_number'],'quotation_divisionid'=>$record['quotation_divisionid']);
				$quotation_data=$this->crud_model->get_view_furniture_quotations_client_project_users($where, null,null, 'furniture_quotation.quotation_revisionnumber', 'asc');
				foreach($quotation_data as $single_quotation) {
					$data['old_quotations'][$record['quotation_number']][$record['quotation_divisionid']][$single_quotation['quotation_revisionnumber']]=$single_quotation['id'];
				}
				//var_dump($data['old_quotations']); echo "<br/><br/>";
				unset($data['old_quotations'][$record['quotation_number']][$record['quotation_divisionid']][$record['quotation_revisionnumber']]);

			}// End of foreach($data['records'] as $record)
			/*To handle previous versions code end*/

		}
		//exit;

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		$data['print_view']=$print_view;
		$data['print_quotation_id']=$print_quotation_id;
		$data=html_escape($data);
		//$list = $this->crud_model->get_list('division_id','division_name','company_division',array('all'=>' - All Divisions - '));
		$list = $this->crud_model->get_list('division_id','division_name','company_division',array());

		//unset($list[QMS_GENERAL_QTN_DIV_ID]);
		//unset($list[QMS_WORKSHOP_QTN_DIV_ID]);

		$data['division_list'] = $list;
		$data['type'] = $type;
		
		$this->load->view('templates/header');
		$this->load->view('furniture/quotations/latest_quotations',$data);
		$this->load->view('templates/footer');
	}
	
	public function pirnt_quotations($type="", $page=1, $print_view=0, $print_quotation_id=0) {
		
		$where = array();
		
		if($type==1){
		    $where1 = array('view_furniture_quotations_client_project_users.project_status !=' => '1','view_furniture_quotations_client_project_users.quotation_status' => 'Confirmed');
		}else if($type==2){
			$where1 = array('view_furniture_quotations_client_project_users.project_status !=' => '1','view_furniture_quotations_client_project_users.quotation_status' => 'Closed');
		}else if($type==3){
			$where1 = array('view_furniture_quotations_client_project_users.project_status !=' => '1','view_furniture_quotations_client_project_users.quotation_status' => 'Open');
		}else{
			$where1 = array('view_furniture_quotations_client_project_users.project_status !=' => '1','view_furniture_quotations_client_project_users.quotation_status' => 'Draft');
		}
		//$where = array('furniture_quotation.quotation_divisionid' => 11);
		if($this->session->userdata('user_group_id') != 1){
			$where = array('furniture_quotation.salesman_id' => $this->session->userdata('user_id'));
		}

		$config['per_page']		= 2000;
		$config['base_url'] 	= site_url('furniture/furniture_quotations/index/');
		$config['total_rows'] 	= $this->crud_model->get_view_furniture_quotations_client_project_users_count($where);
		$offset = ($page-1) * $config['per_page'];

		/*$data['records'] = $this->crud_model->get_view_furniture_quotations_client_project_users
                                                                       ($where,$config['per_page'],$offset,'furniture_quotation.last_modified_date','desc');
                */
                if($this->session->userdata('user_group_id') != 1){
			if($type==1){
		    $where1 = array('view_furniture_quotations_client_project_users.salesman_id' => $this->session->userdata('user_id'),'view_furniture_quotations_client_project_users.project_status !=' => '1','view_furniture_quotations_client_project_users.quotation_status' => 'Confirmed');
		}else if($type==2){
			$where1 = array('view_furniture_quotations_client_project_users.salesman_id' => $this->session->userdata('user_id'),'view_furniture_quotations_client_project_users.project_status !=' => '1','view_furniture_quotations_client_project_users.quotation_status' => 'Closed');
		}else if($type==3){
			$where1 = array('view_furniture_quotations_client_project_users.salesman_id' => $this->session->userdata('user_id'),'view_furniture_quotations_client_project_users.project_status !=' => '1','view_furniture_quotations_client_project_users.quotation_status' => 'Open');
		}else{
			$where1 = array('view_furniture_quotations_client_project_users.salesman_id' => $this->session->userdata('user_id'),'view_furniture_quotations_client_project_users.project_status !=' => '1','view_furniture_quotations_client_project_users.quotation_status' => 'Draft');
		}
		}
			
				$data['records'] = $this->crud_model->get('view_furniture_quotations_client_project_users',
				$where1,
				$config['per_page'],
				$offset,
				'quotation_id',
				'desc');
				
				/*To handle previous versions code start*/
		$data['old_quotations']=array();
		if($data['records'] != false) {
			foreach($data['records'] as $record) {
				//var_dump($record);echo "<br/><br/>";
				//$data['old_quotations'][$record['quotation_number']]=array();
				if($record['quotation_revisionnumber'] == 0) {
					continue;
				}
				$where=array('quotation_number'=>$record['quotation_number'],'quotation_divisionid'=>$record['quotation_divisionid']);
				$quotation_data=$this->crud_model->get_view_furniture_quotations_client_project_users($where, null,null, 'furniture_quotation.quotation_revisionnumber', 'asc');
				foreach($quotation_data as $single_quotation) {
					$data['old_quotations'][$record['quotation_number']][$record['quotation_divisionid']][$single_quotation['quotation_revisionnumber']]=$single_quotation['id'];
				}
				//var_dump($data['old_quotations']); echo "<br/><br/>";
				unset($data['old_quotations'][$record['quotation_number']][$record['quotation_divisionid']][$record['quotation_revisionnumber']]);

			}// End of foreach($data['records'] as $record)
			/*To handle previous versions code end*/

		}
		//exit;

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		$data['print_view']=$print_view;
		$data['print_quotation_id']=$print_quotation_id;
		$data=html_escape($data);
		//$list = $this->crud_model->get_list('division_id','division_name','company_division',array('all'=>' - All Divisions - '));
		$list = $this->crud_model->get_list('division_id','division_name','company_division',array());

		//unset($list[QMS_GENERAL_QTN_DIV_ID]);
		//unset($list[QMS_WORKSHOP_QTN_DIV_ID]);

		$data['division_list'] = $list;
		$data['type'] = $type;
		$data['print_view'] = $print_view;
		
		//$this->load->view('templates/header');
		$this->load->view('reports/pirnt_quotations',$data);
		//$this->load->view('templates/footer');
	}
	
	public function completed_projects($page=1, $print_view=0, $print_quotation_id=0) {
		
		$where = array();
		
		$where1 = array('view_furniture_quotations_client_project_users.project_status' => '1');
		//$where = array('furniture_quotation.quotation_divisionid' => 11);
		if($this->session->userdata('user_group_id') != 1){
			$where = array('furniture_quotation.salesman_id' => $this->session->userdata('user_id'));
		}

		$config['per_page']		= 50;
		$config['base_url'] 	= site_url('furniture/furniture_quotations/index/');
		$config['total_rows'] 	= $this->crud_model->get_view_furniture_quotations_client_project_users_count($where);
		$offset = ($page-1) * $config['per_page'];

		/*$data['records'] = $this->crud_model->get_view_furniture_quotations_client_project_users
                                                                       ($where,$config['per_page'],$offset,'furniture_quotation.last_modified_date','desc');
                */
        if($this->session->userdata('user_group_id') != 1){
		    $where1 = array('view_furniture_quotations_client_project_users.salesman_id' => $this->session->userdata('user_id'),'view_furniture_quotations_client_project_users.project_status' => '1');
		}
			
				$data['records'] = $this->crud_model->get('view_furniture_quotations_client_project_users',
				$where1,
				$config['per_page'],
				$offset,
				'quotation_id',
				'desc');
				
				/*To handle previous versions code start*/
		$data['old_quotations']=array();
		if($data['records'] != false) {
			foreach($data['records'] as $record) {
				//var_dump($record);echo "<br/><br/>";
				//$data['old_quotations'][$record['quotation_number']]=array();
				if($record['quotation_revisionnumber'] == 0) {
					continue;
				}
				$where=array('quotation_number'=>$record['quotation_number'],'quotation_divisionid'=>$record['quotation_divisionid']);
				$quotation_data=$this->crud_model->get_view_furniture_quotations_client_project_users($where, null,null, 'furniture_quotation.quotation_revisionnumber', 'asc');
				foreach($quotation_data as $single_quotation) {
					$data['old_quotations'][$record['quotation_number']][$record['quotation_divisionid']][$single_quotation['quotation_revisionnumber']]=$single_quotation['id'];
				}
				//var_dump($data['old_quotations']); echo "<br/><br/>";
				unset($data['old_quotations'][$record['quotation_number']][$record['quotation_divisionid']][$record['quotation_revisionnumber']]);

			}// End of foreach($data['records'] as $record)
			/*To handle previous versions code end*/

		}
		//exit;

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		$data['print_view']=$print_view;
		$data['print_quotation_id']=$print_quotation_id;
		$data=html_escape($data);
		//$list = $this->crud_model->get_list('division_id','division_name','company_division',array('all'=>' - All Divisions - '));
		$list = $this->crud_model->get_list('division_id','division_name','company_division',array());

		//unset($list[QMS_GENERAL_QTN_DIV_ID]);
		//unset($list[QMS_WORKSHOP_QTN_DIV_ID]);

		$data['division_list'] = $list;
		
		$this->load->view('templates/header');
		$this->load->view('furniture/quotations/completed_projects',$data);
		$this->load->view('templates/footer');
	}

	public function enquiry($page=1){
		$config['per_page']		= 5;
		$config['base_url'] 	= site_url('furniture/furniture_quotations/enquiry/');
		$config['total_rows'] 	= $this->crud_model->get_count('enquiry',array());

		$offset = ($page-1) * $config['per_page'];

		$data['records'] = $this->crud_model->get('enquiry',
		array(),
		$config['per_page'],
		$offset
		);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		$this->load->view('templates/header');
		$this->load->view('furniture/quotations/newenquiry',$data);
		$this->load->view('templates/footer');
	}

	public function editenquiry($id,$type=NULl){
		//$this->form_validation->set_rules('division_id', 'Division', 'required|max_length[50]');
		if($type==='head') {
			$this->form_validation->set_rules('prospect_name', 'Prospect Name', 'required');
		}

		if($type==='details') {
			$this->form_validation->set_rules('appointment_date', 'Appointment Date', 'required');
			$this->form_validation->set_rules('meeting_type_id', 'Meeting Type', 'required');
			//$this->form_validation->set_rules('outcome_id', 'Outcome', 'required');
		}
		//$this->form_validation->set_rules('prospect_name', 'Prospect Name', 'required');

		$where=array(
			'id' => $id
	);
	$records=$this->crud_model->get('enquiry',$where); 
	if($records != false){
		if ($this->form_validation->run() == FALSE)
		{
			$data['id']			 = $records[0]['id'];
			$data['enquiry_number']			 = $records[0]['enquiry_number'];
			$data['enquiry_date']			 = $records[0]['enquiry_date'];
			$data['division_id']			 = $records[0]['division_id'];
			$data['client_id']			 = $records[0]['client_id'];
			$data['prospect_name']			 = $records[0]['prospect_name'];
			$data['contact_person']			 = $records[0]['contact_person'];
			$data['phone']			 = $records[0]['phone'];
			$data['email']			 = $records[0]['email'];
			$data['salesman_id']			 = $records[0]['salesman_id'];
			//$data['requirement']			 = $records[0]['requirement'];
			//$data['requirement']			 = $records[0]['requirement'];
			$data['requirement']			 = $records[0]['requirement'];
			$data['enquiry_details']=$this->crud_model->get('enquiry_details',array('enquiry_id'=>$id,'status'=>1), null,null,null,null,null, null);

			$list = $this->crud_model->get_list('division_id','division_name','company_division',array(''=>' - Select Division- '));
			$data['division_list'] = $list;
			$list2 = $this->crud_model->get_list('user_id','user_name','users',array(''=>'Sales Person Assigned'),array('is_salesman'=>1));
			$data['salesman_list'] = $list2;
			$list3 = $this->crud_model->get_list('meeting_type_name','meeting_type_name','meeting_type',array(''=>'---Select---'),array('status'=>1));
			$data['meeting_type_list'] = $list3;
			$list4 = $this->crud_model->get_list('outcome_name','outcome_name','outcome',array(''=>'---Select---'),array('status'=>1));
			$data['outcome_list'] = $list4;
			$this->load->view('templates/header');
			$this->load->view('furniture/quotations/edit_enquiry',$data);
			$this->load->view('templates/footer');
		} else {

			if($type==='head') {
				$data=array(
						'prospect_name'   =>  $this->input->post('prospect_name'),
						'phone'  =>  $this->input->post('phone'),
						'email'   =>  $this->input->post('email'),
						'contact_person'   =>  $this->input->post('contact_person'),
						'requirement'  =>  $this->input->post('requirement'),
						'salesman_id'  =>  $this->input->post('salesman_id')

				);
				$where = array('id' => $id);
				$this->crud_model->update('enquiry',$data,$where);
			}

			if($type==='details') {
				$data=array(
						'enquiry_id'   =>  $id,
						'appointment_date'  =>  date("Y-m-d", strtotime($this->input->post('appointment_date'))),
						'meeting_type'   =>  $this->input->post('meeting_type_id'),
						'outcome'   =>  $this->input->post('outcome_id'),
						'notes'  =>  $this->input->post('notes'),
						'Created_User_id'  =>  $this->session->userdata('user_id'),
						'created_date'  => date('Y-m-d')
				);
				$this->crud_model->insert('enquiry_details',$data);
			}

			$this->session->set_flashdata('response','Enquiry updated');
			redirect('furniture/furniture_quotations/enquiry');
		}
	}
	}

	public function createenquiry(){
		$this->form_validation->set_rules('division_id', 'Division', 'required|max_length[50]');
		$this->form_validation->set_rules('prospect_name', 'Prospect Name', 'required');
		//$this->form_validation->set_rules('prospect_name', 'Prospect Name', 'required');

		if ($this->form_validation->run() == FALSE)
		{
			$list = $this->crud_model->get_list('division_id','division_name','company_division',array(''=>' - Select Division- '));
			$data['division_list'] = $list;
			$list2 = $this->crud_model->get_list('user_id','user_name','users',array(''=>'Sales Person Assigned'),array('is_salesman'=>1));
			$data['salesman_list'] = $list2;
			$this->load->view('templates/header');
			$this->load->view('furniture/quotations/create_enquiry',$data);
			$this->load->view('templates/footer');
		} else {
			$enquiry_no=$this->getNo($this->input->post('division_id'));
			$data=array(
					'enquiry_number'  =>  $enquiry_no,
					'enquiry_date'  =>  date('Y-m-d'),
					'division_id'  =>  $this->input->post('division_id'),
					'client_id'   =>  $this->input->post('client_id'),
					'prospect_name'   =>  $this->input->post('prospect_name'),
					'phone'  =>  $this->input->post('phone'),
					'email'   =>  $this->input->post('email'),
					'contact_person'   =>  $this->input->post('contact_person'),
					'requirement'  =>  $this->input->post('requirement'),
					'salesman_id'  =>  $this->input->post('salesman_id'),
					'Created_User_id'  =>  $this->session->userdata('user_id'),
					'created_date'  => date('Y-m-d'),
					'status'   =>  1

			);


			$records=$this->crud_model->insert('enquiry',$data);

			$this->session->set_flashdata('response','Enquiry updated');
			redirect('furniture/furniture_quotations/enquiry');
		}
	}

	public function getNo($division_id){  
		$query= $this->db->query("SELECT max(id) as enquiry_no FROM `enquiry` WHERE division_id='$division_id' ");
		$no=$query->row()->enquiry_no+1;
		if($division_id!=0){
			$query2= $this->db->query("SELECT * FROM  `company_division` WHERE division_id='$division_id'");
			$division_code=$query2->row()->division_code;
		} else {
			$division_code='';
		}
		$data='ENQ'.sprintf("%'.05d",$no).$division_code;
	    return $data;
		
	}
		
	public function getEnquiryNo(){  
		$division_id =$this->input->post('division_id');
		$query= $this->db->query("SELECT max(id) as enquiry_no FROM `enquiry` WHERE division_id='$division_id' ");
		$no=$query->row()->enquiry_no+1;
		if($division_id!=0){
			$query2= $this->db->query("SELECT * FROM  `company_division` WHERE division_id='$division_id'");
			$division_code=$query2->row()->division_code;
		} else {
			$division_code='';
		}
		$j='ENQ'.sprintf("%'.05d",$no).$division_code;
		$data   =   json_encode(array('2',$j));
	    echo $data;
		
	}

	public function search_client() {
		$client	=	$this->input->post('client');
	 $today	=	date("Y-m-d");
	 $html	='';
	 $sql="";
	 $clients = explode(" ", trim($client));
	 for($i=0;$i<count($clients);$i++) {
		 $r	= $clients[$i];
		 $sql.=" and client_name LIKE '%$r%' ";
	 }
	 $client_contact_data = $this->db->query("SELECT * FROM `new_client_master` where `client_name` like '$client%'  union (SELECT * FROM `new_client_master` where  `client_id` not in (SELECT `client_id` FROM `new_client_master` where  `client_name` like '$client%' ) ".$sql." order by client_name) ");
	 $n=1;
	 if(count($client_contact_data->result_array())>0){
		 $html ='';
		 foreach ($client_contact_data->result_array() as $client_contact_datas){
			  $html.='<li value="' .$client_contact_datas['client_id'].'" class="client_button" tabindex="'.$n++.'" ><input type="hidden" class="client_name" value="'.$client_contact_datas['client_name'].'" /><input type="hidden" class="client_address" value="'.$client_contact_datas['client_address'].'" /><input type="hidden" class="client_telephone1" value="'.$client_contact_datas['client_telephone1'].'" /><input type="hidden" class="client_email" value="'.$client_contact_datas['client_email'].'" />'.$client_contact_datas['client_name'].'</li>';
		 }
	 } else {
		 $html.='<li style="color:red;" class="no_result_button" > No Results Found </li>';
	 }
	 
	 print $html;
 }
}

?>