<?php
class Quotation_client_project extends CI_Controller {
	function  Quotation_client_project()
	{
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
	}
	function index()
	{

		$this->load->view('templates/header');
		$this->load->view('quotations/quotation_client_project/create');
		$this->load->view('templates/footer');
	}
	function edit($quotation_id)
	{
		$where=array(
				'quotation_id'    => $quotation_id
		);
		$data['quotation_id']= $quotation_id;
		
		$rs=$this->crud_model->get('quotations',$where);
		
		if($rs!=false)
		{
			$data['client_id']   = $rs[0]['client_id'];
			$data['project_id']  = $rs[0]['project_id'];
				
		}
		$where= array(
				'client_id'  => $rs[0]['client_id']
		);
		$where_project=array(
				'project_id' => $rs[0]['project_id']
		);
		$rs=$this->crud_model->get('client_master',$where);
		
		
		if($rs!=false)
		{
			$data['client_id']              = $rs[0]['client_id'];
			$data['client_name']            = $rs[0]['client_name'];
			$data['client_address']         = $rs[0]['client_address'];
			$data['client_area']            = $rs[0]['client_area'];
			$data['client_phone_number1']    = $rs[0]['client_phone_number1'];
			$data['client_phone_number2']   = $rs[0]['client_phone_number2'];
			$data['client_fax_number']      = $rs[0]['client_fax_number'];
			$data['client_email_id']        = $rs[0]['client_email_id'];
		}
		
		$rs=$this->crud_model->get('project_master',$where_project);
		if($rs!=false)
		{
			$data['project_id']        = $rs[0]['project_id'];
			$data['project_name']      = $rs[0]['project_name'];
			$data['project_location']  = $rs[0]['project_location'];
			$data['project_more_details']  = $rs[0]['project_more_details'];
		}
		$this->load->view('templates/header');
		$this->load->view('quotations/quotation_client_project/create',$data);
		$this->load->view('templates/footer');
	}
	function do_insert()
	{
		$quotation_id = $this->input->post('quotation_id');
		
		$this->form_validation->set_rules('client_name', 'Client Name', 'required');
		$this->form_validation->set_rules('client_address', 'Client Address', 'required');
		$this->form_validation->set_rules('client_area', 'Client Area', 'required');
		$this->form_validation->set_rules('client_phone_number1', 'Client Telephone 1', 'required|max_length[15]|numeric');
		$this->form_validation->set_rules('client_phone_number2', 'Client Telephone 2', 'max_length[15]|numeric');
		$this->form_validation->set_rules('client_fax_number', 'Client Fax', 'numeric');
		$this->form_validation->set_rules('project_name', 'Project Name', 'required');
		$this->form_validation->set_rules('project_location', 'Project Location', 'required');
		$this->form_validation->set_rules('project_more_details', 'Project More Details', 'required');

		if ($this->form_validation->run() == FALSE)
		{
			// false section
			$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
			
		}
		else
		{	// true section
								
			$data_client=array(

					'client_name'                 => $this->input->post('client_name'),
					'client_address'              => $this->input->post('client_address'),
					'client_area'                 => $this->input->post('client_area'),
					'client_phone_number1'        => $this->input->post('client_phone_number1'),
					'client_phone_number2'        => $this->input->post('client_phone_number2'),
					'client_fax_number'           => $this->input->post('client_fax_number'),
					'client_email_id'             => $this->input->post('client_email_id')
			);
			$data_project=array(
						
						
					'project_name'                    => $this->input->post('project_name'),
					'project_location'                => $this->input->post('project_location'),
					'project_more_details'            => $this->input->post('project_more_details')
						
			);
			$where_client = array(
					'client_id'    => $this->input->post('client_id')
			);
			$where_project= array(
					'project_id'    => $this->input->post('project_id')
			);
				
			if($this->input->post('quotation_id')=='')
			{
					
				$rr=$this->crud_model->insert('client_master',$data_client);
				$client_id=$this->db->insert_id();

				$this->session->set_userdata('client_id',$client_id);
				$rr_pro=$this->crud_model->insert('project_master',$data_project);
				$project_id=$this->db->insert_id();

				$this->session->set_userdata('project_id',$project_id);
				if($rr == false )
				{
					// error
						
					$this->session->set_flashdata('response','<div class="alert alert-error">Client & Project  cannot be inserted</div>',':old:');
					$this->load->view('templates/header');
					$this->load->view('quotations/quotation_client_project');
					$this->load->view('templates/footer');
				}
				else
				{
					// redirect
					$this->session->set_flashdata('response','<div class="alert alert-success">Client & Project Details added successfully</div>');
					redirect('quotations/quotation_client_project');
						
				}
					
			}
			else 
			{
				
				$rr=$this->crud_model->update('client_master',$data_client,$where_client);
				$rr_pro=$this->crud_model->update('project_master',$data_project,$where_project);
				$this->session->set_flashdata('response','<div class="alert alert-success">Client & Project Details updated successfully</div>');
				redirect('quotations/quotation_client_project/edit/'.$quotation_id);
				
			}
				
		}
	}
		function do_update()
		{
			$this->form_validation->set_rules('client_name', 'Client Name', 'required');
			$this->form_validation->set_rules('client_address', 'Client Address', 'required');
			$this->form_validation->set_rules('client_area', 'Client Area', 'required');
			$this->form_validation->set_rules('client_phone_number1', 'Client Telephone 1', 'required|max_length[15]|numeric');
			$this->form_validation->set_rules('client_phone_number2', 'Client Telephone 2', 'required|max_length[15]|numeric');
			$this->form_validation->set_rules('client_fax_number', 'Client Fax', 'numeric');
			$this->form_validation->set_rules('project_name', 'Project Name', 'required');
			$this->form_validation->set_rules('project_location', 'Project Location', 'required');
			$this->form_validation->set_rules('project_more_details', 'Project More Details', 'required');
			if ($this->form_validation->run() == FALSE)
			{
				// false section
				$this->session->set_flashdata('response','<div class="alert alert-error">'.validation_errors().'</div>',':old:');
				$this->index();
			}
			else
			{	// true section

				$where = array(
						'client_id'    => $this->input->post('client_id')
				);
				$data_client=array(

						'client_name'                 => $this->input->post('client_name'),
						'client_address'              => $this->input->post('client_address'),
						'client_area'                 => $this->input->post('client_area'),
						'client_phone_number1'        => $this->input->post('client_phone_number1'),
						'client_phone_number2'        => $this->input->post('client_phone_number2'),
						'client_fax_number'           => $this->input->post('client_fax_number'),
						'client_email_id'             => $this->input->post('client_email_id')
				);
				$rr=$this->crud_model->update('client_master',$data_client,$where);


				$data_project=array(


						'project_name'                    => $this->input->post('project_name'),
						'project_location'                => $this->input->post('project_location'),
						'project_more_details'            => $this->input->post('project_more_details')

				);
				$where= array(
						'project_id'    => $this->input->post('project_id')
				);
				$rr_pro=$this->crud_model->update('project_master',$data_project,$where);



				// redirect
				$this->session->set_flashdata('response','<div class="alert alert-success">Client & Project Details updated successfully</div>');
				redirect('quotations/quotation_client_project');

			}

		}
		/* function edit($quotation_id)
		 {

		$where=array(
				'quotation_id'    => $quotation_id
		);
		$data['quotation_id']= $quotation_id;

		$rs=$this->crud_model->get('quotations',$where);
			
		if($rs!=false)
		{
		$client_id   = $rs[0]['client_id'];
		$project_id  = $rs[0]['project_id'];

		}
		$where= array(
				'client_id'  => $client_id
		);

		$rs=$this->crud_model->get('client_master',$where);

			
		if($rs!=false)
		{
		$data['client_id']              = $rs[0]['client_id'];
		$data['client_name']            = $rs[0]['client_name'];
		$data['client_address']         = $rs[0]['client_address'];
		$data['client_area']            = $rs[0]['client_area'];
		$data['client_phone_number1']    = $rs[0]['client_phone_number1'];
		$data['client_phone_number2']   = $rs[0]['client_phone_number2'];
		$data['client_fax_number']      = $rs[0]['client_fax_number'];
		$data['client_email_id']        = $rs[0]['client_email_id'];
		}
		$where=array(
				'project_id' => $project_id
		);
		$rs=$this->crud_model->get('project_master',$where);
		if($rs!=false)
		{
		$data['project_id']        = $rs[0]['project_id'];
		$data['project_name']      = $rs[0]['project_name'];
		$data['project_location']  = $rs[0]['project_location'];
		$data['project_more_details']  = $rs[0]['project_more_details'];
		}
		$this->load->view('templates/header');
		$this->load->view('quotations/quotation_client_project/edit',$data);
		$this->load->view('templates/footer');
			
		} */
	}
