<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Technician_search extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_logged_in') != true)
		{
			$this->session->set_flashdata('response','<div class="alert alert-error">Unauthorised access. Login required.</div>');
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->library('pagination');
		$this->load->model('furniture_quotation_model');
		$this->load->model('Technician_model');
	}	

	public function new_technician_job() {
		$test=$this->Technician_model->new_technician_job_list();
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Job No</th>
						<th>Job Date</th>
						<th>Reg No.</th>
						<th>Vehicle</th>
						<th>Action</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				$checkbegin = $this->Technician_model->geJobBegin($myAction['job_id'], $myAction['technician_id']);
				if(!empty($checkbegin)){
					//$bg_red = ($checkbegin->task_flag == 1 ? 'bg-begin-danger' : '');
					$bg_color = ($checkbegin->end_time == '' ? 'alert-success' : '' );
				}  else {
					$bg_color ='';
					$bg_red ='';
				}
				$list.='<tr class="'.$bg_color.'">
					<td>'.$myAction['job_card_number'].'</td>
					<td>'.date("M d, Y", strtotime($myAction['job_card_date'])).'</td>
					<td>'.$myAction['reg_no'].'</td>
					<td>'.$myAction['v_make'].'-'.$myAction['v_model'].'</td>
					<td><a href="'.base_url().'index.php/technician/Technician/view_jobs/'.$myAction['job_id'].'/'.$myAction['technician_id'].'" >Select</a></td>';
				$list.='</tr>';
			}
		} else {
			$list.='<tr>
				<td  style="color: red;">No records available</td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
			</tr>';
		}
		echo json_encode($list);
	}
	public function in_progress_technician_job() {
		$test=$this->Technician_model->in_progress_technician_job_list();
		$user_id 	 = $this->session->userdata('user_id');
		$list=	'<thead class="thead-light">
					<tr>
						<th>Job No</th>
						<th>Job Date</th>
						<th>Reg No.</th>
						<th>Vehicle</th>
						<th>Action</th>
					</tr>
				</thead>';
		if($test!=false){
			$count=0;
			foreach($test as $myAction){ 
				$count++;
				$checkbegin = $this->Technician_model->geJobBegin($myAction['job_id'], $myAction['technician_id']);
				if(!empty($checkbegin)){
					$bg_color = ($checkbegin->end_time == '' ? 'alert-success' : '' );
				}  else {
					$bg_color ='';
				}
				$list.='<tr class="'.$bg_color.'">
					<td>'.$myAction['job_card_number'].'</td>
					<td>'.date("M d, Y", strtotime($myAction['job_card_date'])).'</td>
					<td>'.$myAction['reg_no'].'</td>
					<td>'.$myAction['v_make'].'-'.$myAction['v_model'].'</td>
					<td><a href="'.base_url().'index.php/technician/Technician/view_jobs/'.$myAction['job_id'].'/'.$myAction['technician_id'].'" >Select</a></td>';
				$list.='</tr>';
			}
		} else {
			$list.='<tr>
				<td  style="color: red;">No records available</td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
			</tr>';
		}
		echo json_encode($list);
	}
	public function search_job_technician() {
		$reg_no = $this->input->post('reg_no');
		if($reg_no!=''){
			$result=$this->Technician_model->search_job_technician($reg_no);
			if($result!=false){
				$list='<table cellpadding="0" cellspacing="0" class="table table-bordered" width="100%">
												<thead class="thead-light">
													<tr>
														<th>Particulars</th>
														<th>AWS</th>
														<th>MIN</th>
														<th>Ageing</th>
														<th>Action</th>
													</tr>
												</thead>
												<tbody>'; 
				$i=1;

				foreach ($result as $key => $row) {
					$beginBtnClass = '';
					$beginBtnClass2 = '';
					$completeBtnClass='hide';
					$showClass='';
					$completedTrClass='';
					$job_detail_id=$row['job_detail_id'];
					$not_begin_job=0;
					$query=$this->db->query("SELECT * FROM `technician_wise_log` WHERE `job_detail_id` = $job_detail_id and job_status='begin' order by `log_id` DESC limit 1 ");
					if($query->num_rows()>0){
						$result=$query->row();
						$end_time=$result->end_time;
						$job_flag=$result->job_flag;
						if(!empty($end_time) OR $job_flag==1){
							$not_begin_job=1;
						}
					}
					$dates=$this->db->query("SELECT min(`job_date`) as min,max(`job_date`) as max FROM `technician_wise_log` WHERE `job_detail_id` = $job_detail_id")->result();
					$fromDate=$dates[0]->min;
					$toDate=$dates[0]->max;
					if(!empty($fromDate) && !empty($toDate)){
						$starttimestamp = strtotime($fromDate);
						$endtimestamp   = strtotime($toDate);
						$datediff 		= abs($endtimestamp - $starttimestamp);
						$linewiseaging  = round($datediff / (60 * 60 * 24));
					} else {
						$linewiseaging = 0;
					}
					if($not_begin_job!=1){
						$beginBtnClass    = ($row['progress_status'] == 20 ? 'hide ' : '');	
						$completeBtnClass = ($row['progress_status'] == 20 ? 'show' : 'hide');
						$showClass  	  = ($row['progress_status'] == 20 ? 'alert-warning' : '');
					}
					$beginBtnClass2 = ($row['job_technician_status'] == 3 ? 'hide ' : '');
					$completedTrClass  = ($row['job_technician_status'] == 3 ? 'alert-success' : '');
					$list.='<tr class="'.$showClass .' '.$completedTrClass.'" id="jobseleted_'.$row['job_detail_id'].'">';
					$list.='<td>'.$i++.'. '.$row['furniture_description'].' <b></td>';
					$list.='<td>'.$row['aws'].'  </td>';
					$list.='<td> '.$row['min'].'</td>';
					$list.='<td>'.($linewiseaging > 0 ? $linewiseaging : '').'</td>';
					$list.='<td>';
					//$list.='<a style="margin-right:20px;" class=" btn-primary btn btn-sm  "     role="button" data-bs-toggle="collapse" data-parent="#accordion" href="#collapse" aria-expanded="false" aria-controls="collapse">View Task </a>';
					$list.='<a class=" btn-warning btn btn-sm select-job text-white '.$beginBtnClass.' '.$beginBtnClass2.'" role="button" id="select-job_'.$row['job_detail_id'].'" data-job-detail-id="'.$row['job_detail_id'].'" data-job-no="'.$row['job_card_number'].'"   data-job-id="'.$row['job_card_id'].'" data-technician_id="'.$row['technician_id'].'" >Begin</a>';
					$list.='<a class=" btn-success btn btn-sm completed-job text-white '.$completeBtnClass.'"  role="button" id="completed-job_'.$row['job_detail_id'].'" data-job-detail-id="'.$row['job_detail_id'].'" data-job-no="'.$row['job_card_number'].'"   data-job-id="'.$row['job_card_id'].'" data-technician_id="'.$row['technician_id'].'" >Complete</a>';
					$list.='</td>';
					$list.='</tr>';
				}
				$list.='</tbody></table>';
				echo json_encode($list);
			} else{
				echo json_encode('No records found');
			}
		} else {
			echo json_encode('Search field cannot be empty');
		}
	}
}
?>