<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Payroll_report extends CI_Controller {

	public function __construct()
	{
		parent::__construct();// you have missed this line.\
		if(!$this->session->userdata('user_logged_in'))
		{
			$this->session->set_flashdata('response','Unauthorised access. Login required.');
			redirect('Login');
		}
		$this->load->model('EnquiryModel');
		$this->load->model('Hr_model');
	}

	public function report(){
		$this->users_model->permission("Payroll_Report","View");
		$title['headerTitle']="Payroll Report";
		$data['payheads'] = $this->crud_model->get('pay_head');
		$get_payroll_reports = $this->Hr_model->get_payroll_report();
		$payroll_reports = [];
		if ($get_payroll_reports != false) {
			foreach ($get_payroll_reports as $value) {
				$employeeId = $value['employee_id'];
				$payHeadId = $value['pay_head_id'];
				$payroll_reports[$employeeId]['employee_name'] = $value['employee_name'];
				$payroll_reports[$employeeId][$payHeadId] = $value['amount'];
				$payroll_reports[$employeeId]['processed_no'] = $value['processed_no'];
			}
		}
		$data['payroll_reports'] = $payroll_reports;
		if($this->input->post('year')!='') {
			$data['selectedyear'] = $this->input->post('year');
		} else {
			$data['selectedyear'] = date('Y');
		}
		if($this->input->post('month')!='') {
			$data['selectedmonth'] = $this->input->post('month');
		} else {
			$data['selectedmonth'] = date('m');
		}
		$this->load->view('templates/header',$title);
		$this->load->view('transactions/reports/payroll_report',$data);
		$this->load->view('templates/footer');
	}
	public function payslip($employee_id,$processed_no){
		$this->users_model->permission("Payroll_Report","View");
		$title['headerTitle']="Payslip";
		$mpdf = new \Mpdf\Mpdf([
			'default_font_size' => 10,
		]);
		$filename = "payslip.pdf";
		$employee=$this->Hr_model->get_employee(array('employee_id'=>$employee_id));
		if($employee==false){
			$this->session->set_flashdata('response','Employee not found');
			redirect('Dashboard/home');
		}
		$data['earnings']=$this->Hr_model->get_emp_earnings(array('employee_id'=>$employee_id,'processed_no'=>$processed_no));
		if($data['earnings']==false){
			$this->session->set_flashdata('response','Select valid payslip');
			redirect('Dashboard/home');
		}
		$data['deductions']=$this->Hr_model->get_emp_deductions(array('employee_id'=>$employee_id,'processed_no'=>$processed_no));
		$data['employee']=$employee;
		if(isset($data['earnings'])){
			$month=$data['earnings'][0]['processing_month'];
			$year=$data['earnings'][0]['processing_year'];
			$data['ot_data']=$this->Hr_model->get_emp_ot(array('employee_id'=>$employee_id,'month(attendance_date)'=>$month,'year(attendance_date)'=>$year));
		} else {
			$data['ot_data']=false;
		}
		$header = $this->load->view('transactions/reports/payslip_header',$data, true);
		$mpdf->SetHTMLHeader($header);
		$mpdf->AddPage('P','','','','',15,5,42,20,10,0);
		$html = $this->load->view('transactions/reports/payslip',$data, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output($filename, 'I');
	}
	
}

?>