<?php

class Furniture_Quotation_Model extends CI_Model {

	public function __construct() {
	
		// Call the Model constructor
		parent::__construct();
	}
	
	
	function get_full_quotation_details($quotation_id, $revisions) {
	
		$data['quotation_id']  = $quotation_id;
		
		$where=array('furniture_quotation.id' => $quotation_id);
		
		
		if($revisions == 'unique'){
			$records=$this->crud_model->get_view_furniture_quotations_client_project_users($where);
		}
		else{
			$records=$this->crud_model->get_view_furniture_quotations_client_project_users($where);
		}
		if($records!=false) {
			$data['quotation_number']			=$records[0]['quotation_number'];
			$data['quotation_revisionnumber']	= $records[0]['quotation_revisionnumber'];
			$data['quotation_number_full']		= $records[0]['division_code']."-".$records[0]['quotation_number'] . "-". $records[0]['quotation_revisionnumber'];
			
			$data['quotation_date']				= $records[0]['quotation_date'];
			$data['quotation_confirmationdate']	= $records[0]['quotation_confirmationdate'];
			
			$data['quotation_status']			=$records[0]['quotation_status'];
			$data['reason_forclose']			=$records[0]['reason_forclose'];
			$data['quotation_cprid']			=$records[0]['quotation_cprid'];
			$data['lpono']						=$records[0]['lpono'];
						
			$data['last_modified_by']			= $records[0]['last_modified_by'];
			$data['last_modified_date']			= $records[0]['last_modified_date'];
			
			$data['division_id']				= $records[0]['quotation_divisionid'];
			$data['division_code']				= $records[0]['division_code'];
			$data['division_name']				= $records[0]['division_name'];
			
			$data['currency_code']				= $records[0]['currency_code'];
			$data['currency_name']				= $records[0]['currency_name'];
			$data['logo_filename']				= $records[0]['logo_filename'];
			
			$data['salesman_name']				= $records[0]['user_name'];
			$data['salesman_email_id']			= $records[0]['user_email_id'];
			$data['salesman_contact_number']	= $records[0]['user_contact_number'];
			$data['salesman_direct_number']		= $records[0]['user_direct_number'];
			
			$data['client_id']					= $records[0]['client_id'];
			$data['client_name']				= $records[0]['client_name'];
			$data['client_address']				= $records[0]['client_address'];
			$data['client_country']				= $records[0]['client_country'];
			$data['client_telephone1']			= $records[0]['client_telephone1'];
			$data['client_telephone2']			= $records[0]['client_telephone2'];
			$data['client_email']				= $records[0]['client_email'];
			$data['client_fax']				    = $records[0]['client_fax'];
			$data['contact_person']				= $records[0]['contact_person'];
			$data['tax_name']	            	= $records[0]['tax_name'];
			$data['tax_no']	        			= $records[0]['tax_no'];
			$data['tax_perce']	        		= $records[0]['tax_perce'];
			$data['approver_id']	            = $records[0]['approver_id'];
			$data['estimator_id']	            = $records[0]['estimator_id'];
			$data['quotation_type']	            = $records[0]['quotation_type'];
			$data['status']	        			= $records[0]['status'];
			
			$data['project_name']				= $records[0]['project_name'];
			$data['project_location']			= $records[0]['project_location'];
			$data['project_remarks']			= $records[0]['project_remarks'];
			$data["project_contact_person_email"] = $records[0]["project_contact_person_email"];
			$data["project_contact_person_number"] = $records[0]["project_contact_person_number"];	
			
			$data['quotation_total']			= round($records[0]['quotation_total'], 3);
			$data['quotation_discount_amount']      = $records[0]['quotation_discount_qt'] != 0 ? $records[0]['quotation_discount_qt'] : $records[0]['quotation_discount'];
			//$data['quotation_discount_amount']      = $records[0]['quotation_discount'];
			$data['quotation_vat_amount']      = $records[0]['quotation_vat_amount'];
			$data['quotation_vat_percentage']      = $records[0]['quotation_vat_percentage'];
			$data['quotation_amount_with_vat']      = $records[0]['quotation_amount_with_vat'];
			$data['common_comments'] = $records[0]['common_comments'];
			$data['contact_id'] = $records[0]['contact_id'];
			$data['Contact_Name'] = $records[0]['Contact_Name'];
			$data['Contact_Tel'] = $records[0]['Contact_Tel'];
                        if($data['quotation_discount_amount']!=0 && $data['quotation_total']!= 0){
                           $data['discount_percentage']	= round(($data['quotation_discount_amount'] * 100) / $data['quotation_total'],8);
                        } else
                        {
                          $data['discount_percentage'] = 0;
                        }

			//$data['quotation_discount_amount'] 	= round($data['quotation_total'] * ($data['discount_percentage'] / 100),3);
			$data['quotation_net_total']		= round($data['quotation_total'] - $data['quotation_discount_amount'],3);
			$data['quotation_discount']			= $records[0]['quotation_discount'];
			$data['advance_percentage']			= $records[0]['advance_percentage'];
			$data['advance_amount']				= $records[0]['advance_amount'];

			$data['covering_letter']			= $records[0]['covering_letter'];
			
			$data['terms_and_conditions']			= $records[0]['terms_and_conditions'];
			
			$data['advance_required']			= $this->get_quotation_advance($quotation_id);
			
			$data['exstock_paymenttermid'] 	= $records[0]['exstock_paymenttermid'];
			$data['byorder_paymenttermid'] 	= $records[0]['byorder_paymenttermid'];
			$data['exstock_payment_label'] 	= $records[0]['payment_label'];
			$data['byorder_payment_label'] 	= $records[0]['payment_label'];
			$data['exstock_payment_text'] 	= $records[0]['payment_text'];
			$data['byorder_payment_text'] 	= $records[0]['payment_text'];
			
			$data['quotation_logos']		= $records[0]['quotation_logos'];
			$data['quotation_footer']		= $records[0]['quotation_footer'];
			$data['invoice_date']		    = $this->get_invoice_date($quotation_id);						
			$frs = $this->crud_model->get_view_furniture_items_with_brand(array('furniture_items.quotation_id'=> $records[0]['id']),null,null,"furniture_items.furniture_area, furniture_brands.brand_name, furniture_items.furniture_brand_other, furniture_items.furniture_id","ASC");			
			if($frs  != false) {
				$data['furniture_items']=$frs;
			
			} else {
				$data['furniture_items']=array();
			}
			return $data;
				
		} else {
			return false;
		}
		
		
		
	}// End of get_full_quotation_details
	
	
	
	//new
	function get_full_invoice_details($invoice_id = 0, $revisions= 'unique') {
	
		$data['invoice_id']  = $invoice_id;
		
		$where=array('furniture_invoice.invoice_id' => $invoice_id);
		
		if($revisions == 'unique'){
			$records=$this->crud_model->invoice($where);
		}
		else{
			$records=$this->crud_model->invoice($where);
		}
		
		$division=$this->crud_model->get("furniture_invoice",$where);
		
		if($records!=false) {
		
			$data['invoice_number']			    = $records[0]['invoice_number'];
			$data['division_code']			    = $records[0]['division_code'];
			$data['currency_code']			    = $records[0]['currency_code'];
			$data['currency_name']				= $records[0]['currency_name'];
			$data['logo_filename']				= $records[0]['logo_filename'];
			$data['invoice_date']	            = $records[0]['invoice_date'];
			$data['quotation_id']		        = $records[0]['quotation_id'];
			$data['invoice_amount']				= $records[0]['invoice_amount'];
			$data['client_name']	            = $records[0]['client_name'];
			$data['salesman_name']				= $records[0]['user_name'];
			$data['salesman_email_id']			= $records[0]['user_email_id'];
			$data['client_email']	            = $records[0]['client_email'];
			$data['client_address']	            = $records[0]['client_address'];
			$data['client_telephone1']	        = $records[0]['client_telephone1'];
			$data['client_telephone2']	        = $records[0]['client_telephone2'];
			$data['invoice_status']			    = $records[0]['invoice_status'];
			$data['quotation_number']			= $records[0]['quotation_number'];
			$data['invoice_percentage']			= $records[0]['invoice_percentage'];
			$data['invoice_percentage_amount']	= $records[0]['invoice_percentage_amount'];
			$data['invoice_discount']			= $records[0]['invoice_discount'];
			$data['quotation_number_full']		= $records[0]['quotation_number_full'];
			$data['quotation_vat_percentage']	= $records[0]['quotation_vat_percentage'];
			$data['qoute_discount']				= $records[0]['qoute_discount'];
			$data['quotation_logos']			= $records[0]['quotation_logos'];
			$data['lpono']						= $records[0]['lpono'];
			$data['lpono']						= $records[0]['po_no'];
			$data['job_card_id']				= $records[0]['job_card_id'];
			$data['quotation_revisionnumber']	= $records[0]['quotation_revisionnumber'];
			$data['division_id']				= $records[0]['quotation_divisionid'];
			$data['invoice_division_id']		= $division[0]['quotation_divisionid'];
			$data['project_name']				= $records[0]['project_name'];
			$data['invoice_vat_amount']		= $division[0]['invoice_vat_amount'];
			$data['tax_name']	            = $records[0]['tax_name'];
			$data['tax_no']	        = $records[0]['tax_no'];
             
			$frs = $this->crud_model->get_view_invoice_items_with_brand(array('furniture_invoice_details.invoice_id'=> $records[0]['invoice_id']),null,null,"group_id","ASC",null,null,"group_name");
			
			if($frs  != false) {
				$data['invoice_items']=$frs;
			
			} else {
				$data['invoice_items']=array();
			}
			return $data;
				
		} else {
			return false;
		}
		
		
		
	}
	//new end




	function set_quotation_id($division){
	
		$furniture_quotation_number = $this->get_new_quotation_number($division);
		$data=array(
				'quotation_date' =>date('Y-m-d h:m:s'),
				'salesman_id'    =>$this->session->userdata('user_id'),
				'quotation_number' => $furniture_quotation_number
		);
		$furniture_quotation_id = $this->crud_model->insert('furniture_quotation',$data);
		$this->session->set_userdata('furniture_quotation_id',$furniture_quotation_id);
	}



	function get_new_quotation_number($division){
		$SQL = "SELECT MAX(quotation_number)+1 as `new_quotation_number` FROM furniture_quotation WHERE `quotation_divisionid`='$division';";
		$result = $this->db->query($SQL);
		$data = $result->result_array();
		
		if($data[0]['new_quotation_number'] != NULL and $data[0]['new_quotation_number'] != ""){
			return $data[0]['new_quotation_number'];
		} else{
			return 10001;
		}
	}

	function get_new_bom_number(){
		$SQL = "SELECT MAX(bom_h_id)+1 as `new_bom_number` FROM bom_h WHERE 1";
		$result = $this->db->query($SQL);
		$data = $result->result_array();
		
		if($data[0]['new_bom_number'] != NULL and $data[0]['new_bom_number'] != ""){
			return $data[0]['new_bom_number'];
		} else{
			return 1;
		}
	}
	
	function check_changes_cloned($old_quotation_id,$quotation_mode) {
	
		// If the quotation status is in edit mode, then do a cloning, set the mode in to draft and the new quotation_id in session
			$new_quotation_id=0;
			if($quotation_mode == 'edit' && $old_quotation_id){
				
				$quotation_id=$old_quotation_id;
				
				$rs = $this->crud_model->get('furniture_quotation',array('id'=>$quotation_id));
				
				if($rs != false){
				
					$row = $rs[0];

					if($row['quotation_status']==='Open'){
						
					// Getting Max Revision Number //
					$records = $this->db->query("SELECT MAX(quotation_revisionnumber) as `max_rev_number` FROM furniture_quotation WHERE id = ".$this->db->escape($row['id']));
					
					$ds = $records->result_array();
					
					$new_rev_number = ($ds[0]['max_rev_number']) + 1;
	
					$division_id=$row['quotation_divisionid'];
					$nbquery= $this->db->query("SELECT * FROM  `company_division` WHERE division_id='$division_id'");
					$division_code=$nbquery->row()->division_code;

					$data = array(									
						'quotation_number'			=> $row['quotation_number'],
						'quotation_number_full' 	=> $division_code.'-'.$row['quotation_number'].'-'.$new_rev_number,		
						'quotation_revisionnumber'  => $new_rev_number,					
						'quotation_date' 			=> $row['quotation_date'],
						'quotation_divisionid' 		=> $row['quotation_divisionid'],
						'quotation_currencyid' 		=> $row['quotation_currencyid'],
						'salesman_id'				=> $row['salesman_id'],
						'client_id'					=> $row['client_id'],
						'contact_id'				=> $row['contact_id'],
						'enquiry_id'				=> $row['enquiry_id'],
						'project_name'				=> $row['project_name'],
						'project_location'			=> $row['project_location'],
						'project_remarks'			=> $row['project_remarks'],
						'quotation_total'			=> $row['quotation_total'],
						'quotation_vat_percentage'	=> $row['quotation_vat_percentage'],
						'quotation_vat_amount'		=> $row['quotation_vat_amount'],
						'quotation_amount_with_vat'	=> $row['quotation_amount_with_vat'],
						'quotation_discount'		=> 0,
						'exstock_paymenttermid'		=> $row['exstock_paymenttermid'],
						'byorder_paymenttermid'		=> $row['byorder_paymenttermid'],
						'quotation_logos'			=> $row['quotation_logos'],
						'covering_letter'			=> $row['covering_letter'],
						'terms_and_conditions'		=> $row['terms_and_conditions'],
						'status'					=> '3',
						'quotation_status'			=> 'Draft',
						'enquiry_id'    			=> $row['enquiry_id'],
						'last_modified_by' 			=> $this->session->userdata('user_id'),
						'last_modified_date'		=> date('Y-m-d h:m:s')
					);
					
					
					$this->crud_model->insert('furniture_quotation',$data);
					
					$new_quotation_id = $this->db->insert_id();
					
					
					$log_data=array(
						'trans_no'  =>  $division_code.'-'.$row['quotation_number'].'-'.$new_rev_number,
						'trans_type'  =>  'Quotation',
						'trans_op'  =>  'Edit',
						'trans_user_id'  =>  $this->session->userdata('user_id')
					);
					$log_for_transactions=$this->crud_model->insert('log_for_transactions',$log_data);


					$query = $this->db->query("SELECT * FROM `log_for_quotation` WHERE `trans_id`='$old_quotation_id' and group_by='3' order by `id` desc limit 1 ");
					if($query!=false){
						$log_for_quotationg_data=array(
							'trans_id'  	=>  $new_quotation_id,
							'trans_type'  	=>  'Quotation',
							'trans_action'  =>  'Transfer',
							'flow_id'  		=>  $query->row()->flow_id,
							'group_by'  	=>  3,
							'trans_user_id' =>  $query->row()->trans_user_id

						);
						$log_for_transactions=$this->crud_model->insert('log_for_quotation',$log_for_quotationg_data);
					}

					$queryee = $this->db->query("SELECT * FROM `log_for_quotation` WHERE `trans_id`='$old_quotation_id' and group_by='4' order by `id` desc limit 1 ");
					if($queryee!=false){
						$log_for_quotationg_dataee=array(
							'trans_id'  	=>  $new_quotation_id,
							'trans_type'  	=>  'Quotation',
							'trans_action'  =>  'Transfer',
							'flow_id'  		=>  $queryee->row()->flow_id,
							'group_by'  	=>  4,
							'trans_user_id' =>  $queryee->row()->trans_user_id

						);
						$log_for_transactions=$this->crud_model->insert('log_for_quotation',$log_for_quotationg_dataee);
					}

					$queryqq = $this->db->query("SELECT * FROM `log_for_quotation` WHERE `trans_id`='$old_quotation_id' and group_by='1' order by `id` desc limit 1");
					if($queryqq!=false){
						$log_for_quotationg_dataqq=array(
							'trans_id'  	=>  $new_quotation_id,
							'trans_type'  	=>  'Quotation',
							'trans_action'  =>  'Transfer',
							'flow_id'  		=>  $queryqq->row()->flow_id,
							'group_by'  	=>  1,
							'trans_user_id' =>  $queryqq->row()->trans_user_id
						);
						$log_for_transactionsqq=$this->crud_model->insert('log_for_quotation',$log_for_quotationg_dataqq);
					}

					//Furniture Cloning
					
					$rs = $this->crud_model->get('furniture_items',array('quotation_id'=>$quotation_id), null, null, "furniture_id", "ASC");
					if($rs != false){
						foreach($rs as $furniture_item ) {
							
							$data = array(
								'quotation_id'			=> $new_quotation_id,
								'furniture_reference'	=> $furniture_item['furniture_reference'],
								'furniture_brand'		=> $furniture_item['furniture_brand'],
								'furniture_brand_other'	=> $furniture_item['furniture_brand_other'],
								'furniture_area'		=> $furniture_item['furniture_area'],
								'ex_furniture_area'		=> $furniture_item['ex_furniture_area'],
								'sub_group'				=> $furniture_item['sub_group'],
								'sub_group_id'			=> $furniture_item['sub_group_id'],
								'item_id'				=> $furniture_item['item_id'],
								'furniture_model'		=> $furniture_item['furniture_model'],
								'furniture_description'	=> $furniture_item['furniture_description'],
								'furniture_upholstery'	=> $furniture_item['furniture_upholstery'],
								'furniture_unitprice'	=> $furniture_item['furniture_unitprice'],
								'furniture_quantity'	=> $furniture_item['furniture_quantity'],
								'furniture_type'		=> $furniture_item['furniture_type'],
								'furniture_height'		=> $furniture_item['furniture_height'],
								'furniture_width'		=> $furniture_item['furniture_width'],
								'furniture_uom'			=> $furniture_item['furniture_uom'],
								'furniture_ratem2'		=> $furniture_item['furniture_ratem2'],
								'furniture_stock_type'	=> $furniture_item['furniture_stock_type'],
								'category'				=> $furniture_item['category'],
								'fabric_width'			=> $furniture_item['fabric_width'],
								'gathering'				=> $furniture_item['gathering'],
								'uom'					=> $furniture_item['uom'],
								'vat_perce'				=> $furniture_item['vat_perce'],
								'vat_amount'			=> $furniture_item['vat_amount'],
								'item_discount'			=> $furniture_item['item_discount'],
								'total_discount'		=> $furniture_item['total_discount'],
								'net_amount'			=> $furniture_item['net_amount'],
								'is_optional'			=> $furniture_item['is_optional'],
								'contingency'			=> $furniture_item['contingency'],
								'furniture_comments'	=> $furniture_item['furniture_comments'],
								'image'					=> $furniture_item['image'],
								'estimate_yes_or_no'	=> $furniture_item['estimate_yes_or_no'],
								'total_cost_including_overhead'	=> $furniture_item['total_cost_including_overhead']
							);
							$this->crud_model->insert('furniture_items',$data);
							

							$selected_furniture_id		=	$furniture_item['furniture_id'];
							$furniture_id				= 	$this->db->insert_id();
							$new_quotation_number		= 	$row['quotation_number'];
							$new_quotation_divisionid	= 	$row['quotation_divisionid'];
							

							$datarow					=  $this->itemWiseDatarow($furniture_id);
							$estimation 				=  $this->estimation($selected_furniture_id);
							$estimationMaterialsAdded 	=  $this->estimationMaterialsAdded($selected_furniture_id);
							$estimationLabourCostAdded 	=  $this->estimationLabourCostAdded($selected_furniture_id);
							$estimationSubContractAdded =  $this->estimationSubContractAdded($selected_furniture_id);
							$estimationHiringAdded 		=  $this->estimationHiringAdded($selected_furniture_id);
							$estimationOthersAdded 		=  $this->estimationOthersAdded($selected_furniture_id);

							$where=array(
								'furniture_id'=> $furniture_id
							);

							$this->crud_model->delete('estimation',$where);
							$this->crud_model->delete('estimation_material',$where);
							$this->crud_model->delete('estimation_labourcost',$where);
							$this->crud_model->delete('estimation_subcontract',$where);
							$this->crud_model->delete('estimation_hiring',$where);
							$this->crud_model->delete('estimation_others',$where);

							$boq_no =  $this->furniture_quotation_model->get_boq_no($furniture_id,$new_quotation_divisionid,$new_quotation_number);

							$user_id	=	$this->session->userdata('user_id');

							if($estimation!=false){
								$summary_data=array(
									'boq_no'   			=>  $boq_no,
									'furniture_id' 		=>  $furniture_id,
									'material'  		=>  $estimation['material'],
									'labourCost'   		=>  $estimation['labourCost'],
									'subcontract'   	=>  $estimation['subcontract'],
									'hiring'   			=>  $estimation['hiring'],
									'others'  			=>  $estimation['others'],
									'materialperce'  	=>  $estimation['materialperce'],
									'labourCostperce'   =>  $estimation['labourCostperce'],
									'subcontractperce'  =>  $estimation['subcontractperce'],
									'hiringperce'   	=>  $estimation['hiringperce'],
									'othersperce'  		=>  $estimation['othersperce'],
									'profitperce'  		=>  $estimation['profitperce'],
									'selling_price'  	=>  $estimation['selling_price'],
									'user_id'  			=>  $estimation['user_id']
								);
								$this->db->insert('estimation', $summary_data);
							}
							if($estimationMaterialsAdded!=false){
								foreach($estimationMaterialsAdded as $rowz){
									$material_data=array(
										'boq_no'   			=>  $boq_no,
										'furniture_id' 		=>  $furniture_id,
										'item_id'  			=>  $rowz['item_id'],
										'item_name'   		=>  $rowz['item_name'],
										'item_description'  =>  $rowz['item_description'],
										'material_qty'   	=>  $rowz['material_qty'],
										'material_uom'  	=>  $rowz['material_uom'],
										'material_unitprice'=>  $rowz['material_unitprice'],
										'material_total'   	=>  $rowz['material_total'],
										'user_id'  			=>  $rowz['user_id']
									);
									$this->db->insert('estimation_material', $material_data);
								}
							}
							if($estimationLabourCostAdded!=false){
								foreach($estimationLabourCostAdded as $row2){
									$labour_data=array(
										'boq_no'   				=>  $boq_no,
										'furniture_id' 			=>  $furniture_id,
										'labour_department'  	=>  $row2['labour_department'],
										'labour_emp_category'  	=>  $row2['labour_emp_category'],
										'labour_no_of_ppl'   	=>  $row2['labour_no_of_ppl'],
										'labour_hours'  		=>  $row2['labour_hours'],
										'labour_total_man_hours'=>  $row2['labour_total_man_hours'],
										'labour_rate'  			=>  $row2['labour_rate'],
										'labour_total_amount'	=>  $row2['labour_total_amount'],
										'user_id'  				=>  $row2['user_id']
									);
									$this->db->insert('estimation_labourcost', $labour_data);
								}
							}
							if($estimationSubContractAdded!=false){
								foreach($estimationSubContractAdded as $row3){
									$subcontract_data=array(
										'boq_no'   				=>  $boq_no,
										'furniture_id' 			=>  $furniture_id,
										'subcontract_vendor'  	=>  $row3['subcontract_vendor'],
										'subcontract_work_type' =>  $row3['subcontract_work_type'],
										'subcontract_amount'  	=>  $row3['subcontract_amount'],
										'user_id'  				=>  $row3['user_id']
									);
									$this->db->insert('estimation_subcontract', $subcontract_data);
								}
							}
							if($estimationHiringAdded!=false){
								foreach($estimationHiringAdded as $row4){
									$hiring_data=array(
										'boq_no'   			=>  $boq_no,
										'furniture_id' 		=>  $furniture_id,
										'hiring_vendor'  	=>  $row4['hiring_vendor'],
										'hiring_work_type' 	=>  $row4['hiring_work_type'],
										'hiring_amount'  	=>  $row4['hiring_amount'],
										'user_id'  			=>  $row4['user_id']
									);
									$this->db->insert('estimation_hiring', $hiring_data);
								}
							}
							if($estimationOthersAdded!=false){
								foreach($estimationOthersAdded as $row5){
									$others_data=array(
										'boq_no'   			=>  $boq_no,
										'furniture_id' 		=>  $furniture_id,
										'others_vendor'  	=>  $row5['others_vendor'],
										'others_work_type' 	=>  $row5['others_work_type'],
										'others_amount'  	=>  $row5['others_amount'],
										'user_id'  			=>  $row5['user_id']
									);
									$this->db->insert('estimation_others', $others_data);
								}
							}
							/*if($estimation!=false){
								$data2=array(
									'furniture_unitprice'   =>  $estimation['selling_price'],
									'vat_amount'   			=>  $datarow['furniture_quantity']*$estimation['selling_price']*($datarow['vat_perce']/100),
									'net_amount'   			=>  ($estimation['selling_price']* $datarow['furniture_quantity'])+( $datarow['furniture_quantity']*$estimation['selling_price']*($datarow['vat_perce']/100)),
									'item_discount'   		=>  0,
									'total_discount'   		=>  0,
								);
								$this->db->where('furniture_id', $furniture_id);
								$this->db->update('furniture_items', $data2);
							}*/
						}
					
					}	
					}
					//Furniture Cloning End
				}	
				//$this->session->set_userdata('furniture_quotation_id',$new_quotation_id);
				//$this->session->set_userdata('quotation_mode','draft');
				//log_message('INFO','After cloning, Furniture Quotation ID: '.$this->session->userdata('furniture_quotation_id'));
			}
			return $new_quotation_id;
		}	

	
	function xxx_check_changes_cloned() {
	
		// If the quotation status is in edit mode, then do a cloning, set the mode in to draft and the new quotation_id in session
		if($this->session->userdata('quotation_mode') == 'edit' && $this->session->userdata('furniture_quotation_id')){
			
			$quotation_id=$this->session->userdata('furniture_quotation_id');
			
			$rs = $this->crud_model->get('furniture_quotation',array('id'=>$quotation_id));
			
			if($rs != false){
			
				$row = $rs[0];
				// Getting Max Revision Number //
				$records = $this->db->query("SELECT MAX(quotation_revisionnumber) as `max_rev_number` FROM furniture_quotation WHERE id = ".$this->db->escape($row['id']));
				
				$ds = $records->result_array();
				
				$new_rev_number = ($ds[0]['max_rev_number']) + 1;

				
				$data = array(									
					'quotation_number'			=> $row['quotation_number'],	
					'quotation_revisionnumber'  => $new_rev_number,					
					'quotation_date' 			=> $row['quotation_date'],
					'quotation_divisionid' 		=> $row['quotation_divisionid'],
					'quotation_currencyid' 		=> $row['quotation_currencyid'],
					'salesman_id'				=> $row['salesman_id'],
					'client_id'					=> $row['client_id'],
					'contact_id'				=> $row['contact_id'],
					'enquiry_id'				=> $row['enquiry_id'],
					'project_name'				=> $row['project_name'],
					'project_location'			=> $row['project_location'],
					'project_remarks'			=> $row['project_remarks'],
					'quotation_total'			=> $row['quotation_total'],
					'quotation_vat_percentage'	=> $row['quotation_vat_percentage'],
					'quotation_vat_amount'		=> $row['quotation_vat_amount'],
					'quotation_amount_with_vat'	=> $row['quotation_amount_with_vat'],
					'quotation_discount'		=> 0,
					'exstock_paymenttermid'		=> $row['exstock_paymenttermid'],
					'byorder_paymenttermid'		=> $row['byorder_paymenttermid'],
					'quotation_logos'			=> $row['quotation_logos'],
					'covering_letter'			=> $row['covering_letter'],
					'terms_and_conditions'		=> $row['terms_and_conditions'],
					'quotation_status'			=> 'Draft',
					'last_modified_by' 			=> $this->session->userdata('user_id'),
					'last_modified_date'		=> date('Y-m-d h:m:s')
				);
				
				
				$this->crud_model->insert('furniture_quotation',$data);
				
				$new_quotation_id = $this->db->insert_id();
				
				//Furniture Cloning
				
				$rs = $this->crud_model->get('furniture_items',array('quotation_id'=>$quotation_id), null, null, "furniture_id", "ASC");
				if($rs != false){
					foreach($rs as $furniture_item ) {
						
						$data = array(
							'quotation_id'			=> $new_quotation_id,
							'furniture_reference'	=> $furniture_item['furniture_reference'],
							'furniture_brand'		=> $furniture_item['furniture_brand'],
							'furniture_brand_other'	=> $furniture_item['furniture_brand_other'],
							'furniture_area'		=> $furniture_item['furniture_area'],
                            'ex_furniture_area'		=> $furniture_item['ex_furniture_area'],
							'sub_group'				=> $furniture_item['sub_group'],
                            'sub_group_id'			=> $furniture_item['sub_group_id'],
							'item_id'				=> $furniture_item['item_id'],
							'furniture_model'		=> $furniture_item['furniture_model'],
							'furniture_description'	=> $furniture_item['furniture_description'],
							'furniture_upholstery'	=> $furniture_item['furniture_upholstery'],
							'furniture_unitprice'	=> $furniture_item['furniture_unitprice'],
							'furniture_quantity'	=> $furniture_item['furniture_quantity'],
							'furniture_type'		=> $furniture_item['furniture_type'],
                            'furniture_height'		=> $furniture_item['furniture_height'],
                            'furniture_width'		=> $furniture_item['furniture_width'],
                            'furniture_uom'			=> $furniture_item['furniture_uom'],
                            'furniture_ratem2'		=> $furniture_item['furniture_ratem2'],
                            'furniture_stock_type'	=> $furniture_item['furniture_stock_type'],
							'category'				=> $furniture_item['category'],
							'fabric_width'			=> $furniture_item['fabric_width'],
							'gathering'				=> $furniture_item['gathering'],
							'uom'					=> $furniture_item['uom'],
							'vat_perce'				=> $furniture_item['vat_perce'],
							'total_discount'		=> $furniture_item['total_discount'],
							'image'					=> $furniture_item['image']
							
						);
						
						$this->crud_model->insert('furniture_items',$data);
					}
				}
				
				//Furniture Cloning End
					
			}		
		
			$this->session->set_userdata('furniture_quotation_id',$new_quotation_id);
			$this->session->set_userdata('quotation_mode','draft');
			log_message('INFO','After cloning, Furniture Quotation ID: '.$this->session->userdata('furniture_quotation_id'));
		}
		return;
	}	//End of check_changes_cloned
	
	
	
	function check_privilege($quotation_id){
		$rs = $this->crud_model->get_view_furniture_quotations_client_project_users(array('furniture_quotation.id'=>$quotation_id));
		if($rs != false){
			$row = $rs[0];
			if(($row['quotation_status'] != 'Draft' && $row['quotation_status'] != 'Open' && $row['quotation_status'] != 'Confirmed')) {
				return false;
			}
			if($this->session->userdata('user_group_id') == 1 ) {
				return true;
			} else {
				if($row['salesman_id'] == $this->session->userdata('user_id') ) {
					return true;
				} else {
					$data = $this->db->query("SELECT * FROM `view_log_for_quotation` WHERE flow_id!='2' AND `trans_id` LIKE '$quotation_id' order by `id` DESC limit 0,1");
					$rsv = $data->result_array();
					if($rsv != false){
						if($rsv[0]['trans_user_id'] == $this->session->userdata('user_id') ) {
							return true;
						} else {
							return false;
						}
					} else {
						return false;
					}
				}
			}
		} 
		return false;	
	} //End of function check_privilege
	

	function update_purchase_order_total($po_id){
		$rs = $this->crud_model->get('po_b',array('po_id'=>$po_id));
		if($rs != false){
			$po_gross_amt=0;
			$po_vat_amt=0;
			$po_net_amt=0;
			$po_discount=0;
			$fx_po_gross_amt=0;
			$fx_po_discount=0;
			$fx_po_net_amt=0;
			foreach($rs as $furniture_item ) {
				$po_gross_amt = $po_gross_amt +  (($furniture_item['item_qty']*$furniture_item['item_rate'])- $furniture_item['item_disc']);
				$po_vat_amt   = $po_vat_amt +  ($furniture_item['item_vat']);
				$po_discount  = $po_discount +  ($furniture_item['item_disc']);
				$po_net_amt = $po_net_amt +  ((($furniture_item['item_qty']*$furniture_item['item_rate']) - $furniture_item['item_disc']) + $furniture_item['item_vat'] );

				$fx_po_gross_amt = $fx_po_gross_amt +  (($furniture_item['item_qty']*$furniture_item['item_fx_rate'])- $furniture_item['fx_disc']);
				$fx_po_discount  = $fx_po_discount +  ($furniture_item['fx_disc']);
				$fx_po_net_amt = $fx_po_net_amt +  ((($furniture_item['item_qty']*$furniture_item['item_fx_rate']) - $furniture_item['fx_disc']) + $furniture_item['item_vat'] );

			}
			$update_data = array(
				'po_gross_amt'=> $po_gross_amt,
				'po_vat_amt'  => $po_vat_amt,
				'sign' 	  	  => '-',
				'round_off'   => 0,
				'status'      => 'Draft',
				'po_net_amt'  => $po_net_amt,
				'fx_po_gross_amt'  => $fx_po_gross_amt,
				'fx_po_net_amt'  => $fx_po_net_amt,
			);			
			$where= array('po_id'=>$po_id);
			$this->crud_model->update('po_h',$update_data,$where );
		} else {
			$update_data = array(
				'po_gross_amt'=> 0,
				'po_vat_amt'  => 0,
				'sign' 	  	  => '-',
				'round_off'   => 0,
				'status'      => 'Draft',
				'po_net_amt'  => 0,
				'fx_po_gross_amt'  => 0,
				'fx_po_discount'  => 0,
				'fx_po_net_amt'  => 0,
			);			
			$where= array('po_id'=>$po_id);
			$this->crud_model->update('po_h',$update_data,$where );			
		}
	}

	function update_purchase_invoice_total($po_id){
		$rs = $this->crud_model->get('purchase_b',array('pur_h_id'=>$po_id));
		if($rs != false){
			$po_gross_amt=0;
			$po_vat_amt=0;
			$po_net_amt=0;
			$po_discount=0;
			$fx_pi_gross_amt=0;
			$fx_pi_net_amt=0;
			foreach($rs as $furniture_item ) {
				$po_gross_amt = $po_gross_amt +  (($furniture_item['item_qty']*$furniture_item['item_rate'])- $furniture_item['item_disc_amt']);
				$po_vat_amt   = $po_vat_amt +  ($furniture_item['item_vat_amt']);
				$po_discount  = $po_discount +  ($furniture_item['item_disc_amt']);
				$po_net_amt   = $po_net_amt +  ((($furniture_item['item_qty']*$furniture_item['item_rate']) - $furniture_item['item_disc_amt']) + $furniture_item['item_vat_amt'] );
				$fx_pi_gross_amt = $fx_pi_gross_amt +  (($furniture_item['item_qty']*$furniture_item['item_fx_rate'])- $furniture_item['fx_disc']);
				$fx_pi_net_amt   = $fx_pi_net_amt +  ((($furniture_item['item_qty']*$furniture_item['item_fx_rate']) - $furniture_item['fx_disc']) + $furniture_item['item_vat_amt'] );
			}
			$update_data = array(
				'pur_amt' 	  => $po_gross_amt,
				'pur_vat'     => $po_vat_amt,
				'pur_discount'=> 0,
				'sign' 	  	  => '-',
				'round_off'   => 0,
				'status'      => 'Draft',
				'pur_net_amt' => $po_net_amt,
				'fx_pi_gross_amt' => $fx_pi_gross_amt,
				'fx_pi_discount' => 0,
				'fx_pi_net_amt' => $fx_pi_net_amt
			);			
			$where= array('id'=>$po_id);
			$this->crud_model->update('purchase_h',$update_data,$where );
		} else {
			$update_data = array(
				'pur_amt'  	  => 0,
				'pur_vat'     => 0,
				'pur_discount'=> 0,
				'sign' 	  	  => '-',
				'round_off'   => 0,
				'status'      => 'Draft',
				'pur_net_amt' => 0,
				'fx_pi_gross_amt' => 0,
				'fx_pi_discount' => 0,
				'fx_pi_net_amt' => 0
			);			
			$where= array('id'=>$po_id);
			$this->crud_model->update('purchase_h',$update_data,$where );			
		}
	}


	
	function update_quotation_total($quotation_id){
	
		//$quotation_id=$this->session->userdata('furniture_quotation_id');
		$rs = $this->crud_model->get('furniture_items',array('quotation_id'=>$quotation_id));
		if($rs != false){
			$quotation_total=0;
			$quotation_vat_amount=0;
			$quotation_amount_with_vat=0;
			foreach($rs as $furniture_item ) {
				if($furniture_item['is_optional']==0){
					$quotation_total = $quotation_total +  (($furniture_item['furniture_unitprice']*$furniture_item['furniture_quantity']) - $furniture_item['item_discount']);
					$quotation_vat_amount = $quotation_vat_amount +  ((($furniture_item['furniture_unitprice']*$furniture_item['furniture_quantity']) - $furniture_item['item_discount'])*($furniture_item['vat_perce']/100));
					$quotation_amount_with_vat = $quotation_amount_with_vat+ ((($furniture_item['furniture_unitprice']*$furniture_item['furniture_quantity']) - $furniture_item['item_discount']) + ((($furniture_item['furniture_unitprice']*$furniture_item['furniture_quantity']) - $furniture_item['item_discount'])*($furniture_item['vat_perce']/100)));
				}
			}
			$data=array(
				'quotation_total'  			=> $quotation_total,
				'quotation_vat_amount'  	=> $quotation_vat_amount,
				'quotation_amount_with_vat' => $quotation_amount_with_vat,
				'advance_percentage'  		=> 0,
				'advance_amount'  			=> 0,
				'quotation_discount'  		=> 0,
				'last_modified_by'			=> $this->session->userdata('user_id'),
				'last_modified_date'		=> date('Y-m-d h:m:s')
			);
						
			$where= array('id'=>$quotation_id);
			$this->crud_model->update('furniture_quotation',$data,$where );				
	
		} else {
				$data=array(
					'quotation_total'  			=> 0,
					'quotation_vat_amount'  	=> 0,
					'quotation_amount_with_vat' => 0,
					'advance_percentage'  		=> 0,
					'advance_amount'  			=> 0,
					'quotation_discount'  		=> 0,
					'last_modified_by'			=> $this->session->userdata('user_id'),
					'last_modified_date'		=> date('Y-m-d h:m:s')
				);
				
				$where= array('id'=>$quotation_id);
				$this->crud_model->update('furniture_quotation',$data,$where );	
		}
	
	} //End of function update_quotation_total


	function get_full_proforma_details($invoice_id, $revisions) {
	
		$data['proforma_id']  = $invoice_id;
		
		$where=array('proforma.proforma_id' => $invoice_id);
		
		if($revisions == 'unique'){
			$records=$this->crud_model->proforma($where);
		}
		else{
			$records=$this->crud_model->proforma($where);
		}
		
		$division=$this->crud_model->get("proforma",$where);
		
		if($records!=false) {
		
			$data['invoice_number']			    = $records[0]['proforma_number'];
			$data['division_code']			    = $records[0]['division_code'];
			$data['currency_code']			    = $records[0]['currency_code'];
			$data['currency_name']				= $records[0]['currency_name'];
			$data['logo_filename']				= $records[0]['logo_filename'];
			$data['invoice_date']	            = $records[0]['proforma_date'];
			$data['quotation_id']		        = $records[0]['quotation_id'];
			$data['invoice_amount']				= $records[0]['proforma_amount'];
			$data['client_name']	            = $records[0]['client_name'];
			$data['salesman_name']				= $records[0]['user_name'];
			$data['salesman_email_id']			= $records[0]['user_email_id'];
			$data['client_email']	            = $records[0]['client_email'];
			$data['client_address']	            = $records[0]['client_address'];
			$data['client_telephone1']	        = $records[0]['client_telephone1'];
			$data['client_telephone2']	        = $records[0]['client_telephone2'];
			$data['invoice_status']			    = $records[0]['proforma_status'];
			$data['quotation_number']			= $records[0]['quotation_number'];
			$data['invoice_percentage']			= $records[0]['proforma_percentage'];
			$data['invoice_percentage_amount']	= $records[0]['proforma_percentage_amount'];
			$data['invoice_discount']			= $records[0]['proforma_discount'];
			$data['qoute_discount']				= $records[0]['qoute_discount'];
			$data['quotation_logos']			= $records[0]['quotation_logos'];
			$data['lpono']						= $records[0]['lpono'];
			$data['lpono']						= $records[0]['po_no'];
			$data['quotation_number_full']		= $records[0]['quotation_number_full'];
			$data['quotation_revisionnumber']	= $records[0]['quotation_revisionnumber'];
			$data['division_id']				= $records[0]['quotation_divisionid'];
			$data['quotation_vat_percentage']	= $records[0]['quotation_vat_percentage'];
			$data['proforma_vat_percentage']	= $records[0]['proforma_vat_percentage'];
			$data['invoice_division_id']		= $division[0]['quotation_divisionid'];
			$data['project_name']				= $records[0]['project_name'];
			$data['invoice_vat_amount']			= $division[0]['proforma_vat_amount'];
			$data['tax_name']	            	= $records[0]['tax_name'];
			$data['tax_no']	        			= $records[0]['tax_no'];
			$data['is_project']	        		= $records[0]['is_project'];
			$data['job_card_id']	        	= $records[0]['job_card_id'];
             
			$frs = $this->crud_model->get_view_proforma_items_with_brand(array('proforma_details.proforma_id'=> $records[0]['proforma_id']),null,null,"group_id","ASC",null,null,"group_name");
			
			if($frs  != false) {
				$data['invoice_items']=$frs;
			
			} else {
				$data['invoice_items']=array();
			}
			return $data;
				
		} else {
			return false;
		}
		
		
		
	}

	
	
	function get_quotation_advance($quotation_id){
			
		$quotation_advance=0;

		$rs = $this->crud_model->get('furniture_items',array('quotation_id'=>$quotation_id));
		if($rs != false){
		
			$exorder_total=0;
			$byorder_total=0;
			
			foreach($rs as $furniture_item ) {
				if($furniture_item['furniture_type'] == 1) {
					$exorder_total = $exorder_total + ($furniture_item['furniture_unitprice']*$furniture_item['furniture_quantity']);
				} else {
					$byorder_total = $byorder_total + ($furniture_item['furniture_unitprice']*$furniture_item['furniture_quantity']);
				}
			}
			
			$quotation_total=$exorder_total+$byorder_total;
			
			//$rs = $this->crud_model->get('view_furniture_quotations_client_project_users',array('quotation_id'=>$quotation_id));
			$rs = $this->crud_model->get_view_furniture_quotations_client_project_users(array('furniture_quotation.id'=>$quotation_id));
			//var_dump($rs);
			
			$quotation_discount=$rs[0]['quotation_discount'];
			/*$exstock_payment_advance=$rs[0]['exstock_payment_advance'];
			$byorder_payment_advance=$rs[0]['byorder_payment_advance'];*/
			$exstock_payment_advance=$rs[0]['payment_advance'];
			$byorder_payment_advance=$rs[0]['payment_advance'];
						
			
			$exorder_total_after_discount=$exorder_total-($exorder_total*$quotation_discount/100);
			$byorder_total_after_discount=$byorder_total-($byorder_total*$quotation_discount/100);
			
			$exorder_advance=$exorder_total_after_discount*$exstock_payment_advance/100;
			$byorder_advance=$byorder_total_after_discount*$byorder_payment_advance/100;
			
			$quotation_advance=$exorder_advance+$byorder_advance;
		}	
		
		return	$quotation_advance;

	}//End of function get_quotation_advance
	
	function set_receipt_id($quotation_id=NULL){
		$furniture_receipt_number = $this->get_new_receipt_number();
		$data=array(
			'receipt_date' 	=>date('Y-m-d h:m:s'),
			'quotation_id'  =>	$quotation_id,
			'receipt_number'=> 	$furniture_receipt_number
		);
		$furniture_receipt_id = $this->crud_model->insert('furniture_receipts',$data);
		$this->session->set_userdata('furniture_receipt_id',$furniture_receipt_id);
	}
	
	function get_new_receipt_number(){
		$SQL = "SELECT MAX(receipt_number)+1 as `new_receipt_number` FROM furniture_receipts;";
		$result = $this->db->query($SQL);
		$data = $result->result_array();
		if($data[0]['new_receipt_number'] != NULL and $data[0]['new_receipt_number'] != ""){
			return $data[0]['new_receipt_number'];
		} else{
			return 10001;
		}
	}
	
	function set_invoice_id($quotation_id=NULL){
		$furniture_invoice_number = $this->get_new_invoice_number();
		$furniture_invoice_details = $this->get_invoice_details($quotation_id);
		$quotation_details = $this->crud_model->get('furniture_quotation',array('id'=>$quotation_id));
		$invoice_amount = $quotation_details[0]['quotation_total'] - $quotation_details[0]['quotation_discount'];
		$client_id = $quotation_details[0]['client_id'];
		$paid_amount = 0;
		if ($furniture_invoice_details != False){
            foreach($furniture_invoice_details as $receipt){
				$paid_amount = $paid_amount+$receipt['receipt_amount'];
			}
		}
		//var_dump($furniture_invoice_details); exit;
		$data=array(
			'invoice_date' 		=> date('Y-m-d h:m:s'),
			'quotation_id'    	=> $quotation_id,
			'invoice_number' 	=> $furniture_invoice_number,
			'invoice_amount'	=> $invoice_amount,
			'paid_amount' 		=> $paid_amount,
			'client_id'			=> $client_id
		);
		$furniture_invoice_id = $this->crud_model->insert('furniture_invoice',$data);
		$this->session->set_userdata('furniture_invoice_id',$furniture_invoice_id);
			
	}
	
	// Get the All the amount paid for the quotation
	function get_invoice_details($quotation_id=NULL){
		$where = array('quotation_id' => $quotation_id);
		$this->db->select('receipt_amount');
		$this->db->from('furniture_receipts');
		$this->db->where($where);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}else{
			return false;
		}	
	}
	
	function get_invoice_amount($quotation_id=NULL){
		$where = array('id' => $quotation_id);
		$this->db->select('receipt_amount');
		$this->db->from('furniture_receipts');
		$this->db->where($where);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}else{
			return false;
		}
	}
	
	function get_invoice_date($quotation_id=NULL){
		$where = array('quotation_id' => $quotation_id);
		$this->db->select('invoice_date');
		$this->db->from('furniture_invoice');
		$this->db->where($where);
		$rs = $this->db->get();
		
		if($rs->num_rows() > 0){
			$data = $rs->result_array();
			return $data[0]['invoice_date'];
		}
		else{
			return false;
		}
	}
	
	function get_new_invoice_number(){
		$SQL = "SELECT MAX(invoice_number)+1 as `new_invoice_number` FROM furniture_invoice;";
		$result = $this->db->query($SQL);
		$data = $result->result_array();
		
		if($data[0]['new_invoice_number'] != NULL and $data[0]['new_invoice_number'] != ""){
			return $data[0]['new_invoice_number'];
		} else{
			return 1001;
		}
	}
	
	function check_invoice($quotation_id=NULL){
		$rs = $this->crud_model->get('furniture_invoice',array('quotation_id'=>$quotation_id));
		if($rs != false){
			return 1;
		}else{
			return 0;
		}
	}
	
	function check_receipt($quotation_id=NULL){
		$rs = $this->crud_model->get('furniture_receipts',array('quotation_id'=>$quotation_id));
		if($rs != false){
			return 1;
		}else{
			return 0;
		}
	}
	
	function get_all_invoices(){
		if(isset($_REQUEST['search_button'])){
			if($this->input->post('filter_division')!="" && $this->input->post('filter_value')!=""){
				if($this->input->post('filter_by') == 1) {
					$this->db->where('invoice_number',$this->input->post('filter_value'));
					$this->db->where('furniture_invoice.quotation_divisionid',$this->input->post('filter_division'));
				} elseif($this->input->post('filter_by') == 2) {
					$this->db->like('client', $this->input->post('filter_value'));
					$this->db->where('furniture_invoice.quotation_divisionid',$this->input->post('filter_division'));
				}
			}else{
				$this->db->or_where('furniture_invoice.quotation_divisionid',$this->input->post('filter_division'));
			}
		}
		$this->db->select('*');
		$this->db->from('furniture_invoice');
		//$this->db->join('furniture_quotation','furniture_invoice.quotation_id = furniture_quotation.id','left');
		$this->db->join('company_division','company_division.division_id = furniture_invoice.quotation_divisionid','inner');
		$this->db->join('new_client_master','new_client_master.client_id = furniture_invoice.client_id','left');
		$this->db->join('furniture_quotation','furniture_quotation.id = furniture_invoice.quotation_id','left');
		$this->db->order_by("invoice_date","desc");
		//$this->db->group_by("furniture_receipts.quotation_id");
		$rs = $this->db->get();
		
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}else{
			return false;
		}
	}
	/*
	function get_all_receipts(){
		$this->db->select('*');
		$this->db->from('furniture_receipts');
		$this->db->join('furniture_quotation','furniture_quotation.id = furniture_receipts.quotation_id','left');
		$this->db->join('company_division','company_division.division_id = furniture_quotation.quotation_divisionid','left');
		$rs = $this->db->get();

		if($rs->num_rows() > 0){
			return $rs->result_array();
		}
		else{
			return false;
		}

	}
	*/

	function get_all_receipts(){
		if(isset($_REQUEST['search_button'])){
		
			if($this->input->post('filter_division')!="" && $this->input->post('filter_value')!=""){
				if($this->input->post('filter_by') == 1) {
					$this->db->where('receipt_number',$this->input->post('filter_value'));
					$this->db->where('furniture_receipts.quotation_divisionid',$this->input->post('filter_division'));
				} elseif($this->input->post('filter_by') == 2) {
					$this->db->like('furniture_invoice.client', $this->input->post('filter_value'));
					$this->db->where('furniture_receipts.quotation_divisionid',$this->input->post('filter_division'));
				}
			}else{
				$this->db->or_where('furniture_receipts.quotation_divisionid',$this->input->post('filter_division'));
			}
		}
		$this->db->select('receipt_id,receipt_number,receipt_number,receipt_date,receipt_status,sum(receipt_amount) receipt_amount,sum(furniture_receipts.receipt_discount) receipt_discount,receipt_mode,furniture_invoice.client,company_division.division_code,company_division.currency_code,furniture_receipts.quotation_divisionid' );
		$this->db->from('furniture_receipts');
		$this->db->group_by('receipt_number');
		$this->db->group_by('furniture_receipts.quotation_divisionid');
		//$this->db->join('furniture_quotation','furniture_quotation.id = furniture_receipts.quotation_id','left');
		//$this->db->join('new_client_master','furniture_quotation.client_id = new_client_master.client_id','left');
		$this->db->join('company_division','company_division.division_id = furniture_receipts.quotation_divisionid','inner');
		$this->db->join('furniture_invoice','furniture_invoice.invoice_id = furniture_receipts.invoice_id','inner');
		$this->db->order_by("receipt_date","desc");
		$rs = $this->db->get();
		//echo $this->db->last_query().'<br>';
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}else{
			return false;
		}

	}

	function get_all_ledgers(){
		if(isset($_REQUEST['ttttt'])){
			if($this->input->post('filter_value')!=""){
				$this->db->like('ledger_name',$this->input->post('filter_value'));
				$this->db->or_like('ledger_code',$this->input->post('filter_value'));
			}
			/*$fromDate=$this->input->post('fromDate');
			$toDate=$this->input->post('toDate');
			if($fromDate!='' and $toDate!='') {
				$date2 = str_replace('/', '-', $this->input->post("fromDate"));
				$date3 = str_replace('/', '-', $this->input->post("toDate"));
				$fromDate =   date("Y-m-d", strtotime($date2));
				$toDate =   date("Y-m-d", strtotime($date3));
				$this->db->where('delivery_noted_date >=', $fromDate);
				$this->db->where('delivery_noted_date <=', $toDate);
			} else if($fromDate!='' and $toDate==''){
				$date2 = str_replace('/', '-', $this->input->post("fromDate"));
				$fromDate =   date("Y-m-d", strtotime($date2));
				$this->db->where('delivery_noted_date >=', $fromDate);
			} else if($fromDate=='' and $toDate!=''){
				$date3 = str_replace('/', '-', $this->input->post("toDate"));
				$toDate =   date("Y-m-d", strtotime($date3));
				$this->db->where('delivery_noted_date <=', $toDate);
			}*/
		}
		$this->db->select('*' );
		$this->db->from('ledgers');
		$this->db->join('account_group','ledgers.acoount_group_id = account_group.acc_group_id','left');
		$this->db->where('ledgers.acoount_group_id!="17" and ledgers.acoount_group_id!="18" ');
		$this->db->limit(200);
		$this->db->order_by("ledger_id","desc");
		$rs = $this->db->get();
		//echo $this->db->last_query().'<br>';
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}else{
			return false;
		}
	}

	function get_all_delivery_notes(){
		if(isset($_REQUEST['ttttt'])){
			if($this->input->post('filter_value')!=""){
				$this->db->like('delivery_note_number',$this->input->post('filter_value'));
			}
			$fromDate=$this->input->post('fromDate');
			$toDate=$this->input->post('toDate');
			if($fromDate!='' and $toDate!='') {
				$date2 = str_replace('/', '-', $this->input->post("fromDate"));
				$date3 = str_replace('/', '-', $this->input->post("toDate"));
				$fromDate =   date("Y-m-d", strtotime($date2));
				$toDate =   date("Y-m-d", strtotime($date3));
				$this->db->where('delivery_noted_date >=', $fromDate);
				$this->db->where('delivery_noted_date <=', $toDate);
			} else if($fromDate!='' and $toDate==''){
				$date2 = str_replace('/', '-', $this->input->post("fromDate"));
				$fromDate =   date("Y-m-d", strtotime($date2));
				$this->db->where('delivery_noted_date >=', $fromDate);
			} else if($fromDate=='' and $toDate!=''){
				$date3 = str_replace('/', '-', $this->input->post("toDate"));
				$toDate =   date("Y-m-d", strtotime($date3));
				$this->db->where('delivery_noted_date <=', $toDate);
			}
		}
		$this->db->select('*' );
		$this->db->from('delivery_note');
		$this->db->join('new_client_master','delivery_note.client_id = new_client_master.client_id','left');
		$this->db->limit(200);
		$this->db->order_by("delivery_note.id","desc");
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}else{
			return false;
		}
	}

	function get_all_delivery_notes_by_job($search_job_card_id){
		if(isset($_REQUEST['search_button'])){
			if($this->input->post('filter_division')!="" && $this->input->post('filter_value')!=""){
				if($this->input->post('filter_by') == 1) {
					$this->db->like('delivery_note_number',$this->input->post('filter_value'));
					$this->db->where('delivery_note.divisionid',$this->input->post('filter_division'));
				} elseif($this->input->post('filter_by') == 2) {
					$this->db->like('new_client_master.client_name', $this->input->post('filter_value'));
					$this->db->where('delivery_note.divisionid',$this->input->post('filter_division'));
				}
			}else{
				$this->db->or_where('delivery_note.divisionid',$this->input->post('filter_division'));
			}
		}
		
		$this->db->select('*' );
		$this->db->from('delivery_note');
		$this->db->join('new_client_master','delivery_note.client_id = new_client_master.client_id','left');
		if($search_job_card_id!=''){
			$this->db->join('delivery_note_details','delivery_note.id = delivery_note_details.delvery_note_id','left');
			$this->db->where('delivery_note_details.job_card_details_id',$search_job_card_id);
			$this->db->group_by('delivery_note.id');
		}
		$this->db->order_by("delivery_noted_date","desc");
		
		$rs = $this->db->get();
		//echo $this->db->last_query().'<br>';
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}else{
			return false;
		}

	}

	function get_all_receipts_invdetails($receipt_no,$receipt_id,$quotation_divisionid){
		$where = array('furniture_receipts.receipt_number' => $receipt_no,'furniture_receipts.quotation_divisionid' => $quotation_divisionid);
		//$where = array('furniture_receipts.quotation_divisionid' => $quotation_divisionid);
		$this->db->where($where);
		$this->db->select('receipt_id,receipt_date,`cust_bill_allocations`.`bill_id` as invoice_id,invoice_number,invoice_amount,qoute_discount, `cust_bill_allocations`.`bill_os_amount` as paid_amount,company_division.division_code,company_division.currency_code,invoice_percentage_amount,invoice_discount,job_card_id' );
		$this->db->from('furniture_receipts');
		//$this->db->join('furniture_quotation','furniture_quotation.id = furniture_receipts.quotation_id','left');
		//$this->db->join('new_client_master','furniture_quotation.client_id = new_client_master.client_id','left');
		$this->db->join('cust_bill_allocations', 'furniture_receipts.receipt_code = cust_bill_allocations.trn_no');
		$this->db->join('company_division','company_division.division_id = furniture_receipts.quotation_divisionid','inner');
		$this->db->join('furniture_invoice','furniture_invoice.invoice_id = cust_bill_allocations.bill_id','left');
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}else{
			return false;
		}
	}

	function get_all_payments_invdetails($receipt_no,$receipt_id,$quotation_divisionid){
		$where = array('furniture_payments.payment_number' => $receipt_no,'furniture_payments.quotation_divisionid' => $quotation_divisionid);
		//$where = array('furniture_receipts.quotation_divisionid' => $quotation_divisionid);
		$this->db->where($where);
		$this->db->select('payment_id,payment_date,`supplier_bill_allocations`.`bill_id` as invoice_id,purchase_invoice_code as invoice_number,pur_net_amt invoice_amount,0 as qoute_discount, `supplier_bill_allocations`.`bill_os_amount` as paid_amount,company_division.division_code,company_division.currency_code,pur_net_amt as invoice_percentage_amount,pur_discount as invoice_discount' );
		$this->db->from('furniture_payments');
		$this->db->join('supplier_bill_allocations', 'furniture_payments.payment_code = supplier_bill_allocations.trn_no');
		$this->db->join('company_division','company_division.division_id = furniture_payments.quotation_divisionid','inner');
		$this->db->join('purchase_h','purchase_h.id = supplier_bill_allocations.bill_id','left');
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}else{
			return false;
		}
	}

	function get_all_receipts_paydetails($receipt_no,$receipt_id,$quotation_divisionid){
		$where = array('furniture_receipts.receipt_number' => $receipt_no,'furniture_receipts.quotation_divisionid' => $quotation_divisionid);
		//$where = array('furniture_receipts.quotation_divisionid' => $quotation_divisionid);
		$this->db->where($where);
		$this->db->select('*' );
		//$this->db->from('furniture_receipts');
		$this->db->from('receipt_payment_details');
		$this->db->join('furniture_receipts','receipt_payment_details.receipt_id = furniture_receipts.receipt_id','inner');
		//$this->db->join('new_client_master','furniture_quotation.client_id = new_client_master.client_id','left');
		$rs = $this->db->get();
		//echo $this->db->last_query().'<br>';
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}else{
			return false;
		}

	}

	function get_all_payments_paydetails($receipt_no,$receipt_id,$quotation_divisionid){
		$where = array('furniture_payments.payment_number' => $receipt_no,'furniture_payments.quotation_divisionid' => $quotation_divisionid);
		//$where = array('furniture_receipts.quotation_divisionid' => $quotation_divisionid);
		$this->db->where($where);
		$this->db->select('payment_mode_details.payment_mode,payment_mode_details.name,payment_mode_details.amount,payment_mode_details.authorized');
		//$this->db->from('furniture_receipts');
		$this->db->from('payment_mode_details');
		$this->db->join('furniture_payments','payment_mode_details.payment_id = furniture_payments.payment_id','inner');
		//$this->db->join('new_client_master','furniture_quotation.client_id = new_client_master.client_id','left');
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}else{
			return false;
		}

	}

	function get_all_ledgers_from_accounts($payment_code){
		$where = array('accounts.vch_type' => 'PAYMENT','accounts.vch_no' => $payment_code,'accounts.vch_ref' => 'Ledger');
		$this->db->where($where);
		$this->db->select('accounts.*,ledgers.ledger_name');
		$this->db->from('accounts');
		$this->db->join('ledgers','accounts.ledger_code = ledgers.ledger_code','inner');
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}else{
			return false;
		}
	}

	function get_all_credit_notes_invdetails($receipt_no,$receipt_id,$quotation_divisionid){

		$where = array('credit_note.credit_note_number' => $receipt_no,'credit_note.quotation_divisionid' => $quotation_divisionid);
		//$where = array('furniture_receipts.quotation_divisionid' => $quotation_divisionid);
		$this->db->where($where);
		$this->db->select('credit_note_id,credit_note_date,`cust_bill_allocations`.`bill_id` as invoice_id,invoice_number,invoice_amount,qoute_discount, `cust_bill_allocations`.`bill_os_amount` as paid_amount,company_division.division_code,company_division.currency_code,invoice_percentage_amount,invoice_discount' );
		$this->db->from('credit_note');
		//$this->db->join('furniture_quotation','furniture_quotation.id = furniture_receipts.quotation_id','left');
		//$this->db->join('new_client_master','furniture_quotation.client_id = new_client_master.client_id','left');
		$this->db->join('cust_bill_allocations', 'credit_note.credit_note_code = cust_bill_allocations.trn_no');
		$this->db->join('company_division','company_division.division_id = credit_note.quotation_divisionid','inner');
		$this->db->join('furniture_invoice','furniture_invoice.invoice_id = cust_bill_allocations.bill_id','left');
		$rs = $this->db->get();
	
		//echo $this->db->last_query().'<br>';
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}else{
			return false;
		}
	}

	function get_all_debit_notes_invdetails($receipt_no,$receipt_id,$quotation_divisionid){

		$where = array('debit_note.debit_note_number' => $receipt_no,'debit_note.quotation_divisionid' => $quotation_divisionid);
		//$where = array('furniture_receipts.quotation_divisionid' => $quotation_divisionid);
		$this->db->where($where);
		$this->db->select('debit_note_id,debit_note_date,`supplier_bill_allocations`.`bill_id` as purchase_id,purchase_invoice_code,pur_net_amt as invoice_amount, `supplier_bill_allocations`.`bill_os_amount` as paid_amount,company_division.division_code,company_division.currency_code' );
		$this->db->from('debit_note');
		//$this->db->join('furniture_quotation','furniture_quotation.id = furniture_receipts.quotation_id','left');
		//$this->db->join('new_client_master','furniture_quotation.client_id = new_client_master.client_id','left');
		$this->db->join('supplier_bill_allocations', 'debit_note.debit_note_code = supplier_bill_allocations.trn_no');
		$this->db->join('company_division','company_division.division_id = debit_note.quotation_divisionid','inner');
		$this->db->join('purchase_h','purchase_h.id = supplier_bill_allocations.bill_id','left');
		$rs = $this->db->get();
	
		//echo $this->db->last_query().'<br>';
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}else{
			return false;
		}
	}

	function get_all_credit_notes($limit, $start,$division_id,$filter_by,$filter_value){
		$user_id	=	$this->session->userdata('user_id');
		$sql	=	" 1 ";
		if ($division_id!= "NIL") {
			$sql	.=	" AND FR.`quotation_divisionid`='$division_id'";
		}
		
		if ($filter_by!= "NIL" and $filter_value!= "NIL") {
			if($filter_by == 1) {
				$sql	.=	" AND FR.`credit_note_code` LIKE '%$filter_value%'";
			} else if ($filter_by == 2) {
				$sql	.=	" AND NCM.client_name LIKE '%$filter_value%'";
			}
		}

		$rs = $query= $this->db->query("SELECT FR.`credit_note_id`,FR.`credit_note_code`,FR.`quotation_divisionid`,FR.`quotation_id`,FR.`credit_note_number`,FR.credit_note_date,FR.credit_note_status,FR.credit_note_mode,FR.credit_note_reference,FR.credit_note_generatedby,FR.credit_note_cancelledby,FR.credit_note_cancelled_date,FR.net_amount,NCM.client_name,NCM.client_code,NCM.client_id FROM `credit_note` FR inner join new_client_master NCM on NCM.client_id=FR.client_id WHERE  ".$sql." GROUP BY FR.credit_note_id,FR.quotation_divisionid order by FR.`credit_note_id` desc limit ".$start.",".$limit);
	
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}else{
			return false;
		}
	}

	function get_all_debit_notes($limit, $start,$division_id,$filter_by,$filter_value){
		$user_id	=	$this->session->userdata('user_id');
		$sql	=	" 1 ";
		if ($division_id!= "NIL") {
			$sql	.=	" AND DN.`quotation_divisionid`='$division_id'";
		}
		
		if ($filter_by!= "NIL" and $filter_value!= "NIL") {
			if($filter_by == 1) {
				$sql	.=	" AND DN.`debit_note_code` LIKE '%$filter_value%'";
			} else if ($filter_by == 2) {
				$sql	.=	" AND SP.supplier_name LIKE '%$filter_value%'";
			}
		}

		$rs = $query= $this->db->query("SELECT DN.`debit_note_id`,DN.`debit_note_code`,DN.`quotation_divisionid`,DN.`quotation_id`,DN.`debit_note_number`,DN.debit_note_date,DN.debit_note_status,DN.net_amount,DN.debit_note_mode,DN.debit_note_reference,DN.debit_note_generatedby,DN.debit_note_cancelledby,DN.debit_note_cancelled_date,SP.`supplier_name`,SP.`supplier_code`,SP.`supplier_id` FROM `debit_note` DN inner join supplier_master SP on SP.`supplier_id`=DN.`supplier_id` WHERE  ".$sql." GROUP BY DN.debit_note_id,DN.quotation_divisionid order by DN.`debit_note_id` desc limit ".$start.",".$limit);
	
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}else{
			return false;
		}
	}

	public function debit_record_count($division_id,$filter_by,$filter_value) {
		$user_id	=	$this->session->userdata('user_id');
		$sql	=	" 1 ";
		//$sql	=	" FI.`quotation_divisionid` in  (SELECT `division_id` FROM `user_division_permissions` WHERE `user_id`='$user_id') ";
		if ($division_id!= "NIL") {
			$sql	.=	" AND DN.`quotation_divisionid`='$division_id'";
		}
		
		if ($filter_by!= "NIL" and $filter_value!= "NIL") {
			if($filter_by == 1) {
				$sql	.=	" AND DN.`debit_note_code` LIKE '%$filter_value%'";
			} else if ($filter_by == 2) {
				$sql	.=	" AND SP.supplier_name LIKE '%$filter_value%'";
			}
		}
		
		$result =   $this->db->query("SELECT count(DN.`debit_note_number`) AS `Tcount`  FROM `debit_note` DN inner join supplier_master SP on SP.`supplier_id`=DN.`supplier_id`  WHERE  ".$sql." ");
		return ($result->row()->Tcount);
	}

	function get_credit_note_details($receipt_no,$receipt_id,$quotation_divisionid){
		$where = array('credit_note.credit_note_number' => $receipt_no,'credit_note.quotation_divisionid' => $quotation_divisionid);
		//$where = array('furniture_receipts.quotation_divisionid' => $quotation_divisionid);
        $this->db->select('credit_note_reference,credit_note_code,credit_note_mode,ledger_name,credit_note.taxable_type,credit_note_number,credit_note_date,credit_note_status,net_amount,taxable_amount,tax_amount, credit_note_mode,new_client_master.client_name,client_code, credit_note_remarks, credit_note_generatedby,company_division.division_id,company_division.division_code,company_division.currency_code,company_division.currency_name,company_division.logo_filename' );
		$this->db->from('credit_note');
		$this->db->where($where);
		$this->db->group_by('credit_note_number');
		$this->db->group_by('credit_note.quotation_divisionid');
		//$this->db->join('furniture_quotation','furniture_quotation.id = furniture_receipts.quotation_id','left');
		//$this->db->join('new_client_master','furniture_quotation.client_id = new_client_master.client_id','left');
		$this->db->join('new_client_master','credit_note.client_id = new_client_master.client_id','left');
		$this->db->join('company_division','company_division.division_id = credit_note.quotation_divisionid','inner');
		$this->db->join('ledgers','ledgers.ledger_code = credit_note.led_code','left');
		$this->db->join('users','users.user_id = credit_note.credit_note_generatedby','left');
                $rs = $this->db->get();

		if($rs->num_rows() > 0){
			return $rs->result_array();
		}else{
			return false;
		}

	}

	function get_debit_note_details($receipt_no,$receipt_id,$quotation_divisionid){
		$where = array('debit_note.debit_note_number' => $receipt_no,'debit_note.quotation_divisionid' => $quotation_divisionid);
		//$where = array('furniture_receipts.quotation_divisionid' => $quotation_divisionid);
        $this->db->select('debit_note_reference,debit_note_code,debit_note_mode,ledger_name,debit_note.taxable_type,debit_note_number,debit_note_date,debit_note_status,net_amount,taxable_amount,tax_amount, debit_note_mode,supplier_master.supplier_name,supplier_code, debit_note_remarks, debit_note_generatedby,company_division.division_id,company_division.division_code,company_division.currency_code,company_division.currency_name,company_division.logo_filename' );
		$this->db->from('debit_note');
		$this->db->where($where);
		$this->db->group_by('debit_note_number');
		$this->db->group_by('debit_note.quotation_divisionid');
		//$this->db->join('furniture_quotation','furniture_quotation.id = furniture_receipts.quotation_id','left');
		//$this->db->join('new_client_master','furniture_quotation.client_id = new_client_master.client_id','left');
		$this->db->join('supplier_master ','debit_note.supplier_id = supplier_master.supplier_id','left');
		$this->db->join('company_division','company_division.division_id = debit_note.quotation_divisionid','inner');
		$this->db->join('ledgers','ledgers.ledger_code = debit_note.led_code','left');
		$this->db->join('users','users.user_id = debit_note.debit_note_generatedby','left');
                $rs = $this->db->get();

		if($rs->num_rows() > 0){
			return $rs->result_array();
		}else{
			return false;
		}

	}
	
	function get_receipt_details($receipt_no,$receipt_id,$quotation_divisionid){
		$where = array('furniture_receipts.receipt_number' => $receipt_no,'furniture_receipts.quotation_divisionid' => $quotation_divisionid);
		//$where = array('furniture_receipts.quotation_divisionid' => $quotation_divisionid);
        $this->db->select('receipt_id,receipt_reference,receipt_number,receipt_code,receipt_date,cheque_date,receipt_status,receipt_mode,receipt_amount,receipt_discount,new_client_master.client_name,new_client_master.client_code, receipt_remarks, receipt_bankname, receipt_generatedby,company_division.division_id,company_division.division_code,company_division.currency_code,company_division.currency_name,company_division.logo_filename' );
		$this->db->from('furniture_receipts');
		$this->db->where($where);
		$this->db->join('new_client_master','furniture_receipts.client_id = new_client_master.client_id','left');
		$this->db->join('company_division','company_division.division_id = furniture_receipts.quotation_divisionid','inner');
		$this->db->join('users','users.user_id = furniture_receipts.receipt_generatedby','left');
		$this->db->group_by('receipt_number');
		$this->db->group_by('furniture_receipts.quotation_divisionid');
		//$this->db->join('furniture_quotation','furniture_quotation.id = furniture_receipts.quotation_id','left');
		//$this->db->join('new_client_master','furniture_quotation.client_id = new_client_master.client_id','left');
		/*$this->db->join('receipts_details', 'furniture_receipts.receipt_id = receipts_details.receipt_id');
		
		$this->db->join('furniture_invoice','receipts_details.invoice_id = furniture_invoice.invoice_id','left');
		$this->db->join('furniture_quotation','furniture_invoice.quotation_id = furniture_quotation.id','left');*/
                $rs = $this->db->get();
			//	echo $this->db->last_query().'<br>';
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}else{
			return false;
		}

	}

	function get_payment_details($receipt_no,$receipt_id,$quotation_divisionid){
		$where = array('furniture_payments.payment_number' => $receipt_no,'furniture_payments.quotation_divisionid' => $quotation_divisionid);
		//$where = array('furniture_receipts.quotation_divisionid' => $quotation_divisionid);
        $this->db->select('payment_reference,payment_number,payment_code,payment_date,payment_status,payment_mode,payment_amount,payment_discount,supplier_master.supplier_name,supplier_master.supplier_code, payment_remarks, payment_bankname, payment_generatedby,company_division.division_id,company_division.division_code,company_division.currency_code,company_division.currency_name,company_division.logo_filename' );
		$this->db->from('furniture_payments');
		$this->db->where($where);
		$this->db->join('supplier_master','furniture_payments.client_id = supplier_master.supplier_id','left');
		$this->db->join('company_division','company_division.division_id = furniture_payments.quotation_divisionid','inner');
		$this->db->join('users','users.user_id = furniture_payments.payment_generatedby','left');
		$this->db->group_by('payment_number');
		$this->db->group_by('furniture_payments.quotation_divisionid');
        $rs = $this->db->get();
		//	echo $this->db->last_query().'<br>';
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}else{
			return false;
		}

	}

	function get_generated_receipts($quotation_id){
		$where = array('quotation_id' => $quotation_id, 'receipt_status' => 1);

        $this->db->select('sum(receipt_amount) rcpt_amount' );
		$this->db->from('furniture_receipts');
		$this->db->where($where);

        $rs = $this->db->get();

	    if($rs->num_rows() > 0){
			return $rs->result_array();
		} else{
			return 0;
		}
	}

	function get_credit_amount_for_invoice($invoice_id = NULL){
		$where = array('invoice_id' => $invoice_id);
		$this->db->select('total_credit_note_amount');
		$this->db->from('furniture_invoice');
		$this->db->where($where);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			$result = $rs->result_array();
			return $result[0]['total_credit_note_amount'];
		}else{
			return -1;
		}
	}

	function get_credit_amount_for_invoice_nb($invoice_id = NULL){
		$where = array('invoice_id' => $invoice_id,'credit_note_status' =>1);
		$this->db->select('sum(net_amount) as net_amount');
		$this->db->from('credit_note');
		$this->db->where($where);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			$result = $rs->result_array();
			return $result[0]['net_amount'];
		}else{
			return -1;
		}
	}


	function get_outstanding_invoices($client_id = NULL){

		$where = array('furniture_invoice.client_id' => $client_id);
		//$where = '(furniture_invoice.client_id =1 AND (invoice_amount > paid_amount))';
		$this->db->select('*');
		$this->db->from('furniture_invoice');
        $this->db->where($where);
        //$this->db->where('invoice_amount>','paid_amount');
		//$this->db->where('furniture_invoice.client_id', $client_id);
        //$this->db->where('invoice_amount > paid_amount');
        //$this->db->join('furniture_invoice','furniture_invoice.quotation_id = furniture_quotation.id','left');
		//$this->db->join('furniture_receipts','furniture_receipts.quotation_id = furniture_quotation.id','left');
		$this->db->join('new_client_master','new_client_master.client_id = furniture_invoice.client_id','left');
		$this->db->group_by("furniture_invoice.invoice_id");
		$rs = $this->db->get();
		//echo $this->db->last_query().'<br>';
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}else{
			return false;
		}
	}
	function get_outstanding_invoices_new($client_id = NULL,$ref_division=NULL){

		//$where = array('furniture_invoice.client' => $client_id, 'furniture_invoice.invoice_amount ' > 'furniture_invoice.paid_amount');
		$where = '(furniture_invoice.client_id ="'.$client_id.'" AND furniture_invoice.quotation_divisionid ="'.$ref_division.'" AND (invoice_percentage_amount-(invoice_discount))>(paid_amount+receipt_discount+total_credit_note_amount) AND invoice_status!="1")';
		$this->db->select('*');
		$this->db->from('furniture_invoice');
		$this->db->where($where);
        //$this->db->where('invoice_amount>','paid_amount');
		//$this->db->where('furniture_invoice.client_id', $client_id);
        //$this->db->where('invoice_amount > paid_amount');
        //$this->db->join('furniture_invoice','furniture_invoice.quotation_id = furniture_quotation.id','left');
		$this->db->join('company_division','company_division.division_id=furniture_invoice.quotation_divisionid','inner');
		$this->db->join('new_client_master','new_client_master.client_id=furniture_invoice.client_id','left');
		$this->db->group_by("furniture_invoice.invoice_id");
        
		$rs = $this->db->get();
		//echo $this->db->last_query().'<br>';
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}else{
			return false;
		}
	}

	function get_outstanding_invoices_new2($client_id = NULL,$ref_division=NULL,$journal_code=NULL){
		if($journal_code != ''){
			$where = " and CBA.`trn_no`!='$journal_code'";
		} else {
			$where = "";
		}
		$result = $this->db->query("SELECT `bill_type`,`bill_amt` AS invoice_amount,sum(`bill_os_amount`) as balance_amount,(`bill_amt`-sum(`bill_os_amount`)) as paid_amount,CBA.`trn_no` AS invoice_number,CBA.bill_id as invoice_id,bill_date as invoice_date,IF(sum(`bill_os_amount`)>0, 1, 0) as nb_order,`sm_id`,CBA.`customer_code` FROM `cust_bill_allocations` CBA  WHERE CBA.`customer_code`='$client_id' and CBA.`division_id`='$ref_division' and CBA.`status`='1' ".$where." Group by CBA.`bill_id` having balance_amount!=0 order by nb_order,invoice_date asc ");
        if($result->num_rows() > 0){
			return $result->result_array();
		}else{
			return false;
		}
	}

	function get_outstanding_payment($client_id = NULL,$ref_division=NULL,$journal_code=NULL){
		if($journal_code != ''){
			$where = " and CBA.`trn_no`!='$journal_code'";
		}else{
			$where = "";
		}
		//$where = array('furniture_invoice.client_id' => $client_id);
		//$where = '(furniture_invoice.client_id ="'.$client_id.'" AND furniture_invoice.invoice_amount > furniture_invoice.paid_amount)';
		 $result = $this->db->query("SELECT `bill_type`,`bill_amt` AS invoice_amount,round(sum(`bill_os_amount`),3) as balance_amount,ROUND(`bill_amt`-SUM(`bill_os_amount`), 3) as paid_amount,CBA.`trn_no` AS invoice_number,CBA.bill_id as invoice_id,bill_date as invoice_date,IF(sum(`bill_os_amount`)>0, 1, 0) as nb_order,CBA.`sup_ref`,CBA.`supplier_code` FROM `supplier_bill_allocations` CBA  WHERE CBA.`supplier_code`='$client_id' and CBA.`division_id`='$ref_division' and CBA.`status`='1' ".$where." Group by CBA.`bill_id` having balance_amount!=0 order by nb_order,invoice_date asc ");
        
		 if($result->num_rows() > 0){
			return $result->result_array();
		}else{
			return false;
		}
	}
	
	function get_confirmed_quotes($client_id = NULL){
		
		$where = array('furniture_quotation.client_id' => $client_id );
		$this->db->select('*');
		$this->db->from('furniture_quotation');
		$this->db->where($where);
		//$this->db->join('furniture_invoice','furniture_invoice.quotation_id = furniture_quotation.id','left');
		//$this->db->join('furniture_receipts','furniture_receipts.quotation_id = furniture_quotation.id','left');
		$this->db->join('new_client_master','new_client_master.client_id = furniture_invoice.client_id','left');
		$this->db->order_by("furniture_invoice.invoice_id");
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}else{
			return false;
		}
	}
	
	function get_paid_receipts_total($quotation_id = NULL){
		$where = array('quotation_id' => $quotation_id, 'receipt_status' => 1 );
		
		$this->db->select_sum('receipt_amount');
		$this->db->from('furniture_receipts');
		$this->db->where($where);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			$result = $rs->result_array();
			return $result[0]['receipt_amount'];
		}else{
			return 0;
		}
	}
	
	function get_confirmed_quotations($client_id = NULL, $not_included_quotations = array()){

		$SQL = "select * FROM  `furniture_quotation` INNER JOIN new_client_master ON furniture_quotation.client_id = new_client_master.client_id
				WHERE furniture_quotation.client_id =". $client_id ."and quotation_status =  'Confirmed' AND furniture_quotation.id NOT IN
				(SELECT quotation_id FROM furniture_invoice WHERE client_id =".$client_id.");";
		$result = $this->db->query($SQL);
		$rs = $result->result_array();
		 /*
			$where = array('client_id' => $client_id, 'quotation_status' => 'Confirmed' );
			$this->db->select('*');
			$this->db->from('furniture_quotation');
			$this->db->where($where);
			if(!empty($not_included_quotations)){
				$this->db->where_not_in('id', $not_included_quotations);
			}
			$rs = $this->db->get();
        */
        //echo $rs->num_rows(); 
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}else{
			return false;
		}
	}
	
	function get_paid_amount_for_quotation($quotation_id = NULL){
		$where = array('quotation_id' => $quotation_id);
		$this->db->select('paid_amount');
		$this->db->from('furniture_invoice');
		$this->db->where($where);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			$result = $rs->result_array();
			return $result[0]['paid_amount'];
		}else{
			return -1;
		}
	}
	function get_paid_amount_for_invoice($invoice_id = NULL){
		$where = array('invoice_id' => $invoice_id);
		$this->db->select('paid_amount');
		$this->db->from('furniture_invoice');
		$this->db->where($where);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			$result = $rs->result_array();
			return $result[0]['paid_amount'];
		}else{
			return -1;
		}
	}
	function get_receipt_discount_for_invoice($invoice_id = NULL){
		$where = array('invoice_id' => $invoice_id);
		$this->db->select('receipt_discount');
		$this->db->from('furniture_invoice');
		$this->db->where($where);
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			$result = $rs->result_array();
			return $result[0]['receipt_discount'];
		}else{
			return -1;
		}
	}
	
	public function listData($limit, $start,$fromDate,$toDate,$user_id){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		if($fromDate!='NIL' and $toDate!='NIL') {
			$sql .="  AND FI.`invoice_date` between '$fromDate' and '$toDate'  ";
		} else if($fromDate!='NIL' and $toDate=='NIL'){
			$sql .=" and FI.`invoice_date`	>=	'$fromDate' ";
		} else if($fromDate=='NIL' and $toDate!='NIL'){
			$sql .=" and FI.`invoice_date`	<=	'$toDate' ";
		}
		if ($user_id != "NIL"){
			$sql	.= " AND FI.created_id='$user_id'";
		}
		
		
        $query= $this->db->query("SELECT FI.`invoice_id`,FI.`quotation_divisionid`,FI.`invoice_number`,FI.`invoice_date`,FI.`invoice_amount`,FI.`invoice_percentage`,FI.`invoice_percentage_amount`,FI.`invoice_discount`,FI.`qoute_discount`,FI.`paid_amount`,FI.`receipt_discount`,FI.`client_id`,FI.`invoice_vat_amount`,FI.`invoice_created_by`,CD.`division_code`,NCM.`client_name` FROM `furniture_invoice` FI INNER JOIN `company_division` CD ON CD.division_id = FI.quotation_divisionid LEFT JOIN `new_client_master` NCM ON NCM.client_id = FI.client_id WHERE FI.`invoice_status`='0' and FI.`invoice_discount`>0  ".$sql." order by FI.`invoice_id` desc limit ".$start.",".$limit);
		return $query->result();
    }
	
	public function record_count($fromDate,$toDate,$user_id) {
        $sql='';
		if($fromDate!='NIL' and $toDate!='NIL') {
			$sql .="  AND FI.`invoice_date` between '$fromDate' and '$toDate'  ";
		} else if($fromDate!='NIL' and $toDate=='NIL'){
			$sql .=" and FI.`invoice_date`	>=	'$fromDate' ";
		} else if($fromDate=='NIL' and $toDate!='NIL'){
			$sql .=" and FI.`invoice_date`	<=	'$toDate' ";
		}
		if ($user_id != "NIL"){
			$sql	.= " AND FI.created_id='$user_id'";
		}
		
		$result =   $this->db->query("SELECT count(FI.`invoice_number`) AS `Tcount` FROM `furniture_invoice` FI INNER JOIN `company_division` CD ON CD.division_id = FI.quotation_divisionid LEFT JOIN `new_client_master` NCM ON NCM.client_id = FI.client_id  WHERE FI.`invoice_status`='0' and FI.`invoice_discount`>0 ".$sql);
        return ($result->row()->Tcount);
    }
	
	public function billoutstandinglist($limit, $start,$fromDate,$client_id,$user_id,$division){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		if($fromDate!='NIL') {
			$sql .=" AND  DATE(furniture_quotation.`quotation_confirmationdate`) <= '$fromDate'  ";
		}
		if($client_id!='NIL') {
			$sql .=" AND  new_client_master.`client_id`='$client_id'  ";
		}
		if($user_id!='NIL') {
			$sql .=" AND  furniture_quotation.`salesman_id`='$user_id'  ";
		}
		if($division!='NIL') {
			$sql .=" AND furniture_quotation.`quotation_divisionid` = '$division'  ";
		}
		/*if($fromDate!='NIL' and $toDate!='NIL') {
			$sql .="  AND FI.`invoice_date` between '$fromDate' and '$toDate'  ";
		} else if($fromDate!='NIL' and $toDate=='NIL'){
			$sql .=" and FI.`invoice_date`	>=	'$fromDate' ";
		} else if($fromDate=='NIL' and $toDate!='NIL'){
			$sql .=" and FI.`invoice_date`	<=	'$toDate' ";
		}
		if ($user_id != "NIL"){
			$sql	.= " AND FI.created_id='$user_id'";
		}*/
		
		$this->db->query("SET SQL_BIG_SELECTS=1");
        $query= $this->db->query("SELECT * FROM ( SELECT
    CONCAT(
        division_code,
        '-',
        furniture_quotation.quotation_number,
        '-',
        furniture_quotation.quotation_revisionnumber,
        ''
    ) AS qout_no,
    IF(
        furniture_quotation.`quotation_confirmationdate` >= '2019-07-01',
        ROUND(
            (
                furniture_quotation.quotation_total - furniture_quotation.quotation_discount
            ) +(
                (
                    furniture_quotation.quotation_total - furniture_quotation.quotation_discount
                ) * 0.05
            ),
            3
        ),
        ROUND(
            (
                furniture_quotation.quotation_total - furniture_quotation.quotation_discount
            ),
            3
        )
    ) AS quote_amount,
    new_client_master.client_name,
    invoice_number,
    invoice_date,
	total_credit_note_amount,
    ROUND(SUM(
        (
            invoice_percentage_amount - invoice_discount
        )),
        3
    ) AS invoice_amount,
    SUM(paid_amount) AS paid_amount,
    ROUND(SUM(invoice_discount+receipt_discount),3) as discount,
    ROUND(
        IF(
            furniture_quotation.`quotation_confirmationdate` >= '2019-07-01',
            ROUND(
                (
                    furniture_quotation.quotation_total - furniture_quotation.quotation_discount
                ) +(
                    (
                        furniture_quotation.quotation_total - furniture_quotation.quotation_discount
                    ) * 0.05
                ),
                3
            ),
            ROUND(
                (
                    furniture_quotation.quotation_total - furniture_quotation.quotation_discount
                ),
                3
            )
        ) -(
            SUM(invoice_percentage_amount)
        ),
        3
    ) AS UnInvoiced_amount,
    ROUND(
        (IF(
            furniture_quotation.`quotation_confirmationdate` >= '2019-07-01',
            ROUND(
                (
                    furniture_quotation.quotation_total - furniture_quotation.quotation_discount
                ) +(
                    (
                        furniture_quotation.quotation_total - furniture_quotation.quotation_discount
                    ) * 0.05
                ),
                3
            ),
            ROUND(
                (
                    furniture_quotation.quotation_total - furniture_quotation.quotation_discount
                ),
                3
            )
        )
		-SUM(invoice_percentage_amount)
		)+SUM(((invoice_percentage_amount - invoice_discount)-(paid_amount + receipt_discount+total_credit_note_amount))
        ),
        3
    ) AS balance,
    division_code,
	furniture_quotation.`quotation_confirmationdate`,furniture_quotation.id,
	new_client_master.client_id,new_client_master.`client_name` as nname,furniture_quotation.quotation_number,furniture_quotation.quotation_revisionnumber,users.`user_name` AS salesman
	FROM
		`furniture_quotation`
	INNER JOIN furniture_invoice ON furniture_invoice.quotation_id = furniture_quotation.id
	INNER JOIN new_client_master ON furniture_invoice.client_id = new_client_master.client_id
	INNER JOIN users ON furniture_quotation.`salesman_id`=users.`user_id`
	LEFT JOIN company_division ON furniture_invoice.quotation_divisionid = company_division.division_id
	WHERE  invoice_status != 1 AND furniture_quotation.quotation_status = 'Confirmed' ".$sql." GROUP BY furniture_quotation.id
	HAVING balance!= 0

		UNION ALL 
		SELECT CONCAT(division_code,'-',furniture_quotation.quotation_number,'-',furniture_quotation.quotation_revisionnumber,'') AS qout_no,IF( furniture_quotation.`quotation_confirmationdate`>= '2019-07-01',ROUND((furniture_quotation.quotation_total - furniture_quotation.quotation_discount)+((furniture_quotation.quotation_total - furniture_quotation.quotation_discount) * 0.05),3),ROUND((furniture_quotation.quotation_total - furniture_quotation.quotation_discount),3)) AS quote_amount,new_client_master.client_name,invoice_number,invoice_date,total_credit_note_amount,ROUND((invoice_percentage_amount - invoice_discount),3) AS invoice_amount,paid_amount,ROUND(invoice_discount+receipt_discount,3) as discount,
		ROUND(IF(furniture_quotation.`quotation_confirmationdate` >= '2019-07-01',ROUND((furniture_quotation.quotation_total - furniture_quotation.quotation_discount) +((furniture_quotation.quotation_total - furniture_quotation.quotation_discount) * 0.05),3), ROUND((furniture_quotation.quotation_total - furniture_quotation.quotation_discount),3)) -(invoice_percentage_amount),3) AS UnInvoiced_amount,IF( furniture_quotation.`quotation_confirmationdate`>= '2019-07-01',ROUND((furniture_quotation.quotation_total - furniture_quotation.quotation_discount)+((furniture_quotation.quotation_total - furniture_quotation.quotation_discount) * 0.05),3),ROUND((furniture_quotation.quotation_total - furniture_quotation.quotation_discount),3)) AS balance,division_code,furniture_quotation.`quotation_confirmationdate`,furniture_quotation.id,new_client_master.client_id,new_client_master.`client_name` as nname,furniture_quotation.quotation_number,furniture_quotation.quotation_revisionnumber,users.`user_name` AS salesman FROM `furniture_quotation`
	INNER JOIN users ON furniture_quotation.`salesman_id`=users.`user_id` LEFT JOIN new_client_master ON furniture_quotation.`client_id` = new_client_master.client_id LEFT JOIN company_division ON furniture_quotation.`quotation_divisionid` = company_division.division_id LEFT JOIN furniture_invoice ON furniture_invoice.quotation_id = furniture_quotation.id
	WHERE  furniture_quotation.quotation_status = 'Confirmed'  AND furniture_invoice.quotation_id IS NULL ".$sql." ) AS T  ORDER BY quotation_confirmationdate desc,id asc
		");
			return $query->result();
    }
	
	
	public function record_count_b($fromDate) {
        $sql='';
		/*if($fromDate!='NIL' and $toDate!='NIL') {
			$sql .="  AND FI.`invoice_date` between '$fromDate' and '$toDate'  ";
		} else if($fromDate!='NIL' and $toDate=='NIL'){
			$sql .=" and FI.`invoice_date`	>=	'$fromDate' ";
		} else if($fromDate=='NIL' and $toDate!='NIL'){
			$sql .=" and FI.`invoice_date`	<=	'$toDate' ";
		}
		if ($user_id != "NIL"){
			$sql	.= " AND FI.created_id='$user_id'";
		}*/
		
		$result =   $this->db->query("SELECT count(FI.`invoice_number`) AS `Tcount` FROM `furniture_invoice` FI INNER JOIN `company_division` CD ON CD.division_id = FI.quotation_divisionid LEFT JOIN `new_client_master` NCM ON NCM.client_id = FI.client_id  WHERE FI.`invoice_status`='0' and FI.`invoice_discount`>0 ".$sql);
        return ($result->row()->Tcount);
    }
	
	
	public function billoutstandinglist2($limit, $start,$fromDate,$client_id,$user_id,$division){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		if($fromDate!='NIL') {
			$sql .=" AND  DATE(furniture_quotation.`quotation_confirmationdate`) <= '$fromDate'  ";
		}
		if($client_id!='NIL') {
			$sql .=" AND  new_client_master.`client_id`='$client_id'  ";
		}
		if($user_id!='NIL') {
			$sql .=" AND  furniture_quotation.`salesman_id`='$user_id'  ";
		}
		if($division!='NIL') {
			$sql .=" AND furniture_quotation.`quotation_divisionid` = '$division'  ";
		}
		/*if($fromDate!='NIL' and $toDate!='NIL') {
			$sql .="  AND FI.`invoice_date` between '$fromDate' and '$toDate'  ";
		} else if($fromDate!='NIL' and $toDate=='NIL'){
			$sql .=" and FI.`invoice_date`	>=	'$fromDate' ";
		} else if($fromDate=='NIL' and $toDate!='NIL'){
			$sql .=" and FI.`invoice_date`	<=	'$toDate' ";
		}
		if ($user_id != "NIL"){
			$sql	.= " AND FI.created_id='$user_id'";
		}*/
		
		$this->db->query("SET SQL_BIG_SELECTS=1");
        $query= $this->db->query("SELECT * FROM ( SELECT
    CONCAT(
        division_code,
        '-',
        furniture_quotation.quotation_number,
        '-',
        furniture_quotation.quotation_revisionnumber,
        ''
    ) AS qout_no,
    IF(
        furniture_quotation.`quotation_confirmationdate` >= '2019-07-01',
        ROUND(
            (
                furniture_quotation.quotation_total - furniture_quotation.quotation_discount
            ) +(
                (
                    furniture_quotation.quotation_total - furniture_quotation.quotation_discount
                ) * 0.05
            ),
            3
        ),
        ROUND(
            (
                furniture_quotation.quotation_total - furniture_quotation.quotation_discount
            ),
            3
        )
    ) AS quote_amount,
    new_client_master.client_name,
    invoice_number,
    invoice_date,
	total_credit_note_amount,
    ROUND(SUM(
        (
            invoice_percentage_amount - invoice_discount
        )),
        3
    ) AS invoice_amount,
    SUM(paid_amount) AS paid_amount,
    ROUND(SUM(invoice_discount+receipt_discount),3) as discount,
    ROUND(
        IF(
            furniture_quotation.`quotation_confirmationdate` >= '2019-07-01',
            ROUND(
                (
                    furniture_quotation.quotation_total - furniture_quotation.quotation_discount
                ) +(
                    (
                        furniture_quotation.quotation_total - furniture_quotation.quotation_discount
                    ) * 0.05
                ),
                3
            ),
            ROUND(
                (
                    furniture_quotation.quotation_total - furniture_quotation.quotation_discount
                ),
                3
            )
        ) -(
            SUM(invoice_percentage_amount)
        ),
        3
    ) AS UnInvoiced_amount,
    ROUND(
        (IF(
            furniture_quotation.`quotation_confirmationdate` >= '2019-07-01',
            ROUND(
                (
                    furniture_quotation.quotation_total - furniture_quotation.quotation_discount
                ) +(
                    (
                        furniture_quotation.quotation_total - furniture_quotation.quotation_discount
                    ) * 0.05
                ),
                3
            ),
            ROUND(
                (
                    furniture_quotation.quotation_total - furniture_quotation.quotation_discount
                ),
                3
            )
        )
		-SUM(invoice_percentage_amount)
		)+SUM(((invoice_percentage_amount - invoice_discount)-(paid_amount + receipt_discount+total_credit_note_amount))
        ),
        3
    ) AS balance,
    division_code,
	furniture_quotation.`quotation_confirmationdate`,furniture_quotation.id,
	new_client_master.client_id,new_client_master.`client_name` as nname,furniture_quotation.quotation_number,furniture_quotation.quotation_revisionnumber,users.`user_name` AS salesman
	FROM
		`furniture_quotation`
	INNER JOIN furniture_invoice ON furniture_invoice.quotation_id = furniture_quotation.id
	INNER JOIN new_client_master ON furniture_invoice.client_id = new_client_master.client_id
	INNER JOIN users ON furniture_quotation.`salesman_id`=users.`user_id`
	LEFT JOIN company_division ON furniture_invoice.quotation_divisionid = company_division.division_id
	WHERE  invoice_status != 1 AND furniture_quotation.quotation_status = 'Confirmed' ".$sql." GROUP BY furniture_quotation.id
	HAVING balance!= 0

		UNION ALL 
		SELECT CONCAT(division_code,'-',furniture_quotation.quotation_number,'-',furniture_quotation.quotation_revisionnumber,'') AS qout_no,IF( furniture_quotation.`quotation_confirmationdate`>= '2019-07-01',ROUND((furniture_quotation.quotation_total - furniture_quotation.quotation_discount)+((furniture_quotation.quotation_total - furniture_quotation.quotation_discount) * 0.05),3),ROUND((furniture_quotation.quotation_total - furniture_quotation.quotation_discount),3)) AS quote_amount,new_client_master.client_name,invoice_number,invoice_date,total_credit_note_amount,ROUND((invoice_percentage_amount - invoice_discount),3) AS invoice_amount,paid_amount,ROUND(invoice_discount+receipt_discount,3) as discount,
		ROUND(IF(furniture_quotation.`quotation_confirmationdate` >= '2019-07-01',ROUND((furniture_quotation.quotation_total - furniture_quotation.quotation_discount) +((furniture_quotation.quotation_total - furniture_quotation.quotation_discount) * 0.05),3), ROUND((furniture_quotation.quotation_total - furniture_quotation.quotation_discount),3)) -(invoice_percentage_amount),3) AS UnInvoiced_amount,IF( furniture_quotation.`quotation_confirmationdate`>= '2019-07-01',ROUND((furniture_quotation.quotation_total - furniture_quotation.quotation_discount)+((furniture_quotation.quotation_total - furniture_quotation.quotation_discount) * 0.05),3),ROUND((furniture_quotation.quotation_total - furniture_quotation.quotation_discount),3)) AS balance,division_code,furniture_quotation.`quotation_confirmationdate`,furniture_quotation.id,new_client_master.client_id,new_client_master.`client_name` as nname,furniture_quotation.quotation_number,furniture_quotation.quotation_revisionnumber,users.`user_name` AS salesman FROM `furniture_quotation`
	INNER JOIN users ON furniture_quotation.`salesman_id`=users.`user_id` LEFT JOIN new_client_master ON furniture_quotation.`client_id` = new_client_master.client_id LEFT JOIN company_division ON furniture_quotation.`quotation_divisionid` = company_division.division_id LEFT JOIN furniture_invoice ON furniture_invoice.quotation_id = furniture_quotation.id
	WHERE  furniture_quotation.quotation_status = 'Confirmed'  AND furniture_invoice.quotation_id IS NULL ".$sql." ) AS T  ORDER BY `nname` asc,quotation_confirmationdate asc,id asc
		");
		return $query->result_array();
    }

 	// function estimation_config(){
	// 	$query = $this->db->query("SELECT * FROM `company_details`");
	// 	//print("SELECT * FROM `company_details`");
	// 	//	$data	=	$query->result_array();
	// 	//	$data = $rs->result_array();
	// 			//return $data[0]['invoice_date'];
	// 	//print_r($data);
	// 	return $query->row()->is_estimate;
	// }
	
	function estimation_config(){
		$user_division   =   $this->session->userdata('user_division');
		$query = $this->db->query("SELECT `status` FROM `config_settings` WHERE division_id='$user_division' and `config_name`= 'is_estimate'");		
		return $query->row()->status;
	}

	function config($division_id){
		$query = $this->db->query("SELECT division_id,is_quote_from_master,is_estimate,is_approve,is_bom,is_optional_item_level,is_category FROM `company_division` where division_id='$division_id'");
		return $query->row();
	}

	public function nbget_all_receipts($limit, $start,$fromDate,$toDate,$division_id,$receipt_no,$client_id){
		$user_id	=	$this->session->userdata('user_id');
		$sql	=	" 1 ";
		//$sql	=	" FI.`quotation_divisionid` in  (SELECT `division_id` FROM `user_division_permissions` WHERE `user_id`='$user_id') ";

		if($fromDate!='NIL' and $toDate!='NIL') {
			$sql .="  AND date(FR.receipt_date) between '$fromDate' and '$toDate'  ";
		} else if($fromDate!='NIL' and $toDate=='NIL'){
			$sql .=" and date(FR.receipt_date)	>=	'$fromDate' ";
		} else if($fromDate=='NIL' and $toDate!='NIL'){
			$sql .=" and date(FR.receipt_date)	<=	'$toDate' ";
		}

		if ($division_id!= "NIL") {
			$sql	.=	" AND FR.`quotation_divisionid`='$division_id'";
		}
		
		if ($receipt_no!= "NIL") {
			$sql	.=	" AND FR.`receipt_code` LIKE '%$receipt_no%'";
		}

		if ($client_id!= "NIL") {
			$sql	.=	" AND FR.`client_id`='$client_id'";
		}
		
		$query= $this->db->query("SELECT FR.`receipt_id`,FR.`receipt_code`,FR.`quotation_divisionid`,FR.`quotation_id`,FR.`receipt_number`,FR.receipt_date,FR.receipt_status,FR.receipt_mode,FR.receipt_reference,FR.receipt_generatedby,FR.receipt_cancelledby,FR.receipt_cancelled_date,FR.receipt_amount,NCM.client_name,NCM.client_code,NCM.client_id FROM `furniture_receipts` FR inner join new_client_master NCM on NCM.client_id=FR.client_id WHERE  ".$sql." GROUP BY FR.receipt_id,FR.quotation_divisionid order by FR.`receipt_id` desc limit ".$start.",".$limit);
		//echo $this->db->last_query().'<br>';
		return $query->result_array();
	}

	public function rnbrecord_count($fromDate,$toDate,$division_id,$receipt_no,$client_id) {
		$user_id	=	$this->session->userdata('user_id');
		$sql	=	" 1 ";
		//$sql	=	" FI.`quotation_divisionid` in  (SELECT `division_id` FROM `user_division_permissions` WHERE `user_id`='$user_id') ";

		if($fromDate!='NIL' and $toDate!='NIL') {
			$sql .="  AND date(FR.receipt_date) between '$fromDate' and '$toDate'  ";
		} else if($fromDate!='NIL' and $toDate=='NIL'){
			$sql .=" and date(FR.receipt_date)	>=	'$fromDate' ";
		} else if($fromDate=='NIL' and $toDate!='NIL'){
			$sql .=" and date(FR.receipt_date)	<=	'$toDate' ";
		}
		if ($division_id!= "NIL") {
			$sql	.=	" AND FI.`quotation_divisionid`='$division_id'";
		}
		
		if ($receipt_no!= "NIL") {
			$sql	.=	" AND FR.`receipt_code` LIKE '%$receipt_no%'";
		}

		if ($client_id!= "NIL") {
			$sql	.=	" AND FR.`client_id`='$client_id'";
		}
		
		$result =   $this->db->query("SELECT count(T.`receipt_number`) AS `Tcount` FROM (SELECT FR.`receipt_number`  FROM `furniture_receipts` FR INNER JOIN `company_division` CD ON CD.`division_id`=FR.`quotation_divisionid` LEFT JOIN `furniture_invoice` FI ON FI.`invoice_id`=FR.`invoice_id` WHERE  ".$sql." GROUP BY FR.receipt_number,FR.quotation_divisionid ) as T");
		return ($result->row()->Tcount);
	}

	public function payrecord_count($division_id,$filter_by,$filter_value) {
		$user_id	=	$this->session->userdata('user_id');
		$sql	=	" 1 ";
		//$sql	=	" FI.`quotation_divisionid` in  (SELECT `division_id` FROM `user_division_permissions` WHERE `user_id`='$user_id') ";
		/* if ($division_id!= "NIL") {
			$sql	.=	" AND FI.`quotation_divisionid`='$division_id'";
		}
		
		if ($filter_by!= "NIL" and $filter_value!= "NIL") {
			if($filter_by == 1) {
				$sql	.=	" AND FR.`receipt_number` LIKE '%$filter_value%'";
			} else if ($filter_by == 2) {
				$sql	.=	" AND FI.`client` LIKE '%$filter_value%'";
			}
		} */
		
		$result =   $this->db->query("SELECT count(`purchase_no`) AS `Tcount`  FROM `purchase_h` FR  WHERE  1 ");
		return ($result->row()->Tcount);
	}

	public function cnbbrecord_count($division_id,$filter_by,$filter_value) {
		$user_id	=	$this->session->userdata('user_id');
		$sql	=	" 1 ";
		//$sql	=	" FI.`quotation_divisionid` in  (SELECT `division_id` FROM `user_division_permissions` WHERE `user_id`='$user_id') ";
		if ($division_id!= "NIL") {
			$sql	.=	" AND FI.`quotation_divisionid`='$division_id'";
		}
		
		if ($filter_by!= "NIL" and $filter_value!= "NIL") {
			if($filter_by == 1) {
				$sql	.=	" AND FR.`receipt_number` LIKE '%$filter_value%'";
			} else if ($filter_by == 2) {
				$sql	.=	" AND FI.`client` LIKE '%$filter_value%'";
			}
		}
		
		$result =   $this->db->query("SELECT count(`credit_note_id`) AS `Tcount`  FROM `credit_note` FR  WHERE  1 ");
		return ($result->row()->Tcount);
	}

	public function get_all_payments($limit, $start,$division_id,$filter_by,$filter_value){
		$user_id	=	$this->session->userdata('user_id');
		$sql	=	" 1 ";
		//$sql	=	" FI.`quotation_divisionid` in  (SELECT `division_id` FROM `user_division_permissions` WHERE `user_id`='$user_id') ";
		if ($division_id!= "NIL") {
			$sql	.=	" AND FI.`quotation_divisionid`='$division_id'";
		}
		
		if ($filter_by!= "NIL" and $filter_value!= "NIL") {
			if($filter_by == 1) {
				$sql	.=	" AND FR.`payment_code` LIKE '%$filter_value%'";
			} else if ($filter_by == 2) {
				$sql	.=	" AND FI.`client` LIKE '%$filter_value%'";
			}
		}
		
		$query= $this->db->query("SELECT FR.`payment_id`,FR.`payment_code`,FR.`quotation_divisionid`,FR.`quotation_id`,FR.`payment_number`,FR.payment_date,FR.payment_status,FR.payment_mode,FR.payment_reference,FR.payment_generatedby,FR.payment_cancelledby,FR.payment_cancelled_date,FR.payment_amount,NCM.supplier_name,NCM.supplier_code,NCM.supplier_id FROM `furniture_payments` FR inner join supplier_master NCM on NCM.supplier_id=FR.client_id WHERE  ".$sql." GROUP BY FR.payment_id,FR.quotation_divisionid order by FR.`payment_id` desc limit ".$start.",".$limit);
		//echo $this->db->last_query().'<br>';
		return $query->result_array();
	}

	public function qlistData($limit, $start,$type,$client_id,$telephone,$quotation_number,$project,$user_id){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		if ($type != "NIL"){
			if ($type === "All") {
				$sql	.= " (E.`quotation_status`='Draft' OR E.`quotation_status`='Open' OR E.`quotation_status`='Closed' OR E.`quotation_status`='Confirmed')";
			}  else {
				$sql	.= " E.`quotation_status`='$type'";
			}
		}  else {
			$sql	.= " (E.`quotation_status`='Draft' OR E.`quotation_status`='Open' OR E.`quotation_status`='Closed' OR E.`quotation_status`='Confirmed')";
		}
		$is_salesman = $this->session->userdata('is_salesman');
		$logged_user_id = $this->session->userdata('user_id');

		$is_user_type = $this->session->userdata('is_user_type');
		
		if( $this->session->userdata('user_group_id') != 1 and $this->session->userdata('user_group_id')!=10 ) {
			if ($is_user_type!='') {
				if ($is_salesman != 1) {
					$sql    .= "  and E.`status` in ($is_user_type) ";
				}
			}
		}
		//and  $this->session->userdata('user_group_id') != 1 
		if ($is_salesman == 1) {
			if( $this->session->userdata('user_group_id') != 1 and $this->session->userdata('user_group_id')!=10 ) {
				$sql    .= "  and E.`salesman_id`='$logged_user_id' ";
			}
		} else {
			$sql    .=   "  ";
		}	
		
		if ($client_id != "NIL"){
			$sql	.= " and E.`client_id`='$client_id'";
		}
		if ($telephone != "NIL"){
			$sql	.= " and ( E.`client_telephone1` Like '%$telephone%' OR E.`client_telephone2` Like '%$telephone%'  OR E.`Contact_Tel` Like '%$telephone%' )";
		}
		if ($quotation_number != "NIL"){
			$sql	.= " and (E.`quotation_number_full` like '%$quotation_number%' )";
		}

		if ($project != "NIL"){
			$sql	.= " and (E.`project_name` like '%$project%' )";
		}

		if ($user_id != "NIL") {
			$sql    .= "  and E.`salesman_id`='$user_id' ";
		} else {
			$sql    .=   "  ";
		}	
		
		if ($type === "Confirmed"){
			$order_by=' order by E.`quotation_confirmationdate` desc';
		} else {
			$order_by=' order by E.`quotation_id` desc';
		}
		
		$query= $this->db->query("SELECT * FROM `view_furniture_quotations_client_project_users` E  WHERE ".$sql." group by E.`quotation_id` ".$order_by." limit ".$start.",".$limit);
		
		return $query->result();
	}

	public function record_qcount($type,$client_id,$telephone,$quotation_number,$project,$user_id) {
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		if ($type != "NIL"){
			if ($type === "All") {
				$sql	.= " (E.`quotation_status`='Draft' OR E.`quotation_status`='Open' OR E.`quotation_status`='Closed' OR E.`quotation_status`='Confirmed')";
			}  else {
				$sql	.= " E.`quotation_status`='$type'";
			}
		}  else {
			$sql	.= " (E.`quotation_status`='Draft' OR E.`quotation_status`='Open' OR E.`quotation_status`='Closed' OR E.`quotation_status`='Confirmed')";
		}
		$is_salesman   =   $this->session->userdata('is_salesman');
		$logged_user_id   =   $this->session->userdata('user_id');

		$is_user_type   =   $this->session->userdata('is_user_type');
		
		if( $this->session->userdata('user_group_id') != 1 ) {
			if ($is_user_type!='') {
				$sql    .= "  and E.`status` in ($is_user_type) ";
			}
		}

		if ($is_salesman == 1) {
			$sql    .= "  and E.`salesman_id`='$logged_user_id' ";
		} else {
			$sql    .=   "  ";
		}	
		
		if ($client_id != "NIL"){
			$sql	.= " and E.`client_id`='$client_id'";
		}
		if ($telephone != "NIL"){
			$sql	.= " and ( E.`client_telephone1` Like '%$telephone%' OR E.`client_telephone2` Like '%$telephone%'  OR E.`Contact_Tel` Like '%$telephone%' )";
		}
		if ($quotation_number != "NIL"){
			$sql	.= " and (E.`quotation_number_full` like '%$quotation_number%' )";
		}

		if ($project != "NIL"){
			$sql	.= " and (E.`project_name` like '%$project%' )";
		}

		if ($user_id  != "NIL") {
			$sql    .= "  and E.`salesman_id`='$user_id' ";
		} else {
			$sql    .=   "  ";
		}	
		
		
		
		$result =   $this->db->query("SELECT COUNT(*) AS  Tcount FROM ( SELECT count(E.`quotation_id`) FROM `view_furniture_quotations_client_project_users` E  WHERE  ".$sql." group by E.`quotation_id` ) AS T ");
		return ($result->row()->Tcount);
	}

	public function userList(){
		$is_salesman   =   $this->session->userdata('is_salesman');
		$logged_user_id   =   $this->session->userdata('user_id');
		if ($is_salesman == 1 AND $this->session->userdata('user_group_id') != 1) {
			$sql    = "  and `user_id`='$logged_user_id' ";
		} else {
			$sql    =   "  ";
		}	
		$query= $this->db->query("SELECT * FROM `users` where `user_status`='Enabled' ".$sql);
		return $query->result();
	}

	public function taxability($date){
		$query= $this->db->query("SELECT * FROM `vat_applicable` WHERE `applicable_date` in (SELECT max(applicable_date) FROM `vat_applicable` where `applicable_date`<'$date') order by `vat_percentage` DESC");
		return $query->result();
	}

	public function vat_applicable($date){
		$query= $this->db->query("SELECT * FROM `vat_applicable` WHERE (taxability='Zero rated' OR taxability='Taxable') and `applicable_date` in (SELECT max(applicable_date) FROM `vat_applicable` where (taxability='Zero rated' OR taxability='Taxable') and `applicable_date`<'$date') order by `vat_percentage` DESC");
		return $query->result();
	}
	public function vat_applicable2($date){
		$query= $this->db->query("SELECT * FROM `vat_applicable` WHERE (taxability='Zero rated' OR taxability='Taxable') and `applicable_date` in (SELECT max(applicable_date) FROM `vat_applicable` where (taxability='Zero rated' OR taxability='Taxable') and `applicable_date`<'$date') order by `vat_percentage` DESC");
		return $query->result_array();
	}

	public function myEnquiries($limit, $start,$search_item) {
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id 	 = $this->session->userdata('user_id');
		$is_salesman = $this->session->userdata('is_salesman');
		if($this->session->userdata('user_group_id') == 1 ) {
			$sql=" E.status='1' ";
		} else {
			if ($is_salesman == 1) {
				$sql= " E.status='1' AND ( E.salesman_id=0 OR E.salesman_id='' OR E.salesman_id is NULL OR E.`salesman_id` = '$user_id' ) ";
			} else {
				$sql= " E.status='1' AND E.`salesman_id` = '$user_id' AND E.`salesman_id`!='0' ";
			}			
		}
		if($search_item!=''){
			$sql.=" AND (E.`enquiry_number` LIKE '%$search_item%' or E.`prospect_name` LIKE '%$search_item%' )";
		}
		$query= $this->db->query("SELECT E.`id`,E.enquiry_number,E.salesman_id,E.prospect_name,E.enquiry_date,U.user_name FROM `enquiry` E Left JOIN `users` U ON U.user_id=E.salesman_id WHERE ".$sql." order by E.salesman_id,E.enquiry_date asc limit ".$start.",".$limit);
		return $query->result();
	}

	public function myQuoteswithDesigners($limit, $start,$search_item){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		if($this->session->userdata('user_group_id') == 1 ) {
			$sql='';
		} else {
			$sql=" and q.`salesman_id` = '$user_id'";
		}
		if($search_item!=''){
			$sql.=" and (q.`quotation_number_full` LIKE '%$search_item%' or q.`client_name` LIKE '%$search_item%' or q.`project_name` LIKE '%$search_item%' )";
		}
		$query= $this->db->query("SELECT t.*,q.quotation_number_full,q.project_name,q.client_name,u.user_name FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id left join `users` u on u.user_id=t.trans_user_id   WHERE q.`quotation_status`='Draft' and t.group_by='2'  ".$sql." order by q.`quotation_id` desc limit ".$start.",".$limit);
		return $query->result();
	}
	public function myActions($limit, $start,$search_item){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		//if($this->session->userdata('user_group_id') == 1 ) {
			//$sql='';
		//} else {
			$sql=" and q.`salesman_id` = '$user_id'";
		//}
		if($search_item!=''){
			$sql.=" and (q.`quotation_number_full` LIKE '%$search_item%' or q.`client_name` LIKE '%$search_item%' or q.`project_name` LIKE '%$search_item%' )";
		}
		$query= $this->db->query("SELECT t.*,q.quotation_number_full,q.quotation_date,q.project_name,q.client_name,q.quotation_divisionid,q.quotation_number,u.user_name as salesman_name FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id left join `users` u on u.user_id=t.trans_user_id  WHERE q.`quotation_status`='Draft' and t.group_by='1'  ".$sql." order by q.`last_modified_date` desc limit ".$start.",".$limit);
		return $query->result();
	}
	public function myQuoteswithEstimators($limit, $start,$search_item){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		if($this->session->userdata('user_group_id') == 1 ) {
			$sql='';
		} else {
			$sql=" and q.`salesman_id` = '$user_id'";
		}
		if($search_item!=''){
			$sql.=" and (q.`quotation_number_full` LIKE '%$search_item%' or q.`client_name` LIKE '%$search_item%' or q.`project_name` LIKE '%$search_item%' )";
		}
		$query= $this->db->query("SELECT t.*,q.quotation_number_full,q.quotation_date,q.project_name,q.client_name,q.quotation_divisionid,q.quotation_number,u.user_name FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id left join `users` u on u.user_id=t.trans_user_id   WHERE q.`quotation_status`='Draft' and group_by='3'  ".$sql." order by q.`quotation_id` desc limit ".$start.",".$limit);
		return $query->result();
	}
	public function myQuoteswithEstimators2($limit, $start,$search_item){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		$sql=" and q.`salesman_id` = '$user_id'";
		
		$query= $this->db->query("SELECT t.*,q.quotation_number_full,q.quotation_date,q.project_name,q.client_name,q.quotation_divisionid,q.quotation_number,u.user_name as salesman_name FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id left join `users` u on u.user_id=t.trans_user_id   WHERE q.`quotation_status`='Draft' and group_by='3'  ".$sql." order by q.`last_modified_date` desc limit ".$start.",".$limit);
		return $query->result();
	}
	public function myQuotesPendingforApprovals($limit, $start,$search_item){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		if($this->session->userdata('user_group_id') == 1 ) {
			$sql='';
		} else {
			$sql=" and q.`salesman_id` = '$user_id'";
		}
		if($search_item!=''){
			$sql.=" and (q.`quotation_number_full` LIKE '%$search_item%' or q.`client_name` LIKE '%$search_item%' or q.`project_name` LIKE '%$search_item%' )";
		}
		$query= $this->db->query("SELECT t.*,q.quotation_number_full,q.project_name,q.client_name FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id WHERE q.`quotation_status`='Open' and t.group_by='4' and t.`trans_user_id` is null  ".$sql." order by q.`quotation_id` desc limit ".$start.",".$limit);
		return $query->result();
	}

	public function myQuotesApprover($limit, $start,$search_item){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		$sql=" and q.`salesman_id` = '$user_id'";
		
		$query= $this->db->query("SELECT t.*,q.quotation_number_full,q.quotation_date,q.project_name,q.client_name,q.quotation_divisionid,q.quotation_number,u.user_name as salesman_name FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id left join `users` u on u.user_id=t.trans_user_id WHERE q.`quotation_status`='Draft' and t.group_by='4'  ".$sql." order by q.`last_modified_date` desc limit ".$start.",".$limit);
		return $query->result();
	}

	public function myOktoConfirmQuotations($limit, $start,$search_item){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		$sql=" and q.`salesman_id` = '$user_id'";
		
		$query= $this->db->query("SELECT t.*,q.quotation_number_full,q.quotation_date,q.project_name,q.client_name,q.quotation_divisionid,q.quotation_number,u.user_name as salesman_name FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id left join `users` u on u.user_id=t.trans_user_id WHERE q.`quotation_status`='Open' and t.group_by='1'  ".$sql." order by q.`last_modified_date` desc limit ".$start.",".$limit);
		return $query->result();
	}

	public function myQuotesRecentlyApproved($limit, $start,$search_item){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		if($this->session->userdata('user_group_id') == 1 ) {
			$sql='';
		} else {
			$sql=" and q.`salesman_id` = '$user_id'";
		}
		if($search_item!=''){
			$sql.=" and (q.`quotation_number_full` LIKE '%$search_item%' or q.`client_name` LIKE '%$search_item%' or q.`project_name` LIKE '%$search_item%' )";
		}
		$query= $this->db->query("SELECT t.*,q.quotation_number_full,q.project_name,q.client_name,u.user_name,q.quotation_divisionid,q.quotation_number FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id left join `users` u on u.user_id=t.trans_user_id  WHERE q.`quotation_status`='Open' and t.group_by='1'   ".$sql." order by q.`quotation_id` desc limit ".$start.",".$limit);
		return $query->result();
	}
	public function myQuotesReceivedfromDesigners($limit, $start,$search_item){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		if($this->session->userdata('user_group_id') == 1 ) {
			$sql='';
		} else {
			$sql=" and q.`salesman_id` = '$user_id'";
		}
		if($search_item!=''){
			$sql.=" and (q.`quotation_number_full` LIKE '%$search_item%' or q.`client_name` LIKE '%$search_item%' or q.`project_name` LIKE '%$search_item%' )";
		}
		$query= $this->db->query("SELECT t.*,q.quotation_number_full,q.project_name,q.client_name,u.user_name FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id left join `users` u on u.user_id=t.trans_user_id  WHERE q.`quotation_status`='Draft' and t.flow_id='3'  ".$sql." order by q.`quotation_id` desc limit ".$start.",".$limit);
		return $query->result();
	}
	public function myQuotesRecentlyConfirmed($limit, $start,$search_item){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		if($this->session->userdata('user_group_id') == 1 ) {
			$sql='';
		} else {
			$sql=" and q.`salesman_id` = '$user_id'";
		}
		if($search_item!=''){
			$sql.=" and (q.`quotation_number_full` LIKE '%$search_item%' or q.`client_name` LIKE '%$search_item%' or q.`project_name` LIKE '%$search_item%' )";
		}
		$query= $this->db->query("SELECT t.*,q.quotation_number_full,q.project_name,q.client_name,u.user_name,q.quotation_divisionid,q.quotation_number FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id left join `users` u on u.user_id=t.trans_user_id  WHERE q.`quotation_status`='Confirmed' and t.group_by='4'   ".$sql." order by q.`quotation_id` desc limit ".$start.",".$limit);
		return $query->result();
	}
	public function pendingtoPickDesigners($limit, $start,$search_item){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		if($this->session->userdata('user_group_id') == 1 ) {
			$sql='';
		} else {
			//$sql=" and q.`salesman_id` = '$user_id'";
		}
		if($search_item!=''){
			$sql.=" and (q.`quotation_number_full` LIKE '%$search_item%' or q.`client_name` LIKE '%$search_item%' or q.`project_name` LIKE '%$search_item%' )";
		}
		$query= $this->db->query("SELECT t.*,q.quotation_number_full,q.project_name,q.client_name,u.user_name FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id left join `users` u on u.user_id=t.trans_user_id  WHERE q.`quotation_status`='Draft' and t.group_by='2' and t.`trans_user_id` is null  ".$sql." order by q.`quotation_id` desc limit ".$start.",".$limit);
		return $query->result();
	}
	public function myActionsDesigners($limit, $start,$search_item){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		//if($this->session->userdata('user_group_id') == 1 ) {
			//$sql='';
		//} else {
			$sql=" and t.`trans_user_id` = '$user_id'";
		//}
		if($search_item!=''){
			$sql.=" and (q.`quotation_number_full` LIKE '%$search_item%' or q.`client_name` LIKE '%$search_item%' or q.`project_name` LIKE '%$search_item%' )";
		}
		$query= $this->db->query("SELECT t.*,q.quotation_number_full,q.project_name,q.client_name,q.quotation_divisionid,q.quotation_number FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id  WHERE q.`quotation_status`='Draft' and t.group_by='2'  ".$sql." order by q.`quotation_id` desc limit ".$start.",".$limit);
		return $query->result();
	}
	public function pendingtoPickEstimators($limit, $start,$search_item){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		if($this->session->userdata('user_group_id') == 1 ) {
			$sql='';
		} else {
			//$sql=" and q.`salesman_id` = '$user_id'";
		}
		if($search_item!=''){
			$sql.=" and (q.`quotation_number_full` LIKE '%$search_item%' or q.`client_name` LIKE '%$search_item%' or q.`project_name` LIKE '%$search_item%' )";
		}
		$query= $this->db->query("SELECT t.*,q.quotation_number_full,q.quotation_date,q.project_name,q.client_name,u.user_name as salesman_name,q.quotation_divisionid,q.quotation_number FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by`,`trans_action` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id left join `users` u on u.user_id=t.trans_user_id  WHERE q.`quotation_status`='Draft' and t.group_by='3' and t.`trans_user_id` is null  ".$sql." order by q.`quotation_id` desc limit ".$start.",".$limit);
		return $query->result();
	}

	public function pendingtoPickEstimators2($limit, $start,$search_item){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		if($this->session->userdata('user_group_id') == 1 ) {
			$sql='';
		} else {
			//$sql=" and q.`salesman_id` = '$user_id'";
		}
		if($search_item!=''){
			$sql.=" and (q.`quotation_number_full` LIKE '%$search_item%' or q.`client_name` LIKE '%$search_item%' or q.`project_name` LIKE '%$search_item%' )";
		}
		$query= $this->db->query("SELECT t.*,q.quotation_number_full,q.quotation_date,q.project_name,q.client_name,u.user_name as salesman_name,q.quotation_divisionid,q.quotation_number FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by`,`trans_action` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id left join `users` u on u.user_id=q.salesman_id  WHERE q.`quotation_status`='Draft' and t.group_by='3' and t.`trans_user_id` is null  ".$sql." order by q.`quotation_id` desc limit ".$start.",".$limit);
		return $query->result();
	}

	public function myActionsEstimators($limit, $start,$search_item){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		//if($this->session->userdata('user_group_id') == 1 ) {
			//$sql='';
		//} else {
			$sql=" and t.`trans_user_id` = '$user_id'";
		//}
		if($search_item!=''){
			$sql.=" and (q.`quotation_number_full` LIKE '%$search_item%' or q.`client_name` LIKE '%$search_item%' or q.`project_name` LIKE '%$search_item%' )";
		}
		$query= $this->db->query("SELECT t.*,q.quotation_number_full,q.quotation_date,q.project_name,q.client_name,u.user_name as salesman_name,q.quotation_divisionid,q.quotation_number,q.quotation_revisionnumber FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id left join `users` u on u.user_id=q.salesman_id  WHERE q.`quotation_status`='Draft' and t.group_by='3'  ".$sql." order by q.`last_modified_date`,q.`quotation_revisionnumber` desc limit ".$start.",".$limit);
		return $query->result();
	}

	public function myEstimationConfirmed($limit, $start,$search_item){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		//if($this->session->userdata('user_group_id') == 1 ) {
			//$sql='';
		//} else {
			$sql=" and t.`trans_user_id` = '$user_id'";
		//}
		if($search_item!=''){
			$sql.=" and (q.`quotation_number_full` LIKE '%$search_item%' or q.`client_name` LIKE '%$search_item%' or q.`project_name` LIKE '%$search_item%' )";
		}
		$query= $this->db->query("SELECT t.*,q.quotation_number_full,q.quotation_date,q.project_name,q.client_name,u.user_name as salesman_name,q.quotation_divisionid,q.quotation_number,q.quotation_revisionnumber FROM `view_furniture_quotations_client_project_users` q inner join `log_for_quotation` t on (t.trans_id=q.quotation_id ) left join `users` u on u.user_id=q.salesman_id WHERE q.quotation_status='Confirmed' and t.flow_id=4 ".$sql." group by q.quotation_id order by q.`last_modified_date`,q.`quotation_revisionnumber` desc limit ".$start.",".$limit);   
		return $query->result();
	}

	public function confirmedQuote($limit, $start,$search_item){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		//if($this->session->userdata('user_group_id') == 1 ) {
			//$sql='';
		//} else {
			$sql=" and t.`trans_user_id` = '$user_id'";
		//}
		if($search_item!=''){
			$sql.=" and (q.`quotation_number_full` LIKE '%$search_item%' or q.`client_name` LIKE '%$search_item%' or q.`project_name` LIKE '%$search_item%' )";
		}
		$query= $this->db->query("SELECT q.*,u.user_name as salesman_name,q.quotation_divisionid,q.quotation_number,q.quotation_revisionnumber FROM `view_furniture_quotations_client_project_users` q inner join `users` u on u.user_id=q.salesman_id WHERE q.quotation_status='Confirmed' group by q.quotation_id order by q.`last_modified_date` desc limit ".$start.",".$limit);   
		return $query->result();
	}

	public function myEstimationQoutewithApprover($limit, $start,$search_item){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		//if($this->session->userdata('user_group_id') == 1 ) {
			//$sql='';
		//} else {
			$sql=" and t.`trans_user_id` = '$user_id'";
		//}
		
		
		$query= $this->db->query("SELECT t.*,q.quotation_number_full,q.quotation_date,q.project_name,q.client_name,q.quotation_divisionid,q.quotation_number,q.quotation_revisionnumber FROM `view_furniture_quotations_client_project_users` q inner join `log_for_quotation` t on (t.trans_id=q.quotation_id and flow_id=4) WHERE  (q.quotation_status='Draft' OR q.quotation_status='Open') and (q.status=5 OR q.status=7) ".$sql." group by q.quotation_id order by q.`last_modified_date`,q.`quotation_revisionnumber` desc limit ".$start.",".$limit);
		return $query->result();
	}

	public function pendingtoPickApprovers($limit, $start,$search_item){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		if($this->session->userdata('user_group_id') == 1 ) {
			$sql='';
		} else {
			//$sql=" and q.`salesman_id` = '$user_id'";
		}
		if($search_item!=''){
			$sql.=" and (q.`quotation_number_full` LIKE '%$search_item%' or q.`client_name` LIKE '%$search_item%' or q.`project_name` LIKE '%$search_item%' )";
		}
		$query= $this->db->query("SELECT t.*,q.quotation_number_full,q.project_name,q.client_name,u.user_name FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id left join `users` u on u.user_id=t.trans_user_id  WHERE q.`quotation_status`='Draft' and t.group_by='4' and t.`trans_user_id` is null  ".$sql." order by q.`quotation_id` desc limit ".$start.",".$limit);
		return $query->result();
	}

	public function pendingtoPickApprovers2($limit, $start,$search_item){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		if($this->session->userdata('user_group_id') == 1 ) {
			$sql='';
		} else {
			//$sql=" and q.`salesman_id` = '$user_id'";
		}
		if($search_item!=''){
			$sql.=" and (q.`quotation_number_full` LIKE '%$search_item%' or q.`client_name` LIKE '%$search_item%' or q.`project_name` LIKE '%$search_item%' )";
		}
		$query= $this->db->query("SELECT t.*,q.quotation_number_full,q.quotation_date,q.project_name,q.client_name,u.user_name as salesman_name,q.quotation_divisionid,q.quotation_number FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by`,`trans_action` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id left join `users` u on u.user_id=q.salesman_id  WHERE q.`quotation_status`='Draft' and t.group_by='4' and t.`trans_user_id` is null  ".$sql." order by q.`quotation_id` desc limit ".$start.",".$limit);
		return $query->result();
	}

	public function forApproval($limit, $start,$search_item){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		if($this->session->userdata('user_group_id') == 1 ) {
			$sql='';
		} else {
			//$sql=" and q.`salesman_id` = '$user_id'";
		}
		$sql=" and t.`trans_user_id` = '$user_id'";
		if($search_item!=''){
			$sql.=" and (q.`quotation_number_full` LIKE '%$search_item%' or q.`client_name` LIKE '%$search_item%' or q.`project_name` LIKE '%$search_item%' )";
		}
		$query= $this->db->query("SELECT t.*,q.quotation_number_full,q.quotation_date,q.project_name,q.client_name,u.user_name as salesman_name,q.quotation_divisionid,q.quotation_number FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by`,`trans_action` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id left join `users` u on u.user_id=q.salesman_id  WHERE q.`quotation_status`='Draft' and t.group_by='4' ".$sql." order by q.`last_modified_date` desc limit ".$start.",".$limit);
		return $query->result();
	}

	public function forConfirm($limit, $start,$search_item){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		if($this->session->userdata('user_group_id') == 1 ) {
			$sql='';
		} else {
			//$sql=" and q.`salesman_id` = '$user_id'";
		}
		$sql=" and t.`trans_user_id` = '$user_id'";
		if($search_item!=''){
			$sql.=" and (q.`quotation_number_full` LIKE '%$search_item%' or q.`client_name` LIKE '%$search_item%' or q.`project_name` LIKE '%$search_item%' )";
		}
		$query= $this->db->query("SELECT t.*,q.quotation_number_full,q.quotation_date,q.project_name,q.client_name,u.user_name as salesman_name,q.quotation_divisionid,q.quotation_number FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by`,`trans_action` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id left join `users` u on u.user_id=q.salesman_id  WHERE q.`quotation_status`='Open' and t.flow_id='7' ".$sql." order by q.`last_modified_date` desc limit ".$start.",".$limit);
		return $query->result();
	}

	public function myActionsApprovers($limit, $start,$search_item){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		//if($this->session->userdata('user_group_id') == 1 ) {
			//$sql='';
		//} else {
			$sql=" and t.`trans_user_id` = '$user_id'";
		//}
		if($search_item!=''){
			$sql.=" and (q.`quotation_number_full` LIKE '%$search_item%' or q.`client_name` LIKE '%$search_item%' or q.`project_name` LIKE '%$search_item%' )";
		}
		$query= $this->db->query("SELECT t.*,q.quotation_number_full,q.project_name,q.client_name,q.quotation_divisionid,q.quotation_number,q.quotation_status FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id  WHERE (q.`quotation_status`='Draft' OR  q.`quotation_status`='Open') and t.group_by='4'  ".$sql." order by q.`quotation_id` desc limit ".$start.",".$limit);
		return $query->result();
	}
	public function recentlyConfirmed($limit, $start,$search_item){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		//if($this->session->userdata('user_group_id') == 1 ) {
			//$sql='';
		//} else {
			$sql=" and t.`trans_user_id` = '$user_id'";
		//}
		if($search_item!=''){
			$sql.=" and (q.`quotation_number_full` LIKE '%$search_item%' or q.`client_name` LIKE '%$search_item%' or q.`project_name` LIKE '%$search_item%' )";
		}
		$query= $this->db->query("SELECT t.*,q.quotation_number_full,q.project_name,q.client_name,q.quotation_divisionid,q.quotation_number FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id  WHERE q.`quotation_status`='Confirmed' and t.group_by='4'  ".$sql." order by q.`quotation_id` desc limit ".$start.",".$limit);
		return $query->result();
	}
	public function pendingtoApproverPr($limit, $start,$search_item){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		if($this->session->userdata('user_group_id') == 1 ) {
			$sql='';
		} else {
			//$sql=" and q.`salesman_id` = '$user_id'";
		}
		if($search_item!=''){
			$sql.=" and (t.`pr_code` LIKE '%$search_item%' )";
		}
		$query= $this->db->query("SELECT t.*,u.user_name FROM  `purchase_request` AS t left join `users` u on u.user_id=t.user_id  WHERE t.`status`='Rate Updated'  ".$sql." order by t.`pr_id` desc limit ".$start.",".$limit);
		return $query->result();
	}
	public function pendingtoApproverPo($limit, $start,$search_item){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		if($this->session->userdata('user_group_id') == 1 ) {
			$sql='';
		} else {
			//$sql=" and q.`salesman_id` = '$user_id'";
		}
		if($search_item!=''){
			$sql.=" and (t.`po_code` LIKE '%$search_item%' )";
		}
		$query= $this->db->query("SELECT t.*,u.user_name,s.supplier_name FROM  `po_h` AS t left join `users` u on u.user_id=t.user_id left join `supplier_master` s on s.supplier_id=t.supplier_id  WHERE t.`status`='Draft'  ".$sql." order by t.`po_id` desc limit ".$start.",".$limit);
		return $query->result();
	}
	public function itemWiseDatarow($furniture_id){
		$result =   $this->db->query("SELECT FI.furniture_id, CONCAT(FI.ex_furniture_area, '.',FI.sub_group_id, '.',FI.item_order) AS sl_no,FI.quotation_id,FI.furniture_area,FI.ex_furniture_area,FI.sub_group,FI.sub_group_id,FI.item_order,FI.furniture_model,FI.furniture_quantity,FI.uom,FI.furniture_description,FI.furniture_comments,FI.vat_perce,FI.image,FI.comment_flag,FI.comments,FQ.quotation_number_full,FQ.quotation_number,FQ.quotation_revisionnumber,FQ.quotation_divisionid,FQ.client_id,FQ.quotation_date,FQ.project_name,FQ.common_comments,FQ.quotation_type,NCM.client_name,E.enquiry_number,E.enquiry_date FROM `furniture_items` FI INNER JOIN `furniture_quotation` FQ ON FQ.id=FI.quotation_id LEFT JOIN `new_client_master` NCM ON NCM.client_id=FQ.client_id LEFT JOIN `enquiry` E ON E.id=FQ.enquiry_id WHERE FI.furniture_id='$furniture_id'");
		return ($result->row_array());
	}

	public function userWisePRpendingcount($user_id=''){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		if( $user_id!='' && $this->session->userdata('user_group_id') != 1 && $this->session->userdata('user_group_id') != 10 ) {
			$sql=" and pr.`user_id` = '$user_id'";
		}
		
		$result= $this->db->query("SELECT count(pr.pr_id) as count FROM `purchase_request` pr left join `department_master` d on d.department_id=pr.dep_id left join `po_h` ph on ph.pr_id=pr.pr_id WHERE pr.status!='Cancel'  ".$sql." and ph.po_id is null order by pr.`pr_id` desc");	
		return ($result->row_array());
	}

	public function userWisePRpending($user_id=''){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		if( $user_id!='' && $this->session->userdata('user_group_id') != 1 && $this->session->userdata('user_group_id') != 10 ) {
			$sql=" and pr.`user_id` = '$user_id'";
		}
		$query= $this->db->query("SELECT pr.*,d.department_name FROM `purchase_request` pr left join `department_master` d on d.department_id=pr.dep_id left join `po_h` ph on ph.pr_id=pr.pr_id WHERE pr.status!='Cancel'  ".$sql." and ph.po_id is null order by pr.`pr_id` desc");
		return $query->result();
	}

	public function userWisePRnotReceivedcount($user_id=''){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		if( $user_id!='' ) {
			$sql=" and pr.`user_id` = '$user_id'";
		}
		
		$result= $this->db->query("SELECT count(pr.pr_id) as count FROM `purchase_request` pr left join `department_master` d on d.department_id=pr.dep_id inner join `po_h` ph on ph.pr_id=pr.pr_id left join `purchase_h` p on p.po_h_id=ph.po_id WHERE pr.status!='Cancel' and ph.status='Confirmed' ".$sql." and p.id is null order by pr.`pr_id` DESC");	
		return ($result->row_array());
	}

	public function userWisePRnotReceived($user_id=''){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		if( $user_id!='' ) {
			$sql=" and pr.`user_id` = '$user_id'";
		}
		
		$result= $this->db->query("SELECT pr.*,d.department_name,ph.po_id,ph.po_code,sm.supplier_name,p.purchase_invoice_code FROM `purchase_request` pr left join `department_master` d on d.department_id=pr.dep_id inner join `po_h` ph on ph.pr_id=pr.pr_id inner join `supplier_master` sm on sm.supplier_id=ph.supplier_id left join `purchase_h` p on p.po_h_id=ph.po_id WHERE pr.status!='Cancel' and ph.status='Confirmed' ".$sql." and p.id is null order by pr.`pr_id` DESC");	
		return $result->result();
	}

	public function pendingPR($limit, $start,$search_item){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		if($this->session->userdata('user_group_id') == 1 ) {
			$sql='';
		} else {
			//$sql=" and q.`salesman_id` = '$user_id'";
		}
		if($search_item!=''){
			$sql.=" and (t.`pr_code` LIKE '%$search_item%' )";
		}
		$query= $this->db->query("SELECT t.*,u.user_name,d.department_name FROM  `purchase_request` AS t left join `po_h` p on t.pr_id=p.pr_id left join `users` u on u.user_id=t.user_id left join `department_master` d on d.department_id=t.dep_id WHERE t.status!='Cancel' and p.po_id is null ".$sql." order by t.`pr_id` desc limit ".$start.",".$limit);
		return $query->result();
	}

	public function pendingPRCount($salesman_id){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		if($this->session->userdata('user_group_id') == 1 ) {
			$sql='';
		} else {
			//$sql=" and q.`salesman_id` = '$user_id'";
		}
		$result= $this->db->query("SELECT count(t.pr_id) as count FROM  `purchase_request` AS t left join `po_h` p on t.pr_id=p.pr_id left join `users` u on u.user_id=t.user_id    WHERE t.status!='Cancel' and p.po_id is null ".$sql." ");
		return ($result->row_array());
	}

	public function pendingPOCount($type='',$salesman_id=''){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='1 ';
		$user_id = $this->session->userdata('user_id');
		if($this->session->userdata('user_group_id') == 1 ) {
			$sql='';
		} else {
			//$sql=" and q.`salesman_id` = '$user_id'";
		}
		if($type!=''){
			$sql.=" and t.`status`='$type'";
		}
		$result= $this->db->query("SELECT count(po_id) as count FROM  `po_h` AS t left join `users` u on u.user_id=t.user_id  WHERE   ".$sql." ");
		return ($result->row_array());
	}
	public function approvedPOCount($type='',$salesman_id=''){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='1 ';
		$user_id = $this->session->userdata('user_id');
		if($this->session->userdata('user_group_id') == 1 ) {
			$sql='';
		} else {
			//$sql=" and q.`salesman_id` = '$user_id'";
		}
		if($type!=''){
			$sql.=" and t.`status`='$type'";
		}
		$result= $this->db->query("SELECT count(po_id) as count FROM  `po_h` AS t left join `purchase_h` p on p.po_h_id=t.po_id left join `users` u on u.user_id=t.user_id  WHERE   ".$sql." and p.po_h_id is null ");
		return ($result->row_array());
	}

	public function pendingPO($limit, $start,$type='',$search_item=''){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='1 ';
		$user_id = $this->session->userdata('user_id');
		if($this->session->userdata('user_group_id') == 1 ) {
			$sql='';
		} else {
			//$sql=" and q.`salesman_id` = '$user_id'";
		}
		if($type!=''){
			$sql.=" and t.`status`='$type'";
			if($type=='Draft'){
				$query= $this->db->query("SELECT t.*,u.user_name,s.supplier_name FROM  `po_h` AS t left join `users` u on u.user_id=t.user_id left join `supplier_master` s on s.supplier_id=t.supplier_id WHERE   ".$sql." order by t.`po_id` desc limit ".$start.",".$limit);
				return $query->result();
			} else if($type=='Confirmed'){
				$query= $this->db->query("SELECT t.*,u.user_name,s.supplier_name FROM  `po_h` AS t left join `purchase_h` p on p.po_h_id=t.po_id left join `users` u on u.user_id=t.user_id left join `supplier_master` s on s.supplier_id=t.supplier_id WHERE   ".$sql."  and p.po_h_id is null order by t.`po_id` desc limit ".$start.",".$limit);
				return $query->result();
			}
		}
	}
	

	public function estimation($furniture_id){
		$result =   $this->db->query("SELECT * FROM `estimation` WHERE furniture_id='$furniture_id'");
		return ($result->row_array());
	}

	public function estimationMaterialsAdded($furniture_id){
		$result =   $this->db->query("SELECT * FROM `estimation_material` WHERE furniture_id='$furniture_id'");
		return ($result->result_array());
	}

	public function estimationLabourCostAdded($furniture_id){
		$result =   $this->db->query("SELECT * FROM `estimation_labourcost` WHERE furniture_id='$furniture_id'");
		return ($result->result_array());
	}
	public function estimationSubContractAdded($furniture_id){
		$result =   $this->db->query("SELECT * FROM `estimation_subcontract` WHERE furniture_id='$furniture_id'");
		return ($result->result_array());
	}
	public function estimationHiringAdded($furniture_id){
		$result =   $this->db->query("SELECT * FROM `estimation_hiring` WHERE furniture_id='$furniture_id'");
		return ($result->result_array());
	}
	public function estimationOthersAdded($furniture_id){
		$result =   $this->db->query("SELECT * FROM `estimation_others` WHERE furniture_id='$furniture_id'");
		return ($result->result_array());
	}
	public function overhead(){
		$result =   $this->db->query("SELECT * FROM `overhead_table` WHERE status='1' ");
		return ($result->result_array());
	}

	public function enquiryData(){
		$user_id = $this->session->userdata('user_id');
		$result =   $this->db->query("SELECT SUM(confirmed_enquiry) as confirmed_enquiry,SUM(lost_enquiry) as lost_enquiry,SUM(new_enquiry) as new_enquiry,SUM(unassigned_enquiry) as unassigned_enquiry,SUM(unattended_enquiry) as unattended_enquiry FROM (select if(E.status = '2', 1, 0) as confirmed_enquiry,if(E.status = '0', 1, 0) as lost_enquiry,if(E.status = '1', 1, 0) as new_enquiry,if(E.salesman_id = 0, 1, 0) as unassigned_enquiry,if(E.salesman_id != 0 and ED.meeting_type  IS NULL, 1, 0) as unattended_enquiry from enquiry E left join enquiry_details ED on ED.enquiry_id=E.id where E.Created_User_id='$user_id' group by E.id) as T LIMIT 1 ");
		return ($result->row_array());
	}

	public function enquiryData2($salesman_id){
		$result =   $this->db->query("SELECT IFNULL(SUM(confirmed_enquiry),0) as confirmed_enquiry,IFNULL(SUM(lost_enquiry),0) as lost_enquiry,IFNULL(SUM(new_enquiry),0) as new_enquiry,IFNULL(SUM(unassigned_enquiry),0) as unassigned_enquiry,IFNULL(SUM(unattended_enquiry),0) as unattended_enquiry FROM (select if(E.status = '2', 1, 0) as confirmed_enquiry,if(E.status = '0', 1, 0) as lost_enquiry,if(E.status = '1', 1, 0) as new_enquiry,if(E.salesman_id = 0, 1, 0) as unassigned_enquiry,if(E.salesman_id != 0 and ED.meeting_type  IS NULL, 1, 0) as unattended_enquiry from enquiry E left join enquiry_details ED on ED.enquiry_id=E.id where E.Created_User_id='$salesman_id' group by E.id) as T LIMIT 1 ");
		return ($result->row_array());
	}

	public function get_boq_no($no,$division_id,$quotation_number){
		if($division_id!=0){
			$query= $this->db->query("SELECT * FROM  `company_division` WHERE division_id='$division_id' ");
			$division_code=$query->row()->division_code;
		} else {
			$division_code='';
		}
		$purchase_order_no='BOQ/'.$division_code.'/'.$quotation_number.'/'.sprintf("%'.04d",$no); // BOQ / DIVISION CODE / Quotation Number / Furniture id
		return $purchase_order_no;
	}

	public function get_ledger_code(){
		$result = $this->db->query("SELECT COUNT(ledger_id) AS items_count FROM ledgers where is_edit='1' ");
		$val = $result->result_array();
		$ledger_code = "LED00".($val[0]['items_count']+1);
		//$purchase_order_no='BOQ/'.$division_code.'/'.$quotation_number.'/'.sprintf("%'.04d",$no); // BOQ / DIVISION CODE / Quotation Number / Furniture id
		return $ledger_code;
	}

	public function get_receipt_code($quotation_divisionid,$receipt_no) {
		$query= $this->db->query("SELECT * FROM  `company_division` WHERE division_id='$quotation_divisionid' ");
		$division_code=$query->row()->division_code;
		$invice_no = 'R'.date("y").$division_code.sprintf("%'.05d", ($receipt_no));
		return $invice_no;
	}

	public function get_journal_code($quotation_divisionid,$receipt_no) {
		$query= $this->db->query("SELECT * FROM  `company_division` WHERE division_id='$quotation_divisionid' ");
		$division_code=$query->row()->division_code;
		//.$division_code
		$invice_no = 'JL'.date("y").sprintf("%'.05d", ($receipt_no));
		return $invice_no;
	}

	public function get_credit_note_code($quotation_divisionid,$credit_note_no) {
		$query= $this->db->query("SELECT * FROM  `company_division` WHERE division_id='$quotation_divisionid' ");
		$division_code=$query->row()->division_code;
		$invice_no = 'CN'.date("y").$division_code.sprintf("%'.05d", ($credit_note_no));
		return $invice_no;
	}

	public function get_debit_note_code($quotation_divisionid,$credit_note_no) {
		$query= $this->db->query("SELECT * FROM  `company_division` WHERE division_id='$quotation_divisionid' ");
		$division_code=$query->row()->division_code;
		$invice_no = 'DN'.date("y").$division_code.sprintf("%'.05d", ($credit_note_no));
		return $invice_no;
	}

	public function get_payment_code($quotation_divisionid,$receipt_no) {
		$query= $this->db->query("SELECT * FROM  `company_division` WHERE division_id='$quotation_divisionid' ");
		$division_code=$query->row()->division_code;
		$invice_no = 'PY'.date("y").$division_code.sprintf("%'.05d", ($receipt_no));
		return $invice_no;
	}

	public function get_approve_status($quotation_id){
		$this->db->select('*');
		$this->db->from('log_for_quotation');
		$this->db->where('trans_id', $quotation_id); 
		$this->db->where("(trans_action='Approve2' OR trans_action='Approve3')", NULL, FALSE);
		$approve_data = $this->db->get();
		if($approve_data->num_rows() > 0){
			$approve_status_data	=	$approve_data->result_array();
			if($approve_status_data[0]['trans_user_id']!==NULL){
				return 'Approved';
			} else {
				return 'notApproved';
			}
		} else {
			return false;
		}
	}

	public function bsList($limit, $start,$fromDate,$client_id,$user_id,$division){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$this->db->where('jc.`job_card_status` !=', 'Cancelled');
		if($fromDate!='NIL') {
			$this->db->where('DATE(jc.`job_card_date`) <=', $fromDate);
		}
		if($client_id!='NIL') {
			$this->db->where('jc.`client_id`', $client_id);
		}
		if($user_id!='NIL') {
			$this->db->where('jc.`salesman_id`', $user_id);
		}
		if($division!='NIL') {
			$this->db->where('jc.`job_card_divisionid`', $division);
		}
		
		$this->db->query("SET SQL_BIG_SELECTS=1");
       	$this->db->select("jc.`job_card_id`,jc.`job_card_number`,jc.`job_card_date`,`job_card_total_with_vat` as job_card_amount_with_vat,jc.client_name,jc.`quotation_number_full`,sum(if(cba.bill_type = 'Invoice', cba.bill_amt, 0)) as invoiced_amount,sum(if(cba.bill_type = 'Receipt', cba.bill_amt, 0)) as received_amount,sum(if(cba.bill_type = 'Credit Note', cba.bill_amt, 0)) as cr_amount,jc.user_name as sales_man" );
		$this->db->from('view_furniture_job_card as jc');
		$this->db->join('furniture_invoice as fi','fi.job_card_id = jc.job_card_id and fi.invoice_status = 0','left');
		$this->db->join('cust_bill_allocations as cba',' cba.bill_id = fi.invoice_id and cba.`trn_type` !="Opening" and cba.`status`="1"','left');
		//$this->db->where('fi.invoice_status', 0);
		$this->db->limit(200);
		$this->db->group_by("jc.`job_card_id`");
		$rs = $this->db->get();
		return $rs->result_array();
    }

	public function openingList($limit, $start,$fromDate,$client_code,$user_id,$division){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		if($fromDate!='NIL') {
			$this->db->where('DATE(`bill_date`) <=', $fromDate);
		}
		if($client_code!='NIL') {
			$this->db->where('`ledger_code`', $client_code);
		}
		if($user_id!='NIL') {
			$this->db->where('cba.sm_id', $user_id);
		}
		if($division!='NIL') {
			$this->db->where('cba.`division_id`', $division);
		}
		
		$this->db->query("SET SQL_BIG_SELECTS=1");
        //$query= $this->db->query("SELECT jc.`job_card_id`,jc.`job_card_number`,jc.`job_card_date`,`job_card_total_with_vat` as job_card_amount_with_vat,jc.client_name,jc.`quotation_number_full`,sum(if(cba.bill_type = 'Invoice', cba.bill_amt, 0)) as invoiced_amount,sum(if(cba.bill_type = 'Receipt', cba.bill_amt, 0)) as received_amount,sum(if(cba.bill_type = 'Credit Note', cba.bill_amt, 0)) as cr_amount,jc.user_name as sales_man FROM `view_furniture_job_card` jc left join furniture_invoice fi on fi.job_card_id=jc.`job_card_id` left join cust_bill_allocations cba on cba.bill_id=fi.invoice_id WHERE 1 ".$sql." group by jc.`job_card_id`");
		$this->db->select("'' as job_card_id,trn_no as job_card_number,bill_date as job_card_date,'' as job_card_amount_with_vat,l.ledger_name as client_name,'' as quotation_number_full,sum(if(cba.bill_type = 'Invoice', cba.bill_amt, 0)) as invoiced_amount,sum(if(cba.bill_type = 'Receipt', cba.bill_amt, 0)) as received_amount,sum(if(cba.bill_type = 'Credit Note', cba.bill_amt, 0)) as cr_amount,u.user_name as sales_man" );
		//$this->db->from('view_furniture_job_card as jc');
		//$this->db->join('furniture_invoice as fi','fi.job_card_id = jc.job_card_id','left');
		$this->db->from('cust_bill_allocations as cba','cba.bill_id = fi.invoice_id','left');
		$this->db->join('ledgers as l','l.ledger_code = cba.customer_code','left');
		$this->db->join('users as u','u.user_id = cba.sm_id','left');
		$this->db->where('cba.`trn_type`', 'Opening');
		$this->db->group_by("cba.bill_id");
		$this->db->limit(200);
		$rs = $this->db->get();

		//echo $this->db->last_query().'<br>';
		return $rs->result_array();
    }

	function books_beginning_date_config(){
		$query = $this->db->query("SELECT * FROM `company_details`");
		return $query->row()->books_beginning_date;
	}
	public function get_all_general_receipts($limit, $start,$division_id,$filter_by,$filter_value){
		$user_id	=	$this->session->userdata('user_id');
		$sql	=	" 1 ";
		//$sql	=	" FI.`quotation_divisionid` in  (SELECT `division_id` FROM `user_division_permissions` WHERE `user_id`='$user_id') ";
		if ($division_id!= "NIL") {
			//$sql	.=	" AND FI.`quotation_divisionid`='$division_id'";
		}
		
		if ($filter_by!= "NIL" and $filter_value!= "NIL") {
			if($filter_by == 1) {
				//$sql	.=	" AND FR.`receipt_number` LIKE '%$filter_value%'";
			} else if ($filter_by == 2) {
				//$sql	.=	" AND FI.`client` LIKE '%$filter_value%'";
			}
		}
		
		$query= $this->db->query("SELECT * FROM `general_receipts`  WHERE  ".$sql."  order by `g_receipt_id` desc limit ".$start.",".$limit);
		//echo $this->db->last_query().'<br>';
		return $query->result_array();
	}

	public function get_all_journals($limit, $start,$division_id,$filter_by,$filter_value){
		$user_id	=	$this->session->userdata('user_id');
		$sql	=	" 1 ";
		//$sql	=	" FI.`quotation_divisionid` in  (SELECT `division_id` FROM `user_division_permissions` WHERE `user_id`='$user_id') ";
		if ($division_id!= "NIL") {
			//$sql	.=	" AND FI.`quotation_divisionid`='$division_id'";
		}
		
		if ($filter_by!= "NIL" and $filter_value!= "NIL") {
			if($filter_by == 1) {
				//$sql	.=	" AND FR.`receipt_number` LIKE '%$filter_value%'";
			} else if ($filter_by == 2) {
				//$sql	.=	" AND FI.`client` LIKE '%$filter_value%'";
			}
		}
		
		$query= $this->db->query("SELECT * FROM `journal`  WHERE  ".$sql."  order by `journal_id` desc limit ".$start.",".$limit);
		//echo $this->db->last_query().'<br>';
		return $query->result_array();
	}

	public function journal_record_count($division_id,$filter_by,$filter_value) {
		$user_id	=	$this->session->userdata('user_id');
		$sql	=	" 1 ";
		//$sql	=	" FI.`quotation_divisionid` in  (SELECT `division_id` FROM `user_division_permissions` WHERE `user_id`='$user_id') ";
		if ($division_id!= "NIL") {
			//$sql	.=	" AND FI.`quotation_divisionid`='$division_id'";
		}
		
		if ($filter_by!= "NIL" and $filter_value!= "NIL") {
			if($filter_by == 1) {
				//$sql	.=	" AND FR.`receipt_number` LIKE '%$filter_value%'";
			} else if ($filter_by == 2) {
				//$sql	.=	" AND FI.`client` LIKE '%$filter_value%'";
			}
		}
		
		$result =   $this->db->query("SELECT count(`journal_id`) AS `Tcount` FROM `journal` WHERE  ".$sql."  ");
		return ($result->row()->Tcount);
	}

	public function general_record_count($division_id,$filter_by,$filter_value) {
		$user_id	=	$this->session->userdata('user_id');
		$sql	=	" 1 ";
		//$sql	=	" FI.`quotation_divisionid` in  (SELECT `division_id` FROM `user_division_permissions` WHERE `user_id`='$user_id') ";
		if ($division_id!= "NIL") {
			//$sql	.=	" AND FI.`quotation_divisionid`='$division_id'";
		}
		
		if ($filter_by!= "NIL" and $filter_value!= "NIL") {
			if($filter_by == 1) {
				//$sql	.=	" AND FR.`receipt_number` LIKE '%$filter_value%'";
			} else if ($filter_by == 2) {
				//$sql	.=	" AND FI.`client` LIKE '%$filter_value%'";
			}
		}
		
		$result =   $this->db->query("SELECT count(`g_receipt_id`) AS `Tcount` FROM `general_receipts` WHERE  ".$sql."  ");
		return ($result->row()->Tcount);
	}
	public function get_all_general_payments($limit, $start,$division_id,$filter_by,$filter_value){
		$user_id	=	$this->session->userdata('user_id');
		$sql	=	" 1 ";
		//$sql	=	" FI.`quotation_divisionid` in  (SELECT `division_id` FROM `user_division_permissions` WHERE `user_id`='$user_id') ";
		if ($division_id!= "NIL") {
			//$sql	.=	" AND FI.`quotation_divisionid`='$division_id'";
		}
		
		if ($filter_by!= "NIL" and $filter_value!= "NIL") {
			if($filter_by == 1) {
				//$sql	.=	" AND FR.`receipt_number` LIKE '%$filter_value%'";
			} else if ($filter_by == 2) {
				//$sql	.=	" AND FI.`client` LIKE '%$filter_value%'";
			}
		}
		
		$query= $this->db->query("SELECT * FROM `general_payments`  WHERE  ".$sql."  order by `g_payment_id` desc limit ".$start.",".$limit);
		//echo $this->db->last_query().'<br>';
		return $query->result_array();
	}

	public function general_payment_record_count($division_id,$filter_by,$filter_value) {
		$user_id	=	$this->session->userdata('user_id');
		$sql	=	" 1 ";
		//$sql	=	" FI.`quotation_divisionid` in  (SELECT `division_id` FROM `user_division_permissions` WHERE `user_id`='$user_id') ";
		if ($division_id!= "NIL") {
			//$sql	.=	" AND FI.`quotation_divisionid`='$division_id'";
		}
		
		if ($filter_by!= "NIL" and $filter_value!= "NIL") {
			if($filter_by == 1) {
				//$sql	.=	" AND FR.`receipt_number` LIKE '%$filter_value%'";
			} else if ($filter_by == 2) {
				//$sql	.=	" AND FI.`client` LIKE '%$filter_value%'";
			}
		}
		
		$result =   $this->db->query("SELECT count(`g_payment_id`) AS `Tcount` FROM `general_payments` WHERE  ".$sql."  ");
		return ($result->row()->Tcount);
	}
	function get_all_employees(){
		if(isset($_REQUEST['ttttt'])){
			if($this->input->post('filter_value')!=""){
				$this->db->like('employee_number',$this->input->post('filter_value'));
			}
		}
		$this->db->select('*' );
		$this->db->from('employee');
		//$this->db->join('new_client_master','delivery_note.client_id = new_client_master.client_id','left');
		$this->db->limit(500);
		$this->db->order_by("employee_id","desc");
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}else{
			return false;
		}
	}

	function get_all_job_update_employeewise_list(){
		if(isset($_REQUEST['ttttt'])){
			if($this->input->post('employee')!=""){
				$this->db->where('JUE.employee_id',$this->input->post('employee_id'));
			}
			if($this->input->post('job_no')!=""){
				$this->db->like('JUE.job_number',$this->input->post('job_no'));
			}
			$fromDate=$this->input->post('fromDate');
			$toDate=$this->input->post('toDate');
			if($fromDate!='' and $toDate!='') {
				$date2 = str_replace('/', '-', $this->input->post("fromDate"));
				$date3 = str_replace('/', '-', $this->input->post("toDate"));
				$fromDate =   date("Y-m-d", strtotime($date2));
				$toDate =   date("Y-m-d", strtotime($date3));
				$this->db->where('JUE.work_done_date >=', $fromDate);
				$this->db->where('JUE.work_done_date <=', $toDate);
			} else if($fromDate!='' and $toDate==''){
				$date2 = str_replace('/', '-', $this->input->post("fromDate"));
				$fromDate =   date("Y-m-d", strtotime($date2));
				$this->db->where('JUE.work_done_date >=', $fromDate);
			} else if($fromDate=='' and $toDate!=''){
				$date3 = str_replace('/', '-', $this->input->post("toDate"));
				$toDate =   date("Y-m-d", strtotime($date3));
				$this->db->where('JUE.work_done_date <=', $toDate);
			}
		}
		$this->db->select('JUE.id,JUE.work_done_date,JUE.job_number,JUE.normal_hours,JUE.normal_ot,JUE.employee_id,E.employee_name,JC.project_name' );
		$this->db->from('job_update_employeewise AS JUE');
		$this->db->join('employee AS E','E.employee_id = JUE.employee_id','inner');
		$this->db->join('job_card AS JC','JC.id = JUE.job_card_id','inner');
		$this->db->limit(200);
		$this->db->order_by("JUE.work_done_date","desc");
		$rs = $this->db->get();
		if($rs->num_rows() > 0){
			return $rs->result_array();
		}else{
			return false;
		}
	}
	public function enquiryCount($salesman_id){
		if($salesman_id!=''){
			$sql=" and salesman_id='$salesman_id'";
		} else {
			$user_id	=	$this->session->userdata('user_id');
			$sql=" and salesman_id='$user_id'";
		}
		$result =   $this->db->query("SELECT IFNULL(sum(YEARWEEK(`enquiry_date`, 1) = YEARWEEK(CURDATE(), 1)),0) as enq_week_count,IFNULL(SUM(DATE_FORMAT(enquiry_date, '%Y-%m-01') = DATE_FORMAT(CURRENT_DATE(), '%Y-%m-01')),0) as enq_month_count,IFNULL(sum(YEAR(enquiry_date) = YEAR(CURDATE())),0) as enq_year_count FROM enquiry WHERE (status='1' OR status='2') ".$sql);
		return ($result->row_array());
	}

	public function enquiryPendingCount($salesman_id){
		if($salesman_id!=''){
			$sql=" and salesman_id='$salesman_id' ";
		} else {
			$user_id	=	$this->session->userdata('user_id');
			$sql=" and salesman_id='$user_id'";
		}
		$result =   $this->db->query("SELECT salesman_id, COUNT(*) AS count FROM enquiry WHERE status = '1'  ".$sql." ");
		return ($result->row_array());
	}
	public function enquiryUnallocatedCount(){
		$sql=" and salesman_id='0'";
		$result =   $this->db->query("SELECT salesman_id, COUNT(*) AS count FROM enquiry WHERE status = '1'  ".$sql." ");
		return ($result->row_array());
	}
	public function quotationsCount($salesman_id){
		if($salesman_id!=''){
			$sql=" and salesman_id='$salesman_id'";
		} else {
			$user_id	=	$this->session->userdata('user_id');
			$sql=" and salesman_id='$user_id'";
		}
		$result =   $this->db->query("SELECT IFNULL(sum(YEARWEEK(`quotation_date`, 1) = YEARWEEK(CURDATE(), 1)),0) as qtn_week_count,IFNULL(SUM(DATE_FORMAT(quotation_date, '%Y-%m-01') = DATE_FORMAT(CURRENT_DATE(), '%Y-%m-01')),0) as qtn_month_count,IFNULL(sum(YEAR(quotation_date) = YEAR(CURDATE())),0) as qtn_year_count FROM furniture_quotation WHERE 1 ".$sql);
		return ($result->row_array());
	}

	public function quotationsCount2($salesman_id){
		if($salesman_id!=''){
			$sql=" and salesman_id='$salesman_id'";
		} else {
			$user_id	=	$this->session->userdata('user_id');
			$sql=" and salesman_id='$user_id'";
		}
		$result =   $this->db->query("SELECT count(q.quotation_number_full) as count FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id  WHERE q.`quotation_status`='Draft' and t.group_by='1'  ".$sql." order by q.`quotation_id` ");
		return ($result->row_array());
	}

	
	public function withEstimatorCount($salesman_id){
		$user_id = $this->session->userdata('user_id');
		$sql=" and q.`salesman_id` = '$user_id'";
		
		$result= $this->db->query("SELECT count(q.quotation_number_full) as count FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id left join `users` u on u.user_id=t.trans_user_id   WHERE q.`quotation_status`='Draft' and group_by='3'  ".$sql." ");
		return ($result->row_array());
	}
	public function withApproverCount($salesman_id){
		$user_id = $this->session->userdata('user_id');
		$sql=" and q.`salesman_id` = '$user_id'";
		
		$result= $this->db->query("SELECT count(q.quotation_number_full) as count FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id WHERE q.`quotation_status`='Draft' and t.group_by='4'  ".$sql." ");
		return ($result->row_array());
	}	
	public function withApproverCountOpen($salesman_id){
		$user_id = $this->session->userdata('user_id');
		$sql=" and q.`salesman_id` = '$user_id'";
		
		$result= $this->db->query("SELECT count(q.quotation_number_full) as count FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id WHERE q.`quotation_status`='Open' and t.group_by='1'  ".$sql." ");
		return ($result->row_array());
	}	

	public function jobsNotCreatedCount($salesman_id){
		$user_id = $this->session->userdata('user_id');
		$sql=" and q.`salesman_id` = '$user_id'";
		
		$result= $this->db->query("SELECT count(q.quotation_number_full) as count FROM `view_furniture_quotations_client_project_users` q left join `job_card` j on j.quotation_id=q.quotation_id WHERE q.quotation_status='Confirmed' and j.job_card_number is null  ".$sql." ");
		return ($result->row_array());
	}	

	public function jobsCount($salesman_id){
		// if($salesman_id!=''){
		// 	$sql=" and salesman_id='$salesman_id'";
		// } else {
		// 	$user_id	=	$this->session->userdata('user_id');
		// 	$sql=" and salesman_id='$user_id'";
		// }
		$sql='';
		$result =   $this->db->query("SELECT IFNULL(sum(YEARWEEK(`job_card_date`, 1) = YEARWEEK(CURDATE(), 1)),0) as job_week_count,IFNULL(SUM(DATE_FORMAT(job_card_date, '%Y-%m-01') = DATE_FORMAT(CURRENT_DATE(), '%Y-%m-01')),0) as job_month_count,IFNULL(sum(YEAR(job_card_date) = YEAR(CURDATE())),0) as job_year_count FROM job_card WHERE job_card_status!='Completed' and job_card_status!='Cancelled' ".$sql);
		return ($result->row_array());
	}

	public function jobsCompletedCount(){
		$sql = "";
		$result = $this->db->query("SELECT COUNT(job_card_number) AS cmp_count FROM job_card WHERE job_card_status = 'Completed'");
		return $result->row();
	}

	public function jobsCancelledCount(){
		$sql = "";
		$result = $this->db->query("SELECT COUNT(job_card_number) AS cnl_count FROM job_card WHERE job_card_status = 'Cancelled'");
		return $result->row();
	}

	public function JobcardInvoiceCmplCount(){
		$sql = "";
		$result = $this->db->query("SELECT COUNT(invoice_number) AS invcmplete_count FROM furniture_invoice WHERE invoice_status = '0'");
		return $result->row();
	}
	public function JobcardInvoiceCnlCount(){
		$sql = "";
		$result = $this->db->query("SELECT COUNT(invoice_number) AS invc_cnl_count FROM furniture_invoice WHERE invoice_status = '1'");
		return $result->row();
	}

	public function pendingtoPickCount($salesman_id){
		$sql="";
		$result= $this->db->query("SELECT count(q.quotation_number_full) as count FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by`,`trans_action` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id left join `users` u on u.user_id=t.trans_user_id  WHERE q.`quotation_status`='Draft' and t.group_by='3' and t.`trans_user_id` is null  ".$sql);
		return ($result->row_array());
	}

	public function estimationQuotationsCount($salesman_id){
		if($salesman_id!=''){
			$sql=" and t.`trans_user_id` = '$salesman_id'";
		} else {
			$user_id	=	$this->session->userdata('user_id');
			$sql=" and t.`trans_user_id` = '$user_id'";
		}
		
		$result= $this->db->query("SELECT count(q.quotation_number_full) as count FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id  WHERE q.`quotation_status`='Draft' and t.group_by='3'  ".$sql."  ");
		return ($result->row_array());
	}

	public function estimationConfirmedCount($salesman_id){
		if($salesman_id!=''){
			$sql=" and t.`trans_user_id` = '$salesman_id'";
		} else {
			$user_id	=	$this->session->userdata('user_id');
			$sql=" and t.`trans_user_id` = '$user_id'";
		}
		
		$result= $this->db->query("SELECT count(quotation_number_full) as count from (SELECT q.quotation_number_full,t.trans_user_id,t.flow_id FROM `view_furniture_quotations_client_project_users` q inner join `log_for_quotation` t on (t.trans_id=q.quotation_id ) WHERE q.quotation_status='Confirmed' and t.flow_id=4 ".$sql." group by q.quotation_id) as m    ");
		return ($result->row_array());
	}

	public function myEstimationwithApproverCount($salesman_id){
		if($salesman_id!=''){
			$sql=" and t.`trans_user_id` = '$salesman_id'";
		} else {
			$user_id	=	$this->session->userdata('user_id');
			$sql=" and t.`trans_user_id` = '$user_id'";
		}
		
		$result= $this->db->query("SELECT count(quotation_number_full) as count from (SELECT q.quotation_number_full,q.status FROM `view_furniture_quotations_client_project_users` q inner join `log_for_quotation` t on (t.trans_id=q.quotation_id and flow_id=4) WHERE  (q.quotation_status='Draft' OR q.quotation_status='Open') and (q.status=5 OR q.status=7) ".$sql." group by q.quotation_id ) as m    ");
		return ($result->row_array());
	}

	public function pendingtoPickApproverCount($salesman_id){
		$sql="";
		$result= $this->db->query("SELECT count(q.quotation_number_full) as count FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id left join `users` u on u.user_id=t.trans_user_id  WHERE q.`quotation_status`='Draft' and t.group_by='4' and t.`trans_user_id` is null  ");
		return ($result->row_array());
	}

	public function pendingtoApproveCustomercount($salesman_id){
		$sql="";
		$result= $this->db->query("SELECT count(client_id) as count FROM `new_client_master` WHERE `cstatus`='2' ");
		return ($result->row_array());
	}

	public function pendingtoApproveCustomer($limit, $start,$search_item){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		if($this->session->userdata('user_group_id') == 1 ) {
			$sql='';
		} else {
			//$sql=" and q.`salesman_id` = '$user_id'";
		}
		if($search_item!=''){
			$sql.=" and ( `client_name` LIKE '%$search_item%' )";
		}
		$query= $this->db->query("SELECT * FROM `new_client_master` WHERE `cstatus`='2'  ".$sql." order by `client_name` desc limit ".$start.",".$limit);
		return $query->result();
	}

	public function forApprovalCount($salesman_id){
		$user_id	=	$this->session->userdata('user_id');
		$sql=" and t.`trans_user_id` = '$user_id'";
		$result= $this->db->query("SELECT count(q.quotation_number_full) as count FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id left join `users` u on u.user_id=t.trans_user_id  WHERE q.`quotation_status`='Draft' and t.group_by='4' ".$sql." ");
		return ($result->row_array());
	}

	public function forConfirmCount($salesman_id){
		$user_id	=	$this->session->userdata('user_id');
		$sql=" and t.`trans_user_id` = '$user_id'";
		$result= $this->db->query("SELECT count(q.quotation_number_full) as count FROM (SELECT `flow_id`,`trans_id`,`trans_user_id`,`group_by` FROM `view_log_for_quotation` WHERE `id` IN (SELECT max(`id`) as id FROM `view_log_for_quotation` WHERE 1 group by `trans_id`)) AS t INNER JOIN `view_furniture_quotations_client_project_users` q on q.quotation_id=t.trans_id left join `users` u on u.user_id=t.trans_user_id  WHERE q.`quotation_status`='Open' and t.flow_id='7' ".$sql." ");
		return ($result->row_array());
	}

	public function confirmedQuoteCount(){
		$user_id	=	$this->session->userdata('user_id');
		//$sql=" and t.`trans_user_id` = '$user_id'";
		$result= $this->db->query("SELECT count(q.quotation_number_full) as count FROM `view_furniture_quotations_client_project_users` q  WHERE q.`quotation_status`='Confirmed' ");
		return ($result->row_array());
	}

	public function pendingtoApproverPrCount($salesman_id){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		if($this->session->userdata('user_group_id') == 1 ) {
			$sql='';
		} else {
			//$sql=" and q.`salesman_id` = '$user_id'";
		}
		$result= $this->db->query("SELECT count(pr_id) as count FROM  `purchase_request` AS t left join `users` u on u.user_id=t.user_id  WHERE t.`status`='Rate Updated'  ".$sql." ");
		return ($result->row_array());
	}

	public function pendingtoApproverPoCount($salesman_id){
		//$sql	=	$this->OppLogin->mylist("username");
		$sql='';
		$user_id = $this->session->userdata('user_id');
		if($this->session->userdata('user_group_id') == 1 ) {
			$sql='';
		} else {
			//$sql=" and q.`salesman_id` = '$user_id'";
		}
		$result= $this->db->query("SELECT count(po_id) as count FROM  `po_h` AS t left join `users` u on u.user_id=t.user_id  WHERE t.`status`='Draft'  ".$sql." ");
		return ($result->row_array());
	}

	public function JobacardDiscountReqCount(){
		$user_id = $this->session->userdata('user_id');
		$result= $this->db->query("SELECT count(id) as count FROM `job_card`   WHERE  `dis_req_status`='0' AND `disc_req_to` = $user_id");
 		return ($result->row()->count);
	}
	public function JobacardDiscountCompCount(){
		$count = 0;
		$user_id = $this->session->userdata('user_id');
		$result= $this->db->query("SELECT * FROM `job_card`   WHERE  `dis_req_status`='1' AND `disc_req_from` = $user_id");
		if($result->num_rows() > 0){
			foreach ($result->result() as $rec) {
				$this->db->where('job_card_id', $rec->id);
				$finv_rs = $this->db->get('furniture_invoice');
				if ($finv_rs->num_rows() == 0) {
					$count++;
				}
				else{
					$count = 0;
				}
			}
			$count = $count;
		}
		else{
			$count = 0;
		}	
		return 	$count;
	}
		
	public function myJobs(){
		$where = array('job_card.salesman_id'=>$this->session->userdata('user_id'),'job_card.job_card_status!='=>'Completed');
		$this->db->select('job_card.id as job_card_id,job_card.*,new_client_master.*,furniture_quotation.*,users.*,company_division.*');
		$this->db->where($where);
		$this->db->where('job_card.job_card_status!=','Cancelled');
		$this->db->from('job_card');
		$this->db->join('new_client_master','new_client_master.client_id = job_card.client_id','left');
		$this->db->join('furniture_quotation','furniture_quotation.id = job_card.quotation_id','left');
		$this->db->join('users','users.user_id = job_card.salesman_id','left');
		$this->db->join('company_division','company_division.division_id = job_card.divisionid','left');
		$this->db->order_by("job_card.id","desc");
		$rs = $this->db->get();		
		if($rs->num_rows() > 0) {
			return $rs->result();
		} else {
			return false;
		}	
	}

	public function myQuoteNotCreatedJobs(){
		$user_id=$this->session->userdata('user_id');
		$where = "q.salesman_id='$user_id' and q.quotation_status='Confirmed' AND j.job_card_number is null";
		$this->db->select('q.*');
		$this->db->where($where);
		$this->db->from('view_furniture_quotations_client_project_users as q');
		$this->db->join('job_card j','j.quotation_id = q.quotation_id','left');
		$this->db->order_by("q.quotation_id","desc");
		$rs = $this->db->get();		
		if($rs->num_rows() > 0) {
			return $rs->result();
		} else {
			return false;
		}	
	}

	public function jobcardDiscountlist(){
		$user_id=$this->session->userdata('user_id');
		$where = "j.disc_req_to='$user_id' and j.dis_req_status='0' ";
		$this->db->select('j.*,NCM.client_name');
		$this->db->where($where);
		$this->db->from('job_card as j');
		$this->db->join('new_client_master NCM','NCM.client_id = j.client_id','left');
		$this->db->order_by("j.id","desc");
		$rs = $this->db->get();	
		if($rs->num_rows() > 0) {
			return $rs->result();
		} else {
			return false;
		}	
	}

	public function jobcardDiscountcompletedlist() {
		$returncmpArray = [];
		$user_id = $this->session->userdata('user_id');
		$where = "j.disc_req_from='$user_id' and j.dis_req_status='1' ";
		$this->db->select('j.*, NCM.client_name');
		$this->db->from('job_card as j');
		$this->db->join('new_client_master NCM', 'NCM.client_id = j.client_id', 'left');
		$this->db->where($where);
		$this->db->order_by("j.id", "desc");
		$rs = $this->db->get();
	
		if ($rs->num_rows() > 0) {
			foreach ($rs->result() as $rec) {
				$this->db->where('job_card_id', $rec->id);
				$finv_rs = $this->db->get('furniture_invoice');
				//echo $this->db->last_query();
				if ($finv_rs->num_rows() == 0) {
					$returncmpArray[] = $rec;
				}
			}
		} else {
			$returncmpArray = false;
		}
		//var_dump($returncmpArray);
		return $returncmpArray;
	}

	public function myInvoices(){
		$where = array( 'furniture_invoice.invoice_status='=>0);
		$this->db->select('furniture_invoice.*,job_card.reg_no,job_card.client_id,job_card.make,job_card.model');
		$this->db->where($where);
		$this->db->from('furniture_invoice');
		$this->db->join('job_card','job_card.id = furniture_invoice.job_card_id','left');
		//$this->db->join('furniture_quotation','furniture_quotation.id = job_card.quotation_id','left');
		//$this->db->join('users','users.user_id = job_card.salesman_id','left');
		//$this->db->join('company_division','company_division.division_id = job_card.divisionid','left');
		$this->db->order_by("furniture_invoice.invoice_id","desc");
		$rs = $this->db->get();
		if($rs->num_rows() > 0) {
			return $rs->result();
		} else {
			return false;
		}	
	}

	public function cancelledInvoices(){
		$where = array( 'furniture_invoice.invoice_status!='=>0);
		$this->db->select('furniture_invoice.*,job_card.reg_no,job_card.client_id,job_card.make,job_card.model');
		$this->db->where($where);
		$this->db->from('furniture_invoice');
		$this->db->join('job_card','job_card.id = furniture_invoice.job_card_id','left');
		//$this->db->join('furniture_quotation','furniture_quotation.id = job_card.quotation_id','left');
		//$this->db->join('users','users.user_id = job_card.salesman_id','left');
		//$this->db->join('company_division','company_division.division_id = job_card.divisionid','left');
		$this->db->order_by("furniture_invoice.invoice_id","desc");
		$rs = $this->db->get();
		if($rs->num_rows() > 0) {
			return $rs->result();
		} else {
			return false;
		}	
	}

	public function invCount2($salesman_id){
		$where = array('job_card.salesman_id'=>$this->session->userdata('user_id'),'furniture_invoice.invoice_status!='=>0);
		$this->db->select('furniture_invoice.*,users.*,job_card.project_name');
		$this->db->where($where);
		$this->db->from('furniture_invoice');
		$this->db->join('job_card','job_card.id = furniture_invoice.job_card_id','left');
		//$this->db->join('furniture_quotation','furniture_quotation.id = job_card.quotation_id','left');
		$this->db->join('users','users.user_id = job_card.salesman_id','left');
		//$this->db->join('company_division','company_division.division_id = job_card.divisionid','left');
		$this->db->order_by("furniture_invoice.invoice_id","desc");
		$rs = $this->db->get();
		return ($rs->num_rows());
	}
	public function invCount($salesman_id){
		if($salesman_id!=''){
			$sql=" and jc.salesman_id='$salesman_id'";
		} else {
			$user_id = $this->session->userdata('user_id');
			$sql=" and jc.salesman_id='$user_id'";
		}
		$result =   $this->db->query("SELECT IFNULL(sum(t.invoice_count),0) as invoice_count,jc.salesman_id,sum(pending_amount) as pending_amount FROM (SELECT count(fi.job_card_id) as invoice_count,fi.job_card_id,sum(`invoice_percentage`) as check_percentage,(`invoice_amount`-sum(`invoice_percentage_amount`)) as pending_amount FROM `furniture_invoice` fi    where fi.invoice_status=0 group by fi.job_card_id having check_percentage<100 ) AS t inner join job_card jc on jc.id=t.job_card_id where 1 ".$sql );
		return ($result->row_array());
	}
	public function recAmt($salesman_id){
		if($salesman_id!=''){
			$sql=" and salesman_id='$salesman_id'";
		} else {
			$user_id	=	$this->session->userdata('user_id');
			$sql=" and jc.salesman_id='$user_id'";
		}
		$result =   $this->db->query("SELECT sum(os_amount) as receivables_amount FROM (SELECT cba.`bill_id`,cba.`trn_no`,round(sum(cba.`bill_os_amount`),3) as os_amount,jc.salesman_id  FROM `cust_bill_allocations` cba inner join furniture_invoice fi on fi.invoice_id=cba.bill_id  inner join job_card jc on jc.id=fi.job_card_id WHERE cba.trn_type in ('Invoice','Receipt','Credit Note') and cba.`status`='1' ".$sql." group by cba.`bill_id`  having os_amount!=0) as t");
		return ($result->row_array());
	}
	public function jobDepartmentwise(){
		$sql="";
		$result =   $this->db->query("SELECT `labour_department`,sum(`labour_total_man_hours`)/8 as no_of_days,dm.department_id,dm.man_power,jc.`job_card_status` FROM `set_departments` sd inner join `department_master` dm on sd.department_id=dm.department_id inner join `job_estimation_labourcost` jel on jel.job_card_details_id=sd.job_card_details_id and dm.department_name=jel.labour_department inner join `job_card` jc on jc.id=sd.`job_card_id` WHERE jc.`job_card_status`!='Closed' AND jc.`job_card_status`!='Cancelled' and (sd.`status`='3' or sd.`status`='2') group by sd.`department_id`");
		return ($result->result_array());
	}

	public function validate_debit_or_credit($payment_code, $payment_type){
		$this->db->where('vch_no', $payment_code);
		$this->db->where('vch_type', $payment_type);
		$this->db->where('status', '1');
		$this->db->select_sum('ledger_amount');
		$rs = $this->db->get('accounts');
		$sumLedgerAmount = $rs->row()->ledger_amount;
		if ($sumLedgerAmount == 0) {
			return true;
		} else {
			return false;
		}
	}

	function sendmail($from,$fromname,$to,$subject,$message,$cc,$bcc)
	{
		$this->load->library('email');
		$config = array();
		$config['useragent'] = "CodeIgniter";
		$config['mailpath']  = "/usr/bin/sendmail";
		$config['protocol']  = "smtp";
		$config['smtp_host'] = "smtp.ipage.com";
		$config['smtp_user'] = "autotalli@q-pro.in";
		$config['smtp_pass'] = "Atalli123@";        
		$config['smtp_port'] = "587";
		$config['mailtype']  = 'html';
		$config['charset']   = 'utf-8';
		$config['newline']   = "\r\n";
		$config['wordwrap']  = TRUE;
		$this->load->library('email');
		$this->email->initialize($config);        
		$this->email->subject($subject);
		$this->email->message($message);
		$this->email->from( "autotalli@q-pro.in", 'Nabas', 'autotalli@q-pro.in'  );        
		$this->email->to($to);
		if($this->email->send())
		{
			return true;
		}
		else
		{
			return false;
		}
			
	}

	public function getItemRow($item_id){
		$this->db->select('*');
		$this->db->where('id',$item_id);
		$rs = $this->db->get('items');
		if ($rs->num_rows() > 0) {
			 return $rs->row();
		} else {
			return false;
		}
	}

	public function isBeginCheck(){
		$technician_id = $this->session->userdata('technician_id');
		$res = $this->db->query("SELECT * FROM `technician_wise_log` WHERE `user_id` = '".$technician_id."' and `job_status`='begin'  AND `end_time` IS NULL AND job_flag = 0 order by date(job_date) DESC LIMIT 1");
		if ($res->num_rows() > 0) {
            $row = $res->row();
			$taskres = $this->db->query("SELECT * FROM `job_card_technician` WHERE `technician_id` = '".$technician_id."' AND job_detail_id='".$row->job_detail_id."' AND progress_status = 20");
			
			if ($taskres->num_rows() > 0) {
				return true;
			}
		}
		else{
			return false;
		}
	}
}
?>