<?php

class Technician_model extends CI_Model {

	public function __construct() {
	
		// Call the Model constructor
		parent::__construct();
	}

	function get_employee($where = array(),$limit=null,$offset=null,$order_by_field=null,$order_by_order=null,$like=null, $or_where=null){

		if(!is_null($offset) and !is_null($limit)){
			$this->db->limit($limit,$offset);
		}
		if($order_by_field != null and $order_by_order != null){
			$this->db->order_by($order_by_field, $order_by_order);
		}

		if($like !=null && is_array($like)) {
			foreach($like as $key=>$value) {
				$this->db->like($key, $value);
			}
		}
		
		if($or_where) {
			$this->db->or_where($or_where);
		}
	
		$this->db->select('employee.*,country_master.Country');
		$this->db->where($where);
		$this->db->from('employee');
		$this->db->join('country_master','country_master.id = employee.nationality','left');
		$rs = $this->db->get();
		
		if($rs->num_rows() > 0){
			return $rs->row_array();
		}
		else{
			return false;
		}
	}

	function get_count_with_group_by($table_name = '', $where = array(), $group_by = '') {
		$this->db->select('COUNT(*) as count');
		if (!empty($group_by)) {
			$this->db->group_by($group_by);
		}
		$rs = $this->db->get_where($table_name, $where);
		return $rs->num_rows();
	}

	public function new_technician_job_count(){
		$technician_id = $this->session->userdata('technician_id');
		//and jt.service_troubleshoot=1
		//$result= $this->db->query("SELECT COUNT(DISTINCT `job_id`) as count FROM `job_card_technician` jt WHERE jt.`technician_id`=$technician_id  and jt.`job_technician_status`=2 and jt.progress_status!=20");
		$result= $this->db->query("SELECT COUNT(DISTINCT jt.`job_id`) as count 
				FROM `job_card_technician` jt 
				WHERE jt.`job_id` NOT IN (
				SELECT `job_id` 
				FROM `job_card_technician` 
				WHERE `progress_status` = 20
				) 
				AND jt.`technician_id`=$technician_id 
				AND jt.`job_technician_status`=2");
		return ($result->row_array());
	}
	public function in_progress_technician_job_count(){
		$technician_id = $this->session->userdata('technician_id');
		//and jt.service_troubleshoot=1
		$result= $this->db->query("SELECT COUNT(DISTINCT `job_id`) as count FROM `job_card_technician` jt WHERE jt.`technician_id`=$technician_id and jt.progress_status=20");
		return ($result->row_array());
	}

	public function new_technician_job_list(){
		$technician_id = $this->session->userdata('technician_id');
		//and jt.service_troubleshoot=1
		//$result= $this->db->query("SELECT DISTINCT(jt.`job_id`),jt.technician_id,jc.job_card_number,jc.job_card_date,jc.reg_no,mk.title as v_make,md.title as v_model FROM `job_card_technician` jt inner join `job_card` jc on jc.id=jt.job_id INNER JOIN make mk on mk.id=jc.make INNER JOIN `model` md on md.id=jc.model WHERE jt.`technician_id`=$technician_id and jt.`job_technician_status`=2 and jt.progress_status!=20");
		$result= $this->db->query("SELECT DISTINCT(jt.`job_id`),jt.technician_id,jc.job_card_number,jc.job_card_date,jc.reg_no,mk.title as v_make,md.title as v_model 
				FROM `job_card_technician` jt 
				inner join `job_card` jc on jc.id=jt.job_id INNER JOIN make mk on mk.id=jc.make INNER JOIN `model` md on md.id=jc.model
				WHERE jt.`job_id` NOT IN (
				SELECT `job_id` 
				FROM `job_card_technician` 
				WHERE `progress_status` = 20
				) 
				AND jt.`technician_id`=$technician_id 
				AND jt.`job_technician_status`=2");
		return ($result->result_array());
	}
	public function in_progress_technician_job_list(){
		$technician_id = $this->session->userdata('technician_id');
		//and jt.service_troubleshoot=1
		$result= $this->db->query("SELECT DISTINCT(jt.`job_id`),jt.technician_id,jc.job_card_number,jc.job_card_date,jc.reg_no,mk.title as v_make,md.title as v_model FROM `job_card_technician` jt inner join `job_card` jc on jc.id=jt.job_id INNER JOIN make mk on mk.id=jc.make INNER JOIN `model` md on md.id=jc.model WHERE jt.`technician_id`=$technician_id and jt.progress_status=20");
		return ($result->result_array());
	}
	public function job_list_item_wise($job_id){
		$technician_id = $this->session->userdata('technician_id');
		//and jt.service_troubleshoot=1
		$result= $this->db->query("SELECT jt.*,jcd.furniture_description FROM `job_card_technician` jt inner join job_card_details jcd on jcd.job_card_details_id=jt.job_detail_id WHERE jt.`job_id` =$job_id and jt.`technician_id`=$technician_id and (jt.`job_technician_status`=2 or jt.`job_technician_status`=3 ) ");
		return ($result->result_array());
	}
	public function geJobBegin($job_id, $technician_id){
		$qry = $this->db->query("SELECT * FROM `technician_wise_log` WHERE `job_id`='$job_id'  AND `user_id` = '$technician_id' AND `job_status` = 'begin' AND job_flag = 0 AND `end_time` IS NULL AND `job_duration` IS NULL ");
		if($qry->num_rows() > 0){
			return $qry->row();
		} else {
			return false;
		}		
	}
	public function beginJob($job_detail_id, $job_id, $job_no, $status, $job_status,$technician_id){
		$toDay = date("Y-m-d H:i:s");
		if($technician_id!=''){
			$qry = $this->db->query("UPDATE `job_card_technician` SET  `progress_status` = '".$status."'   WHERE `job_detail_id` ='".$job_detail_id."' and `technician_id` ='".$technician_id."' ");
			if ($qry) {
				$selectqry = $this->db->query("SELECT * FROM `technician_wise_log`WHERE end_time IS NULL AND job_status = 'begin' AND `user_id` ='".$technician_id."' and  `job_flag`=0 order by log_id DESC LIMIT 1");
				if ($selectqry->num_rows() > 0) {
					$result = $selectqry->row();
					$starttimestamp = strtotime($result->job_date);
					$endtimestamp = strtotime($toDay);
					$timediff = abs($endtimestamp - $starttimestamp);
					$hours = floor($timediff / 3600);
					$minutes = floor(($timediff % 3600) / 60);
					$seconds = $timediff % 60;
					$duration = sprintf('%02d:%02d:%02d', $hours, $minutes, $seconds);
					$statusUpdate = $this->db->query("UPDATE `technician_wise_log` SET `job_duration`= '".$duration."',`end_time` = '". $toDay."' WHERE job_status = 'begin' AND `end_time` IS NULL AND`user_id` ='". $technician_id."' AND job_flag = 0 AND `log_id` = '". $result->log_id."' ");
					/* if($statusUpdate){
						$this->db->query("UPDATE `job_card_technician` SET  `progress_status` = 0 WHERE  `technician_id` ='".$technician_id."' AND `job_detail_id` ='".$result->job_detail_id."'");
					} */
				}
				$this->db->query("INSERT INTO `technician_wise_log`(
					`job_detail_id`,
					`job_id`,
					`job_no`,
					`job_date`,
					`user_id`,
					`job_status`)
					VALUES (
					'".$job_detail_id."',
					'".$job_id."',
					'".$job_no."',
					'".$toDay."',
					'".$technician_id."',
					'".$job_status."')");
				return true;
			} else {
				return false;
			}		
		}
	}
	public function completeJob( $job_detail_id, $job_id, $job_no, $status, $job_status,$technician_id){
		$toDay = date("Y-m-d H:i:s");
		if($technician_id!=''){
			$qry = $this->db->query("UPDATE `job_card_technician` SET  `progress_status` = '20'   WHERE `job_detail_id` ='".$job_detail_id."' and `technician_id` ='".$technician_id."' ");
			if ($qry) {
				$selectqry = $this->db->query("SELECT * FROM `technician_wise_log` WHERE end_time IS NULL AND job_status = 'begin' AND job_flag = 0 AND `user_id` ='".$technician_id."'");
				if ($selectqry->num_rows() > 0) {
					$result = $selectqry->row();
					$starttimestamp = strtotime($result->job_date);
					$endtimestamp = strtotime($toDay);
					$timediff = abs($endtimestamp - $starttimestamp);
					$hours = floor($timediff / 3600);
					$minutes = floor(($timediff % 3600) / 60);
					$seconds = $timediff % 60;
					$duration = sprintf('%02d:%02d:%02d', $hours, $minutes, $seconds);
					$statusUpdate = $this->db->query("UPDATE `technician_wise_log` SET `job_duration`= '".$duration."',`end_time` = '". $toDay."' WHERE job_status = 'begin' AND `end_time` IS NULL AND `user_id` ='". $technician_id."' AND job_flag = 0 AND `log_id` = '". $result->log_id."' ");
				}

				$sql = $this->db->query("SELECT * FROM `job_card_technician` WHERE `job_detail_id` ='".$job_detail_id."' and progress_status IN (0,20) and `technician_id` ='".$technician_id."' ");
				if ($sql->num_rows() > 0) {
					//,`progress_status` = 30
					$this->db->query("UPDATE `job_card_technician` SET `job_technician_status` = 3 WHERE  `job_detail_id` ='".$job_detail_id."' and `technician_id` ='".$technician_id."' ");
				}

				$iscompletedsql = $this->db->query("SELECT * FROM `job_card_technician` WHERE `job_id` ='".$job_id."' AND `technician_id` ='".$technician_id."' and `job_technician_status` = 3 ");
				$assignedcount = $this->db->query("SELECT * FROM `job_card_technician` WHERE `job_id` ='".$job_id."' AND `technician_id` ='".$technician_id."' ");
 				if ($iscompletedsql->num_rows() == $assignedcount->num_rows()) {
					$this->db->query("UPDATE `job_card_technician` SET `progress_status` = 30 WHERE `job_id` ='".$job_id."'  AND `technician_id` ='".$technician_id."' ");
				}
				$iscompletedallsql = $this->db->query("SELECT * FROM `job_card_technician` WHERE `job_id` ='".$job_id."' and job_technician_status=3");
				if ($iscompletedallsql->num_rows() == 0) {
					$this->db->query("UPDATE `job_card_details` SET `job_status` = 3 WHERE `job_id` ='".$job_id."'");
				}
				$this->db->query("INSERT INTO `technician_wise_log`(
					`job_detail_id`,
					`job_id`,
					`job_no`,
					`job_date`,
					`user_id`,
					`job_status`)
					VALUES (
					'".$job_detail_id."',
					'".$job_id."',
					'".$job_no."',
					'".$toDay."',
					'".$technician_id."',
					'".$job_status."')");
				return true;
			} else {
				return false;
			}
		}
	}
	public function search_job_technician($reg_no){
		$technician_id = $this->session->userdata('technician_id');
		$result= $this->db->query("SELECT jc.id as job_card_id,jc.job_card_number,jt.*,jcd.furniture_description FROM `job_card` jc inner join `job_card_technician` jt on jt.job_id=jc.id inner join job_card_details jcd on jcd.job_card_details_id=jt.job_detail_id WHERE jc.`reg_no` = '$reg_no' and jc.`job_card_status`='Draft' AND jt.technician_id='$technician_id' AND jt.job_technician_status=2;");
		return ($result->result_array());
	}

	public function CheckopenedJobtechnician($job_id,$technician_id){
		$userid = $technician_id;
		$res = $this->db->query("SELECT * FROM `technician_wise_log` WHERE `user_id` = '".$userid."' and `job_status`='begin'  AND `end_time` IS NULL AND `job_flag` = 0 order by date(job_date) DESC LIMIT 1");
 		if ($res->num_rows() > 0) {
            $row = $res->row();
			$taskres = $this->db->query("SELECT * FROM `job_card_technician` WHERE `technician_id` = '". $userid."' AND job_detail_id='".$row->job_detail_id."' AND job_id='".$row->job_id."' AND progress_status = 20");
 			if ($taskres->num_rows() > 0) {
				return $taskres->row();
			}
			else{
				return false;
			}
		}
		else{
			return false;
		}
	}
}
?>