
	<style>
		div.dt-buttons {
			float: right;
			padding-left: 15px;
			padding-right: 15px;
		}
		.dataTables_length {
			position: absolute;
		}
	</style>
    <!--app-content open-->
	<div class="app-content main-content">
		<div class="side-app">
			<div class="main-container">
				<!-- PAGE-HEADER -->
				<div class="page-header">
					<div class="col-xl-5 col-lg-6 col-md-5 col-sm-6">
						<h1 class="page-title">Credit Note List</h1>
                    </div>
					<div class="col-xl-7 col-lg-6 col-md-7 col-sm-6">
                        <div class="float-sm-end float-none my-1">
							<?php if($this->users_model->check_permission("Credit_note","Add")!=false){ ?>
							<a id="add__new__list" type="button" class="btn btn-md btn-primary " data-bs-target=".bd-example-modal-lg" href="<?php echo site_url('Credit_note/create_credit_note');?>"><i class="fa fa-plus"></i> Add a new Credit Note</a>
							<?php } ?>
						</div>
                    </div>
				</div>
			</div>
			<!-- PAGE-HEADER END -->
			<!-- ROW-1 -->
			<div class="row">
				<div class="col-md-12 col-lg-12">
					<div class="card">
						<div class="card-body">
							<h3 class="card-title">Credit Note List</h3>
						</div>
						<?php
							if($this->session->flashdata("response")!='') {
								echo '<div class="alert alert-danger">' . $this->session->flashdata("response") . '</div>';
								$this->session->unset_userdata('response');
							}
						?>
						<?php
							if($this->session->flashdata("success")!='') {
								echo '<div class="alert alert-success">' . $this->session->flashdata("success") . '</div>';
								$this->session->unset_userdata('success');
							}
						?>
						<div class="table-responsive">
							<table id="receipt_data" class="table card-table ">
								<thead class="thead-light"  >
									<tr>
										<th>Credit Note No</th>
										<th>Client</th>
										<th>Date</th>
										<th>Amount</th>
										<th>Action</th>
									</tr>
								</thead>
								<tbody>
									<?php
										//$DeletePermission=$this->users_model->check_permission("Credit_note","Delete");
										$EditPermission=$this->users_model->check_permission("Credit_note","Edit");
										if($receipts != false) {
											foreach($receipts as $receipts) {
												$style='';
			
												if($receipts['credit_note_status']=='0'){
													$style= 'style="background: #f5d2d2;color:#6b1110;"';
												} else {
													$style='';
												}
									?>
									<tr <?php  echo $style;?> >
										<td>
											<?php echo $receipts['credit_note_code'];?>
										</td>
										<td><?php echo $receipts['client_name'];?></td>
										<td><?php echo date('M d,Y',strtotime ($receipts['credit_note_date']));?></td>
										<td><?php echo number_format($receipts['net_amount'],3);?></td>
										<td style="width:100px;">
											<div class="btn-group">
												<button type="button" class="btn btn-sm btn-primary dropdown-toggle" data-bs-toggle="dropdown">
												Action <span class="caret"></span>
												</button>
												<ul class="dropdown-menu" role="menu">
													<li><a class="click2" target="_blank" href="<?php echo site_url('Credit_note/view1/'.$receipts["credit_note_id"].'/'.$receipts['credit_note_number'].'/'.$receipts['quotation_divisionid'].'/pdf'); ?>"  ><i class="fa fa-print"></i> Print</a></li>
													<?php if($EditPermission){ ?>
														<li><a class="click2" href="javascript:ConfirmDelete('<?php echo $receipts['credit_note_number'];?>','<?php echo $receipts['quotation_divisionid'];?>','<?php echo $receipts['credit_note_id'];?>','<?php echo $receipts['credit_note_code'];?>')"  ><i class="fa fa-mail-forward"></i> Cancel</a></li>
													<?php } ?>
												</ul>
											</div>
										</td>
									</tr>
									<?php } } ?>
								</tbody>
							</table>
						</div>
						<?php echo $pagination; ?>
						<!-- table-responsive -->
					</div>
				</div>
			</div>
			<!-- ROW-1 CLOSED -->
		</div>
	</div>
						</div>
						<!-- ROW-4 CLOSED -->
					</div>
				</div>
				<!-- CONTAINER CLOSED -->
			</div>

	<script type="text/javascript">
		$(function(e) {
			$('#receipt_data').DataTable({
				"paging": true,
				"processing": true,
				"scrollCollapse": true,
				"order": [[0, 'desc']],
				"iDisplayLength": 100,
				"lengthMenu": [ [100, 150, 200, -1], [100, 150, 200, "All"] ],
				"info": true,
				"pagingType": 'full_numbers',
				dom: 'lBfrtip',
				buttons: [
					{ extend: 'copyHtml5',title: '',text: 'Copy',header: false, text:'<i class="fa fa-copy"></i>',titleAttr: 'Copy', className: 'btn-primary' },
					{ extend: 'excelHtml5',title: 'Receipt Data',filename: function(){ var today = new Date();var n = today.getTime();return 'ReceiptExcelExport' + today.getDate().toString()+(today.getMonth()+1)+today.getFullYear(); },text: 'Excel', text:'<i class="fa fa-file-excel-o"></i>',titleAttr: 'Excel', className: 'btn-success' },
					{ extend: 'print',title: 'Receipt Data',filename: function(){ var today = new Date();var n = today.getTime();return 'ReceiptPrintExport' + today.getDate().toString()+(today.getMonth()+1)+today.getFullYear(); },text: 'Print', text:'<i class="fa fa-print"></i>',titleAttr: 'Print', className: 'btn-warning' },
					
				]
			});
			//
			// Select2 { extend: 'csvHtml5',text: 'CSV',header: false, text:'<i class="fa fa-file-pdf-o"></i>',titleAttr: 'CSV', className: 'btn-warning' },
			//{ extend: 'colvis',title: '',filename: 'fileName',text: 'Pdf', text:'<i class="fa fa-file-pdf-o"></i>',titleAttr: 'Pdf', className: 'btn-warning' },
		});
		function ConfirmDelete(receipt_number,quotation_divisionid,receipt_id,receipt_code){
			$('body').removeClass('timer-alert');
			swal({
					title: "Alert",
					text: "Are you sure you want to Cancel this Credit Note ??",
					type: "warning",
					showCancelButton: true,
					confirmButtonText: 'Yes',
					cancelButtonText: 'Cancel'
				},
				function(isConfirm){
				if (isConfirm) {
					document.location.href="<?php echo site_url('Credit_note/cancel_credit_note'); ?>/"+receipt_number+"/"+quotation_divisionid+"/"+receipt_id+"/"+receipt_code;
					//window.location = "Receipt/cancel_receipt/"+receipt_number+"/"+quotation_divisionid+"/"+receipt_id;
				} else {
					swal("Cancelled", "Something went wrong :)", "error");
				}
			});
		}
	</script>
