<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Admin extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */

	function __construct() {
		parent::__construct();

		$this->load->model('general_model');
		$this->load->library('form_validation');
		$this->load->library('session');
		$this->load->helper("url");
		//$this->load->library('encrypt');
		$this->load->library('pagination');
		$this->load->helper('date');

		if(!isset($_SESSION['logged_in'])) {
            $this->session->set_flashdata('registerMessage','Please Login First',':old:');
            return redirect('index.php/welcome/login');
        }
		
	}

	public function index()
	{
		redirect(base_url().'index.php/admin/dashboard');
	}

	public function dashboard(){
		$data['currentMenu'] = 'dashboard';
		$data['pageType'] = 'Admin';
		$data['pageHeading'] = 'Dashboard';
		$data['pageTitle'] = "Dashboard | ".HEX_APPLICATION_NAME;
		if(($this->session->userdata('adminAccess')) == 1){
			$data['viewAdminDashboardLink'] = 1;
		}else{
			$data['loginLink'] =1;
		}

		
		
		$this->load->view('templates/header',$data);
		$this->load->view('admin/dashboard/dashboard',$data);
		$this->load->view('templates/footer');
	}

	public function settings(){

		$where = array('companyID'	=> 1);
		$data['settings'] = $this->general_model->get('gen_settings',$where);


		$data['currentMenu'] = 'settings';
		$data['pageType'] = 'Settings';
		$data['pageHeading'] = 'Settngs';
		$data['pageTitle'] = "Settings | ".HEX_APPLICATION_NAME;
		if(($this->session->userdata('adminAccess')) == 1){
			$data['viewAdminDashboardLink'] = 1;
		}else{
			$data['loginLink'] =1;
		}



		$data['loginRedirect']=base_url().'index.php/admin/updateSettings';
		
		$this->load->view('templates/header',$data);
		$this->load->view('admin/settings/settings',$data);
		$this->load->view('templates/footer');
	}

	public function updateSettings(){
		if(!isset($_SESSION['admin_logged_in'])){
			redirect(base_url());
		}

		$this->form_validation->set_rules('companyName', 'Company Name', 'required');
		$this->form_validation->set_rules('companyAddress1', 'Company Address', 'required');

		if ($this->form_validation->run() == FALSE) {	
			$this->session->set_flashdata('registerMessage',validation_errors(),':old:');
			redirect(base_url().'index.php/admin/settings');
		}else{

			$companyLogo ="";
			if (isset($_FILES['companyLogo']) && !empty($_FILES['companyLogo']['tmp_name'])){
				$config['upload_path'] 		= './uploads/';
				$config['allowed_types']    = 'jpg|png';
				$config['max_size']         = 5000000;
				$config['max_width']        = 1024000;
				$config['max_height']       = 7680000;
				$config['encrypt_name'] 		= TRUE;
				$this->load->library('upload', $config);
				if ( ! $this->upload->do_upload('companyLogo')){
					$this->session->set_flashdata('registerMessage',$this->upload->display_errors(),':old:');
					$companyLogo ="";
				}else{
					$dataUpload = $this->upload->data();
					$companyLogo = $dataUpload['file_name']; 
				}
			}

			$data = array(
				'companyName'		 		=>	$this->input->post('companyName'),
				'companyAddress1'   =>  $this->input->post('companyAddress1'),
				'companyAddress2' 	=>  $this->input->post('companyAddress2'),
				'companyTRN'   			=>  $this->input->post('companyTRN')
			);

			if($companyLogo !=""){
				$data['companyLogo'] = $companyLogo;
			}

			$where = array(
				'companyID'					=> 1
			);
			$this->general_model->update('gen_settings',$data,$where);
			$this->session->set_flashdata('registerMessage','Settings Upddated Successfully',':old:');
			redirect(base_url().'index.php/admin/settings');
		}
	}

	
}
