<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Api extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	
	function __construct() {
		parent::__construct();

		$this->load->model('general_model');
		$this->load->library('form_validation');
		$this->load->library('session');
		$this->load->helper("url");
		$this->load->library('pagination');
		$this->load->helper('date');
		
	}

	// 01. Salesman Login
	public function login(){
		$obj = array();
		$username = $_POST['username'];
    $userPassword = $_POST['userPassword'];
    $user_record = $this->general_model->check_salesman_login($username,$userPassword);
    if($user_record == false){
			// throw invalid email id or password error
			$obj['status'] = 0;
      $obj['message'] = 'Invalid Login or Password';
		}else{
			$obj['userID'] = $user_record['salesmanID'];
			$obj['userFullName'] = $user_record['salesmanName'];
			$obj['status'] = 1;
      $obj['message'] = 'Success';
		}

		echo json_encode($obj);
	}

	// 02. Day Open
	public function dayOpen(){
		$obj = array();
		$salesmanID = $_POST['salesmanID'];
    $transactionDate = strtotime($_POST['transactionDate']);

    $whereCheck = array(
    	'salesman'	=> $salesmanID,
    	'status'		=> 1
    );

    $checkCount = $this->general_model->getCount('trn_day_open_close', $whereCheck);
    if($checkCount > 0){
    	$openedDays = $this->general_model->get('trn_day_open_close', $whereCheck);
    	$obj['openedDate'] = $openedDays[0]['date'];
    	$obj['status'] = 0;
      $obj['message'] = 'Another day is already opened.';
    }else{
    	$where = array(
	    	'salesman'	=> $salesmanID,
	    	'date'			=> date('Y-m-d', $transactionDate)
	    );

	    $count = $this->general_model->getCount('trn_day_open_close', $where);

	    if($count > 0){
	    	$obj['status'] = 0;
	      $obj['message'] = 'Day is already opened';
	    }else{
	    	$data = array(
	    		'salesman'			=> $salesmanID,
	    		'date'					=> date('Y-m-d', $transactionDate),
	    		'dayOpenTime'		=> date('Y-m-d H:i:s'),
	    		'status'				=> 1
	    	);

	    	$this->general_model->insert('trn_day_open_close', $data);

				$obj['status'] = 1;
	      $obj['message'] = 'Day opened Successfully';    	
	    }
    }
    
    echo json_encode($obj);
	}

	// 03. Day Close
	public function dayClose(){
		$obj = array();
		$salesmanID = $_POST['salesmanID'];
    $transactionDate = strtotime($_POST['transactionDate']);

    // Check Whether Day is Opened or Not
    $whereCheckOpen = array(
    	'salesman'	=> $salesmanID,
    	'date'			=> date('Y-m-d', $transactionDate),
    	'status'		=> 1
    );
		$openCount = $this->general_model->getCount('trn_day_open_close', $whereCheckOpen);

    if($openCount > 0){
    	// Check Whether Day is already closed or not
    	$whereCheckClose = array(
	    	'salesman'	=> $salesmanID,
	    	'date'			=> date('Y-m-d', $transactionDate),
	    	'status'		=> 2
	    );
			$closeCount = $this->general_model->getCount('trn_day_open_close', $whereCheckClose);

	    if($closeCount > 0){
	    	$obj['status'] = 0;
      	$obj['message'] = 'Day is already closed';
	    }else{
	    	$data = array(
	    		'dayCloseTime'	=> date('Y-m-d H:i:s'),
	    		'status'				=> 2
	    	);

	    	$where = array(
	    		'salesman'			=> $salesmanID,
	    		'date'					=> date('Y-m-d', $transactionDate),
	    		'status'				=> 1
	    	);

	    	$this->general_model->update('trn_day_open_close', $data, $where);

				$obj['status'] = 1;
	      $obj['message'] = 'Day closed Successfully'; 
	    }
    }else{
    	$obj['status'] = 0;
      $obj['message'] = 'You should open the day first';
		}
    echo json_encode($obj);
	}

	// 04. Check Day Open/Close
	public function checkDayOpenClose(){
		$obj = array();
		$salesmanID = $_POST['salesmanID'];
    $transactionDate = strtotime($_POST['transactionDate']);

    // Check Whether Day is Opened or Not
    $whereCheckOpen = array(
    	'salesman'	=> $salesmanID,
    	'date'			=> date('Y-m-d', $transactionDate),
    	'status'		=> 1
    );
		$openCount = $this->general_model->getCount('trn_day_open_close', $whereCheckOpen);

		if($openCount > 0){
    	// Check Whether Day is already closed or not
    	$whereCheckClose = array(
	    	'salesman'	=> $salesmanID,
	    	'date'			=> date('Y-m-d', $transactionDate),
	    	'status'		=> 2
	    );
			$closeCount = $this->general_model->getCount('trn_day_open_close', $whereCheckClose);

	    if($closeCount > 0){
	    	$obj['status'] = 0;
      	$obj['message'] = 'You cannot create new transaction as the day is already closed.';
	    }else{
				$obj['status'] = 1;
	      $obj['message'] = 'Sucess'; 
	    }
    }else{
    	$obj['status'] = 0;
      $obj['message'] = 'You cannot create new transaction as the day is not opened yet.';
		}

		echo json_encode($obj);
	}

	// 05. Customers List
	public function customers(){
		$obj = array();
		$where = array();
		$customers = $this->general_model->get('mst_customers',$where);

		if(is_array($customers)){
			$i=0;
			foreach($customers as $customer){
				$obj['results'][$i]['customerID'] = $customer['client_id'];
				$obj['results'][$i]['customerName'] = $customer['client_name'];
				$obj['results'][$i]['is_credit'] = $customer['is_credit'];
				$obj['results'][$i]['is_taxable'] = $customer['is_taxable'];
				$i++;
			}
			$obj['status'] = 1;
      $obj['message'] = "Sucess";
		}else{
			$obj['status'] = 0;
      $obj['message'] = "No purchase orders";
    }
    echo json_encode($obj);
	}

	// 06. Customer Outstanding Amount
	public function customerOutstanding(){
		$obj = array();
		$client_id = $_POST['customerID'];
		$where = array(
			'client_id'		=> $client_id
		);
		$whereInvoiceAmount = array('status' => 5);
		$OutstandingAmount = $this->general_model->getSum('bill_os_amt','trn_customer_outstandings',$where);
		$OutstandingtotalAmount = $this->general_model->getSum('totalAmount','trn_sales_invoice',$whereInvoiceAmount);
		$outStandingBills = $this->general_model->getCount('trn_customer_outstandings',$where);

		$whereCustomer = array('client_id'	=> $client_id);
		$customerDetails = $this->general_model->get('mst_customers',$whereCustomer);

		if(is_array($OutstandingtotalAmount)){
			$obj['customerBalance'] = $OutstandingAmount[0]['bill_os_amt'] + $OutstandingtotalAmount[0]['totalAmount'];
		}else{
			$obj['customerBalance'] = $OutstandingAmount[0]['bill_os_amt'];
		}

		$whereOverDue = array(
			'client_id'															=> $client_id,
			'DATEDIFF(CURRENT_DATE(), bill_date) >'	=> $customerDetails[0]['creditPeriod']
		);
		$overDueAmount = $this->general_model->getSum('bill_os_amt','trn_customer_outstandings',$whereOverDue);
		$overDueBillCount = $this->general_model->getCount('trn_customer_outstandings',$whereOverDue);

		$obj['overdueamount'] = $overDueAmount[0]['bill_os_amt'];
		$obj['overDueBillCount'] = $overDueBillCount;
		$obj['outStandingBills'] = $outStandingBills;
		$obj['is_credit'] = $customerDetails[0]['is_credit'];
		$obj['creditLimit'] = $customerDetails[0]['creditLimit'];
		$obj['is_taxable'] = $customerDetails[0]['is_taxable'];
		$saleFlag = 1;
		if($customerDetails[0]['is_credit'] == 1){ // If Credit Sale Enabled
			if($customerDetails[0]['blockon_creditlimit'] == 1){ // If Block on Credit Limit
				if($overDueAmount[0]['bill_os_amt'] > $customerDetails[0]['creditLimit']){ // If Credit Limit over
					$saleFlag = 0;
				}

				if($obj['customerBalance'] > $customerDetails[0]['creditLimit']){
					$saleFlag = 0;
				}
			}

			if($customerDetails[0]['blockon_overdue'] == 1){ // If Block on Overdue
				if($overDueBillCount > 0){ // If overdue bills
					$saleFlag = 0;
				}
			}


		}

		if($saleFlag == 1){
			$obj['allowSale'] = 1;
		}else{
			$obj['allowSale'] = 0;
		}
		
		$obj['status'] = 1;
    $obj['message'] = "Sucess";
    echo json_encode($obj);
	}

	// 07. Item List For Sales Invoice
	public function products(){
		$obj = array();
		$salesmanID = $_POST['salesmanID'];
		$customerID = $_POST['customerID'];
		$where = array('mst_godown.salesman' => $salesmanID);
		$products = $this->general_model->get_sm_products($where);
		//print_r($products);exit;
		$whereCustomer = array('client_id'	=> $customerID);
		$clients = $this->general_model->get('mst_customers', $whereCustomer);
		$priceType = $clients[0]['priceType'];

		if(is_array($products)){
			$i=0;
			foreach($products as $product){
				$obj['results'][$i]['productID'] = $product['item_id'];
				$obj['results'][$i]['productDetailsID'] = $product['item_details_id'];
				$obj['results'][$i]['productCode'] = $product['item_code'];
				$obj['results'][$i]['productName'] = $product['item_description'];
				$obj['results'][$i]['productTax'] = $product['productTax'];
				$obj['results'][$i]['rateInclVatFlag'] = $product['isRateInclVat'];

				if($priceType != 0){
					if($priceType == 1){
						if($product['item_price1'] != "0.000"){
							$obj['results'][$i]['productPrice'] = $product['item_price1'];
							$obj['results'][$i]['productPriceFlag'] = 0;
						}else{
							$obj['results'][$i]['productPrice'] = '';
							$obj['results'][$i]['productPriceFlag'] = 1;
						}
					}else if($priceType == 2){
						if($product['item_price2'] != "0.000"){
							$obj['results'][$i]['productPrice'] = $product['item_price2'];
							$obj['results'][$i]['productPriceFlag'] = 0;
						}else{
							$obj['results'][$i]['productPrice'] = '';
							$obj['results'][$i]['productPriceFlag'] = 1;
						}
					}else if($priceType == 3){
						if($product['item_price3'] != "0.000"){
							$obj['results'][$i]['productPrice'] = $product['item_price3'];
							$obj['results'][$i]['productPriceFlag'] = 0;
						}else{
							$obj['results'][$i]['productPrice'] = '';
							$obj['results'][$i]['productPriceFlag'] = 1;
						}
					}
				}else{
					if($product['item_price1'] != "0.000"){
						$obj['results'][$i]['productPrice'] = $product['item_price1'];
						$obj['results'][$i]['productPriceFlag'] = 1;
					}else{
						$obj['results'][$i]['productPrice'] = '';
						$obj['results'][$i]['productPriceFlag'] = 1;
					}
				}
				$obj['results'][$i]['productMinPrice'] = $product['item_min_price'];
				$obj['results'][$i]['productMaxDiscountPer'] = $product['item_max_discount_per'];
				$i++;
			}
			$obj['status'] = 1;
      $obj['message'] = "Sucess";
		}else{
			$obj['status'] = 0;
      $obj['message'] = "No products";
    }
    echo json_encode($obj);
	}

	// 07A. Item List For Sales Order
	public function allproducts(){
		$obj = array();
		$salesmanID = $_POST['salesmanID'];
		$customerID = $_POST['customerID'];
		$where = array();
		$products = $this->general_model->get_products($where);
		//print_r($products);exit;
		$whereCustomer = array('client_id'	=> $customerID);
		$clients = $this->general_model->get('mst_customers', $whereCustomer);
		$priceType = $clients[0]['priceType'];

		if(is_array($products)){
			$i=0;
			foreach($products as $product){
				$obj['results'][$i]['productID'] = $product['item_id'];
				$obj['results'][$i]['productDetailsID'] = $product['item_details_id'];
				$obj['results'][$i]['productCode'] = $product['item_code'];
				$obj['results'][$i]['productName'] = $product['item_name'];
				$obj['results'][$i]['productTax'] = $product['productTax'];
				$obj['results'][$i]['rateInclVatFlag'] = $product['isRateInclVat'];

				if($priceType != 0){
					if($priceType == 1){
						if($product['item_price1'] != "0.000"){
							$obj['results'][$i]['productPrice'] = $product['item_price1'];
							$obj['results'][$i]['productPriceFlag'] = 0;
						}else{
							$obj['results'][$i]['productPrice'] = '';
							$obj['results'][$i]['productPriceFlag'] = 1;
						}
					}else if($priceType == 2){
						if($product['item_price2'] != "0.000"){
							$obj['results'][$i]['productPrice'] = $product['item_price2'];
							$obj['results'][$i]['productPriceFlag'] = 0;
						}else{
							$obj['results'][$i]['productPrice'] = '';
							$obj['results'][$i]['productPriceFlag'] = 1;
						}
					}else if($priceType == 3){
						if($product['item_price3'] != "0.000"){
							$obj['results'][$i]['productPrice'] = $product['item_price3'];
							$obj['results'][$i]['productPriceFlag'] = 0;
						}else{
							$obj['results'][$i]['productPrice'] = '';
							$obj['results'][$i]['productPriceFlag'] = 1;
						}
					}
				}else{
					if($product['item_price1'] != "0.000"){
						$obj['results'][$i]['productPrice'] = $product['item_price1'];
						$obj['results'][$i]['productPriceFlag'] = 1;
					}else{
						$obj['results'][$i]['productPrice'] = '';
						$obj['results'][$i]['productPriceFlag'] = 1;
					}
				}
				
				$obj['results'][$i]['productMinPrice'] = $product['item_min_price'];
				$obj['results'][$i]['productMaxDiscountPer'] = $product['item_max_discount_per'];
				$i++;
			}
			$obj['status'] = 1;
      $obj['message'] = "Sucess";
		}else{
			$obj['status'] = 0;
      $obj['message'] = "No products";
    }
    echo json_encode($obj);
	}

	// 08. Tax List
	public function tax(){
		$obj = array();
		$where = array();
		$taxes = $this->general_model->get('sys_tax',$where);

		if(is_array($taxes)){
			$i=0;
			foreach($taxes as $tax){
				$obj['results'][$i]['taxID'] = $tax['taxID'];
				$obj['results'][$i]['taxName'] = $tax['taxName'];
				$obj['results'][$i]['taxPercentage'] = $tax['taxPercentage'];
				$i++;
			}
			$obj['status'] = 1;
      $obj['message'] = "Sucess";
		}else{
			$obj['status'] = 0;
      $obj['message'] = "No taxes";
    }
    echo json_encode($obj);
	}

	public function test(){
		$items[0]['itemDetailID'] = 1;
		$items[0]['itemPrice'] = 2.500;
		$items[0]['itemQty'] = 10;
		$items[0]['itemDiscountPer'] = 10.00;
		$items[0]['itemDiscountAmount'] = 2.500;
		$items[0]['itemTotalDiscountSplitAmount'] = 0.500;
		$items[0]['itemTax'] = 2;
		$items[0]['itemTaxAmount'] = 1.125;
		$items[0]['itemTotal'] = 23.625;
		$items[1]['itemDetailID'] = 2;
		$items[1]['itemPrice'] = 1.000;
		$items[1]['itemQty'] = 10;
		$items[1]['itemDiscountPer'] = 10.00;
		$items[1]['itemDiscountAmount'] = 1.000;
		$items[1]['itemTotalDiscountSplitAmount'] = 0.500;
		$items[1]['itemTax'] = 2;
		$items[1]['itemTaxAmount'] = 0.425;
		$items[1]['itemTotal'] = 8.925;

		$salesOrder['salesOrderDate'] = "2021-02-14";
		$salesOrder['customer'] = 1;
		$salesOrder['subTotal'] = 35.00;
		$salesOrder['taxAmount'] = 1.550;
		$salesOrder['discountAmout'] = 4.500;
		$salesOrder['totalAmount'] = 32.550;
		$salesOrder['salesman'] = 3;
		$salesOrder['paymentMode'] = 1;
		$salesOrder['cashAmountReceived'] = 35.000;
		$salesOrder['cashAmountBalance'] = 2.450;
		$salesOrder['cardNumber'] = '';
		$salesOrder['chequeNumber'] = '';
		$salesOrder['paymentStatus'] = 1;
		$salesOrder['items'] = json_encode($items);

		echo json_encode($salesOrder);
	}

	// 09. Create Sales Order
	public function createSalesOrder(){
		$obj = array();
		// $customer = $_POST['customer'];
		// $subTotal = $_POST['subTotal'];
		// $taxAmount = $_POST['taxAmount'];
		// $discountAmout = $_POST['discountAmout'];
		// $totalAmount = $_POST['totalAmount'];
		// $salesman = $_POST['salesman'];
		// $itemsJson = $_POST['items'];
		// $items = json_decode($itemsJson);

		//JSON Processing
		$salesOrderJson = $_POST['salesOrder'];
		$salesOrder = json_decode($salesOrderJson,true);
		$salesOrderDate = $salesOrder['salesOrderDate'];
		$customer = $salesOrder['customer'];
		$subTotal = $salesOrder['subTotal'];
		$taxAmount = $salesOrder['taxAmount'];
		$discountAmout = $salesOrder['discountAmout'];
		$totalAmount = $salesOrder['totalAmount'];
		$salesman = $salesOrder['salesman'];
		$itemsJson = $salesOrder['items'];
		$items = json_decode($itemsJson);


		$salesOrderNumber = $this->general_model->getmax('salesOrderNumber','trn_sales_orders');

		$data = array(
			'salesOrderNumber'	=> $salesOrderNumber,
			'salesOrderDate'		=> $salesOrderDate,
			'customer'					=> $customer,
			'subTotal'					=> $subTotal,
			'taxAmount'					=> $taxAmount,
			'discountAmout'			=> $discountAmout,
			'totalAmount'				=> $totalAmount,
			'salesman'					=> $salesman,
			'status'						=> 1,
		);

		$salesOrderID = $this->general_model->insert('trn_sales_orders', $data);

		if(isset($items) && is_array($items)){
			foreach($items as $item){
				$itemDetailID = $item->itemDetailID;
				$itemPrice = $item->itemPrice;
				$itemQty = $item->itemQty;
				$itemDiscountPer = $item->itemDiscountPer;
				$itemDiscountAmount = $item->itemDiscountAmount;
				$itemTotalDiscountSplitAmount = $item->itemTotalDiscountSplitAmount;
				$itemTax = $item->itemTax;
				$itemTaxAmount = $item->itemTaxAmount;
				$itemTotal = $item->itemTotal;

				$dataDetails = array(
					'salesOrder'									=> $salesOrderID,
					'itemDetailID'									=> $itemDetailID,
					'itemPrice'											=> $itemPrice,
					'itemQty'												=> $itemQty,
					'itemDiscountPer'								=> $itemDiscountPer,
					'itemDiscountAmount'						=> $itemDiscountAmount,
					'itemDiscountAmount'						=> $itemDiscountAmount,
					'itemTotalDiscountSplitAmount'	=> $itemTotalDiscountSplitAmount,
					'itemTax'												=> $itemTax,
					'itemTaxAmount'									=> $itemTaxAmount,
					'itemTotal'											=> $itemTotal
				);

				$this->general_model->insert('trn_sales_order_details', $dataDetails);
			}

			$obj['salesOrderID'] = $salesOrderID;
			$obj['salesOrderNumber'] = $salesOrderNumber;
			$obj['subTotal'] = $subTotal;
			$obj['taxAmount'] = $taxAmount;
			$obj['discountAmout'] = $discountAmout;
			$obj['totalAmount'] = $totalAmount;
			$obj['status'] = 1;
	    $obj['message'] = "";

	    echo json_encode($obj);
		}
	}

	// 10. Create Sales Invoice
	public function createSalesInvoice(){
		$obj = array();

		//JSON Processing
		$salesOrderJson = $_POST['salesOrder'];
		$salesOrder = json_decode($salesOrderJson,true);
		$salesOrderDate = $salesOrder['salesOrderDate'];
		$customer = $salesOrder['customer'];
		$subTotal = $salesOrder['subTotal'];
		$taxAmount = $salesOrder['taxAmount'];
		$discountAmout = $salesOrder['discountAmout'];
		$totalAmount = $salesOrder['totalAmount'];
		$salesman = $salesOrder['salesman'];
		$paymentMode = $salesOrder['paymentMode'];
		$cashAmountReceived = $salesOrder['cashAmountReceived'];
		$cashAmountBalance = $salesOrder['cashAmountBalance'];
		$cardNumber = $salesOrder['cardNumber'];
		$chequeNumber = $salesOrder['chequeNumber'];
		$paymentStatus = $salesOrder['paymentStatus'];
		$itemsJson = $salesOrder['items'];
		$items = json_decode($itemsJson);


		$salesInvoiceNumer = $this->general_model->getmax('salesInvoiceNumer','trn_sales_invoice');

		$data = array(
			'salesInvoiceNumer'		=> $salesInvoiceNumer,
			'salesInvoiceDate'		=> $salesOrderDate,
			'customer'						=> $customer,
			'subTotal'						=> $subTotal,
			'taxAmount'						=> $taxAmount,
			'discountAmout'				=> $discountAmout,
			'totalAmount'					=> $totalAmount,
			'salesman'						=> $salesman,
			'paymentMode'					=> $paymentMode,
			'cashAmountReceived'	=> $cashAmountReceived,
			'cashAmountBalance'		=> $cashAmountBalance,
			'cardNumber'					=> $cardNumber,
			'chequeNumber'				=> $chequeNumber,
			'paymentStatus'				=> $paymentStatus,
			'status'							=> 1,
		);

		$salesInvoiceID = $this->general_model->insert('trn_sales_invoice', $data);

		$whereClient = array('client_id'	=> $customer);
		$customers = $this->general_model->get('mst_customers', $whereClient);

		// $dataOS = array(
		// 	'client_id'		=> $customer,
		// 	'Client_name'	=> $customers[0]['client_name'],
		// 	'bill_no'			=> $salesInvoiceNumer,
		// 	'bill_date'		=> $salesOrderDate,
		// 	'bill_amount'	=> $totalAmount,
		// 	'bill_os_amt'	=> $cashAmountBalance
		// );

		// $this->general_model->insert('trn_customer_outstandings', $dataOS);

		if(isset($items) && is_array($items)){
			foreach($items as $item){
				$itemDetailID = $item->itemDetailID;
				$itemPrice = $item->itemPrice;
				$itemQty = $item->itemQty;
				$itemDiscountPer = $item->itemDiscountPer;
				$itemDiscountAmount = $item->itemDiscountAmount;
				$itemTotalDiscountSplitAmount = $item->itemTotalDiscountSplitAmount;
				$itemTax = $item->itemTax;
				$itemTaxAmount = $item->itemTaxAmount;
				$itemTotal = $item->itemTotal;

				$dataDetails = array(
					'salesInvoice'									=> $salesInvoiceID,
					'itemDetailID'									=> $itemDetailID,
					'itemPrice'											=> $itemPrice,
					'itemQty'												=> $itemQty,
					'itemDiscountPer'								=> $itemDiscountPer,
					'itemDiscountAmount'						=> $itemDiscountAmount,
					'itemDiscountAmount'						=> $itemDiscountAmount,
					'itemTotalDiscountSplitAmount'	=> $itemTotalDiscountSplitAmount,
					'itemTax'												=> $itemTax,
					'itemTaxAmount'									=> $itemTaxAmount,
					'itemTotal'											=> $itemTotal
				);

				$this->general_model->insert('trn_sales_invoice_details', $dataDetails);
			}

			
		}

		$obj['salesInvoiceID'] = $salesInvoiceID;
		$obj['salesInvoiceNumer'] = $salesInvoiceNumer;
		$obj['subTotal'] = $subTotal;
		$obj['taxAmount'] = $taxAmount;
		$obj['discountAmout'] = $discountAmout;
		$obj['totalAmount'] = $totalAmount;
		$obj['status'] = 1;
    $obj['message'] = "";

    echo json_encode($obj);
	}

	// 11. Sales List
	public function salesList(){
		$obj = array();
		$salesmanID = $_POST['salesmanID'];
		$where = array(
			'salesman'		=> $salesmanID
		);

		$invoices =  $this->general_model->get_invoices($where);
		if(is_array($invoices)){
			$i=0;
			foreach($invoices as $invoice){
				$obj['results'][$i]['salesInvoiceNumer'] = $invoice['salesInvoiceNumer'];
				$obj['results'][$i]['salesInvoiceDate'] = date('d/m/Y',strtotime($invoice['salesInvoiceDate']));
				$obj['results'][$i]['totalAmount'] = $invoice['totalAmount'];
				$obj['results'][$i]['customerName'] = $invoice['client_name'];
				$obj['results'][$i]['dueDays'] = $invoice['creditPeriod'];

				$i++;
			}
			$obj['status'] = 1;
      $obj['message'] = "Sucess";
		}else{
			$obj['status'] = 0;
      $obj['message'] = "No invoices found";
		}
		echo json_encode($obj);
	}

	// 12. Sale Report
	public function saleReport(){
		$obj = array();
		$salesmanID = $_POST['salesmanID'];
		$where = array(
			'salesman'		=> $salesmanID
		);

		$invoices =  $this->general_model->get_invoices($where);
		if(is_array($invoices)){
			$i=0;
			foreach($invoices as $invoice){
				$obj['results'][$i]['salesInvoiceNumer'] = $invoice['salesInvoiceNumer'];
				$obj['results'][$i]['salesInvoiceDate'] = date('d/m/Y',strtotime($invoice['salesInvoiceDate']));
				$obj['results'][$i]['totalAmount'] = $invoice['totalAmount'];
				$obj['results'][$i]['customerName'] = $invoice['client_name'];
				$obj['results'][$i]['dueDays'] = $invoice['creditPeriod'];

				$i++;
			}
			$obj['status'] = 1;
      $obj['message'] = "Sucess";
		}else{
			$obj['status'] = 0;
      $obj['message'] = "No invoices found";
		}
		echo json_encode($obj);
	}

	// 13. App Settings
	public function appSettings(){
		$obj = array();
		//$appID = $_POST['appID'];
		$salesmanID = $_POST['salesmanID'];

		$whereCheck = array(
    	'salesman'	=> $salesmanID,
    	'status'		=> 1
    );

    $checkCount = $this->general_model->getCount('trn_day_open_close', $whereCheck);
    if($checkCount > 0){
    	$openedDays = $this->general_model->get('trn_day_open_close', $whereCheck);
    	$obj['openedDate'] = $openedDays[0]['date'];
    }

		$obj['appStatus'] = 1;
		$obj['offlineDBFlag'] = 1;

		$obj['status'] = 1;
    $obj['message'] = "Sucess";
    echo json_encode($obj);
	}

	

	


}