<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Welcome extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */

	function __construct() {
		parent::__construct();

		$this->load->model('general_model');
		$this->load->library('form_validation');
		$this->load->library('session');
		$this->load->helper("url");
		//$this->load->library('encrypt');
		$this->load->library('pagination');
		$this->load->helper('date');
		
	}

	public function index()
	{
		redirect(base_url().'index.php/welcome/login');
	}

	public function login(){

		$data['loginRedirect']=base_url().'index.php/welcome/checklogin';

		$data['pageTitle'] = "Login | ".HEX_APPLICATION_NAME;

		$this->load->view('login/login',$data);
	}

	public function checklogin(){
		$this->form_validation->set_rules('login', 'Username', 'required');
		$this->form_validation->set_rules('password', 'Password', 'required|min_length[6]|max_length[14]');
		
		if ($this->form_validation->run() == FALSE) {	
			//var_dump(validation_errors());
			$this->session->set_flashdata('registerMessage',validation_errors(),':old:');
			$data['loginRedirect']=base_url().'welcome/checklogin';
			
			redirect(base_url().'index.php/welcome/login');
		}else{
			$userName=$this->input->post('login');
			$userPassword=$this->input->post('password');
			$user_record =$this->general_model->check_admin_login($userName,$userPassword);
			if($user_record == false){
				// throw invalid email id or password error
				$this->session->set_flashdata('registerMessage','Invalid Login or Password',':old:');
				redirect(base_url().'index.php/welcome/login');
			}else{
				if($user_record['userType'] == 1 ){
					$admindata = array(
						'logged_in'					=> true,
						'admin_logged_in' 	=> true,
						'userId' 						=> $user_record['userID'],
						'userName'		    	=> $user_record['userName'],
						'userFullName'		  => $user_record['userName'],
					);

					$this->session->set_userdata('adminAccess',1);
					$this->session->set_userdata($admindata);

					//Set User Permissions

					redirect(base_url().'index.php/admin/dashboard');
				}
				
			}
		}
	}

	public function logout() {		
		$this->session->sess_destroy();
		session_start();
		session_destroy();
		redirect(base_url());
		
	}
}
