<?php
	if(isset($_SESSION['admin_logged_in'])|| in_array("UserCreate",$_SESSION['assignedPermissions'])){
?>
<div class="row">
	<div class="col-md-12 col-lg-12">
		<div class="card">
			<div class="card-header">
				<h3 class="card-title"><?php echo "Add New ".$pageHeading;?></h3>
			</div>
			<div class="card-body">
				<?php 
          $attributes = array('class' => 'form form-horizontal form-bordered', 'id' => 'form');
          echo form_open_multipart($loginRedirect,$attributes);
        ?>
				<div class="row">
					<div class="col-md-4">
						<div class="form-group">
							<label class="form-label">Full Name</label>
							<input type="text" class="form-control" name="userFullName" placeholder="Full Name">
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<label class="form-label">Contact Number</label>
							<input type="text" class="form-control" name="userContactNumber" placeholder="Contact Number">
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<label class="form-label">Email Address</label>
							<input type="text" class="form-control" name="userEmail" placeholder="Email Address">
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<label class="form-label">Username</label>
							<input type="text" class="form-control" name="username" placeholder="Username">
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<label class="form-label">Password</label>
							<input type="password" class="form-control" name="userPassword" pattern=".{0}|.{6,}" placeholder="Password" title="6 chars minimum" required>
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<label class="form-label">Departments</label>
							<?php 
                $designationsOptionsJs = 'id="userDepartments" class="form-control  userDepartments"';
                echo form_multiselect('userDepartments[]', $departments, '',$designationsOptionsJs);
              ?>
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<div class="col-md-8">
								<label class="form-label">Is Approver User?</label>
							</div>
							<div class="col-md-2">
								<input type="checkbox" class="form-control" name="isApprover" value="1"> 
							</div>
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<div class="form-label"></div>
							<input type="submit" class="btn btn-primary" name="" value="Submit">
						</div>
					</div>
				</div>
				<?php echo form_close();?>
				<?php if($this->session->flashdata('registerMessage')){ ?>
          <div class="alert alert-warning ">
            <a class="panel-close close " data-dismiss="alert">×</a> 
            <i class="fa fa-coffe"></i>
            <?php echo $this->session->flashdata('registerMessage');?>
          </div>
        <?php } ?>
			</div>
		</div>
	</div>
</div>
<?php
	}
?>
<!-- ROW-1 : Add New Items -->
<div class="row">
	<div class="col-md-12 col-lg-12">
		<div class="card">
			<div class="card-header">
				<h3 class="card-title"><?php echo $pageHeading;?></h3>
			</div>
			<div class="card-body">
				<div class="table-responsive">
					<table id="example" class="table table-striped table-bordered text-nowrap w-100">
						<thead>
							<tr>
								<th class="wd-15p">Full Name</th>
								<th class="wd-15p">Contact Number</th>
								<th class="wd-20p">Email</th>
								<th class="wd-15p">Departments</th>
								<th class="wd-10p">Status</th>
								<?php 
									if(isset($_SESSION['admin_logged_in'])|| in_array("UserEdit",$_SESSION['assignedPermissions'])){
								?>
									<th class="wd-25p">Actions</th>
								<?php } ?>
							</tr>
						</thead>
						<tbody>
							<?php
								if(is_array($users)){
									foreach($users as $user){
							?>
										<tr>
											<td><?php echo $user['userFullName'];?></td>
											<td><?php echo $user['userContactNumber'];?></td>
											<td><?php echo $user['userEmail'];?></td>
											<td><?php echo $user['deptList'];?></td>
											<td>
												<?php 
													if($user['isActive'] == 1){
														echo "Active";
													}else{
														echo "Inactive";
													}
												?>
											</td>
											<?php 
												if(isset($_SESSION['admin_logged_in'])|| in_array("UserEdit",$_SESSION['assignedPermissions'])){
											?>
											<td>
												<?php 
													if($user['isActive'] == 1){
												?>
														<a class="btn" href="<?php echo base_url()?>index.php/masters/users/makeInactive/<?php echo $user['userID'];?>">
															<i class="icon icon-control-pause" data-toggle="tooltip" title="Make Inactive"></i>
														</a>
												<?php
													}else{
												?>
														<a class="btn" href="<?php echo base_url()?>index.php/masters/users/makeActive/<?php echo $user['userID'];?>">
															<i class="icon icon-control-play" data-toggle="tooltip" title="Make Active"></i>
														</a>
												<?php
													}
												?>
												<a class="btn" href="<?php echo base_url()?>index.php/masters/users/permissions/<?php echo $user['userID'];?>">
													<i class="icon icon-settings" data-toggle="tooltip" title="Permissions"></i>
												</a>
												<a class="btn" href="<?php echo base_url()?>index.php/masters/users/edit/<?php echo $user['userID'];?>">
													<i class="icon icon-note" data-toggle="tooltip" title="Edit"></i>
												</a>
												<a class="btn" href="<?php echo base_url()?>index.php/masters/users/delete/<?php echo $user['userID'];?>">
													<i class="icon icon-trash" data-toggle="tooltip" title="Delete"></i>
												</a>
											</td>
											<?php }?>
										</tr>
							<?php
									}
								}
							?>
						</tbody>
					</table>
				</div>
				<!-- table-responsive -->
			</div>
		</div>
	</div>
</div>
